/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.async;

import com.baidu.navisdk.ui.widget.recyclerview.async.AsyncLoader;
import com.baidu.navisdk.ui.widget.recyclerview.async.AsyncPageLoader;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.Card;
import com.baidu.navisdk.ui.widget.recyclerview.structure.BaseCell;
import java.util.List;

public class CardLoadSupport {
    private static int sInitialPage = 1;
    private AsyncPageLoader mAsyncPageLoader;
    private AsyncLoader mAsyncLoader;

    public static void setInitialPage(int n2) {
        sInitialPage = n2;
    }

    public CardLoadSupport() {
    }

    public CardLoadSupport(AsyncLoader asyncLoader) {
        this(asyncLoader, null);
    }

    public CardLoadSupport(AsyncPageLoader asyncPageLoader) {
        this(null, asyncPageLoader);
    }

    public CardLoadSupport(AsyncLoader asyncLoader, AsyncPageLoader asyncPageLoader) {
        this.mAsyncLoader = asyncLoader;
        this.mAsyncPageLoader = asyncPageLoader;
    }

    public void replaceLoader(AsyncLoader asyncLoader) {
        this.mAsyncLoader = asyncLoader;
    }

    public void replaceLoader(AsyncPageLoader asyncPageLoader) {
        this.mAsyncPageLoader = asyncPageLoader;
    }

    public void replaceLoader(AsyncLoader asyncLoader, AsyncPageLoader asyncPageLoader) {
        CardLoadSupport cardLoadSupport = this;
        cardLoadSupport.mAsyncLoader = asyncLoader;
        cardLoadSupport.mAsyncPageLoader = asyncPageLoader;
    }

    public void doLoad(final Card card) {
        Object object = this.mAsyncLoader;
        if (object == null) {
            return;
        }
        if (!card.loading && !card.loaded) {
            AsyncLoader.LoadedCallback loadedCallback;
            AsyncLoader asyncLoader = object;
            card.loading = true;
            object = loadedCallback;
            loadedCallback = new AsyncLoader.LoadedCallback(){

                @Override
                public void finish() {
                    Card card2 = card;
                    card2.loading = false;
                    card2.loaded = true;
                }

                @Override
                public void finish(List<BaseCell> list) {
                    1 v02 = this;
                    v02.finish();
                    v02.card.addCells(list);
                    v02.card.notifyDataChange();
                }

                @Override
                public void fail(boolean bl) {
                    Card card2 = card;
                    card2.loading = false;
                    card2.loaded = bl;
                }
            };
            asyncLoader.loadData(card, (AsyncLoader.LoadedCallback)object);
        }
    }

    public void loadMore(final Card card) {
        if (this.mAsyncPageLoader == null) {
            return;
        }
        if (!card.loading && card.loadMore && card.hasMore) {
            AsyncPageLoader.LoadedCallback loadedCallback;
            card.loading = true;
            if (!card.loaded) {
                card.page = sInitialPage;
            }
            AsyncPageLoader.LoadedCallback loadedCallback2 = loadedCallback;
            loadedCallback = new AsyncPageLoader.LoadedCallback(){

                @Override
                public void finish(boolean bl) {
                    card.loaded = true;
                    card.loading = false;
                    ++card.page;
                    card.hasMore = bl;
                }

                @Override
                public void finish(List<BaseCell> list, boolean bl) {
                    if (card.page == sInitialPage) {
                        card.setCells(list);
                    } else {
                        card.addCells(list);
                    }
                    2 v02 = this;
                    v02.finish(bl);
                    v02.card.notifyDataChange();
                }

                @Override
                public void fail(boolean bl) {
                    Card card2 = card;
                    card2.loaded = true;
                    card2.loading = false;
                    card2.hasMore = bl;
                }
            };
            this.mAsyncPageLoader.loadData(card.page, card, loadedCallback2);
        }
    }
}

