/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.banner;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.widget.recyclerview.banner.CommonBannerConfig;
import com.baidu.navisdk.ui.widget.recyclerview.banner.CommonBannerViewPager;
import com.baidu.navisdk.ui.widget.recyclerview.util.Utils;
import com.baidu.navisdk.ui.widget.recyclerview.view.TimerHandler;
import com.baidu.navisdk.util.common.LogUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class CommonBannerView
extends ViewGroup
implements ViewPager.OnPageChangeListener,
TimerHandler.TimerHandlerListener {
    private static final String CURRENT_POS = "__current_pos__";
    public static final int GRAVITY_LEFT = 0;
    public static final int GRAVITY_CENTER = 1;
    public static final int GRAVITY_RIGHT = 2;
    private static Constructor imageViewConstructor;
    public static Class<? extends ImageView> sImageClass;
    private boolean isIndicatorOutside;
    private CommonBannerViewPager mViewPager;
    private CommonBannerIndicator mIndicator;
    private int mIndicatorHeight;
    private int mIndicatorGap;
    private int mIndicatorMargin;
    private float xDown;
    private float yDown;
    private float ratio;
    private boolean init;
    private int height;
    private CommonBannerConfig config;
    private BannerSupportV2 bannerSupport;
    private int currentItemPos;
    private int direction;
    private TimerHandler timer;
    private ScreenBroadcastReceiver mScreenBroadcastReceiver;
    private final IntentFilter filter;

    public CommonBannerView(Context context) {
        CommonBannerView commonBannerView = this;
        commonBannerView(context, null);
        commonBannerView.init();
    }

    public CommonBannerView(Context context, AttributeSet attributeSet) {
        CommonBannerView commonBannerView = this;
        commonBannerView(context, attributeSet, 0);
        commonBannerView.init();
    }

    public CommonBannerView(Context context, AttributeSet attributeSet, int n2) {
        IntentFilter intentFilter;
        CommonBannerView commonBannerView = commonBannerView2;
        super(context, attributeSet, n2);
        commonBannerView.mIndicatorHeight = -2;
        commonBannerView.mIndicatorGap = 12;
        commonBannerView.mIndicatorMargin = 20;
        commonBannerView.ratio = Float.NaN;
        commonBannerView.height = -2;
        CommonBannerView commonBannerView2 = intentFilter;
        intentFilter = new IntentFilter();
        commonBannerView.filter = commonBannerView2;
        commonBannerView.init();
    }

    private void init() {
        CommonBannerView commonBannerView = this;
        this.mViewPager = new CommonBannerViewPager(this.getContext());
        this.mViewPager.setId(R.id.RECYCLER_BANNER_ID);
        CommonBannerView commonBannerView2 = this;
        commonBannerView.mIndicator = commonBannerView2.new CommonBannerIndicator(commonBannerView2.getContext());
        commonBannerView.addView((View)commonBannerView.mViewPager);
        commonBannerView.addView((View)commonBannerView.mIndicator);
        commonBannerView.mIndicator.setPadding(this.mIndicatorGap, 0, 0, 0);
        commonBannerView.mScreenBroadcastReceiver = new ScreenBroadcastReceiver(this);
        commonBannerView.filter.addAction("android.intent.action.SCREEN_ON");
        commonBannerView.filter.addAction("android.intent.action.SCREEN_OFF");
        commonBannerView.filter.addAction("android.intent.action.USER_PRESENT");
    }

    private int getIndicatorGravity(String string2) {
        if ("left".equals(string2)) {
            return 0;
        }
        if ("right".equals(string2)) {
            return 2;
        }
        return 1;
    }

    private void startTimer() {
        TimerHandler timerHandler = this.timer;
        if (timerHandler != null && this.mViewPager != null && timerHandler.isStopped()) {
            CommonBannerView commonBannerView = this;
            commonBannerView.timer.setListener(this);
            commonBannerView.timer.removeCallbacksAndMessages(null);
            commonBannerView.timer.tick(0);
            commonBannerView.timer.setStopped(false);
            return;
        }
    }

    private void stopTimer() {
        TimerHandler timerHandler = this.timer;
        if (timerHandler != null && this.mViewPager != null && !timerHandler.isStopped()) {
            CommonBannerView commonBannerView = this;
            commonBannerView.timer.removeCallbacksAndMessages(null);
            commonBannerView.timer.setListener(null);
            commonBannerView.timer.setStopped(true);
            return;
        }
    }

    private int getNextItemIndex() {
        return this.mViewPager.getNextItem();
    }

    private boolean scrollNextPage() {
        this.direction = 1;
        boolean bl = false;
        CommonBannerViewPager commonBannerViewPager = this.mViewPager;
        if (commonBannerViewPager != null && commonBannerViewPager.getAdapter() != null && this.mViewPager.getAdapter().getCount() > 0) {
            int n2 = this.mViewPager.getCurrentItemFake();
            int n3 = 0;
            if (n2 < this.mViewPager.getAdapter().getCount() - 1) {
                n3 = n2 + 1;
                bl = true;
            }
            this.mViewPager.setCurrentItemFake(n3, true);
        }
        return bl;
    }

    public static ImageView createImageInstance(Context context) {
        GenericDeclaration genericDeclaration = sImageClass;
        if (genericDeclaration != null) {
            if (imageViewConstructor == null) {
                Class<? extends ImageView> clazz = genericDeclaration;
                Class[] classArray = new Class[1];
                try {
                    classArray[0] = Context.class;
                    imageViewConstructor = clazz.getConstructor(classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    LogUtil.printException("create ImageView constructor exception!", noSuchMethodException);
                }
            }
            if ((genericDeclaration = imageViewConstructor) != null) {
                try {
                    return (ImageView)((Constructor)genericDeclaration).newInstance(context);
                }
                catch (InvocationTargetException invocationTargetException) {
                    LogUtil.printException("new ImageView instance InvocationTargetException!", invocationTargetException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    LogUtil.printException("new ImageView instance IllegalAccessException!", illegalAccessException);
                }
                catch (InstantiationException instantiationException) {
                    LogUtil.printException("new ImageView instance InstantiationException!", instantiationException);
                }
            }
        }
        return null;
    }

    static /* synthetic */ CommonBannerViewPager access$000(CommonBannerView commonBannerView) {
        return commonBannerView.mViewPager;
    }

    static /* synthetic */ int access$100(CommonBannerView commonBannerView) {
        return commonBannerView.mIndicatorHeight;
    }

    static /* synthetic */ int access$200(CommonBannerView commonBannerView) {
        return commonBannerView.mIndicatorMargin;
    }

    static /* synthetic */ int access$300(CommonBannerView commonBannerView) {
        return commonBannerView.mIndicatorGap;
    }

    static /* synthetic */ boolean access$400(CommonBannerView commonBannerView) {
        return commonBannerView.init;
    }

    static {
        sImageClass = ImageView.class;
    }

    public void setConfig(CommonBannerConfig commonBannerConfig) {
        this.config = commonBannerConfig;
        boolean bl = commonBannerConfig != null;
        this.init = bl;
        this.bindView(commonBannerConfig);
    }

    public void setAdapter(PagerAdapter pagerAdapter) {
        CommonBannerView commonBannerView = this;
        commonBannerView.mViewPager.setAdapter(pagerAdapter);
        commonBannerView.disableAutoScroll();
        commonBannerView.mViewPager.removeOnPageChangeListener(this);
        commonBannerView.mViewPager.addOnPageChangeListener(this);
    }

    public void updateIndicators(String string2, String string3, int n2, int n3, int n4) {
        Object object = object.mIndicator;
        if (object != null) {
            ((CommonBannerIndicator)((Object)object)).updateIndicators(string2, string3, n2, n3, n4);
        }
    }

    public void setIndicatorGravity(int n2) {
        Object object;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2 && (object = object.mIndicator) != null) {
                    object.setGravity(5);
                }
            } else {
                object = object.mIndicator;
                if (object != null) {
                    object.setGravity(1);
                }
            }
        } else {
            object = object.mIndicator;
            if (object != null) {
                object.setGravity(3);
            }
        }
    }

    public void setIndicatorPos(String string2) {
        this.isIndicatorOutside = "inside".equals(string2) ? false : "outside".equals(string2);
    }

    public void setIndicatorGap(int n2) {
        if (n2 >= 0) {
            this.mIndicatorGap = n2;
        }
    }

    public void setIndicatorMargin(int n2) {
        if (n2 > 0) {
            this.mIndicatorMargin = n2;
        }
    }

    public void setIndicatorHeight(int n2) {
        this.mIndicatorHeight = n2 > 0 ? n2 : -2;
    }

    public CommonBannerViewPager getViewPager() {
        return this.mViewPager;
    }

    public void onPageScrolled(int n2, float f3, int n3) {
        if (this.bannerSupport != null) {
            for (n2 = 0; n2 < this.bannerSupport.getListeners().size(); ++n2) {
                CommonBannerView commonBannerView = this;
                Object obj = commonBannerView.config.getDataList().get(this.currentItemPos);
                int n4 = commonBannerView.currentItemPos;
                int n5 = commonBannerView.direction;
                this.bannerSupport.getListeners().get(n2).onPageScrolled(obj, n4, f3, n3, n5);
            }
        }
    }

    public void onPageSelected(int n2) {
        CommonBannerView commonBannerView = this;
        commonBannerView.currentItemPos = n2 = commonBannerView.mViewPager.getCurrentItem();
        commonBannerView.mIndicator.setCurrItem(n2);
        CommonBannerConfig commonBannerConfig = commonBannerView.config;
        if (commonBannerConfig != null) {
            commonBannerConfig.putExtra(CURRENT_POS, this.currentItemPos);
        }
        if (this.bannerSupport != null && this.config != null) {
            for (int i3 = 0; i3 < this.bannerSupport.getListeners().size(); ++i3) {
                CommonBannerView commonBannerView2 = this;
                Object obj = commonBannerView2.config.getDataList().get(this.currentItemPos);
                this.bannerSupport.getListeners().get(i3).onPageSelected(obj, commonBannerView2.currentItemPos);
            }
        }
    }

    public void onPageScrollStateChanged(int n2) {
        if (this.bannerSupport != null) {
            for (int i3 = 0; i3 < this.bannerSupport.getListeners().size(); ++i3) {
                this.bannerSupport.getListeners().get(i3).onPageScrollStateChanged(this.config.getDataList().get(this.currentItemPos), n2);
            }
        }
    }

    public void registerPageChangeListener(BannerListenerV2 bannerListenerV2) {
        BannerSupportV2 bannerSupportV2 = ((CommonBannerView)((Object)bannerSupportV2)).bannerSupport;
        if (bannerSupportV2 != null && bannerListenerV2 != null) {
            bannerSupportV2.registerPageChangeListener(bannerListenerV2);
        }
    }

    public void unregisterPageChangeListener(BannerListenerV2 bannerListenerV2) {
        BannerSupportV2 bannerSupportV2 = ((CommonBannerView)((Object)bannerSupportV2)).bannerSupport;
        if (bannerSupportV2 != null && bannerListenerV2 != null) {
            bannerSupportV2.unregisterPageChangeListener(bannerListenerV2);
        }
    }

    public void clearPageChangeListeners() {
        BannerSupportV2 bannerSupportV2 = ((CommonBannerView)((Object)bannerSupportV2)).bannerSupport;
        if (bannerSupportV2 != null) {
            bannerSupportV2.destroy();
        }
    }

    public void bindView(CommonBannerConfig object) {
        int n2;
        int n3;
        int n4;
        if (object == null) {
            return;
        }
        this.bannerSupport = new BannerSupportV2();
        CommonBannerView commonBannerView = this;
        ScreenBroadcastReceiver screenBroadcastReceiver = commonBannerView.mScreenBroadcastReceiver;
        this.getContext().registerReceiver((BroadcastReceiver)screenBroadcastReceiver, commonBannerView.filter);
        if (((CommonBannerConfig)object).getStyle() != null) {
            CommonBannerConfig commonBannerConfig = object;
            int n5 = commonBannerConfig.getStyle().padding[0];
            n4 = commonBannerConfig.getStyle().padding[1];
            n3 = commonBannerConfig.getStyle().padding[2];
            this.setPadding(((CommonBannerConfig)object).getStyle().padding[3], n5, n4, n3);
        }
        if (((CommonBannerConfig)object).getBgColor() != Long.MIN_VALUE) {
            this.setBackgroundColor((int)((CommonBannerConfig)object).getBgColor());
        }
        CommonBannerView commonBannerView2 = this;
        CommonBannerConfig commonBannerConfig = object;
        CommonBannerView commonBannerView3 = this;
        commonBannerView3.setAdapter(((CommonBannerConfig)object).getBannerAdapter());
        commonBannerView3.mViewPager.setAutoMeasureHeight(true);
        this.ratio = ((CommonBannerConfig)object).getRatio();
        this.height = ((CommonBannerConfig)object).getHeight();
        this.mViewPager.setRatio(this.ratio);
        int n6 = commonBannerConfig.getAutoScrollInternal();
        commonBannerView2.setAutoScroll(n6, commonBannerConfig.getSpecialInterval());
        commonBannerView2.mViewPager.setPageMargin(((CommonBannerConfig)object).gethGap());
        if (((CommonBannerConfig)object).getDataList() != null && ((CommonBannerConfig)object).getDataList().size() > ((CommonBannerConfig)object).getInfiniteMinCount()) {
            this.setInfiniteLoop(((CommonBannerConfig)object).isInfinite());
        } else {
            this.setInfiniteLoop(false);
        }
        CommonBannerView commonBannerView4 = this;
        commonBannerView4.setIndicatorGravity(commonBannerView4.getIndicatorGravity(((CommonBannerConfig)object).getIndicatorGravity()));
        this.setIndicatorPos(((CommonBannerConfig)object).getIndicatorPos());
        n6 = ((CommonBannerConfig)object).getIndicatorGap();
        if (n6 <= 0) {
            n6 = this.mIndicatorGap;
        }
        this.setIndicatorGap(n6);
        n6 = ((CommonBannerConfig)object).getIndicatorMargin();
        if (n6 <= 0) {
            n6 = this.mIndicatorMargin;
        }
        this.setIndicatorMargin(n6);
        this.setIndicatorHeight(((CommonBannerConfig)object).getIndicatorHeight());
        if (((CommonBannerConfig)object).getItemMargin()[0] <= 0 && ((CommonBannerConfig)object).getItemMargin()[1] <= 0) {
            CommonBannerView commonBannerView5 = this;
            commonBannerView5.setScrollMargin(0, 0);
            commonBannerView5.mViewPager.setClipToPadding(true);
            commonBannerView5.mViewPager.setClipChildren(true);
        } else {
            CommonBannerView commonBannerView6 = this;
            commonBannerView6.setScrollMargin(((CommonBannerConfig)object).getItemMargin()[0], ((CommonBannerConfig)object).getItemMargin()[1]);
            commonBannerView6.mViewPager.setClipToPadding(false);
            commonBannerView6.mViewPager.setClipChildren(false);
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams instanceof FrameLayout.LayoutParams) {
            CommonBannerConfig commonBannerConfig2 = object;
            int n7 = commonBannerConfig2.getMargin()[0];
            n4 = commonBannerConfig2.getMargin()[1];
            n3 = commonBannerConfig2.getMargin()[2];
            ((FrameLayout.LayoutParams)layoutParams).setMargins(((CommonBannerConfig)object).getMargin()[3], n7, n4, n3);
        } else if (layoutParams instanceof RelativeLayout.LayoutParams) {
            CommonBannerConfig commonBannerConfig3 = object;
            int n8 = commonBannerConfig3.getMargin()[0];
            n4 = commonBannerConfig3.getMargin()[1];
            n3 = commonBannerConfig3.getMargin()[2];
            ((RelativeLayout.LayoutParams)layoutParams).setMargins(((CommonBannerConfig)object).getMargin()[3], n8, n4, n3);
        } else if (layoutParams instanceof LinearLayout.LayoutParams) {
            CommonBannerConfig commonBannerConfig4 = object;
            int n9 = commonBannerConfig4.getMargin()[0];
            n4 = commonBannerConfig4.getMargin()[1];
            n3 = commonBannerConfig4.getMargin()[2];
            ((LinearLayout.LayoutParams)layoutParams).setMargins(((CommonBannerConfig)object).getMargin()[3], n9, n4, n3);
        }
        CommonBannerConfig commonBannerConfig5 = object;
        this.mViewPager.setItemRatio(((CommonBannerConfig)object).getItemRatio());
        this.currentItemPos = n2 = ((CommonBannerConfig)object).getIntExtra(CURRENT_POS);
        this.mViewPager.setCurrentItem(n2);
        String string2 = commonBannerConfig5.getIndicatorFocus();
        object = commonBannerConfig5.getIndicatorNor();
        int n10 = commonBannerConfig5.getIndicatorRadius();
        n4 = commonBannerConfig5.getIndicatorColor();
        n3 = commonBannerConfig5.getIndicatorDefaultColor();
        this.updateIndicators(string2, (String)object, n10, n4, n3);
    }

    public void unbindView(CommonBannerConfig commonBannerConfig) {
        this.getContext().unregisterReceiver((BroadcastReceiver)this.mScreenBroadcastReceiver);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected void onMeasure(int n2, int n3) {
        int n4;
        if (!Float.isNaN(this.ratio)) {
            n3 = View.MeasureSpec.makeMeasureSpec((int)((int)((float)View.MeasureSpec.getSize((int)n2) / this.ratio)), (int)0x40000000);
        } else {
            n4 = this.height;
            if (n4 > 0) {
                n3 = View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000);
            }
        }
        CommonBannerView commonBannerView = this;
        commonBannerView.mViewPager.measure(n2, n3);
        commonBannerView.mIndicator.measure(n2, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        n2 = 0;
        n3 = 0;
        n4 = commonBannerView.mViewPager.getMeasuredWidth();
        int n5 = commonBannerView.mViewPager.getMeasuredHeight();
        if (commonBannerView.isIndicatorOutside) {
            this.setMeasuredDimension(n4, n5 + this.mIndicator.getMeasuredHeight() + n2 + n3);
        } else {
            this.setMeasuredDimension(n4, n5 + n2 + n3);
        }
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        CommonBannerView commonBannerView = this;
        int n6 = commonBannerView.mViewPager.getMeasuredWidth();
        int n7 = commonBannerView.mViewPager.getMeasuredHeight();
        int n8 = commonBannerView.mIndicator.getMeasuredHeight();
        int n9 = commonBannerView.getPaddingTop();
        int n10 = commonBannerView.getPaddingLeft();
        int n11 = n9 + n7;
        commonBannerView.mViewPager.layout(n10, n9, n6, n11);
        if (commonBannerView.isIndicatorOutside) {
            int n72 = n11 + n7 + n8;
            this.mIndicator.layout(n10, n11, n6, n72);
        } else {
            this.mIndicator.layout(n10, n11 - n8, n6, n11);
        }
    }

    protected void onAttachedToWindow() {
        CommonBannerView commonBannerView = this;
        super.onAttachedToWindow();
        commonBannerView.startTimer();
    }

    protected void onDetachedFromWindow() {
        CommonBannerView commonBannerView = this;
        super.onDetachedFromWindow();
        commonBannerView.stopTimer();
    }

    protected void onVisibilityChanged(View view, int n2) {
        super.onVisibilityChanged(view, n2);
        if (n2 == 0) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }

    public void onStartTemporaryDetach() {
        CommonBannerView commonBannerView = this;
        super.onStartTemporaryDetach();
        commonBannerView.stopTimer();
    }

    public void onFinishTemporaryDetach() {
        CommonBannerView commonBannerView = this;
        super.onFinishTemporaryDetach();
        commonBannerView.startTimer();
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.timer != null) {
            int n2 = motionEvent.getAction();
            if (n2 == 0) {
                this.stopTimer();
            }
            if (n2 == 1 || n2 == 3) {
                this.startTimer();
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        void var1_5;
        int n2 = var1_5.getAction();
        void v02 = var1_5;
        float f3 = v02.getRawX();
        float f4 = v02.getRawY();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    void var0_4;
                    int bl = (int)(f3 - this.xDown);
                    int n3 = (int)(f4 - this.yDown);
                    this.direction = -bl;
                    ViewParent viewParent = this.getParent();
                    if (Math.abs(bl) >= Math.abs(n3)) {
                        boolean bl2 = true;
                    } else {
                        boolean bl3 = false;
                    }
                    viewParent.requestDisallowInterceptTouchEvent((boolean)var0_4);
                }
            } else {
                this.direction = 1;
            }
        } else {
            CommonBannerView commonBannerView = this;
            commonBannerView.xDown = f3;
            commonBannerView.yDown = f4;
        }
        return false;
    }

    @Override
    public int getNextItem() {
        return this.getNextItemIndex();
    }

    @Override
    public void callBack() {
        this.scrollNextPage();
    }

    public void setScrollMargin(int n2, int n3) {
        this.mViewPager.setPadding(n2, 0, n3, 0);
    }

    public void setInfiniteLoop(boolean bl) {
        this.mViewPager.setEnableLoop(bl);
    }

    public void setAutoScroll(int n2, SparseIntArray sparseIntArray) {
        TimerHandler timerHandler;
        if (n2 == 0) {
            return;
        }
        if (this.timer != null) {
            this.disableAutoScroll();
        }
        TimerHandler timerHandler2 = timerHandler;
        long l2 = n2;
        timerHandler2(this, l2);
        this.timer = timerHandler2;
        timerHandler.setSpecialInterval(sparseIntArray);
        this.startTimer();
    }

    public void disableAutoScroll() {
        this.stopTimer();
        this.timer = null;
    }

    public static interface BannerListenerV2<T> {
        public void onPageScrolled(T var1, int var2, float var3, int var4, int var5);

        public void onPageSelected(T var1, int var2);

        public void onPageScrollStateChanged(T var1, int var2);

        public void onItemPositionInBanner(T var1, int var2);
    }

    public static class BannerSupportV2 {
        private final List<BannerListenerV2> listeners;

        public BannerSupportV2() {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.listeners = arrayList2;
        }

        public void registerPageChangeListener(BannerListenerV2 bannerListenerV2) {
            if (!this.listeners.contains(bannerListenerV2)) {
                this.listeners.add(bannerListenerV2);
            }
        }

        public void unregisterPageChangeListener(BannerListenerV2 bannerListenerV2) {
            this.listeners.remove(bannerListenerV2);
        }

        @Deprecated
        public List<BannerListenerV2> getListeners() {
            return this.listeners;
        }

        public void destroy() {
            this.destroyBannerListener();
        }

        public void destroyBannerListener() {
            this.listeners.clear();
        }
    }

    private static class ScreenBroadcastReceiver
    extends BroadcastReceiver {
        private String action = null;
        private CommonBannerView mBannerView = null;

        public ScreenBroadcastReceiver(CommonBannerView commonBannerView) {
            this.mBannerView = commonBannerView;
        }

        public void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            this.action = object;
            if ("android.intent.action.SCREEN_ON".equals(object)) {
                this.mBannerView.startTimer();
            } else if ("android.intent.action.SCREEN_OFF".equals(this.action)) {
                this.mBannerView.stopTimer();
            } else if ("android.intent.action.USER_PRESENT".equals(this.action)) {
                this.mBannerView.startTimer();
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(@NonNull ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    class CommonBannerIndicator
    extends LinearLayout {
        private final int STYLE_NONE;
        private final int STYLE_DOT;
        private final int STYLE_IMG;
        private ImageView[] mImageViews;
        private String focusUrl;
        private String norUrl;
        private int norColor;
        private int focusColor;
        private float radius;
        private int style;

        public CommonBannerIndicator(Context context) {
            super(context);
            this.STYLE_NONE = 0;
            this.STYLE_DOT = 1;
            this.STYLE_IMG = 2;
        }

        private int getDefaultIndicatorDrawableId(boolean bl) {
            return bl ? R.drawable.nsdk_drawable_route_result_intelli_drive_page_indicator_selected : R.drawable.nsdk_drawable_route_result_intelli_drive_page_indicator_unselected;
        }

        private GradientDrawable getGradientDrawable(int n2, float f3) {
            CommonBannerIndicator commonBannerIndicator = GradientDrawable.Orientation.BOTTOM_TOP;
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = n2;
            nArray[1] = n2;
            GradientDrawable gradientDrawable = new GradientDrawable((GradientDrawable.Orientation)commonBannerIndicator, nArray2);
            gradientDrawable.setShape(1);
            gradientDrawable.setCornerRadius(f3);
            return gradientDrawable;
        }

        /*
         * Unable to fully structure code
         */
        public void updateIndicators(String var1_1, String var2_2, int var3_4, int var4_7, int var5_10) {
            block29: {
                block30: {
                    if (CommonBannerView.access$000(CommonBannerView.this).getWrapperAdapter() == null) {
                        return;
                    }
                    v0 = this;
                    v0.focusUrl = var1_1;
                    v0.norUrl = var2_2;
                    v0.norColor = var5_10;
                    v0.focusColor = var4_7;
                    this.radius = var6_12 = (float)var3_4;
                    this.style = var5_10 != 0 && var4_7 != 0 && var3_4 > 0 ? 1 : (TextUtils.isEmpty((CharSequence)var1_1) == false && TextUtils.isEmpty((CharSequence)var2_2) == false ? 2 : 0);
                    if (this.style == 0) {
                        this.setVisibility(4);
                        return;
                    }
                    v1 = this;
                    v1.setVisibility(0);
                    var7_14 = 0;
                    var8_15 = 0;
                    var9_16 = v1.style;
                    if (var9_16 != 2) break block29;
                    var3_5 = Utils.getImageSize((String)var2_2);
                    var9_17 = Utils.getImageSize((String)var1_1);
                    if (var3_5 == null || var9_17 == null) break block30;
                    v2 = var3_5;
                    var3_6 = Math.max((Integer)v2.first, (Integer)var9_17.first);
                    var8_15 = var7_14 = Math.max((Integer)v2.second, (Integer)var9_17.second);
                    var7_14 = var3_6;
                    ** GOTO lbl-1000
                }
                if (var9_17 != null) {
                    v3 = var9_17;
                    var7_14 = (Integer)v3.first;
                    var8_15 = (Integer)v3.second;
                }
                if (var3_5 == null) ** GOTO lbl-1000
                v4 = var3_5;
                var7_14 = (Integer)v4.first;
                var8_15 = (Integer)v4.second;
                ** GOTO lbl-1000
            }
            if (var9_16 == 1) {
                var8_15 = var3_4 * 2;
                var3_4 = var8_15;
            } else lbl-1000:
            // 4 sources

            {
                var3_4 = var8_15;
                var8_15 = var7_14;
            }
            if (CommonBannerView.access$100(CommonBannerView.this) != -2 && CommonBannerView.access$100(CommonBannerView.this) > 0) {
                var3_4 = CommonBannerView.access$100(CommonBannerView.this);
            }
            v5 = this;
            var7_14 = CommonBannerView.access$000(v5.CommonBannerView.this).getWrapperAdapter().getCount();
            var9_18 = v5.mImageViews;
            if (v5.mImageViews == null) {
                this.mImageViews = new ImageView[var7_14];
                var7_14 = 0;
                while (true) {
                    var9_18 = this.mImageViews;
                    if (var7_14 < this.mImageViews.length) {
                        v6 = this;
                        var9_18[var7_14] = CommonBannerView.createImageInstance(this.getContext());
                        v6.mImageViews[var7_14].setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                        v6.addView((View)v6.mImageViews[var7_14]);
                        var7_14 += 1;
                        continue;
                    }
                    break;
                }
            } else if (var9_18.length != var7_14) {
                for (var9_19 = 0; var9_19 < ((ImageView[])(var10_21 = this.mImageViews)).length; ++var9_19) {
                    this.removeView((View)var10_21[var9_19]);
                }
                v7 = var10_21;
                this.mImageViews = var9_18 = new ImageView[var7_14];
                var7_14 = Math.min(((ImageView[])v7).length, var7_14);
                System.arraycopy(v7, 0, var9_18, 0, var7_14);
                var7_14 = 0;
                while (true) {
                    var9_18 = this.mImageViews;
                    if (var7_14 >= this.mImageViews.length) break;
                    if (var9_18[var7_14] == null) {
                        var9_18[var7_14] = CommonBannerView.createImageInstance(this.getContext());
                        this.mImageViews[var7_14].setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    }
                    v8 = this;
                    v8.addView((View)v8.mImageViews[var7_14]);
                    var7_14 += 1;
                }
            }
            var7_14 = CommonBannerView.access$000(CommonBannerView.this).getCurrentItem();
            var9_20 = 0;
            while (true) {
                var10_21 = this.mImageViews;
                if (var9_20 >= this.mImageViews.length) break;
                var10_21 = (LinearLayout.LayoutParams)var10_21[var9_20].getLayoutParams();
                var11_22 = this.style;
                if (var11_22 != 2 && var11_22 != 1) {
                    var10_21.setMargins(0, 0, 0, 0);
                } else {
                    v9 = this;
                    var11_22 = CommonBannerView.access$200(v9.CommonBannerView.this);
                    var12_23 = CommonBannerView.access$300(v9.CommonBannerView.this);
                    var13_24 = CommonBannerView.access$200(v9.CommonBannerView.this);
                    var10_21.setMargins(0, var11_22, var12_23, var13_24);
                    if (var8_15 > 0) {
                        var10_21.width = var8_15;
                    }
                    if (var3_4 > 0) {
                        var10_21.height = var3_4;
                    }
                }
                if (this.style == 1) {
                    var10_21 = this.mImageViews[var9_20];
                    var11_22 = var7_14 == var9_20 ? var4_7 : var5_10;
                    var10_21.setImageDrawable((Drawable)this.getGradientDrawable(var11_22, var6_12));
                }
                ++var9_20;
            }
            if (this.style == 2) {
                if (CommonBannerView.access$400(CommonBannerView.this)) {
                    for (var3_4 = 0; var3_4 < this.mImageViews.length; ++var3_4) {
                        if (CommonBannerView.access$500(CommonBannerView.this) != null) {
                            v10 = this;
                            var4_8 = CommonBannerView.access$500(v10.CommonBannerView.this);
                            var5_11 = v10.mImageViews[var3_4];
                            var6_13 = var7_14 == var3_4 ? var1_1 : var2_2;
                            var8_15 = var7_14 == var3_4 ? 1 : 0;
                            var4_7 = this.getDefaultIndicatorDrawableId((boolean)var8_15);
                            var4_8.doLoadImageUrl(var5_11, (String)var6_13, var4_7);
                        }
                        if (var3_4 != CommonBannerView.access$600(CommonBannerView.this)) continue;
                        this.mImageViews[var3_4].setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, (Object)CommonBannerView.access$600(CommonBannerView.this));
                    }
                } else {
                    for (var3_4 = 0; var3_4 < ((ImageView[])(var4_9 = this.mImageViews)).length; ++var3_4) {
                        if ((var4_9 = var4_9[var3_4]).getTag(R.id.RECYCLER_BANNER_INDICATOR_POS) == null) continue;
                        var4_9.setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, null);
                        if (CommonBannerView.access$500(CommonBannerView.this) == null) continue;
                        CommonBannerView.access$500(CommonBannerView.this).doLoadImageUrl(var4_9, (String)var2_2, this.getDefaultIndicatorDrawableId(false));
                    }
                    if (CommonBannerView.access$600(CommonBannerView.this) >= 0) {
                        var2_2 = this.mImageViews;
                        if (CommonBannerView.access$600(CommonBannerView.this) < this.mImageViews.length) {
                            var2_2[CommonBannerView.access$600(CommonBannerView.this)].setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, (Object)CommonBannerView.access$600(CommonBannerView.this));
                            if (CommonBannerView.access$500(CommonBannerView.this) != null) {
                                v11 = this;
                                this = v11.mImageViews[CommonBannerView.access$600(CommonBannerView.this)];
                                var2_3 = v11.getDefaultIndicatorDrawableId(true);
                                CommonBannerView.access$500(CommonBannerView.this).doLoadImageUrl((ImageView)this, (String)var1_1, var2_3);
                            }
                        }
                    }
                }
            }
        }

        public void setCurrItem(int n2) {
            if (commonBannerIndicator2.mImageViews != null) {
                Object object;
                int n3;
                for (n3 = 0; n3 < ((ImageView[])(object = commonBannerIndicator2.mImageViews)).length; ++n3) {
                    int n4 = commonBannerIndicator2.style;
                    if (n4 == 1) {
                        object = object[n3];
                        n4 = n2 == n3 ? commonBannerIndicator2.focusColor : commonBannerIndicator2.norColor;
                        object.setImageDrawable((Drawable)commonBannerIndicator2.getGradientDrawable(n4, commonBannerIndicator2.radius));
                        continue;
                    }
                    if (n4 != 2 || (object = object[n3]).getTag(R.id.RECYCLER_BANNER_INDICATOR_POS) == null) continue;
                    object.setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, null);
                    if (commonBannerIndicator2.CommonBannerView.this.config == null) continue;
                    ImageView imageView = object;
                    CommonBannerIndicator commonBannerIndicator = commonBannerIndicator2;
                    object = commonBannerIndicator.norUrl;
                    commonBannerIndicator2.CommonBannerView.this.config.doLoadImageUrl(imageView, (String)object, commonBannerIndicator.getDefaultIndicatorDrawableId(false));
                }
                if (commonBannerIndicator2.CommonBannerView.this.currentItemPos >= 0) {
                    Object object2 = commonBannerIndicator2.mImageViews;
                    if (commonBannerIndicator2.CommonBannerView.this.currentItemPos < commonBannerIndicator2.mImageViews.length) {
                        object2[commonBannerIndicator2.CommonBannerView.this.currentItemPos].setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, (Object)commonBannerIndicator2.CommonBannerView.this.currentItemPos);
                        if (commonBannerIndicator2.style == 2 && commonBannerIndicator2.CommonBannerView.this.config != null) {
                            CommonBannerIndicator commonBannerIndicator = commonBannerIndicator2;
                            CommonBannerIndicator commonBannerIndicator2 = commonBannerIndicator.mImageViews[commonBannerIndicator2.CommonBannerView.this.currentItemPos];
                            object2 = commonBannerIndicator.focusUrl;
                            n3 = commonBannerIndicator.getDefaultIndicatorDrawableId(true);
                            commonBannerIndicator2.CommonBannerView.this.config.doLoadImageUrl((ImageView)commonBannerIndicator2, (String)object2, n3);
                        }
                    }
                }
            }
        }
    }
}

