/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.banner;

import android.database.DataSetObserver;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

public class CommonBannerViewPagerAdapter
extends PagerAdapter {
    private static final int INFINITE_RATIO = 400;
    private PagerAdapter adapter;
    private boolean enableLoop;
    private float multiScrRatio = Float.NaN;
    private boolean hasCentered;
    private int scrWidth;
    private int infiniteRatio;
    private ViewPagerCenterListener centerListener;
    private SparseArray viewArray;

    public CommonBannerViewPagerAdapter(PagerAdapter pagerAdapter) {
        SparseArray sparseArray;
        CommonBannerViewPagerAdapter commonBannerViewPagerAdapter = sparseArray;
        sparseArray = new SparseArray();
        v1.viewArray = commonBannerViewPagerAdapter;
        v1.adapter = pagerAdapter;
        v1.infiniteRatio = 400;
    }

    public int getCount() {
        return this.enableLoop ? (this.adapter.getCount() == 0 ? 0 : this.adapter.getCount() * this.infiniteRatio) : this.adapter.getCount();
    }

    public Object instantiateItem(ViewGroup viewGroup, int n2) {
        if (this.enableLoop && this.adapter.getCount() != 0) {
            n2 %= this.adapter.getCount();
        }
        Object object = this.adapter.instantiateItem(viewGroup, n2);
        View view = null;
        if (object instanceof View) {
            view = (View)object;
        }
        int n3 = viewGroup.getChildCount();
        for (int i3 = 0; i3 < n3; ++i3) {
            View view2 = viewGroup.getChildAt(i3);
            if (!this.isViewFromObject(view2, object)) continue;
            this.viewArray.put(n2, (Object)view2);
            break;
        }
        if (this.isEnableMultiScr()) {
            RelativeLayout relativeLayout;
            if (this.scrWidth == 0) {
                this.scrWidth = viewGroup.getResources().getDisplayMetrics().widthPixels;
            }
            RelativeLayout relativeLayout2 = relativeLayout;
            relativeLayout = new RelativeLayout(viewGroup.getContext());
            if (view != null && view.getLayoutParams() != null) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams((int)((float)this.scrWidth * this.multiScrRatio), -1);
                layoutParams.addRule(13, -1);
                view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            viewGroup.removeView(view);
            relativeLayout2.addView(view);
            viewGroup.addView((View)relativeLayout2);
            return relativeLayout2;
        }
        return object;
    }

    public void destroyItem(ViewGroup viewGroup, int n2, Object object) {
        if (this.enableLoop && this.adapter.getCount() != 0) {
            n2 %= this.adapter.getCount();
        }
        if (this.isEnableMultiScr() && object instanceof RelativeLayout) {
            RelativeLayout relativeLayout = (RelativeLayout)object;
            object = relativeLayout.getChildAt(0);
            relativeLayout.removeAllViews();
            this.adapter.destroyItem(viewGroup, n2, object);
        } else {
            this.adapter.destroyItem(viewGroup, n2, object);
        }
        this.viewArray.remove(n2);
    }

    public View getViewAtPosition(int n2) {
        return (View)this.viewArray.get(n2);
    }

    public void finishUpdate(ViewGroup viewGroup) {
        if (!this.hasCentered && this.adapter.getCount() > 0 && this.getCount() > this.adapter.getCount()) {
            this.centerListener.center();
        }
        this.hasCentered = true;
        this.adapter.finishUpdate(viewGroup);
    }

    public boolean isViewFromObject(View view, Object object) {
        return this.adapter.isViewFromObject(view, object);
    }

    public void restoreState(Parcelable parcelable, ClassLoader classLoader) {
        this.adapter.restoreState(parcelable, classLoader);
    }

    public Parcelable saveState() {
        return this.adapter.saveState();
    }

    public void startUpdate(ViewGroup viewGroup) {
        this.adapter.startUpdate(viewGroup);
    }

    public CharSequence getPageTitle(int n2) {
        int n3 = n2 % this.adapter.getCount();
        return this.adapter.getPageTitle(n3);
    }

    public float getPageWidth(int n2) {
        return this.adapter.getPageWidth(n2);
    }

    public void setPrimaryItem(ViewGroup viewGroup, int n2, Object object) {
        this.adapter.setPrimaryItem(viewGroup, n2, object);
    }

    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
        this.adapter.unregisterDataSetObserver(dataSetObserver);
    }

    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
        this.adapter.registerDataSetObserver(dataSetObserver);
    }

    public void notifyDataSetChanged() {
        CommonBannerViewPagerAdapter commonBannerViewPagerAdapter = commonBannerViewPagerAdapter2;
        super.notifyDataSetChanged();
        CommonBannerViewPagerAdapter commonBannerViewPagerAdapter2 = commonBannerViewPagerAdapter.adapter;
        if (commonBannerViewPagerAdapter2 != null) {
            commonBannerViewPagerAdapter2.notifyDataSetChanged();
        }
    }

    public int getItemPosition(Object object) {
        return this.adapter.getItemPosition(object);
    }

    public final PagerAdapter getAdapter() {
        return this.adapter;
    }

    public int getRealCount() {
        return this.adapter.getCount();
    }

    public void setEnableLoop(boolean bl) {
        this.enableLoop = bl;
        this.notifyDataSetChanged();
        if (!bl) {
            this.centerListener.resetPosition();
        }
    }

    public boolean isEnableLoop() {
        return this.enableLoop;
    }

    public void setMultiScrRatio(float f3) {
        this.multiScrRatio = f3;
    }

    public boolean isEnableMultiScr() {
        return !Float.isNaN(this.multiScrRatio) && this.multiScrRatio < 1.0f;
    }

    public void setCenterListener(ViewPagerCenterListener viewPagerCenterListener) {
        this.centerListener = viewPagerCenterListener;
    }

    public void setInfiniteRatio(int n2) {
        this.infiniteRatio = n2;
    }

    public static interface ViewPagerCenterListener {
        public void center();

        public void resetPosition();
    }
}

