/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.core.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.navisdk.ui.widget.recyclerview.BinderViewHolder;
import com.baidu.navisdk.ui.widget.recyclerview.core.protocol.ControlBinder;
import com.baidu.navisdk.ui.widget.recyclerview.core.protocol.ControlBinderResolver;
import com.baidu.navisdk.ui.widget.recyclerview.core.protocol.LayoutBinder;
import com.baidu.navisdk.ui.widget.recyclerview.core.protocol.LayoutBinderResolver;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.Card;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutAdapter;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend.PerformanceMonitor;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.v;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class GroupBasicAdapter<L, C>
extends VirtualLayoutAdapter<BinderViewHolder<C, ? extends View>> {
    private static final String TAG = "GroupBasicAdapter";
    protected static final String PHASE_CREATE = "create";
    protected static final String PHASE_BIND = "bind";
    protected static final String PHASE_UNBIND = "unbind";
    @NonNull
    private final Context mContext;
    @NonNull
    protected ArrayList<Pair<Range<Integer>, L>> mCards = new ArrayList();
    @NonNull
    protected List<C> mData = new LinkedList<C>();
    private final ControlBinderResolver<? extends ControlBinder<C, ? extends View>> mCompBinderResolver;
    private final LayoutBinderResolver<L, ? extends LayoutBinder<L>> mCardBinderResolver;
    private PerformanceMonitor mPerformanceMonitor;
    private final SparseBooleanArray pendingDeleteMap = new SparseBooleanArray();
    private final SparseArray<L> oldMap = new SparseArray(64);
    private final SparseArray<L> newMap = new SparseArray(64);

    public GroupBasicAdapter(@NonNull Context context, @NonNull VirtualLayoutManager virtualLayoutManager, @NonNull ControlBinderResolver<? extends ControlBinder<C, ? extends View>> controlBinderResolver, @NonNull LayoutBinderResolver<L, ? extends LayoutBinder<L>> layoutBinderResolver) {
        super(virtualLayoutManager);
        this.mContext = v.a(context, (Object)"context should not be null");
        this.mCompBinderResolver = v.a(controlBinderResolver, (Object)"componentBinderResolver should not be null");
        this.mCardBinderResolver = v.a(layoutBinderResolver, (Object)"layoutBinderResolver should not be null");
    }

    private void createSnapshot() {
        GroupBasicAdapter groupBasicAdapter = this;
        groupBasicAdapter.oldMap.clear();
        List<L> list = groupBasicAdapter.getGroups();
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            L l2 = list.get(i3);
            this.oldMap.put(System.identityHashCode(l2), l2);
        }
    }

    private void diffWithSnapshot() {
        int n2;
        int n3;
        SparseArray<L> sparseArray = sparseArray5;
        sparseArray.pendingDeleteMap.clear();
        sparseArray.newMap.clear();
        List<L> list = sparseArray.getGroups();
        int n4 = list.size();
        for (n3 = 0; n3 < n4; ++n3) {
            L l2 = list.get(n3);
            sparseArray5.newMap.put(System.identityHashCode(l2), l2);
        }
        n3 = sparseArray5.newMap.size();
        for (n2 = 0; n2 < n3; ++n2) {
            SparseArray<L> sparseArray2 = sparseArray5;
            n4 = sparseArray2.newMap.keyAt(n2);
            if (sparseArray2.oldMap.get(n4) == null) continue;
            SparseArray<L> sparseArray3 = sparseArray5;
            sparseArray3.oldMap.remove(n4);
            sparseArray3.pendingDeleteMap.put(n4, true);
        }
        n3 = sparseArray5.pendingDeleteMap.size();
        for (n2 = 0; n2 < n3; ++n2) {
            sparseArray5.newMap.remove(sparseArray5.pendingDeleteMap.keyAt(n2));
        }
        SparseArray<L> sparseArray4 = sparseArray5;
        SparseArray<L> sparseArray5 = sparseArray4.newMap;
        sparseArray4.diffGroup(sparseArray5, sparseArray4.oldMap);
        sparseArray4.oldMap.clear();
        sparseArray4.newMap.clear();
    }

    public void setPerformanceMonitor(PerformanceMonitor performanceMonitor) {
        this.mPerformanceMonitor = performanceMonitor;
    }

    public void setData(@Nullable List<L> list) {
        this.setData(list, false);
    }

    public void setData(@Nullable List<L> list, boolean bl) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setData --> silence = " + bl);
            LogUtil.printList(TAG, "setData", "cards", list);
        }
        GroupBasicAdapter groupBasicAdapter = this;
        groupBasicAdapter.createSnapshot();
        groupBasicAdapter.mCards.clear();
        groupBasicAdapter.mData.clear();
        if (list != null && list.size() != 0) {
            GroupBasicAdapter groupBasicAdapter2 = this;
            List<L> list2 = list;
            GroupBasicAdapter groupBasicAdapter3 = this;
            groupBasicAdapter3.mCards.ensureCapacity(list.size());
            list = groupBasicAdapter3.mData;
            groupBasicAdapter2.setLayoutHelpers(groupBasicAdapter2.transformCards(list2, list, groupBasicAdapter3.mCards));
        } else {
            this.setLayoutHelpers(Collections.emptyList());
        }
        this.diffWithSnapshot();
        if (!bl) {
            this.notifyDataSetChanged();
        }
    }

    public void appendGroup(@Nullable List<L> list) {
        if (list != null && list.size() != 0) {
            LinkedList<LayoutHelper> linkedList;
            GroupBasicAdapter groupBasicAdapter = object;
            groupBasicAdapter.createSnapshot();
            LinkedList<LayoutHelper> linkedList2 = linkedList;
            GroupBasicAdapter groupBasicAdapter2 = object;
            GroupBasicAdapter groupBasicAdapter3 = object;
            linkedList2(object.getLayoutHelpers());
            ArrayList<Pair<Range<Integer>, L>> arrayList = groupBasicAdapter3.mCards;
            arrayList.ensureCapacity(arrayList.size() + list.size());
            Object object = groupBasicAdapter3.mData;
            linkedList.addAll(groupBasicAdapter2.transformCards(list, (List<C>)object, (List<Pair<Range<Integer>, L>>)groupBasicAdapter3.mCards));
            groupBasicAdapter.setLayoutHelpers(linkedList);
            groupBasicAdapter.diffWithSnapshot();
            groupBasicAdapter.notifyDataSetChanged();
            return;
        }
    }

    protected abstract List<C> getItems(@NonNull L var1);

    public C getItemByPosition(int n2) {
        return this.mData.get(n2);
    }

    public int getPositionByItem(C c3) {
        return this.mData.indexOf(c3);
    }

    @NonNull
    protected List<LayoutHelper> transformCards(@Nullable List<L> list, @NonNull List<C> list2, @NonNull List<Pair<Range<Integer>, L>> list3) {
        if (LogUtil.LOGGABLE) {
            LogUtil.printList(TAG, "transformCards", "cards", list);
            LogUtil.printList(TAG, "transformCards", "data", list2);
            LogUtil.printList(TAG, "transformCards", "rangeCards", list3);
        }
        if (list != null && list.size() != 0) {
            ArrayList<LayoutHelper> arrayList;
            int n2 = list2.size();
            ArrayList<LayoutHelper> arrayList2 = arrayList;
            arrayList = new ArrayList<LayoutHelper>(list.size());
            int n3 = list.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                Object object = list.get(i3);
                if (object == null) continue;
                GroupBasicAdapter groupBasicAdapter = this;
                String string2 = groupBasicAdapter.getCardStringType(object);
                List<C> list4 = groupBasicAdapter.getItems(object);
                if (list4 == null) continue;
                int n4 = n2;
                list2.addAll(list4);
                n2 = n4 + list4.size();
                list3.add(Pair.create(Range.create(n4, n2), object));
                object = ((LayoutBinder)this.mCardBinderResolver.create(string2)).getHelper(string2, object);
                if (object == null) continue;
                L l2 = object;
                ((LayoutHelper)l2).setItemCount(list4.size());
                arrayList2.add((LayoutHelper)l2);
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.printList(TAG, "transformCards", "helpers", arrayList2);
            }
            return arrayList2;
        }
        return new LinkedList<LayoutHelper>();
    }

    public BinderViewHolder<C, ? extends View> onCreateViewHolder(ViewGroup object, int n2) {
        GroupBasicAdapter groupBasicAdapter = object3;
        String string2 = groupBasicAdapter.getCellTypeFromItemType(n2);
        ControlBinder controlBinder = (ControlBinder)groupBasicAdapter.mCompBinderResolver.create(string2);
        Object object2 = groupBasicAdapter.mPerformanceMonitor;
        if (object2 != null) {
            ((PerformanceMonitor)object2).recordStart(PHASE_CREATE, string2);
        }
        if (controlBinder == null && LogUtil.LOGGABLE) {
            HashMap hashMap;
            HashMap<String, String> hashMap2 = object2 = hashMap;
            hashMap2();
            hashMap2.put("type", string2);
            hashMap.put("binderResolver", object3.mCompBinderResolver.toString());
            LogUtil.e(TAG, "Couldn't found component match certain type: " + string2 + ", infoMap: " + object2);
        }
        GroupBasicAdapter groupBasicAdapter2 = object3;
        Object object3 = groupBasicAdapter2.createViewHolder(controlBinder, groupBasicAdapter2.mContext, (ViewGroup)object);
        object = groupBasicAdapter2.mPerformanceMonitor;
        if (object != null) {
            ((PerformanceMonitor)object).recordEnd(PHASE_CREATE, string2);
        }
        return object3;
    }

    public abstract <V extends View> BinderViewHolder<C, V> createViewHolder(@NonNull ControlBinder<C, V> var1, @NonNull Context var2, ViewGroup var3);

    public void onBindViewHolder(BinderViewHolder<C, ? extends View> binderViewHolder, int n2) {
        GroupBasicAdapter groupBasicAdapter = performanceMonitor2;
        C c3 = groupBasicAdapter.mData.get(n2);
        PerformanceMonitor performanceMonitor = groupBasicAdapter.mPerformanceMonitor;
        if (performanceMonitor != null) {
            performanceMonitor.recordStart(PHASE_BIND, (View)binderViewHolder.itemView);
        }
        binderViewHolder.bind(c3);
        PerformanceMonitor performanceMonitor2 = ((GroupBasicAdapter)((Object)performanceMonitor2)).mPerformanceMonitor;
        if (performanceMonitor2 != null) {
            performanceMonitor2.recordEnd(PHASE_BIND, (View)binderViewHolder.itemView);
        }
    }

    public void onViewRecycled(BinderViewHolder<C, ? extends View> binderViewHolder) {
        PerformanceMonitor performanceMonitor = ((GroupBasicAdapter)((Object)performanceMonitor2)).mPerformanceMonitor;
        if (performanceMonitor != null) {
            performanceMonitor.recordStart(PHASE_UNBIND, (View)binderViewHolder.itemView);
        }
        binderViewHolder.unbind();
        PerformanceMonitor performanceMonitor2 = ((GroupBasicAdapter)((Object)performanceMonitor2)).mPerformanceMonitor;
        if (performanceMonitor2 != null) {
            performanceMonitor2.recordEnd(PHASE_UNBIND, (View)binderViewHolder.itemView);
        }
    }

    public void destroy() {
    }

    public Pair<Range<Integer>, L> getCardRange(int n2) {
        if (n2 >= 0 && n2 <= this.mCards.size() - 1) {
            return this.mCards.get(n2);
        }
        return null;
    }

    public Range<Integer> getCardRange(Card card) {
        if (card == null) {
            return Range.create(0, 1);
        }
        int n2 = this.getGroups().indexOf(card);
        if (n2 >= 0) {
            return (Range)this.mCards.get((int)n2).first;
        }
        return Range.create(0, 1);
    }

    public int findCardIdxForCard(L l2) {
        int n2 = this.mCards.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            if (this.mCards.get((int)i3).second != l2) continue;
            return i3;
        }
        return -1;
    }

    public int findCardIdxFor(int n2) {
        int n3 = 0;
        int n4 = this.mCards.size() - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            Pair<Range<Integer>, L> pair = this.mCards.get(n5);
            if (pair == null) {
                return -1;
            }
            if ((Integer)((Range)pair.first).getLower() <= n2 && (Integer)((Range)pair.first).getUpper() > n2) {
                return n5;
            }
            if ((Integer)((Range)pair.first).getUpper() <= n2) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
        }
        return -1;
    }

    public int findCardIdxFor(C c3) {
        GroupBasicAdapter groupBasicAdapter = this;
        return groupBasicAdapter.findCardIdxFor(groupBasicAdapter.mData.indexOf(c3));
    }

    public abstract Range<Integer> getCardRange(String var1);

    public abstract Card getCardById(String var1);

    public abstract int findLastPositionOfCell(String var1);

    public abstract int findFirstPositionOfCell(String var1);

    public abstract String getCardStringType(L var1);

    public abstract String getCellTypeFromItemType(int var1);

    public abstract int getItemType(C var1);

    public int getItemViewType(int n2) {
        GroupBasicAdapter groupBasicAdapter = this;
        return groupBasicAdapter.getItemType(groupBasicAdapter.mData.get(n2));
    }

    public long getItemId(int n2) {
        return super.getItemId(n2);
    }

    public int getItemCount() {
        return this.mData.size();
    }

    public void notifyUpdate() {
        this.notifyUpdate(true);
    }

    public void notifyUpdate(boolean bl) {
        if (bl) {
            GroupBasicAdapter groupBasicAdapter = this;
            groupBasicAdapter.setData(groupBasicAdapter.getGroups());
        } else {
            this.notifyDataSetChanged();
        }
    }

    public void refreshWithoutNotify() {
        GroupBasicAdapter groupBasicAdapter = this;
        groupBasicAdapter.setData(groupBasicAdapter.getGroups(), true);
    }

    public void replaceGroup(int n2, @Nullable List<L> list) {
        if (n2 >= 0 && n2 < this.mCards.size() && list != null && list.size() != 0) {
            List<L> list2 = this.getGroups();
            if (list2.addAll(n2 + 1, list)) {
                list2.remove(n2);
                this.setData(list2);
            }
            return;
        }
    }

    public void insertGroup(int n2, @Nullable List<L> list) {
        if (n2 >= 0 && n2 < this.mCards.size() && list != null && list.size() != 0) {
            List<Object> list2 = this.getGroups();
            if (list2.addAll(n2, list)) {
                GroupBasicAdapter groupBasicAdapter = this;
                groupBasicAdapter.createSnapshot();
                groupBasicAdapter.mCards.clear();
                groupBasicAdapter.mData.clear();
                if (list2 != null && list2.size() != 0) {
                    GroupBasicAdapter groupBasicAdapter2 = this;
                    List<L> list3 = list2;
                    GroupBasicAdapter groupBasicAdapter3 = this;
                    groupBasicAdapter3.mCards.ensureCapacity(list2.size());
                    list2 = groupBasicAdapter3.mData;
                    groupBasicAdapter2.setLayoutHelpers(groupBasicAdapter2.transformCards(list3, list2, groupBasicAdapter3.mCards));
                } else {
                    this.setLayoutHelpers(Collections.emptyList());
                }
                this.diffWithSnapshot();
                this.notifyItemRangeInserted(n2, list.size());
            }
            return;
        }
    }

    public void removeGroup(@Nullable L l2) {
        if (l2 == null) {
            return;
        }
        List<L> list = this.getGroups();
        if (list.remove(l2)) {
            this.setData(list);
        }
    }

    public void removeGroup(int n2) {
        List<L> list = this.getGroups();
        if (n2 >= 0 && n2 < list.size() && list.remove(n2) != null) {
            this.setData(list);
        }
    }

    public abstract void removeComponent(int var1);

    public abstract void removeComponent(C var1);

    public abstract void removeComponents(L var1);

    public abstract void insertComponents(int var1, List<C> var2);

    public abstract void insertBatchComponents(int var1, List<L> var2);

    public abstract void replaceComponent(List<C> var1, List<C> var2);

    public abstract void replaceComponent(L var1, L var2);

    public List<L> getGroups() {
        ArrayList<Object> arrayList;
        ArrayList<Object> arrayList2 = arrayList;
        arrayList = new ArrayList<Object>(this.mCards.size());
        int n2 = this.mCards.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            arrayList2.add(this.mCards.get((int)i3).second);
        }
        return arrayList2;
    }

    public List<C> getComponents() {
        return new ArrayList<C>(this.mData);
    }

    protected void diffGroup(SparseArray<L> sparseArray, SparseArray<L> sparseArray2) {
    }
}

