/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.baidu.navisdk.ui.widget.recyclerview.BaseCardData;
import com.baidu.navisdk.ui.widget.recyclerview.BaseData;
import com.baidu.navisdk.ui.widget.recyclerview.Engine;
import com.baidu.navisdk.ui.widget.recyclerview.IServiceManager;
import com.baidu.navisdk.ui.widget.recyclerview.MVHelper;
import com.baidu.navisdk.ui.widget.recyclerview.Style;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.BaseCellBinderResolver;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.CardResolver;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.ComponentLifecycle;
import com.baidu.navisdk.ui.widget.recyclerview.structure.BaseCell;
import com.baidu.navisdk.ui.widget.recyclerview.structure.card.BannerCard;
import com.baidu.navisdk.ui.widget.recyclerview.structure.card.LinearScrollCard;
import com.baidu.navisdk.ui.widget.recyclerview.support.CardSupport;
import com.baidu.navisdk.ui.widget.recyclerview.util.Utils;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.BaseLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.FixAreaLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.MarginLayoutHelper;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.v;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class Card
extends ComponentLifecycle {
    public static final String TAG = "Card";
    public static final Card NaN = new NaNCard();
    public String stringType;
    public IServiceManager serviceManager;
    public String id;
    private LayoutHelper mLayoutHelper;
    private final SparseBooleanArray pendingDeleteMap;
    private final SparseArray<BaseCell> oldMap;
    private final SparseArray<BaseCell> newMap;
    @Nullable
    protected BaseCell mHeader;
    @Nullable
    protected BaseCell mFooter;
    @NonNull
    protected ArrayMap<Range<Integer>, Card> mChildren;
    @NonNull
    protected List<BaseCell> mCells;
    @NonNull
    protected final List<BaseCell> mPendingCells;
    @NonNull
    protected final List<BaseCell> mInQueueCells;
    @Nullable
    public Style style;
    private BaseCell mPlaceholderCell;
    public boolean loadMore;
    public boolean loading;
    public int page;
    public String load;
    public boolean loaded;
    public boolean hasMore;
    protected int maxChildren;
    public BaseData originalData;
    private boolean mPlaceholderRequired;
    private boolean mIsExposed;
    public boolean isDisplayBeyondScreen;
    public boolean isDisplayBeyondSpecHeight;
    protected boolean mRetainLayout;
    private float mTmpAspectRatio;

    public Card() {
        ArrayList arrayList;
        ArrayList arrayList2;
        ArrayList arrayList3;
        ArrayMap arrayMap;
        SparseArray sparseArray;
        SparseArray sparseArray2;
        SparseBooleanArray sparseBooleanArray;
        Object object = sparseBooleanArray;
        sparseBooleanArray = new SparseBooleanArray();
        v1.pendingDeleteMap = object;
        object = sparseArray2;
        sparseArray2 = new SparseArray();
        v1.oldMap = object;
        object = sparseArray;
        sparseArray = new SparseArray();
        v1.newMap = object;
        object = arrayMap;
        arrayMap = new ArrayMap();
        v1.mChildren = object;
        object = arrayList3;
        arrayList3 = new ArrayList();
        v1.mCells = object;
        object = arrayList2;
        arrayList2 = new ArrayList();
        v1.mPendingCells = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.mInQueueCells = object;
        v1.loadMore = false;
        v1.loading = false;
        v1.loaded = false;
        v1.hasMore = false;
        v1.maxChildren = Integer.MAX_VALUE;
        v1.mPlaceholderRequired = true;
        v1.mIsExposed = false;
        v1.isDisplayBeyondScreen = false;
        v1.isDisplayBeyondSpecHeight = false;
        v1.mRetainLayout = true;
        v1.mTmpAspectRatio = Float.NaN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BaseCell createCell(@Nullable Card card, @NonNull MVHelper mVHelper, @NonNull BaseData baseData, @NonNull IServiceManager iServiceManager, boolean bl) {
        BaseData baseData2 = baseData;
        v.a(baseData2, (Object)"data is null when create cell!!!");
        BaseCell baseCell = null;
        String string2 = baseData2.getType();
        if (mVHelper.resolver().getViewClass(string2) == null && !Utils.isCard(baseData)) {
            BaseCell baseCell2;
            if (!iServiceManager.getService(BaseCellBinderResolver.class).has(string2)) return BaseCell.NaN;
            baseCell = baseCell2;
            new BaseCell((String)string2).serviceManager = iServiceManager;
            if (card != null) {
                baseCell.parent = card;
                baseCell.parentId = card.id;
                card.parseCell(mVHelper, baseData, baseCell, bl);
            } else {
                baseCell.parseWith(baseData, mVHelper);
            }
            BaseCell baseCell3 = baseCell;
            baseCell3.setStringType(string2);
            return baseCell3;
        }
        if (mVHelper.resolver().isCompatibleType(string2)) {
            baseCell = Utils.newInstance(mVHelper.resolver().getCellClass(string2));
            if (baseCell == null) {
                return BaseCell.NaN;
            }
            baseCell.serviceManager = iServiceManager;
        } else if (Utils.isCard(baseData)) {
            int n2 = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1533004560: {
                    if (!string2.equals("container-oneColumn")) break;
                    n2 = 1;
                    break;
                }
                case 910646644: {
                    if (!string2.equals("container-fiveColumn")) break;
                    n2 = 5;
                    break;
                }
                case 809074426: {
                    if (!string2.equals("container-flow")) break;
                    n2 = 0;
                    break;
                }
                case 762305352: {
                    if (!string2.equals("container-threeColumn")) break;
                    n2 = 3;
                    break;
                }
                case 495395225: {
                    if (!string2.equals("container-scroll")) break;
                    n2 = 7;
                    break;
                }
                case 6732280: {
                    if (!string2.equals("container-banner")) break;
                    n2 = 6;
                    break;
                }
                case -123807114: {
                    if (!string2.equals("container-twoColumn")) break;
                    n2 = 2;
                    break;
                }
                case -139342616: {
                    if (!string2.equals("container-fourColumn")) break;
                    n2 = 4;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 7: {
                    LinearScrollCard linearScrollCard;
                    LinearScrollCard linearScrollCard2 = linearScrollCard;
                    linearScrollCard2();
                    linearScrollCard2.serviceManager = iServiceManager;
                    linearScrollCard.parseWith((BaseCardData)baseData, mVHelper);
                    if (linearScrollCard.getCells().size() <= 0) break;
                    baseCell = linearScrollCard2.getCells().get(0);
                    break;
                }
                case 6: {
                    BannerCard bannerCard;
                    BannerCard bannerCard2 = bannerCard;
                    bannerCard2();
                    bannerCard2.serviceManager = iServiceManager;
                    bannerCard.parseWith((BaseCardData)baseData, mVHelper);
                    if (bannerCard.getCells().size() <= 0) break;
                    baseCell = bannerCard2.getCells().get(0);
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    Card card2 = (Card)iServiceManager.getService(CardResolver.class).create(string2);
                    card2.serviceManager = iServiceManager;
                    card2.parseWith((BaseCardData)baseData, mVHelper);
                    card.addChildCard(card2);
                }
            }
            if (baseCell == null) return BaseCell.NaN;
            baseCell.serviceManager = iServiceManager;
            if (card != null) {
                baseCell.parent = card;
                baseCell.parentId = card.id;
            }
        } else {
            BaseCell baseCell4;
            baseCell = baseCell4;
            new BaseCell((String)string2).serviceManager = iServiceManager;
            if (card != null) {
                baseCell.parent = card;
                baseCell.parentId = card.id;
            }
        }
        if (card != null) {
            card.parseCell(mVHelper, baseData, baseCell, bl);
        } else {
            baseCell.parseWith(baseData, mVHelper);
        }
        BaseCell baseCell5 = baseCell;
        baseCell5.setStringType(string2);
        return baseCell5;
    }

    private MVHelper getMVHelper() {
        IServiceManager iServiceManager = ((Card)((Object)iServiceManager)).serviceManager;
        if (iServiceManager != null) {
            return iServiceManager.getService(MVHelper.class);
        }
        return null;
    }

    private void adjustPendingCells(boolean bl) {
        Object object;
        if (this.mPendingCells.size() > 0) {
            Card card = this;
            Collections.sort(card.mPendingCells, CellPositionComparator.COMPARATOR);
            object = card.mPendingCells.iterator();
            while (object.hasNext()) {
                BaseCell baseCell = object.next();
                int n2 = baseCell.position;
                if (n2 < 0) continue;
                if (n2 >= this.mCells.size()) break;
                Card card2 = this;
                card2.mCells.add(baseCell.position, baseCell);
                card2.mInQueueCells.add(baseCell);
                object.remove();
                if (bl) continue;
                baseCell.added();
            }
        }
        if (this.mInQueueCells.size() > 0) {
            Card card = this;
            Collections.sort(card.mInQueueCells, CellPositionComparator.REVERSE_COMPARATOR);
            Iterator<BaseCell> iterator = card.mInQueueCells.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                int n3 = ((BaseCell)object).position;
                if (n3 < 0) continue;
                if (n3 <= this.mCells.size()) break;
                this.mPendingCells.add((BaseCell)object);
                iterator.remove();
            }
        }
        if (LogUtil.LOGGABLE && this.mPendingCells.size() > 0 && this.mInQueueCells.size() > 0) {
            List<BaseCell> list = this.mInQueueCells;
            if (this.mPendingCells.get((int)0).position < list.get((int)(list.size() - 1)).position) {
                LogUtil.e(TAG, "Items in pendingQueue must have large position than Items in queue!!!");
            }
        }
    }

    private void diffCells(@NonNull SparseArray<BaseCell> sparseArray, @NonNull SparseArray<BaseCell> sparseArray2) {
        int n2;
        if (!this.mIsActivated) {
            return;
        }
        int n3 = sparseArray.size();
        for (n2 = 0; n2 < n3; ++n2) {
            SparseArray<BaseCell> sparseArray3 = sparseArray;
            BaseCell baseCell = (BaseCell)sparseArray3.get(sparseArray3.keyAt(n2));
            if (baseCell == null) continue;
            baseCell.added();
        }
        int n4 = sparseArray2.size();
        for (n2 = 0; n2 < n4; ++n2) {
            SparseArray<BaseCell> sparseArray4 = sparseArray2;
            BaseCell baseCell = (BaseCell)sparseArray4.get(sparseArray4.keyAt(n2));
            if (baseCell == null) continue;
            baseCell.removed();
        }
    }

    public final LayoutHelper getLayoutHelper() {
        Card card = this;
        LayoutHelper layoutHelper = card.convertLayoutHelper(card.mLayoutHelper);
        Object object = card.style;
        if (object != null && layoutHelper != null) {
            LayoutHelper layoutHelper2 = layoutHelper;
            layoutHelper2.setZIndex(((Style)object).zIndex);
            if (layoutHelper2 instanceof BaseLayoutHelper) {
                object = (BaseLayoutHelper)layoutHelper;
                ((BaseLayoutHelper)object).setBgColor(this.style.bgColor);
                if (TextUtils.isEmpty((CharSequence)this.style.bgImgUrl) && this.style.bgImgId == -1) {
                    Object object2 = object;
                    ((BaseLayoutHelper)object2).setLayoutViewBindListener(null);
                    ((BaseLayoutHelper)object2).setLayoutViewUnBindListener(null);
                } else {
                    IServiceManager iServiceManager = this.serviceManager;
                    if (iServiceManager != null && iServiceManager.getService(CardSupport.class) != null) {
                        Object object3 = object;
                        object = this.serviceManager.getService(CardSupport.class);
                        Card card2 = this;
                        ((BaseLayoutHelper)object3).setLayoutViewBindListener(new BindListener(card2.style, (CardSupport)object){
                            final /* synthetic */ CardSupport val$support;
                            {
                                this.val$support = cardSupport;
                                super(style2);
                            }

                            @Override
                            public void onBind(View view, BaseLayoutHelper baseLayoutHelper) {
                                this.val$support.onBindBackgroundView(view, Card.this);
                            }
                        });
                        Card card3 = this;
                        ((BaseLayoutHelper)object3).setLayoutViewUnBindListener(new UnbindListener(card3.style, (CardSupport)object){
                            final /* synthetic */ CardSupport val$support;
                            {
                                this.val$support = cardSupport;
                                super(style2);
                            }

                            @Override
                            public void onUnbind(View view, BaseLayoutHelper baseLayoutHelper) {
                                this.val$support.onUnbindBackgroundView(view, Card.this);
                            }
                        });
                    } else {
                        Object object4 = object;
                        ((BaseLayoutHelper)object4).setLayoutViewBindListener(new BindListener(this.style));
                        ((BaseLayoutHelper)object4).setLayoutViewUnBindListener(new UnbindListener(this.style));
                    }
                }
                Float.isNaN(this.style.aspectRatio);
            }
            if (layoutHelper instanceof FixAreaLayoutHelper) {
                object = (FixAreaLayoutHelper)layoutHelper;
                final int n2 = 0;
                Object object5 = this.serviceManager;
                if (object5 != null && object5.getService(CardSupport.class) != null && (object5 = this.serviceManager.getService(CardSupport.class).onGetFixViewAppearAnimator(this)) != null) {
                    n2 = 1;
                    ((FixAreaLayoutHelper)object).setFixViewAnimatorHelper((FixAreaLayoutHelper.FixViewAnimatorHelper)object5);
                }
                if (n2 == 0 && (n2 = this.style.animationTime) > 0) {
                    FixAreaLayoutHelper.FixViewAnimatorHelper fixViewAnimatorHelper;
                    Object object6 = object;
                    object = fixViewAnimatorHelper;
                    fixViewAnimatorHelper = new FixAreaLayoutHelper.FixViewAnimatorHelper(){

                        @Override
                        public ViewPropertyAnimator onGetFixViewAppearAnimator(View view) {
                            View view2 = view;
                            int n22 = view2.getMeasuredHeight();
                            view2.setTranslationY((float)(-n22));
                            return view2.animate().translationYBy((float)n22).setDuration((long)n2);
                        }

                        @Override
                        public ViewPropertyAnimator onGetFixViewDisappearAnimator(View view) {
                            View view2 = view;
                            int n22 = view2.getMeasuredHeight();
                            return view2.animate().translationYBy((float)(-n22)).setDuration((long)n2);
                        }
                    };
                    ((FixAreaLayoutHelper)object6).setFixViewAnimatorHelper((FixAreaLayoutHelper.FixViewAnimatorHelper)object);
                }
            }
            if (layoutHelper instanceof MarginLayoutHelper) {
                MarginLayoutHelper marginLayoutHelper = (MarginLayoutHelper)layoutHelper;
                int n3 = this.style.margin[3];
                int n4 = this.style.margin[0];
                int n5 = this.style.margin[1];
                int n6 = this.style.margin[2];
                marginLayoutHelper.setMargin(n3, n4, n5, n6);
                n3 = this.style.padding[3];
                n4 = this.style.padding[0];
                n5 = this.style.padding[1];
                n6 = this.style.padding[2];
                marginLayoutHelper.setPadding(n3, n4, n5, n6);
            }
        }
        if (this.mRetainLayout) {
            this.mLayoutHelper = layoutHelper;
        }
        return layoutHelper;
    }

    @Nullable
    public LayoutHelper convertLayoutHelper(@Nullable LayoutHelper layoutHelper) {
        return null;
    }

    public void onBindCell(int n2, int n3, boolean bl) {
        if (!this.mIsExposed && this.serviceManager != null) {
            this.mIsExposed = true;
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onBindCell --> offset = " + n2 + ", position = " + n3 + ", showFromEnd = " + bl);
            }
        }
    }

    public BaseCell getCellById(String string2) {
        int n2 = this.mCells.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            BaseCell baseCell = this.mCells.get(i3);
            String string3 = baseCell.id;
            if (string3 == null || !string3.equals(string2)) continue;
            return baseCell;
        }
        return null;
    }

    public List<BaseCell> getCells() {
        return Collections.unmodifiableList(this.mCells);
    }

    public boolean isValid() {
        return !TextUtils.isEmpty((CharSequence)this.stringType) && this.serviceManager != null;
    }

    public void parseWith(@NonNull BaseCardData baseCardData, @NonNull MVHelper mVHelper) {
        this.parseWith(baseCardData, mVHelper, true);
    }

    public void parseWith(@NonNull BaseCardData baseCardData, @NonNull MVHelper mVHelper, boolean bl) {
        ArrayList<BaseData> arrayList;
        BaseCardData baseCardData2 = baseCardData;
        v.a(this.serviceManager, (Object)"serviceManager is null when parsing card!!!");
        v.a(baseCardData2, (Object)"data is null when parsing card!!!");
        this.originalData = baseCardData2;
        this.stringType = baseCardData.getType();
        this.id = baseCardData.getId();
        this.loadMore = baseCardData.isLoadMore();
        this.load = baseCardData.getLoad();
        this.loaded = baseCardData.isLoaded();
        this.maxChildren = baseCardData.getMaxChildren();
        if (bl) {
            this.parseHeaderCell(mVHelper, baseCardData.getHeadCell());
        }
        if ((arrayList = baseCardData.getCellList()) != null && bl) {
            int n2 = Math.min(arrayList.size(), this.maxChildren);
            for (int i3 = 0; i3 < n2; ++i3) {
                BaseData baseData = arrayList.get(i3);
                Card.createCell(this, mVHelper, baseData, this.serviceManager, true);
            }
        }
        if (bl) {
            this.parseFooterCell(mVHelper, baseCardData.getFootCell());
        }
        this.parseStyle(baseCardData);
    }

    protected void parseCell(@NonNull MVHelper mVHelper, @NonNull BaseData baseData, @NonNull BaseCell baseCell, boolean bl) {
        baseCell.parseWith(baseData, mVHelper);
        if (bl && !this.addCellInternal(baseCell, false) && LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "parseCell --> Parse invalid cell with data: " + baseData);
        }
    }

    public void setCells(@Nullable List<BaseCell> iterator) {
        int n2;
        BaseCell object2 = this.mPlaceholderCell;
        if (object2 != null) {
            this.mCells.remove(object2);
        }
        Card card = this;
        card.oldMap.clear();
        card.pendingDeleteMap.clear();
        for (BaseCell baseCell : card.mCells) {
            this.oldMap.put(System.identityHashCode(baseCell), (Object)baseCell);
        }
        this.mCells.clear();
        if (iterator != null) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                this.addCellInternal(iterator.next(), true);
            }
        }
        Card card2 = this;
        card2.adjustPendingCells(true);
        card2.newMap.clear();
        for (BaseCell<Object> baseCell : card2.mCells) {
            this.newMap.put(System.identityHashCode(baseCell), baseCell);
        }
        int n3 = this.oldMap.size();
        for (n2 = 0; n2 < n3; ++n2) {
            Card card3 = this;
            int n4 = card3.oldMap.keyAt(n2);
            if (card3.newMap.get(n4) == null) continue;
            Card card4 = this;
            card4.newMap.remove(n4);
            card4.pendingDeleteMap.put(n4, true);
        }
        int n5 = this.pendingDeleteMap.size();
        for (n2 = 0; n2 < n5; ++n2) {
            this.oldMap.remove(this.pendingDeleteMap.keyAt(n2));
        }
        Card card5 = this;
        SparseArray<BaseCell> sparseArray = card5.newMap;
        card5.diffCells(sparseArray, card5.oldMap);
        card5.newMap.clear();
        card5.oldMap.clear();
        card5.pendingDeleteMap.clear();
        if (card5.requirePlaceholderCell()) {
            this.mCells.add(this.mPlaceholderCell);
        }
    }

    public void addCell(@Nullable BaseCell baseCell) {
        Card card = this;
        card.addCellInternal(baseCell, false);
        card.adjustPendingCells(false);
        baseCell = card.mPlaceholderCell;
        if (baseCell != null) {
            this.mCells.remove(baseCell);
        }
        if (this.requirePlaceholderCell()) {
            this.mCells.add(this.mPlaceholderCell);
        }
    }

    public void addCells(@Nullable List<BaseCell> object) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                this.addCellInternal((BaseCell)object.next(), false);
            }
        }
        Card card = this;
        card.adjustPendingCells(false);
        object = card.mPlaceholderCell;
        if (object != null) {
            this.mCells.remove(object);
        }
        if (this.requirePlaceholderCell()) {
            this.mCells.add(this.mPlaceholderCell);
        }
    }

    public void addCells(Card componentLifecycle, int n2, @Nullable List<BaseCell> list) {
        if (list != null) {
            int n3 = 0;
            for (BaseCell baseCell : list) {
                this.addCellInternal((Card)componentLifecycle, n2 + n3, baseCell, false);
                ++n3;
            }
        }
        Card card = this;
        card.adjustPendingCells(false);
        componentLifecycle = card.mPlaceholderCell;
        if (componentLifecycle != null) {
            this.mCells.remove(componentLifecycle);
        }
        if (this.requirePlaceholderCell()) {
            this.mCells.add(this.mPlaceholderCell);
        }
    }

    public void removeAllCells() {
        int n2 = this.mCells.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            this.mCells.get(i3).onRemoved();
        }
        this.mCells.clear();
    }

    public boolean removeCell(@Nullable BaseCell baseCell) {
        if (baseCell == null) {
            return false;
        }
        boolean bl = this.mCells.remove(baseCell);
        if (bl) {
            baseCell.onRemoved();
        }
        this.notifyDataChange();
        return bl;
    }

    public boolean removeCellSilently(@Nullable BaseCell baseCell) {
        if (baseCell == null) {
            return false;
        }
        boolean bl = this.mCells.remove(baseCell);
        if (bl) {
            baseCell.onRemoved();
        }
        return bl;
    }

    public boolean replaceCell(@Nullable BaseCell baseCell, @Nullable BaseCell baseCell2) {
        if (baseCell != null && baseCell2 != null) {
            int n2 = this.mCells.indexOf(baseCell);
            if (n2 >= 0) {
                this.mCells.set(n2, baseCell2);
                baseCell2.onAdded();
                baseCell.onRemoved();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean addCellInternal(@Nullable BaseCell baseCell, boolean bl) {
        if (baseCell != null) {
            baseCell.parentId = componentLifecycle.id;
            baseCell.parent = componentLifecycle;
            baseCell.serviceManager = componentLifecycle.serviceManager;
            MVHelper mVHelper = componentLifecycle.getMVHelper();
            if (mVHelper != null && mVHelper.isValid(baseCell, componentLifecycle.serviceManager)) {
                if (baseCell.position >= 0 && !TextUtils.isEmpty((CharSequence)componentLifecycle.load)) {
                    baseCell.pos = baseCell.position;
                    componentLifecycle.mPendingCells.add(baseCell);
                    return true;
                }
                int n2 = componentLifecycle.mHeader != null ? componentLifecycle.mCells.size() + 1 : componentLifecycle.mCells.size();
                baseCell.pos = n2;
                if (!bl && componentLifecycle.mIsActivated) {
                    baseCell.added();
                }
                Card card = componentLifecycle;
                card.mCells.add(baseCell);
                ComponentLifecycle componentLifecycle = card.mFooter;
                if (componentLifecycle != null) {
                    ((BaseCell)componentLifecycle).pos = baseCell.pos + 1;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean addCellInternal(Card object, int n2, @Nullable BaseCell baseCell, boolean bl) {
        void var3_6;
        if (var3_6 != null) {
            MVHelper n3;
            var3_6.parentId = ((Card)((Object)n3)).id;
            var3_6.parent = n3;
            var3_6.serviceManager = this.serviceManager;
            n3 = this.getMVHelper();
            if (n3 != null && n3.isValid((BaseCell)var3_6, this.serviceManager)) {
                BaseCell baseCell2;
                void var2_5;
                void var4_7;
                if (var3_6.position >= 0 && !TextUtils.isEmpty((CharSequence)this.load)) {
                    var3_6.pos = var3_6.position;
                    this.mPendingCells.add((BaseCell)var3_6);
                    return true;
                }
                int baseCell22 = this.mHeader != null ? this.mCells.size() + 1 : this.mCells.size();
                var3_6.pos = baseCell22;
                if (var4_7 == false && this.mIsActivated) {
                    var3_6.added();
                }
                Card card = this;
                card.mCells.add((int)var2_5, (BaseCell)var3_6);
                BaseCell baseCell3 = card.mFooter;
                if (baseCell3 != null) {
                    baseCell3.pos = var3_6.pos + 1;
                }
                if ((baseCell2 = this.mHeader) != null) {
                    baseCell2.pos = 0;
                }
                return true;
            }
        }
        return false;
    }

    public void addChildCard(Card card) {
    }

    public void offsetChildCard(Card card, int n2) {
    }

    public void clearChildMap() {
    }

    public void storeAspectRatio() {
        Style style2 = this.style;
        if (style2 != null && !Float.isNaN(style2.aspectRatio)) {
            this.mTmpAspectRatio = this.style.aspectRatio;
            this.style.aspectRatio = Float.NaN;
        }
    }

    public void restoreAspectRatio() {
        if (this.style != null && !Float.isNaN(this.mTmpAspectRatio)) {
            this.style.aspectRatio = this.mTmpAspectRatio;
        }
    }

    public void enablePlaceholderView(View view, int n2) {
        if (!TextUtils.isEmpty((CharSequence)this.load) && view != null) {
            Card card = this;
            card.storeAspectRatio();
            card.mPlaceholderCell = new PlaceholderCell(n2, view);
            if (card.mCells.size() == 0) {
                this.mCells.add(this.mPlaceholderCell);
            }
        } else {
            this.mCells.remove(this.mPlaceholderCell);
            this.mPlaceholderCell = null;
        }
    }

    public void showPlaceholderView(boolean bl) {
        this.mPlaceholderRequired = bl;
        if (!bl) {
            this.restoreAspectRatio();
        } else {
            this.storeAspectRatio();
        }
        if (!this.mCells.contains(this.mPlaceholderCell)) {
            if (this.requirePlaceholderCell()) {
                Card card = this;
                card.mCells.add(this.mPlaceholderCell);
                card.notifyDataChange();
            }
        } else if (!this.requirePlaceholderCell() && this.mCells.remove(this.mPlaceholderCell)) {
            this.notifyDataChange();
        }
    }

    public BaseCell getPlaceholderCell() {
        return this.mPlaceholderCell;
    }

    public boolean requirePlaceholderCell() {
        return this.mPlaceholderRequired && this.mPlaceholderCell != null && !TextUtils.isEmpty((CharSequence)this.load) && (this.mCells.size() == 0 || this.mCells.size() == 1 && this.mCells.contains(this.mPlaceholderCell));
    }

    public final void notifyDataChange() {
        IServiceManager iServiceManager = ((Card)((Object)iServiceManager)).serviceManager;
        if (iServiceManager instanceof Engine) {
            ((Engine)iServiceManager).refresh();
        }
    }

    public Card findChildCardById(String string2) {
        if (!this.mChildren.isEmpty()) {
            int n2 = this.mChildren.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                Card card = (Card)this.mChildren.valueAt(i3);
                if (card == null || !card.id.equals(string2)) continue;
                return card;
            }
        }
        return null;
    }

    public ArrayMap<Range<Integer>, Card> getChildren() {
        return this.mChildren;
    }

    @Override
    protected void onAdded() {
        Iterator<BaseCell> iterator = ((Card)((Object)iterator)).mCells.iterator();
        while (iterator.hasNext()) {
            ((BaseCell)iterator.next()).added();
        }
    }

    @Override
    protected void onRemoved() {
        Iterator<BaseCell> iterator = ((Card)((Object)iterator)).mCells.iterator();
        while (iterator.hasNext()) {
            ((BaseCell)iterator.next()).removed();
        }
    }

    protected void parseHeaderCell(@NonNull MVHelper mVHelper, @Nullable BaseData baseData) {
    }

    protected void parseFooterCell(@NonNull MVHelper mVHelper, @Nullable BaseData baseData) {
    }

    protected void parseStyle(@Nullable BaseData object) {
        if (object != null) {
            object = ((BaseData)object).getStyle();
        } else {
            Style style2;
            object = style2;
            style2 = new Style();
        }
        this.style = object;
    }

    public static final class NaNCard
    extends Card {
        @Override
        public boolean isValid() {
            return false;
        }
    }

    private static class CellPositionComparator
    implements Comparator<BaseCell> {
        public static final CellPositionComparator COMPARATOR = new CellPositionComparator(false);
        public static final CellPositionComparator REVERSE_COMPARATOR = new CellPositionComparator(true);
        private final int mLarge;
        private final int mSmall;

        /*
         * WARNING - void declaration
         */
        CellPositionComparator(boolean bl) {
            void var1_4;
            if (bl) {
                int n2 = -1;
            } else {
                boolean bl2 = true;
            }
            this.mLarge = var1_4;
            this.mSmall = -var1_4;
        }

        @Override
        public int compare(BaseCell baseCell, BaseCell baseCell2) {
            if (baseCell == null && baseCell2 == null) {
                return 0;
            }
            if (baseCell == null) {
                return this.mSmall;
            }
            if (baseCell2 == null) {
                return this.mLarge;
            }
            int n2 = baseCell.position;
            int n3 = baseCell2.position;
            return n2 < n3 ? this.mSmall : (n2 == n3 ? 0 : this.mLarge);
        }
    }

    public static final class PlaceholderCell
    extends BaseCell {
        private int mHeight;
        private final View mPlaceholderView;
        private final long mBgColor;

        public PlaceholderCell(int n2, int n3) {
            long l2 = n3;
            this(n2, null, l2);
        }

        public PlaceholderCell(int n2, View view) {
            this(n2, view, Long.MIN_VALUE);
        }

        public PlaceholderCell(int n2, View view, long l2) {
            Style style2;
            Style style3;
            PlaceholderCell placeholderCell = this;
            this.mHeight = 0;
            this.mHeight = n2;
            this.mPlaceholderView = view;
            placeholderCell.mBgColor = l2;
            Style style4 = style3 = style2;
            style4();
            this.style = style4;
            style3.height = this.mHeight;
            style2.bgColor = this.mBgColor;
            style2.display = "block";
            placeholderCell.stringType = "-1";
        }

        public void bindView(@NonNull View view) {
            View view2 = this.mPlaceholderView;
            if (view2 != null && view instanceof FrameLayout) {
                if (view2.getParent() instanceof FrameLayout) {
                    ((FrameLayout)this.mPlaceholderView.getParent()).removeView(this.mPlaceholderView);
                }
                ((FrameLayout)view).addView(this.mPlaceholderView);
            }
        }
    }

    public static class UnbindListener
    implements BaseLayoutHelper.LayoutViewUnBindListener {
        private final Style mStyle;

        public UnbindListener(Style style2) {
            this.mStyle = style2;
        }

        @Override
        public void onUnbind(View view, BaseLayoutHelper baseLayoutHelper) {
        }
    }

    public static class BindListener
    implements BaseLayoutHelper.LayoutViewBindListener {
        private final Style mStyle;

        public BindListener(Style style2) {
            this.mStyle = style2;
        }

        @Override
        public void onBind(View view, BaseLayoutHelper object) {
            object = this.mStyle;
            if (object != null) {
                if (!TextUtils.isEmpty((CharSequence)((Style)object).bgImgUrl)) {
                    boolean cfr_ignored_0 = view instanceof ImageView;
                } else if (this.mStyle.bgImgId != -1) {
                    View view2 = view;
                    view2.setBackgroundDrawable(view2.getContext().getResources().getDrawable(this.mStyle.bgImgId));
                }
            }
        }
    }
}

