/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete;

import com.baidu.navisdk.util.common.LogUtil;

public abstract class ComponentLifecycle {
    private static final String TAG = "ComponentLifecycle";
    public boolean mIsActivated = false;

    public void added() {
        if (this.mIsActivated && LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "added --> Component can not be added more than once");
            throw new IllegalStateException("Component can not be added more than once");
        }
        this.mIsActivated = true;
        this.onAdded();
    }

    public void removed() {
        if (!this.mIsActivated && LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "removed --> Component can not be removed more than once");
            throw new IllegalStateException("Component can not be removed more than once");
        }
        this.mIsActivated = false;
        this.onRemoved();
    }

    protected void onAdded() {
    }

    protected void onRemoved() {
    }
}

