/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.structure;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import com.baidu.navisdk.ui.widget.recyclerview.BaseCellData;
import com.baidu.navisdk.ui.widget.recyclerview.BaseData;
import com.baidu.navisdk.ui.widget.recyclerview.IServiceManager;
import com.baidu.navisdk.ui.widget.recyclerview.MVHelper;
import com.baidu.navisdk.ui.widget.recyclerview.OnCellClickListener;
import com.baidu.navisdk.ui.widget.recyclerview.Style;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.Card;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.ComponentLifecycle;
import com.baidu.navisdk.ui.widget.recyclerview.util.IInnerImageSetter;
import com.baidu.navisdk.util.common.v;
import java.util.concurrent.atomic.AtomicLong;

public class BaseCell<V extends View>
extends ComponentLifecycle
implements View.OnClickListener {
    public static final BaseCell NaN = new NaNBaseCell();
    private static final AtomicLong sIdGen = new AtomicLong();
    public static boolean sIsGenIds = false;
    public String stringType;
    @Nullable
    public String parentId;
    public Card parent;
    @Nullable
    public String id;
    public int pos;
    public int position = -1;
    @Nullable
    public Style style;
    public final long objectId;
    public BaseData originalData;
    private final ArrayMap<Integer, Integer> innerClickMap = new ArrayMap();
    public IServiceManager serviceManager;
    public boolean mIsExposed = false;
    private SparseArray<Object> mTag;
    public GridDisplayType gridDisplayType = GridDisplayType.inline;
    public int colSpan = 1;
    public ArrayMap<String, Object> extras = new ArrayMap();

    public BaseCell() {
        long l2 = sIsGenIds ? sIdGen.getAndIncrement() : 0L;
        this.objectId = l2;
    }

    public BaseCell(String string2) {
        this.setStringType(string2);
        long l2 = sIsGenIds ? sIdGen.getAndIncrement() : 0L;
        this.objectId = l2;
    }

    public void setStringType(String string2) {
        this.stringType = string2;
    }

    public void onClick(View view) {
        Object object = this.serviceManager;
        if (object != null && (object = object.getService(OnCellClickListener.class)) != null) {
            BaseCell baseCell = this;
            int n2 = baseCell.pos;
            if (baseCell.innerClickMap.containsKey((Object)view.hashCode())) {
                n2 = (Integer)this.innerClickMap.get((Object)view.hashCode());
            }
            object.onClick(view, this, n2);
        }
    }

    public void setOnClickListener(View view, int n2) {
        view.setOnClickListener((View.OnClickListener)n3);
        Integer n3 = view.hashCode();
        ((BaseCell)((Object)n3)).innerClickMap.put((Object)n3, (Object)n2);
    }

    public void clearClickListener(View view, int n2) {
        view.setOnClickListener(null);
        this.innerClickMap.remove((Object)view.hashCode());
    }

    public void parseWith(@NonNull BaseData baseData, @NonNull MVHelper mVHelper) {
        BaseData baseData2 = baseData;
        v.a(baseData2, (Object)"data should not be null!!!");
        if (baseData2 == null) {
            return;
        }
        this.originalData = baseData;
        this.id = baseData.getId();
        this.stringType = baseData.getType();
        this.style = baseData.getStyle();
        if (baseData instanceof BaseCellData) {
            this.position = ((BaseCellData)baseData).getPosition();
        }
    }

    public final void doLoadImageUrl(@NonNull ImageView imageView, @Nullable String string2) {
        IServiceManager iServiceManager = this.serviceManager;
        if (iServiceManager != null && iServiceManager.getService(IInnerImageSetter.class) != null) {
            this.serviceManager.getService(IInnerImageSetter.class).doLoadImageUrl(imageView, string2);
        }
    }

    public final void doLoadImageUrl(@NonNull ImageView imageView, @Nullable String string2, int n2) {
        IServiceManager iServiceManager = this.serviceManager;
        if (iServiceManager != null && iServiceManager.getService(IInnerImageSetter.class) != null) {
            this.serviceManager.getService(IInnerImageSetter.class).doLoadImageUrl(imageView, string2, n2);
        }
    }

    public final void doLoadImageUrl(@NonNull ImageView imageView, @Nullable String string2, Drawable drawable2) {
        IServiceManager iServiceManager = this.serviceManager;
        if (iServiceManager != null && iServiceManager.getService(IInnerImageSetter.class) != null) {
            this.serviceManager.getService(IInnerImageSetter.class).doLoadImageUrl(imageView, string2, drawable2);
        }
    }

    public void bindView(@NonNull V v2) {
    }

    public void postBindView(@NonNull V v2) {
    }

    public void unbindView(@NonNull V v2) {
        this.clearClickListener((View)v2, 0);
    }

    public boolean isValid() {
        return true;
    }

    public void putExtra(String string2, Object object) {
        this.extras.put((Object)string2, object);
    }

    public Object getExtra(String string2) {
        return this.extras.get((Object)string2);
    }

    public Object getExtra(String string2, Object object) {
        if ((object2 = ((BaseCell)object2).getExtra(string2)) == null) {
            Object object2 = object;
        }
        return object2;
    }

    public <T> T getExtra(String string2, Class<T> clazz) {
        if (!clazz.isInstance(this = ((BaseCell)this).getExtra(string2))) {
            return null;
        }
        return clazz.cast(this);
    }

    public <T> T getExtra(String string2, Class<T> clazz, T t2) {
        if ((baseCell = baseCell.getExtra(string2, clazz)) == null) {
            BaseCell<Object> baseCell = t2;
        }
        return (T)baseCell;
    }

    public int getIntExtra(String string2) {
        return this.getIntExtra(string2, 0);
    }

    public int getIntExtra(String string2, int n2) {
        return this.getExtra(string2, Integer.class, n2);
    }

    public long getLongExtra(String string2) {
        return this.getLongExtra(string2, 0L);
    }

    public long getLongExtra(String string2, long l2) {
        return this.getExtra(string2, Long.class, l2);
    }

    public String getStringExtra(String string2) {
        return this.getStringExtra(string2, "");
    }

    public String getStringExtra(String string2, String string3) {
        return this.getExtra(string2, String.class, string3);
    }

    public boolean getBooleanExtra(String string2) {
        return this.getBooleanExtra(string2, false);
    }

    public boolean getBooleanExtra(String string2, boolean bl) {
        return this.getExtra(string2, Boolean.class, bl);
    }

    public static final class NaNBaseCell
    extends BaseCell {
        @Override
        public boolean isValid() {
            return false;
        }
    }

    public static final class GridDisplayType
    extends Enum<GridDisplayType> {
        public static final /* enum */ GridDisplayType inline;
        public static final /* enum */ GridDisplayType block;
        private static final /* synthetic */ GridDisplayType[] $VALUES;

        public static GridDisplayType[] values() {
            return (GridDisplayType[])$VALUES.clone();
        }

        public static GridDisplayType valueOf(String string2) {
            return Enum.valueOf(GridDisplayType.class, string2);
        }

        static {
            GridDisplayType gridDisplayType;
            inline = new GridDisplayType();
            GridDisplayType gridDisplayType2 = gridDisplayType;
            block = new GridDisplayType();
            $VALUES = new GridDisplayType[]{inline, gridDisplayType2};
        }
    }
}

