/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.structure;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.navisdk.util.common.LogUtil;
import java.lang.reflect.InvocationTargetException;

public class ViewCreator<V extends View> {
    private static final String TAG = "ViewCreator";
    private Class<V> mClz;
    private V view;

    public ViewCreator(@NonNull Class<V> clazz) {
        this.mClz = clazz;
    }

    private void handleException(Exception exception) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "Exception when create instance: " + this.mClz.getCanonicalName() + "  exception: " + exception);
        }
        throw new RuntimeException(exception);
    }

    public V create(@NonNull Context context, ViewGroup viewGroup) {
        Class<V> clazz = this.mClz;
        Class[] classArray = new Class[1];
        classArray[0] = Context.class;
        View view = (View)clazz.getConstructor(classArray).newInstance(context);
        try {
            this.view = view;
            return (V)view;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.handleException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.handleException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            this.handleException(instantiationException);
        }
        throw new RuntimeException("Failed to create View of class: " + this.mClz.getName());
    }
}

