/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.structure.card;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseIntArray;
import com.baidu.navisdk.ui.widget.recyclerview.BaseCardData;
import com.baidu.navisdk.ui.widget.recyclerview.BaseCellData;
import com.baidu.navisdk.ui.widget.recyclerview.BaseData;
import com.baidu.navisdk.ui.widget.recyclerview.MVHelper;
import com.baidu.navisdk.ui.widget.recyclerview.Style;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.Card;
import com.baidu.navisdk.ui.widget.recyclerview.structure.BaseCell;
import com.baidu.navisdk.ui.widget.recyclerview.structure.cell.BannerCell;
import java.util.Collections;
import java.util.List;

public class BannerCard
extends Card {
    private BannerCell cell;

    @Override
    public void parseWith(@NonNull BaseCardData baseData, @NonNull MVHelper mVHelper) {
        BaseCellData baseCellData;
        if (this.cell == null) {
            BannerCell bannerCell;
            BannerCell bannerCell2 = bannerCell;
            bannerCell = new BannerCell();
            this.cell = bannerCell2;
        }
        BannerCard bannerCard = this;
        super.parseWith((BaseCardData)baseData, mVHelper);
        baseData = baseCellData;
        ((BaseCellData)baseData)("-2");
        baseCellData.setId(this.id);
        baseCellData.setStyle(new Style());
        bannerCard.cell.parseWith(baseData, mVHelper);
        if (!super.getCells().isEmpty()) {
            BannerCard bannerCard2 = this;
            bannerCard2.cell.mCells.addAll(super.getCells());
            super.setCells(Collections.singletonList(bannerCard2.cell));
        }
    }

    @Override
    protected void parseHeaderCell(@NonNull MVHelper mVHelper, @Nullable BaseData baseData) {
        if (baseData == null) {
            return;
        }
        this.cell.mHeader = Card.createCell(this, mVHelper, baseData, this.serviceManager, false);
        if (this.cell.mHeader.isValid()) {
            BaseCell baseCell = this.cell.mHeader;
            baseCell.parent = this;
            baseCell.parentId = this.id;
            baseCell.pos = 0;
        }
    }

    @Override
    protected void parseFooterCell(@NonNull MVHelper object, @Nullable BaseData baseData) {
        if (baseData == null) {
            return;
        }
        this.cell.mFooter = Card.createCell(this, (MVHelper)object, baseData, this.serviceManager, false);
        if (this.cell.mFooter.isValid()) {
            BannerCell bannerCell = this.cell;
            object = bannerCell.mFooter;
            ((BaseCell)object).parent = this;
            bannerCell.mFooter.parentId = this.id;
            int n2 = bannerCell.mHeader.isValid() ? this.getCells().size() + 1 : this.getCells().size();
            ((BaseCell)object).pos = n2;
        }
    }

    @Override
    public void setCells(@Nullable List<BaseCell> list) {
        if (list != null && !list.isEmpty()) {
            BannerCard bannerCard = this;
            super.setCells(Collections.singletonList(bannerCard.cell));
            bannerCard.cell.setData(list);
        } else {
            super.setCells(null);
        }
        this.notifyDataChange();
    }

    @Override
    public void parseStyle(@Nullable BaseData object) {
        super.parseStyle((BaseData)object);
        if (object == null) {
            return;
        }
        if (((BaseData)object).getStyle() instanceof BannerStyle) {
            BannerCard bannerCard = bannerStyle;
            BannerStyle bannerStyle = (BannerStyle)((BaseData)object).getStyle();
            bannerCard.cell.setIndicatorRadius(bannerStyle.indicatorRadius);
            bannerCard.cell.setIndicatorColor(bannerStyle.indicatorColor);
            bannerCard.cell.setIndicatorDefaultColor(bannerStyle.indicatorDefaultColor);
            bannerCard.cell.setAutoScrollInternal(bannerStyle.autoScrollInternal);
            bannerCard.cell.setSpecialInterval(bannerStyle.specialInterval);
            bannerCard.cell.setInfinite(bannerStyle.infinite);
            bannerCard.cell.setInfiniteMinCount(bannerStyle.infiniteMinCount);
            bannerCard.cell.setIndicatorFocus(bannerStyle.indicatorFocus);
            bannerCard.cell.setIndicatorNor(bannerStyle.indicatorNor);
            bannerCard.cell.setIndicatorGravity(bannerStyle.indicatorGravity);
            bannerCard.cell.setIndicatorPos(bannerStyle.indicatorPos);
            bannerCard.cell.setIndicatorGap(bannerStyle.indicatorGap);
            bannerCard.cell.setIndicatorMargin(bannerStyle.indicatorMargin);
            bannerCard.cell.setIndicatorHeight(bannerStyle.indicatorHeight);
            bannerCard.cell.setPageWidth(bannerStyle.pageWidth);
            bannerCard.cell.sethGap(bannerStyle.hGap);
            BannerCell bannerCell = bannerCard.cell;
            bannerCell.itemRatio = bannerStyle.itemRatio;
            object = bannerCell.itemMargin;
            object[0] = bannerStyle.itemMargin[0];
            bannerCell.itemMargin[1] = bannerStyle.itemMargin[1];
            bannerCell.setRatio(bannerStyle.aspectRatio);
            BannerCell bannerCell2 = bannerCard.cell;
            bannerCell2.margin = bannerStyle.margin;
            bannerCell2.height = bannerStyle.height;
        }
    }

    public static class BannerStyle
    extends Style {
        public int indicatorRadius;
        public int indicatorColor;
        public int indicatorDefaultColor;
        public int autoScrollInternal;
        public SparseIntArray specialInterval;
        public boolean infinite;
        public int infiniteMinCount;
        public String indicatorFocus;
        public String indicatorNor;
        public String indicatorGravity;
        public String indicatorPos;
        public int indicatorGap;
        public int indicatorMargin;
        public int indicatorHeight;
        public float pageWidth = Float.NaN;
        public int hGap;
        public int[] itemMargin = new int[2];
        public double itemRatio = Double.NaN;
    }
}

