/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.structure.card;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.BaseData;
import com.baidu.navisdk.ui.widget.recyclerview.MVHelper;
import com.baidu.navisdk.ui.widget.recyclerview.Style;
import com.baidu.navisdk.ui.widget.recyclerview.dataparser.concrete.Card;
import com.baidu.navisdk.ui.widget.recyclerview.structure.BaseCell;
import com.baidu.navisdk.ui.widget.recyclerview.support.CardSupport;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.BaseLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.GridLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.RangeGridLayoutHelper;
import java.util.List;

public class GridCard
extends Card {
    private static final String TAG = "GridCard";
    private int mColumn = 0;

    public GridCard() {
    }

    public GridCard(int n2) {
        this.mColumn = n2;
    }

    private void convertChildLayoutHelper(@Nullable RangeGridLayoutHelper rangeGridLayoutHelper, GridCard gridCard) {
        int n2 = gridCard.getChildren().size();
        for (int i3 = 0; i3 < n2; ++i3) {
            RangeGridLayoutHelper.GridRangeStyle gridRangeStyle;
            GridCard gridCard2 = gridCard;
            Range range = (Range)gridCard2.getChildren().keyAt(i3);
            Object object = (Card)gridCard2.getChildren().valueAt(i3);
            Style style2 = ((Card)object).style;
            if (!(style2 instanceof GridStyle) || !(object instanceof GridCard)) continue;
            Card card = object;
            object = (GridStyle)style2;
            GridCard gridCard3 = (GridCard)card;
            if (!gridCard3.getChildren().isEmpty()) {
                this.convertChildLayoutHelper(rangeGridLayoutHelper, gridCard3);
            }
            RangeGridLayoutHelper.GridRangeStyle gridRangeStyle2 = gridRangeStyle;
            gridRangeStyle = new RangeGridLayoutHelper.GridRangeStyle();
            int n3 = gridCard3.mColumn;
            int n4 = ((GridStyle)object).column;
            if (n4 > 0) {
                gridRangeStyle2.setSpanCount(n4);
            } else {
                gridRangeStyle2.setSpanCount(n3);
                n4 = n3;
            }
            gridRangeStyle2.setSpanSizeLookup(new CellSpanSizeLookup(gridCard3.getCells(), n4));
            gridRangeStyle2.setVGap(((GridStyle)object).vGap);
            gridRangeStyle2.setHGap(((GridStyle)object).hGap);
            gridRangeStyle2.setAutoExpand(((GridStyle)object).autoExpand);
            float[] fArray = ((GridStyle)object).cols;
            if (((GridStyle)object).cols != null && fArray.length > 0) {
                gridRangeStyle2.setWeights(fArray);
            }
            if (!Float.isNaN(((Style)object).aspectRatio)) {
                gridRangeStyle2.setAspectRatio(((Style)object).aspectRatio);
            }
            gridRangeStyle2.setBgColor(style2.bgColor);
            int n5 = style2.margin[3];
            n3 = style2.margin[0];
            n4 = style2.margin[1];
            int n6 = style2.margin[2];
            gridRangeStyle2.setMargin(n5, n3, n4, n6);
            n5 = style2.padding[3];
            n3 = style2.padding[0];
            n4 = style2.padding[1];
            n6 = style2.padding[2];
            gridRangeStyle2.setPadding(n5, n3, n4, n6);
            if (TextUtils.isEmpty((CharSequence)style2.bgImgUrl) && style2.bgImgId == -1) {
                RangeGridLayoutHelper.GridRangeStyle gridRangeStyle3 = gridRangeStyle2;
                gridRangeStyle3.setLayoutViewBindListener(null);
                gridRangeStyle3.setLayoutViewUnBindListener(null);
            } else {
                Object object2 = this.serviceManager;
                if (object2 != null && object2.getService(CardSupport.class) != null) {
                    RangeGridLayoutHelper.GridRangeStyle gridRangeStyle4 = gridRangeStyle2;
                    object2 = this.serviceManager.getService(CardSupport.class);
                    gridRangeStyle4.setLayoutViewBindListener(new Card.BindListener(style2, (CardSupport)object2, gridCard3){
                        final /* synthetic */ CardSupport val$support;
                        final /* synthetic */ GridCard val$gridCard;
                        {
                            this.val$support = cardSupport;
                            this.val$gridCard = gridCard2;
                            super(style2);
                        }

                        @Override
                        public void onBind(View view, BaseLayoutHelper baseLayoutHelper) {
                            this.val$support.onBindBackgroundView(view, this.val$gridCard);
                        }
                    });
                    gridRangeStyle4.setLayoutViewUnBindListener(new Card.UnbindListener(style2, (CardSupport)object2, gridCard3){
                        final /* synthetic */ CardSupport val$support;
                        final /* synthetic */ GridCard val$gridCard;
                        {
                            this.val$support = cardSupport;
                            this.val$gridCard = gridCard2;
                            super(style2);
                        }

                        @Override
                        public void onUnbind(View view, BaseLayoutHelper baseLayoutHelper) {
                            this.val$support.onUnbindBackgroundView(view, this.val$gridCard);
                        }
                    });
                } else {
                    Card.UnbindListener unbindListener;
                    Card.BindListener bindListener;
                    RangeGridLayoutHelper.GridRangeStyle gridRangeStyle5 = gridRangeStyle2;
                    object2 = bindListener;
                    bindListener = new Card.BindListener(style2);
                    gridRangeStyle5.setLayoutViewBindListener((BaseLayoutHelper.LayoutViewBindListener)object2);
                    object2 = unbindListener;
                    unbindListener = new Card.UnbindListener(style2);
                    gridRangeStyle5.setLayoutViewUnBindListener((BaseLayoutHelper.LayoutViewUnBindListener)object2);
                }
            }
            rangeGridLayoutHelper.addRangeStyle((Integer)range.getLower(), (Integer)range.getUpper(), gridRangeStyle2);
        }
    }

    private void ensureBlock(BaseCell baseCell) {
        if (baseCell != null && baseCell.isValid()) {
            if (baseCell.style == null) {
                Style style2;
                Style style3 = style2;
                style2 = new Style();
                baseCell.style = style3;
            }
            baseCell.style.putExtrasObject("display", "block");
            baseCell.style.display = "block";
        }
    }

    @Override
    protected void parseHeaderCell(@NonNull MVHelper mVHelper, @Nullable BaseData baseData) {
        if (baseData == null) {
            return;
        }
        GridCard gridCard = this;
        gridCard.ensureBlock(Card.createCell(gridCard, mVHelper, baseData, this.serviceManager, true));
    }

    @Override
    protected void parseFooterCell(@NonNull MVHelper mVHelper, @Nullable BaseData baseData) {
        if (baseData == null) {
            return;
        }
        GridCard gridCard = this;
        gridCard.ensureBlock(Card.createCell(gridCard, mVHelper, baseData, this.serviceManager, true));
    }

    @Override
    public void addChildCard(Card card) {
        if (card == null) {
            return;
        }
        List<BaseCell> list = card.getCells();
        if (list != null && !list.isEmpty()) {
            GridCard gridCard = this;
            gridCard.addCells(card.getCells());
            List<BaseCell> list2 = list;
            int n2 = this.mCells.indexOf(list2.get(list2.size() - 1));
            Range<Integer> range = Range.create(gridCard.mCells.indexOf(list.get(0)), n2);
            gridCard.mChildren.put(range, (Object)card);
        }
    }

    @Override
    public void offsetChildCard(Card card, int n2) {
        ArrayMap arrayMap;
        if (card == null) {
            return;
        }
        ArrayMap arrayMap2 = arrayMap;
        arrayMap = new ArrayMap();
        boolean bl = false;
        int n3 = this.mChildren.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            GridCard gridCard = this;
            Range range = (Range)gridCard.mChildren.keyAt(i3);
            Card card2 = (Card)gridCard.mChildren.valueAt(i3);
            if (card2 == card) {
                arrayMap2.put(Range.create(Integer.valueOf((Integer)range.getLower()), (Integer)range.getUpper() + n2), (Object)card2);
                bl = true;
                continue;
            }
            if (bl) {
                arrayMap2.put(Range.create((Integer)range.getLower() + n2, (Integer)range.getUpper() + n2), (Object)card2);
                continue;
            }
            arrayMap2.put((Object)range, (Object)card2);
        }
        GridCard gridCard = this;
        gridCard.mChildren.clear();
        gridCard.mChildren.putAll((SimpleArrayMap)arrayMap2);
    }

    @Override
    public void clearChildMap() {
        this.mChildren.clear();
    }

    public void clearCells() {
        this.mCells.clear();
    }

    @Override
    protected void parseStyle(@Nullable BaseData object) {
        if (object != null && ((BaseData)object).getStyle() instanceof GridStyle) {
            this.style = ((BaseData)object).getStyle();
        } else {
            GridStyle gridStyle;
            object = gridStyle;
            gridStyle = new GridStyle();
            this.style = object;
        }
        object = this.style;
        if (((GridStyle)object).column > 0) {
            this.mColumn = ((GridStyle)object).column;
        }
    }

    @Override
    public boolean isValid() {
        return super.isValid() && (((GridCard)this).mColumn > 0 || (this = ((Card)this).style) instanceof GridStyle && ((GridStyle)this).column > 0);
    }

    @Override
    @Nullable
    public LayoutHelper convertLayoutHelper(@Nullable LayoutHelper layoutHelper) {
        RangeGridLayoutHelper rangeGridLayoutHelper;
        layoutHelper = rangeGridLayoutHelper;
        ((RangeGridLayoutHelper)layoutHelper)(1, this.mCells.size());
        ((BaseLayoutHelper)layoutHelper).setItemCount(this.mCells.size());
        rangeGridLayoutHelper.setSpanCount(this.mColumn);
        Style style2 = this.style;
        if (style2 instanceof GridStyle) {
            style2 = (GridStyle)style2;
            int n2 = this.mColumn;
            int n3 = ((GridStyle)style2).column;
            if (n3 > 0) {
                ((RangeGridLayoutHelper)layoutHelper).setSpanCount(n3);
            } else {
                n3 = n2;
            }
            ((RangeGridLayoutHelper)layoutHelper).setSpanSizeLookup(new CellSpanSizeLookup(this.mCells, n3));
            ((RangeGridLayoutHelper)layoutHelper).setVGap(((GridStyle)style2).vGap);
            ((RangeGridLayoutHelper)layoutHelper).setHGap(((GridStyle)style2).hGap);
            ((RangeGridLayoutHelper)layoutHelper).setAutoExpand(((GridStyle)style2).autoExpand);
            float[] fArray = ((GridStyle)style2).cols;
            if (((GridStyle)style2).cols != null && fArray.length > 0) {
                ((RangeGridLayoutHelper)layoutHelper).setWeights(fArray);
            }
            if (!Float.isNaN(style2.aspectRatio)) {
                ((RangeGridLayoutHelper)layoutHelper).setAspectRatio(style2.aspectRatio);
            }
        }
        LayoutHelper layoutHelper2 = layoutHelper;
        ((RangeGridLayoutHelper)layoutHelper2).getRootRangeStyle().onClearChildMap();
        this.convertChildLayoutHelper((RangeGridLayoutHelper)layoutHelper2, this);
        return layoutHelper;
    }

    private static class ChildCardMap {
        private int lastIndex = -1;
        private int[] mOffsetMap = new int[1024];
        private Card[] mCardMap = new Card[1024];

        private ChildCardMap() {
        }

        public void addChild(int n2, int n3, Card card) {
            int n4 = this.lastIndex + 1;
            Object[] objectArray = this.mCardMap;
            if (n4 < this.mCardMap.length) {
                objectArray[n4] = card;
            } else {
                ChildCardMap childCardMap = this;
                n4 = objectArray.length;
                Card[] cardArray = new Card[n4 * 2];
                Card[] cardArray2 = cardArray;
                System.arraycopy(objectArray, 0, cardArray2, 0, n4);
                this.mCardMap = cardArray2;
                cardArray[n4] = card;
                int n5 = childCardMap.mOffsetMap.length;
                objectArray = new int[n5 * 2];
                System.arraycopy(childCardMap.mOffsetMap, 0, objectArray, 0, n5);
                childCardMap.mOffsetMap = (int[])objectArray;
            }
            this.lastIndex = n4;
            while (n2 <= n3) {
                this.mOffsetMap[n2] = n4;
                ++n2;
            }
        }

        public Card getChild(int n2) {
            return this.mCardMap[this.mOffsetMap[n2]];
        }
    }

    public static class CellSpanSizeLookup
    extends GridLayoutHelper.SpanSizeLookup {
        public static final String DISPLAY_INLINE = "inline";
        public static final String DISPLAY_BLOCK = "block";
        public static final String KEY_COLSPAN = "colspan";
        public static final String KEY_DISPLAY = "display";
        protected final List<BaseCell> mCells;
        private final int mTotalColumn;

        public CellSpanSizeLookup(List<BaseCell> list, int n2) {
            this.mCells = list;
            this.mTotalColumn = n2;
        }

        @Override
        public int getSpanSize(int n2) {
            if ((n2 -= this.getStartPosition()) >= 0 && n2 < this.mCells.size()) {
                Style style2;
                BaseCell baseCell = this.mCells.get(n2);
                if (baseCell != null && (style2 = baseCell.style) != null && style2.extras != null) {
                    style2.optExtrasInt(KEY_COLSPAN, 1);
                    if (TextUtils.equals((CharSequence)DISPLAY_BLOCK, (CharSequence)baseCell.style.optExtrasString(KEY_DISPLAY, DISPLAY_INLINE))) {
                        return this.mTotalColumn;
                    }
                    return baseCell.style.optExtrasInt(KEY_COLSPAN, 1);
                }
                return 1;
            }
            return 0;
        }
    }

    public static class GridStyle
    extends Style {
        public static final String KEY_COLUMN = "column";
        public static final String KEY_AUTO_EXPAND = "autoExpand";
        public static final String KEY_IGNORE_EXTRA = "ignoreExtra";
        public static final String KEY_H_GAP = "hGap";
        public static final String KEY_V_GAP = "vGap";
        public int vGap = 0;
        public int hGap = 0;
        public boolean autoExpand = false;
        public int column = 0;
        public float[] cols;
    }
}

