/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.widget.recyclerview.BaseData;
import com.baidu.navisdk.ui.widget.recyclerview.BinderViewHolder;
import com.baidu.navisdk.ui.widget.recyclerview.Style;
import com.baidu.navisdk.ui.widget.recyclerview.core.adapter.GroupBasicAdapter;
import com.baidu.navisdk.ui.widget.recyclerview.ext.BannerListener;
import com.baidu.navisdk.ui.widget.recyclerview.structure.BaseCell;
import com.baidu.navisdk.ui.widget.recyclerview.structure.cell.BannerCell;
import com.baidu.navisdk.ui.widget.recyclerview.structure.view.IRecyclerViewLifeCycle;
import com.baidu.navisdk.ui.widget.recyclerview.support.BannerSupport;
import com.baidu.navisdk.ui.widget.recyclerview.util.ImageUtils;
import com.baidu.navisdk.ui.widget.recyclerview.util.Utils;
import com.baidu.navisdk.ui.widget.recyclerview.view.BannerViewPager;
import com.baidu.navisdk.ui.widget.recyclerview.view.TimerHandler;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import java.util.ArrayList;
import java.util.List;

public class BannerView
extends ViewGroup
implements ViewPager.OnPageChangeListener,
TimerHandler.TimerHandlerListener,
IRecyclerViewLifeCycle {
    private static final String CURRENT_POS = "__current_pos__";
    public static final int GRAVITY_LEFT = 0;
    public static final int GRAVITY_CENTER = 1;
    public static final int GRAVITY_RIGHT = 2;
    private boolean isIndicatorOutside;
    private BannerViewPager mUltraViewPager;
    private BannerIndicator mIndicator;
    private int mIndicatorHeight;
    private int mIndicatorGap;
    private int mIndicatorMargin;
    private float xDown;
    private float yDown;
    private float ratio;
    private int height;
    private BaseCell cell;
    private BannerSupport bannerSupport;
    private final List<BinderViewHolder> mHeaderViewHolders;
    private final List<BinderViewHolder> mFooterViewHolders;
    private int currentItemPos;
    private boolean init;
    private int direction;
    private TimerHandler timer;
    private ScreenBroadcastReceiver mScreenBroadcastReceiver;
    private final IntentFilter filter;

    public BannerView(Context context) {
        this(context, null);
    }

    public BannerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BannerView(Context context, AttributeSet attributeSet, int n2) {
        IntentFilter intentFilter;
        ArrayList arrayList;
        ArrayList arrayList2;
        BannerView bannerView = object;
        super(context, attributeSet, n2);
        bannerView.mIndicatorHeight = -2;
        bannerView.mIndicatorGap = 12;
        bannerView.mIndicatorMargin = 20;
        bannerView.ratio = Float.NaN;
        bannerView.height = -2;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        bannerView.mHeaderViewHolders = object;
        object = arrayList;
        arrayList = new ArrayList();
        bannerView.mFooterViewHolders = object;
        object = intentFilter;
        intentFilter = new IntentFilter();
        bannerView.filter = object;
        bannerView.init();
    }

    private void init() {
        BannerView bannerView = this;
        this.mUltraViewPager = new BannerViewPager(this.getContext());
        this.mUltraViewPager.setId(R.id.RECYCLER_BANNER_ID);
        BannerView bannerView2 = this;
        bannerView.mIndicator = bannerView2.new BannerIndicator(bannerView2.getContext());
        bannerView.addView((View)bannerView.mUltraViewPager);
        bannerView.addView((View)bannerView.mIndicator);
        bannerView.mIndicator.setPadding(this.mIndicatorGap, 0, 0, 0);
        bannerView.mScreenBroadcastReceiver = new ScreenBroadcastReceiver(this);
        bannerView.filter.addAction("android.intent.action.SCREEN_ON");
        bannerView.filter.addAction("android.intent.action.SCREEN_OFF");
        bannerView.filter.addAction("android.intent.action.USER_PRESENT");
    }

    private int getIndicatorGravity(String string2) {
        if ("left".equals(string2)) {
            return 0;
        }
        if ("right".equals(string2)) {
            return 2;
        }
        return 1;
    }

    private void bindHeaderView(BaseCell object) {
        View view;
        if (object != null && ((BaseCell)object).isValid() && (view = object3.getHeaderViewFromRecycler((BaseCell)object)) != null) {
            Object object2 = view.getLayoutParams();
            if (object2 == null || !(object2 instanceof LayoutParams)) {
                LayoutParams layoutParams;
                object2 = layoutParams;
                layoutParams = new LayoutParams(-1, -2);
            }
            BannerView bannerView = object3;
            Object object3 = (LayoutParams)((Object)object2);
            object = ((BaseCell)object).style.margin;
            ((ViewGroup.MarginLayoutParams)object3).topMargin = (int)object[0];
            ((ViewGroup.MarginLayoutParams)object3).leftMargin = (int)object[3];
            ((ViewGroup.MarginLayoutParams)object3).bottomMargin = (int)object[2];
            ((LayoutParams)((Object)object2)).rightMargin = ((BaseCell)object).style.margin[1];
            bannerView.addView(view, (ViewGroup.LayoutParams)object2);
        }
    }

    private void bindFooterView(BaseCell object) {
        View view;
        if (object != null && ((BaseCell)object).isValid() && (view = object3.getFooterViewFromRecycler((BaseCell)object)) != null) {
            Object object2 = view.getLayoutParams();
            if (object2 == null || !(object2 instanceof LayoutParams)) {
                LayoutParams layoutParams;
                object2 = layoutParams;
                layoutParams = new LayoutParams(-1, -2);
            }
            BannerView bannerView = object3;
            Object object3 = (LayoutParams)((Object)object2);
            object = ((BaseCell)object).style.margin;
            ((ViewGroup.MarginLayoutParams)object3).topMargin = (int)object[0];
            ((ViewGroup.MarginLayoutParams)object3).leftMargin = (int)object[3];
            ((ViewGroup.MarginLayoutParams)object3).bottomMargin = (int)object[2];
            ((LayoutParams)((Object)object2)).rightMargin = ((BaseCell)object).style.margin[1];
            bannerView.addView(view, (ViewGroup.LayoutParams)object2);
        }
    }

    private View getHeaderViewFromRecycler(@NonNull BaseCell baseCell) {
        BaseCell baseCell2 = baseCell;
        GroupBasicAdapter groupBasicAdapter = baseCell2.serviceManager.getService(GroupBasicAdapter.class);
        int n2 = groupBasicAdapter.getItemType(baseCell);
        BinderViewHolder binderViewHolder = (BinderViewHolder)baseCell2.serviceManager.getService(RecyclerView.RecycledViewPool.class).getRecycledView(n2);
        if (binderViewHolder == null) {
            binderViewHolder = (BinderViewHolder)groupBasicAdapter.createViewHolder(this, n2);
        }
        binderViewHolder.bind(baseCell);
        this.mHeaderViewHolders.add(binderViewHolder);
        return binderViewHolder.itemView;
    }

    private View getFooterViewFromRecycler(@NonNull BaseCell baseCell) {
        BaseCell baseCell2 = baseCell;
        GroupBasicAdapter groupBasicAdapter = baseCell2.serviceManager.getService(GroupBasicAdapter.class);
        int n2 = groupBasicAdapter.getItemType(baseCell);
        BinderViewHolder binderViewHolder = (BinderViewHolder)baseCell2.serviceManager.getService(RecyclerView.RecycledViewPool.class).getRecycledView(n2);
        if (binderViewHolder == null) {
            binderViewHolder = (BinderViewHolder)groupBasicAdapter.createViewHolder(this, n2);
        }
        binderViewHolder.bind(baseCell);
        this.mFooterViewHolders.add(binderViewHolder);
        return binderViewHolder.itemView;
    }

    private void recycleView() {
        BannerView bannerView = this;
        bannerView.recyclerView(bannerView.mHeaderViewHolders);
        bannerView.recyclerView(bannerView.mFooterViewHolders);
    }

    private void recyclerView(List<BinderViewHolder> list) {
        if (!list.isEmpty()) {
            RecyclerView.RecycledViewPool recycledViewPool = this.cell.serviceManager.getService(RecyclerView.RecycledViewPool.class);
            int n2 = list.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                BinderViewHolder binderViewHolder = list.get(i3);
                binderViewHolder.unbind();
                this.removeView((View)binderViewHolder.itemView);
                recycledViewPool.putRecycledView((RecyclerView.ViewHolder)binderViewHolder);
            }
            list.clear();
        }
    }

    private void startTimer() {
        TimerHandler timerHandler = this.timer;
        if (timerHandler != null && this.mUltraViewPager != null && timerHandler.isStopped()) {
            BannerView bannerView = this;
            bannerView.timer.setListener(this);
            bannerView.timer.removeCallbacksAndMessages(null);
            bannerView.timer.tick(0);
            bannerView.timer.setStopped(false);
            return;
        }
    }

    private void stopTimer() {
        TimerHandler timerHandler = this.timer;
        if (timerHandler != null && this.mUltraViewPager != null && !timerHandler.isStopped()) {
            BannerView bannerView = this;
            bannerView.timer.removeCallbacksAndMessages(null);
            bannerView.timer.setListener(null);
            bannerView.timer.setStopped(true);
            return;
        }
    }

    private int getNextItemIndex() {
        return this.mUltraViewPager.getNextItem();
    }

    private BaseData getParentCardData() {
        return this.cell.parent.originalData;
    }

    private boolean scrollNextPage() {
        this.direction = 1;
        boolean bl = false;
        BannerViewPager bannerViewPager = this.mUltraViewPager;
        if (bannerViewPager != null && bannerViewPager.getAdapter() != null && this.mUltraViewPager.getAdapter().getCount() > 0) {
            int n2 = this.mUltraViewPager.getCurrentItemFake();
            int n3 = 0;
            if (n2 < this.mUltraViewPager.getAdapter().getCount() - 1) {
                n3 = n2 + 1;
                bl = true;
            }
            this.mUltraViewPager.setCurrentItemFake(n3, true);
        }
        return bl;
    }

    static /* synthetic */ BannerViewPager access$000(BannerView bannerView) {
        return bannerView.mUltraViewPager;
    }

    static /* synthetic */ int access$100(BannerView bannerView) {
        return bannerView.mIndicatorHeight;
    }

    static /* synthetic */ int access$200(BannerView bannerView) {
        return bannerView.mIndicatorMargin;
    }

    static /* synthetic */ int access$300(BannerView bannerView) {
        return bannerView.mIndicatorGap;
    }

    static /* synthetic */ boolean access$400(BannerView bannerView) {
        return bannerView.init;
    }

    public void setAdapter(PagerAdapter pagerAdapter) {
        BannerView bannerView = this;
        bannerView.mUltraViewPager.setAdapter(pagerAdapter);
        bannerView.disableAutoScroll();
        bannerView.mUltraViewPager.removeOnPageChangeListener(this);
        bannerView.mUltraViewPager.addOnPageChangeListener(this);
    }

    public void updateIndicators(String string2, String string3, int n2, int n3, int n4) {
        Object object = object.mIndicator;
        if (object != null) {
            ((BannerIndicator)((Object)object)).updateIndicators(string2, string3, n2, n3, n4);
        }
    }

    public void setIndicatorGravity(int n2) {
        Object object;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2 && (object = object.mIndicator) != null) {
                    object.setGravity(5);
                }
            } else {
                object = object.mIndicator;
                if (object != null) {
                    object.setGravity(1);
                }
            }
        } else {
            object = object.mIndicator;
            if (object != null) {
                object.setGravity(3);
            }
        }
    }

    public void setIndicatorPos(String string2) {
        this.isIndicatorOutside = "inside".equals(string2) ? false : "outside".equals(string2);
    }

    public void setIndicatorGap(int n2) {
        if (n2 >= 0) {
            this.mIndicatorGap = n2;
        }
    }

    public void setIndicatorMargin(int n2) {
        if (n2 > 0) {
            this.mIndicatorMargin = n2;
        }
    }

    public void setIndicatorHeight(int n2) {
        this.mIndicatorHeight = n2 > 0 ? n2 : -2;
    }

    public BannerViewPager getUltraViewPager() {
        return this.mUltraViewPager;
    }

    public void onPageScrolled(int n2, float f3, int n3) {
        Object object;
        int n4;
        if (this.bannerSupport != null) {
            for (n2 = 0; n2 < this.bannerSupport.getListeners().size(); ++n2) {
                BannerView bannerView = this;
                BaseData baseData = bannerView.getParentCardData();
                int n5 = bannerView.currentItemPos;
                n4 = bannerView.direction;
                this.bannerSupport.getListeners().get(n2).onPageScrolled(baseData, n5, f3, n3, n4);
            }
        }
        if ((object = this.bannerSupport) != null && (object = ((BannerSupport)object).getScrolledListenerById(this.cell.id)) != null) {
            for (int i3 = 0; i3 < object.size(); ++i3) {
                BannerView bannerView = this;
                BaseData baseData = bannerView.getParentCardData();
                n4 = bannerView.currentItemPos;
                int n6 = bannerView.direction;
                ((BannerListener)object.get(i3)).onPageScrolled(baseData, n4, f3, n3, n6);
            }
        }
    }

    public void onPageSelected(int n2) {
        Object object;
        Object object2;
        BannerView bannerView = this;
        bannerView.currentItemPos = n2 = bannerView.mUltraViewPager.getCurrentItem();
        bannerView.mIndicator.setCurrItem(n2);
        BaseCell baseCell = bannerView.cell;
        if (baseCell != null) {
            baseCell.putExtra(CURRENT_POS, this.currentItemPos);
        }
        if (this.bannerSupport != null) {
            for (int i3 = 0; i3 < this.bannerSupport.getListeners().size(); ++i3) {
                BannerView bannerView2 = this;
                object2 = bannerView2.getParentCardData();
                this.bannerSupport.getListeners().get(i3).onPageSelected((BaseData)object2, bannerView2.currentItemPos);
            }
        }
        if ((object = this.cell) != null && (object2 = this.bannerSupport) != null && (object = ((BannerSupport)object2).getSelectedListenerById(((BaseCell)object).id)) != null) {
            for (int i4 = 0; i4 < object.size(); ++i4) {
                BannerView bannerView3 = this;
                BaseData baseData = bannerView3.getParentCardData();
                ((BannerListener)object.get(i4)).onPageSelected(baseData, bannerView3.currentItemPos);
            }
        }
    }

    public void onPageScrollStateChanged(int n2) {
        Object object;
        if (this.bannerSupport != null) {
            for (int i3 = 0; i3 < this.bannerSupport.getListeners().size(); ++i3) {
                this.bannerSupport.getListeners().get(i3).onPageScrollStateChanged(this.getParentCardData(), n2);
            }
        }
        if ((object = this.bannerSupport) != null && (object = ((BannerSupport)object).getScrollStateChangedListenerById(this.cell.id)) != null) {
            for (int i4 = 0; i4 < object.size(); ++i4) {
                ((BannerListener)object.get(i4)).onPageScrollStateChanged(this.getParentCardData(), n2);
            }
        }
    }

    @Override
    public void cellInited(BaseCell baseCell) {
        boolean bl = this.cell != baseCell;
        BannerView bannerView = this;
        bannerView.init = bl;
        bannerView.cell = baseCell;
    }

    @Override
    public void postBindView(BaseCell baseCell) {
        float f3;
        long l2;
        int n2;
        int n3;
        BaseCell baseCell2 = baseCell;
        BannerView bannerView = this;
        Object object = bannerView.mScreenBroadcastReceiver;
        this.getContext().registerReceiver((BroadcastReceiver)object, bannerView.filter);
        object = (BannerCell)baseCell2;
        ((BannerCell)object).initAdapter();
        Style style2 = baseCell2.style;
        if (style2 != null) {
            int n4 = style2.padding[3];
            n3 = style2.padding[0];
            n2 = style2.padding[1];
            int n5 = style2.padding[2];
            this.setPadding(n4, n3, n2, n5);
        }
        if ((l2 = ((BannerCell)object).mBgColor) != Long.MIN_VALUE) {
            this.setBackgroundColor((int)l2);
        }
        BannerView bannerView2 = this;
        Object object2 = object;
        BannerView bannerView3 = this;
        bannerView3.setAdapter(((BannerCell)object).mBannerWrapper);
        bannerView3.mUltraViewPager.setAutoMeasureHeight(true);
        this.ratio = f3 = ((BannerCell)object).mRatio;
        this.height = ((BannerCell)object).height;
        this.mUltraViewPager.setRatio(f3);
        int n6 = ((BannerCell)object2).mAutoScrollInternal;
        bannerView2.setAutoScroll(n6, ((BannerCell)object2).mSpecialInterval);
        bannerView2.mUltraViewPager.setPageMargin(((BannerCell)object).hGap);
        if (((BannerCell)object).mCells.size() <= ((BannerCell)object).mInfiniteMinCount) {
            this.setInfiniteLoop(false);
        } else {
            this.setInfiniteLoop(((BannerCell)object).mInfinite);
        }
        BannerView bannerView4 = this;
        bannerView4.setIndicatorGravity(bannerView4.getIndicatorGravity(((BannerCell)object).mIndicatorGravity));
        this.setIndicatorPos(((BannerCell)object).mIndicatorPos);
        n6 = ((BannerCell)object).mIndicatorGap;
        if (n6 <= 0) {
            n6 = this.mIndicatorGap;
        }
        this.setIndicatorGap(n6);
        n6 = ((BannerCell)object).mIndicatorMargin;
        if (n6 <= 0) {
            n6 = this.mIndicatorMargin;
        }
        this.setIndicatorMargin(n6);
        this.setIndicatorHeight(((BannerCell)object).mIndicatorHeight);
        int[] nArray = ((BannerCell)object).itemMargin;
        if (((BannerCell)object).itemMargin[0] <= 0 && nArray[1] <= 0) {
            BannerView bannerView5 = this;
            bannerView5.setScrollMargin(0, 0);
            bannerView5.mUltraViewPager.setClipToPadding(true);
            bannerView5.mUltraViewPager.setClipChildren(true);
        } else {
            BannerView bannerView6 = this;
            int n7 = ((BannerCell)object).itemMargin[0];
            bannerView6.setScrollMargin(n7, ((BannerCell)object).itemMargin[1]);
            bannerView6.mUltraViewPager.setClipToPadding(false);
            bannerView6.mUltraViewPager.setClipChildren(false);
        }
        Object object3 = object;
        Object object4 = object;
        BannerView bannerView7 = this;
        Object object5 = object;
        BannerView bannerView8 = this;
        int n8 = ((BannerCell)object).margin[3];
        int n9 = ((BannerCell)object).margin[0];
        n3 = ((BannerCell)object).margin[1];
        n2 = ((BannerCell)object).margin[2];
        ((VirtualLayoutManager.LayoutParams)bannerView8.getLayoutParams()).setMargins(n8, n9, n3, n2);
        bannerView8.mUltraViewPager.setItemRatio(((BannerCell)object).itemRatio);
        this.currentItemPos = n8 = ((BaseCell)object).getIntExtra(CURRENT_POS);
        this.mUltraViewPager.setCurrentItem(n8);
        Object object6 = ((BannerCell)object5).mIndicatorFocus;
        object = ((BannerCell)object5).mIndicatorNor;
        n9 = ((BannerCell)object5).mIndicatorRadius;
        n3 = ((BannerCell)object5).mIndicatorColor;
        n2 = ((BannerCell)object5).mIndicatorDefaultColor;
        bannerView7.updateIndicators((String)object6, (String)object, n9, n3, n2);
        bannerView7.recycleView();
        this.bindHeaderView(((BannerCell)object4).mHeader);
        this.bindFooterView(((BannerCell)object3).mFooter);
        object6 = baseCell.serviceManager;
        if (object6 != null) {
            this.bannerSupport = object6.getService(BannerSupport.class);
        }
    }

    @Override
    public void postUnBindView(BaseCell baseCell) {
        BannerView bannerView = this;
        bannerView.recycleView();
        bannerView.getContext().unregisterReceiver((BroadcastReceiver)this.mScreenBroadcastReceiver);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected void onMeasure(int n2, int n3) {
        int n4;
        int n5;
        if (!Float.isNaN(this.ratio)) {
            n3 = View.MeasureSpec.makeMeasureSpec((int)((int)((float)View.MeasureSpec.getSize((int)n2) / this.ratio)), (int)0x40000000);
        } else {
            n5 = this.height;
            if (n5 > 0) {
                n3 = View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000);
            }
        }
        BannerView bannerView = this;
        bannerView.mUltraViewPager.measure(n2, n3);
        bannerView.mIndicator.measure(n2, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        n3 = 0;
        if (!bannerView.mHeaderViewHolders.isEmpty()) {
            n4 = this.mHeaderViewHolders.size();
            for (n5 = 0; n5 < n4; ++n5) {
                Object v2 = this.mHeaderViewHolders.get((int)n5).itemView;
                LayoutParams layoutParams = (LayoutParams)v2.getLayoutParams();
                v2.measure(n2, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                n3 += v2.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
        }
        n5 = 0;
        if (!this.mFooterViewHolders.isEmpty()) {
            int n6 = this.mFooterViewHolders.size();
            for (n4 = 0; n4 < n6; ++n4) {
                Object v3 = this.mFooterViewHolders.get((int)n4).itemView;
                LayoutParams layoutParams = (LayoutParams)v3.getLayoutParams();
                v3.measure(n2, View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                n5 += v3.getMeasuredHeight() + layoutParams.topMargin + layoutParams.bottomMargin;
            }
        }
        BannerView bannerView2 = this;
        n2 = bannerView2.mUltraViewPager.getMeasuredWidth();
        n4 = bannerView2.mUltraViewPager.getMeasuredHeight();
        if (bannerView2.isIndicatorOutside) {
            this.setMeasuredDimension(n2, n4 + this.mIndicator.getMeasuredHeight() + n3 + n5);
        } else {
            this.setMeasuredDimension(n2, n4 + n3 + n5);
        }
    }

    protected void onLayout(boolean n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        BannerView bannerView = this;
        n2 = bannerView.mUltraViewPager.getMeasuredWidth();
        n3 = bannerView.mUltraViewPager.getMeasuredHeight();
        n4 = bannerView.mIndicator.getMeasuredHeight();
        n5 = bannerView.getPaddingTop();
        n6 = bannerView.getPaddingLeft();
        if (!bannerView.mHeaderViewHolders.isEmpty()) {
            n9 = this.mHeaderViewHolders.size();
            for (n8 = 0; n8 < n9; ++n8) {
                Object v2 = this.mHeaderViewHolders.get((int)n8).itemView;
                LayoutParams layoutParams = (LayoutParams)v2.getLayoutParams();
                n7 = n6 + layoutParams.leftMargin;
                int n10 = n5 + layoutParams.topMargin;
                int n11 = v2.getMeasuredWidth();
                int n12 = n5 + layoutParams.topMargin + v2.getMeasuredHeight();
                v2.layout(n7, n10, n11, n12);
                n5 += layoutParams.topMargin + v2.getMeasuredHeight() + layoutParams.bottomMargin;
            }
        }
        BannerView bannerView2 = this;
        n8 = n5 + n3;
        bannerView2.mUltraViewPager.layout(n6, n5, n2, n8);
        if (bannerView2.isIndicatorOutside) {
            n3 = n8 + n3 + n4;
            this.mIndicator.layout(n6, n8, n2, n3);
            n8 += n4;
        } else {
            this.mIndicator.layout(n6, n8 - n4, n2, n8);
        }
        if (!this.mFooterViewHolders.isEmpty()) {
            n3 = this.mFooterViewHolders.size();
            for (n2 = 0; n2 < n3; ++n2) {
                int n13 = n8;
                Object v3 = this.mFooterViewHolders.get((int)n2).itemView;
                int n14 = n8;
                int n15 = n8;
                LayoutParams layoutParams = (LayoutParams)v3.getLayoutParams();
                n8 = n6 + layoutParams.leftMargin;
                n9 = n15 + layoutParams.topMargin;
                int n16 = v3.getMeasuredWidth();
                n7 = n14 + layoutParams.topMargin + v3.getMeasuredHeight();
                v3.layout(n8, n9, n16, n7);
                n8 = n13 + (layoutParams.topMargin + v3.getMeasuredHeight() + layoutParams.bottomMargin);
            }
        }
    }

    protected void onAttachedToWindow() {
        BannerView bannerView = this;
        super.onAttachedToWindow();
        bannerView.startTimer();
    }

    protected void onDetachedFromWindow() {
        BannerView bannerView = this;
        super.onDetachedFromWindow();
        bannerView.stopTimer();
    }

    protected void onVisibilityChanged(View view, int n2) {
        super.onVisibilityChanged(view, n2);
        if (n2 == 0) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
    }

    public void onStartTemporaryDetach() {
        BannerView bannerView = this;
        super.onStartTemporaryDetach();
        bannerView.stopTimer();
    }

    public void onFinishTemporaryDetach() {
        BannerView bannerView = this;
        super.onFinishTemporaryDetach();
        bannerView.startTimer();
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (this.timer != null) {
            int n2 = motionEvent.getAction();
            if (n2 == 0) {
                this.stopTimer();
            }
            if (n2 == 1 || n2 == 3) {
                this.startTimer();
            }
        }
        return super.dispatchTouchEvent(motionEvent);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        void var1_5;
        int n2 = var1_5.getAction();
        void v02 = var1_5;
        float f3 = v02.getRawX();
        float f4 = v02.getRawY();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    void var0_4;
                    int bl = (int)(f3 - this.xDown);
                    int n3 = (int)(f4 - this.yDown);
                    this.direction = -bl;
                    ViewParent viewParent = this.getParent();
                    if (Math.abs(bl) >= Math.abs(n3)) {
                        boolean bl2 = true;
                    } else {
                        boolean bl3 = false;
                    }
                    viewParent.requestDisallowInterceptTouchEvent((boolean)var0_4);
                }
            } else {
                this.direction = 1;
            }
        } else {
            BannerView bannerView = this;
            bannerView.xDown = f3;
            bannerView.yDown = f4;
        }
        return false;
    }

    @Override
    public int getNextItem() {
        return this.getNextItemIndex();
    }

    @Override
    public void callBack() {
        this.scrollNextPage();
    }

    public void setScrollMargin(int n2, int n3) {
        this.mUltraViewPager.setPadding(n2, 0, n3, 0);
    }

    public void setInfiniteLoop(boolean bl) {
        this.mUltraViewPager.setEnableLoop(bl);
    }

    public void setAutoScroll(int n2, SparseIntArray sparseIntArray) {
        TimerHandler timerHandler;
        if (n2 == 0) {
            return;
        }
        if (this.timer != null) {
            this.disableAutoScroll();
        }
        TimerHandler timerHandler2 = timerHandler;
        long l2 = n2;
        timerHandler2(this, l2);
        this.timer = timerHandler2;
        timerHandler.setSpecialInterval(sparseIntArray);
        this.startTimer();
    }

    public void disableAutoScroll() {
        this.stopTimer();
        this.timer = null;
    }

    private static class ScreenBroadcastReceiver
    extends BroadcastReceiver {
        private String action = null;
        private BannerView mBannerView = null;

        public ScreenBroadcastReceiver(BannerView bannerView) {
            this.mBannerView = bannerView;
        }

        public void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            this.action = object;
            if ("android.intent.action.SCREEN_ON".equals(object)) {
                this.mBannerView.startTimer();
            } else if ("android.intent.action.SCREEN_OFF".equals(this.action)) {
                this.mBannerView.stopTimer();
            } else if ("android.intent.action.USER_PRESENT".equals(this.action)) {
                this.mBannerView.startTimer();
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(@NonNull ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    class BannerIndicator
    extends LinearLayout {
        private final int STYLE_NONE;
        private final int STYLE_DOT;
        private final int STYLE_IMG;
        private ImageView[] mImageViews;
        private String focusUrl;
        private String norUrl;
        private int norColor;
        private int focusColor;
        private float radius;
        private int style;

        public BannerIndicator(Context context) {
            super(context);
            this.STYLE_NONE = 0;
            this.STYLE_DOT = 1;
            this.STYLE_IMG = 2;
        }

        private int getDefaultIndicatorDrawableId(boolean bl) {
            return bl ? R.drawable.nsdk_drawable_route_result_intelli_drive_page_indicator_selected : R.drawable.nsdk_drawable_route_result_intelli_drive_page_indicator_unselected;
        }

        private GradientDrawable getGradientDrawable(int n2, float f3) {
            BannerIndicator bannerIndicator = GradientDrawable.Orientation.BOTTOM_TOP;
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = n2;
            nArray[1] = n2;
            GradientDrawable gradientDrawable = new GradientDrawable((GradientDrawable.Orientation)bannerIndicator, nArray2);
            gradientDrawable.setShape(1);
            gradientDrawable.setCornerRadius(f3);
            return gradientDrawable;
        }

        /*
         * Unable to fully structure code
         */
        public void updateIndicators(String var1_1, String var2_2, int var3_4, int var4_7, int var5_10) {
            block29: {
                block30: {
                    if (BannerView.access$000(BannerView.this).getWrapperAdapter() == null) {
                        return;
                    }
                    v0 = this;
                    v0.focusUrl = var1_1;
                    v0.norUrl = var2_2;
                    v0.norColor = var5_10;
                    v0.focusColor = var4_7;
                    this.radius = var6_12 = (float)var3_4;
                    this.style = var5_10 != 0 && var4_7 != 0 && var3_4 > 0 ? 1 : (TextUtils.isEmpty((CharSequence)var1_1) == false && TextUtils.isEmpty((CharSequence)var2_2) == false ? 2 : 0);
                    if (this.style == 0) {
                        this.setVisibility(4);
                        return;
                    }
                    v1 = this;
                    v1.setVisibility(0);
                    var7_14 = 0;
                    var8_15 = 0;
                    var9_16 = v1.style;
                    if (var9_16 != 2) break block29;
                    var3_5 = Utils.getImageSize((String)var2_2);
                    var9_17 = Utils.getImageSize((String)var1_1);
                    if (var3_5 == null || var9_17 == null) break block30;
                    v2 = var3_5;
                    var3_6 = Math.max((Integer)v2.first, (Integer)var9_17.first);
                    var8_15 = var7_14 = Math.max((Integer)v2.second, (Integer)var9_17.second);
                    var7_14 = var3_6;
                    ** GOTO lbl-1000
                }
                if (var9_17 != null) {
                    v3 = var9_17;
                    var7_14 = (Integer)v3.first;
                    var8_15 = (Integer)v3.second;
                }
                if (var3_5 == null) ** GOTO lbl-1000
                v4 = var3_5;
                var7_14 = (Integer)v4.first;
                var8_15 = (Integer)v4.second;
                ** GOTO lbl-1000
            }
            if (var9_16 == 1) {
                var8_15 = var3_4 * 2;
                var3_4 = var8_15;
            } else lbl-1000:
            // 4 sources

            {
                var3_4 = var8_15;
                var8_15 = var7_14;
            }
            if (BannerView.access$100(BannerView.this) != -2 && BannerView.access$100(BannerView.this) > 0) {
                var3_4 = BannerView.access$100(BannerView.this);
            }
            v5 = this;
            var7_14 = BannerView.access$000(v5.BannerView.this).getWrapperAdapter().getCount();
            var9_18 = v5.mImageViews;
            if (v5.mImageViews == null) {
                this.mImageViews = new ImageView[var7_14];
                var7_14 = 0;
                while (true) {
                    var9_18 = this.mImageViews;
                    if (var7_14 < this.mImageViews.length) {
                        v6 = this;
                        var9_18[var7_14] = ImageUtils.createImageInstance(this.getContext());
                        v6.mImageViews[var7_14].setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                        v6.addView((View)v6.mImageViews[var7_14]);
                        var7_14 += 1;
                        continue;
                    }
                    break;
                }
            } else if (var9_18.length != var7_14) {
                for (var9_19 = 0; var9_19 < ((ImageView[])(var10_21 = this.mImageViews)).length; ++var9_19) {
                    this.removeView((View)var10_21[var9_19]);
                }
                v7 = var10_21;
                this.mImageViews = var9_18 = new ImageView[var7_14];
                var7_14 = Math.min(((ImageView[])v7).length, var7_14);
                System.arraycopy(v7, 0, var9_18, 0, var7_14);
                var7_14 = 0;
                while (true) {
                    var9_18 = this.mImageViews;
                    if (var7_14 >= this.mImageViews.length) break;
                    if (var9_18[var7_14] == null) {
                        var9_18[var7_14] = ImageUtils.createImageInstance(this.getContext());
                        this.mImageViews[var7_14].setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    }
                    v8 = this;
                    v8.addView((View)v8.mImageViews[var7_14]);
                    var7_14 += 1;
                }
            }
            var7_14 = BannerView.access$000(BannerView.this).getCurrentItem();
            var9_20 = 0;
            while (true) {
                var10_21 = this.mImageViews;
                if (var9_20 >= this.mImageViews.length) break;
                var10_21 = (LinearLayout.LayoutParams)var10_21[var9_20].getLayoutParams();
                var11_22 = this.style;
                if (var11_22 != 2 && var11_22 != 1) {
                    var10_21.setMargins(0, 0, 0, 0);
                } else {
                    v9 = this;
                    var11_22 = BannerView.access$200(v9.BannerView.this);
                    var12_23 = BannerView.access$300(v9.BannerView.this);
                    var13_24 = BannerView.access$200(v9.BannerView.this);
                    var10_21.setMargins(0, var11_22, var12_23, var13_24);
                    if (var8_15 > 0) {
                        var10_21.width = var8_15;
                    }
                    if (var3_4 > 0) {
                        var10_21.height = var3_4;
                    }
                }
                if (this.style == 1) {
                    var10_21 = this.mImageViews[var9_20];
                    var11_22 = var7_14 == var9_20 ? var4_7 : var5_10;
                    var10_21.setImageDrawable((Drawable)this.getGradientDrawable(var11_22, var6_12));
                }
                ++var9_20;
            }
            if (this.style == 2) {
                if (BannerView.access$400(BannerView.this)) {
                    for (var3_4 = 0; var3_4 < this.mImageViews.length; ++var3_4) {
                        if (BannerView.access$500(BannerView.this) != null) {
                            v10 = this;
                            var4_8 = BannerView.access$500(v10.BannerView.this);
                            var5_11 = v10.mImageViews[var3_4];
                            var6_13 = var7_14 == var3_4 ? var1_1 : var2_2;
                            var8_15 = var7_14 == var3_4 ? 1 : 0;
                            var4_7 = this.getDefaultIndicatorDrawableId((boolean)var8_15);
                            var4_8.doLoadImageUrl(var5_11, (String)var6_13, var4_7);
                        }
                        if (var3_4 != BannerView.access$600(BannerView.this)) continue;
                        this.mImageViews[var3_4].setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, (Object)BannerView.access$600(BannerView.this));
                    }
                } else {
                    for (var3_4 = 0; var3_4 < ((ImageView[])(var4_9 = this.mImageViews)).length; ++var3_4) {
                        if ((var4_9 = var4_9[var3_4]).getTag(R.id.RECYCLER_BANNER_INDICATOR_POS) == null) continue;
                        var4_9.setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, null);
                        if (BannerView.access$500(BannerView.this) == null) continue;
                        BannerView.access$500(BannerView.this).doLoadImageUrl(var4_9, (String)var2_2, this.getDefaultIndicatorDrawableId(false));
                    }
                    if (BannerView.access$600(BannerView.this) >= 0) {
                        var2_2 = this.mImageViews;
                        if (BannerView.access$600(BannerView.this) < this.mImageViews.length) {
                            var2_2[BannerView.access$600(BannerView.this)].setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, (Object)BannerView.access$600(BannerView.this));
                            if (BannerView.access$500(BannerView.this) != null) {
                                v11 = this;
                                this = v11.mImageViews[BannerView.access$600(BannerView.this)];
                                var2_3 = v11.getDefaultIndicatorDrawableId(true);
                                BannerView.access$500(BannerView.this).doLoadImageUrl((ImageView)this, (String)var1_1, var2_3);
                            }
                        }
                    }
                }
            }
        }

        public void setCurrItem(int n2) {
            if (bannerIndicator2.mImageViews != null) {
                Object object;
                int n3;
                for (n3 = 0; n3 < ((ImageView[])(object = bannerIndicator2.mImageViews)).length; ++n3) {
                    int n4 = bannerIndicator2.style;
                    if (n4 == 1) {
                        object = object[n3];
                        n4 = n2 == n3 ? bannerIndicator2.focusColor : bannerIndicator2.norColor;
                        object.setImageDrawable((Drawable)bannerIndicator2.getGradientDrawable(n4, bannerIndicator2.radius));
                        continue;
                    }
                    if (n4 != 2 || (object = object[n3]).getTag(R.id.RECYCLER_BANNER_INDICATOR_POS) == null) continue;
                    object.setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, null);
                    if (bannerIndicator2.BannerView.this.cell == null) continue;
                    ImageView imageView = object;
                    BannerIndicator bannerIndicator = bannerIndicator2;
                    object = bannerIndicator.norUrl;
                    bannerIndicator2.BannerView.this.cell.doLoadImageUrl(imageView, (String)object, bannerIndicator.getDefaultIndicatorDrawableId(false));
                }
                if (bannerIndicator2.BannerView.this.currentItemPos >= 0) {
                    Object object2 = bannerIndicator2.mImageViews;
                    if (bannerIndicator2.BannerView.this.currentItemPos < bannerIndicator2.mImageViews.length) {
                        object2[bannerIndicator2.BannerView.this.currentItemPos].setTag(R.id.RECYCLER_BANNER_INDICATOR_POS, (Object)bannerIndicator2.BannerView.this.currentItemPos);
                        if (bannerIndicator2.style == 2 && bannerIndicator2.BannerView.this.cell != null) {
                            BannerIndicator bannerIndicator = bannerIndicator2;
                            BannerIndicator bannerIndicator2 = bannerIndicator.mImageViews[bannerIndicator2.BannerView.this.currentItemPos];
                            object2 = bannerIndicator.focusUrl;
                            n3 = bannerIndicator.getDefaultIndicatorDrawableId(true);
                            bannerIndicator2.BannerView.this.cell.doLoadImageUrl((ImageView)bannerIndicator2, (String)object2, n3);
                        }
                    }
                }
            }
        }
    }
}

