/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Cantor;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutAdapter;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.SingleLayoutHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DelegateAdapter
extends VirtualLayoutAdapter<RecyclerView.ViewHolder> {
    @Nullable
    private AtomicInteger mIndexGen;
    private int mIndex = 0;
    private final boolean mHasConsistItemType;
    private SparseArray<Adapter> mItemTypeAry = new SparseArray();
    @NonNull
    private final List<Pair<AdapterDataObserver, Adapter>> mAdapters = new ArrayList<Pair<AdapterDataObserver, Adapter>>();
    private int mTotal = 0;
    private final SparseArray<Pair<AdapterDataObserver, Adapter>> mIndexAry = new SparseArray();
    private long[] cantorReverse = new long[2];

    public DelegateAdapter(VirtualLayoutManager virtualLayoutManager) {
        this(virtualLayoutManager, false, false);
    }

    public DelegateAdapter(VirtualLayoutManager virtualLayoutManager, boolean bl) {
        this(virtualLayoutManager, bl, false);
    }

    DelegateAdapter(VirtualLayoutManager object, boolean bl, boolean bl2) {
        super((VirtualLayoutManager)object);
        if (bl2) {
            AtomicInteger atomicInteger;
            object = atomicInteger;
            atomicInteger = new AtomicInteger(0);
            this.mIndexGen = object;
        }
        this.mHasConsistItemType = bl;
    }

    public static Adapter<? extends RecyclerView.ViewHolder> simpleAdapter(@NonNull View view) {
        return new SimpleViewAdapter(view);
    }

    public static Adapter<? extends RecyclerView.ViewHolder> simpleAdapter(@NonNull View view, @NonNull LayoutHelper layoutHelper) {
        return new SimpleViewAdapter(view, layoutHelper);
    }

    static /* synthetic */ int access$102(DelegateAdapter delegateAdapter, int n2) {
        delegateAdapter.mTotal = n2;
        return n2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
        if (adapter.mHasConsistItemType) {
            RecyclerView.Adapter adapter = (Adapter)((Object)adapter.mItemTypeAry.get(n2));
            if (adapter != null) {
                return adapter.onCreateViewHolder(viewGroup, n2);
            }
            return null;
        }
        DelegateAdapter delegateAdapter = adapter;
        Cantor.reverseCantor(n2, adapter.cantorReverse);
        int n3 = (int)delegateAdapter.cantorReverse[1];
        n2 = (int)delegateAdapter.cantorReverse[0];
        Adapter adapter = delegateAdapter.findAdapterByIndex(n3);
        if (adapter == null) {
            return null;
        }
        return adapter.onCreateViewHolder(viewGroup, n2);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n2) {
        if ((this = this.findAdapterByPosition(n2)) == null) {
            return;
        }
        Pair<AdapterDataObserver, Adapter> pair = this;
        ((Adapter)((Object)pair.second)).onBindViewHolder(viewHolder, n2 - ((AdapterDataObserver)((Object)this.first)).mStartPosition);
        ((Adapter)((Object)pair.second)).onBindViewHolderWithOffset(viewHolder, n2 - ((AdapterDataObserver)((Object)this.first)).mStartPosition, n2);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n2, List<Object> list) {
        if ((this = this.findAdapterByPosition(n2)) == null) {
            return;
        }
        Pair<AdapterDataObserver, Adapter> pair = this;
        ((Adapter)((Object)pair.second)).onBindViewHolder(viewHolder, n2 - ((AdapterDataObserver)((Object)this.first)).mStartPosition, list);
        ((Adapter)((Object)pair.second)).onBindViewHolderWithOffset(viewHolder, n2 - ((AdapterDataObserver)((Object)this.first)).mStartPosition, n2, list);
    }

    public int getItemCount() {
        return this.mTotal;
    }

    public int getItemViewType(int n2) {
        Pair<AdapterDataObserver, Adapter> pair = this.findAdapterByPosition(n2);
        if (pair == null) {
            return -1;
        }
        if ((n2 = ((Adapter)((Object)pair.second)).getItemViewType(n2 - ((AdapterDataObserver)((Object)pair.first)).mStartPosition)) < 0) {
            return n2;
        }
        if (this.mHasConsistItemType) {
            this.mItemTypeAry.put(n2, pair.second);
            return n2;
        }
        int n3 = ((AdapterDataObserver)((Object)pair.first)).mIndex;
        return (int)Cantor.getCantor(n2, n3);
    }

    public long getItemId(int n2) {
        if ((this = this.findAdapterByPosition(n2)) == null) {
            return -1L;
        }
        long l2 = ((Adapter)((Object)this.second)).getItemId(n2 - ((AdapterDataObserver)((Object)this.first)).mStartPosition);
        if (l2 < 0L) {
            return -1L;
        }
        return Cantor.getCantor(((AdapterDataObserver)((Object)this.first)).mIndex, l2);
    }

    public void setHasStableIds(boolean bl) {
    }

    public void onViewRecycled(RecyclerView.ViewHolder viewHolder) {
        super.onViewRecycled(viewHolder);
        int n2 = viewHolder.getPosition();
        if (n2 >= 0 && (this = this.findAdapterByPosition(n2)) != null) {
            ((Adapter)((Object)this.second)).onViewRecycled(viewHolder);
        }
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder viewHolder) {
        super.onViewAttachedToWindow(viewHolder);
        int n2 = viewHolder.getPosition();
        if (n2 >= 0 && (this = this.findAdapterByPosition(n2)) != null) {
            ((Adapter)((Object)this.second)).onViewAttachedToWindow(viewHolder);
        }
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder viewHolder) {
        super.onViewDetachedFromWindow(viewHolder);
        int n2 = viewHolder.getPosition();
        if (n2 >= 0 && (this = this.findAdapterByPosition(n2)) != null) {
            ((Adapter)((Object)this.second)).onViewDetachedFromWindow(viewHolder);
        }
    }

    @Override
    @Deprecated
    public void setLayoutHelpers(List<LayoutHelper> list) {
        throw new UnsupportedOperationException("DelegateAdapter doesn't support setLayoutHelpers directly");
    }

    public void setAdapters(@Nullable List<Adapter> linkedList) {
        LinkedList<LayoutHelper> linkedList2;
        this.clear();
        if (linkedList == null) {
            linkedList = Collections.emptyList();
        }
        List<Adapter> list = linkedList;
        linkedList = linkedList2;
        linkedList2 = new LinkedList<LayoutHelper>();
        boolean bl = true;
        this.mTotal = 0;
        Iterator<Adapter> iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2;
            DelegateAdapter delegateAdapter = this;
            Adapter adapter = iterator.next();
            int n3 = delegateAdapter.mTotal;
            AtomicInteger atomicInteger = delegateAdapter.mIndexGen;
            if (atomicInteger == null) {
                n2 = this.mIndex;
                this.mIndex = n2 + 1;
            } else {
                n2 = atomicInteger.incrementAndGet();
            }
            AdapterDataObserver adapterDataObserver = new AdapterDataObserver(n3, n2);
            adapter.registerAdapterDataObserver(adapterDataObserver);
            bl = bl && adapter.hasStableIds();
            DelegateAdapter delegateAdapter2 = this;
            LayoutHelper layoutHelper = adapter.onCreateLayoutHelper();
            layoutHelper.setItemCount(adapter.getItemCount());
            this.mTotal += layoutHelper.getItemCount();
            linkedList.add(layoutHelper);
            adapter = Pair.create((Object)((Object)adapterDataObserver), (Object)((Object)adapter));
            delegateAdapter2.mIndexAry.put(adapterDataObserver.mIndex, (Object)adapter);
            delegateAdapter2.mAdapters.add((Pair<AdapterDataObserver, Adapter>)adapter);
        }
        if (!this.hasObservers()) {
            super.setHasStableIds(bl);
        }
        super.setLayoutHelpers(linkedList);
    }

    public void addAdapters(int n2, @Nullable List<Adapter> object) {
        if (object != null && object.size() != 0) {
            ArrayList<Adapter> arrayList;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 > this.mAdapters.size()) {
                n2 = this.mAdapters.size();
            }
            ArrayList<Adapter> arrayList2 = arrayList;
            arrayList = new ArrayList<Adapter>();
            Iterator<Pair<AdapterDataObserver, Adapter>> iterator = this.mAdapters.iterator();
            while (iterator.hasNext()) {
                arrayList2.add((Adapter)((Object)iterator.next().second));
            }
            object = object.iterator();
            while (object.hasNext()) {
                arrayList2.add(n2, (Adapter)((Object)object.next()));
                ++n2;
            }
            this.setAdapters(arrayList2);
            return;
        }
    }

    public void addAdapters(@Nullable List<Adapter> list) {
        DelegateAdapter delegateAdapter = this;
        delegateAdapter.addAdapters(delegateAdapter.mAdapters.size(), list);
    }

    public void addAdapter(int n2, @Nullable Adapter adapter) {
        this.addAdapters(n2, Collections.singletonList(adapter));
    }

    public void addAdapter(@Nullable Adapter adapter) {
        this.addAdapters(Collections.singletonList(adapter));
    }

    public void removeFirstAdapter() {
        List<Pair<AdapterDataObserver, Adapter>> list = this.mAdapters;
        if (list != null && !list.isEmpty()) {
            DelegateAdapter delegateAdapter = this;
            delegateAdapter.removeAdapter((Adapter)((Object)delegateAdapter.mAdapters.get((int)0).second));
        }
    }

    public void removeLastAdapter() {
        List<Pair<AdapterDataObserver, Adapter>> list = this.mAdapters;
        if (list != null && !list.isEmpty()) {
            DelegateAdapter delegateAdapter = this;
            List<Pair<AdapterDataObserver, Adapter>> list2 = delegateAdapter.mAdapters;
            delegateAdapter.removeAdapter((Adapter)((Object)list2.get((int)(list2.size() - 1)).second));
        }
    }

    public void removeAdapter(int n2) {
        if (n2 >= 0 && n2 < this.mAdapters.size()) {
            DelegateAdapter delegateAdapter = this;
            delegateAdapter.removeAdapter((Adapter)((Object)delegateAdapter.mAdapters.get((int)n2).second));
        }
    }

    public void removeAdapter(@Nullable Adapter adapter) {
        if (adapter == null) {
            return;
        }
        this.removeAdapters(Collections.singletonList(adapter));
    }

    public void removeAdapters(@Nullable List<Adapter> arrayList) {
        if (arrayList != null && !arrayList.isEmpty()) {
            ArrayList<Adapter> arrayList2;
            LinkedList<LayoutHelper> linkedList;
            Object object = linkedList;
            linkedList = new LinkedList<LayoutHelper>(super.getLayoutHelpers());
            int n2 = arrayList.size();
            block0: for (int i3 = 0; i3 < n2; ++i3) {
                Adapter adapter = arrayList.get(i3);
                Iterator<Pair<AdapterDataObserver, Adapter>> iterator = this.mAdapters.iterator();
                while (iterator.hasNext()) {
                    Pair<AdapterDataObserver, Adapter> pair = iterator.next();
                    Adapter adapter2 = (Adapter)((Object)pair.second);
                    if (!((Object)((Object)adapter2)).equals((Object)adapter)) continue;
                    adapter2.unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)pair.first);
                    int n3 = this.findAdapterPositionByIndex(((AdapterDataObserver)((Object)pair.first)).mIndex);
                    if (n3 >= 0 && n3 < object.size()) {
                        object.remove(n3);
                    }
                    iterator.remove();
                    continue block0;
                }
            }
            arrayList = arrayList2;
            arrayList2 = new ArrayList<Adapter>();
            object = this.mAdapters.iterator();
            while (object.hasNext()) {
                arrayList.add((Adapter)((Object)((Pair)object.next()).second));
            }
            this.setAdapters(arrayList);
            return;
        }
    }

    public void clear() {
        this.mTotal = 0;
        this.mIndex = 0;
        AtomicInteger atomicInteger = this.mIndexGen;
        if (atomicInteger != null) {
            atomicInteger.set(0);
        }
        DelegateAdapter delegateAdapter = this;
        delegateAdapter.mLayoutManager.setLayoutHelpers(null);
        for (Pair pair : delegateAdapter.mAdapters) {
            ((Adapter)((Object)pair.second)).unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)pair.first);
        }
        DelegateAdapter delegateAdapter2 = this;
        delegateAdapter2.mItemTypeAry.clear();
        delegateAdapter2.mAdapters.clear();
        delegateAdapter2.mIndexAry.clear();
    }

    public int getAdaptersCount() {
        List<Pair<AdapterDataObserver, Adapter>> list = ((DelegateAdapter)((Object)list)).mAdapters;
        return list == null ? 0 : list.size();
    }

    public int findOffsetPosition(int n2) {
        if ((this = this.findAdapterByPosition(n2)) == null) {
            return -1;
        }
        return n2 - ((AdapterDataObserver)((Object)this.first)).mStartPosition;
    }

    @Nullable
    public Pair<AdapterDataObserver, Adapter> findAdapterByPosition(int n2) {
        Pair<AdapterDataObserver, Adapter> pair;
        block5: {
            Pair<AdapterDataObserver, Adapter> pair2;
            block4: {
                int n3 = this.mAdapters.size();
                if (n3 == 0) {
                    return null;
                }
                int n4 = n3;
                n3 = 0;
                int n5 = n4 - 1;
                while (true) {
                    pair2 = null;
                    if (n3 > n5) break block4;
                    int n6 = (n3 + n5) / 2;
                    pair = this.mAdapters.get(n6);
                    int n7 = ((AdapterDataObserver)((Object)pair.first)).mStartPosition + ((Adapter)((Object)pair.second)).getItemCount() - 1;
                    Object object = pair.first;
                    if (((AdapterDataObserver)((Object)object)).mStartPosition > n2) {
                        n5 = n6 - 1;
                        continue;
                    }
                    if (n7 < n2) {
                        n3 = n6 + 1;
                        continue;
                    }
                    if (((AdapterDataObserver)((Object)object)).mStartPosition <= n2 && n7 >= n2) break;
                }
                break block5;
            }
            pair = pair2;
        }
        return pair;
    }

    public int findAdapterPositionByIndex(int n2) {
        Pair pair = (Pair)this.mIndexAry.get(n2);
        return pair == null ? -1 : this.mAdapters.indexOf(pair);
    }

    public Adapter findAdapterByIndex(int n2) {
        return (Adapter)((Object)((Pair)this.mIndexAry.get((int)n2)).second);
    }

    public static abstract class Adapter<VH extends RecyclerView.ViewHolder>
    extends RecyclerView.Adapter<VH> {
        public abstract LayoutHelper onCreateLayoutHelper();

        protected void onBindViewHolderWithOffset(VH VH, int n2, int n3) {
        }

        protected void onBindViewHolderWithOffset(VH VH, int n2, int n3, List<Object> list) {
            this.onBindViewHolderWithOffset(VH, n2, n3);
        }
    }

    static class SimpleViewAdapter
    extends Adapter<RecyclerView.ViewHolder> {
        private View mView;
        private LayoutHelper mLayoutHelper;

        public SimpleViewAdapter(@NonNull View view, @NonNull LayoutHelper layoutHelper) {
            this.mView = view;
            this.mLayoutHelper = layoutHelper;
        }

        public SimpleViewAdapter(@NonNull View view) {
            SingleLayoutHelper singleLayoutHelper;
            SimpleViewAdapter simpleViewAdapter = object;
            Object object = singleLayoutHelper;
            singleLayoutHelper = new SingleLayoutHelper();
            simpleViewAdapter(view, (LayoutHelper)object);
        }

        @Override
        public LayoutHelper onCreateLayoutHelper() {
            return this.mLayoutHelper;
        }

        public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
            return new SimpleViewHolder(this.mView);
        }

        public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n2) {
        }

        public int getItemCount() {
            return 1;
        }
    }

    static class SimpleViewHolder
    extends RecyclerView.ViewHolder {
        public SimpleViewHolder(View view) {
            super(view);
        }
    }

    protected class AdapterDataObserver
    extends RecyclerView.AdapterDataObserver {
        int mStartPosition;
        int mIndex = -1;

        public AdapterDataObserver(int n2, int n3) {
            this.mStartPosition = n2;
            this.mIndex = n3;
        }

        private boolean updateLayoutHelper() {
            LinkedList<LayoutHelper> linkedList;
            int n2 = this.mIndex;
            if (n2 < 0) {
                return false;
            }
            if ((n2 = DelegateAdapter.this.findAdapterPositionByIndex(n2)) < 0) {
                return false;
            }
            Pair pair = (Pair)DelegateAdapter.this.mAdapters.get(n2);
            LinkedList<LayoutHelper> linkedList2 = linkedList;
            linkedList2(DelegateAdapter.this.getLayoutHelpers());
            LayoutHelper layoutHelper = (LayoutHelper)linkedList.get(n2);
            if (layoutHelper.getItemCount() != ((Adapter)((Object)pair.second)).getItemCount()) {
                layoutHelper.setItemCount(((Adapter)((Object)pair.second)).getItemCount());
                DelegateAdapter.access$102(DelegateAdapter.this, this.mStartPosition + ((Adapter)((Object)pair.second)).getItemCount());
                ++n2;
                while (n2 < DelegateAdapter.this.mAdapters.size()) {
                    AdapterDataObserver adapterDataObserver = this;
                    pair = (Pair)adapterDataObserver.DelegateAdapter.this.mAdapters.get(n2);
                    ((AdapterDataObserver)((Object)((Pair)adapterDataObserver.DelegateAdapter.this.mAdapters.get(n2)).first)).mStartPosition = DelegateAdapter.this.mTotal;
                    DelegateAdapter delegateAdapter = adapterDataObserver.DelegateAdapter.this;
                    DelegateAdapter.access$102(delegateAdapter, delegateAdapter.mTotal + ((Adapter)((Object)pair.second)).getItemCount());
                    ++n2;
                }
                DelegateAdapter.super.setLayoutHelpers(linkedList2);
            }
            return true;
        }

        public void updateStartPositionAndIndex(int n2, int n3) {
            AdapterDataObserver adapterDataObserver = this;
            adapterDataObserver.mStartPosition = n2;
            adapterDataObserver.mIndex = n3;
        }

        public int getStartPosition() {
            return this.mStartPosition;
        }

        public int getIndex() {
            return this.mIndex;
        }

        public void onChanged() {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyDataSetChanged();
        }

        public void onItemRangeRemoved(int n2, int n3) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemRangeRemoved(this.mStartPosition + n2, n3);
        }

        public void onItemRangeInserted(int n2, int n3) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemRangeInserted(this.mStartPosition + n2, n3);
        }

        public void onItemRangeMoved(int n2, int n3, int n4) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            int n5 = this.mStartPosition;
            int n6 = n5 + n2;
            DelegateAdapter.this.notifyItemMoved(n6, n5 + n3);
        }

        public void onItemRangeChanged(int n2, int n3) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemRangeChanged(this.mStartPosition + n2, n3);
        }

        public void onItemRangeChanged(int n2, int n3, Object object) {
            if (!this.updateLayoutHelper()) {
                return;
            }
            DelegateAdapter.this.notifyItemRangeChanged(this.mStartPosition + n2, n3, object);
        }
    }
}

