/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout;

import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.ExposeLinearLayoutManagerEx;

public abstract class OrientationHelperEx {
    private static final int INVALID_SIZE = Integer.MIN_VALUE;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    protected final ExposeLinearLayoutManagerEx mLayoutManager;
    private int mLastTotalSpace = Integer.MIN_VALUE;

    private OrientationHelperEx(ExposeLinearLayoutManagerEx exposeLinearLayoutManagerEx) {
        this.mLayoutManager = exposeLinearLayoutManagerEx;
    }

    public static OrientationHelperEx createOrientationHelper(ExposeLinearLayoutManagerEx exposeLinearLayoutManagerEx, int n2) {
        if (n2 != 0) {
            if (n2 == 1) {
                return OrientationHelperEx.createVerticalHelper(exposeLinearLayoutManagerEx);
            }
            throw new IllegalArgumentException("invalid orientation");
        }
        return OrientationHelperEx.createHorizontalHelper(exposeLinearLayoutManagerEx);
    }

    public static OrientationHelperEx createHorizontalHelper(ExposeLinearLayoutManagerEx exposeLinearLayoutManagerEx) {
        return new OrientationHelperEx(exposeLinearLayoutManagerEx){

            @Override
            public int getEndAfterPadding() {
                return this.mLayoutManager.getWidth() - this.mLayoutManager.getPaddingRight();
            }

            @Override
            public int getEnd() {
                return this.mLayoutManager.getWidth();
            }

            @Override
            public void offsetChildren(int n2) {
                this.mLayoutManager.offsetChildrenHorizontal(n2);
            }

            @Override
            public int getStartAfterPadding() {
                return this.mLayoutManager.getPaddingLeft();
            }

            @Override
            public int getDecoratedMeasurement(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                return !this.mLayoutManager.isEnableMarginOverLap() ? this.mLayoutManager.getDecoratedMeasuredWidth(view) + layoutParams.leftMargin + layoutParams.rightMargin : this.mLayoutManager.getDecoratedMeasuredWidth(view);
            }

            @Override
            public int getDecoratedMeasurementInOther(View view) {
                1 v02 = this_;
                1 this_ = (RecyclerView.LayoutParams)view.getLayoutParams();
                return v02.mLayoutManager.getDecoratedMeasuredHeight(view) + ((RecyclerView.LayoutParams)this_).topMargin + ((RecyclerView.LayoutParams)this_).bottomMargin;
            }

            @Override
            public int getDecoratedEnd(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                return !this.mLayoutManager.isEnableMarginOverLap() ? this.mLayoutManager.getDecoratedRight(view) + layoutParams.rightMargin : this.mLayoutManager.getDecoratedRight(view);
            }

            @Override
            public int getDecoratedStart(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                return !this.mLayoutManager.isEnableMarginOverLap() ? this.mLayoutManager.getDecoratedLeft(view) - layoutParams.leftMargin : this.mLayoutManager.getDecoratedLeft(view);
            }

            @Override
            public int getTotalSpace() {
                return this.mLayoutManager.getWidth() - this.mLayoutManager.getPaddingLeft() - this.mLayoutManager.getPaddingRight();
            }

            @Override
            public void offsetChild(View view, int n2) {
                view.offsetLeftAndRight(n2);
            }

            @Override
            public int getEndPadding() {
                return this.mLayoutManager.getPaddingRight();
            }
        };
    }

    public static OrientationHelperEx createVerticalHelper(ExposeLinearLayoutManagerEx exposeLinearLayoutManagerEx) {
        return new OrientationHelperEx(exposeLinearLayoutManagerEx){

            @Override
            public int getEndAfterPadding() {
                return this.mLayoutManager.getHeight() - this.mLayoutManager.getPaddingBottom();
            }

            @Override
            public int getEnd() {
                return this.mLayoutManager.getHeight();
            }

            @Override
            public void offsetChildren(int n2) {
                this.mLayoutManager.offsetChildrenVertical(n2);
            }

            @Override
            public int getStartAfterPadding() {
                return this.mLayoutManager.getPaddingTop();
            }

            @Override
            public int getDecoratedMeasurement(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                return !this.mLayoutManager.isEnableMarginOverLap() ? this.mLayoutManager.getDecoratedMeasuredHeight(view) + layoutParams.topMargin + layoutParams.bottomMargin : this.mLayoutManager.getDecoratedMeasuredHeight(view);
            }

            @Override
            public int getDecoratedMeasurementInOther(View view) {
                2 v02 = this_;
                2 this_ = (RecyclerView.LayoutParams)view.getLayoutParams();
                return v02.mLayoutManager.getDecoratedMeasuredWidth(view) + ((RecyclerView.LayoutParams)this_).leftMargin + ((RecyclerView.LayoutParams)this_).rightMargin;
            }

            @Override
            public int getDecoratedEnd(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                return !this.mLayoutManager.isEnableMarginOverLap() ? this.mLayoutManager.getDecoratedBottom(view) + layoutParams.bottomMargin : this.mLayoutManager.getDecoratedBottom(view);
            }

            @Override
            public int getDecoratedStart(View view) {
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                return !this.mLayoutManager.isEnableMarginOverLap() ? this.mLayoutManager.getDecoratedTop(view) - layoutParams.topMargin : this.mLayoutManager.getDecoratedTop(view);
            }

            @Override
            public int getTotalSpace() {
                return this.mLayoutManager.getHeight() - this.mLayoutManager.getPaddingTop() - this.mLayoutManager.getPaddingBottom();
            }

            @Override
            public void offsetChild(View view, int n2) {
                view.offsetTopAndBottom(n2);
            }

            @Override
            public int getEndPadding() {
                return this.mLayoutManager.getPaddingBottom();
            }
        };
    }

    public void onLayoutComplete() {
        this.mLastTotalSpace = this.getTotalSpace();
    }

    public int getTotalSpaceChange() {
        return Integer.MIN_VALUE == this.mLastTotalSpace ? 0 : this.getTotalSpace() - this.mLastTotalSpace;
    }

    public abstract int getDecoratedStart(View var1);

    public abstract int getDecoratedEnd(View var1);

    public abstract int getDecoratedMeasurement(View var1);

    public abstract int getDecoratedMeasurementInOther(View var1);

    public abstract int getStartAfterPadding();

    public abstract int getEndAfterPadding();

    public abstract int getEnd();

    public abstract void offsetChildren(int var1);

    public abstract int getTotalSpace();

    public abstract void offsetChild(View var1, int var2);

    public abstract int getEndPadding();
}

