/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout;

import android.os.Build;
import android.support.annotation.NonNull;
import java.util.Arrays;
import java.util.Objects;

public final class Range<T extends Comparable<? super T>> {
    private final T mLower;
    private final T mUpper;

    public Range(@NonNull T t2, @NonNull T t3) {
        if (t2 != null) {
            if (t3 != null) {
                this.mLower = t2;
                this.mUpper = t3;
                if (t2.compareTo(t3) <= 0) {
                    return;
                }
                throw new IllegalArgumentException("lower must be less than or equal to upper");
            }
            throw new IllegalArgumentException("upper must not be null");
        }
        throw new IllegalArgumentException("lower must not be null");
    }

    public static <T extends Comparable<? super T>> Range<T> create(T t2, T t3) {
        return new Range<T>(t2, t3);
    }

    public T getLower() {
        return this.mLower;
    }

    public T getUpper() {
        return this.mUpper;
    }

    public boolean contains(@NonNull T t2) {
        if (t2 != null) {
            boolean bl = t2.compareTo(this.mLower) >= 0;
            boolean bl2 = t2.compareTo(this.mUpper) <= 0;
            return bl && bl2;
        }
        throw new IllegalArgumentException("value must not be null");
    }

    public boolean contains(@NonNull Range<T> range) {
        if (range != null) {
            boolean bl = range.mLower.compareTo(this.mLower) >= 0;
            boolean bl2 = range.mUpper.compareTo(this.mUpper) <= 0;
            return bl && bl2;
        }
        throw new IllegalArgumentException("value must not be null");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof Range) {
            object = (Range)object;
            return this.mLower.equals(((Range)object).mLower) && this.mUpper.equals(((Range)object).mUpper);
        }
        return false;
    }

    public T clamp(T t2) {
        if (t2 != null) {
            if (t2.compareTo(this.mLower) < 0) {
                return this.mLower;
            }
            if (t2.compareTo(this.mUpper) > 0) {
                return this.mUpper;
            }
            return t2;
        }
        throw new IllegalArgumentException("value must not be null");
    }

    public Range<T> intersect(Range<T> range) {
        if (range != null) {
            int n2 = range.mLower.compareTo(range2.mLower);
            int n3 = range.mUpper.compareTo(range2.mUpper);
            if (n2 <= 0 && n3 >= 0) {
                return range2;
            }
            if (n2 >= 0 && n3 <= 0) {
                return range;
            }
            T t2 = n2 <= 0 ? range2.mLower : range.mLower;
            Range<T> range2 = n3 >= 0 ? range2.mUpper : range.mUpper;
            return Range.create(t2, range2);
        }
        throw new IllegalArgumentException("range must not be null");
    }

    public Range<T> intersect(T t2, T t3) {
        if (t2 != null) {
            if (t3 != null) {
                int n2 = t2.compareTo(this.mLower);
                int n3 = t3.compareTo(this.mUpper);
                if (n2 <= 0 && n3 >= 0) {
                    return this;
                }
                if (n2 <= 0) {
                    t2 = this.mLower;
                }
                if (n3 >= 0) {
                    t3 = this.mUpper;
                }
                return Range.create(t2, t3);
            }
            throw new IllegalArgumentException("upper must not be null");
        }
        throw new IllegalArgumentException("lower must not be null");
    }

    public Range<T> extend(Range<T> range) {
        if (range != null) {
            int n2 = range.mLower.compareTo(range2.mLower);
            int n3 = range.mUpper.compareTo(range2.mUpper);
            if (n2 <= 0 && n3 >= 0) {
                return range;
            }
            if (n2 >= 0 && n3 <= 0) {
                return range2;
            }
            T t2 = n2 >= 0 ? range2.mLower : range.mLower;
            Range<T> range2 = n3 <= 0 ? range2.mUpper : range.mUpper;
            return Range.create(t2, range2);
        }
        throw new IllegalArgumentException("range must not be null");
    }

    public Range<T> extend(T t2, T t3) {
        if (t2 != null) {
            if (t3 != null) {
                int n2 = t2.compareTo(this.mLower);
                int n3 = t3.compareTo(this.mUpper);
                if (n2 >= 0 && n3 <= 0) {
                    return this;
                }
                if (n2 >= 0) {
                    t2 = this.mLower;
                }
                if (n3 <= 0) {
                    t3 = this.mUpper;
                }
                return Range.create(t2, t3);
            }
            throw new IllegalArgumentException("upper must not be null");
        }
        throw new IllegalArgumentException("lower must not be null");
    }

    public Range<T> extend(T t2) {
        if (t2 != null) {
            T t3 = t2;
            return this.extend(t3, t3);
        }
        throw new IllegalArgumentException("value must not be null");
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mLower;
        objectArray[1] = this.mUpper;
        return String.format("[%s, %s]", objectArray2);
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 19) {
            return Objects.hash(this.mLower, this.mUpper);
        }
        return Arrays.hashCode(new Object[]{this.mLower, this.mUpper});
    }
}

