/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout;

import java.lang.reflect.Array;

public class SortedList<T> {
    public static final int INVALID_POSITION = -1;
    private static final int MIN_CAPACITY = 10;
    private static final int CAPACITY_GROWTH = 10;
    private static final int INSERTION = 1;
    private static final int DELETION = 2;
    private static final int LOOKUP = 4;
    T[] mData;
    private Callback mCallback;
    private BatchedCallback mBatchedCallback;
    private int mSize;
    private final Class<T> mTClass;

    public SortedList(Class<T> clazz, Callback<T> callback) {
        this(clazz, callback, 10);
    }

    public SortedList(Class<T> clazz, Callback<T> callback, int n2) {
        SortedList sortedList = this;
        this.mTClass = clazz;
        this.mData = (Object[])Array.newInstance(clazz, n2);
        sortedList.mCallback = callback;
        sortedList.mSize = 0;
    }

    private int add(T t2, boolean bl) {
        int n2 = this.findIndexOf(t2, 1);
        if (n2 == -1) {
            n2 = 0;
        } else if (n2 < this.mSize) {
            SortedList sortedList = this;
            T t3 = sortedList.mData[n2];
            if (sortedList.mCallback.areItemsTheSame(t3, t2)) {
                if (this.mCallback.areContentsTheSame(t3, t2)) {
                    this.mData[n2] = t2;
                    return n2;
                }
                SortedList sortedList2 = this;
                sortedList2.mData[n2] = t2;
                sortedList2.mCallback.onChanged(n2, 1);
                return n2;
            }
        }
        this.addToData(n2, t2);
        if (bl) {
            this.mCallback.onInserted(n2, 1);
        }
        return n2;
    }

    private boolean remove(T t2, boolean bl) {
        int n2 = this.findIndexOf(t2, 2);
        if (n2 == -1) {
            return false;
        }
        this.removeItemAtIndex(n2, bl);
        return true;
    }

    private void removeItemAtIndex(int n2, boolean bl) {
        int n3;
        SortedList sortedList = this;
        System.arraycopy(sortedList.mData, n2 + 1, sortedList.mData, n2, this.mSize - n2 - 1);
        sortedList.mSize = n3 = sortedList.mSize - 1;
        sortedList.mData[n3] = null;
        if (bl) {
            this.mCallback.onRemoved(n2, 1);
        }
    }

    private int findIndexOf(T t2, int n2) {
        int n3 = 0;
        int n4 = this.mSize;
        while (n3 < n4) {
            SortedList sortedList = this;
            int n5 = (n3 + n4) / 2;
            T t3 = sortedList.mData[n5];
            int n6 = sortedList.mCallback.compare(t3, t2);
            if (n6 < 0) {
                n3 = n5 + 1;
                n5 = n4;
            } else if (n6 == 0) {
                if (this.mCallback.areItemsTheSame(t3, t2)) {
                    return n5;
                }
                int n7 = this.linearEqualitySearch(t2, n5, n3, n4);
                if (n2 == 1) {
                    if (n7 == -1) {
                        n7 = n5;
                    }
                    return n7;
                }
                return n7;
            }
            n4 = n5;
        }
        if (n2 != 1) {
            n3 = -1;
        }
        return n3;
    }

    private int linearEqualitySearch(T t2, int n2, int n3, int n4) {
        for (int i3 = n2 - 1; i3 >= n3; --i3) {
            SortedList sortedList = this;
            T t3 = sortedList.mData[i3];
            if (sortedList.mCallback.compare(t3, t2) != 0) break;
            if (!this.mCallback.areItemsTheSame(t3, t2)) continue;
            return i3;
        }
        while (++n2 < n4) {
            SortedList sortedList = this;
            T t4 = sortedList.mData[n2];
            if (sortedList.mCallback.compare(t4, t2) != 0) break;
            if (!this.mCallback.areItemsTheSame(t4, t2)) continue;
            return n2;
        }
        return -1;
    }

    private void addToData(int n2, T t2) {
        int n3 = this.mSize;
        if (n2 <= n3) {
            T[] TArray = this.mData;
            if (n3 == this.mData.length) {
                Object[] objectArray = (Object[])Array.newInstance(this.mTClass, TArray.length + 10);
                System.arraycopy(this.mData, 0, objectArray, 0, n2);
                objectArray[n2] = t2;
                int n4 = n2;
                int n5 = n2 + 1;
                n2 = this.mSize - n2;
                System.arraycopy(this.mData, n4, objectArray, n5, n2);
                this.mData = objectArray;
            } else {
                int n6 = n3;
                int n7 = n2;
                n3 = n7 + 1;
                int n8 = n6 - n7;
                System.arraycopy(TArray, n2, TArray, n3, n8);
                this.mData[n2] = t2;
            }
            ++this.mSize;
            return;
        }
        throw new IndexOutOfBoundsException("cannot add item to " + n2 + " because size is " + this.mSize);
    }

    public int size() {
        return this.mSize;
    }

    public int add(T t2) {
        return this.add(t2, true);
    }

    public void beginBatchedUpdates() {
        Callback callback = this.mCallback;
        if (callback instanceof BatchedCallback) {
            return;
        }
        if (this.mBatchedCallback == null) {
            BatchedCallback batchedCallback;
            BatchedCallback batchedCallback2 = batchedCallback;
            batchedCallback = new BatchedCallback(callback);
            this.mBatchedCallback = batchedCallback2;
        }
        this.mCallback = this.mBatchedCallback;
    }

    public void endBatchedUpdates() {
        Callback callback = this.mCallback;
        if (callback instanceof BatchedCallback) {
            ((BatchedCallback)callback).dispatchLastEvent();
        }
        if (this.mCallback == (callback = this.mBatchedCallback)) {
            this.mCallback = ((BatchedCallback)callback).mWrappedCallback;
        }
    }

    public boolean remove(T t2) {
        return this.remove(t2, true);
    }

    public T removeItemAt(int n2) {
        T t2 = this.get(n2);
        this.removeItemAtIndex(n2, true);
        return t2;
    }

    public void updateItemAt(int n2, T t2) {
        T t3 = this.get(n2);
        boolean bl = t3 == t2 || !this.mCallback.areContentsTheSame(t3, t2);
        if (t3 != t2 && this.mCallback.compare(t3, t2) == 0) {
            this.mData[n2] = t2;
            if (bl) {
                this.mCallback.onChanged(n2, 1);
            }
            return;
        }
        if (bl) {
            this.mCallback.onChanged(n2, 1);
        }
        SortedList sortedList = this;
        sortedList.removeItemAtIndex(n2, false);
        int n3 = sortedList.add(t2, false);
        if (n2 != n3) {
            this.mCallback.onMoved(n2, n3);
        }
    }

    public void recalculatePositionOfItemAt(int n2) {
        SortedList sortedList = this;
        T t2 = sortedList.get(n2);
        sortedList.removeItemAtIndex(n2, false);
        int n3 = sortedList.add(t2, false);
        if (n2 != n3) {
            this.mCallback.onMoved(n2, n3);
        }
    }

    public T get(int n2) throws IndexOutOfBoundsException {
        if (n2 < this.mSize && n2 >= 0) {
            return this.mData[n2];
        }
        throw new IndexOutOfBoundsException("Asked to get item at " + n2 + " but size is " + this.mSize);
    }

    public int indexOf(T t2) {
        return this.findIndexOf(t2, 4);
    }

    public static class BatchedCallback<T2>
    extends Callback<T2> {
        static final int TYPE_NONE = 0;
        static final int TYPE_ADD = 1;
        static final int TYPE_REMOVE = 2;
        static final int TYPE_CHANGE = 3;
        static final int TYPE_MOVE = 4;
        private final Callback<T2> mWrappedCallback;
        int mLastEventType = 0;
        int mLastEventPosition = -1;
        int mLastEventCount = -1;

        public BatchedCallback(Callback<T2> callback) {
            this.mWrappedCallback = callback;
        }

        @Override
        public int compare(T2 T2, T2 T22) {
            return this.mWrappedCallback.compare(T2, T22);
        }

        @Override
        public void onInserted(int n2, int n3) {
            int n4;
            int n5;
            if (this.mLastEventType == 1 && n2 >= (n5 = this.mLastEventPosition) && n2 <= n5 + (n4 = this.mLastEventCount)) {
                this.mLastEventCount = n4 + n3;
                this.mLastEventPosition = Math.min(n2, n5);
                return;
            }
            this.dispatchLastEvent();
            this.mLastEventPosition = n2;
            this.mLastEventCount = n3;
            this.mLastEventType = 1;
        }

        @Override
        public void onRemoved(int n2, int n3) {
            if (this.mLastEventType == 2 && this.mLastEventPosition == n2) {
                this.mLastEventCount += n3;
                return;
            }
            this.dispatchLastEvent();
            this.mLastEventPosition = n2;
            this.mLastEventCount = n3;
            this.mLastEventType = 2;
        }

        @Override
        public void onMoved(int n2, int n3) {
            BatchedCallback batchedCallback = this;
            batchedCallback.dispatchLastEvent();
            batchedCallback.mWrappedCallback.onMoved(n2, n3);
        }

        @Override
        public void onChanged(int n2, int n3) {
            int n4;
            int n5;
            int n6;
            if (this.mLastEventType == 3 && n2 <= (n6 = this.mLastEventPosition) + (n5 = this.mLastEventCount) && (n4 = n2 + n3) >= n6) {
                this.mLastEventPosition = Math.min(n2, n6);
                this.mLastEventCount = Math.max(n6 + n5, n4) - this.mLastEventPosition;
                return;
            }
            this.dispatchLastEvent();
            this.mLastEventPosition = n2;
            this.mLastEventCount = n3;
            this.mLastEventType = 3;
        }

        @Override
        public boolean areContentsTheSame(T2 T2, T2 T22) {
            return this.mWrappedCallback.areContentsTheSame(T2, T22);
        }

        @Override
        public boolean areItemsTheSame(T2 T2, T2 T22) {
            return this.mWrappedCallback.areItemsTheSame(T2, T22);
        }

        public void dispatchLastEvent() {
            int n2 = this.mLastEventType;
            if (n2 == 0) {
                return;
            }
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 == 3) {
                        BatchedCallback batchedCallback = this;
                        n2 = batchedCallback.mLastEventPosition;
                        this.mWrappedCallback.onChanged(n2, batchedCallback.mLastEventCount);
                    }
                } else {
                    BatchedCallback batchedCallback = this;
                    n2 = batchedCallback.mLastEventPosition;
                    this.mWrappedCallback.onRemoved(n2, batchedCallback.mLastEventCount);
                }
            } else {
                BatchedCallback batchedCallback = this;
                n2 = batchedCallback.mLastEventPosition;
                this.mWrappedCallback.onInserted(n2, batchedCallback.mLastEventCount);
            }
            this.mLastEventType = 0;
        }
    }

    public static abstract class Callback<T2> {
        public abstract int compare(T2 var1, T2 var2);

        public abstract void onInserted(int var1, int var2);

        public abstract void onRemoved(int var1, int var2);

        public abstract void onMoved(int var1, int var2);

        public abstract void onChanged(int var1, int var2);

        public abstract boolean areContentsTheSame(T2 var1, T2 var2);

        public abstract boolean areItemsTheSame(T2 var1, T2 var2);
    }
}

