/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.os.Trace;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.ExposeLinearLayoutManagerEx;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelperFinder;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutManagerHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutView;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutViewFactory;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.OrientationHelperEx;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.RangeLayoutHelperFinder;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend.PerformanceMonitor;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend.ViewLifeCycleHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend.ViewLifeCycleListener;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.BaseLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.DefaultLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.FixAreaAdjuster;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.FixAreaLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.LayoutChunkResult;
import com.baidu.navisdk.util.common.LogUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VirtualLayoutManager
extends ExposeLinearLayoutManagerEx
implements LayoutManagerHelper {
    protected static final String TAG = "VirtualLayoutManager";
    private static final String PHASE_MEASURE = "measure";
    private static final String PHASE_LAYOUT = "layout";
    private static final String TRACE_LAYOUT = "VLM onLayoutChildren";
    private static final String TRACE_SCROLL = "VLM scroll";
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static LayoutHelper DEFAULT_LAYOUT_HELPER = new DefaultLayoutHelper();
    private static final int MAX_NO_SCROLLING_SIZE = 0x7FFFFFF;
    protected OrientationHelperEx mOrientationHelper;
    protected OrientationHelperEx mSecondaryOrientationHelper;
    private RecyclerView mRecyclerView;
    private boolean mNoScrolling = false;
    private boolean mNestedScrolling = false;
    private boolean mCanScrollHorizontally;
    private boolean mCanScrollVertically;
    private boolean mEnableMarginOverlapping = false;
    private int mMaxMeasureSize = -1;
    private PerformanceMonitor mPerformanceMonitor;
    private ViewLifeCycleHelper mViewLifeCycleHelper;
    private LayoutHelperFinder mHelperFinder;
    private FixAreaAdjuster mFixAreaAdjustor = FixAreaAdjuster.mDefaultAdjuster;
    private HashMap<Integer, LayoutHelper> newHelpersSet = new HashMap();
    private HashMap<Integer, LayoutHelper> oldHelpersSet = new HashMap();
    private BaseLayoutHelper.LayoutViewBindListener mLayoutViewBindListener;
    private AnchorInfoWrapper mTempAnchorInfoWrapper = new AnchorInfoWrapper();
    private int mNested = 0;
    private LayoutStateWrapper mTempLayoutStateWrapper = new LayoutStateWrapper();
    private List<Pair<Range<Integer>, Integer>> mRangeLengths = new LinkedList<Pair<Range<Integer>, Integer>>();
    private LayoutHelper mDefaultLayoutHelper = DEFAULT_LAYOUT_HELPER;
    private LayoutViewFactory mLayoutViewFatory = new LayoutViewFactory(){

        @Override
        public View generateLayoutView(@NonNull Context context) {
            return new LayoutView(context);
        }
    };
    private Rect mDecorInsets = new Rect();
    private boolean mSpaceMeasured = false;
    private int mMeasuredFullSpace = 0;
    private boolean mSpaceMeasuring = false;

    public VirtualLayoutManager(@NonNull Context context) {
        this(context, 1);
    }

    public VirtualLayoutManager(@NonNull Context context, int n2) {
        this(context, n2, false);
    }

    public VirtualLayoutManager(@NonNull Context context, int n2, boolean bl) {
        super(context, n2, bl);
        this.mOrientationHelper = OrientationHelperEx.createOrientationHelper(this, n2);
        int n3 = n2 == 1 ? 0 : 1;
        VirtualLayoutManager virtualLayoutManager = this;
        virtualLayoutManager.mSecondaryOrientationHelper = OrientationHelperEx.createOrientationHelper(virtualLayoutManager, n3);
        virtualLayoutManager.mCanScrollVertically = super.canScrollVertically();
        virtualLayoutManager.mCanScrollHorizontally = super.canScrollHorizontally();
        virtualLayoutManager.setHelperFinder(new RangeLayoutHelperFinder());
    }

    private void runPreLayout(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mNested == 0) {
            List<LayoutHelper> list = this.mHelperFinder.reverse();
            int n2 = list.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                list.get(i3).beforeLayout(recycler, state, this);
            }
        }
        ++this.mNested;
    }

    private void runPostLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int n2) {
        if (--((VirtualLayoutManager)((Object)viewLifeCycleHelper)).mNested <= 0) {
            VirtualLayoutManager virtualLayoutManager = viewLifeCycleHelper;
            virtualLayoutManager.mNested = 0;
            int n3 = virtualLayoutManager.findFirstVisibleItemPosition();
            int n4 = virtualLayoutManager.findLastVisibleItemPosition();
            List<LayoutHelper> list = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
            int n5 = list.size();
            for (int i3 = 0; i3 < n5; ++i3) {
                Exception exception2;
                block5: {
                    try {
                        list.get(i3).afterLayout(recycler, state, n3, n4, n2, (LayoutManagerHelper)((Object)viewLifeCycleHelper));
                    }
                    catch (Exception exception2) {
                        if (LogUtil.LOGGABLE) break block5;
                    }
                    continue;
                }
                LogUtil.e(TAG, "runPostLayout --> exception = " + exception2);
                throw exception2;
            }
            ViewLifeCycleHelper viewLifeCycleHelper = ((VirtualLayoutManager)((Object)viewLifeCycleHelper)).mViewLifeCycleHelper;
            if (viewLifeCycleHelper != null) {
                viewLifeCycleHelper.checkViewStatusInScreen();
            }
        }
    }

    @Nullable
    private int findRangeLength(@NonNull Range<Integer> range) {
        Pair<Range<Integer>, Integer> pair;
        int n2 = this.mRangeLengths.size();
        if (n2 == 0) {
            return -1;
        }
        int n3 = n2;
        n2 = 0;
        int n4 = n3 - 1;
        int n5 = -1;
        while (true) {
            pair = null;
            if (n2 > n4) break;
            n5 = (n2 + n4) / 2;
            pair = this.mRangeLengths.get(n5);
            Range range2 = (Range)pair.first;
            if (range2 == null) {
                pair = null;
                break;
            }
            if (range2.contains(range.getLower()) || range2.contains(range.getUpper()) || range.contains(range2)) break;
            if ((Integer)range2.getLower() > range.getUpper()) {
                n4 = n5 - 1;
                continue;
            }
            if ((Integer)range2.getUpper() >= range.getLower()) continue;
            n2 = n5 + 1;
        }
        if (pair == null) {
            n5 = -1;
        }
        return n5;
    }

    private void setDefaultLayoutHelper(@NonNull LayoutHelper layoutHelper) {
        if (layoutHelper != null) {
            this.mDefaultLayoutHelper = layoutHelper;
            return;
        }
        throw new IllegalArgumentException("layoutHelper should not be null");
    }

    private void measureChildWithDecorations(View view, int n2, int n3) {
        VirtualLayoutManager virtualLayoutManager = performanceMonitor2;
        virtualLayoutManager.calculateItemDecorationsForChild(view, virtualLayoutManager.mDecorInsets);
        Rect rect = virtualLayoutManager.mDecorInsets;
        int n4 = rect.left;
        int n5 = rect.right;
        n2 = virtualLayoutManager.updateSpecWithExtra(n2, n4, n5);
        Rect rect2 = virtualLayoutManager.mDecorInsets;
        n4 = rect2.top;
        n5 = rect2.bottom;
        n3 = virtualLayoutManager.updateSpecWithExtra(n3, n4, n5);
        PerformanceMonitor performanceMonitor = virtualLayoutManager.mPerformanceMonitor;
        if (performanceMonitor != null) {
            performanceMonitor.recordStart(PHASE_MEASURE, view);
        }
        view.measure(n2, n3);
        PerformanceMonitor performanceMonitor2 = ((VirtualLayoutManager)((Object)performanceMonitor2)).mPerformanceMonitor;
        if (performanceMonitor2 != null) {
            performanceMonitor2.recordEnd(PHASE_MEASURE, view);
        }
    }

    private void measureChildWithDecorationsAndMargin(View view, int n2, int n3) {
        performanceMonitor.calculateItemDecorationsForChild(view, ((VirtualLayoutManager)((Object)performanceMonitor)).mDecorInsets);
        Object object = (RecyclerView.LayoutParams)view.getLayoutParams();
        if (((VirtualLayoutManager)((Object)performanceMonitor)).getOrientation() == 1) {
            RecyclerView.LayoutParams layoutParams = object;
            Rect rect = ((VirtualLayoutManager)((Object)performanceMonitor)).mDecorInsets;
            int n4 = layoutParams.leftMargin + rect.left;
            n2 = ((VirtualLayoutManager)((Object)performanceMonitor)).updateSpecWithExtra(n2, n4, layoutParams.rightMargin + rect.right);
        }
        if (((VirtualLayoutManager)((Object)performanceMonitor)).getOrientation() == 0) {
            VirtualLayoutManager virtualLayoutManager = performanceMonitor;
            Rect rect = virtualLayoutManager.mDecorInsets;
            int n5 = rect.top;
            int n6 = rect.bottom;
            n3 = virtualLayoutManager.updateSpecWithExtra(n3, n5, n6);
        }
        if ((object = ((VirtualLayoutManager)((Object)performanceMonitor)).mPerformanceMonitor) != null) {
            ((PerformanceMonitor)object).recordStart(PHASE_MEASURE, view);
        }
        view.measure(n2, n3);
        PerformanceMonitor performanceMonitor = ((VirtualLayoutManager)((Object)performanceMonitor)).mPerformanceMonitor;
        if (performanceMonitor != null) {
            performanceMonitor.recordEnd(PHASE_MEASURE, view);
        }
    }

    private int updateSpecWithExtra(int n2, int n3, int n4) {
        if (n3 == 0 && n4 == 0) {
            return n2;
        }
        int n5 = View.MeasureSpec.getMode((int)n2);
        if (n5 != Integer.MIN_VALUE && n5 != 0x40000000) {
            return n2;
        }
        if (View.MeasureSpec.getSize((int)n2) - n3 - n4 < 0) {
            return View.MeasureSpec.makeMeasureSpec((int)0, (int)n5);
        }
        return View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)n2) - n3 - n4), (int)n5);
    }

    public void setPerformanceMonitor(PerformanceMonitor performanceMonitor) {
        this.mPerformanceMonitor = performanceMonitor;
    }

    public void setNoScrolling(boolean bl) {
        VirtualLayoutManager virtualLayoutManager = this;
        virtualLayoutManager.mNoScrolling = bl;
        virtualLayoutManager.mSpaceMeasured = false;
        virtualLayoutManager.mMeasuredFullSpace = 0;
        virtualLayoutManager.mSpaceMeasuring = false;
    }

    public void setCanScrollVertically(boolean bl) {
        this.mCanScrollVertically = bl;
    }

    public void setCanScrollHorizontally(boolean bl) {
        this.mCanScrollHorizontally = bl;
    }

    public void setNestedScrolling(boolean bl) {
        this.setNestedScrolling(bl, -1);
    }

    public void setNestedScrolling(boolean bl, int n2) {
        VirtualLayoutManager virtualLayoutManager = this;
        virtualLayoutManager.mNestedScrolling = bl;
        virtualLayoutManager.mSpaceMeasured = false;
        virtualLayoutManager.mSpaceMeasuring = false;
        virtualLayoutManager.mMeasuredFullSpace = 0;
    }

    public void setHelperFinder(@NonNull LayoutHelperFinder layoutHelperFinder) {
        if (layoutHelperFinder != null) {
            LinkedList<LayoutHelper> linkedList;
            LinkedList<LayoutHelper> linkedList2 = linkedList;
            linkedList = new LinkedList<LayoutHelper>();
            Object object = this.mHelperFinder;
            if (object != null) {
                object = ((LayoutHelperFinder)object).getLayoutHelpers();
                int n2 = object.size();
                for (int i3 = 0; i3 < n2; ++i3) {
                    linkedList2.add((LayoutHelper)object.get(i3));
                }
            }
            this.mHelperFinder = layoutHelperFinder;
            if (linkedList2.size() > 0) {
                this.mHelperFinder.setLayouts(linkedList2);
            }
            this.mSpaceMeasured = false;
            this.requestLayout();
            return;
        }
        throw new IllegalArgumentException("finder is null");
    }

    public void setFixOffset(int n2, int n3, int n4, int n5) {
        FixAreaAdjuster fixAreaAdjuster;
        VirtualLayoutManager virtualLayoutManager = fixAreaAdjuster2;
        FixAreaAdjuster fixAreaAdjuster2 = fixAreaAdjuster;
        fixAreaAdjuster = new FixAreaAdjuster(n2, n3, n4, n5);
        virtualLayoutManager.mFixAreaAdjustor = fixAreaAdjuster2;
    }

    public void setLayoutHelpers(@Nullable List<LayoutHelper> iterator) {
        Object object;
        int n2;
        List<LayoutHelper> list = this.mHelperFinder.getLayoutHelpers();
        int n3 = list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object = list.get(n2);
            this.oldHelpersSet.put(System.identityHashCode(object), (LayoutHelper)object);
        }
        if (iterator != null) {
            int n4 = 0;
            for (n2 = 0; n2 < iterator.size(); ++n2) {
                LayoutHelper layoutHelper = iterator.get(n2);
                if (layoutHelper instanceof FixAreaLayoutHelper) {
                    ((FixAreaLayoutHelper)layoutHelper).setAdjuster(this.mFixAreaAdjustor);
                }
                if (layoutHelper instanceof BaseLayoutHelper && (object = this.mLayoutViewBindListener) != null) {
                    ((BaseLayoutHelper)layoutHelper).setLayoutViewBindListener((BaseLayoutHelper.LayoutViewBindListener)object);
                }
                if (layoutHelper.getItemCount() > 0) {
                    int n5 = n4;
                    layoutHelper.setRange(n5, n5 + layoutHelper.getItemCount() - 1);
                } else {
                    layoutHelper.setRange(-1, -1);
                }
                n4 += layoutHelper.getItemCount();
            }
        }
        VirtualLayoutManager virtualLayoutManager = this;
        virtualLayoutManager.mHelperFinder.setLayouts((List<LayoutHelper>)((Object)iterator));
        iterator = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
        n2 = iterator.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            LayoutHelper layoutHelper = iterator.get(i3);
            this.newHelpersSet.put(System.identityHashCode(layoutHelper), layoutHelper);
        }
        iterator = this.oldHelpersSet.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer n6 = (Integer)((Map.Entry)iterator.next()).getKey();
            if (!this.newHelpersSet.containsKey(n6)) continue;
            this.newHelpersSet.remove(n6);
            iterator.remove();
        }
        iterator = this.oldHelpersSet.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().clear(this);
        }
        if (!this.oldHelpersSet.isEmpty() || !this.newHelpersSet.isEmpty()) {
            this.mSpaceMeasured = false;
        }
        VirtualLayoutManager virtualLayoutManager2 = this;
        virtualLayoutManager2.oldHelpersSet.clear();
        virtualLayoutManager2.newHelpersSet.clear();
        virtualLayoutManager2.requestLayout();
    }

    @NonNull
    public List<LayoutHelper> getLayoutHelpers() {
        return this.mHelperFinder.getLayoutHelpers();
    }

    public void setEnableMarginOverlapping(boolean bl) {
        this.mEnableMarginOverlapping = bl;
    }

    @Override
    public boolean isEnableMarginOverLap() {
        return this.mEnableMarginOverlapping;
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    @Override
    public void setOrientation(int n2) {
        this.mOrientationHelper = OrientationHelperEx.createOrientationHelper(this, n2);
        super.setOrientation(n2);
    }

    public void setReverseLayout(boolean bl) {
        if (!bl) {
            super.setReverseLayout(false);
            return;
        }
        throw new UnsupportedOperationException("VirtualLayoutManager does not support reverse layout in current version.");
    }

    public void setStackFromEnd(boolean bl) {
        if (!bl) {
            super.setStackFromEnd(false);
            return;
        }
        throw new UnsupportedOperationException("VirtualLayoutManager does not support stack from end.");
    }

    @Override
    public void onAnchorReady(RecyclerView.State state, ExposeLinearLayoutManagerEx.AnchorInfo object) {
        int n2;
        super.onAnchorReady(state, (ExposeLinearLayoutManagerEx.AnchorInfo)object);
        int n3 = 1;
        while (n3 != 0) {
            int n4;
            VirtualLayoutManager virtualLayoutManager = this;
            AnchorInfoWrapper anchorInfoWrapper = virtualLayoutManager.mTempAnchorInfoWrapper;
            anchorInfoWrapper.position = n4 = ((ExposeLinearLayoutManagerEx.AnchorInfo)object).mPosition;
            anchorInfoWrapper.coordinate = ((ExposeLinearLayoutManagerEx.AnchorInfo)object).mCoordinate;
            virtualLayoutManager.mTempAnchorInfoWrapper.layoutFromEnd = ((ExposeLinearLayoutManagerEx.AnchorInfo)object).mLayoutFromEnd;
            LayoutHelper layoutHelper = virtualLayoutManager.mHelperFinder.getLayoutHelper(n4);
            if (layoutHelper != null) {
                layoutHelper.checkAnchorInfo(state, this.mTempAnchorInfoWrapper, this);
            }
            if ((n2 = this.mTempAnchorInfoWrapper.position) == ((ExposeLinearLayoutManagerEx.AnchorInfo)object).mPosition) {
                n3 = 0;
            } else {
                ((ExposeLinearLayoutManagerEx.AnchorInfo)object).mPosition = n2;
            }
            ((ExposeLinearLayoutManagerEx.AnchorInfo)object).mCoordinate = this.mTempAnchorInfoWrapper.coordinate;
            this.mTempAnchorInfoWrapper.position = -1;
        }
        VirtualLayoutManager virtualLayoutManager = this;
        AnchorInfoWrapper anchorInfoWrapper = virtualLayoutManager.mTempAnchorInfoWrapper;
        anchorInfoWrapper.position = ((ExposeLinearLayoutManagerEx.AnchorInfo)object).mPosition;
        anchorInfoWrapper.coordinate = ((ExposeLinearLayoutManagerEx.AnchorInfo)object).mCoordinate;
        object = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
        n2 = object.size();
        for (n3 = 0; n3 < n2; ++n3) {
            ((LayoutHelper)object.get(n3)).onRefreshLayout(state, this.mTempAnchorInfoWrapper, this);
        }
    }

    public LayoutHelper findNeighbourNonfixLayoutHelper(LayoutHelper layoutHelper, boolean bl) {
        if (layoutHelper == null) {
            return null;
        }
        List<LayoutHelper> list = ((VirtualLayoutManager)((Object)list)).mHelperFinder.getLayoutHelpers();
        int n2 = list.indexOf(layoutHelper);
        if (n2 == -1) {
            return null;
        }
        n2 = bl ? --n2 : ++n2;
        if (n2 >= 0 && n2 < list.size()) {
            if ((list = (LayoutHelper)list.get(n2)) != null) {
                if (((LayoutHelper)((Object)list)).isFixLayout()) {
                    return null;
                }
                return list;
            }
            return null;
        }
        return null;
    }

    @Override
    protected int computeAlignOffset(View view, boolean bl, boolean bl2) {
        VirtualLayoutManager virtualLayoutManager = this;
        return virtualLayoutManager.computeAlignOffset(virtualLayoutManager.getPosition(view), bl, bl2);
    }

    @Override
    protected int computeAlignOffset(int n2, boolean bl, boolean bl2) {
        LayoutHelper layoutHelper;
        if (n2 != -1 && (layoutHelper = this.mHelperFinder.getLayoutHelper(n2)) != null) {
            return layoutHelper.computeAlignOffset(n2 - layoutHelper.getRange().getLower(), bl, bl2, this);
        }
        return 0;
    }

    public int obtainExtraMargin(View view, boolean bl) {
        return this.obtainExtraMargin(view, bl, true);
    }

    public int obtainExtraMargin(View view, boolean bl, boolean bl2) {
        if (view != null) {
            return this.computeAlignOffset(view, bl, bl2);
        }
        return 0;
    }

    public void runAdjustLayout() {
        VirtualLayoutManager virtualLayoutManager = this;
        int n2 = virtualLayoutManager.findFirstVisibleItemPosition();
        LayoutHelper layoutHelper = virtualLayoutManager.mHelperFinder.getLayoutHelper(n2);
        int n3 = virtualLayoutManager.findLastVisibleItemPosition();
        LayoutHelper layoutHelper2 = virtualLayoutManager.mHelperFinder.getLayoutHelper(n3);
        List<LayoutHelper> list = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
        int n4 = list.indexOf(layoutHelper2);
        for (int i3 = list.indexOf(layoutHelper); i3 <= n4; ++i3) {
            Exception exception2;
            block3: {
                try {
                    list.get(i3).adjustLayout(n2, n3, this);
                }
                catch (Exception exception2) {
                    if (LogUtil.LOGGABLE) break block3;
                }
                continue;
            }
            LogUtil.e(TAG, "runAdjustLayout --> exception = " + exception2);
            throw exception2;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        Throwable throwable2;
        block12: {
            block11: {
                if (Build.VERSION.SDK_INT >= 18) {
                    Trace.beginSection((String)TRACE_LAYOUT);
                }
                if (this.mNoScrolling && state.didStructureChange()) {
                    VirtualLayoutManager virtualLayoutManager = this;
                    virtualLayoutManager.mSpaceMeasured = false;
                    virtualLayoutManager.mSpaceMeasuring = true;
                }
                VirtualLayoutManager virtualLayoutManager = this;
                this.runPreLayout(recycler, state);
                super.onLayoutChildren(recycler, state);
                virtualLayoutManager.runPostLayout(recycler, state, Integer.MAX_VALUE);
                if (!virtualLayoutManager.mNestedScrolling && !this.mNoScrolling || !this.mSpaceMeasuring) break block11;
                VirtualLayoutManager virtualLayoutManager2 = this;
                virtualLayoutManager2.mSpaceMeasured = true;
                {
                    catch (Throwable throwable2) {
                        break block12;
                    }
                    catch (Exception exception) {}
                    {
                        exception.printStackTrace();
                        throw exception;
                    }
                }
                recycler = virtualLayoutManager2.getChildAt(virtualLayoutManager2.getChildCount() - 1);
                if (recycler != null) {
                    VirtualLayoutManager virtualLayoutManager3 = this;
                    RecyclerView.Recycler recycler2 = recycler;
                    state = (RecyclerView.LayoutParams)recycler2.getLayoutParams();
                    virtualLayoutManager3.mMeasuredFullSpace = virtualLayoutManager3.getDecoratedBottom((View)recycler2) + state.bottomMargin + this.computeAlignOffset((View)recycler, true, false);
                    recycler = virtualLayoutManager3.mRecyclerView;
                    if (recycler != null && this.mNestedScrolling && (recycler = recycler.getParent()) instanceof View) {
                        this.mMeasuredFullSpace = Math.min(this.mMeasuredFullSpace, ((View)recycler).getMeasuredHeight());
                    }
                } else {
                    this.mSpaceMeasuring = false;
                }
                this.mSpaceMeasuring = false;
                if (this.mRecyclerView != null && this.getItemCount() > 0) {
                    this.mRecyclerView.post(new Runnable(){

                        @Override
                        public void run() {
                            if (VirtualLayoutManager.this.mRecyclerView != null) {
                                VirtualLayoutManager.this.mRecyclerView.requestLayout();
                            }
                        }
                    });
                }
            }
            if (Build.VERSION.SDK_INT >= 18) {
                Trace.endSection();
            }
            return;
        }
        this.runPostLayout(recycler, state, Integer.MAX_VALUE);
        throw throwable2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int scrollInternalBy(int n2, RecyclerView.Recycler recycler, RecyclerView.State state) {
        Throwable throwable2;
        int n3;
        block12: {
            block11: {
                block10: {
                    if (Build.VERSION.SDK_INT >= 18) {
                        Trace.beginSection((String)TRACE_SCROLL);
                    }
                    VirtualLayoutManager virtualLayoutManager = this;
                    virtualLayoutManager.runPreLayout(recycler, state);
                    n3 = 0;
                    if (!virtualLayoutManager.mNoScrolling) {
                        n2 = super.scrollInternalBy(n2, recycler, state);
                        break block10;
                    }
                    if (this.getChildCount() == 0 || n2 == 0) break block11;
                    this.mLayoutState.mRecycle = true;
                    this.ensureLayoutStateExpose();
                    int n4 = n2 > 0 ? 1 : -1;
                    VirtualLayoutManager virtualLayoutManager2 = this;
                    VirtualLayoutManager virtualLayoutManager3 = virtualLayoutManager2;
                    VirtualLayoutManager virtualLayoutManager4 = virtualLayoutManager2;
                    int n5 = n4;
                    int n6 = Math.abs(n2);
                    {
                        catch (Throwable throwable2) {
                            break block12;
                        }
                        catch (Exception exception) {}
                        {
                            if (LogUtil.LOGGABLE) {
                                LogUtil.e(TAG, "scrollInternalBy --> exception = " + exception);
                            }
                            throw exception;
                        }
                    }
                    {
                        virtualLayoutManager3.updateLayoutStateExpose(n5, n6, true, state);
                        int n7 = virtualLayoutManager4.mLayoutState.mScrollingOffset + this.fill(recycler, this.mLayoutState, state, false);
                        if (n7 < 0) {
                            this.runPostLayout(recycler, state, n3);
                            return 0;
                        }
                        if (n6 <= n7) break block10;
                        n2 = n4 * n7;
                    }
                }
                this.runPostLayout(recycler, state, n2);
                if (Build.VERSION.SDK_INT >= 18) {
                    Trace.endSection();
                }
                return n2;
            }
            this.runPostLayout(recycler, state, n3);
            return 0;
        }
        this.runPostLayout(recycler, state, n3);
        throw throwable2;
    }

    public void onScrollStateChanged(int n2) {
        VirtualLayoutManager virtualLayoutManager = this;
        super.onScrollStateChanged(n2);
        int n3 = virtualLayoutManager.findFirstVisibleItemPosition();
        int n4 = virtualLayoutManager.findLastVisibleItemPosition();
        List<LayoutHelper> list = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
        int n5 = list.size();
        for (int i3 = 0; i3 < n5; ++i3) {
            list.get(i3).onScrollStateChanged(n2, n3, n4, this);
        }
    }

    public void offsetChildrenHorizontal(int n2) {
        VirtualLayoutManager virtualLayoutManager = this;
        super.offsetChildrenHorizontal(n2);
        List<LayoutHelper> list = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
        int n3 = list.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            list.get(i3).onOffsetChildrenHorizontal(n2, this);
        }
    }

    public void offsetChildrenVertical(int n2) {
        VirtualLayoutManager virtualLayoutManager = viewLifeCycleHelper;
        super.offsetChildrenVertical(n2);
        List<LayoutHelper> list = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
        int n3 = list.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            list.get(i3).onOffsetChildrenVertical(n2, (LayoutManagerHelper)((Object)viewLifeCycleHelper));
        }
        ViewLifeCycleHelper viewLifeCycleHelper = ((VirtualLayoutManager)((Object)viewLifeCycleHelper)).mViewLifeCycleHelper;
        if (viewLifeCycleHelper != null) {
            viewLifeCycleHelper.checkViewStatusInScreen();
        }
    }

    public void setViewLifeCycleListener(@NonNull ViewLifeCycleListener viewLifeCycleListener) {
        if (viewLifeCycleListener != null) {
            if (this.recycleOffset != 0) {
                ViewLifeCycleHelper viewLifeCycleHelper;
                ViewLifeCycleHelper viewLifeCycleHelper2 = viewLifeCycleHelper;
                viewLifeCycleHelper = new ViewLifeCycleHelper(this, viewLifeCycleListener);
                this.mViewLifeCycleHelper = viewLifeCycleHelper2;
                return;
            }
            throw new IllegalArgumentException("ViewLifeCycleListener should work with virtualLayoutManager.setRecycleOffset()!");
        }
        throw new IllegalArgumentException("ViewLifeCycleListener should not be null!");
    }

    public int getVirtualLayoutDirection() {
        return this.mLayoutState.mLayoutDirection;
    }

    @Override
    protected void layoutChunk(RecyclerView.Recycler recycler, RecyclerView.State state, ExposeLinearLayoutManagerEx.LayoutState object, LayoutChunkResult pair) {
        VirtualLayoutManager virtualLayoutManager = this;
        int n2 = ((ExposeLinearLayoutManagerEx.LayoutState)object).mCurrentPosition;
        LayoutStateWrapper.access$102(virtualLayoutManager.mTempLayoutStateWrapper, (ExposeLinearLayoutManagerEx.LayoutState)object);
        Object object2 = virtualLayoutManager.mHelperFinder;
        object2 = object2 == null ? null : ((LayoutHelperFinder)object2).getLayoutHelper(n2);
        if (object2 == null) {
            object2 = this.mDefaultLayoutHelper;
        }
        ((LayoutHelper)object2).doLayout(recycler, state, this.mTempLayoutStateWrapper, (LayoutChunkResult)pair, this);
        LayoutStateWrapper.access$102(this.mTempLayoutStateWrapper, null);
        int n3 = ((ExposeLinearLayoutManagerEx.LayoutState)object).mCurrentPosition;
        if (n3 == n2) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "layoutHelper[" + object2.getClass().getSimpleName() + "@" + object2.toString() + "] consumes no item!");
            }
            pair.mFinished = true;
        } else {
            int n4;
            Range<Integer> range;
            int n5 = pair.mIgnoreConsumed ? 0 : pair.mConsumed;
            object = range;
            Integer n6 = Math.min(n2, n3 -= ((ExposeLinearLayoutManagerEx.LayoutState)object).mItemDirection);
            if ((n4 = this.findRangeLength(new Range<Integer>(n6, Math.max(n2, n3)))) >= 0) {
                pair = this.mRangeLengths.get(n4);
                if (pair != null && ((Range)pair.first).equals(object) && (Integer)pair.second == n5) {
                    return;
                }
                this.mRangeLengths.remove(n4);
            }
            VirtualLayoutManager virtualLayoutManager2 = this;
            virtualLayoutManager2.mRangeLengths.add((Pair<Range<Integer>, Integer>)Pair.create((Object)object, (Object)n5));
            Collections.sort(virtualLayoutManager2.mRangeLengths, new Comparator<Pair<Range<Integer>, Integer>>(){

                @Override
                public int compare(Pair<Range<Integer>, Integer> pair, Pair<Range<Integer>, Integer> pair2) {
                    if (pair == null && pair2 == null) {
                        return 0;
                    }
                    if (pair == null) {
                        return -1;
                    }
                    if (pair2 == null) {
                        return 1;
                    }
                    Range range = (Range)pair2.first;
                    return (Integer)((Range)pair.first).getLower() - (Integer)range.getLower();
                }
            });
        }
    }

    public int getOffsetToStart() {
        if (this.getChildCount() == 0) {
            return -1;
        }
        View view = this.getChildAt(0);
        if (view == null) {
            return -1;
        }
        VirtualLayoutManager virtualLayoutManager = this;
        int n2 = virtualLayoutManager.getPosition(view);
        if ((n2 = virtualLayoutManager.findRangeLength(Range.create(n2, n2))) >= 0 && n2 < this.mRangeLengths.size()) {
            int n3 = -this.mOrientationHelper.getDecoratedStart(view);
            for (int i3 = 0; i3 < n2; ++i3) {
                Pair<Range<Integer>, Integer> pair = this.mRangeLengths.get(i3);
                if (pair == null) continue;
                n3 += ((Integer)pair.second).intValue();
            }
            return n3;
        }
        return -1;
    }

    @Override
    public void scrollToPosition(int n2) {
        super.scrollToPosition(n2);
    }

    @Override
    public void scrollToPositionWithOffset(int n2, int n3) {
        super.scrollToPositionWithOffset(n2, n3);
    }

    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.State state, int n2) {
        super.smoothScrollToPosition(recyclerView, state, n2);
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return this.mCurrentPendingSavedState == null;
    }

    public void onItemsAdded(RecyclerView recyclerView, int n2, int n3) {
        this.onItemsChanged(recyclerView);
    }

    public void onItemsRemoved(RecyclerView recyclerView, int n2, int n3) {
        this.onItemsChanged(recyclerView);
    }

    public void onItemsUpdated(RecyclerView recyclerView, int n2, int n3) {
        this.onItemsChanged(recyclerView);
    }

    public void onItemsMoved(RecyclerView recyclerView, int n2, int n3, int n4) {
        this.onItemsChanged(recyclerView);
    }

    public void onItemsChanged(RecyclerView object) {
        object = this.mHelperFinder.getLayoutHelpers();
        int n2 = object.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            ((LayoutHelper)object.get(i3)).onItemsChanged(this);
        }
    }

    public boolean checkLayoutParams(RecyclerView.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)layoutParams);
        }
        if (layoutParams instanceof RecyclerView.LayoutParams) {
            return new LayoutParams((RecyclerView.LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    public RecyclerView.LayoutParams generateLayoutParams(Context context, AttributeSet attributeSet) {
        return new InflateLayoutParams(context, attributeSet);
    }

    public void onAdapterChanged(RecyclerView.Adapter adapter, RecyclerView.Adapter adapter2) {
        super.onAdapterChanged(adapter, adapter2);
    }

    @Override
    public void onAttachedToWindow(RecyclerView recyclerView) {
        super.onAttachedToWindow(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    @Override
    public void onDetachedFromWindow(RecyclerView object, RecyclerView.Recycler recycler) {
        VirtualLayoutManager virtualLayoutManager = this;
        super.onDetachedFromWindow((RecyclerView)object, recycler);
        object = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
        int n2 = object.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            ((LayoutHelper)object.get(i3)).clear(this);
        }
        this.mRecyclerView = null;
    }

    public List<View> getFixedViews() {
        LinkedList linkedList;
        if (((VirtualLayoutManager)((Object)linkedList2)).mRecyclerView == null) {
            return Collections.emptyList();
        }
        VirtualLayoutManager virtualLayoutManager = linkedList2;
        LinkedList linkedList2 = linkedList;
        linkedList = new LinkedList();
        List<LayoutHelper> list = virtualLayoutManager.mHelperFinder.getLayoutHelpers();
        int n2 = list.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            View view = list.get(i3).getFixedView();
            if (view == null) continue;
            linkedList2.add(view);
        }
        return linkedList2;
    }

    public void setLayoutViewFactory(@NonNull LayoutViewFactory layoutViewFactory) {
        if (layoutViewFactory != null) {
            this.mLayoutViewFatory = layoutViewFactory;
            return;
        }
        throw new IllegalArgumentException("factory should not be null");
    }

    @Override
    public final View generateLayoutView() {
        RecyclerView recyclerView = virtualLayoutManager.mRecyclerView;
        if (recyclerView == null) {
            return null;
        }
        VirtualLayoutManager virtualLayoutManager = virtualLayoutManager.mLayoutViewFatory.generateLayoutView(recyclerView.getContext());
        LayoutParams layoutParams = new LayoutParams(-2, -2);
        ExposeLinearLayoutManagerEx.attachViewHolder(layoutParams, new LayoutViewHolder((View)virtualLayoutManager));
        virtualLayoutManager.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return virtualLayoutManager;
    }

    @Override
    public void addChildView(View view, int n2) {
        super.addView(view, n2);
    }

    public void moveView(int n2, int n3) {
        super.moveView(n2, n3);
    }

    @Override
    public void addChildView(LayoutStateWrapper layoutStateWrapper, View view) {
        int n2 = layoutStateWrapper.getItemDirection() == 1 ? -1 : 0;
        this.addChildView(layoutStateWrapper, view, n2);
    }

    @Override
    public void addChildView(LayoutStateWrapper layoutStateWrapper, View view, int n2) {
        this.showView(view);
        if (!layoutStateWrapper.hasScrapList()) {
            this.addView(view, n2);
        } else {
            this.addDisappearingView(view, n2);
        }
    }

    @Override
    public void addOffFlowView(View view, boolean bl) {
        VirtualLayoutManager virtualLayoutManager = this;
        virtualLayoutManager.showView(view);
        virtualLayoutManager.addHiddenView(view, bl);
    }

    @Override
    public void addBackgroundView(View view, boolean n2) {
        this.showView(view);
        n2 = n2 != 0 ? 0 : -1;
        this.addView(view, n2);
    }

    @Override
    public void addFixedView(View view) {
        this.addOffFlowView(view, false);
    }

    @Override
    public void hideView(View view) {
        super.hideView(view);
    }

    @Override
    public void showView(View view) {
        super.showView(view);
    }

    @Override
    public RecyclerView getRecyclerView() {
        return this.mRecyclerView;
    }

    @Override
    public RecyclerView.ViewHolder getChildViewHolder(View view) {
        VirtualLayoutManager virtualLayoutManager = virtualLayoutManager.mRecyclerView;
        if (virtualLayoutManager != null) {
            return virtualLayoutManager.getChildViewHolder(view);
        }
        return null;
    }

    @Override
    public boolean isViewHolderUpdated(View view) {
        return (this = this.getChildViewHolder(view)) == null || ExposeLinearLayoutManagerEx.isViewHolderUpdated((RecyclerView.ViewHolder)this);
    }

    @Override
    public void removeChildView(View view) {
        this.removeView(view);
    }

    @Override
    public OrientationHelperEx getMainOrientationHelper() {
        return this.mOrientationHelper;
    }

    @Override
    public OrientationHelperEx getSecondaryOrientationHelper() {
        return this.mSecondaryOrientationHelper;
    }

    @Override
    public void measureChild(View view, int n2, int n3) {
        this.measureChildWithDecorations(view, n2, n3);
    }

    @Override
    public void measureChildWithMargins(View view, int n2, int n3) {
        this.measureChildWithDecorationsAndMargin(view, n2, n3);
    }

    @Override
    public int getChildMeasureSpec(int n2, int n3, boolean bl) {
        return LinearLayoutManager.getChildMeasureSpec((int)n2, (int)0, (int)n3, (boolean)bl);
    }

    public boolean canScrollHorizontally() {
        return this.mCanScrollHorizontally && !this.mNoScrolling;
    }

    public boolean canScrollVertically() {
        return this.mCanScrollVertically && !this.mNoScrolling;
    }

    @Override
    public void layoutChildWithMargins(View view, int n2, int n3, int n4, int n5) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        PerformanceMonitor performanceMonitor = this.mPerformanceMonitor;
        if (performanceMonitor != null) {
            performanceMonitor.recordStart(PHASE_LAYOUT, view);
        }
        VirtualLayoutManager virtualLayoutManager = this;
        int n6 = n2 + marginLayoutParams.leftMargin;
        n2 = n3 + marginLayoutParams.topMargin;
        n3 = n4 - marginLayoutParams.rightMargin;
        n4 = n5 - marginLayoutParams.bottomMargin;
        virtualLayoutManager.layoutDecorated(view, n6, n2, n3, n4);
        PerformanceMonitor performanceMonitor2 = virtualLayoutManager.mPerformanceMonitor;
        if (performanceMonitor2 != null) {
            performanceMonitor2.recordEnd(PHASE_LAYOUT, view);
        }
    }

    @Override
    public void layoutChild(View view, int n2, int n3, int n4, int n5) {
        PerformanceMonitor performanceMonitor = ((VirtualLayoutManager)((Object)performanceMonitor2)).mPerformanceMonitor;
        if (performanceMonitor != null) {
            performanceMonitor.recordStart(PHASE_LAYOUT, view);
        }
        VirtualLayoutManager virtualLayoutManager = performanceMonitor2;
        virtualLayoutManager.layoutDecorated(view, n2, n3, n4, n5);
        PerformanceMonitor performanceMonitor2 = virtualLayoutManager.mPerformanceMonitor;
        if (performanceMonitor2 != null) {
            performanceMonitor2.recordEnd(PHASE_LAYOUT, view);
        }
    }

    @Override
    protected void recycleChildren(RecyclerView.Recycler recycler, int n2, int n3) {
        if (n2 == n3) {
            return;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "Recycling " + Math.abs(n2 - n3) + " items");
        }
        if (n3 > n2) {
            VirtualLayoutManager virtualLayoutManager = this;
            View view = this.getChildAt(n3 - 1);
            int n4 = virtualLayoutManager.getPosition(virtualLayoutManager.getChildAt(n2));
            int n5 = virtualLayoutManager.getPosition(view);
            int n6 = n2;
            while (n2 < n3) {
                VirtualLayoutManager virtualLayoutManager2 = this;
                int n7 = virtualLayoutManager2.getPosition(virtualLayoutManager2.getChildAt(n6));
                if (n7 != -1) {
                    LayoutHelper layoutHelper = this.mHelperFinder.getLayoutHelper(n7);
                    if (layoutHelper != null && !layoutHelper.isRecyclable(n7, n4, n5, this, true)) {
                        ++n6;
                    } else {
                        this.removeAndRecycleViewAt(n6, recycler);
                    }
                } else {
                    this.removeAndRecycleViewAt(n6, recycler);
                }
                ++n2;
            }
        } else {
            VirtualLayoutManager virtualLayoutManager = this;
            View view = this.getChildAt(n2);
            int n8 = virtualLayoutManager.getPosition(virtualLayoutManager.getChildAt(n3 + 1));
            int n9 = virtualLayoutManager.getPosition(view);
            while (n2 > n3) {
                VirtualLayoutManager virtualLayoutManager3 = this;
                int n10 = virtualLayoutManager3.getPosition(virtualLayoutManager3.getChildAt(n2));
                if (n10 != -1) {
                    LayoutHelper layoutHelper = this.mHelperFinder.getLayoutHelper(n10);
                    if (layoutHelper == null || layoutHelper.isRecyclable(n10, n8, n9, this, false)) {
                        this.removeAndRecycleViewAt(n2, recycler);
                    }
                } else {
                    this.removeAndRecycleViewAt(n2, recycler);
                }
                --n2;
            }
        }
    }

    public void detachAndScrapAttachedViews(RecyclerView.Recycler recycler) {
        for (int i3 = this.getChildCount() - 1; i3 >= 0; --i3) {
            VirtualLayoutManager virtualLayoutManager = this;
            RecyclerView.ViewHolder viewHolder = virtualLayoutManager.getChildViewHolder(virtualLayoutManager.getChildAt(i3));
            if (!(viewHolder instanceof CacheViewHolder) || !((CacheViewHolder)viewHolder).needCached()) continue;
            ExposeLinearLayoutManagerEx.ViewHolderWrapper.setFlags(viewHolder, 0, 6);
        }
        super.detachAndScrapAttachedViews(recycler);
    }

    public void detachAndScrapViewAt(int n2, RecyclerView.Recycler recycler) {
        VirtualLayoutManager virtualLayoutManager = this;
        RecyclerView.ViewHolder viewHolder = virtualLayoutManager.getChildViewHolder(virtualLayoutManager.getChildAt(n2));
        if (viewHolder instanceof CacheViewHolder && ((CacheViewHolder)viewHolder).needCached()) {
            ExposeLinearLayoutManagerEx.ViewHolderWrapper.setFlags(viewHolder, 0, 4);
        }
        super.detachAndScrapViewAt(n2, recycler);
    }

    public void detachAndScrapView(View view, RecyclerView.Recycler recycler) {
        super.detachAndScrapView(view, recycler);
    }

    @Override
    public int getContentWidth() {
        return super.getWidth();
    }

    @Override
    public int getContentHeight() {
        return super.getHeight();
    }

    @Override
    public boolean isDoLayoutRTL() {
        return this.isLayoutRTL();
    }

    @Override
    public View findViewByPosition(int n2) {
        View view = super.findViewByPosition(n2);
        if (view != null && this.getPosition(view) == n2) {
            return view;
        }
        for (int i3 = 0; i3 < this.getChildCount(); ++i3) {
            View view2 = this.getChildAt(i3);
            if (view2 == null || this.getPosition(view2) != n2) continue;
            return view2;
        }
        return null;
    }

    @Override
    public void recycleView(View view) {
        ViewParent viewParent;
        if (virtualLayoutManager2.mRecyclerView != null && (viewParent = view.getParent()) != null && viewParent == (viewParent = virtualLayoutManager2.mRecyclerView)) {
            VirtualLayoutManager virtualLayoutManager = virtualLayoutManager2;
            VirtualLayoutManager virtualLayoutManager2 = viewParent.getChildViewHolder(view);
            virtualLayoutManager.mRecyclerView.getRecycledViewPool().putRecycledView((RecyclerView.ViewHolder)virtualLayoutManager2);
        }
    }

    @Override
    public LayoutHelper findLayoutHelperByPosition(int n2) {
        return this.mHelperFinder.getLayoutHelper(n2);
    }

    /*
     * Exception decompiling
     */
    public void onMeasure(RecyclerView.Recycler var1_3, RecyclerView.State var2_4, int var3_5, int var4_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static interface CacheViewHolder {
        public boolean needCached();
    }

    private static class LayoutViewHolder
    extends RecyclerView.ViewHolder {
        public LayoutViewHolder(View view) {
            super(view);
        }
    }

    public static class LayoutStateWrapper {
        public static final int LAYOUT_START = -1;
        public static final int LAYOUT_END = 1;
        static final int INVALID_LAYOUT = Integer.MIN_VALUE;
        public static final int ITEM_DIRECTION_HEAD = -1;
        public static final int ITEM_DIRECTION_TAIL = 1;
        static final int SCOLLING_OFFSET_NaN = Integer.MIN_VALUE;
        private ExposeLinearLayoutManagerEx.LayoutState mLayoutState;

        LayoutStateWrapper() {
        }

        LayoutStateWrapper(ExposeLinearLayoutManagerEx.LayoutState layoutState) {
            this.mLayoutState = layoutState;
        }

        static /* synthetic */ ExposeLinearLayoutManagerEx.LayoutState access$102(LayoutStateWrapper layoutStateWrapper, ExposeLinearLayoutManagerEx.LayoutState layoutState) {
            layoutStateWrapper.mLayoutState = layoutState;
            return layoutState;
        }

        public int getOffset() {
            return this.mLayoutState.mOffset;
        }

        public int getCurrentPosition() {
            return this.mLayoutState.mCurrentPosition;
        }

        public boolean hasScrapList() {
            return this.mLayoutState.mScrapList != null;
        }

        public void skipCurrentPosition() {
            ExposeLinearLayoutManagerEx.LayoutState layoutState = ((LayoutStateWrapper)((Object)layoutState)).mLayoutState;
            layoutState.mCurrentPosition += layoutState.mItemDirection;
        }

        public boolean isRecycle() {
            return this.mLayoutState.mRecycle;
        }

        public boolean isRefreshLayout() {
            return this.mLayoutState.mOnRefresLayout;
        }

        public int getAvailable() {
            return this.mLayoutState.mAvailable;
        }

        public int getItemDirection() {
            return this.mLayoutState.mItemDirection;
        }

        public int getLayoutDirection() {
            return this.mLayoutState.mLayoutDirection;
        }

        public int getScrollingOffset() {
            return this.mLayoutState.mScrollingOffset;
        }

        public int getExtra() {
            return this.mLayoutState.mExtra;
        }

        public boolean isPreLayout() {
            return this.mLayoutState.mIsPreLayout;
        }

        public boolean hasMore(RecyclerView.State state) {
            return this.mLayoutState.hasMore(state);
        }

        public View next(RecyclerView.Recycler recycler) {
            return this.mLayoutState.next(recycler);
        }

        public View retrieve(RecyclerView.Recycler recycler, int n2) {
            int n3 = this.mLayoutState.mCurrentPosition;
            this.mLayoutState.mCurrentPosition = n2;
            this.mLayoutState.mCurrentPosition = n3;
            return this.next(recycler);
        }
    }

    public static class AnchorInfoWrapper {
        public int position;
        public int coordinate;
        public boolean layoutFromEnd;

        AnchorInfoWrapper() {
        }
    }

    public static class InflateLayoutParams
    extends LayoutParams {
        public InflateLayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams {
        public static final int INVALIDE_SIZE = Integer.MIN_VALUE;
        public int zIndex = 0;
        public float mAspectRatio = Float.NaN;
        private int mOriginWidth = Integer.MIN_VALUE;
        private int mOriginHeight = Integer.MIN_VALUE;

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(int n2, int n3) {
            super(n2, n3);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(RecyclerView.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public void storeOriginWidth() {
            if (this.mOriginWidth == Integer.MIN_VALUE) {
                this.mOriginWidth = this.width;
            }
        }

        public void storeOriginHeight() {
            if (this.mOriginHeight == Integer.MIN_VALUE) {
                this.mOriginHeight = this.height;
            }
        }

        public void restoreOriginWidth() {
            int n2 = this.mOriginWidth;
            if (n2 != Integer.MIN_VALUE) {
                this.width = n2;
            }
        }

        public void restoreOriginHeight() {
            int n2 = this.mOriginHeight;
            if (n2 != Integer.MIN_VALUE) {
                this.height = n2;
            }
        }
    }
}

