/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend;

import android.support.v7.widget.RecyclerView;
import android.util.SparseIntArray;
import com.baidu.navisdk.util.common.LogUtil;
import java.io.Closeable;

public final class InnerRecycledViewPool
extends RecyclerView.RecycledViewPool {
    private static final String TAG = "InnerRecycledViewPool";
    private static final int DEFAULT_MAX_SIZE = 100;
    private final RecyclerView.RecycledViewPool mInnerPool;
    private final SparseIntArray mScrapLength;
    private final SparseIntArray mMaxScrap;

    public InnerRecycledViewPool(RecyclerView.RecycledViewPool recycledViewPool) {
        SparseIntArray sparseIntArray;
        SparseIntArray sparseIntArray2;
        InnerRecycledViewPool innerRecycledViewPool = sparseIntArray2;
        sparseIntArray2 = new SparseIntArray();
        v1.mScrapLength = innerRecycledViewPool;
        innerRecycledViewPool = sparseIntArray;
        sparseIntArray = new SparseIntArray();
        v1.mMaxScrap = innerRecycledViewPool;
        v1.mInnerPool = recycledViewPool;
    }

    public InnerRecycledViewPool() {
        RecyclerView.RecycledViewPool recycledViewPool;
        InnerRecycledViewPool innerRecycledViewPool = innerRecycledViewPool2;
        InnerRecycledViewPool innerRecycledViewPool2 = recycledViewPool;
        recycledViewPool = new RecyclerView.RecycledViewPool();
        innerRecycledViewPool(innerRecycledViewPool2);
    }

    private void destroyViewHolder(RecyclerView.ViewHolder viewHolder) {
        block7: {
            block6: {
                InnerRecycledViewPool innerRecycledViewPool = viewHolder.itemView;
                if (innerRecycledViewPool instanceof Closeable) {
                    try {
                        ((Closeable)((Object)innerRecycledViewPool)).close();
                    }
                    catch (Exception exception) {
                        if (!LogUtil.LOGGABLE) break block6;
                        LogUtil.e(TAG, "destroyViewHolder --> view exception = " + exception);
                    }
                }
            }
            if (viewHolder instanceof Closeable) {
                try {
                    ((Closeable)viewHolder).close();
                }
                catch (Exception exception) {
                    if (!LogUtil.LOGGABLE) break block7;
                    LogUtil.e(TAG, "destroyViewHolder --> holder exception = " + exception);
                }
            }
        }
    }

    public void clear() {
        int n2 = this.mScrapLength.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            InnerRecycledViewPool innerRecycledViewPool = this;
            int n3 = innerRecycledViewPool.mScrapLength.keyAt(i3);
            RecyclerView.ViewHolder viewHolder = innerRecycledViewPool.mInnerPool.getRecycledView(n3);
            while (viewHolder != null) {
                InnerRecycledViewPool innerRecycledViewPool2 = this;
                innerRecycledViewPool2.destroyViewHolder(viewHolder);
                viewHolder = innerRecycledViewPool2.mInnerPool.getRecycledView(n3);
            }
        }
        InnerRecycledViewPool innerRecycledViewPool = this;
        innerRecycledViewPool.mScrapLength.clear();
        super.clear();
    }

    public void setMaxRecycledViews(int n2, int n3) {
        RecyclerView.ViewHolder viewHolder = this.mInnerPool.getRecycledView(n2);
        while (viewHolder != null) {
            InnerRecycledViewPool innerRecycledViewPool = this;
            innerRecycledViewPool.destroyViewHolder(viewHolder);
            viewHolder = innerRecycledViewPool.mInnerPool.getRecycledView(n2);
        }
        InnerRecycledViewPool innerRecycledViewPool = this;
        innerRecycledViewPool.mMaxScrap.put(n2, n3);
        innerRecycledViewPool.mScrapLength.put(n2, 0);
        innerRecycledViewPool.mInnerPool.setMaxRecycledViews(n2, n3);
    }

    public RecyclerView.ViewHolder getRecycledView(int n2) {
        int n3;
        RecyclerView.ViewHolder viewHolder = this.mInnerPool.getRecycledView(n2);
        if (viewHolder != null && (n3 = this.mScrapLength.indexOfKey(n2) >= 0 ? this.mScrapLength.get(n2) : 0) > 0) {
            this.mScrapLength.put(n2, n3 - 1);
        }
        return viewHolder;
    }

    public int size() {
        int n2 = 0;
        int n3 = this.mScrapLength.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            n2 += this.mScrapLength.valueAt(i3);
        }
        return n2;
    }

    public void putRecycledView(RecyclerView.ViewHolder viewHolder) {
        int n2 = viewHolder.getItemViewType();
        if (this.mMaxScrap.indexOfKey(n2) < 0) {
            this.mMaxScrap.put(n2, 100);
            this.setMaxRecycledViews(n2, 100);
        }
        int n3 = this.mScrapLength.indexOfKey(n2) >= 0 ? this.mScrapLength.get(n2) : 0;
        if (this.mMaxScrap.get(n2) > n3) {
            InnerRecycledViewPool innerRecycledViewPool = this;
            innerRecycledViewPool.mInnerPool.putRecycledView(viewHolder);
            innerRecycledViewPool.mScrapLength.put(n2, n3 + 1);
        } else {
            this.destroyViewHolder(viewHolder);
        }
    }
}

