/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend;

import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.extend.ViewLifeCycleListener;

public class ViewLifeCycleHelper {
    private ArrayMap<View, STATUS> mViewStatusMap;
    private ViewLifeCycleListener mViewLifeCycleListener;
    private VirtualLayoutManager mVirtualLayoutManager;
    private int scrHeight;

    public ViewLifeCycleHelper(VirtualLayoutManager virtualLayoutManager, @NonNull ViewLifeCycleListener viewLifeCycleListener) {
        ArrayMap arrayMap;
        ViewLifeCycleHelper viewLifeCycleHelper = arrayMap;
        arrayMap = new ArrayMap();
        v1.mViewStatusMap = viewLifeCycleHelper;
        v1.mViewLifeCycleListener = viewLifeCycleListener;
        v1.mVirtualLayoutManager = virtualLayoutManager;
    }

    private STATUS getViewStatus(View view) {
        if (!this.mViewStatusMap.containsKey((Object)view)) {
            this.mViewStatusMap.put((Object)view, (Object)STATUS.DISAPPEARED);
            return STATUS.DISAPPEARED;
        }
        return (STATUS)((Object)this.mViewStatusMap.get((Object)view));
    }

    private void setViewstatus(View view, STATUS sTATUS) {
        this.mViewStatusMap.put((Object)view, (Object)sTATUS);
    }

    private boolean isViewReadyAppearing(View view) {
        return this.getViewStatus(view) == STATUS.DISAPPEARED;
    }

    private void setViewAppearing(View view) {
        STATUS sTATUS = STATUS.APPEARING;
        if (((ViewLifeCycleHelper)((Object)viewLifeCycleListener)).getViewStatus(view) == sTATUS) {
            return;
        }
        ViewLifeCycleHelper viewLifeCycleHelper = viewLifeCycleListener;
        viewLifeCycleHelper.setViewstatus(view, sTATUS);
        ViewLifeCycleListener viewLifeCycleListener = viewLifeCycleHelper.mViewLifeCycleListener;
        if (viewLifeCycleListener != null) {
            viewLifeCycleListener.onAppearing(view);
        }
    }

    private boolean isViewReadyAppeared(View view) {
        return this.getViewStatus(view) == STATUS.APPEARING;
    }

    private void setViewAppeared(View view) {
        STATUS sTATUS = STATUS.APPEARED;
        if (((ViewLifeCycleHelper)((Object)viewLifeCycleListener)).getViewStatus(view) == sTATUS) {
            return;
        }
        ViewLifeCycleHelper viewLifeCycleHelper = viewLifeCycleListener;
        viewLifeCycleHelper.setViewstatus(view, sTATUS);
        ViewLifeCycleListener viewLifeCycleListener = viewLifeCycleHelper.mViewLifeCycleListener;
        if (viewLifeCycleListener != null) {
            viewLifeCycleListener.onAppeared(view);
        }
    }

    private boolean isViewReadyDisAppearing(View view) {
        return this.getViewStatus(view) == STATUS.APPEARED;
    }

    private void setViewDisappearing(View view) {
        STATUS sTATUS = STATUS.DISAPPEARING;
        if (((ViewLifeCycleHelper)((Object)viewLifeCycleListener)).getViewStatus(view) == sTATUS) {
            return;
        }
        ViewLifeCycleHelper viewLifeCycleHelper = viewLifeCycleListener;
        viewLifeCycleHelper.setViewstatus(view, sTATUS);
        ViewLifeCycleListener viewLifeCycleListener = viewLifeCycleHelper.mViewLifeCycleListener;
        if (viewLifeCycleListener != null) {
            viewLifeCycleListener.onDisappearing(view);
        }
    }

    private boolean isViewReadyDisAppeared(View view) {
        return this.getViewStatus(view) == STATUS.DISAPPEARING;
    }

    private void setViewDisappeared(View view) {
        STATUS sTATUS = STATUS.DISAPPEARED;
        if (((ViewLifeCycleHelper)((Object)viewLifeCycleListener)).getViewStatus(view) == sTATUS) {
            return;
        }
        ViewLifeCycleHelper viewLifeCycleHelper = viewLifeCycleListener;
        viewLifeCycleHelper.setViewstatus(view, sTATUS);
        ViewLifeCycleListener viewLifeCycleListener = viewLifeCycleHelper.mViewLifeCycleListener;
        if (viewLifeCycleListener != null) {
            viewLifeCycleListener.onDisappeared(view);
        }
    }

    public void checkViewStatusInScreen() {
        for (int i3 = 0; i3 < this.mVirtualLayoutManager.getChildCount(); ++i3) {
            ViewLifeCycleHelper viewLifeCycleHelper = this;
            View view = viewLifeCycleHelper.mVirtualLayoutManager.getChildAt(i3);
            if (viewLifeCycleHelper.scrHeight == 0) {
                this.scrHeight = view.getContext().getResources().getDisplayMetrics().heightPixels;
            }
            if (this.mVirtualLayoutManager.getVirtualLayoutDirection() == 1) {
                if (view.getTop() <= 0 && view.getBottom() >= 0 && this.isViewReadyDisAppearing(view)) {
                    this.setViewDisappearing(view);
                } else if (view.getTop() <= this.scrHeight && view.getBottom() >= this.scrHeight && this.isViewReadyAppearing(view)) {
                    this.setViewAppearing(view);
                }
            } else if (view.getTop() <= 0 && view.getBottom() >= 0 && this.isViewReadyAppearing(view)) {
                this.setViewAppearing(view);
            } else if (view.getTop() <= this.scrHeight && view.getBottom() >= this.scrHeight && this.isViewReadyDisAppearing(view)) {
                this.setViewDisappearing(view);
            }
            if (view.getTop() >= 0 && view.getBottom() <= this.scrHeight) {
                if (this.isViewReadyAppearing(view)) {
                    this.setViewAppearing(view);
                    continue;
                }
                if (!this.isViewReadyAppeared(view)) continue;
                this.setViewAppeared(view);
                continue;
            }
            if (view.getBottom() > 0 && view.getTop() < this.scrHeight) continue;
            if (this.isViewReadyDisAppearing(view)) {
                this.setViewDisappearing(view);
                continue;
            }
            if (!this.isViewReadyDisAppeared(view)) continue;
            this.setViewDisappeared(view);
        }
    }

    public static final class STATUS
    extends Enum<STATUS> {
        public static final /* enum */ STATUS APPEARING;
        public static final /* enum */ STATUS APPEARED;
        public static final /* enum */ STATUS DISAPPEARING;
        public static final /* enum */ STATUS DISAPPEARED;
        private static final /* synthetic */ STATUS[] $VALUES;

        public static STATUS[] values() {
            return (STATUS[])$VALUES.clone();
        }

        public static STATUS valueOf(String string2) {
            return Enum.valueOf(STATUS.class, string2);
        }

        static {
            STATUS sTATUS;
            APPEARING = new STATUS();
            APPEARED = new STATUS();
            DISAPPEARING = new STATUS();
            STATUS sTATUS2 = sTATUS;
            DISAPPEARED = new STATUS();
            $VALUES = new STATUS[]{APPEARING, APPEARED, DISAPPEARING, sTATUS2};
        }
    }
}

