/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutManagerHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.BaseLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.LayoutChunkResult;
import com.baidu.navisdk.util.common.LogUtil;

public abstract class AbstractFullFillLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "FullFillLayoutHelper";
    protected boolean hasHeader = false;
    protected boolean hasFooter = false;
    protected boolean mLayoutWithAnchor = false;
    private LayoutManagerHelper mTempLayoutHelper;

    protected int getAllChildren(View[] viewArray, RecyclerView.Recycler recycler, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutChunkResult layoutChunkResult, LayoutManagerHelper layoutManagerHelper) {
        View view;
        boolean bl = layoutStateWrapper.getItemDirection() == 1;
        int n2 = 0;
        int n3 = bl ? this.getRange().getLower() : this.getRange().getUpper();
        int n4 = layoutStateWrapper.getCurrentPosition();
        if ((bl ? n4 > n3 : n4 > n3) && LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "Please handle strange order views carefully");
        }
        while (n2 < viewArray.length && !this.isOutOfRange(layoutStateWrapper.getCurrentPosition()) && (view = this.nextView(recycler, layoutStateWrapper, layoutManagerHelper, layoutChunkResult)) != null) {
            viewArray[n2] = view;
            ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
            if (layoutParams == null) {
                view.setLayoutParams(this.generateDefaultLayoutParams());
            } else if (!this.checkLayoutParams(layoutParams)) {
                view.setLayoutParams(this.generateLayoutParams(layoutParams));
            }
            ++n2;
        }
        if (n2 > 0 && !bl) {
            int n5 = 0;
            for (int i3 = n2 - 1; n5 < i3; ++n5, --i3) {
                View[] viewArray2 = viewArray;
                View[] viewArray3 = viewArray;
                layoutStateWrapper = viewArray2[n5];
                viewArray2[n5] = viewArray3[i3];
                viewArray3[i3] = layoutStateWrapper;
            }
        }
        return n2;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutChunkResult layoutChunkResult, LayoutManagerHelper layoutManagerHelper) {
        this.mTempLayoutHelper = layoutManagerHelper;
        this.doLayoutView(recycler, state, layoutStateWrapper, layoutChunkResult, layoutManagerHelper);
        this.mTempLayoutHelper = null;
    }

    protected void doLayoutView(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutChunkResult layoutChunkResult, LayoutManagerHelper layoutManagerHelper) {
    }

    protected void onMeasure(int n2, int n3) {
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
    }

    protected final void setMeasuredDimension(int n2, int n3) {
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfoWrapper, LayoutManagerHelper layoutManagerHelper) {
        if (anchorInfoWrapper.layoutFromEnd) {
            if (!this.hasFooter) {
                anchorInfoWrapper.position = this.getRange().getUpper();
            }
        } else if (!this.hasHeader) {
            anchorInfoWrapper.position = this.getRange().getLower();
        }
        this.mLayoutWithAnchor = true;
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int n2, int n3, int n4, LayoutManagerHelper layoutManagerHelper) {
        super.afterLayout(recycler, state, n2, n3, n4, layoutManagerHelper);
        this.mLayoutWithAnchor = false;
    }

    @Override
    public int computeAlignOffset(int n2, boolean bl, boolean bl2, LayoutManagerHelper layoutManagerHelper) {
        if (layoutManagerHelper.getOrientation() == 1) {
            if (bl) {
                return this.mMarginBottom + this.mPaddingBottom;
            }
            return -this.mMarginTop - this.mPaddingTop;
        }
        if (bl) {
            return this.mMarginRight + this.mPaddingRight;
        }
        return -this.mMarginLeft - this.mPaddingLeft;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return true;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.LayoutParams(layoutParams);
    }

    @Override
    public boolean isRecyclable(int n2, int n3, int n4, LayoutManagerHelper range, boolean bl) {
        range = ((LayoutHelper)((Object)range2)).getRange();
        if (range.contains(n2)) {
            if (((AbstractFullFillLayoutHelper)((Object)range2)).hasHeader && n2 == ((LayoutHelper)((Object)range2)).getRange().getLower()) {
                return true;
            }
            if (((AbstractFullFillLayoutHelper)((Object)range2)).hasFooter && n2 == ((LayoutHelper)((Object)range2)).getRange().getUpper()) {
                return true;
            }
            Range<Integer> range2 = Range.create((Integer)range.getLower() + ((AbstractFullFillLayoutHelper)((Object)range2)).hasHeader, (Integer)range.getUpper() - ((AbstractFullFillLayoutHelper)((Object)range2)).hasFooter);
            return Range.create(n3, n4).contains(range2);
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "Child item not match");
        }
        return true;
    }

    public void setHasHeader(boolean bl) {
        this.hasHeader = bl;
    }

    public void setHasFooter(boolean bl) {
        this.hasFooter = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void calculateRect(int n2, Rect rect, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutManagerHelper layoutManagerHelper) {
        if (layoutManagerHelper.getOrientation() == 1) {
            rect.left = layoutManagerHelper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft;
            rect.right = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingRight() - this.mMarginRight - this.mPaddingRight;
            if (layoutStateWrapper.getLayoutDirection() == -1) {
                int n3 = layoutStateWrapper.getOffset();
                int n4 = this.mLayoutWithAnchor || this.hasFooter ? 0 : this.mMarginBottom + this.mPaddingBottom;
                rect.bottom = n4 = n3 - n4;
                rect.top = n4 - n2;
                return;
            }
            int n5 = layoutStateWrapper.getOffset();
            int n6 = this.mLayoutWithAnchor || this.hasHeader ? 0 : this.mMarginTop + this.mPaddingTop;
            rect.top = n6 = n5 + n6;
            rect.bottom = n6 + n2;
            return;
        }
        rect.top = layoutManagerHelper.getPaddingTop() + this.mMarginTop + this.mPaddingTop;
        rect.bottom = layoutManagerHelper.getContentHeight() - layoutManagerHelper.getPaddingBottom() - this.mMarginBottom - this.mPaddingBottom;
        if (layoutStateWrapper.getLayoutDirection() == -1) {
            int n7 = layoutStateWrapper.getOffset();
            int n8 = this.mLayoutWithAnchor || this.hasFooter ? 0 : this.mMarginRight + this.mPaddingRight;
            rect.right = n8 = n7 - n8;
            rect.left = n8 - n2;
            return;
        }
        int n9 = layoutStateWrapper.getOffset();
        int n10 = this.mLayoutWithAnchor || this.hasHeader ? 0 : this.mMarginLeft + this.mPaddingLeft;
        rect.left = n10 = n9 + n10;
        rect.right = n10 + n2;
    }
}

