/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutManagerHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.OrientationHelperEx;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.LayoutChunkResult;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.MarginLayoutHelper;
import com.baidu.navisdk.util.common.LogUtil;

public abstract class BaseLayoutHelper
extends MarginLayoutHelper {
    private static final String TAG = "BaseLayoutHelper";
    private static final int LAYOUT_TAG = 1193046;
    protected Rect mLayoutRegion;
    View mLayoutView;
    long mBgColor;
    float mAspectRatio;
    private int mItemCount;
    private LayoutViewUnBindListener mLayoutViewUnBindListener;
    private LayoutViewBindListener mLayoutViewBindListener;

    public BaseLayoutHelper() {
        Rect rect;
        BaseLayoutHelper baseLayoutHelper = rect;
        rect = new Rect();
        v1.mLayoutRegion = baseLayoutHelper;
        v1.mBgColor = Long.MIN_VALUE;
        v1.mAspectRatio = Float.NaN;
        v1.mItemCount = 0;
    }

    private int calGap(int n2, int n3) {
        if (n2 < n3) {
            return n3 - n2;
        }
        return 0;
    }

    @Override
    public boolean isFixLayout() {
        return false;
    }

    public long getBgColor() {
        return this.mBgColor;
    }

    public void setBgColor(long l2) {
        this.mBgColor = l2;
    }

    public void setAspectRatio(float f3) {
        this.mAspectRatio = f3;
    }

    public float getAspectRatio() {
        return this.mAspectRatio;
    }

    @Override
    public int getItemCount() {
        return this.mItemCount;
    }

    @Override
    public void setItemCount(int n2) {
        this.mItemCount = n2;
    }

    @Nullable
    public final View nextView(RecyclerView.Recycler recycler, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutManagerHelper layoutManagerHelper, LayoutChunkResult layoutChunkResult) {
        BaseLayoutHelper baseLayoutHelper = layoutStateWrapper.next(recycler);
        if (baseLayoutHelper == null) {
            if (LogUtil.LOGGABLE && !layoutStateWrapper.hasScrapList()) {
                throw new RuntimeException("received null view when unexpected");
            }
            layoutChunkResult.mFinished = true;
            return null;
        }
        layoutManagerHelper.addChildView(layoutStateWrapper, (View)baseLayoutHelper);
        return baseLayoutHelper;
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State object, LayoutManagerHelper layoutManagerHelper) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "call beforeLayout() on " + this.getClass().getSimpleName());
        }
        if (this.requireLayoutView()) {
        } else {
            recycler = this.mLayoutView;
            if (recycler != null) {
                object = this.mLayoutViewUnBindListener;
                if (object != null) {
                    object.onUnbind((View)recycler, this);
                }
                layoutManagerHelper.removeChildView(this.mLayoutView);
                this.mLayoutView = null;
            }
        }
    }

    protected boolean isValidScrolled(int n2) {
        return n2 != Integer.MAX_VALUE && n2 != Integer.MIN_VALUE;
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State object, int n2, int n3, int n4, LayoutManagerHelper layoutManagerHelper) {
        block14: {
            block16: {
                block17: {
                    int n5;
                    int n6;
                    block15: {
                        if (LogUtil.LOGGABLE) {
                            LogUtil.e(TAG, "call afterLayout() on " + this.getClass().getSimpleName());
                        }
                        if (!this.requireLayoutView()) break block14;
                        if (this.isValidScrolled(n4) && (recycler = this.mLayoutView) != null) {
                            BaseLayoutHelper baseLayoutHelper = this;
                            int n7 = baseLayoutHelper.mLayoutView.getTop();
                            int n8 = baseLayoutHelper.mLayoutView.getRight();
                            n2 = baseLayoutHelper.mLayoutView.getBottom();
                            this.mLayoutRegion.union(recycler.getLeft(), n7, n8, n2);
                        }
                        if (this.mLayoutRegion.isEmpty()) break block14;
                        if (this.isValidScrolled(n4)) {
                            if (layoutManagerHelper.getOrientation() == 1) {
                                this.mLayoutRegion.offset(0, -n4);
                            } else {
                                this.mLayoutRegion.offset(-n4, 0);
                            }
                        }
                        LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
                        n6 = layoutManagerHelper2.getContentWidth();
                        n5 = layoutManagerHelper2.getContentHeight();
                        if (layoutManagerHelper2.getOrientation() != 1) break block15;
                        int n9 = n5;
                        n5 = -n9 / 4;
                        n2 = n9 + n9 / 4;
                        if (!this.mLayoutRegion.intersects(0, n5, n6, n2)) break block16;
                        break block17;
                    }
                    int n10 = n6;
                    n6 = -n10 / 4;
                    n2 = n10 + n10 / 4;
                    if (!this.mLayoutRegion.intersects(n6, 0, n2, n5)) break block16;
                }
                if (this.mLayoutView == null) {
                    View view;
                    this.mLayoutView = view = layoutManagerHelper.generateLayoutView();
                    layoutManagerHelper.addOffFlowView(view, true);
                }
                if (layoutManagerHelper.getOrientation() == 1) {
                    BaseLayoutHelper baseLayoutHelper = this;
                    baseLayoutHelper.mLayoutRegion.left = layoutManagerHelper.getPaddingLeft() + this.mMarginLeft;
                    baseLayoutHelper.mLayoutRegion.right = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingRight() - this.mMarginRight;
                } else {
                    BaseLayoutHelper baseLayoutHelper = this;
                    baseLayoutHelper.mLayoutRegion.top = layoutManagerHelper.getPaddingTop() + this.mMarginTop;
                    baseLayoutHelper.mLayoutRegion.bottom = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingBottom() - this.mMarginBottom;
                }
                BaseLayoutHelper baseLayoutHelper = this;
                baseLayoutHelper.bindLayoutView(baseLayoutHelper.mLayoutView);
                return;
            }
            BaseLayoutHelper baseLayoutHelper = this;
            baseLayoutHelper.mLayoutRegion.set(0, 0, 0, 0);
            recycler = baseLayoutHelper.mLayoutView;
            if (recycler != null) {
                recycler.layout(0, 0, 0, 0);
            }
        }
        if ((recycler = this.mLayoutView) != null) {
            object = this.mLayoutViewUnBindListener;
            if (object != null) {
                object.onUnbind((View)recycler, this);
            }
            layoutManagerHelper.removeChildView(this.mLayoutView);
            this.mLayoutView = null;
        }
    }

    @Override
    public void adjustLayout(int n2, int n3, LayoutManagerHelper layoutManagerHelper) {
        if (this.requireLayoutView()) {
            Rect rect;
            Rect rect2 = rect;
            rect = new Rect();
            OrientationHelperEx orientationHelperEx = layoutManagerHelper.getMainOrientationHelper();
            for (int i3 = 0; i3 < layoutManagerHelper.getChildCount(); ++i3) {
                int n4;
                int n5;
                LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
                View view = layoutManagerHelper2.getChildAt(i3);
                int n6 = layoutManagerHelper2.getPosition(view);
                if (!this.getRange().contains(n6)) continue;
                if (view.getVisibility() == 8) {
                    rect2.setEmpty();
                    continue;
                }
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                if (layoutManagerHelper.getOrientation() == 1) {
                    int n7 = layoutManagerHelper.getDecoratedLeft(view) - layoutParams.leftMargin;
                    n5 = orientationHelperEx.getDecoratedStart(view);
                    n6 = layoutManagerHelper.getDecoratedRight(view) + layoutParams.rightMargin;
                    n4 = orientationHelperEx.getDecoratedEnd(view);
                    rect2.union(n7, n5, n6, n4);
                    continue;
                }
                int n8 = orientationHelperEx.getDecoratedStart(view);
                n5 = layoutManagerHelper.getDecoratedTop(view) - layoutParams.topMargin;
                n4 = orientationHelperEx.getDecoratedEnd(view);
                n6 = layoutManagerHelper.getDecoratedBottom(view) + layoutParams.bottomMargin;
                rect2.union(n8, n5, n4, n6);
            }
            if (!rect2.isEmpty()) {
                Rect rect3 = rect2;
                int n9 = rect3.top - this.mPaddingTop;
                int n10 = rect3.right + this.mPaddingRight;
                int n11 = rect3.bottom + this.mPaddingBottom;
                this.mLayoutRegion.set(rect2.left - this.mPaddingLeft, n9, n10, n11);
            } else {
                this.mLayoutRegion.setEmpty();
            }
            View view = this.mLayoutView;
            if (view != null) {
                Rect rect4 = this.mLayoutRegion;
                int n12 = rect4.left;
                int n13 = rect4.top;
                int n14 = rect4.right;
                int n15 = rect4.bottom;
                view.layout(n12, n13, n14, n15);
            }
        }
    }

    @Override
    public final void clear(LayoutManagerHelper layoutManagerHelper) {
        View view = this.mLayoutView;
        if (view != null) {
            LayoutViewUnBindListener layoutViewUnBindListener = this.mLayoutViewUnBindListener;
            if (layoutViewUnBindListener != null) {
                layoutViewUnBindListener.onUnbind(view, this);
            }
            layoutManagerHelper.removeChildView(this.mLayoutView);
            this.mLayoutView = null;
        }
        this.onClear(layoutManagerHelper);
    }

    protected void onClear(LayoutManagerHelper layoutManagerHelper) {
    }

    @Override
    public boolean requireLayoutView() {
        return this.mBgColor != Long.MIN_VALUE || this.mLayoutViewBindListener != null;
    }

    public abstract void layoutViews(RecyclerView.Recycler var1, RecyclerView.State var2, VirtualLayoutManager.LayoutStateWrapper var3, LayoutChunkResult var4, LayoutManagerHelper var5);

    @Override
    public void doLayout(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutChunkResult layoutChunkResult, LayoutManagerHelper layoutManagerHelper) {
        this.layoutViews(recycler, state, layoutStateWrapper, layoutChunkResult, layoutManagerHelper);
    }

    protected void layoutChildWithMargin(View view, int n2, int n3, int n4, int n5, @NonNull LayoutManagerHelper layoutManagerHelper) {
        this.layoutChildWithMargin(view, n2, n3, n4, n5, layoutManagerHelper, false);
    }

    protected void layoutChildWithMargin(View view, int n2, int n3, int n4, int n5, @NonNull LayoutManagerHelper layoutManagerHelper, boolean bl) {
        layoutManagerHelper.layoutChildWithMargins(view, n2, n3, n4, n5);
        if (this.requireLayoutView()) {
            if (bl) {
                int n6 = n2 - this.mPaddingLeft - this.mMarginLeft;
                n2 = n3 - this.mPaddingTop - this.mMarginTop;
                n3 = n4 + this.mPaddingRight + this.mMarginRight;
                int n7 = n5 + this.mPaddingBottom + this.mMarginBottom;
                this.mLayoutRegion.union(n6, n2, n3, n7);
            } else {
                int n8 = n2 - this.mPaddingLeft;
                int n9 = n3 - this.mPaddingTop;
                n2 = n4 + this.mPaddingRight;
                n3 = n5 + this.mPaddingBottom;
                this.mLayoutRegion.union(n8, n9, n2, n3);
            }
        }
    }

    protected void layoutChild(View view, int n2, int n3, int n4, int n5, @NonNull LayoutManagerHelper layoutManagerHelper) {
        this.layoutChild(view, n2, n3, n4, n5, layoutManagerHelper, false);
    }

    protected void layoutChild(View view, int n2, int n3, int n4, int n5, @NonNull LayoutManagerHelper layoutManagerHelper, boolean bl) {
        layoutManagerHelper.layoutChild(view, n2, n3, n4, n5);
        if (this.requireLayoutView()) {
            if (bl) {
                int n6 = n2 - this.mPaddingLeft - this.mMarginLeft;
                n2 = n3 - this.mPaddingTop - this.mMarginTop;
                n3 = n4 + this.mPaddingRight + this.mMarginRight;
                int n7 = n5 + this.mPaddingBottom + this.mMarginBottom;
                this.mLayoutRegion.union(n6, n2, n3, n7);
            } else {
                int n8 = n2 - this.mPaddingLeft;
                int n9 = n3 - this.mPaddingTop;
                n2 = n4 + this.mPaddingRight;
                n3 = n5 + this.mPaddingBottom;
                this.mLayoutRegion.union(n8, n9, n2, n3);
            }
        }
    }

    public void setLayoutViewHelper(DefaultLayoutViewHelper defaultLayoutViewHelper) {
        BaseLayoutHelper baseLayoutHelper = this;
        baseLayoutHelper.mLayoutViewBindListener = defaultLayoutViewHelper;
        baseLayoutHelper.mLayoutViewUnBindListener = defaultLayoutViewHelper;
    }

    public void setLayoutViewBindListener(LayoutViewBindListener layoutViewBindListener) {
        this.mLayoutViewBindListener = layoutViewBindListener;
    }

    public void setLayoutViewUnBindListener(LayoutViewUnBindListener layoutViewUnBindListener) {
        this.mLayoutViewUnBindListener = layoutViewUnBindListener;
    }

    @Override
    public void bindLayoutView(@NonNull View view) {
        LayoutViewBindListener layoutViewBindListener;
        view.measure(View.MeasureSpec.makeMeasureSpec((int)this.mLayoutRegion.width(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mLayoutRegion.height(), (int)0x40000000));
        Rect rect = this.mLayoutRegion;
        int n2 = rect.left;
        int n3 = rect.top;
        int n4 = rect.right;
        int n5 = rect.bottom;
        view.layout(n2, n3, n4, n5);
        long l2 = this.mBgColor;
        if (l2 != Long.MIN_VALUE) {
            view.setBackgroundColor((int)l2);
        }
        if ((layoutViewBindListener = this.mLayoutViewBindListener) != null) {
            layoutViewBindListener.onBind(view, this);
        }
        this.mLayoutRegion.set(0, 0, 0, 0);
    }

    protected void handleStateOnResult(LayoutChunkResult layoutChunkResult, View view) {
        if (view == null) {
            return;
        }
        BaseLayoutHelper baseLayoutHelper = (RecyclerView.LayoutParams)view.getLayoutParams();
        if (baseLayoutHelper.isItemRemoved() || baseLayoutHelper.isItemChanged()) {
            layoutChunkResult.mIgnoreConsumed = true;
        }
        boolean bl = layoutChunkResult.mFocusable || view.isFocusable();
        layoutChunkResult.mFocusable = bl;
    }

    protected void handleStateOnResult(LayoutChunkResult layoutChunkResult, View[] viewArray) {
        if (viewArray == null) {
            return;
        }
        for (int i3 = 0; i3 < viewArray.length; ++i3) {
            View view = viewArray[i3];
            if (view == null) continue;
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                layoutChunkResult.mIgnoreConsumed = true;
            }
            boolean bl = layoutChunkResult.mFocusable || view.isFocusable();
            layoutChunkResult.mFocusable = bl;
            if (bl && layoutChunkResult.mIgnoreConsumed) break;
        }
    }

    protected int computeStartSpace(LayoutManagerHelper object, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        int n3 = 0;
        LayoutHelper layoutHelper = null;
        if (object instanceof VirtualLayoutManager) {
            layoutHelper = ((VirtualLayoutManager)object).findNeighbourNonfixLayoutHelper(this, bl2);
        }
        object = null;
        if (layoutHelper != null && layoutHelper instanceof MarginLayoutHelper) {
            object = (MarginLayoutHelper)layoutHelper;
        }
        if (layoutHelper == this) {
            return 0;
        }
        if (!bl3) {
            n2 = bl ? this.mMarginTop + this.mPaddingTop : this.mMarginLeft + this.mPaddingLeft;
        } else {
            int n4;
            if (object == null) {
                n4 = bl ? this.mMarginTop + this.mPaddingTop : this.mMarginLeft + this.mPaddingLeft;
            } else if (bl) {
                if (bl2) {
                    BaseLayoutHelper baseLayoutHelper = this;
                    n4 = ((MarginLayoutHelper)object).mMarginBottom;
                    n4 = baseLayoutHelper.calGap(n4, baseLayoutHelper.mMarginTop);
                } else {
                    BaseLayoutHelper baseLayoutHelper = this;
                    n4 = ((MarginLayoutHelper)object).mMarginTop;
                    n4 = baseLayoutHelper.calGap(n4, baseLayoutHelper.mMarginBottom);
                }
            } else if (bl2) {
                BaseLayoutHelper baseLayoutHelper = this;
                n4 = ((MarginLayoutHelper)object).mMarginRight;
                n4 = baseLayoutHelper.calGap(n4, baseLayoutHelper.mMarginLeft);
            } else {
                BaseLayoutHelper baseLayoutHelper = this;
                n4 = ((MarginLayoutHelper)object).mMarginLeft;
                n4 = baseLayoutHelper.calGap(n4, baseLayoutHelper.mMarginRight);
            }
            n2 = (bl ? (bl2 ? this.mPaddingTop : this.mPaddingBottom) : (bl2 ? this.mPaddingLeft : this.mPaddingRight)) + n3 + n4;
        }
        return n2;
    }

    protected int computeEndSpace(LayoutManagerHelper layoutManagerHelper, boolean bl, boolean bl2, boolean bl3) {
        return bl ? this.mMarginBottom + this.mPaddingBottom : this.mMarginLeft + this.mPaddingLeft;
    }

    public static class DefaultLayoutViewHelper
    implements LayoutViewBindListener,
    LayoutViewUnBindListener,
    LayoutViewHelper {
        private final LayoutViewBindListener mLayoutViewBindListener;
        private final LayoutViewUnBindListener mLayoutViewUnBindListener;

        public DefaultLayoutViewHelper(LayoutViewBindListener layoutViewBindListener, LayoutViewUnBindListener layoutViewUnBindListener) {
            this.mLayoutViewBindListener = layoutViewBindListener;
            this.mLayoutViewUnBindListener = layoutViewUnBindListener;
        }

        @Override
        public void onBindViewSuccess(View view, String string2) {
            view.setTag(1193046, (Object)string2);
        }

        @Override
        public void onBind(View view, BaseLayoutHelper baseLayoutHelper) {
            if (view.getTag(1193046) == null && (this = ((DefaultLayoutViewHelper)this).mLayoutViewBindListener) != null) {
                this.onBind(view, baseLayoutHelper);
            }
        }

        @Override
        public void onUnbind(View view, BaseLayoutHelper baseLayoutHelper) {
            LayoutViewUnBindListener layoutViewUnBindListener = ((DefaultLayoutViewHelper)layoutViewUnBindListener).mLayoutViewUnBindListener;
            if (layoutViewUnBindListener != null) {
                layoutViewUnBindListener.onUnbind(view, baseLayoutHelper);
            }
            view.setTag(1193046, null);
        }
    }

    public static interface LayoutViewHelper {
        public void onBindViewSuccess(View var1, String var2);
    }

    public static interface LayoutViewUnBindListener {
        public void onUnbind(View var1, BaseLayoutHelper var2);
    }

    public static interface LayoutViewBindListener {
        public void onBind(View var1, BaseLayoutHelper var2);
    }
}

