/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutManagerHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.OrientationHelperEx;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.FixAreaLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.LayoutChunkResult;

public class FixLayoutHelper
extends FixAreaLayoutHelper {
    private static final String TAG = "FixLayoutHelper";
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private int mPos;
    private int mAlignType;
    protected int mX;
    protected int mY;
    private boolean mSketchMeasure;
    protected View mFixView;
    protected boolean mDoNormalHandle;
    private boolean mShouldDrawn;
    private boolean isAddFixViewImmediately;
    private boolean isRemoveFixViewImmediately;
    private FixViewAppearAnimatorListener mFixViewAppearAnimatorListener;
    private FixViewDisappearAnimatorListener mFixViewDisappearAnimatorListener;

    public FixLayoutHelper(int n2, int n3) {
        this(0, n2, n3);
    }

    public FixLayoutHelper(int n2, int n3, int n4) {
        FixViewDisappearAnimatorListener fixViewDisappearAnimatorListener;
        FixViewAppearAnimatorListener fixViewAppearAnimatorListener;
        FixLayoutHelper fixLayoutHelper = object;
        fixLayoutHelper.mPos = -1;
        fixLayoutHelper.mAlignType = 0;
        fixLayoutHelper.mX = 0;
        fixLayoutHelper.mY = 0;
        fixLayoutHelper.mSketchMeasure = false;
        fixLayoutHelper.mFixView = null;
        fixLayoutHelper.mDoNormalHandle = false;
        fixLayoutHelper.mShouldDrawn = true;
        fixLayoutHelper.isAddFixViewImmediately = false;
        fixLayoutHelper.isRemoveFixViewImmediately = true;
        Object object = fixViewAppearAnimatorListener;
        fixViewAppearAnimatorListener = new FixViewAppearAnimatorListener();
        fixLayoutHelper.mFixViewAppearAnimatorListener = object;
        object = fixViewDisappearAnimatorListener;
        fixViewDisappearAnimatorListener = new FixViewDisappearAnimatorListener();
        fixLayoutHelper.mFixViewDisappearAnimatorListener = object;
        fixLayoutHelper.mAlignType = n2;
        fixLayoutHelper.mX = n3;
        fixLayoutHelper.mY = n4;
        fixLayoutHelper.setItemCount(1);
    }

    private void addFixViewWithAnimator(LayoutManagerHelper layoutManagerHelper, View view) {
        FixAreaLayoutHelper.FixViewAnimatorHelper fixViewAnimatorHelper = this.mFixViewAnimatorHelper;
        if (fixViewAnimatorHelper != null) {
            if ((fixViewAnimatorHelper = fixViewAnimatorHelper.onGetFixViewAppearAnimator(view)) != null) {
                FixLayoutHelper fixLayoutHelper = this;
                View view2 = view;
                view2.setVisibility(4);
                layoutManagerHelper.addFixedView(view2);
                fixLayoutHelper.mFixViewAppearAnimatorListener.bindAction(layoutManagerHelper, view);
                fixViewAnimatorHelper.setListener((Animator.AnimatorListener)fixLayoutHelper.mFixViewAppearAnimatorListener).start();
            } else {
                layoutManagerHelper.addFixedView(view);
            }
        } else {
            layoutManagerHelper.addFixedView(view);
        }
        this.isRemoveFixViewImmediately = false;
    }

    private void removeFixViewWithAnimator(RecyclerView.Recycler recycler, LayoutManagerHelper layoutManagerHelper, View view) {
        FixAreaLayoutHelper.FixViewAnimatorHelper fixViewAnimatorHelper;
        if (!this.isRemoveFixViewImmediately && (fixViewAnimatorHelper = this.mFixViewAnimatorHelper) != null) {
            if ((fixViewAnimatorHelper = fixViewAnimatorHelper.onGetFixViewDisappearAnimator(view)) != null) {
                FixLayoutHelper fixLayoutHelper = this;
                fixLayoutHelper.mFixViewDisappearAnimatorListener.bindAction(recycler, layoutManagerHelper, view);
                fixViewAnimatorHelper.setListener((Animator.AnimatorListener)fixLayoutHelper.mFixViewDisappearAnimatorListener).start();
                this.isAddFixViewImmediately = false;
            } else {
                layoutManagerHelper.removeChildView(view);
                recycler.recycleView(view);
                this.isAddFixViewImmediately = false;
            }
        } else {
            layoutManagerHelper.removeChildView(view);
            recycler.recycleView(view);
            this.isAddFixViewImmediately = false;
        }
    }

    private void doMeasureAndLayout(View view, LayoutManagerHelper layoutManagerHelper) {
        if (view != null && layoutManagerHelper != null) {
            int n2;
            int n3;
            int n4;
            int n5;
            LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
            VirtualLayoutManager.LayoutParams layoutParams = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            OrientationHelperEx orientationHelperEx = layoutManagerHelper2.getMainOrientationHelper();
            int n6 = layoutManagerHelper2.getOrientation() == 1 ? 1 : 0;
            if (n6 != 0) {
                n5 = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingLeft() - layoutManagerHelper.getPaddingRight();
                n4 = layoutParams.width;
                if (n4 < 0) {
                    n4 = this.mSketchMeasure && n6 != 0 ? -1 : -2;
                }
                n5 = layoutManagerHelper.getChildMeasureSpec(n5, n4, false);
                if (!Float.isNaN(layoutParams.mAspectRatio) && layoutParams.mAspectRatio > 0.0f) {
                    LayoutManagerHelper layoutManagerHelper3 = layoutManagerHelper;
                    n4 = layoutManagerHelper3.getChildMeasureSpec(layoutManagerHelper3.getContentHeight() - layoutManagerHelper.getPaddingTop() - layoutManagerHelper.getPaddingBottom(), (int)((float)View.MeasureSpec.getSize((int)n5) / layoutParams.mAspectRatio + 0.5f), false);
                } else if (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f) {
                    LayoutManagerHelper layoutManagerHelper4 = layoutManagerHelper;
                    n4 = layoutManagerHelper4.getChildMeasureSpec(layoutManagerHelper4.getContentHeight() - layoutManagerHelper.getPaddingTop() - layoutManagerHelper.getPaddingBottom(), (int)((float)View.MeasureSpec.getSize((int)n5) / this.mAspectRatio + 0.5f), false);
                } else {
                    n4 = layoutManagerHelper.getContentHeight() - layoutManagerHelper.getPaddingTop() - layoutManagerHelper.getPaddingBottom();
                    int n7 = layoutParams.height;
                    if (n7 < 0) {
                        n7 = this.mSketchMeasure && n6 == 0 ? -1 : -2;
                    }
                    n4 = layoutManagerHelper.getChildMeasureSpec(n4, n7, false);
                }
                layoutManagerHelper.measureChildWithMargins(view, n5, n4);
            } else {
                n5 = layoutManagerHelper.getContentHeight() - layoutManagerHelper.getPaddingTop() - layoutManagerHelper.getPaddingBottom();
                n4 = layoutParams.height;
                if (n4 < 0) {
                    n4 = this.mSketchMeasure && n6 == 0 ? -1 : -2;
                }
                n5 = layoutManagerHelper.getChildMeasureSpec(n5, n4, false);
                if (!Float.isNaN(layoutParams.mAspectRatio) && layoutParams.mAspectRatio > 0.0f) {
                    LayoutManagerHelper layoutManagerHelper5 = layoutManagerHelper;
                    n4 = layoutManagerHelper5.getChildMeasureSpec(layoutManagerHelper5.getContentWidth() - layoutManagerHelper.getPaddingLeft() - layoutManagerHelper.getPaddingRight(), (int)((float)View.MeasureSpec.getSize((int)n5) * layoutParams.mAspectRatio + 0.5f), false);
                } else if (!Float.isNaN(this.mAspectRatio) && this.mAspectRatio > 0.0f) {
                    LayoutManagerHelper layoutManagerHelper6 = layoutManagerHelper;
                    n4 = layoutManagerHelper6.getChildMeasureSpec(layoutManagerHelper6.getContentWidth() - layoutManagerHelper.getPaddingLeft() - layoutManagerHelper.getPaddingRight(), (int)((float)View.MeasureSpec.getSize((int)n5) * this.mAspectRatio + 0.5f), false);
                } else {
                    n4 = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingLeft() - layoutManagerHelper.getPaddingRight();
                    int n8 = layoutParams.width;
                    if (n8 < 0) {
                        n8 = this.mSketchMeasure && n6 != 0 ? -1 : -2;
                    }
                    n4 = layoutManagerHelper.getChildMeasureSpec(n4, n8, false);
                }
                layoutManagerHelper.measureChildWithMargins(view, n4, n5);
            }
            n5 = this.mAlignType;
            if (n5 == 1) {
                n3 = layoutManagerHelper.getPaddingTop() + this.mY + this.mAdjuster.top;
                n6 = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingRight() - this.mX - this.mAdjuster.right;
                n5 = n6 - layoutParams.leftMargin - layoutParams.rightMargin - view.getMeasuredWidth();
                n2 = n3 + layoutParams.topMargin + layoutParams.bottomMargin + view.getMeasuredHeight();
                int n9 = n3;
                n3 = n2;
                n2 = n9;
            } else if (n5 == 2) {
                LayoutManagerHelper layoutManagerHelper7 = layoutManagerHelper;
                n5 = layoutManagerHelper7.getPaddingLeft() + this.mX + this.mAdjuster.left;
                n3 = layoutManagerHelper7.getContentHeight() - layoutManagerHelper.getPaddingBottom() - this.mY - this.mAdjuster.bottom;
                n6 = n5 + layoutParams.leftMargin + layoutParams.rightMargin + view.getMeasuredWidth();
                n2 = n3 - view.getMeasuredHeight() - layoutParams.topMargin - layoutParams.bottomMargin;
            } else if (n5 == 3) {
                LayoutManagerHelper layoutManagerHelper8 = layoutManagerHelper;
                n6 = layoutManagerHelper8.getContentWidth() - layoutManagerHelper.getPaddingRight() - this.mX - this.mAdjuster.right;
                n3 = layoutManagerHelper8.getContentHeight() - layoutManagerHelper.getPaddingBottom() - this.mY - this.mAdjuster.bottom;
                n5 = n6 - layoutParams.leftMargin - layoutParams.rightMargin - view.getMeasuredWidth();
                n2 = n3 - view.getMeasuredHeight() - layoutParams.topMargin - layoutParams.bottomMargin;
            } else {
                LayoutManagerHelper layoutManagerHelper9 = layoutManagerHelper;
                n5 = layoutManagerHelper9.getPaddingLeft() + this.mX + this.mAdjuster.left;
                n2 = layoutManagerHelper9.getPaddingTop() + this.mY + this.mAdjuster.top;
                n4 = n6 != 0 ? orientationHelperEx.getDecoratedMeasurementInOther(view) : orientationHelperEx.getDecoratedMeasurement(view);
                int n10 = n6;
                n6 = n5 + n4;
                n3 = n10 != 0 ? orientationHelperEx.getDecoratedMeasurement(view) : orientationHelperEx.getDecoratedMeasurementInOther(view);
                n3 = n2 + n3;
            }
            this.layoutChildWithMargin(view, n5, n2, n6, n3, layoutManagerHelper);
            return;
        }
    }

    static /* synthetic */ boolean access$502(FixLayoutHelper fixLayoutHelper, boolean bl) {
        fixLayoutHelper.isRemoveFixViewImmediately = bl;
        return bl;
    }

    @Override
    public void setItemCount(int n2) {
        if (n2 > 0) {
            super.setItemCount(1);
        } else {
            super.setItemCount(0);
        }
    }

    @Override
    public void setMargin(int n2, int n3, int n4, int n5) {
    }

    public void setX(int n2) {
        this.mX = n2;
    }

    public void setY(int n2) {
        this.mY = n2;
    }

    public void setAlignType(int n2) {
        this.mAlignType = n2;
    }

    public void setSketchMeasure(boolean bl) {
        this.mSketchMeasure = bl;
    }

    @Override
    public void onRangeChange(int n2, int n3) {
        this.mPos = n2;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutChunkResult layoutChunkResult, LayoutManagerHelper layoutManagerHelper) {
        if (this.isOutOfRange(layoutStateWrapper.getCurrentPosition())) {
            return;
        }
        if (!this.mShouldDrawn) {
            layoutStateWrapper.skipCurrentPosition();
            return;
        }
        View view = this.mFixView;
        if (view == null) {
            view = layoutStateWrapper.next(recycler);
        } else {
            layoutStateWrapper.skipCurrentPosition();
        }
        if (view == null) {
            layoutChunkResult.mFinished = true;
            return;
        }
        this.mDoNormalHandle = state.isPreLayout();
        if (this.mDoNormalHandle) {
            layoutManagerHelper.addChildView(layoutStateWrapper, view);
        }
        LayoutChunkResult layoutChunkResult2 = layoutChunkResult;
        this.mFixView = view;
        this.doMeasureAndLayout(view, layoutManagerHelper);
        layoutChunkResult2.mConsumed = 0;
        layoutChunkResult2.mIgnoreConsumed = true;
        this.handleStateOnResult(layoutChunkResult, view);
    }

    @Override
    public boolean requireLayoutView() {
        return false;
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper layoutManagerHelper) {
        FixLayoutHelper fixLayoutHelper = this;
        super.beforeLayout(recycler, state, layoutManagerHelper);
        state = fixLayoutHelper.mFixView;
        if (state != null && layoutManagerHelper.isViewHolderUpdated((View)state)) {
            FixLayoutHelper fixLayoutHelper2 = this;
            layoutManagerHelper.removeChildView(this.mFixView);
            recycler.recycleView(this.mFixView);
            fixLayoutHelper2.mFixView = null;
            fixLayoutHelper2.isAddFixViewImmediately = true;
        }
        this.mDoNormalHandle = false;
    }

    @Override
    public void afterLayout(final RecyclerView.Recycler recycler, RecyclerView.State object, int n2, int n3, int n4, final LayoutManagerHelper layoutManagerHelper) {
        FixLayoutHelper fixLayoutHelper = this;
        super.afterLayout(recycler, (RecyclerView.State)object, n2, n3, n4, layoutManagerHelper);
        if (fixLayoutHelper.mPos < 0) {
            return;
        }
        if (this.mDoNormalHandle && object.isPreLayout()) {
            object = this.mFixView;
            if (object != null) {
                layoutManagerHelper.removeChildView((View)object);
                recycler.recycleView(this.mFixView);
                this.isAddFixViewImmediately = false;
            }
            this.mFixView = null;
            return;
        }
        if (this.shouldBeDraw(layoutManagerHelper, n2, n3, n4)) {
            this.mShouldDrawn = true;
            object = this.mFixView;
            if (object != null) {
                if (object.getParent() == null) {
                    FixLayoutHelper fixLayoutHelper2 = this;
                    fixLayoutHelper2.addFixViewWithAnimator(layoutManagerHelper, fixLayoutHelper2.mFixView);
                } else {
                    layoutManagerHelper.addFixedView(this.mFixView);
                    this.isRemoveFixViewImmediately = false;
                }
            } else {
                Runnable runnable;
                object = runnable;
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        1 v02 = layoutManagerHelper2;
                        v02.FixLayoutHelper.this.mFixView = layoutManagerHelper2.recycler.getViewForPosition(v02.FixLayoutHelper.this.mPos);
                        FixLayoutHelper fixLayoutHelper = v02.FixLayoutHelper.this;
                        View view = fixLayoutHelper.mFixView;
                        fixLayoutHelper.doMeasureAndLayout(view, layoutManagerHelper2.layoutManagerHelper);
                        if (v02.FixLayoutHelper.this.isAddFixViewImmediately) {
                            1 v2 = layoutManagerHelper2;
                            v2.layoutManagerHelper.addFixedView(layoutManagerHelper2.FixLayoutHelper.this.mFixView);
                            FixLayoutHelper.access$502(v2.FixLayoutHelper.this, false);
                        } else {
                            FixLayoutHelper fixLayoutHelper2 = layoutManagerHelper2.FixLayoutHelper.this;
                            LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper2.layoutManagerHelper;
                            fixLayoutHelper2.addFixViewWithAnimator(layoutManagerHelper2, fixLayoutHelper2.mFixView);
                        }
                    }
                };
                if (this.mFixViewDisappearAnimatorListener.isAnimating()) {
                    this.mFixViewDisappearAnimatorListener.withEndAction((Runnable)object);
                } else {
                    object.run();
                }
            }
        } else {
            this.mShouldDrawn = false;
            object = this.mFixView;
            if (object != null) {
                this.removeFixViewWithAnimator(recycler, layoutManagerHelper, (View)object);
                this.mFixView = null;
            }
        }
    }

    protected boolean shouldBeDraw(LayoutManagerHelper layoutManagerHelper, int n2, int n3, int n4) {
        return true;
    }

    @Override
    public View getFixedView() {
        return this.mFixView;
    }

    @Override
    public void onClear(LayoutManagerHelper layoutManagerHelper) {
        FixLayoutHelper fixLayoutHelper = this;
        super.onClear(layoutManagerHelper);
        View view = fixLayoutHelper.mFixView;
        if (view != null) {
            layoutManagerHelper.removeChildView(view);
            layoutManagerHelper.recycleView(this.mFixView);
            this.mFixView.animate().cancel();
            this.mFixView = null;
            this.isAddFixViewImmediately = false;
        }
    }

    private static class FixViewDisappearAnimatorListener
    extends AnimatorListenerAdapter {
        private boolean isAnimating;
        private RecyclerView.Recycler mRecycler;
        private LayoutManagerHelper mLayoutManagerHelper;
        private View mFixView;
        private Runnable mEndAction;

        private FixViewDisappearAnimatorListener() {
        }

        public void bindAction(RecyclerView.Recycler recycler, LayoutManagerHelper layoutManagerHelper, View view) {
            FixViewDisappearAnimatorListener fixViewDisappearAnimatorListener = this;
            fixViewDisappearAnimatorListener.isAnimating = true;
            fixViewDisappearAnimatorListener.mRecycler = recycler;
            fixViewDisappearAnimatorListener.mLayoutManagerHelper = layoutManagerHelper;
            fixViewDisappearAnimatorListener.mFixView = view;
        }

        public void onAnimationStart(Animator animator) {
        }

        public void onAnimationEnd(Animator object) {
            FixViewDisappearAnimatorListener fixViewDisappearAnimatorListener = this;
            fixViewDisappearAnimatorListener.mLayoutManagerHelper.removeChildView(this.mFixView);
            fixViewDisappearAnimatorListener.mRecycler.recycleView(this.mFixView);
            fixViewDisappearAnimatorListener.isAnimating = false;
            object = fixViewDisappearAnimatorListener.mEndAction;
            if (object != null) {
                object.run();
                this.mEndAction = null;
            }
        }

        public boolean isAnimating() {
            return this.isAnimating;
        }

        public void withEndAction(Runnable runnable) {
            this.mEndAction = runnable;
        }
    }

    private static class FixViewAppearAnimatorListener
    extends AnimatorListenerAdapter {
        private LayoutManagerHelper mLayoutManagerHelper;
        private View mFixView;

        private FixViewAppearAnimatorListener() {
        }

        public void bindAction(LayoutManagerHelper layoutManagerHelper, View view) {
            FixViewAppearAnimatorListener fixViewAppearAnimatorListener = this;
            fixViewAppearAnimatorListener.mLayoutManagerHelper = layoutManagerHelper;
            fixViewAppearAnimatorListener.mFixView = view;
        }

        public void onAnimationStart(Animator animator) {
            this.mFixView.setVisibility(0);
        }

        public void onAnimationEnd(Animator animator) {
        }
    }
}

