/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.util.SparseIntArray;
import android.view.View;
import android.widget.TextView;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutManagerHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.OrientationHelperEx;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.BaseLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.LayoutChunkResult;
import com.baidu.navisdk.util.common.LogUtil;
import java.util.Arrays;

public class GridLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "GridLayoutHelper";
    private static final int MAIN_DIR_SPEC = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private int mSpanCount;
    private int mSizePerSpan;
    private int mTotalSize;
    private boolean mIsAutoExpand;
    private boolean mIgnoreExtra;
    @NonNull
    private SpanSizeLookup mSpanSizeLookup;
    private int mVGap;
    private int mHGap;
    private float[] mWeights;
    private View[] mSet;
    private int[] mSpanIndices;
    private int[] mSpanCols;
    private boolean mLayoutWithAnchor;

    public GridLayoutHelper(int n2) {
        this(n2, -1, -1);
    }

    public GridLayoutHelper(int n2, int n3) {
        this(n2, n3, 0);
    }

    public GridLayoutHelper(int n2, int n3, int n4) {
        int n5 = n4;
        this(n2, n3, n5, n5);
    }

    public GridLayoutHelper(int n2, int n3, int n4, int n5) {
        GridLayoutHelper gridLayoutHelper = this;
        this.mSpanCount = 4;
        this.mSizePerSpan = 0;
        this.mTotalSize = 0;
        this.mIsAutoExpand = true;
        this.mIgnoreExtra = false;
        this.mSpanSizeLookup = new DefaultSpanSizeLookup();
        this.mVGap = 0;
        this.mHGap = 0;
        this.mWeights = new float[0];
        this.mLayoutWithAnchor = false;
        gridLayoutHelper.setSpanCount(n2);
        gridLayoutHelper.mSpanSizeLookup.setSpanIndexCacheEnabled(true);
        this.setItemCount(n3);
        this.setVGap(n4);
        this.setHGap(n5);
    }

    private int getMainDirSpec(int n2, int n3, int n4, float f3) {
        if (!Float.isNaN(f3) && f3 > 0.0f && n4 > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)((int)((float)n4 / f3 + 0.5f)), (int)0x40000000);
        }
        if (!Float.isNaN(this.mAspectRatio)) {
            float f4;
            float f5 = this.mAspectRatio;
            if (f4 > 0.0f) {
                return View.MeasureSpec.makeMeasureSpec((int)((int)((float)n3 / f5 + 0.5f)), (int)0x40000000);
            }
        }
        if (n2 < 0) {
            return MAIN_DIR_SPEC;
        }
        return View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
    }

    private void ensureSpanCount() {
        Object[] objectArray = this.mSet;
        if (this.mSet == null || objectArray.length != this.mSpanCount) {
            this.mSet = new View[this.mSpanCount];
        }
        objectArray = this.mSpanIndices;
        if (this.mSpanIndices == null || objectArray.length != this.mSpanCount) {
            this.mSpanIndices = new int[this.mSpanCount];
        }
        objectArray = this.mSpanCols;
        if (this.mSpanCols == null || objectArray.length != this.mSpanCount) {
            this.mSpanCols = new int[this.mSpanCount];
        }
    }

    private int getSpanIndex(RecyclerView.Recycler recycler, RecyclerView.State state, int n2) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getCachedSpanIndex(n2, this.mSpanCount);
        }
        int n3 = recycler.convertPreLayoutPositionToPostLayout(n2);
        if (n3 == -1) {
            return 0;
        }
        return this.mSpanSizeLookup.getCachedSpanIndex(n3, this.mSpanCount);
    }

    private int getSpanSize(RecyclerView.Recycler recycler, RecyclerView.State state, int n2) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanSize(n2);
        }
        int n3 = recycler.convertPreLayoutPositionToPostLayout(n2);
        if (n3 == -1) {
            return 0;
        }
        return this.mSpanSizeLookup.getSpanSize(n3);
    }

    private void assignSpans(RecyclerView.Recycler recycler, RecyclerView.State state, int n2, int n3, boolean n4, LayoutManagerHelper layoutManagerHelper) {
        int n5;
        int n6;
        if (n4 != 0) {
            n4 = 0;
            n6 = 1;
        } else {
            n4 = n2 - 1;
            n2 = -1;
            n6 = -1;
        }
        if (layoutManagerHelper.getOrientation() == 1 && layoutManagerHelper.isDoLayoutRTL()) {
            --n3;
            n5 = -1;
        } else {
            n3 = 0;
            n5 = 1;
        }
        while (n4 != n2) {
            int n7 = this.getSpanSize(recycler, state, layoutManagerHelper.getPosition(this.mSet[n4]));
            this.mSpanIndices[n4] = n5 == -1 && n7 > 1 ? n3 - (n7 - 1) : n3;
            n3 += n5 * n7;
            n4 += n6;
        }
    }

    public void setWeights(float[] fArray) {
        this.mWeights = fArray != null ? Arrays.copyOf(fArray, fArray.length) : new float[0];
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        if (spanSizeLookup != null) {
            SpanSizeLookup spanSizeLookup2 = spanSizeLookup;
            spanSizeLookup2.setStartPosition(this.mSpanSizeLookup.getStartPosition());
            this.mSpanSizeLookup = spanSizeLookup2;
        }
    }

    public void setAutoExpand(boolean bl) {
        this.mIsAutoExpand = bl;
    }

    public void setIgnoreExtra(boolean bl) {
        this.mIgnoreExtra = bl;
    }

    public void setSpanCount(int n2) {
        if (n2 == this.mSpanCount) {
            return;
        }
        if (n2 >= 1) {
            GridLayoutHelper gridLayoutHelper = this;
            gridLayoutHelper.mSpanCount = n2;
            gridLayoutHelper.mSpanSizeLookup.invalidateSpanIndexCache();
            gridLayoutHelper.ensureSpanCount();
            return;
        }
        throw new IllegalArgumentException("Span count should be at least 1. Provided " + n2);
    }

    public int getVGap() {
        return this.mVGap;
    }

    public int getHGap() {
        return this.mHGap;
    }

    public int getSpanCount() {
        return this.mSpanCount;
    }

    @Override
    public void onRangeChange(int n2, int n3) {
        GridLayoutHelper gridLayoutHelper = this;
        gridLayoutHelper.mSpanSizeLookup.setStartPosition(n2);
        gridLayoutHelper.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    public void setGap(int n2) {
        GridLayoutHelper gridLayoutHelper = this;
        gridLayoutHelper.setVGap(n2);
        gridLayoutHelper.setHGap(n2);
    }

    public void setVGap(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.mVGap = n2;
    }

    public void setHGap(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.mHGap = n2;
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutChunkResult layoutChunkResult, LayoutManagerHelper layoutManagerHelper) {
        int n2;
        int n3;
        int n4;
        if (this.isOutOfRange(layoutStateWrapper.getCurrentPosition())) {
            return;
        }
        boolean bl = false;
        int n5 = 0;
        layoutStateWrapper.getCurrentPosition();
        int n6 = layoutManagerHelper.isEnableMarginOverLap();
        int n7 = layoutStateWrapper.getItemDirection();
        int n8 = n7 == 1 ? 1 : 0;
        LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
        OrientationHelperEx orientationHelperEx = layoutManagerHelper2.getMainOrientationHelper();
        boolean bl2 = layoutManagerHelper2.getOrientation() == 1;
        if (bl2) {
            int n9 = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingRight() - layoutManagerHelper.getPaddingLeft() - this.getHorizontalMargin() - this.getHorizontalPadding();
            this.mTotalSize = n4 = n9;
            n4 = this.mSpanCount;
            this.mSizePerSpan = (int)((float)(n9 - (n4 - 1) * this.mHGap) * 1.0f / (float)n4 + 0.5f);
        } else {
            int n10 = layoutManagerHelper.getContentHeight() - layoutManagerHelper.getPaddingBottom() - layoutManagerHelper.getPaddingTop() - this.getVerticalMargin() - this.getVerticalPadding();
            this.mTotalSize = n4 = n10;
            n4 = this.mSpanCount;
            this.mSizePerSpan = (int)((float)(n10 - (n4 - 1) * this.mVGap) * 1.0f / (float)n4 + 0.5f);
        }
        GridLayoutHelper gridLayoutHelper = this;
        int n11 = 0;
        int n12 = gridLayoutHelper.mSpanCount;
        gridLayoutHelper.ensureSpanCount();
        if (n8 == 0) {
            int n13 = this.getSpanIndex(recycler, state, layoutStateWrapper.getCurrentPosition());
            n12 = n13 + this.getSpanSize(recycler, state, layoutStateWrapper.getCurrentPosition());
            if (n13 != this.mSpanCount - 1) {
                n3 = layoutStateWrapper.getCurrentPosition();
                int n14 = this.mSpanCount - n12;
                for (n4 = 0; n4 < this.mSpanCount && n14 > 0 && !this.isOutOfRange(n3 -= n7); ++n4) {
                    n2 = this.getSpanSize(recycler, state, n3);
                    if (n2 <= this.mSpanCount) {
                        View view = layoutStateWrapper.retrieve(recycler, n3);
                        if (view == null) break;
                        if (!bl) {
                            bl = layoutManagerHelper.getReverseLayout() ? n3 == this.getRange().getUpper() : n3 == this.getRange().getLower();
                        }
                        if (n5 == 0) {
                            n5 = (layoutManagerHelper.getReverseLayout() ? n3 == this.getRange().getLower() : n3 == this.getRange().getUpper()) ? 1 : 0;
                        }
                        if ((n14 -= n2) < 0) break;
                        n11 += n2;
                        this.mSet[n4] = view;
                        continue;
                    }
                    throw new IllegalArgumentException("Item at position " + n3 + " requires " + n2 + " spans but GridLayoutManager has only " + this.mSpanCount + " spans.");
                }
                if (n4 > 0) {
                    n7 = 0;
                    for (n3 = n4 - 1; n7 < n3; ++n7, --n3) {
                        View[] viewArray = this.mSet;
                        View[] viewArray2 = this.mSet;
                        View view = viewArray[n7];
                        viewArray[n7] = viewArray2[n3];
                        viewArray2[n3] = view;
                    }
                }
            }
        }
        while (n4 < this.mSpanCount && layoutStateWrapper.hasMore(state) && n12 > 0) {
            n7 = layoutStateWrapper.getCurrentPosition();
            if (this.isOutOfRange(n7)) {
                if (!LogUtil.LOGGABLE) break;
                LogUtil.e(TAG, "pos [" + n7 + "] is out of range");
                break;
            }
            n3 = this.getSpanSize(recycler, state, n7);
            if (n3 <= this.mSpanCount) {
                View view;
                if ((n12 -= n3) < 0 || (view = layoutStateWrapper.next(recycler)) == null) break;
                if (!bl) {
                    bl = layoutManagerHelper.getReverseLayout() ? n7 == this.getRange().getUpper() : n7 == this.getRange().getLower();
                }
                if (n5 == 0) {
                    n5 = (layoutManagerHelper.getReverseLayout() ? n7 == this.getRange().getLower() : n7 == this.getRange().getUpper()) ? 1 : 0;
                }
                n11 += n3;
                this.mSet[n4] = view;
                ++n4;
                continue;
            }
            throw new IllegalArgumentException("Item at position " + n7 + " requires " + n3 + " spans but GridLayoutManager has only " + this.mSpanCount + " spans.");
        }
        if (n4 == 0) {
            return;
        }
        n7 = 0;
        this.assignSpans(recycler, state, n4, n11, n8 != 0, layoutManagerHelper);
        if (n12 > 0 && n4 == n11 && this.mIsAutoExpand) {
            this.mSizePerSpan = bl2 ? (this.mTotalSize - (n4 - 1) * this.mHGap) / n4 : (this.mTotalSize - (n4 - 1) * this.mVGap) / n4;
        } else if (n8 == 0 && n12 == 0 && n4 == n11 && this.mIsAutoExpand) {
            this.mSizePerSpan = bl2 ? (this.mTotalSize - (n4 - 1) * this.mHGap) / n4 : (this.mTotalSize - (n4 - 1) * this.mVGap) / n4;
        }
        n11 = 0;
        float[] fArray = this.mWeights;
        if (this.mWeights != null && fArray.length > 0) {
            n11 = 1;
            int n15 = bl2 ? this.mTotalSize - (n4 - 1) * this.mHGap : this.mTotalSize - (n4 - 1) * this.mVGap;
            int n16 = n12;
            n12 = 0;
            int n17 = n16 > 0 && this.mIsAutoExpand ? n4 : this.mSpanCount;
            int n18 = n15;
            for (n2 = 0; n2 < n17; ++n2) {
                float[] fArray2 = this.mWeights;
                if (n2 < this.mWeights.length && !Float.isNaN(fArray2[n2])) {
                    fArray2 = this.mWeights;
                    if (this.mWeights[n2] >= 0.0f) {
                        float f3 = fArray2[n2];
                        this.mSpanCols[n2] = (int)(f3 * 1.0f / 100.0f * (float)n15 + 0.5f);
                        n18 -= this.mSpanCols[n2];
                        continue;
                    }
                }
                ++n12;
                this.mSpanCols[n2] = -1;
            }
            if (n12 > 0) {
                n12 = n18 / n12;
                for (n15 = 0; n15 < n17; ++n15) {
                    int[] nArray = this.mSpanCols;
                    if (this.mSpanCols[n15] >= 0) continue;
                    nArray[n15] = n12;
                }
            }
        }
        for (n12 = 0; n12 < n4; ++n12) {
            int n19;
            int n20;
            View view = this.mSet[n12];
            int n21 = n8 != 0 ? -1 : 0;
            LayoutManagerHelper layoutManagerHelper3 = layoutManagerHelper;
            layoutManagerHelper3.addChildView(layoutStateWrapper, view, n21);
            n21 = layoutManagerHelper3.getPosition(view);
            n21 = this.getSpanSize(recycler, state, n21);
            if (n11 != 0) {
                n2 = this.mSpanIndices[n12];
                n20 = 0;
                for (int i3 = 0; i3 < n21; ++i3) {
                    n20 += this.mSpanCols[i3 + n2];
                }
                n21 = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, n20), (int)0x40000000);
            } else {
                int n22 = n21;
                n21 = this.mSizePerSpan * n21;
                n2 = Math.max(0, n22 - 1);
                n20 = bl2 ? this.mHGap : this.mVGap;
                n21 = View.MeasureSpec.makeMeasureSpec((int)(n21 + n2 * n20), (int)0x40000000);
            }
            VirtualLayoutManager.LayoutParams layoutParams = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            if (layoutManagerHelper.getOrientation() == 1) {
                n19 = layoutParams.height;
                n20 = this.mTotalSize;
                int n23 = View.MeasureSpec.getSize((int)n21);
                float f4 = layoutParams.mAspectRatio;
                n19 = this.getMainDirSpec(n19, n20, n23, f4);
                layoutManagerHelper.measureChildWithMargins(view, n21, n19);
            } else {
                int n24 = n21;
                int n25 = n21;
                n21 = layoutParams.width;
                n19 = this.mTotalSize;
                n20 = View.MeasureSpec.getSize((int)n25);
                float f5 = layoutParams.mAspectRatio;
                n21 = this.getMainDirSpec(n21, n19, n20, f5);
                n19 = View.MeasureSpec.getSize((int)n24);
                layoutManagerHelper.measureChildWithMargins(view, n21, n19);
            }
            int n26 = orientationHelperEx.getDecoratedMeasurement(view);
            if (n26 <= n7) {
                n26 = n7;
            }
            n7 = n26;
        }
        GridLayoutHelper gridLayoutHelper2 = this;
        n8 = gridLayoutHelper2.getMainDirSpec(n7, gridLayoutHelper2.mTotalSize, 0, Float.NaN);
        for (n12 = 0; n12 < n4; ++n12) {
            int n27;
            View view = this.mSet[n12];
            if (orientationHelperEx.getDecoratedMeasurement(view) == n7) continue;
            int n28 = layoutManagerHelper.getPosition(view);
            n28 = this.getSpanSize(recycler, state, n28);
            if (n11 != 0) {
                n2 = this.mSpanIndices[n12];
                n27 = 0;
                for (int i4 = 0; i4 < n28; ++i4) {
                    n27 += this.mSpanCols[i4 + n2];
                }
                n28 = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, n27), (int)0x40000000);
            } else {
                int n29 = n28;
                n28 = this.mSizePerSpan * n28;
                n2 = Math.max(0, n29 - 1);
                n27 = bl2 ? this.mHGap : this.mVGap;
                n28 = View.MeasureSpec.makeMeasureSpec((int)(n28 + n2 * n27), (int)0x40000000);
            }
            if (layoutManagerHelper.getOrientation() == 1) {
                layoutManagerHelper.measureChildWithMargins(view, n28, n8);
                continue;
            }
            layoutManagerHelper.measureChildWithMargins(view, n8, n28);
        }
        int n30 = 0;
        int n31 = 0;
        if (bl) {
            LayoutManagerHelper layoutManagerHelper4 = layoutManagerHelper;
            n30 = this.computeStartSpace(layoutManagerHelper4, bl2, layoutManagerHelper4.getReverseLayout() ^ true, n6 != 0);
        }
        if (n5 != 0) {
            LayoutManagerHelper layoutManagerHelper5 = layoutManagerHelper;
            n31 = this.computeEndSpace(layoutManagerHelper5, bl2, layoutManagerHelper5.getReverseLayout() ^ true, n6 != 0);
        }
        layoutChunkResult.mConsumed = n7 + n30 + n31;
        n6 = layoutStateWrapper.getLayoutDirection() == -1 ? 1 : 0;
        if (!(this.mLayoutWithAnchor || n5 != 0 && n6 != 0 || bl && n6 == 0)) {
            n6 = layoutChunkResult.mConsumed;
            n8 = bl2 ? this.mVGap : this.mHGap;
            layoutChunkResult.mConsumed = n6 + n8;
        }
        n6 = 0;
        n8 = 0;
        n12 = 0;
        int n32 = 0;
        if (bl2) {
            if (layoutStateWrapper.getLayoutDirection() == -1) {
                n30 = layoutStateWrapper.getOffset() - n31;
                n31 = !this.mLayoutWithAnchor && n5 == 0 ? this.mVGap : 0;
                n32 = n30 - n31;
                n12 = n32 - n7;
            } else {
                n30 = layoutStateWrapper.getOffset() + n30;
                n31 = !this.mLayoutWithAnchor && !bl ? this.mVGap : 0;
                n12 = n30 + n31;
                n32 = n12 + n7;
            }
        } else if (layoutStateWrapper.getLayoutDirection() == -1) {
            n30 = layoutStateWrapper.getOffset() - n31;
            n31 = !this.mLayoutWithAnchor && n5 == 0 ? this.mHGap : 0;
            n8 = n30 - n31;
            n6 = n8 - n7;
        } else {
            n30 = layoutStateWrapper.getOffset() + n30;
            n31 = !this.mLayoutWithAnchor && !bl ? this.mHGap : 0;
            n6 = n30 + n31;
            n8 = n6 + n7;
        }
        for (n30 = 0; n30 < n4; ++n30) {
            View view = this.mSet[n30];
            int n33 = this.mSpanIndices[n30];
            VirtualLayoutManager.LayoutParams layoutParams = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            if (bl2) {
                if (n11 != 0) {
                    n5 = layoutManagerHelper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft;
                    for (n6 = 0; n6 < n33; ++n6) {
                        n5 += this.mSpanCols[n6] + this.mHGap;
                    }
                } else {
                    n5 = layoutManagerHelper.getPaddingLeft() + this.mMarginLeft + this.mPaddingLeft + this.mSizePerSpan * n33 + n33 * this.mHGap;
                }
                n8 = n5 + orientationHelperEx.getDecoratedMeasurementInOther(view);
                n6 = n12;
            } else {
                if (n11 != 0) {
                    n5 = layoutManagerHelper.getPaddingTop() + this.mMarginTop + this.mPaddingTop;
                    for (n7 = 0; n7 < n33; ++n7) {
                        n5 += this.mSpanCols[n7] + this.mVGap;
                    }
                } else {
                    n5 = layoutManagerHelper.getPaddingTop() + this.mMarginTop + this.mPaddingTop + this.mSizePerSpan * n33 + n33 * this.mVGap;
                }
                n32 = n5 + orientationHelperEx.getDecoratedMeasurementInOther(view);
                int n34 = n6;
                n6 = n5;
                n5 = n34;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "layout item in position: " + layoutParams.getViewPosition() + " with text " + ((TextView)view).getText() + " with SpanIndex: " + n33 + " into (" + n5 + ", " + n6 + ", " + n8 + ", " + n32 + " )");
            }
            this.layoutChildWithMargin(view, n5, n6, n8, n32, layoutManagerHelper);
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                layoutChunkResult.mIgnoreConsumed = true;
            }
            layoutChunkResult.mFocusable |= view.isFocusable();
            n12 = n6;
            n6 = n5;
        }
        GridLayoutHelper gridLayoutHelper3 = this;
        gridLayoutHelper3.mLayoutWithAnchor = false;
        Arrays.fill(gridLayoutHelper3.mSet, null);
        Arrays.fill(gridLayoutHelper3.mSpanIndices, 0);
        Arrays.fill(gridLayoutHelper3.mSpanCols, 0);
    }

    @Override
    public int computeAlignOffset(int n2, boolean bl, boolean bl2, LayoutManagerHelper layoutManagerHelper) {
        boolean bl3 = layoutManagerHelper.getOrientation() == 1;
        if (bl) {
            if (n2 == this.getItemCount() - 1) {
                return bl3 ? this.mMarginBottom + this.mPaddingBottom : this.mMarginRight + this.mPaddingRight;
            }
        } else if (n2 == 0) {
            return bl3 ? -this.mMarginTop - this.mPaddingTop : -this.mMarginLeft - this.mPaddingLeft;
        }
        return super.computeAlignOffset(n2, bl, bl2, layoutManagerHelper);
    }

    @Override
    public void onClear(LayoutManagerHelper layoutManagerHelper) {
        GridLayoutHelper gridLayoutHelper = this;
        super.onClear(layoutManagerHelper);
        gridLayoutHelper.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsChanged(LayoutManagerHelper layoutManagerHelper) {
        GridLayoutHelper gridLayoutHelper = this;
        super.onItemsChanged(layoutManagerHelper);
        gridLayoutHelper.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfoWrapper, LayoutManagerHelper layoutManagerHelper) {
        if (state.getItemCount() > 0 && !state.isPreLayout()) {
            int n2 = anchorInfoWrapper.position;
            n2 = this.mSpanSizeLookup.getCachedSpanIndex(n2, this.mSpanCount);
            if (anchorInfoWrapper.layoutFromEnd) {
                while (n2 < this.mSpanCount - 1 && anchorInfoWrapper.position < this.getRange().getUpper()) {
                    anchorInfoWrapper.position = n2 = anchorInfoWrapper.position + 1;
                    n2 = this.mSpanSizeLookup.getCachedSpanIndex(n2, this.mSpanCount);
                }
            } else {
                while (n2 > 0 && (n2 = anchorInfoWrapper.position) > 0) {
                    anchorInfoWrapper.position = --n2;
                    n2 = this.mSpanSizeLookup.getCachedSpanIndex(n2, this.mSpanCount);
                }
            }
            this.mLayoutWithAnchor = true;
        }
    }

    public static abstract class SpanSizeLookup {
        final SparseIntArray mSpanIndexCache;
        private boolean mCacheSpanIndices;
        int mStartPosition;

        public SpanSizeLookup() {
            SparseIntArray sparseIntArray;
            SpanSizeLookup spanSizeLookup = sparseIntArray;
            sparseIntArray = new SparseIntArray();
            v1.mSpanIndexCache = spanSizeLookup;
            v1.mCacheSpanIndices = false;
            v1.mStartPosition = 0;
        }

        public abstract int getSpanSize(int var1);

        public void setSpanIndexCacheEnabled(boolean bl) {
            this.mCacheSpanIndices = bl;
        }

        public void setStartPosition(int n2) {
            this.mStartPosition = n2;
        }

        public int getStartPosition() {
            return this.mStartPosition;
        }

        public void invalidateSpanIndexCache() {
            this.mSpanIndexCache.clear();
        }

        public boolean isSpanIndexCacheEnabled() {
            return this.mCacheSpanIndices;
        }

        int getCachedSpanIndex(int n2, int n3) {
            if (!this.mCacheSpanIndices) {
                return this.getSpanIndex(n2, n3);
            }
            int n4 = this.mSpanIndexCache.get(n2, -1);
            if (n4 != -1) {
                return n4;
            }
            n3 = this.getSpanIndex(n2, n3);
            this.mSpanIndexCache.put(n2, n3);
            return n3;
        }

        public int getSpanIndex(int n2, int n3) {
            int n4;
            int n5 = this.getSpanSize(n2);
            if (n5 == n3) {
                return 0;
            }
            SpanSizeLookup spanSizeLookup = this;
            int n6 = 0;
            int n7 = spanSizeLookup.mStartPosition;
            if (spanSizeLookup.mCacheSpanIndices && this.mSpanIndexCache.size() > 0 && (n4 = this.findReferenceIndexFromCache(n2)) >= 0) {
                n6 = this.mSpanIndexCache.get(n4) + this.getSpanSize(n4);
                n7 = n4 + 1;
            }
            while (n7 < n2) {
                n4 = n6 + (n6 = this.getSpanSize(n7));
                if (n4 == n3) {
                    n4 = 0;
                } else if (n4 > n3) {
                    n4 = n6;
                }
                ++n7;
                n6 = n4;
            }
            if (n6 + n5 <= n3) {
                return n6;
            }
            return 0;
        }

        int findReferenceIndexFromCache(int n2) {
            int n3 = 0;
            int n4 = this.mSpanIndexCache.size() - 1;
            while (n3 <= n4) {
                int n5 = n3 + n4 >>> 1;
                if (this.mSpanIndexCache.keyAt(n5) < n2) {
                    n3 = n5 + 1;
                    continue;
                }
                n4 = n5 - 1;
            }
            n2 = n3 - 1;
            if (n2 >= 0 && n2 < this.mSpanIndexCache.size()) {
                return this.mSpanIndexCache.keyAt(n2);
            }
            return -1;
        }

        public int getSpanGroupIndex(int n2, int n3) {
            int n4 = 0;
            int n5 = 0;
            int n6 = this.getSpanSize(n2);
            for (int i3 = 0; i3 < n2; ++i3) {
                int n7 = n4 + (n4 = this.getSpanSize(i3));
                if (n7 == n3) {
                    n7 = 0;
                    ++n5;
                } else if (n7 > n3) {
                    ++n5;
                    n7 = n4;
                }
                n4 = n7;
            }
            if (n4 + n6 > n3) {
                ++n5;
            }
            return n5;
        }
    }

    static final class DefaultSpanSizeLookup
    extends SpanSizeLookup {
        DefaultSpanSizeLookup() {
        }

        @Override
        public int getSpanSize(int n2) {
            return 1;
        }

        @Override
        public int getSpanIndex(int n2, int n3) {
            return (n2 - this.mStartPosition) % n3;
        }
    }
}

