/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutManagerHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.OrientationHelperEx;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.BaseLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.GridLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.LayoutChunkResult;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.RangeStyle;
import com.baidu.navisdk.util.common.LogUtil;
import java.util.Arrays;

public class RangeGridLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "RGLayoutHelper";
    private static final int MAIN_DIR_SPEC = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
    private final GridRangeStyle mRangeStyle;
    private int mTotalSize;
    private boolean mLayoutWithAnchor;

    public RangeGridLayoutHelper(int n2) {
        this(n2, -1, -1);
    }

    public RangeGridLayoutHelper(int n2, int n3) {
        this(n2, n3, 0);
    }

    public RangeGridLayoutHelper(int n2, int n3, int n4) {
        int n5 = n4;
        this(n2, n3, n5, n5);
    }

    public RangeGridLayoutHelper(int n2, int n3, int n4, int n5) {
        GridRangeStyle gridRangeStyle;
        GridRangeStyle gridRangeStyle2;
        RangeGridLayoutHelper rangeGridLayoutHelper = this;
        rangeGridLayoutHelper.mTotalSize = 0;
        rangeGridLayoutHelper.mLayoutWithAnchor = false;
        GridRangeStyle gridRangeStyle3 = gridRangeStyle2 = gridRangeStyle;
        gridRangeStyle3(this);
        this.mRangeStyle = gridRangeStyle3;
        gridRangeStyle.setSpanCount(n2);
        rangeGridLayoutHelper.mRangeStyle.setVGap(n4);
        rangeGridLayoutHelper.mRangeStyle.setHGap(n5);
        this.setItemCount(n3);
    }

    private int getMainDirSpec(GridRangeStyle gridRangeStyle, int n2, int n3, int n4, float f3) {
        if (!Float.isNaN(f3) && f3 > 0.0f && n4 > 0) {
            return View.MeasureSpec.makeMeasureSpec((int)((int)((float)n4 / f3 + 0.5f)), (int)0x40000000);
        }
        if (!Float.isNaN(gridRangeStyle.mAspectRatio) && gridRangeStyle.mAspectRatio > 0.0f) {
            return View.MeasureSpec.makeMeasureSpec((int)((int)((float)n3 / gridRangeStyle.mAspectRatio + 0.5f)), (int)0x40000000);
        }
        if (n2 < 0) {
            return MAIN_DIR_SPEC;
        }
        return View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
    }

    private int getSpanIndex(GridLayoutHelper.SpanSizeLookup spanSizeLookup, int n2, RecyclerView.Recycler recycler, RecyclerView.State state, int n3) {
        if (!state.isPreLayout()) {
            return spanSizeLookup.getCachedSpanIndex(n3, n2);
        }
        int n4 = recycler.convertPreLayoutPositionToPostLayout(n3);
        if (n4 == -1) {
            return 0;
        }
        return spanSizeLookup.getCachedSpanIndex(n4, n2);
    }

    private int getSpanSize(GridLayoutHelper.SpanSizeLookup spanSizeLookup, RecyclerView.Recycler recycler, RecyclerView.State state, int n2) {
        if (!state.isPreLayout()) {
            return spanSizeLookup.getSpanSize(n2);
        }
        int n3 = recycler.convertPreLayoutPositionToPostLayout(n2);
        if (n3 == -1) {
            return 0;
        }
        return spanSizeLookup.getSpanSize(n3);
    }

    private void assignSpans(GridRangeStyle gridRangeStyle, RecyclerView.Recycler recycler, RecyclerView.State state, int n2, int n3, boolean n4, LayoutManagerHelper layoutManagerHelper) {
        int n5;
        int n6;
        if (n4 != 0) {
            n4 = 0;
            n6 = 1;
        } else {
            n4 = n2 - 1;
            n2 = -1;
            n6 = -1;
        }
        if (layoutManagerHelper.getOrientation() == 1 && layoutManagerHelper.isDoLayoutRTL()) {
            --n3;
            n5 = -1;
        } else {
            n3 = 0;
            n5 = 1;
        }
        while (n4 != n2) {
            GridRangeStyle gridRangeStyle2 = gridRangeStyle;
            View view = gridRangeStyle2.mSet[n4];
            GridLayoutHelper.SpanSizeLookup spanSizeLookup = gridRangeStyle2.mSpanSizeLookup;
            int n7 = layoutManagerHelper.getPosition(view);
            n7 = this.getSpanSize(spanSizeLookup, recycler, state, n7);
            ((GridRangeStyle)gridRangeStyle).mSpanIndices[n4] = n5 == -1 && n7 > 1 ? n3 - (n7 - 1) : n3;
            n3 += n5 * n7;
            n4 += n6;
        }
    }

    public void addRangeStyle(int n2, int n3, GridRangeStyle gridRangeStyle) {
        this.mRangeStyle.addChildRangeStyle(n2, n3, gridRangeStyle);
    }

    public GridRangeStyle getRootRangeStyle() {
        return this.mRangeStyle;
    }

    @Override
    public void setMargin(int n2, int n3, int n4, int n5) {
        RangeGridLayoutHelper rangeGridLayoutHelper = this;
        super.setMargin(n2, n3, n4, n5);
        rangeGridLayoutHelper.mRangeStyle.setMargin(n2, n3, n4, n5);
    }

    @Override
    public void setPadding(int n2, int n3, int n4, int n5) {
        RangeGridLayoutHelper rangeGridLayoutHelper = this;
        super.setPadding(n2, n3, n4, n5);
        rangeGridLayoutHelper.mRangeStyle.setPadding(n2, n3, n4, n5);
    }

    public void setWeights(float[] fArray) {
        this.mRangeStyle.setWeights(fArray);
    }

    public void setSpanSizeLookup(GridLayoutHelper.SpanSizeLookup spanSizeLookup) {
        this.mRangeStyle.setSpanSizeLookup(spanSizeLookup);
    }

    public void setAutoExpand(boolean bl) {
        this.mRangeStyle.setAutoExpand(bl);
    }

    public void setIgnoreExtra(boolean bl) {
        this.mRangeStyle.setIgnoreExtra(bl);
    }

    public void setSpanCount(int n2) {
        this.mRangeStyle.setSpanCount(n2);
    }

    public int getSpanCount() {
        return this.mRangeStyle.getSpanCount();
    }

    @Override
    public void onRangeChange(int n2, int n3) {
        this.mRangeStyle.setRange(n2, n3);
    }

    public void setGap(int n2) {
        RangeGridLayoutHelper rangeGridLayoutHelper = this;
        rangeGridLayoutHelper.setVGap(n2);
        rangeGridLayoutHelper.setHGap(n2);
    }

    public void setVGap(int n2) {
        this.mRangeStyle.setVGap(n2);
    }

    public void setHGap(int n2) {
        this.mRangeStyle.setHGap(n2);
    }

    @Override
    public void setAspectRatio(float f3) {
        this.mRangeStyle.setAspectRatio(f3);
    }

    @Override
    public float getAspectRatio() {
        return this.mRangeStyle.getAspectRatio();
    }

    @Override
    public void setBgColor(long l2) {
        this.mRangeStyle.setBgColor(l2);
    }

    @Override
    public void setLayoutViewHelper(BaseLayoutHelper.DefaultLayoutViewHelper defaultLayoutViewHelper) {
        this.mRangeStyle.setLayoutViewHelper(defaultLayoutViewHelper);
    }

    @Override
    public void setLayoutViewBindListener(BaseLayoutHelper.LayoutViewBindListener layoutViewBindListener) {
        this.mRangeStyle.setLayoutViewBindListener(layoutViewBindListener);
    }

    @Override
    public void setLayoutViewUnBindListener(BaseLayoutHelper.LayoutViewUnBindListener layoutViewUnBindListener) {
        this.mRangeStyle.setLayoutViewUnBindListener(layoutViewUnBindListener);
    }

    @Override
    public boolean requireLayoutView() {
        return this.mRangeStyle.requireLayoutView();
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper layoutManagerHelper) {
        this.mRangeStyle.beforeLayout(recycler, state, layoutManagerHelper);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutChunkResult layoutChunkResult, LayoutManagerHelper layoutManagerHelper) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl;
        OrientationHelperEx orientationHelperEx;
        int n8;
        int n9;
        GridRangeStyle gridRangeStyle;
        int n10;
        int n11;
        int n12;
        int n13;
        block86: {
            GridRangeStyle gridRangeStyle2;
            int n14;
            block87: {
                GridRangeStyle gridRangeStyle3;
                block85: {
                    int n15;
                    block83: {
                        block84: {
                            int n16;
                            if (this.isOutOfRange(layoutStateWrapper.getCurrentPosition())) {
                                return;
                            }
                            n13 = 0;
                            n12 = 0;
                            n14 = 0;
                            n11 = 0;
                            n10 = layoutStateWrapper.getCurrentPosition();
                            gridRangeStyle = this.mRangeStyle.findRangeStyleByPosition(n10);
                            n9 = layoutStateWrapper.getItemDirection();
                            n8 = n9 == 1 ? 1 : 0;
                            LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
                            orientationHelperEx = layoutManagerHelper2.getMainOrientationHelper();
                            bl = layoutManagerHelper2.getOrientation() == 1;
                            if (bl) {
                                this.mTotalSize = n7 = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingRight() - layoutManagerHelper.getPaddingLeft() - gridRangeStyle.getFamilyHorizontalMargin() - gridRangeStyle.getFamilyHorizontalPadding();
                                GridRangeStyle.access$002(gridRangeStyle, (int)((float)(n7 - (gridRangeStyle.mSpanCount - 1) * gridRangeStyle.mHGap) * 1.0f / (float)gridRangeStyle.mSpanCount + 0.5f));
                            } else {
                                this.mTotalSize = n7 = layoutManagerHelper.getContentHeight() - layoutManagerHelper.getPaddingBottom() - layoutManagerHelper.getPaddingTop() - gridRangeStyle.getFamilyVerticalMargin() - gridRangeStyle.getFamilyVerticalPadding();
                                GridRangeStyle.access$002(gridRangeStyle, (int)((float)(n7 - (gridRangeStyle.mSpanCount - 1) * gridRangeStyle.mVGap) * 1.0f / (float)gridRangeStyle.mSpanCount + 0.5f));
                            }
                            GridRangeStyle gridRangeStyle4 = gridRangeStyle;
                            n6 = 0;
                            n5 = gridRangeStyle4.mSpanCount;
                            gridRangeStyle4.ensureSpanCount();
                            if (n8 == 0) {
                                GridRangeStyle gridRangeStyle5 = gridRangeStyle;
                                GridLayoutHelper.SpanSizeLookup spanSizeLookup = gridRangeStyle5.mSpanSizeLookup;
                                n4 = gridRangeStyle5.mSpanCount;
                                int n17 = layoutStateWrapper.getCurrentPosition();
                                int n18 = this.getSpanIndex(spanSizeLookup, n4, recycler, state, n17);
                                spanSizeLookup = gridRangeStyle.mSpanSizeLookup;
                                n4 = layoutStateWrapper.getCurrentPosition();
                                n5 = n18 + this.getSpanSize(spanSizeLookup, recycler, state, n4);
                                if (n18 != gridRangeStyle.mSpanCount - 1) {
                                    n4 = layoutStateWrapper.getCurrentPosition();
                                    n17 = gridRangeStyle.mSpanCount - n5;
                                    for (n7 = 0; n7 < gridRangeStyle.mSpanCount && n17 > 0 && !gridRangeStyle.isOutOfRange(n4 -= n9); n6 += n16, ++n7) {
                                        n16 = this.getSpanSize(gridRangeStyle.mSpanSizeLookup, recycler, state, n4);
                                        if (n16 > gridRangeStyle.mSpanCount) {
                                            throw new IllegalArgumentException("Item at position " + n4 + " requires " + n16 + " spans but RangeGridLayoutHelper has only " + gridRangeStyle.mSpanCount + " spans.");
                                        }
                                        View view = layoutStateWrapper.retrieve(recycler, n4);
                                        if (view == null) break;
                                        if (n13 == 0) {
                                            n13 = (layoutManagerHelper.getReverseLayout() ? n4 == this.mRangeStyle.getRange().getUpper() : n4 == this.mRangeStyle.getRange().getLower()) ? 1 : 0;
                                        }
                                        if (n12 == 0) {
                                            n12 = (layoutManagerHelper.getReverseLayout() ? n4 == this.mRangeStyle.getRange().getLower() : n4 == this.mRangeStyle.getRange().getUpper()) ? 1 : 0;
                                        }
                                        if ((n17 -= n16) < 0) break;
                                        ((GridRangeStyle)gridRangeStyle).mSet[n7] = view;
                                    }
                                    if (n7 > 0) {
                                        n9 = 0;
                                        for (n4 = n7 - 1; n9 < n4; ++n9, --n4) {
                                            GridRangeStyle gridRangeStyle6 = gridRangeStyle;
                                            View view = gridRangeStyle6.mSet[n9];
                                            ((GridRangeStyle)gridRangeStyle6).mSet[n9] = gridRangeStyle.mSet[n4];
                                            ((GridRangeStyle)gridRangeStyle6).mSet[n4] = view;
                                        }
                                    }
                                }
                            }
                            while (n7 < gridRangeStyle.mSpanCount && layoutStateWrapper.hasMore(state) && n5 > 0) {
                                View view;
                                n9 = layoutStateWrapper.getCurrentPosition();
                                if (gridRangeStyle.isOutOfRange(n9)) {
                                    if (!LogUtil.LOGGABLE) break;
                                    LogUtil.e(TAG, "pos [" + n9 + "] is out of range");
                                    break;
                                }
                                n4 = this.getSpanSize(gridRangeStyle.mSpanSizeLookup, recycler, state, n9);
                                if (n4 > gridRangeStyle.mSpanCount) {
                                    throw new IllegalArgumentException("Item at position " + n9 + " requires " + n4 + " spans but GridLayoutManager has only " + gridRangeStyle.mSpanCount + " spans.");
                                }
                                if ((n5 -= n4) < 0 || (view = layoutStateWrapper.next(recycler)) == null) break;
                                if (n13 == 0) {
                                    n13 = (layoutManagerHelper.getReverseLayout() ? n9 == this.mRangeStyle.getRange().getUpper() : n9 == this.mRangeStyle.getRange().getLower()) ? 1 : 0;
                                }
                                if (n14 == 0 && !gridRangeStyle.equals(this.mRangeStyle)) {
                                    if (this.mLayoutWithAnchor) {
                                        n9 = layoutStateWrapper.getCurrentPosition();
                                    }
                                    n14 = (layoutManagerHelper.getReverseLayout() ? n9 == gridRangeStyle.getRange().getUpper() : n9 == gridRangeStyle.getRange().getLower()) ? 1 : 0;
                                }
                                if (n12 == 0) {
                                    n12 = (layoutManagerHelper.getReverseLayout() ? n9 == this.mRangeStyle.getRange().getLower() : n9 == this.mRangeStyle.getRange().getUpper()) ? 1 : 0;
                                }
                                if (n11 == 0 && !gridRangeStyle.equals(this.mRangeStyle)) {
                                    if (this.mLayoutWithAnchor) {
                                        n9 = layoutStateWrapper.getCurrentPosition();
                                    }
                                    n11 = (layoutManagerHelper.getReverseLayout() ? n9 == gridRangeStyle.getRange().getLower() : n9 == gridRangeStyle.getRange().getUpper()) ? 1 : 0;
                                }
                                n6 += n4;
                                ((GridRangeStyle)gridRangeStyle).mSet[n7] = view;
                                ++n7;
                            }
                            if (n7 == 0) {
                                return;
                            }
                            n9 = 0;
                            this.assignSpans(gridRangeStyle, recycler, state, n7, n6, n8 != 0, layoutManagerHelper);
                            if (n5 > 0 && n7 == n6 && gridRangeStyle.mIsAutoExpand) {
                                if (bl) {
                                    GridRangeStyle.access$002(gridRangeStyle, (this.mTotalSize - (n7 - 1) * gridRangeStyle.mHGap) / n7);
                                } else {
                                    GridRangeStyle.access$002(gridRangeStyle, (this.mTotalSize - (n7 - 1) * gridRangeStyle.mVGap) / n7);
                                }
                            } else if (n8 == 0 && n5 == 0 && n7 == n6 && gridRangeStyle.mIsAutoExpand) {
                                if (bl) {
                                    GridRangeStyle.access$002(gridRangeStyle, (this.mTotalSize - (n7 - 1) * gridRangeStyle.mHGap) / n7);
                                } else {
                                    GridRangeStyle.access$002(gridRangeStyle, (this.mTotalSize - (n7 - 1) * gridRangeStyle.mVGap) / n7);
                                }
                            }
                            n6 = 0;
                            if (gridRangeStyle.mWeights != null && gridRangeStyle.mWeights.length > 0) {
                                n6 = 1;
                                n4 = bl ? this.mTotalSize - (n7 - 1) * gridRangeStyle.mHGap : this.mTotalSize - (n7 - 1) * gridRangeStyle.mVGap;
                                int n19 = n5;
                                n5 = 0;
                                int n20 = n19 > 0 && gridRangeStyle.mIsAutoExpand ? n7 : gridRangeStyle.mSpanCount;
                                int n21 = n4;
                                for (n16 = 0; n16 < n20; ++n16) {
                                    if (n16 < gridRangeStyle.mWeights.length && !Float.isNaN(gridRangeStyle.mWeights[n16]) && gridRangeStyle.mWeights[n16] >= 0.0f) {
                                        GridRangeStyle gridRangeStyle7 = gridRangeStyle;
                                        float f3 = gridRangeStyle7.mWeights[n16];
                                        ((GridRangeStyle)gridRangeStyle7).mSpanCols[n16] = (int)(f3 * 1.0f / 100.0f * (float)n4 + 0.5f);
                                        n21 -= gridRangeStyle7.mSpanCols[n16];
                                        continue;
                                    }
                                    ++n5;
                                    ((GridRangeStyle)gridRangeStyle).mSpanCols[n16] = -1;
                                }
                                if (n5 > 0) {
                                    n5 = n21 / n5;
                                    for (n4 = 0; n4 < n20; ++n4) {
                                        if (gridRangeStyle.mSpanCols[n4] >= 0) continue;
                                        ((GridRangeStyle)gridRangeStyle).mSpanCols[n4] = n5;
                                    }
                                }
                            }
                            for (n5 = 0; n5 < n7; ++n5) {
                                int n22;
                                int n23;
                                View view = gridRangeStyle.mSet[n5];
                                int n24 = n8 != 0 ? -1 : 0;
                                layoutManagerHelper.addChildView(layoutStateWrapper, view, n24);
                                GridLayoutHelper.SpanSizeLookup spanSizeLookup = gridRangeStyle.mSpanSizeLookup;
                                n16 = layoutManagerHelper.getPosition(view);
                                int n25 = this.getSpanSize(spanSizeLookup, recycler, state, n16);
                                if (n6 != 0) {
                                    n16 = gridRangeStyle.mSpanIndices[n5];
                                    n23 = 0;
                                    for (n22 = 0; n22 < n25; n23 += gridRangeStyle.mSpanCols[n22 + n16], ++n22) {
                                    }
                                    n25 = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, n23), (int)0x40000000);
                                } else {
                                    int n26 = n25;
                                    n25 = gridRangeStyle.mSizePerSpan * n25;
                                    n16 = Math.max(0, n26 - 1);
                                    n23 = bl ? gridRangeStyle.mHGap : gridRangeStyle.mVGap;
                                    n25 = View.MeasureSpec.makeMeasureSpec((int)(n25 + n16 * n23), (int)0x40000000);
                                }
                                VirtualLayoutManager.LayoutParams layoutParams = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
                                if (layoutManagerHelper.getOrientation() == 1) {
                                    n16 = layoutParams.height;
                                    n23 = this.mTotalSize;
                                    n22 = View.MeasureSpec.getSize((int)n25);
                                    float f4 = layoutParams.mAspectRatio;
                                    n16 = this.getMainDirSpec(gridRangeStyle, n16, n23, n22, f4);
                                    layoutManagerHelper.measureChildWithMargins(view, n25, n16);
                                } else {
                                    int n27 = n25;
                                    int n28 = n25;
                                    n25 = layoutParams.width;
                                    n16 = this.mTotalSize;
                                    n23 = View.MeasureSpec.getSize((int)n28);
                                    float f5 = layoutParams.mAspectRatio;
                                    n25 = this.getMainDirSpec(gridRangeStyle, n25, n16, n23, f5);
                                    n16 = View.MeasureSpec.getSize((int)n27);
                                    layoutManagerHelper.measureChildWithMargins(view, n25, n16);
                                }
                                n4 = orientationHelperEx.getDecoratedMeasurement(view);
                                if (n4 <= n9) {
                                    n4 = n9;
                                }
                                n9 = n4;
                            }
                            RangeGridLayoutHelper rangeGridLayoutHelper = this;
                            n8 = rangeGridLayoutHelper.mTotalSize;
                            n8 = rangeGridLayoutHelper.getMainDirSpec(gridRangeStyle, n9, n8, 0, Float.NaN);
                            for (n5 = 0; n5 < n7; ++n5) {
                                int n29;
                                View view = gridRangeStyle.mSet[n5];
                                if (orientationHelperEx.getDecoratedMeasurement(view) == n9) continue;
                                GridLayoutHelper.SpanSizeLookup spanSizeLookup = gridRangeStyle.mSpanSizeLookup;
                                n16 = layoutManagerHelper.getPosition(view);
                                int n30 = this.getSpanSize(spanSizeLookup, recycler, state, n16);
                                if (n6 != 0) {
                                    n16 = gridRangeStyle.mSpanIndices[n5];
                                    n29 = 0;
                                    for (int i3 = 0; i3 < n30; n29 += gridRangeStyle.mSpanCols[i3 + n16], ++i3) {
                                    }
                                    n30 = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, n29), (int)0x40000000);
                                } else {
                                    int n31 = n30;
                                    n30 = gridRangeStyle.mSizePerSpan * n30;
                                    n16 = Math.max(0, n31 - 1);
                                    n29 = bl ? gridRangeStyle.mHGap : gridRangeStyle.mVGap;
                                    n30 = View.MeasureSpec.makeMeasureSpec((int)(n30 + n16 * n29), (int)0x40000000);
                                }
                                if (layoutManagerHelper.getOrientation() == 1) {
                                    layoutManagerHelper.measureChildWithMargins(view, n30, n8);
                                    continue;
                                }
                                layoutManagerHelper.measureChildWithMargins(view, n8, n30);
                            }
                            n3 = 0;
                            n2 = 0;
                            n8 = 0;
                            n5 = 0;
                            n4 = layoutStateWrapper.getLayoutDirection() == 1 ? 1 : 0;
                            n15 = layoutManagerHelper.isEnableMarginOverLap();
                            if (n13 != 0) {
                                n3 = this.computeStartSpace(layoutManagerHelper, bl, n4 != 0, n15 != 0);
                            }
                            if (n14 != 0) {
                                n8 = bl ? gridRangeStyle.getMarginTop() + gridRangeStyle.getPaddingTop() : gridRangeStyle.getMarginLeft() + gridRangeStyle.getPaddingLeft();
                            }
                            if (n12 != 0) {
                                n2 = bl ? this.mRangeStyle.getMarginBottom() + this.mRangeStyle.getPaddingBottom() : this.mRangeStyle.getMarginRight() + this.mRangeStyle.getPaddingRight();
                            }
                            if (n11 != 0) {
                                n5 = bl ? gridRangeStyle.getMarginBottom() + gridRangeStyle.getPaddingBottom() : gridRangeStyle.getMarginRight() + gridRangeStyle.getPaddingRight();
                            }
                            layoutChunkResult.mConsumed = n9 + n3 + n2 + n8 + n5;
                            n4 = layoutStateWrapper.getLayoutDirection() == -1 ? 1 : 0;
                            n15 = 0;
                            if (this.mLayoutWithAnchor) break block83;
                            if (n4 != 0) break block84;
                            if (n13 != 0) break block83;
                            if (n14 != 0) {
                                n13 = bl ? ((GridRangeStyle)gridRangeStyle.mParent).mVGap : ((GridRangeStyle)gridRangeStyle.mParent).mHGap;
                                if (LogUtil.LOGGABLE) {
                                    LogUtil.e(TAG, "\u2b07 " + n10 + " 1 " + n13 + " gap");
                                }
                                break block85;
                            } else {
                                n13 = bl ? gridRangeStyle.mVGap : gridRangeStyle.mHGap;
                                if (LogUtil.LOGGABLE) {
                                    LogUtil.e(TAG, "\u2b07 " + n10 + " 2 " + n13 + " gap");
                                }
                            }
                            break block85;
                        }
                        if (n12 != 0) break block83;
                        if (n11 != 0) {
                            n13 = bl ? ((GridRangeStyle)gridRangeStyle.mParent).mVGap : ((GridRangeStyle)gridRangeStyle.mParent).mHGap;
                            if (LogUtil.LOGGABLE) {
                                LogUtil.e(TAG, "\u2b06 " + n10 + " 3 " + n13 + " gap");
                            }
                            break block85;
                        } else {
                            n13 = bl ? gridRangeStyle.mVGap : gridRangeStyle.mHGap;
                            if (LogUtil.LOGGABLE) {
                                LogUtil.e(TAG, "\u2b06 " + n10 + " 4 " + n13 + " gap");
                            }
                        }
                        break block85;
                    }
                    n13 = n15;
                }
                if ((layoutChunkResult.mConsumed += n13) <= 0) {
                    layoutChunkResult.mConsumed = 0;
                }
                n12 = 0;
                if (layoutStateWrapper.isRefreshLayout()) break block86;
                if (n4 == 0) break block87;
                n14 = n10 + 1;
                if (!this.isOutOfRange(n14) && (gridRangeStyle3 = this.mRangeStyle.findRangeStyleByPosition(n14)).isFirstPosition(n14)) {
                    n12 = bl ? gridRangeStyle3.getMarginTop() + gridRangeStyle3.getPaddingTop() : gridRangeStyle3.getMarginLeft() + gridRangeStyle3.getPaddingLeft();
                    if (LogUtil.LOGGABLE) {
                        LogUtil.e(TAG, "\u2b06 " + n10 + " 1 " + n12 + " last");
                    }
                }
                break block86;
            }
            n14 = n10 - 1;
            if (!this.isOutOfRange(n14) && (gridRangeStyle2 = this.mRangeStyle.findRangeStyleByPosition(n14)).isLastPosition(n14)) {
                n12 = bl ? gridRangeStyle2.getMarginBottom() + gridRangeStyle2.getPaddingBottom() : gridRangeStyle2.getMarginRight() + gridRangeStyle2.getPaddingRight();
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "\u2b07 " + n10 + " 2 " + n12 + " last");
                }
            }
        }
        if (LogUtil.LOGGABLE) {
            StringBuilder stringBuilder;
            String string2 = TAG;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            String string3 = n4 != 0 ? "\u2b06 " : "\u2b07 ";
            LogUtil.e(string2, stringBuilder2.append(string3).append(n10).append(" consumed ").append(layoutChunkResult.mConsumed).append(" startSpace ").append(n3).append(" endSpace ").append(n2).append(" secondStartSpace ").append(n8).append(" secondEndSpace ").append(n5).append(" lastUnconsumedSpace ").append(n12).toString());
        }
        int n32 = 0;
        n11 = 0;
        n10 = 0;
        int n33 = 0;
        if (bl) {
            if (n4 != 0) {
                n33 = layoutStateWrapper.getOffset() - n2 - n5 - n13 - n12;
                n10 = n33 - n9;
            } else {
                n10 = layoutStateWrapper.getOffset() + n3 + n8 + n13 + n12;
                n33 = n10 + n9;
            }
        } else if (n4 != 0) {
            n11 = layoutStateWrapper.getOffset() - n2 - n13 - n12;
            n32 = n11 - n9;
        } else {
            n32 = layoutStateWrapper.getOffset() + n3 + n13 + n12;
            n11 = n32 + n9;
        }
        n3 = 0;
        while (true) {
            if (n3 >= n7) {
                GridRangeStyle gridRangeStyle8 = gridRangeStyle;
                this.mLayoutWithAnchor = false;
                Arrays.fill(gridRangeStyle8.mSet, null);
                Arrays.fill(gridRangeStyle8.mSpanIndices, 0);
                Arrays.fill(gridRangeStyle8.mSpanCols, 0);
                return;
            }
            View view = gridRangeStyle.mSet[n3];
            int n34 = gridRangeStyle.mSpanIndices[n3];
            VirtualLayoutManager.LayoutParams layoutParams = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
            if (bl) {
                if (n6 != 0) {
                    n12 = layoutManagerHelper.getPaddingLeft() + gridRangeStyle.getFamilyMarginLeft() + gridRangeStyle.getFamilyPaddingLeft();
                    for (n32 = 0; n32 < n34; n12 += gridRangeStyle.mSpanCols[n32] + gridRangeStyle.mHGap, ++n32) {
                    }
                } else {
                    n12 = layoutManagerHelper.getPaddingLeft() + gridRangeStyle.getFamilyMarginLeft() + gridRangeStyle.getFamilyPaddingLeft() + gridRangeStyle.mSizePerSpan * n34 + n34 * gridRangeStyle.mHGap;
                }
                n11 = n12 + orientationHelperEx.getDecoratedMeasurementInOther(view);
                n32 = n10;
            } else {
                if (n6 != 0) {
                    n12 = layoutManagerHelper.getPaddingTop() + gridRangeStyle.getFamilyMarginTop() + gridRangeStyle.getFamilyPaddingTop();
                    for (n10 = 0; n10 < n34; n12 += gridRangeStyle.mSpanCols[n10] + gridRangeStyle.mVGap, ++n10) {
                    }
                } else {
                    n12 = layoutManagerHelper.getPaddingTop() + gridRangeStyle.getFamilyMarginTop() + gridRangeStyle.getFamilyPaddingTop() + gridRangeStyle.mSizePerSpan * n34 + n34 * gridRangeStyle.mVGap;
                }
                n33 = n12 + orientationHelperEx.getDecoratedMeasurementInOther(view);
                int n35 = n32;
                n32 = n12;
                n12 = n35;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "layout item in position: " + layoutParams.getViewPosition() + " with text with SpanIndex: " + n34 + " into (" + n12 + ", " + n32 + ", " + n11 + ", " + n33 + " )");
            }
            gridRangeStyle.layoutChild(view, n12, n32, n11, n33, layoutManagerHelper, false);
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                layoutChunkResult.mIgnoreConsumed = true;
            }
            layoutChunkResult.mFocusable |= view.isFocusable();
            ++n3;
            n10 = n32;
            n32 = n12;
        }
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int n2, int n3, int n4, LayoutManagerHelper layoutManagerHelper) {
        this.mRangeStyle.afterLayout(recycler, state, n2, n3, n4, layoutManagerHelper);
    }

    @Override
    public void adjustLayout(int n2, int n3, LayoutManagerHelper layoutManagerHelper) {
        this.mRangeStyle.adjustLayout(n2, n3, layoutManagerHelper);
    }

    @Override
    public int computeAlignOffset(int n2, boolean bl, boolean bl2, LayoutManagerHelper layoutManagerHelper) {
        boolean bl3 = layoutManagerHelper.getOrientation() == 1;
        if (bl) {
            if (n2 == this.getItemCount() - 1) {
                return GridRangeStyle.computeEndAlignOffset(this.mRangeStyle, bl3);
            }
        } else if (n2 == 0) {
            return GridRangeStyle.computeStartAlignOffset(this.mRangeStyle, bl3);
        }
        return super.computeAlignOffset(n2, bl, bl2, layoutManagerHelper);
    }

    @Override
    public void onClear(LayoutManagerHelper layoutManagerHelper) {
        RangeGridLayoutHelper rangeGridLayoutHelper = this;
        super.onClear(layoutManagerHelper);
        rangeGridLayoutHelper.mRangeStyle.onClear(layoutManagerHelper);
        rangeGridLayoutHelper.mRangeStyle.onInvalidateSpanIndexCache();
    }

    @Override
    public void onItemsChanged(LayoutManagerHelper layoutManagerHelper) {
        RangeGridLayoutHelper rangeGridLayoutHelper = this;
        super.onItemsChanged(layoutManagerHelper);
        rangeGridLayoutHelper.mRangeStyle.onInvalidateSpanIndexCache();
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State object, VirtualLayoutManager.AnchorInfoWrapper anchorInfoWrapper, LayoutManagerHelper layoutManagerHelper) {
        if (object.getItemCount() > 0) {
            object = this.mRangeStyle.findRangeStyleByPosition(anchorInfoWrapper.position);
            int n2 = anchorInfoWrapper.position;
            n2 = ((GridRangeStyle)object).mSpanSizeLookup.getCachedSpanIndex(n2, ((GridRangeStyle)object).mSpanCount);
            if (anchorInfoWrapper.layoutFromEnd) {
                while (n2 < ((GridRangeStyle)object).mSpanCount - 1 && anchorInfoWrapper.position < this.getRange().getUpper()) {
                    ++anchorInfoWrapper.position;
                    n2 = anchorInfoWrapper.position;
                    n2 = ((GridRangeStyle)object).mSpanSizeLookup.getCachedSpanIndex(n2, ((GridRangeStyle)object).mSpanCount);
                }
            } else {
                while (n2 > 0 && (n2 = anchorInfoWrapper.position) > 0) {
                    n2 = anchorInfoWrapper.position = n2 - 1;
                    n2 = ((GridRangeStyle)object).mSpanSizeLookup.getCachedSpanIndex(n2, ((GridRangeStyle)object).mSpanCount);
                }
            }
            this.mLayoutWithAnchor = true;
        }
    }

    public int getBorderStartSpace(LayoutManagerHelper layoutManagerHelper) {
        RangeGridLayoutHelper rangeGridLayoutHelper = this;
        int n2 = rangeGridLayoutHelper.getRange().getLower();
        GridRangeStyle gridRangeStyle = rangeGridLayoutHelper.mRangeStyle.findRangeStyleByPosition(n2);
        if (layoutManagerHelper.getOrientation() == 1) {
            return gridRangeStyle.getFamilyMarginTop() + gridRangeStyle.getFamilyPaddingTop();
        }
        return gridRangeStyle.getFamilyMarginLeft() + gridRangeStyle.getFamilyPaddingLeft();
    }

    public int getBorderEndSpace(LayoutManagerHelper layoutManagerHelper) {
        RangeGridLayoutHelper rangeGridLayoutHelper = this;
        int n2 = rangeGridLayoutHelper.getRange().getUpper();
        GridRangeStyle gridRangeStyle = rangeGridLayoutHelper.mRangeStyle.findRangeStyleByPosition(n2);
        if (layoutManagerHelper.getOrientation() == 1) {
            return gridRangeStyle.getFamilyMarginBottom() + gridRangeStyle.getFamilyPaddingBottom();
        }
        return gridRangeStyle.getFamilyMarginRight() + gridRangeStyle.getFamilyPaddingRight();
    }

    public static class GridRangeStyle
    extends RangeStyle<GridRangeStyle> {
        private float mAspectRatio = Float.NaN;
        private int mSpanCount = 4;
        private int mSizePerSpan = 0;
        private boolean mIsAutoExpand = true;
        private boolean mIgnoreExtra = false;
        @NonNull
        private GridLayoutHelper.SpanSizeLookup mSpanSizeLookup;
        private int mVGap;
        private int mHGap;
        private float[] mWeights;
        private View[] mSet;
        private int[] mSpanIndices;
        private int[] mSpanCols;

        public GridRangeStyle(RangeGridLayoutHelper object) {
            super((BaseLayoutHelper)object);
            GridLayoutHelper.DefaultSpanSizeLookup defaultSpanSizeLookup;
            object = defaultSpanSizeLookup;
            GridRangeStyle gridRangeStyle = this;
            Object object2 = object;
            ((GridLayoutHelper.DefaultSpanSizeLookup)object2)();
            gridRangeStyle.mSpanSizeLookup = object2;
            gridRangeStyle.mVGap = 0;
            gridRangeStyle.mHGap = 0;
            gridRangeStyle.mWeights = new float[0];
            defaultSpanSizeLookup.setSpanIndexCacheEnabled(true);
        }

        public GridRangeStyle() {
            GridLayoutHelper.DefaultSpanSizeLookup defaultSpanSizeLookup;
            GridLayoutHelper.DefaultSpanSizeLookup defaultSpanSizeLookup2 = defaultSpanSizeLookup;
            GridRangeStyle gridRangeStyle = this;
            GridLayoutHelper.DefaultSpanSizeLookup defaultSpanSizeLookup3 = defaultSpanSizeLookup2;
            defaultSpanSizeLookup3();
            gridRangeStyle.mSpanSizeLookup = defaultSpanSizeLookup3;
            gridRangeStyle.mVGap = 0;
            gridRangeStyle.mHGap = 0;
            gridRangeStyle.mWeights = new float[0];
            defaultSpanSizeLookup.setSpanIndexCacheEnabled(true);
        }

        private GridRangeStyle findRangeStyle(GridRangeStyle gridRangeStyle, int n2) {
            int n3 = gridRangeStyle.mChildren.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                GridRangeStyle gridRangeStyle2 = (GridRangeStyle)gridRangeStyle.mChildren.valueAt(i3);
                Range range = (Range)gridRangeStyle.mChildren.keyAt(i3);
                if (!gridRangeStyle2.isChildrenEmpty()) {
                    return this.findRangeStyle(gridRangeStyle2, n2);
                }
                if (!range.contains(n2)) continue;
                return (GridRangeStyle)gridRangeStyle.mChildren.valueAt(i3);
            }
            return gridRangeStyle;
        }

        public static int computeEndAlignOffset(GridRangeStyle gridRangeStyle, boolean bl) {
            int n2 = bl ? gridRangeStyle.mMarginBottom + gridRangeStyle.mPaddingBottom : gridRangeStyle.mMarginRight + gridRangeStyle.mPaddingRight;
            GridRangeStyle gridRangeStyle2 = gridRangeStyle;
            int n3 = gridRangeStyle2.getRange().getUpper();
            int n4 = gridRangeStyle2.mChildren.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                GridRangeStyle gridRangeStyle3 = (GridRangeStyle)gridRangeStyle.mChildren.valueAt(i3);
                if (!gridRangeStyle3.isChildrenEmpty()) {
                    n2 += GridRangeStyle.computeEndAlignOffset(gridRangeStyle3, bl);
                    continue;
                }
                if (gridRangeStyle3.mRange.getUpper() != n3) continue;
                int n5 = bl ? gridRangeStyle3.mMarginBottom + gridRangeStyle3.mPaddingBottom : gridRangeStyle3.mMarginRight + gridRangeStyle3.mPaddingRight;
                n2 += n5;
                break;
            }
            return n2;
        }

        public static int computeStartAlignOffset(GridRangeStyle gridRangeStyle, boolean bl) {
            int n2 = bl ? -gridRangeStyle.mMarginTop - gridRangeStyle.mPaddingTop : -gridRangeStyle.mMarginLeft - gridRangeStyle.mPaddingLeft;
            GridRangeStyle gridRangeStyle2 = gridRangeStyle;
            int n3 = gridRangeStyle2.getRange().getLower();
            int n4 = gridRangeStyle2.mChildren.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                GridRangeStyle gridRangeStyle3 = (GridRangeStyle)gridRangeStyle.mChildren.valueAt(i3);
                if (!gridRangeStyle3.isChildrenEmpty()) {
                    n2 += GridRangeStyle.computeStartAlignOffset(gridRangeStyle3, bl);
                    continue;
                }
                if (gridRangeStyle3.mRange.getLower() != n3) continue;
                int n5 = bl ? -gridRangeStyle3.mMarginTop - gridRangeStyle3.mPaddingTop : -gridRangeStyle3.mMarginLeft - gridRangeStyle3.mPaddingLeft;
                n2 += n5;
                break;
            }
            return n2;
        }

        private void ensureSpanCount() {
            Object[] objectArray = this.mSet;
            if (this.mSet == null || objectArray.length != this.mSpanCount) {
                this.mSet = new View[this.mSpanCount];
            }
            objectArray = this.mSpanIndices;
            if (this.mSpanIndices == null || objectArray.length != this.mSpanCount) {
                this.mSpanIndices = new int[this.mSpanCount];
            }
            objectArray = this.mSpanCols;
            if (this.mSpanCols == null || objectArray.length != this.mSpanCount) {
                this.mSpanCols = new int[this.mSpanCount];
            }
        }

        static /* synthetic */ int access$002(GridRangeStyle gridRangeStyle, int n2) {
            gridRangeStyle.mSizePerSpan = n2;
            return n2;
        }

        public GridRangeStyle findRangeStyleByPosition(int n2) {
            GridRangeStyle gridRangeStyle = this;
            return gridRangeStyle.findRangeStyle(gridRangeStyle, n2);
        }

        public GridRangeStyle findSiblingStyleByPosition(int n2) {
            GridRangeStyle gridRangeStyle;
            GridRangeStyle gridRangeStyle2 = null;
            Object object = this.mParent;
            if (object != null) {
                object = ((GridRangeStyle)object).mChildren;
                int n3 = object.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (!((Range)object.keyAt(i3)).contains(n2)) continue;
                    gridRangeStyle = (GridRangeStyle)object.valueAt(i3);
                    if (gridRangeStyle.equals(this)) break;
                    break;
                }
            } else {
                gridRangeStyle = gridRangeStyle2;
            }
            return gridRangeStyle;
        }

        public void onInvalidateSpanIndexCache() {
            GridRangeStyle gridRangeStyle = this;
            gridRangeStyle.mSpanSizeLookup.invalidateSpanIndexCache();
            int n2 = gridRangeStyle.mChildren.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                ((GridRangeStyle)this.mChildren.valueAt(i3)).onInvalidateSpanIndexCache();
            }
        }

        public void setAspectRatio(float f3) {
            this.mAspectRatio = f3;
        }

        public float getAspectRatio() {
            return this.mAspectRatio;
        }

        @Override
        public void setRange(int n2, int n3) {
            GridRangeStyle gridRangeStyle = this;
            super.setRange(n2, n3);
            gridRangeStyle.mSpanSizeLookup.setStartPosition(n2);
            gridRangeStyle.mSpanSizeLookup.invalidateSpanIndexCache();
        }

        public void setGap(int n2) {
            GridRangeStyle gridRangeStyle = this;
            gridRangeStyle.setVGap(n2);
            gridRangeStyle.setHGap(n2);
        }

        public void setVGap(int n2) {
            if (n2 < 0) {
                n2 = 0;
            }
            this.mVGap = n2;
        }

        public void setHGap(int n2) {
            if (n2 < 0) {
                n2 = 0;
            }
            this.mHGap = n2;
        }

        public void setWeights(float[] fArray) {
            this.mWeights = fArray != null ? Arrays.copyOf(fArray, fArray.length) : new float[0];
        }

        public void setSpanSizeLookup(GridLayoutHelper.SpanSizeLookup spanSizeLookup) {
            if (spanSizeLookup != null) {
                GridLayoutHelper.SpanSizeLookup spanSizeLookup2 = spanSizeLookup;
                spanSizeLookup2.setStartPosition(this.mSpanSizeLookup.getStartPosition());
                this.mSpanSizeLookup = spanSizeLookup2;
            }
        }

        public void setAutoExpand(boolean bl) {
            this.mIsAutoExpand = bl;
        }

        public void setIgnoreExtra(boolean bl) {
            this.mIgnoreExtra = bl;
        }

        public void setSpanCount(int n2) {
            if (n2 == this.mSpanCount) {
                return;
            }
            if (n2 >= 1) {
                GridRangeStyle gridRangeStyle = this;
                gridRangeStyle.mSpanCount = n2;
                gridRangeStyle.mSpanSizeLookup.invalidateSpanIndexCache();
                gridRangeStyle.ensureSpanCount();
                return;
            }
            throw new IllegalArgumentException("Span count should be at least 1. Provided " + n2);
        }

        public int getSpanCount() {
            return this.mSpanCount;
        }
    }
}

