/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.SimpleArrayMap;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutManagerHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.OrientationHelperEx;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.BaseLayoutHelper;
import com.baidu.navisdk.util.common.LogUtil;
import java.lang.reflect.Array;

public class RangeStyle<T extends RangeStyle> {
    private static final String TAG = "RangeStyle";
    protected BaseLayoutHelper mLayoutHelper;
    protected T mParent;
    private int mOriginStartOffset = 0;
    private int mOriginEndOffset = 0;
    protected Range<Integer> mRange;
    protected ArrayMap<Range<Integer>, T> mChildren;
    protected int mPaddingLeft;
    protected int mPaddingRight;
    protected int mPaddingTop;
    protected int mPaddingBottom;
    protected int mMarginLeft;
    protected int mMarginRight;
    protected int mMarginTop;
    protected int mMarginBottom;
    protected Rect mLayoutRegion;
    private View mLayoutView;
    private long mBgColor;
    private BaseLayoutHelper.LayoutViewUnBindListener mLayoutViewUnBindListener;
    private BaseLayoutHelper.LayoutViewBindListener mLayoutViewBindListener;

    public RangeStyle(BaseLayoutHelper baseLayoutHelper) {
        Rect rect;
        ArrayMap arrayMap;
        RangeStyle rangeStyle = arrayMap;
        arrayMap = new ArrayMap();
        v1.mChildren = rangeStyle;
        rangeStyle = rect;
        rect = new Rect();
        v1.mLayoutRegion = rangeStyle;
        v1.mBgColor = Long.MIN_VALUE;
        v1.mLayoutHelper = baseLayoutHelper;
    }

    public RangeStyle() {
        Rect rect;
        ArrayMap arrayMap;
        RangeStyle rangeStyle = arrayMap;
        arrayMap = new ArrayMap();
        v1.mChildren = rangeStyle;
        rangeStyle = rect;
        rect = new Rect();
        v1.mLayoutRegion = rangeStyle;
        v1.mBgColor = Long.MIN_VALUE;
    }

    private boolean isValidScrolled(int n2) {
        return n2 != Integer.MAX_VALUE && n2 != Integer.MIN_VALUE;
    }

    private void unionChildRegion(RangeStyle<T> rangeStyle) {
        if (!rangeStyle.isChildrenEmpty()) {
            int n2 = rangeStyle.mChildren.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                RangeStyle rangeStyle2 = (RangeStyle)rangeStyle.mChildren.valueAt(i3);
                this.unionChildRegion(rangeStyle2);
                View view = rangeStyle2.mLayoutView;
                if (view == null) continue;
                RangeStyle rangeStyle3 = rangeStyle2;
                int n3 = rangeStyle3.mLayoutView.getTop();
                int n4 = rangeStyle3.mLayoutView.getRight();
                int n5 = rangeStyle3.mLayoutView.getBottom();
                rangeStyle.mLayoutRegion.union(view.getLeft(), n3, n4, n5);
            }
        }
    }

    private void removeChildViews(LayoutManagerHelper layoutManagerHelper, RangeStyle<T> rangeStyle) {
        View view;
        if (!rangeStyle.isChildrenEmpty()) {
            int n2 = rangeStyle.mChildren.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                this.removeChildViews(layoutManagerHelper, (RangeStyle)rangeStyle.mChildren.valueAt(i3));
            }
        }
        if ((view = rangeStyle.mLayoutView) != null) {
            BaseLayoutHelper.LayoutViewUnBindListener layoutViewUnBindListener = rangeStyle.mLayoutViewUnBindListener;
            if (layoutViewUnBindListener != null) {
                layoutViewUnBindListener.onUnbind(view, this.getLayoutHelper());
            }
            layoutManagerHelper.removeChildView(rangeStyle.mLayoutView);
            rangeStyle.mLayoutView = null;
        }
    }

    private void hideLayoutViews(LayoutManagerHelper layoutManagerHelper) {
        if (rangeStyle2.isRoot()) {
            RangeStyle rangeStyle = rangeStyle2;
            rangeStyle.hideChildLayoutViews(layoutManagerHelper, rangeStyle2);
            RangeStyle rangeStyle2 = rangeStyle.mLayoutView;
            if (rangeStyle2 != null) {
                layoutManagerHelper.hideView((View)rangeStyle2);
            }
        }
    }

    private void hideChildLayoutViews(LayoutManagerHelper layoutManagerHelper, RangeStyle<T> rangeStyle) {
        int n2 = rangeStyle.mChildren.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            RangeStyle rangeStyle2 = (RangeStyle)rangeStyle.mChildren.valueAt(i3);
            if (!rangeStyle2.isChildrenEmpty()) {
                this.hideChildLayoutViews(layoutManagerHelper, rangeStyle2);
            }
            if ((rangeStyle2 = rangeStyle2.mLayoutView) == null) continue;
            layoutManagerHelper.hideView((View)rangeStyle2);
        }
    }

    private boolean requireChildLayoutView(RangeStyle<T> rangeStyle) {
        boolean bl = rangeStyle.mBgColor != Long.MIN_VALUE || rangeStyle.mLayoutViewBindListener != null;
        int n2 = rangeStyle.mChildren.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            RangeStyle rangeStyle2 = (RangeStyle)rangeStyle.mChildren.valueAt(i3);
            if (!rangeStyle2.isChildrenEmpty()) {
                bl |= this.requireChildLayoutView(rangeStyle2);
                continue;
            }
            return rangeStyle2.requireLayoutView();
        }
        return bl;
    }

    private void clearChild(LayoutManagerHelper layoutManagerHelper, RangeStyle<T> rangeStyle) {
        View view = rangeStyle.mLayoutView;
        if (view != null) {
            BaseLayoutHelper.LayoutViewUnBindListener layoutViewUnBindListener = rangeStyle.mLayoutViewUnBindListener;
            if (layoutViewUnBindListener != null) {
                layoutViewUnBindListener.onUnbind(view, this.getLayoutHelper());
            }
            layoutManagerHelper.removeChildView(rangeStyle.mLayoutView);
            rangeStyle.mLayoutView = null;
        }
        if (rangeStyle.mChildren.isEmpty()) {
            return;
        }
        int n2 = rangeStyle.mChildren.size();
        for (int i3 = 0; i3 < n2; ++i3) {
            this.clearChild(layoutManagerHelper, (RangeStyle)rangeStyle.mChildren.valueAt(i3));
        }
    }

    public void addChildRangeStyle(int n2, int n3, T rangeStyle) {
        if (n2 <= n3 && rangeStyle != null) {
            rangeStyle.setParent((RangeStyle)this);
            rangeStyle.setOriginStartOffset(n2);
            rangeStyle.setOriginEndOffset(n3);
            rangeStyle.setRange(n2, n3);
            this.mChildren.put(rangeStyle.getRange(), rangeStyle);
        }
    }

    public void setParent(T t2) {
        this.mParent = t2;
    }

    public void setPadding(int n2, int n3, int n4, int n5) {
        RangeStyle rangeStyle = this;
        rangeStyle.mPaddingLeft = n2;
        rangeStyle.mPaddingRight = n4;
        rangeStyle.mPaddingTop = n3;
        rangeStyle.mPaddingBottom = n5;
    }

    public void setMargin(int n2, int n3, int n4, int n5) {
        RangeStyle rangeStyle = this;
        rangeStyle.mMarginLeft = n2;
        rangeStyle.mMarginTop = n3;
        rangeStyle.mMarginRight = n4;
        rangeStyle.mMarginBottom = n5;
    }

    protected int getHorizontalMargin() {
        return this.mMarginLeft + this.mMarginRight;
    }

    protected int getVerticalMargin() {
        return this.mMarginTop + this.mMarginBottom;
    }

    protected int getHorizontalPadding() {
        return this.mPaddingLeft + this.mPaddingRight;
    }

    protected int getVerticalPadding() {
        return this.mPaddingTop + this.mPaddingBottom;
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public int getMarginLeft() {
        return this.mMarginLeft;
    }

    public int getMarginRight() {
        return this.mMarginRight;
    }

    public int getMarginTop() {
        return this.mMarginTop;
    }

    public int getMarginBottom() {
        return this.mMarginBottom;
    }

    public void setPaddingLeft(int n2) {
        this.mPaddingLeft = n2;
    }

    public void setPaddingRight(int n2) {
        this.mPaddingRight = n2;
    }

    public void setPaddingTop(int n2) {
        this.mPaddingTop = n2;
    }

    public void setPaddingBottom(int n2) {
        this.mPaddingBottom = n2;
    }

    public void setMarginLeft(int n2) {
        this.mMarginLeft = n2;
    }

    public void setMarginRight(int n2) {
        this.mMarginRight = n2;
    }

    public void setMarginTop(int n2) {
        this.mMarginTop = n2;
    }

    public void setMarginBottom(int n2) {
        this.mMarginBottom = n2;
    }

    public int getFamilyHorizontalMargin() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyHorizontalMargin() : 0) + this.getHorizontalMargin();
    }

    public int getFamilyVerticalMargin() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyVerticalMargin() : 0) + this.getVerticalMargin();
    }

    public int getFamilyHorizontalPadding() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyHorizontalPadding() : 0) + this.getHorizontalPadding();
    }

    public int getFamilyVerticalPadding() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyVerticalPadding() : 0) + this.getVerticalPadding();
    }

    public int getFamilyPaddingLeft() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyPaddingLeft() : 0) + this.mPaddingLeft;
    }

    public int getFamilyPaddingRight() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyPaddingRight() : 0) + this.mPaddingRight;
    }

    public int getFamilyPaddingTop() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyPaddingTop() : 0) + this.mPaddingTop;
    }

    public int getFamilyPaddingBottom() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyPaddingBottom() : 0) + this.mPaddingBottom;
    }

    public int getFamilyMarginLeft() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyMarginLeft() : 0) + this.mMarginLeft;
    }

    public int getFamilyMarginRight() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyMarginRight() : 0) + this.mMarginRight;
    }

    public int getFamilyMarginTop() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyMarginTop() : 0) + this.mMarginTop;
    }

    public int getFamilyMarginBottom() {
        T t2 = this.mParent;
        return (t2 != null ? ((RangeStyle)t2).getFamilyMarginBottom() : 0) + this.mMarginBottom;
    }

    public int getAncestorHorizontalMargin() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorHorizontalMargin() + ((RangeStyle)this.mParent).getHorizontalMargin() : 0;
    }

    public int getAncestorVerticalMargin() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorVerticalMargin() + ((RangeStyle)this.mParent).getVerticalMargin() : 0;
    }

    public int getAncestorHorizontalPadding() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorHorizontalPadding() + ((RangeStyle)this.mParent).getHorizontalPadding() : 0;
    }

    public int getAncestorVerticalPadding() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorVerticalPadding() + ((RangeStyle)this.mParent).getVerticalPadding() : 0;
    }

    public int getAncestorPaddingLeft() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorPaddingLeft() + ((RangeStyle)this.mParent).getPaddingLeft() : 0;
    }

    public int getAncestorPaddingRight() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorPaddingRight() + ((RangeStyle)this.mParent).getPaddingRight() : 0;
    }

    public int getAncestorPaddingTop() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorPaddingTop() + ((RangeStyle)this.mParent).getPaddingTop() : 0;
    }

    public int getAncestorPaddingBottom() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorPaddingBottom() + ((RangeStyle)this.mParent).getPaddingBottom() : 0;
    }

    public int getAncestorMarginLeft() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorMarginLeft() + ((RangeStyle)this.mParent).getMarginLeft() : 0;
    }

    public int getAncestorMarginRight() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorMarginRight() + ((RangeStyle)this.mParent).getMarginRight() : 0;
    }

    public int getAncestorMarginTop() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorMarginTop() + ((RangeStyle)this.mParent).getMarginTop() : 0;
    }

    public int getAncestorMarginBottom() {
        T t2 = this.mParent;
        return t2 != null ? ((RangeStyle)t2).getAncestorMarginBottom() + ((RangeStyle)this.mParent).getMarginBottom() : 0;
    }

    public int getOriginStartOffset() {
        return this.mOriginStartOffset;
    }

    public int getOriginEndOffset() {
        return this.mOriginEndOffset;
    }

    public void setOriginStartOffset(int n2) {
        this.mOriginStartOffset = n2;
    }

    public void setOriginEndOffset(int n2) {
        this.mOriginEndOffset = n2;
    }

    public Range<Integer> getRange() {
        return this.mRange;
    }

    public BaseLayoutHelper getLayoutHelper() {
        BaseLayoutHelper baseLayoutHelper = rangeStyle.mLayoutHelper;
        if (baseLayoutHelper != null) {
            return baseLayoutHelper;
        }
        RangeStyle<T> rangeStyle = rangeStyle.mParent;
        if (rangeStyle != null) {
            return rangeStyle.getLayoutHelper();
        }
        return null;
    }

    public boolean isChildrenEmpty() {
        return this.mChildren.isEmpty();
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public boolean isOutOfRange(int n2) {
        Range<Integer> range = ((RangeStyle)((Object)range)).mRange;
        return range == null || !range.contains(n2);
    }

    public boolean isFirstPosition(int n2) {
        Range<Integer> range = ((RangeStyle)((Object)range)).mRange;
        return range != null && (Integer)range.getLower() == n2;
    }

    public boolean isLastPosition(int n2) {
        Range<Integer> range = ((RangeStyle)((Object)range)).mRange;
        return range != null && (Integer)range.getUpper() == n2;
    }

    public void setRange(int n2, int n3) {
        this.mRange = Range.create(n2, n3);
        if (!this.mChildren.isEmpty()) {
            SimpleArrayMap simpleArrayMap;
            SimpleArrayMap simpleArrayMap2 = simpleArrayMap;
            simpleArrayMap = new SimpleArrayMap();
            int n4 = this.mChildren.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                RangeStyle rangeStyle = (RangeStyle)this.mChildren.valueAt(i3);
                int n5 = rangeStyle.getOriginStartOffset() + n2;
                int n6 = rangeStyle.getOriginEndOffset() + n2;
                simpleArrayMap2.put(Range.create(n5, n6), (Object)rangeStyle);
                rangeStyle.setRange(n5, n6);
            }
            RangeStyle rangeStyle = this;
            rangeStyle.mChildren.clear();
            rangeStyle.mChildren.putAll(simpleArrayMap2);
        }
    }

    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State object, LayoutManagerHelper layoutManagerHelper) {
        if (!this.isChildrenEmpty()) {
            int n2 = this.mChildren.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                ((RangeStyle)this.mChildren.valueAt(i3)).beforeLayout(recycler, (RecyclerView.State)object, layoutManagerHelper);
            }
        }
        if (this.requireLayoutView()) {
        } else {
            recycler = this.mLayoutView;
            if (recycler != null) {
                object = this.mLayoutViewUnBindListener;
                if (object != null) {
                    object.onUnbind((View)recycler, this.getLayoutHelper());
                }
                layoutManagerHelper.removeChildView(this.mLayoutView);
                this.mLayoutView = null;
            }
        }
    }

    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int n2, int n3, int n4, LayoutManagerHelper layoutManagerHelper) {
        block15: {
            block17: {
                block18: {
                    int n5;
                    int n6;
                    block16: {
                        if (!this.isChildrenEmpty()) {
                            int n7 = this.mChildren.size();
                            for (int i3 = 0; i3 < n7; ++i3) {
                                ((RangeStyle)this.mChildren.valueAt(i3)).afterLayout(recycler, state, n2, n3, n4, layoutManagerHelper);
                            }
                        }
                        if (LogUtil.LOGGABLE) {
                            LogUtil.e(TAG, "call afterLayout() on " + this.getClass().getSimpleName());
                        }
                        if (!this.requireLayoutView()) break block15;
                        if (this.isValidScrolled(n4) && (recycler = this.mLayoutView) != null) {
                            RangeStyle rangeStyle = this;
                            int n8 = rangeStyle.mLayoutView.getTop();
                            int n9 = rangeStyle.mLayoutView.getRight();
                            n2 = rangeStyle.mLayoutView.getBottom();
                            this.mLayoutRegion.union(recycler.getLeft(), n8, n9, n2);
                        }
                        if (this.mLayoutRegion.isEmpty()) break block15;
                        if (this.isValidScrolled(n4)) {
                            if (layoutManagerHelper.getOrientation() == 1) {
                                this.mLayoutRegion.offset(0, -n4);
                            } else {
                                this.mLayoutRegion.offset(-n4, 0);
                            }
                        }
                        LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
                        RangeStyle rangeStyle = this;
                        rangeStyle.unionChildRegion(rangeStyle);
                        n6 = layoutManagerHelper2.getContentWidth();
                        n5 = layoutManagerHelper2.getContentHeight();
                        if (layoutManagerHelper2.getOrientation() != 1) break block16;
                        int n10 = n5;
                        n5 = -n10 / 4;
                        n2 = n10 + n10 / 4;
                        if (!this.mLayoutRegion.intersects(0, n5, n6, n2)) break block17;
                        break block18;
                    }
                    int n11 = n6;
                    n6 = -n11 / 4;
                    n2 = n11 + n11 / 4;
                    if (!this.mLayoutRegion.intersects(n6, 0, n2, n5)) break block17;
                }
                if (this.mLayoutView == null) {
                    View view;
                    this.mLayoutView = view = layoutManagerHelper.generateLayoutView();
                    layoutManagerHelper.addBackgroundView(view, true);
                }
                if (layoutManagerHelper.getOrientation() == 1) {
                    RangeStyle rangeStyle = this;
                    rangeStyle.mLayoutRegion.left = layoutManagerHelper.getPaddingLeft() + this.getFamilyMarginLeft() + this.getAncestorPaddingLeft();
                    rangeStyle.mLayoutRegion.right = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingRight() - this.getFamilyMarginRight() - this.getAncestorPaddingRight();
                } else {
                    RangeStyle rangeStyle = this;
                    rangeStyle.mLayoutRegion.top = layoutManagerHelper.getPaddingTop() + this.getFamilyMarginTop() + this.getAncestorPaddingTop();
                    rangeStyle.mLayoutRegion.bottom = layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingBottom() - this.getFamilyMarginBottom() - this.getAncestorPaddingBottom();
                }
                RangeStyle rangeStyle = this;
                rangeStyle.bindLayoutView(rangeStyle.mLayoutView);
                this.hideLayoutViews(layoutManagerHelper);
                return;
            }
            RangeStyle rangeStyle = this;
            rangeStyle.mLayoutRegion.set(0, 0, 0, 0);
            View view = rangeStyle.mLayoutView;
            if (view != null) {
                view.layout(0, 0, 0, 0);
            }
            this.hideLayoutViews(layoutManagerHelper);
        }
        RangeStyle rangeStyle = this;
        rangeStyle.hideLayoutViews(layoutManagerHelper);
        if (rangeStyle.isRoot()) {
            this.removeChildViews(layoutManagerHelper, this);
        }
    }

    public void adjustLayout(int n2, int n3, LayoutManagerHelper layoutManagerHelper) {
        int n4;
        if (!this.isChildrenEmpty()) {
            int n5 = this.mChildren.size();
            for (n4 = 0; n4 < n5; ++n4) {
                ((RangeStyle)this.mChildren.valueAt(n4)).adjustLayout(n2, n3, layoutManagerHelper);
            }
        }
        if (this.requireLayoutView()) {
            Rect rect;
            Rect rect2 = rect;
            rect = new Rect();
            OrientationHelperEx orientationHelperEx = layoutManagerHelper.getMainOrientationHelper();
            for (n4 = 0; n4 < layoutManagerHelper.getChildCount(); ++n4) {
                int n6;
                int n7;
                LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
                View view = layoutManagerHelper2.getChildAt(n4);
                int n8 = layoutManagerHelper2.getPosition(view);
                if (!this.getRange().contains(n8)) continue;
                if (view.getVisibility() == 8) {
                    rect2.setEmpty();
                    continue;
                }
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
                if (layoutManagerHelper.getOrientation() == 1) {
                    int n9 = layoutManagerHelper.getDecoratedLeft(view) - layoutParams.leftMargin;
                    n7 = orientationHelperEx.getDecoratedStart(view);
                    n8 = layoutManagerHelper.getDecoratedRight(view) + layoutParams.rightMargin;
                    n6 = orientationHelperEx.getDecoratedEnd(view);
                    rect2.union(n9, n7, n8, n6);
                    continue;
                }
                int n10 = orientationHelperEx.getDecoratedStart(view);
                n7 = layoutManagerHelper.getDecoratedTop(view) - layoutParams.topMargin;
                n6 = orientationHelperEx.getDecoratedEnd(view);
                n8 = layoutManagerHelper.getDecoratedBottom(view) + layoutParams.bottomMargin;
                rect2.union(n10, n7, n6, n8);
            }
            if (!rect2.isEmpty()) {
                Rect rect3 = rect2;
                int n11 = rect3.top - this.mPaddingTop;
                int n12 = rect3.right + this.mPaddingRight;
                int n13 = rect3.bottom + this.mPaddingBottom;
                this.mLayoutRegion.set(rect2.left - this.mPaddingLeft, n11, n12, n13);
            } else {
                this.mLayoutRegion.setEmpty();
            }
            View view = this.mLayoutView;
            if (view != null) {
                Rect rect4 = this.mLayoutRegion;
                int n14 = rect4.left;
                int n15 = rect4.top;
                int n16 = rect4.right;
                int n17 = rect4.bottom;
                view.layout(n14, n15, n16, n17);
            }
        }
    }

    public boolean requireLayoutView() {
        boolean bl = this.mBgColor != Long.MIN_VALUE || this.mLayoutViewBindListener != null;
        if (!this.isChildrenEmpty()) {
            RangeStyle rangeStyle = this;
            bl |= rangeStyle.requireChildLayoutView(rangeStyle);
        }
        return bl;
    }

    public void bindLayoutView(@NonNull View view) {
        BaseLayoutHelper.LayoutViewBindListener layoutViewBindListener;
        view.measure(View.MeasureSpec.makeMeasureSpec((int)this.mLayoutRegion.width(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mLayoutRegion.height(), (int)0x40000000));
        Rect rect = this.mLayoutRegion;
        int n2 = rect.left;
        int n3 = rect.top;
        int n4 = rect.right;
        int n5 = rect.bottom;
        view.layout(n2, n3, n4, n5);
        long l2 = this.mBgColor;
        if (l2 != Long.MIN_VALUE) {
            view.setBackgroundColor((int)l2);
        }
        if ((layoutViewBindListener = this.mLayoutViewBindListener) != null) {
            layoutViewBindListener.onBind(view, this.getLayoutHelper());
        }
        this.mLayoutRegion.set(0, 0, 0, 0);
    }

    public void setLayoutViewHelper(BaseLayoutHelper.DefaultLayoutViewHelper defaultLayoutViewHelper) {
        RangeStyle rangeStyle = this;
        rangeStyle.mLayoutViewBindListener = defaultLayoutViewHelper;
        rangeStyle.mLayoutViewUnBindListener = defaultLayoutViewHelper;
    }

    public void setLayoutViewBindListener(BaseLayoutHelper.LayoutViewBindListener layoutViewBindListener) {
        this.mLayoutViewBindListener = layoutViewBindListener;
    }

    public void setLayoutViewUnBindListener(BaseLayoutHelper.LayoutViewUnBindListener layoutViewUnBindListener) {
        this.mLayoutViewUnBindListener = layoutViewUnBindListener;
    }

    public void setBgColor(long l2) {
        this.mBgColor = l2;
    }

    public void onClear(LayoutManagerHelper layoutManagerHelper) {
        this.clearChild(layoutManagerHelper, this);
    }

    public void onClearChildMap() {
        this.mChildren.clear();
    }

    public void layoutChild(View view, int n2, int n3, int n4, int n5, @NonNull LayoutManagerHelper layoutManagerHelper, boolean bl) {
        layoutManagerHelper.layoutChildWithMargins(view, n2, n3, n4, n5);
        this.fillLayoutRegion(n2, n3, n4, n5, bl);
    }

    protected void fillLayoutRegion(int n2, int n3, int n4, int n5, boolean bl) {
        int n6;
        if (bl) {
            n6 = n2 - this.mPaddingLeft - this.mMarginLeft;
            int n7 = n3 - this.mPaddingTop - this.mMarginTop;
            int n8 = n4 + this.mPaddingRight + this.mMarginRight;
            int n9 = n5 + this.mPaddingBottom + this.mMarginBottom;
            this.mLayoutRegion.union(n6, n7, n8, n9);
        } else {
            n6 = n2 - this.mPaddingLeft;
            int n10 = n3 - this.mPaddingTop;
            int n11 = n4 + this.mPaddingRight;
            int n12 = n5 + this.mPaddingBottom;
            this.mLayoutRegion.union(n6, n10, n11, n12);
        }
        T t2 = this.mParent;
        if (t2 != null) {
            int n13 = n3;
            int n14 = n2 - this.mPaddingLeft;
            n2 = this.mMarginLeft;
            n3 = n14 - n2;
            n2 = n13 - this.mPaddingTop - n2;
            n4 = n4 + this.mPaddingRight + this.mMarginRight;
            int n15 = n5 + this.mPaddingBottom + this.mMarginBottom;
            ((RangeStyle)t2).fillLayoutRegion(n3, n2, n4, n15, bl);
        }
    }

    private static class RangeMap<T> {
        private static final int CAPACITY = 64;
        private Class<T> mClass;
        private int lastIndex;
        private int[] mOffsetMap;
        private T[] mCardMap;

        public RangeMap(Class<T> clazz) {
            RangeMap rangeMap = this;
            rangeMap.lastIndex = -1;
            rangeMap.mOffsetMap = new int[64];
            rangeMap.mCardMap = (Object[])Array.newInstance(rangeMap.mClass, 64);
            this.mClass = clazz;
        }

        public void addChild(int n2, int n3, T t2) {
            int n4 = this.lastIndex + 1;
            Object[] objectArray = this.mCardMap;
            if (n4 < this.mCardMap.length) {
                objectArray[n4] = t2;
            } else {
                RangeMap rangeMap = this;
                n4 = objectArray.length;
                Object[] objectArray2 = (Object[])Array.newInstance(rangeMap.mClass, n4 * 2);
                objectArray = objectArray2;
                System.arraycopy(this.mCardMap, 0, objectArray, 0, n4);
                this.mCardMap = objectArray;
                objectArray2[n4] = t2;
                int n5 = rangeMap.mOffsetMap.length;
                objectArray = new int[n5 * 2];
                System.arraycopy(rangeMap.mOffsetMap, 0, objectArray, 0, n5);
                rangeMap.mOffsetMap = (int[])objectArray;
            }
            this.lastIndex = n4;
            while (n2 <= n3) {
                this.mOffsetMap[n2] = n4;
                ++n2;
            }
        }

        public T getChild(int n2) {
            return this.mCardMap[this.mOffsetMap[n2]];
        }
    }
}

