/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.LayoutManagerHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.OrientationHelperEx;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.Range;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.VirtualLayoutManager;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.BaseLayoutHelper;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.LayoutChunkResult;
import com.baidu.navisdk.ui.widget.recyclerview.vlayout.layout.StickyLayoutHelper;
import com.baidu.navisdk.util.common.LogUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class StaggeredGridLayoutHelper
extends BaseLayoutHelper {
    private static final String TAG = "Staggered";
    private static final String LOOKUP_BUNDLE_KEY = "StaggeredGridLayoutHelper_LazySpanLookup";
    private static final int INVALID_SPAN_ID = Integer.MIN_VALUE;
    static final int INVALID_LINE = Integer.MIN_VALUE;
    private int mNumLanes;
    private Span[] mSpans;
    private int mHGap;
    private int mVGap;
    private int mColLength;
    private int mEachGap;
    private int mLastGap;
    private BitSet mRemainingSpans;
    private LazySpanLookup mLazySpanLookup;
    private List<View> prelayoutViewList;
    private boolean mLayoutWithAnchor;
    private int anchorPosition;
    private WeakReference<VirtualLayoutManager> mLayoutManager;
    private final Runnable checkForGapsRunnable;

    public StaggeredGridLayoutHelper() {
        this(1, 0);
    }

    public StaggeredGridLayoutHelper(int n2) {
        this(n2, 0);
    }

    public StaggeredGridLayoutHelper(int n2, int n3) {
        Runnable runnable;
        ArrayList arrayList;
        LazySpanLookup lazySpanLookup;
        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
        staggeredGridLayoutHelper.mNumLanes = 0;
        staggeredGridLayoutHelper.mHGap = 0;
        staggeredGridLayoutHelper.mVGap = 0;
        staggeredGridLayoutHelper.mColLength = 0;
        staggeredGridLayoutHelper.mEachGap = 0;
        staggeredGridLayoutHelper.mLastGap = 0;
        staggeredGridLayoutHelper.mRemainingSpans = null;
        Object object = lazySpanLookup;
        lazySpanLookup = new LazySpanLookup();
        staggeredGridLayoutHelper.mLazySpanLookup = object;
        object = arrayList;
        arrayList = new ArrayList();
        staggeredGridLayoutHelper.prelayoutViewList = object;
        staggeredGridLayoutHelper.mLayoutManager = null;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                StaggeredGridLayoutHelper.this.checkForGaps();
            }
        };
        staggeredGridLayoutHelper.checkForGapsRunnable = object;
        staggeredGridLayoutHelper.setLane(n2);
        staggeredGridLayoutHelper.setGap(n3);
    }

    private void ensureLanes() {
        Span[] spanArray = this.mSpans;
        if (this.mSpans == null || spanArray.length != this.mNumLanes || this.mRemainingSpans == null) {
            this.mRemainingSpans = new BitSet(this.mNumLanes);
            this.mSpans = new Span[this.mNumLanes];
            for (int i3 = 0; i3 < this.mNumLanes; ++i3) {
                Span span;
                Span span2 = span;
                span = new Span(i3);
                this.mSpans[i3] = span2;
            }
        }
    }

    private void recycleForPreLayout(RecyclerView.Recycler recycler, VirtualLayoutManager.LayoutStateWrapper object, LayoutManagerHelper layoutManagerHelper) {
        object = layoutManagerHelper.getMainOrientationHelper();
        for (int i3 = ((StaggeredGridLayoutHelper)this).prelayoutViewList.size() - 1; i3 >= 0; --i3) {
            View view = ((StaggeredGridLayoutHelper)this).prelayoutViewList.get(i3);
            if (view != null && ((OrientationHelperEx)object).getDecoratedStart(view) > ((OrientationHelperEx)object).getEndAfterPadding()) {
                Span span = ((StaggeredGridLayoutHelper)this).findSpan(((RecyclerView.LayoutParams)view.getLayoutParams()).getViewPosition(), view, false);
                if (span != null) {
                    span.popEnd((OrientationHelperEx)object);
                }
                layoutManagerHelper.removeChildView(view);
                recycler.recycleView(view);
                continue;
            }
            if ((this = ((StaggeredGridLayoutHelper)this).findSpan(((RecyclerView.LayoutParams)view.getLayoutParams()).getViewPosition(), view, false)) != null) {
                ((Span)this).popEnd((OrientationHelperEx)object);
            }
            layoutManagerHelper.removeChildView(view);
            recycler.recycleView(view);
            break;
        }
    }

    private void checkForGaps() {
        WeakReference<VirtualLayoutManager> weakReference = this.mLayoutManager;
        if (weakReference == null) {
            return;
        }
        if ((weakReference = (VirtualLayoutManager)weakReference.get()) != null && weakReference.getChildCount() != 0) {
            int n2;
            int n3;
            block21: {
                View view;
                int n4;
                int n5;
                Range<Integer> range = this.getRange();
                if (weakReference.getReverseLayout()) {
                    WeakReference<VirtualLayoutManager> weakReference2 = weakReference;
                    ((VirtualLayoutManager)((Object)weakReference2)).findLastVisibleItemPosition();
                    ((VirtualLayoutManager)((Object)weakReference2)).findFirstVisibleItemPosition();
                    n5 = range.getUpper() - 1;
                } else {
                    WeakReference<VirtualLayoutManager> weakReference3 = weakReference;
                    ((VirtualLayoutManager)((Object)weakReference3)).findFirstVisibleItemPosition();
                    weakReference3.findLastCompletelyVisibleItemPosition();
                    n5 = range.getLower();
                }
                WeakReference<VirtualLayoutManager> weakReference4 = weakReference;
                OrientationHelperEx orientationHelperEx = ((VirtualLayoutManager)((Object)weakReference4)).getMainOrientationHelper();
                int n6 = weakReference4.getChildCount();
                n3 = Integer.MIN_VALUE;
                int n7 = Integer.MIN_VALUE;
                if (weakReference4.getReverseLayout()) {
                    block20: {
                        for (n4 = --n6; n4 >= 0; --n4) {
                            WeakReference<VirtualLayoutManager> weakReference5 = weakReference;
                            view = weakReference5.getChildAt(n4);
                            n2 = weakReference5.getPosition(view);
                            if (n2 != n5) continue;
                            if (n4 == n6) {
                                n5 = n7 = orientationHelperEx.getDecoratedEnd(view);
                            } else {
                                WeakReference<VirtualLayoutManager> weakReference6 = weakReference;
                                View view2 = weakReference6.getChildAt(n4 + 1);
                                n5 = weakReference6.getPosition(view2) == n2 - 1 ? orientationHelperEx.getDecoratedStart(view2) - ((VirtualLayoutManager)((Object)weakReference)).obtainExtraMargin(view2, false) + ((VirtualLayoutManager)((Object)weakReference)).obtainExtraMargin(view, true) : orientationHelperEx.getDecoratedEnd(view);
                            }
                            break block20;
                        }
                        n5 = n7;
                        n2 = n3;
                    }
                    n3 = n5;
                } else {
                    for (n4 = 0; n4 < n6; ++n4) {
                        WeakReference<VirtualLayoutManager> weakReference7 = weakReference;
                        view = weakReference7.getChildAt(n4);
                        n2 = weakReference7.getPosition(view);
                        if (n2 != n5) continue;
                        if (n4 == 0) {
                            n3 = n5 = orientationHelperEx.getDecoratedStart(view);
                        } else {
                            View view3 = weakReference.getChildAt(n4 - 1);
                            n3 = orientationHelperEx.getDecoratedEnd(view3) + ((VirtualLayoutManager)((Object)weakReference)).obtainExtraMargin(view3, true, false) - ((VirtualLayoutManager)((Object)weakReference)).obtainExtraMargin(view, false, false);
                            if (n3 == orientationHelperEx.getDecoratedStart(view)) {
                                n2 = Integer.MIN_VALUE;
                            } else {
                                int n8 = weakReference.getPosition(view3);
                                if (n8 != --n5) {
                                    LayoutHelper layoutHelper = ((VirtualLayoutManager)((Object)weakReference)).findLayoutHelperByPosition(n5);
                                    if (layoutHelper != null && layoutHelper instanceof StickyLayoutHelper && layoutHelper.getFixedView() != null) {
                                        n3 += layoutHelper.getFixedView().getMeasuredHeight();
                                    }
                                } else {
                                    ((VirtualLayoutManager)((Object)weakReference)).findLayoutHelperByPosition(n8).getRange();
                                }
                            }
                        }
                        break block21;
                    }
                    int n9 = n3;
                    n3 = n7;
                    n2 = n9;
                }
            }
            if (n2 == Integer.MIN_VALUE) {
                return;
            }
            if (this.hasGapsToFix((VirtualLayoutManager)((Object)weakReference), n2, n3) != null) {
                int n10 = this.mSpans.length;
                for (int i3 = 0; i3 < n10; ++i3) {
                    this.mSpans[i3].setLine(n3);
                }
                WeakReference<VirtualLayoutManager> weakReference8 = weakReference;
                weakReference8.requestSimpleAnimationsInNextLayout();
                weakReference8.requestLayout();
            }
            return;
        }
    }

    private View hasGapsToFix(VirtualLayoutManager virtualLayoutManager, int n2, int n3) {
        if (virtualLayoutManager.findViewByPosition(n2) == null) {
            return null;
        }
        new BitSet(this.mNumLanes).set(0, this.mNumLanes, true);
        for (Span span : this.mSpans) {
            if (span.mViews.size() == 0 || !this.checkSpanForGap(span, virtualLayoutManager, n3)) continue;
            return virtualLayoutManager.getReverseLayout() ? (View)span.mViews.get(span.mViews.size() - 1) : (View)span.mViews.get(0);
        }
        return null;
    }

    private boolean checkSpanForGap(Span span, VirtualLayoutManager virtualLayoutManager, int n2) {
        VirtualLayoutManager virtualLayoutManager2 = virtualLayoutManager;
        OrientationHelperEx orientationHelperEx = virtualLayoutManager2.getMainOrientationHelper();
        if (virtualLayoutManager2.getReverseLayout()) {
            return span.getEndLine(orientationHelperEx) < n2;
        }
        return span.getStartLine(orientationHelperEx) > n2;
    }

    private void recycle(RecyclerView.Recycler recycler, VirtualLayoutManager.LayoutStateWrapper object, Span span, int n2, LayoutManagerHelper layoutManagerHelper) {
        VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper = object;
        object = layoutManagerHelper.getMainOrientationHelper();
        if (layoutStateWrapper.getLayoutDirection() == -1) {
            this.recycleFromEnd(recycler, Math.max(n2, this.getMaxStart(span.getStartLine((OrientationHelperEx)object), (OrientationHelperEx)object)) + (((OrientationHelperEx)object).getEnd() - ((OrientationHelperEx)object).getStartAfterPadding()), layoutManagerHelper);
        } else {
            this.recycleFromStart(recycler, Math.min(n2, this.getMinEnd(span.getEndLine((OrientationHelperEx)object), (OrientationHelperEx)object)) - (((OrientationHelperEx)object).getEnd() - ((OrientationHelperEx)object).getStartAfterPadding()), layoutManagerHelper);
        }
    }

    private void recycleFromStart(RecyclerView.Recycler recycler, int n2, LayoutManagerHelper layoutManagerHelper) {
        OrientationHelperEx orientationHelperEx = layoutManagerHelper.getMainOrientationHelper();
        boolean bl = true;
        while (layoutManagerHelper.getChildCount() > 0 && bl) {
            View view = layoutManagerHelper.getChildAt(0);
            if (view != null && orientationHelperEx.getDecoratedEnd(view) < n2) {
                Span span = this.findSpan(((RecyclerView.LayoutParams)view.getLayoutParams()).getViewPosition(), view, true);
                if (span != null) {
                    span.popStart(orientationHelperEx);
                    layoutManagerHelper.removeChildView(view);
                    recycler.recycleView(view);
                    continue;
                }
                bl = false;
                continue;
            }
            return;
        }
    }

    private void recycleFromEnd(RecyclerView.Recycler recycler, int n2, LayoutManagerHelper layoutManagerHelper) {
        OrientationHelperEx orientationHelperEx = layoutManagerHelper.getMainOrientationHelper();
        for (int i3 = (v756630).getChildCount() - 1; i3 >= 0; --i3) {
            View view = layoutManagerHelper.getChildAt(i3);
            if (view != null && orientationHelperEx.getDecoratedStart(view) > n2) {
                Span span = this.findSpan(((RecyclerView.LayoutParams)view.getLayoutParams()).getViewPosition(), view, false);
                if (span == null) continue;
                span.popEnd(orientationHelperEx);
                layoutManagerHelper.removeChildView(view);
                recycler.recycleView(view);
                continue;
            }
            return;
        }
    }

    private Span findSpan(int n2, View view, boolean bl) {
        if ((n2 = this.mLazySpanLookup.getSpan(n2)) >= 0) {
            Object object = this.mSpans;
            if (n2 < this.mSpans.length) {
                object = object[n2];
                if (bl && ((Span)object).findStart(view)) {
                    return object;
                }
                if (!bl && ((Span)object).findEnd(view)) {
                    return object;
                }
            }
        }
        int n3 = 0;
        while (true) {
            Object object = this.mSpans;
            if (n3 >= this.mSpans.length) break;
            if (n3 != n2) {
                object = object[n3];
                if (bl && ((Span)object).findStart(view)) {
                    return object;
                }
                if (!bl && ((Span)object).findEnd(view)) {
                    return object;
                }
            }
            ++n3;
        }
        return null;
    }

    private void updateAllRemainingSpans(int n2, int n3, OrientationHelperEx orientationHelperEx) {
        for (int i3 = 0; i3 < this.mNumLanes; ++i3) {
            if (this.mSpans[i3].mViews.isEmpty()) continue;
            StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
            staggeredGridLayoutHelper.updateRemainingSpans(staggeredGridLayoutHelper.mSpans[i3], n2, n3, orientationHelperEx);
        }
    }

    private void updateRemainingSpans(Span span, int n2, int n3, OrientationHelperEx orientationHelperEx) {
        int n4 = n2;
        n2 = span.getDeletedSize();
        if (n4 == -1) {
            if (span.getStartLine(orientationHelperEx) + n2 < n3) {
                this.mRemainingSpans.set(span.mIndex, false);
            }
        } else if (span.getEndLine(orientationHelperEx) - n2 > n3) {
            this.mRemainingSpans.set(span.mIndex, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Span getNextSpan(int n2, VirtualLayoutManager.LayoutStateWrapper object, LayoutManagerHelper layoutManagerHelper) {
        int n3;
        int n4;
        int n5;
        LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
        OrientationHelperEx orientationHelperEx = layoutManagerHelper2.getMainOrientationHelper();
        int n6 = (layoutManagerHelper2.getOrientation() == 0 ? ((VirtualLayoutManager.LayoutStateWrapper)object).getLayoutDirection() == -1 != layoutManagerHelper.getReverseLayout() : ((VirtualLayoutManager.LayoutStateWrapper)object).getLayoutDirection() == -1 == layoutManagerHelper.getReverseLayout() == layoutManagerHelper.isDoLayoutRTL()) ? 1 : 0;
        if (n6 != 0) {
            n6 = this.mNumLanes - 1;
            n5 = -1;
            n4 = -1;
        } else {
            n6 = 0;
            n5 = this.mNumLanes;
            n4 = 1;
        }
        if (((VirtualLayoutManager.LayoutStateWrapper)object).getLayoutDirection() != 1) {
            object = null;
            n3 = Integer.MIN_VALUE;
        } else {
            object = null;
            int n7 = Integer.MAX_VALUE;
            while (n6 != n5) {
                Object object2 = this.mSpans[n6];
                int n8 = ((Span)object2).getEndLine(n2, orientationHelperEx);
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "end starIndex " + n6 + " end otherLine " + n8);
                }
                if (n8 >= n7) {
                    n8 = n7;
                    object2 = object;
                }
                if (LogUtil.LOGGABLE) {
                    LogUtil.e(TAG, "end min " + object2 + " end minLine " + n8);
                }
                n6 += n4;
                n7 = n8;
                object = object2;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "final end min " + object + " final end minLine " + n7);
            }
            return object;
        }
        while (n6 != n5) {
            Object object3 = this.mSpans[n6];
            int n9 = ((Span)object3).getStartLine(n2, orientationHelperEx);
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "start starIndex " + n6 + " start otherLine " + n9);
            }
            if (n9 <= n3) {
                n9 = n3;
                object3 = object;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "start max " + object3 + " start maxLine " + n9);
            }
            n6 += n4;
            n3 = n9;
            object = object3;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "final start max " + object + " final start maxLine " + n3);
        }
        return object;
    }

    private int getMaxStart(int n2, OrientationHelperEx orientationHelperEx) {
        int n3 = this.mSpans[0].getStartLine(n2, orientationHelperEx);
        for (int i3 = 1; i3 < this.mNumLanes; ++i3) {
            int n4 = this.mSpans[i3].getStartLine(n2, orientationHelperEx);
            if (n4 <= n3) {
                n4 = n3;
            }
            n3 = n4;
        }
        return n3;
    }

    private int getMinStart(int n2, OrientationHelperEx orientationHelperEx) {
        int n3 = this.mSpans[0].getStartLine(n2, orientationHelperEx);
        for (int i3 = 1; i3 < this.mNumLanes; ++i3) {
            int n4 = this.mSpans[i3].getStartLine(n2, orientationHelperEx);
            if (n4 >= n3) {
                n4 = n3;
            }
            n3 = n4;
        }
        return n3;
    }

    private int getMaxEnd(int n2, OrientationHelperEx orientationHelperEx) {
        int n3 = this.mSpans[0].getEndLine(n2, orientationHelperEx);
        for (int i3 = 1; i3 < this.mNumLanes; ++i3) {
            int n4 = this.mSpans[i3].getEndLine(n2, orientationHelperEx);
            if (n4 <= n3) {
                n4 = n3;
            }
            n3 = n4;
        }
        return n3;
    }

    private int getMinEnd(int n2, OrientationHelperEx orientationHelperEx) {
        int n3 = this.mSpans[0].getEndLine(n2, orientationHelperEx);
        for (int i3 = 1; i3 < this.mNumLanes; ++i3) {
            int n4 = this.mSpans[i3].getEndLine(n2, orientationHelperEx);
            if (n4 >= n3) {
                n4 = n3;
            }
            n3 = n4;
        }
        return n3;
    }

    public void setGap(int n2) {
        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
        staggeredGridLayoutHelper.setHGap(n2);
        staggeredGridLayoutHelper.setVGap(n2);
    }

    public void setHGap(int n2) {
        this.mHGap = n2;
    }

    public int getHGap() {
        return this.mHGap;
    }

    public void setVGap(int n2) {
        this.mVGap = n2;
    }

    public int getVGap() {
        return this.mVGap;
    }

    public void setLane(int n2) {
        this.mNumLanes = n2;
        this.ensureLanes();
    }

    public int getLane() {
        return this.mNumLanes;
    }

    public int getColLength() {
        return this.mColLength;
    }

    @Override
    public void beforeLayout(RecyclerView.Recycler recycler, RecyclerView.State state, LayoutManagerHelper layoutManagerHelper) {
        super.beforeLayout(recycler, state, layoutManagerHelper);
        int n2 = layoutManagerHelper.getOrientation() == 1 ? layoutManagerHelper.getContentWidth() - layoutManagerHelper.getPaddingLeft() - layoutManagerHelper.getPaddingRight() - this.getHorizontalMargin() - this.getHorizontalPadding() : layoutManagerHelper.getContentHeight() - layoutManagerHelper.getPaddingTop() - layoutManagerHelper.getPaddingBottom() - this.getVerticalMargin() - this.getVerticalPadding();
        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
        int n3 = staggeredGridLayoutHelper.mHGap;
        int n4 = staggeredGridLayoutHelper.mNumLanes;
        int n5 = n2;
        this.mColLength = n2 = (int)((double)((n5 - n3 * (n4 - 1)) / n4) + 0.5);
        n2 = n5 - n2 * n4;
        if (n4 <= 1) {
            StaggeredGridLayoutHelper staggeredGridLayoutHelper2 = this;
            staggeredGridLayoutHelper2.mLastGap = 0;
            staggeredGridLayoutHelper2.mEachGap = 0;
        } else if (n4 == 2) {
            StaggeredGridLayoutHelper staggeredGridLayoutHelper3 = this;
            staggeredGridLayoutHelper3.mEachGap = n2;
            staggeredGridLayoutHelper3.mLastGap = n2;
        } else {
            n2 = layoutManagerHelper.getOrientation() == 1 ? this.mHGap : this.mVGap;
            StaggeredGridLayoutHelper staggeredGridLayoutHelper4 = this;
            staggeredGridLayoutHelper4.mLastGap = n2;
            staggeredGridLayoutHelper4.mEachGap = n2;
        }
        WeakReference<VirtualLayoutManager> weakReference = this.mLayoutManager;
        if ((weakReference == null || weakReference.get() == null || this.mLayoutManager.get() != layoutManagerHelper) && layoutManagerHelper instanceof VirtualLayoutManager) {
            this.mLayoutManager = new WeakReference<VirtualLayoutManager>((VirtualLayoutManager)layoutManagerHelper);
        }
    }

    @Override
    public void afterLayout(RecyclerView.Recycler recycler, RecyclerView.State state, int n2, int n3, int n4, LayoutManagerHelper layoutManagerHelper) {
        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
        super.afterLayout(recycler, state, n2, n3, n4, layoutManagerHelper);
        staggeredGridLayoutHelper.mLayoutWithAnchor = false;
        if (n2 <= staggeredGridLayoutHelper.getRange().getUpper() && n3 >= this.getRange().getLower()) {
            if (!state.isPreLayout() && layoutManagerHelper.getChildCount() > 0) {
                ViewCompat.postOnAnimation((View)layoutManagerHelper.getChildAt(0), (Runnable)this.checkForGapsRunnable);
            }
            return;
        }
    }

    @Override
    public void layoutViews(RecyclerView.Recycler recycler, RecyclerView.State state, VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper, LayoutChunkResult layoutChunkResult, LayoutManagerHelper layoutManagerHelper) {
        int n2;
        int n3;
        if (this.isOutOfRange(layoutStateWrapper.getCurrentPosition())) {
            return;
        }
        this.ensureLanes();
        int n4 = layoutManagerHelper.getOrientation() == 1 ? 1 : 0;
        LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
        OrientationHelperEx orientationHelperEx = layoutManagerHelper2.getMainOrientationHelper();
        OrientationHelperEx orientationHelperEx2 = layoutManagerHelper2.getSecondaryOrientationHelper();
        int n5 = layoutManagerHelper2.isEnableMarginOverLap();
        this.mRemainingSpans.set(0, this.mNumLanes, true);
        if (layoutStateWrapper.getLayoutDirection() == 1) {
            n3 = layoutStateWrapper.getOffset() + layoutStateWrapper.getAvailable();
            n2 = n3 + layoutStateWrapper.getExtra() + orientationHelperEx.getEndPadding();
        } else {
            n3 = layoutStateWrapper.getOffset() - layoutStateWrapper.getAvailable();
            n2 = n3 - layoutStateWrapper.getExtra() - orientationHelperEx.getStartAfterPadding();
        }
        this.updateAllRemainingSpans(layoutStateWrapper.getLayoutDirection(), n2, orientationHelperEx);
        int n6 = layoutStateWrapper.getOffset();
        this.prelayoutViewList.clear();
        while (layoutStateWrapper.hasMore(state) && !this.mRemainingSpans.isEmpty() && !this.isOutOfRange(layoutStateWrapper.getCurrentPosition())) {
            int n7;
            int n8;
            Span span;
            int n9;
            View view;
            int n10;
            block33: {
                block28: {
                    block30: {
                        block32: {
                            block31: {
                                block29: {
                                    int n11;
                                    int n12;
                                    VirtualLayoutManager.LayoutStateWrapper layoutStateWrapper2 = layoutStateWrapper;
                                    n10 = layoutStateWrapper2.getCurrentPosition();
                                    view = layoutStateWrapper2.next(recycler);
                                    if (view == null) break;
                                    VirtualLayoutManager.LayoutParams layoutParams = (VirtualLayoutManager.LayoutParams)view.getLayoutParams();
                                    n9 = layoutParams.getViewPosition();
                                    int n13 = this.mLazySpanLookup.getSpan(n9);
                                    if (n13 == Integer.MIN_VALUE) {
                                        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
                                        span = staggeredGridLayoutHelper.getNextSpan(n6, layoutStateWrapper, layoutManagerHelper);
                                        staggeredGridLayoutHelper.mLazySpanLookup.setSpan(n9, span);
                                    } else {
                                        span = this.mSpans[n13];
                                    }
                                    n8 = n9 - this.getRange().getLower() < this.mNumLanes ? 1 : 0;
                                    n9 = this.getRange().getUpper() - n9 < this.mNumLanes ? 1 : 0;
                                    if (layoutStateWrapper.isPreLayout()) {
                                        this.prelayoutViewList.add(view);
                                    }
                                    layoutManagerHelper.addChildView(layoutStateWrapper, view);
                                    if (n4 != 0) {
                                        n12 = this.mColLength;
                                        n12 = layoutManagerHelper.getChildMeasureSpec(n12, layoutParams.width, false);
                                        n11 = orientationHelperEx.getTotalSpace();
                                        n7 = Float.isNaN(layoutParams.mAspectRatio) ? layoutParams.height : (int)((float)View.MeasureSpec.getSize((int)n12) / layoutParams.mAspectRatio + 0.5f);
                                        LayoutManagerHelper layoutManagerHelper3 = layoutManagerHelper;
                                        n7 = layoutManagerHelper3.getChildMeasureSpec(n11, n7, true);
                                        layoutManagerHelper3.measureChildWithMargins(view, n12, n7);
                                    } else {
                                        n12 = this.mColLength;
                                        n12 = layoutManagerHelper.getChildMeasureSpec(n12, layoutParams.height, false);
                                        n11 = orientationHelperEx.getTotalSpace();
                                        n7 = Float.isNaN(layoutParams.mAspectRatio) ? layoutParams.width : (int)((float)View.MeasureSpec.getSize((int)n12) * layoutParams.mAspectRatio + 0.5f);
                                        LayoutManagerHelper layoutManagerHelper4 = layoutManagerHelper;
                                        layoutManagerHelper4.measureChildWithMargins(view, layoutManagerHelper4.getChildMeasureSpec(n11, n7, true), n12);
                                    }
                                    if (layoutStateWrapper.getLayoutDirection() != 1) break block28;
                                    n7 = span.getEndLine(n6, orientationHelperEx);
                                    if (n8 == 0) break block29;
                                    n7 += this.computeStartSpace(layoutManagerHelper, n4 != 0, true, n5 != 0);
                                    break block30;
                                }
                                if (!this.mLayoutWithAnchor) break block31;
                                if (Math.abs(n10 - this.anchorPosition) < this.mNumLanes) break block30;
                                n10 = n4 != 0 ? this.mVGap : this.mHGap;
                                break block32;
                            }
                            n10 = n4 != 0 ? this.mVGap : this.mHGap;
                        }
                        n7 += n10;
                    }
                    n10 = n7 + orientationHelperEx.getDecoratedMeasurement(view);
                    break block33;
                }
                if (n9 != 0) {
                    n10 = span.getStartLine(n6, orientationHelperEx);
                    n7 = n4 != 0 ? this.mMarginBottom + this.mPaddingRight : this.mMarginRight + this.mPaddingRight;
                } else {
                    n10 = span.getStartLine(n6, orientationHelperEx);
                    n7 = n4 != 0 ? this.mVGap : this.mHGap;
                }
                n10 -= n7;
                n7 = n10 - orientationHelperEx.getDecoratedMeasurement(view);
            }
            if (layoutStateWrapper.getLayoutDirection() == 1) {
                span.appendToSpan(view, orientationHelperEx);
            } else {
                span.prependToSpan(view, orientationHelperEx);
            }
            n9 = span.mIndex;
            if (n9 == this.mNumLanes - 1) {
                int n14 = n9;
                n9 = this.mEachGap;
                n9 = n14 * (this.mColLength + n9) - n9 + this.mLastGap;
            } else {
                n9 *= this.mColLength + this.mEachGap;
            }
            n9 += orientationHelperEx2.getStartAfterPadding();
            n9 = n4 != 0 ? (n9 += this.mMarginLeft + this.mPaddingLeft) : (n9 += this.mMarginTop + this.mPaddingTop);
            n8 = n9 + orientationHelperEx.getDecoratedMeasurementInOther(view);
            if (n4 != 0) {
                this.layoutChildWithMargin(view, n9, n7, n8, n10, layoutManagerHelper);
            } else {
                this.layoutChildWithMargin(view, n7, n9, n10, n8, layoutManagerHelper);
            }
            StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
            staggeredGridLayoutHelper.updateRemainingSpans(span, layoutStateWrapper.getLayoutDirection(), n2, orientationHelperEx);
            staggeredGridLayoutHelper.recycle(recycler, layoutStateWrapper, span, n3, layoutManagerHelper);
            staggeredGridLayoutHelper.handleStateOnResult(layoutChunkResult, view);
        }
        if (this.isOutOfRange(layoutStateWrapper.getCurrentPosition())) {
            if (layoutStateWrapper.getLayoutDirection() == -1) {
                for (Span span : this.mSpans) {
                    n2 = span.mCachedStart;
                    if (n2 == Integer.MIN_VALUE) continue;
                    span.mLastEdgeStart = n2;
                }
            } else {
                for (Span span : this.mSpans) {
                    n2 = span.mCachedEnd;
                    if (n2 == Integer.MIN_VALUE) continue;
                    span.mLastEdgeEnd = n2;
                }
            }
        }
        if (layoutStateWrapper.getLayoutDirection() == -1) {
            if (!this.isOutOfRange(layoutStateWrapper.getCurrentPosition()) && layoutStateWrapper.hasMore(state)) {
                int n15 = this.getMaxStart(orientationHelperEx.getStartAfterPadding(), orientationHelperEx);
                layoutChunkResult.mConsumed = layoutStateWrapper.getOffset() - n15;
            } else {
                int n16 = this.getMinStart(orientationHelperEx.getEndAfterPadding(), orientationHelperEx);
                n16 = layoutStateWrapper.getOffset() - n16;
                n4 = n4 != 0 ? this.mMarginTop + this.mPaddingTop : this.mMarginLeft + this.mPaddingLeft;
                layoutChunkResult.mConsumed = n16 + n4;
            }
        } else if (!this.isOutOfRange(layoutStateWrapper.getCurrentPosition()) && layoutStateWrapper.hasMore(state)) {
            layoutChunkResult.mConsumed = this.getMinEnd(orientationHelperEx.getEndAfterPadding(), orientationHelperEx) - layoutStateWrapper.getOffset();
        } else {
            int n17 = this.getMaxEnd(orientationHelperEx.getEndAfterPadding(), orientationHelperEx) - layoutStateWrapper.getOffset();
            n4 = n4 != 0 ? this.mMarginBottom + this.mPaddingBottom : this.mMarginRight + this.mPaddingRight;
            layoutChunkResult.mConsumed = n17 + n4;
        }
        this.recycleForPreLayout(recycler, layoutStateWrapper, layoutManagerHelper);
    }

    @Override
    public void onScrollStateChanged(int n2, int n3, int n4, LayoutManagerHelper layoutManagerHelper) {
        if (n3 <= this.getRange().getUpper() && n4 >= this.getRange().getLower()) {
            if (n2 == 0) {
                this.checkForGaps();
            }
            return;
        }
    }

    @Override
    public int computeAlignOffset(int n2, boolean bl, boolean bl2, LayoutManagerHelper object) {
        boolean bl3 = object.getOrientation() == 1;
        LayoutManagerHelper layoutManagerHelper = object;
        object = object.getMainOrientationHelper();
        View view = layoutManagerHelper.findViewByPosition(n2 + this.getRange().getLower());
        if (view == null) {
            return 0;
        }
        this.ensureLanes();
        if (bl3) {
            if (bl) {
                if (n2 == this.getItemCount() - 1) {
                    return this.mMarginBottom + this.mPaddingBottom + (this.getMaxEnd(((OrientationHelperEx)object).getDecoratedEnd(view), (OrientationHelperEx)object) - ((OrientationHelperEx)object).getDecoratedEnd(view));
                }
                if (!bl2) {
                    return this.getMinEnd(((OrientationHelperEx)object).getDecoratedStart(view), (OrientationHelperEx)object) - ((OrientationHelperEx)object).getDecoratedEnd(view);
                }
            } else {
                if (n2 == 0) {
                    return -this.mMarginTop - this.mPaddingTop - (((OrientationHelperEx)object).getDecoratedStart(view) - this.getMinStart(((OrientationHelperEx)object).getDecoratedStart(view), (OrientationHelperEx)object));
                }
                if (!bl2) {
                    return this.getMaxStart(((OrientationHelperEx)object).getDecoratedEnd(view), (OrientationHelperEx)object) - ((OrientationHelperEx)object).getDecoratedStart(view);
                }
            }
        }
        return 0;
    }

    @Override
    public void onClear(LayoutManagerHelper layoutManagerHelper) {
        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
        super.onClear(layoutManagerHelper);
        staggeredGridLayoutHelper.mLazySpanLookup.clear();
        staggeredGridLayoutHelper.mSpans = null;
        staggeredGridLayoutHelper.mLayoutManager = null;
    }

    @Override
    public boolean isRecyclable(int n2, int n3, int n4, LayoutManagerHelper layoutManagerHelper, boolean bl) {
        View view;
        boolean bl2 = super.isRecyclable(n2, n3, n4, layoutManagerHelper, bl);
        n3 = bl2 ? 1 : 0;
        if (bl2 && (view = layoutManagerHelper.findViewByPosition(n2)) != null) {
            OrientationHelperEx orientationHelperEx = layoutManagerHelper.getMainOrientationHelper();
            int n5 = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewPosition();
            if (layoutManagerHelper.getReverseLayout()) {
                if (bl) {
                    if ((this = ((StaggeredGridLayoutHelper)this).findSpan(n5, view, true)) != null) {
                        ((Span)this).popEnd(orientationHelperEx);
                    }
                } else if ((this = ((StaggeredGridLayoutHelper)this).findSpan(n5, view, false)) != null) {
                    ((Span)this).popStart(orientationHelperEx);
                }
            } else if (bl) {
                if ((this = ((StaggeredGridLayoutHelper)this).findSpan(n5, view, true)) != null) {
                    ((Span)this).popStart(orientationHelperEx);
                }
            } else if ((this = ((StaggeredGridLayoutHelper)this).findSpan(n5, view, false)) != null) {
                ((Span)this).popEnd(orientationHelperEx);
            }
        }
        return n3 != 0;
    }

    @Override
    public void onRefreshLayout(RecyclerView.State state, VirtualLayoutManager.AnchorInfoWrapper anchorInfoWrapper, LayoutManagerHelper layoutManagerHelper) {
        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
        super.onRefreshLayout(state, anchorInfoWrapper, layoutManagerHelper);
        staggeredGridLayoutHelper.ensureLanes();
        if (this.isOutOfRange(anchorInfoWrapper.position)) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onRefreshLayout span.clear()");
            }
            int n2 = this.mSpans.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                this.mSpans[i3].clear();
            }
        }
    }

    @Override
    public void checkAnchorInfo(RecyclerView.State object, VirtualLayoutManager.AnchorInfoWrapper anchorInfoWrapper, LayoutManagerHelper layoutManagerHelper) {
        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
        super.checkAnchorInfo((RecyclerView.State)object, anchorInfoWrapper, layoutManagerHelper);
        staggeredGridLayoutHelper.ensureLanes();
        object = staggeredGridLayoutHelper.getRange();
        if (anchorInfoWrapper.layoutFromEnd) {
            if (anchorInfoWrapper.position < (Integer)((Range)object).getLower() + this.mNumLanes - 1) {
                anchorInfoWrapper.position = Math.min((Integer)((Range)object).getLower() + this.mNumLanes - 1, (Integer)((Range)object).getUpper());
            }
        } else if (anchorInfoWrapper.position > (Integer)((Range)object).getUpper() - (this.mNumLanes - 1)) {
            anchorInfoWrapper.position = Math.max((Integer)((Range)object).getLower(), (Integer)((Range)object).getUpper() - (this.mNumLanes - 1));
        }
        LayoutManagerHelper layoutManagerHelper2 = layoutManagerHelper;
        View view = layoutManagerHelper2.findViewByPosition(anchorInfoWrapper.position);
        int n2 = layoutManagerHelper2.getOrientation() == 1 ? this.mVGap : this.mHGap;
        OrientationHelperEx orientationHelperEx = layoutManagerHelper.getMainOrientationHelper();
        if (view == null) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "checkAnchorInfo span.clear()");
            }
            for (Span span : this.mSpans) {
                span.clear();
                span.setLine(anchorInfoWrapper.coordinate);
            }
        } else {
            int n3 = anchorInfoWrapper.layoutFromEnd ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            for (Span span : this.mSpans) {
                if (span.mViews.isEmpty()) continue;
                n3 = anchorInfoWrapper.layoutFromEnd ? Math.max(n3, layoutManagerHelper.getPosition((View)span.mViews.get(span.mViews.size() - 1))) : Math.min(n3, layoutManagerHelper.getPosition((View)span.mViews.get(0)));
            }
            int n4 = Integer.MIN_VALUE;
            if (!this.isOutOfRange(n3)) {
                int n5 = n3 == (Integer)((Range)object).getLower() ? 1 : 0;
                View view2 = layoutManagerHelper.findViewByPosition(n3);
                if (view2 != null) {
                    if (anchorInfoWrapper.layoutFromEnd) {
                        anchorInfoWrapper.position = n3;
                        int n6 = orientationHelperEx.getDecoratedEnd(view);
                        if (n6 < (n3 = anchorInfoWrapper.coordinate)) {
                            int n7 = n5;
                            n5 = n3 - n6;
                            if (n7 != 0) {
                                n2 = 0;
                            }
                            anchorInfoWrapper.coordinate = orientationHelperEx.getDecoratedEnd(view2) + (n5 += n2);
                            n2 = n5;
                        } else {
                            if (n5 != 0) {
                                n2 = 0;
                            }
                            anchorInfoWrapper.coordinate = orientationHelperEx.getDecoratedEnd(view2) + n2;
                        }
                    } else {
                        anchorInfoWrapper.position = n3;
                        int n8 = orientationHelperEx.getDecoratedStart(view);
                        if (n8 > (n3 = anchorInfoWrapper.coordinate)) {
                            int n9 = n5;
                            n5 = n3 - n8;
                            if (n9 != 0) {
                                n2 = 0;
                            }
                            n2 = n5 - n2;
                            anchorInfoWrapper.coordinate = orientationHelperEx.getDecoratedStart(view2) + n2;
                        } else {
                            if (n5 != 0) {
                                n2 = 0;
                            }
                            n2 = -n2;
                            anchorInfoWrapper.coordinate = orientationHelperEx.getDecoratedStart(view2) + n2;
                        }
                    }
                } else {
                    n2 = n4;
                }
            } else {
                StaggeredGridLayoutHelper staggeredGridLayoutHelper2 = this;
                staggeredGridLayoutHelper2.anchorPosition = anchorInfoWrapper.position;
                staggeredGridLayoutHelper2.mLayoutWithAnchor = true;
                n2 = n4;
            }
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "checkAnchorInfo span.cacheReferenceLineAndClear()");
            }
            int n10 = this.mSpans.length;
            for (int i3 = 0; i3 < n10; ++i3) {
                this.mSpans[i3].cacheReferenceLineAndClear(layoutManagerHelper.getReverseLayout() ^ anchorInfoWrapper.layoutFromEnd, n2, orientationHelperEx);
            }
        }
    }

    @Override
    public void onItemsChanged(LayoutManagerHelper layoutManagerHelper) {
        this.mLazySpanLookup.clear();
    }

    @Override
    public void onSaveState(Bundle bundle) {
        StaggeredGridLayoutHelper staggeredGridLayoutHelper = this;
        super.onSaveState(bundle);
        bundle.putIntArray(LOOKUP_BUNDLE_KEY, staggeredGridLayoutHelper.mLazySpanLookup.mData);
    }

    @Override
    public void onRestoreInstanceState(Bundle bundle) {
        super.onRestoreInstanceState(bundle);
        this.mLazySpanLookup.mData = bundle.getIntArray(LOOKUP_BUNDLE_KEY);
    }

    @Override
    public void onOffsetChildrenVertical(int n2, LayoutManagerHelper layoutManagerHelper) {
        super.onOffsetChildrenVertical(n2, layoutManagerHelper);
        if (layoutManagerHelper.getOrientation() == 1) {
            int n3 = this.mSpans.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.mSpans[i3].onOffset(n2);
            }
        }
    }

    @Override
    public void onOffsetChildrenHorizontal(int n2, LayoutManagerHelper layoutManagerHelper) {
        super.onOffsetChildrenHorizontal(n2, layoutManagerHelper);
        if (layoutManagerHelper.getOrientation() == 0) {
            int n3 = this.mSpans.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                this.mSpans[i3].onOffset(n2);
            }
        }
    }

    static class LazySpanLookup {
        private static final int MIN_SIZE = 10;
        int[] mData;

        LazySpanLookup() {
        }

        int invalidateAfter(int n2) {
            int[] nArray = this.mData;
            if (this.mData == null) {
                return -1;
            }
            if (n2 >= nArray.length) {
                return -1;
            }
            Arrays.fill(nArray, n2, nArray.length, Integer.MIN_VALUE);
            return this.mData.length;
        }

        int getSpan(int n2) {
            Object object = ((LazySpanLookup)object).mData;
            if (((LazySpanLookup)object).mData != null && n2 < ((Object)object).length && n2 >= 0) {
                return (int)object[n2];
            }
            return Integer.MIN_VALUE;
        }

        void setSpan(int n2, Span span) {
            LazySpanLookup lazySpanLookup = this;
            lazySpanLookup.ensureSize(n2);
            lazySpanLookup.mData[n2] = span.mIndex;
        }

        int sizeForPosition(int n2) {
            int n3;
            for (n3 = this.mData.length; n3 <= n2; n3 *= 2) {
            }
            return n3;
        }

        void ensureSize(int n2) {
            int[] nArray = ((LazySpanLookup)object).mData;
            if (((LazySpanLookup)object).mData == null) {
                ((LazySpanLookup)object).mData = new int[Math.max(n2, 10) + 1];
                Arrays.fill(((LazySpanLookup)object).mData, Integer.MIN_VALUE);
            } else if (n2 >= nArray.length) {
                LazySpanLookup lazySpanLookup = object;
                int[] nArray2 = new int[((LazySpanLookup)object).sizeForPosition(n2)];
                Object object = nArray2;
                v2.mData = nArray2;
                n2 = nArray.length;
                System.arraycopy(nArray, 0, object, 0, n2);
                int n3 = nArray.length;
                Arrays.fill(lazySpanLookup.mData, n3, lazySpanLookup.mData.length, Integer.MIN_VALUE);
            }
        }

        void clear() {
            Object object = ((LazySpanLookup)object).mData;
            if (((LazySpanLookup)object).mData != null) {
                Arrays.fill((int[])object, Integer.MIN_VALUE);
            }
        }

        void offsetForRemoval(int n2, int n3) {
            int[] nArray = this.mData;
            if (this.mData != null && n2 < nArray.length) {
                LazySpanLookup lazySpanLookup = this;
                int n4 = n2 + n3;
                lazySpanLookup.ensureSize(n4);
                nArray = lazySpanLookup.mData;
                int n5 = n4;
                n4 = nArray.length - n2 - n3;
                System.arraycopy(lazySpanLookup.mData, n5, nArray, n2, n4);
                n4 = lazySpanLookup.mData.length - n3;
                Arrays.fill(lazySpanLookup.mData, n4, lazySpanLookup.mData.length, Integer.MIN_VALUE);
                return;
            }
        }

        void offsetForAddition(int n2, int n3) {
            int[] nArray = this.mData;
            if (this.mData != null && n2 < nArray.length) {
                LazySpanLookup lazySpanLookup = this;
                int n4 = n2 + n3;
                lazySpanLookup.ensureSize(n4);
                nArray = lazySpanLookup.mData;
                n3 = nArray.length - n2 - n3;
                System.arraycopy(lazySpanLookup.mData, n2, nArray, n4, n3);
                Arrays.fill(lazySpanLookup.mData, n2, n4, Integer.MIN_VALUE);
                return;
            }
        }
    }

    static class Span {
        static final int INVALID_OFFSET = Integer.MIN_VALUE;
        private ArrayList<View> mViews;
        int mCachedStart;
        int mCachedEnd;
        int mDeletedSize;
        final int mIndex;
        int mLastEdgeStart;
        int mLastEdgeEnd;

        private Span(int n2) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            v1.mViews = arrayList2;
            v1.mCachedStart = Integer.MIN_VALUE;
            v1.mCachedEnd = Integer.MIN_VALUE;
            v1.mDeletedSize = 0;
            v1.mLastEdgeStart = Integer.MIN_VALUE;
            v1.mLastEdgeEnd = Integer.MIN_VALUE;
            v1.mIndex = n2;
        }

        void calculateCachedStart(@NonNull OrientationHelperEx orientationHelperEx) {
            this.mCachedStart = this.mViews.size() == 0 ? Integer.MIN_VALUE : orientationHelperEx.getDecoratedStart(this.mViews.get(0));
        }

        int getStartLine(OrientationHelperEx orientationHelperEx) {
            return this.getStartLine(Integer.MIN_VALUE, orientationHelperEx);
        }

        int getStartLine(int n2, OrientationHelperEx orientationHelperEx) {
            int n3 = this.mCachedStart;
            if (n3 != Integer.MIN_VALUE) {
                return n3;
            }
            if (n2 != Integer.MIN_VALUE && this.mViews.size() == 0) {
                int n4 = this.mLastEdgeEnd;
                if (n4 != Integer.MIN_VALUE) {
                    return n4;
                }
                return n2;
            }
            Span span = this;
            span.calculateCachedStart(orientationHelperEx);
            return span.mCachedStart;
        }

        void calculateCachedEnd(OrientationHelperEx orientationHelperEx) {
            if (this.mViews.size() == 0) {
                this.mCachedEnd = Integer.MIN_VALUE;
            } else {
                ArrayList<View> arrayList = this.mViews;
                this.mCachedEnd = orientationHelperEx.getDecoratedEnd(arrayList.get(arrayList.size() - 1));
            }
        }

        int getEndLine(OrientationHelperEx orientationHelperEx) {
            return this.getEndLine(Integer.MIN_VALUE, orientationHelperEx);
        }

        int getEndLine(int n2, OrientationHelperEx orientationHelperEx) {
            int n3 = this.mCachedEnd;
            if (n3 != Integer.MIN_VALUE) {
                return n3;
            }
            if (n2 != Integer.MIN_VALUE && this.mViews.size() == 0) {
                int n4 = this.mLastEdgeStart;
                if (n4 != Integer.MIN_VALUE) {
                    return n4;
                }
                return n2;
            }
            Span span = this;
            span.calculateCachedEnd(orientationHelperEx);
            return span.mCachedEnd;
        }

        void prependToSpan(View view, OrientationHelperEx orientationHelperEx) {
            Span span = this;
            RecyclerView.LayoutParams layoutParams = span.getLayoutParams(view);
            span.mViews.add(0, view);
            span.mCachedStart = Integer.MIN_VALUE;
            if (span.mViews.size() == 1) {
                this.mCachedEnd = Integer.MIN_VALUE;
            }
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                this.mDeletedSize += orientationHelperEx.getDecoratedMeasurement(view);
            }
        }

        void appendToSpan(View view, OrientationHelperEx orientationHelperEx) {
            Span span = this;
            RecyclerView.LayoutParams layoutParams = span.getLayoutParams(view);
            span.mViews.add(view);
            span.mCachedEnd = Integer.MIN_VALUE;
            if (span.mViews.size() == 1) {
                this.mCachedStart = Integer.MIN_VALUE;
            }
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                this.mDeletedSize += orientationHelperEx.getDecoratedMeasurement(view);
            }
        }

        void cacheReferenceLineAndClear(boolean bl, int n2, OrientationHelperEx orientationHelperEx) {
            int n3 = bl ? this.getEndLine(orientationHelperEx) : this.getStartLine(orientationHelperEx);
            this.clear();
            if (n3 == Integer.MIN_VALUE) {
                return;
            }
            if (!(bl && n3 < orientationHelperEx.getEndAfterPadding() || bl)) {
                orientationHelperEx.getStartAfterPadding();
            }
            if (n2 != Integer.MIN_VALUE) {
                n3 += n2;
            }
            Span span = this;
            span.mCachedEnd = n3;
            span.mCachedStart = n3;
            span.mLastEdgeEnd = Integer.MIN_VALUE;
            span.mLastEdgeStart = Integer.MIN_VALUE;
        }

        void clear() {
            Span span = this;
            span.mViews.clear();
            span.invalidateCache();
            span.mDeletedSize = 0;
        }

        void invalidateCache() {
            Span span = this;
            span.mCachedStart = Integer.MIN_VALUE;
            span.mCachedEnd = Integer.MIN_VALUE;
            span.mLastEdgeEnd = Integer.MIN_VALUE;
            span.mLastEdgeStart = Integer.MIN_VALUE;
        }

        void setLine(int n2) {
            Span span = this;
            span.mCachedStart = n2;
            span.mCachedEnd = n2;
            span.mLastEdgeEnd = Integer.MIN_VALUE;
            span.mLastEdgeStart = Integer.MIN_VALUE;
        }

        void popEnd(OrientationHelperEx orientationHelperEx) {
            Span span = this;
            int n2 = span.mViews.size();
            View view = span.mViews.remove(n2 - 1);
            RecyclerView.LayoutParams layoutParams = span.getLayoutParams(view);
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                this.mDeletedSize -= orientationHelperEx.getDecoratedMeasurement(view);
            }
            if (n2 == 1) {
                this.mCachedStart = Integer.MIN_VALUE;
            }
            this.mCachedEnd = Integer.MIN_VALUE;
        }

        boolean findEnd(View view) {
            int n2 = this.mViews.size();
            if (n2 > 0) {
                return this.mViews.get(n2 - 1) == view;
            }
            return false;
        }

        void popStart(OrientationHelperEx orientationHelperEx) {
            Span span = this;
            View view = span.mViews.remove(0);
            RecyclerView.LayoutParams layoutParams = span.getLayoutParams(view);
            if (span.mViews.size() == 0) {
                this.mCachedEnd = Integer.MIN_VALUE;
            }
            if (layoutParams.isItemRemoved() || layoutParams.isItemChanged()) {
                this.mDeletedSize -= orientationHelperEx.getDecoratedMeasurement(view);
            }
            this.mCachedStart = Integer.MIN_VALUE;
        }

        boolean findStart(View view) {
            if (this.mViews.size() > 0) {
                return this.mViews.get(0) == view;
            }
            return false;
        }

        public int getDeletedSize() {
            return this.mDeletedSize;
        }

        RecyclerView.LayoutParams getLayoutParams(View view) {
            return (RecyclerView.LayoutParams)view.getLayoutParams();
        }

        void onOffset(int n2) {
            int n3 = this.mLastEdgeStart;
            if (n3 != Integer.MIN_VALUE) {
                this.mLastEdgeStart = n3 + n2;
            }
            if ((n3 = this.mCachedStart) != Integer.MIN_VALUE) {
                this.mCachedStart = n3 + n2;
            }
            if ((n3 = this.mLastEdgeEnd) != Integer.MIN_VALUE) {
                this.mLastEdgeEnd = n3 + n2;
            }
            if ((n3 = this.mCachedEnd) != Integer.MIN_VALUE) {
                this.mCachedEnd = n3 + n2;
            }
        }

        int getNormalizedOffset(int n2, int n3, int n4, OrientationHelperEx orientationHelperEx) {
            if (this.mViews.size() == 0) {
                return 0;
            }
            if (n2 < 0) {
                int n5 = this.getEndLine(0, orientationHelperEx) - n4;
                if (n5 <= 0) {
                    return 0;
                }
                if (-n2 > n5) {
                    n2 = -n5;
                }
                return n2;
            }
            int n6 = n3 - this.getStartLine(0, orientationHelperEx);
            if (n6 <= 0) {
                return 0;
            }
            if (n6 >= n2) {
                n6 = n2;
            }
            return n6;
        }

        boolean isEmpty(int n2, int n3, OrientationHelperEx orientationHelperEx) {
            int n4 = this.mViews.size();
            for (int i3 = 0; i3 < n4; ++i3) {
                View view = this.mViews.get(i3);
                if (orientationHelperEx.getDecoratedStart(view) >= n3 || orientationHelperEx.getDecoratedEnd(view) <= n2) continue;
                return false;
            }
            return true;
        }
    }
}

