/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.util.common;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.baidu.navisdk.util.common.LogUtil;

public class ScreenUtil {
    public static final int DENSITY_DEFAULT = 160;
    public static final int SCREEN_SIZE_Y_LARGE = 640;
    private static ScreenUtil mInstance;
    public static final int ROTATION_INVALID = -1;
    public static final int ROTATION_TOP = 0;
    public static final int ROTATION_RIGHT = 1;
    public static final int ROTATION_BOTTOM = 2;
    public static final int ROTATION_LEFT = 3;
    private DisplayMetrics mDM;
    private float mDensity = 0.0f;
    private int mWidthPixels = 0;
    private int mHeightPixels = 0;
    private int mAbsoluteWidth = 0;
    private int mAbsoluteHeight = 0;
    private int mStatusBarHeight = 0;
    private int mDPI = 0;
    private boolean isNavibarShown = false;
    private int mDensityDpi;
    private int mOldLayoutWidth;
    private int mOldLayoutHeight;

    private ScreenUtil() {
    }

    public static ScreenUtil getInstance() {
        if (mInstance == null) {
            mInstance = new ScreenUtil();
        }
        return mInstance;
    }

    private int getStatusBarHeightForLowApi(Context context) {
        if (context instanceof Activity) {
            Rect rect;
            ScreenUtil screenUtil = rect;
            rect = new Rect();
            if ((context = ((Activity)context).getWindow()) != null && context.getDecorView() != null) {
                context.getDecorView().getWindowVisibleDisplayFrame((Rect)screenUtil);
            }
            return ((Rect)screenUtil).top;
        }
        return (int)Math.ceil(context.getResources().getDisplayMetrics().density * 25.0f);
    }

    public void init(Context context) {
        DisplayMetrics displayMetrics;
        if (context == null) {
            return;
        }
        this.mDM = displayMetrics = context.getResources().getDisplayMetrics();
        int n2 = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
        ScreenUtil screenUtil = this;
        DisplayMetrics displayMetrics2 = screenUtil.mDM;
        int n3 = Math.max(displayMetrics2.widthPixels, displayMetrics2.heightPixels);
        if (n2 == screenUtil.mWidthPixels && n3 == this.mHeightPixels) {
            return;
        }
        this.mWidthPixels = n2;
        this.mHeightPixels = n3;
        DisplayMetrics displayMetrics3 = this.mDM;
        this.mDensity = displayMetrics3.density;
        this.mDensityDpi = displayMetrics3.densityDpi;
        if (Build.VERSION.SDK_INT >= 17) {
            int n4;
            DisplayMetrics displayMetrics4;
            Context context2 = context;
            context = displayMetrics4;
            displayMetrics4 = new DisplayMetrics();
            ((WindowManager)context2.getSystemService("window")).getDefaultDisplay().getRealMetrics((DisplayMetrics)context);
            this.mAbsoluteWidth = Math.min(context.widthPixels, context.heightPixels);
            this.mAbsoluteHeight = n4 = Math.max(context.widthPixels, context.heightPixels);
            n4 = n4 > this.mHeightPixels ? 1 : 0;
            this.isNavibarShown = n4;
        } else {
            ScreenUtil screenUtil2 = this;
            screenUtil2.mAbsoluteWidth = n2;
            screenUtil2.mAbsoluteHeight = n3;
        }
        this.mDPI = this.mDM.densityDpi;
        if (this.mDPI == 0) {
            this.mDPI = 160;
        }
    }

    public DisplayMetrics getDisplayMetrics() {
        return this.mDM;
    }

    public float getDensity() {
        return this.mDensity;
    }

    public int getDPI() {
        return this.mDPI;
    }

    public int getWidthPixels() {
        return this.mWidthPixels;
    }

    public int getHeightPixels() {
        return this.mHeightPixels;
    }

    public int getStatusBarHeight(Activity activity) {
        if (this.mStatusBarHeight == 0) {
            if (activity == null) {
                return 0;
            }
            this.resetStatusBarHeight(activity);
        }
        return this.mStatusBarHeight;
    }

    public void resetStatusBarHeight(Activity activity) {
        if (activity == null) {
            return;
        }
        ScreenUtil screenUtil = screenUtil3;
        Activity activity2 = activity;
        Class<?> clazz = Class.forName("com.android.internal.R$dimen");
        Class<?> clazz2 = clazz;
        Object obj = clazz.newInstance();
        int n2 = Integer.parseInt(clazz2.getField("status_bar_height").get(obj).toString());
        try {
            screenUtil.mStatusBarHeight = activity2.getResources().getDimensionPixelSize(n2);
        }
        catch (Exception exception) {
            Rect rect;
            ScreenUtil screenUtil2 = screenUtil3;
            ScreenUtil screenUtil3 = rect;
            screenUtil3();
            activity.getWindow().getDecorView().getWindowVisibleDisplayFrame((Rect)screenUtil3);
            screenUtil2.mStatusBarHeight = rect.top;
        }
    }

    public int dip2px(int n2) {
        return (int)(this.mDensity * (float)n2 + 0.5f);
    }

    public int px2dip(int n2) {
        return (int)((float)n2 / this.mDensity + 0.5f);
    }

    public int dip2px(float f3) {
        return (int)(this.mDensity * f3 + 0.5f);
    }

    public int px2dip(float f3) {
        return (int)(f3 / this.mDensity + 0.5f);
    }

    public int getDp(Context context, int n2) {
        if (context != null && context.getResources() != null) {
            return this.px2dip(context.getResources().getDimensionPixelSize(n2));
        }
        return 0;
    }

    public int percentHeight(float f3) {
        return (int)(f3 * (float)this.getHeightPixels());
    }

    public int percentWidth(float f3) {
        return (int)(f3 * (float)this.getWidthPixels());
    }

    public int getStatusBarHeightFullScreen(Context context) {
        if (context == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return this.getStatusBarHeightForLowApi(context);
        }
        int n2 = 0;
        int n3 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n3 > 0) {
            n2 = context.getResources().getDimensionPixelSize(n3);
        }
        if (n2 <= 0) {
            n2 = this.dip2px(25);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getDisplayRotation(Activity activity) {
        if (activity == null) {
            return 0;
        }
        switch (activity.getWindowManager().getDefaultDisplay().getRotation()) {
            default: {
                return 0;
            }
            case 3: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 0: 
        }
        return 0;
    }

    public int getAbsoluteWidth() {
        return this.mAbsoluteWidth;
    }

    public int getAbsoluteHeight() {
        return this.mAbsoluteHeight;
    }

    public boolean isNavibarShown() {
        return this.isNavibarShown;
    }

    public void setNavibarShown(boolean bl) {
        LogUtil.e("setUIViewBound", "setNavibarShown - " + bl);
        this.isNavibarShown = bl;
    }

    public int getNaviBarHeight() {
        return this.getAbsoluteHeight() - this.mHeightPixels;
    }

    public int getDensityDpi() {
        return this.mDensityDpi;
    }

    public void keepScreenOn(boolean bl, Activity activity) {
        if (activity != null && !activity.isFinishing()) {
            if (bl) {
                activity.getWindow().addFlags(128);
            } else {
                activity.getWindow().clearFlags(128);
            }
            return;
        }
    }

    public int getScreenOrientation(Activity activity) {
        if (activity == null) {
            return -1;
        }
        return activity.getResources().getConfiguration().orientation;
    }

    public void setScreenOrientation(Activity activity, int n2) {
        if (activity != null) {
            activity.setRequestedOrientation(n2);
        }
    }
}

