/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.util.jar.style;

import android.content.Context;
import android.content.res.Resources;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.jar.JarUtils;
import com.baidu.navisdk.util.jar.style.StyleAttr;
import com.baidu.navisdk.util.jar.style.StyleCommonView;
import com.baidu.navisdk.util.jar.style.StyleImageView;
import com.baidu.navisdk.util.jar.style.StyleTextView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class BNInflaterFactory
implements LayoutInflater.Factory {
    private static final String TAG = "BNInflaterFactory";
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit.", "android.view.", "android.app."};
    public static final int ID_NULL = 0;
    private static long mLastReleaseTime = 0L;
    private static final HashMap<String, Constructor<? extends View>> mConstructorMap = new HashMap();
    private static volatile BNInflaterFactory mInstance = null;
    private final ConcurrentHashMap<Integer, StyleCommonView> mStyleCommonViewMap;

    private BNInflaterFactory() {
        ConcurrentHashMap concurrentHashMap;
        ConcurrentHashMap concurrentHashMap2 = concurrentHashMap;
        concurrentHashMap = new ConcurrentHashMap();
        v1.mStyleCommonViewMap = concurrentHashMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BNInflaterFactory getInstance() {
        if (mInstance != null) return mInstance;
        Class<BNInflaterFactory> clazz = BNInflaterFactory.class;
        synchronized (BNInflaterFactory.class) {
            if (mInstance != null) return mInstance;
            mInstance = new BNInflaterFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private final View handleCreateView(String string2, Context context, AttributeSet attributeSet) {
        View view = null;
        if (-1 == string2.indexOf(46)) {
            String[] stringArray = sClassPrefixList;
            int n2 = sClassPrefixList.length;
            for (int i3 = 0; i3 < n2; ++i3) {
                try {
                    view = this.handleCreateView(string2, stringArray[i3], context, attributeSet);
                    if (view == null) continue;
                    return view;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            try {
                view = this.handleCreateView(string2, null, context, attributeSet);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return view;
    }

    private final View handleCreateView(String string2, String string3, Context context, AttributeSet attributeSet) throws ClassNotFoundException {
        Constructor<? extends View> constructor;
        block10: {
            Class<View> clazz = context.getClassLoader();
            constructor = mConstructorMap.get(string2);
            if (constructor == null) {
                if ((clazz = ((ClassLoader)((Object)clazz)).loadClass(string3 = string3 == null ? string2 : string3 + string2).asSubclass(View.class)) == null) {
                    LogUtil.e(TAG, "handleCreateView fail c is null name=" + string2);
                    return null;
                }
                Class<View> clazz2 = clazz;
                Class[] classArray = new Class[2];
                classArray[0] = Context.class;
                classArray[1] = AttributeSet.class;
                constructor = clazz2.getConstructor(classArray);
                try {
                    mConstructorMap.put(string2, constructor);
                }
                catch (Exception exception) {
                    if (!LogUtil.LOGGABLE) break block10;
                    exception.printStackTrace();
                    LogUtil.printException(TAG, exception);
                }
            }
        }
        try {
            return constructor.newInstance(context, attributeSet);
        }
        catch (Exception exception) {
            if (LogUtil.LOGGABLE) {
                exception.printStackTrace();
                LogUtil.printException(TAG, exception);
            }
            return null;
        }
    }

    private void parseAttrs(Context object, AttributeSet attributeSet, View view) {
        if (view == null) {
            LogUtil.e(TAG, "parseAttrs fail view is null");
            return;
        }
        Resources resources = object.getResources();
        StyleAttr styleAttr = null;
        StyleAttr styleAttr2 = null;
        StyleAttr[] styleAttrArray = null;
        StyleAttr styleAttr3 = null;
        StyleAttr styleAttr4 = null;
        int n2 = attributeSet.getAttributeCount();
        for (int i3 = 0; i3 < n2; ++i3) {
            String string2 = attributeSet.getAttributeName(i3);
            String string3 = attributeSet.getAttributeValue(i3);
            if ("background".equals(string2)) {
                styleAttr = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("textColor".equals(string2)) {
                styleAttr2 = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("drawableLeft".equals(string2)) {
                if (styleAttrArray == null) {
                    styleAttrArray = new StyleAttr[4];
                }
                styleAttrArray[0] = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("drawableTop".equals(string2)) {
                if (styleAttrArray == null) {
                    styleAttrArray = new StyleAttr[4];
                }
                styleAttrArray[1] = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("drawableRight".equals(string2)) {
                if (styleAttrArray == null) {
                    styleAttrArray = new StyleAttr[4];
                }
                styleAttrArray[2] = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("drawableBottom".equals(string2)) {
                if (styleAttrArray == null) {
                    styleAttrArray = new StyleAttr[4];
                }
                styleAttrArray[3] = this.createAttr(string2, string3, resources);
                continue;
            }
            if ("src".equals(string2) && view instanceof ImageView) {
                styleAttr3 = this.createAttr(string2, string3, resources);
                continue;
            }
            if (!"style".equals(string2)) continue;
            styleAttr4 = this.createAttr(string2, string3, resources);
        }
        if (styleAttr4 != null && (styleAttr == null || styleAttr2 == null)) {
            int n3;
            int n4;
            Context context = object;
            int[] nArray = new int[2];
            object = nArray;
            nArray[0] = 16842904;
            nArray[1] = 16842964;
            object = context.obtainStyledAttributes(styleAttr4.mId, (int[])object);
            if (styleAttr2 == null && object.hasValue(0) && (n4 = object.getResourceId(0, 0)) != 0) {
                styleAttr2 = this.createAttr("textColor", n4, resources);
            }
            if (styleAttr == null && object.hasValue(1) && (n3 = object.getResourceId(1, 0)) != 0) {
                styleAttr = this.createAttr("background", n3, resources);
            }
            object.recycle();
        }
        if (styleAttr != null || styleAttr2 != null || styleAttrArray != null || styleAttr3 != null) {
            object = this.createStyleCommonView(view);
            ((StyleCommonView)object).mBackGroundAttr = styleAttr;
            if (object instanceof StyleTextView) {
                StyleTextView styleTextView = (StyleTextView)object;
                styleTextView.mTextColorAttr = styleAttr2;
                styleTextView.mComponentDrawableAttr = styleAttrArray;
            }
            if (object instanceof StyleImageView) {
                ((StyleImageView)object).mImageResourceAttr = styleAttr3;
            }
            ((StyleCommonView)object).updateStyle();
            this.addToCache((StyleCommonView)object);
        }
    }

    private synchronized void addToCache(StyleCommonView styleCommonView) {
        this.mStyleCommonViewMap.put(styleCommonView.mKey, styleCommonView);
    }

    private synchronized void removeFromCache(StyleCommonView styleCommonView) {
        this.mStyleCommonViewMap.remove(styleCommonView.mKey);
    }

    private synchronized StyleCommonView getStyleView(View view) {
        StyleCommonView styleCommonView = this.mStyleCommonViewMap.get(view.hashCode());
        if (styleCommonView == null) {
            BNInflaterFactory bNInflaterFactory = this;
            styleCommonView = bNInflaterFactory.createStyleCommonView(view);
            bNInflaterFactory.addToCache(styleCommonView);
        }
        return styleCommonView;
    }

    private StyleCommonView createStyleCommonView(View view) {
        Object object;
        if (view instanceof TextView) {
            StyleTextView styleTextView;
            object = styleTextView;
            styleTextView = new StyleTextView(view);
        } else if (view instanceof ImageView) {
            StyleImageView styleImageView;
            object = styleImageView;
            styleImageView = new StyleImageView(view);
        } else {
            StyleCommonView styleCommonView;
            object = styleCommonView;
            styleCommonView = new StyleCommonView(view);
        }
        return object;
    }

    private StyleAttr createAttr(String string2, String string3, Resources resources) {
        if (string3 != null && string3.startsWith("@")) {
            int n2 = Integer.parseInt(string3.substring(1));
            if (n2 == 0) {
                return null;
            }
            return this.createAttr(string2, n2, resources);
        }
        return null;
    }

    private StyleAttr createAttr(String string2, int n2, Resources object) {
        StyleAttr styleAttr;
        Object object2 = styleAttr;
        Resources resources = object;
        ((StyleAttr)object2)();
        object2 = resources.getResourceEntryName(n2);
        object = resources.getResourceTypeName(n2);
        styleAttr.mAttrName = string2;
        styleAttr.mId = n2;
        styleAttr.mEntryName = object2;
        styleAttr.mEntryType = object;
        return styleAttr;
    }

    public View onCreateView(String string2, Context context, AttributeSet attributeSet) {
        View view = this.handleCreateView(string2, context, attributeSet);
        if (view == null) {
            LogUtil.e(TAG, "view is null name:" + string2);
        } else {
            this.parseAttrs(context, attributeSet, view);
        }
        return view;
    }

    public void updateStyle() {
        Object object = ((BNInflaterFactory)object).mStyleCommonViewMap;
        if (object != null) {
            object = ((ConcurrentHashMap)object).entrySet().iterator();
            while (object.hasNext()) {
                WeakReference<View> weakReference;
                StyleCommonView styleCommonView = (StyleCommonView)object.next().getValue();
                if (styleCommonView != null && (weakReference = styleCommonView.mView) != null && weakReference.get() != null) {
                    styleCommonView.updateStyle();
                    continue;
                }
                object.remove();
            }
        }
    }

    public void releaseNullStyle() {
        long l2 = SystemClock.elapsedRealtime();
        if (l2 - mLastReleaseTime > 5000L) {
            return;
        }
        Object object = ((BNInflaterFactory)object).mStyleCommonViewMap;
        if (object != null) {
            object = ((ConcurrentHashMap)object).entrySet().iterator();
            while (object.hasNext()) {
                Object object2 = (StyleCommonView)object.next().getValue();
                if (object2 != null && (object2 = ((StyleCommonView)object2).mView) != null && ((Reference)object2).get() != null) continue;
                object.remove();
            }
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "releaseNullStyle cost time:" + (SystemClock.elapsedRealtime() - l2));
        }
    }

    public void setBackground(View object, int n2) {
        object = bNInflaterFactory2.getStyleView((View)object);
        if (n2 == 0) {
            ((StyleCommonView)object).mBackGroundAttr = null;
        } else {
            BNInflaterFactory bNInflaterFactory = bNInflaterFactory2;
            BNInflaterFactory bNInflaterFactory2 = JarUtils.getResources();
            ((StyleCommonView)object).mBackGroundAttr = bNInflaterFactory.createAttr("background", n2, (Resources)bNInflaterFactory2);
        }
        ((StyleCommonView)object).updateStyle();
    }

    public void setTextColor(TextView textView, int n2) {
        StyleCommonView styleCommonView = bNInflaterFactory2.getStyleView((View)textView);
        if (!(styleCommonView instanceof StyleTextView)) {
            bNInflaterFactory2.removeFromCache(styleCommonView);
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "setTextColor error StyleTextView error");
            }
        }
        StyleTextView styleTextView = (StyleTextView)bNInflaterFactory2.getStyleView((View)textView);
        BNInflaterFactory bNInflaterFactory = bNInflaterFactory2;
        BNInflaterFactory bNInflaterFactory2 = JarUtils.getResources();
        styleTextView.mTextColorAttr = bNInflaterFactory.createAttr("textColor", n2, (Resources)bNInflaterFactory2);
        styleTextView.updateStyle();
    }

    public void setCompoundDrawables(TextView object, int n2, int n3, int n4, int n5) {
        object = (StyleTextView)bNInflaterFactory2.getStyleView((View)object);
        Resources resources = new StyleAttr[4];
        v0.mComponentDrawableAttr = resources;
        if (n2 > 0) {
            Resources resources2 = resources;
            resources = JarUtils.getResources();
            resources2[0] = bNInflaterFactory2.createAttr("drawableLeft", n2, resources);
        }
        if (n3 > 0) {
            Resources resources3 = JarUtils.getResources();
            ((StyleTextView)object).mComponentDrawableAttr[1] = bNInflaterFactory2.createAttr("drawableTop", n3, resources3);
        }
        if (n4 > 0) {
            Resources resources4 = JarUtils.getResources();
            ((StyleTextView)object).mComponentDrawableAttr[2] = bNInflaterFactory2.createAttr("drawableRight", n3, resources4);
        }
        if (n5 > 0) {
            BNInflaterFactory bNInflaterFactory = bNInflaterFactory2;
            BNInflaterFactory bNInflaterFactory2 = JarUtils.getResources();
            ((StyleTextView)object).mComponentDrawableAttr[3] = bNInflaterFactory.createAttr("drawableBottom", n3, (Resources)bNInflaterFactory2);
        }
        ((StyleTextView)object).updateStyle();
    }

    public void setImageResource(View view, int n2) {
        StyleImageView styleImageView = (StyleImageView)bNInflaterFactory2.getStyleView(view);
        BNInflaterFactory bNInflaterFactory = bNInflaterFactory2;
        BNInflaterFactory bNInflaterFactory2 = JarUtils.getResources();
        styleImageView.mImageResourceAttr = bNInflaterFactory.createAttr("background", n2, (Resources)bNInflaterFactory2);
        styleImageView.updateStyle();
    }
}

