/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.vi;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.PhoneNumberUtils;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.webkit.MimeTypeMap;
import com.baidu.navisdk.framework.interfaces.c;
import com.baidu.navisdk.framework.interfaces.g;
import com.baidu.navisdk.k;
import com.baidu.navisdk.ui.util.TipTool;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.ScreenUtil;
import com.baidu.navisdk.util.common.d0;
import com.baidu.navisdk.util.common.f0;
import com.baidu.navisdk.util.common.r;
import com.baidu.navisdk.util.common.t;
import com.baidu.navisdk.util.worker.d;
import com.baidu.navisdk.util.worker.f;
import com.baidu.navisdk.util.worker.h;
import com.baidu.navisdk.vi.VNetworkInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.List;

public class VDeviceAPI {
    private static final String TAG = "VDeviceAPI in java";
    private static PowerManager.WakeLock mWakeLock;
    private static BroadcastReceiver mNetworkStateReceiver;
    private static final int ERROR_INVALID_ADDRESS = 1;
    private static final int ERROR_INVALID_FILE_FORMAT = 2;
    public static final String APP_NAME_BAIDU_MAP = "BaiduMap";
    public static final String APP_PRODUCT_KIND = "baiduNavi_SDK_FOR_Map";
    private static Context sContext;
    private static String sSDCardPath;
    private static String sSDCardCachePath;

    public static void init(Context context, String string2, String string3) {
        sContext = context;
        sSDCardPath = string2;
        sSDCardCachePath = string3;
    }

    public static long getTotalSpace() {
        StatFs statFs;
        File file = Environment.getRootDirectory();
        StatFs statFs2 = statFs;
        return (long)new StatFs(file.getPath()).getBlockSize() * (long)statFs2.getBlockCount() / 1024L;
    }

    public static long getFreeSpace() {
        StatFs statFs;
        File file = Environment.getRootDirectory();
        StatFs statFs2 = statFs;
        return (long)new StatFs(file.getPath()).getBlockSize() * (long)statFs2.getAvailableBlocks() / 1024L;
    }

    public static long getSdcardTotalSpace() {
        StatFs statFs;
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs2 = statFs;
        return (long)new StatFs(file.getPath()).getBlockSize() * (long)statFs2.getBlockCount() / 1024L;
    }

    public static long getSdcardFreeSpace() {
        long l2 = 0L;
        long l3 = 0L;
        File file = Environment.getExternalStorageDirectory();
        StatFs statFs = new StatFs(file.getPath());
        StatFs statFs2 = statFs;
        l2 = statFs.getBlockSize();
        try {
            l3 = statFs2.getAvailableBlocks();
        }
        catch (Exception exception) {
            LogUtil.e(TAG, "getSdcardFreeSpace fail");
        }
        return l2 * l3 / 1024L;
    }

    public static long getTotalMemory() {
        BufferedReader bufferedReader;
        FileReader fileReader;
        String string2 = "/proc/meminfo";
        long l2 = 0L;
        FileReader fileReader2 = fileReader;
        try {
            fileReader = new FileReader(string2);
            BufferedReader bufferedReader2 = new BufferedReader(fileReader2, 8192);
            bufferedReader = bufferedReader2;
            l2 = Integer.valueOf(bufferedReader2.readLine().split("\\s+")[1]).intValue();
        }
        catch (IOException iOException) {}
        bufferedReader.close();
        fileReader.close();
        return l2;
    }

    public static long getAvailableMemory() {
        ActivityManager.MemoryInfo memoryInfo;
        Context context = sContext;
        if (context == null) {
            return 0L;
        }
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        context = memoryInfo;
        activityManager.getMemoryInfo(new ActivityManager.MemoryInfo());
        return context.availMem / 1024L;
    }

    public static String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getPhoneType() {
        String string2 = Build.MODEL;
        if (string2 == null || string2 != null && string2.length() == 0) {
            string2 = "unknown";
        }
        return string2;
    }

    public static String getMacAddress() {
        Context context = sContext;
        if (context == null) {
            return "";
        }
        if ((context = (WifiManager)context.getSystemService("wifi")) != null && context.getConnectionInfo() != null) {
            String string2 = context.getConnectionInfo().getMacAddress();
            LogUtil.e(TAG, "===Mac Address = " + string2);
            return string2;
        }
        return "";
    }

    public static void setupSoftware(String string2) {
        Intent intent;
        if (sContext == null) {
            return;
        }
        Intent intent2 = intent;
        new Intent("android.intent.action.VIEW").setDataAndType(Uri.fromFile((File)new File(string2)), "application/vnd.android.package-archive");
        sContext.startActivity(intent2);
    }

    public static String getModuleFileName() {
        Context context = sContext;
        if (context == null) {
            return null;
        }
        return context.getFilesDir().getAbsolutePath();
    }

    public static String getSdcardPath() {
        return sSDCardPath;
    }

    public static void showJniToast(String object) {
        g g3 = c.o().c();
        if (g3 != null && g3.y()) {
            f f3;
            object = "ENG:" + (String)object;
            if (LogUtil.LOGGABLE) {
                LogUtil.e("showJniToast", " showJniToast toast: " + (String)object);
            }
            h<String, String> h3 = new h<String, String>("ShowJniToast-" + VDeviceAPI.class.getSimpleName(), null, (String)object){
                final /* synthetic */ String a;
                {
                    this.a = string4;
                    super(string2, string3);
                }

                @Override
                protected String execute() {
                    TipTool.onCreateJNIToast(sContext, this.a);
                    return null;
                }
            };
            object = f3;
            f3 = new f(99, 0);
            d.a().submitMainThreadTask(h3, (f)object);
            return;
        }
    }

    public static String getCachePath() {
        return sSDCardCachePath;
    }

    public static String getDataVersion() {
        return k.b();
    }

    public static String getSDKVersion() {
        return k.a();
    }

    public static String getAppPackageVersion() {
        return t.m();
    }

    public static int getAppVersionCode() {
        return t.l();
    }

    public static String getAppPackageName() {
        return t.i();
    }

    public static int getCurrentNetworkType() {
        return r.c(sContext);
    }

    public static int isWifiConnected() {
        return r.e(sContext) ? 1 : 0;
    }

    public static VNetworkInfo getNetworkInfo(int n2) {
        NetworkInfo networkInfo = r.a(sContext, n2);
        return new VNetworkInfo(networkInfo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean setNetworkChangedCallback() {
        IntentFilter intentFilter;
        VDeviceAPI.unsetNetworkChangedCallback();
        mNetworkStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                LogUtil.e(VDeviceAPI.TAG, "network changed.");
                try {
                    VDeviceAPI.onNetworkStateChanged();
                }
                catch (Throwable throwable) {}
            }
        };
        IntentFilter intentFilter2 = intentFilter;
        intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        if (sContext == null) return true;
        try {
            sContext.getApplicationContext().registerReceiver(mNetworkStateReceiver, intentFilter2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unsetNetworkChangedCallback() {
        if (mNetworkStateReceiver == null) return true;
        try {
            if (sContext != null) {
                sContext.getApplicationContext().unregisterReceiver(mNetworkStateReceiver);
            }
            mNetworkStateReceiver = null;
            return true;
        }
        catch (Exception exception) {
            mNetworkStateReceiver = null;
        }
        return true;
    }

    public static native void onNetworkStateChanged();

    public static ScanResult[] getWifiHotpot() {
        Context context = sContext;
        if (context == null) {
            return null;
        }
        List list = ((WifiManager)context.getSystemService("wifi")).getScanResults();
        return list.toArray(new ScanResult[list.size()]);
    }

    public static float getSystemMetricsX() {
        return ScreenUtil.getInstance().getWidthPixels();
    }

    public static float getSystemMetricsY() {
        return ScreenUtil.getInstance().getHeightPixels();
    }

    public static int getWindowWidth() {
        return ScreenUtil.getInstance().getWidthPixels();
    }

    public static int getWindowHeight() {
        return ScreenUtil.getInstance().getHeightPixels();
    }

    public static float getScreenDensity() {
        return ScreenUtil.getInstance().getDensity();
    }

    public static int getScreenDensityDpi() {
        return ScreenUtil.getInstance().getDPI();
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"Wakelock"})
    public static void setScreenAlwaysOn(boolean var0) {
        block10: {
            block9: {
                if (!var0) ** GOTO lbl18
                if (VDeviceAPI.mWakeLock != null) break block9;
                try {
                    var0_1 = (PowerManager)VDeviceAPI.sContext.getSystemService("power");
                    if (var0_1 == null) break block9;
                }
                catch (Exception v0) {}
                VDeviceAPI.mWakeLock = var0_1.newWakeLock(0x2000000A, "VDeviceAPI");
            }
            try {
                if (VDeviceAPI.mWakeLock == null) break block10;
            }
            catch (Exception v1) {}
            VDeviceAPI.mWakeLock.acquire();
            break block10;
lbl18:
            // 1 sources

            if (VDeviceAPI.mWakeLock == null) break block10;
            if (!VDeviceAPI.mWakeLock.isHeld()) break block10;
            VDeviceAPI.mWakeLock.release();
        }
    }

    public static int getScreenBrightness() {
        Context context = sContext;
        if (context == null) {
            return -1;
        }
        context = context.getContentResolver();
        int n2 = 0;
        try {
            n2 = Settings.System.getInt((ContentResolver)context, (String)"screen_brightness_mode");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            LogUtil.e("", settingNotFoundException.toString());
        }
        if (n2 == 1) {
            return -1;
        }
        try {
            return Settings.System.getInt((ContentResolver)context, (String)"screen_brightness");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            return -1;
        }
    }

    public static void makeCall(String string2) {
        Intent intent;
        if (sContext == null) {
            return;
        }
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.DIAL", Uri.parse((String)("tel:" + string2)));
        sContext.startActivity(intent2);
    }

    public static void sendSMS(String string2, String string3) {
        Intent intent;
        if (sContext == null) {
            return;
        }
        Intent intent2 = intent;
        new Intent("android.intent.action.SENDTO", Uri.parse((String)("smsto:" + string2))).putExtra("sms_body", string3);
        sContext.startActivity(intent2);
    }

    public static int sendMMS(String string2, String string3, String string4, String string5) {
        Intent intent;
        Intent intent2;
        String string6;
        if (sContext == null) {
            return 0;
        }
        if (!PhoneNumberUtils.isWellFormedSmsAddress((String)string2)) {
            LogUtil.e(TAG, "invalid address: " + string2);
            return 1;
        }
        try {
            string6 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(string5)).toString()));
        }
        catch (Exception exception) {
            LogUtil.e(TAG, "can't get the mimetype of this file: " + string5);
            return 2;
        }
        Intent intent3 = intent2 = intent;
        intent3("android.intent.action.SEND");
        intent3.putExtra("address", string2);
        intent3.putExtra("subject", string3);
        intent3.putExtra("sms_body", string4);
        intent3.putExtra("android.intent.extra.STREAM", (Parcelable)Uri.parse((String)("file://" + string5)));
        intent.setType(string6);
        sContext.startActivity(intent2);
        return 0;
    }

    public static void openUrl(String string2) {
        Intent intent;
        if (sContext == null) {
            return;
        }
        Intent intent2 = intent;
        intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        sContext.startActivity(intent2);
    }

    public static String getCellId() {
        Context context = sContext;
        if (context != null && f0.a(context, "android.permission.READ_PHONE_STATE")) {
            context = (TelephonyManager)sContext.getSystemService("phone");
            if (context == null) {
                return null;
            }
            if ((context = context.getCellLocation()) instanceof GsmCellLocation) {
                return " " + ((GsmCellLocation)context).getCid();
            }
            return " ";
        }
        return " ";
    }

    public static String getLac() {
        Context context = sContext;
        if (context != null && f0.a(context, "android.permission.READ_PHONE_STATE")) {
            context = (TelephonyManager)sContext.getSystemService("phone");
            if (context == null) {
                return null;
            }
            if ((context = context.getCellLocation()) instanceof GsmCellLocation) {
                return "" + ((GsmCellLocation)context).getLac();
            }
            return "";
        }
        return "";
    }

    public static String getImei() {
        return "000000000000000";
    }

    public static String getImsi() {
        block3: {
            Context context = sContext;
            if (context != null && f0.a(context, "android.permission.READ_PHONE_STATE") && (context = (TelephonyManager)sContext.getSystemService("phone")) != null) {
                try {
                    return context.getSubscriberId();
                }
                catch (Exception exception) {
                    if (!LogUtil.LOGGABLE) break block3;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static String getChannelID() {
        File file;
        if (sContext == null) {
            return "baidu";
        }
        String string2 = "baidu";
        Object object = "/data/data/" + sContext.getPackageName() + "/channel";
        Object object2 = file;
        if (!new File((String)object).exists()) {
            FileOutputStream fileOutputStream;
            File file2;
            InputStream inputStream = sContext.getAssets().open("channel");
            InputStream inputStream2 = inputStream;
            InputStream inputStream3 = inputStream;
            byte[] byArray = new byte[inputStream.available()];
            object2 = byArray;
            inputStream3.read(byArray);
            File file3 = file2;
            file2 = new File((String)object);
            object = fileOutputStream;
            ((FileOutputStream)object)(file3);
            ((FileOutputStream)object).write((byte[])object2);
            string2 = d0.a((byte[])object2, "UTF-8");
            try {
                fileOutputStream.close();
                inputStream2.close();
            }
            catch (IOException iOException) {
                LogUtil.e("", iOException.toString());
            }
        } else {
            FileInputStream fileInputStream;
            object = fileInputStream;
            fileInputStream = new FileInputStream((File)object2);
            string2 = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8")).readLine().toString();
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {
                LogUtil.e("", exception.toString());
            }
        }
        return string2.trim();
    }

    public static String getAppProductKind() {
        LogUtil.e("VDeviceAPI", "getAppProductKind");
        return APP_PRODUCT_KIND;
    }

    public static String getCuid() {
        LogUtil.e("VDeviceAPI", "getCuid");
        return t.g();
    }

    public static String add(String string2, String string3) {
        return new BigInteger(string2).add(new BigInteger(string3)).toString();
    }

    public static String subtract(String string2, String string3) {
        return new BigInteger(string2).subtract(new BigInteger(string3)).toString();
    }

    public static String multiply(String string2, String string3) {
        return new BigInteger(string2).multiply(new BigInteger(string3)).toString();
    }

    public static String divide(String string2, String string3) {
        return new BigInteger(string2).divide(new BigInteger(string3)).toString();
    }

    public static String mod(String string2, String string3) {
        return new BigInteger(string2).mod(new BigInteger(string3)).toString();
    }

    public static boolean gt(String string2, String string3) {
        return new BigInteger(string2).compareTo(new BigInteger(string3)) > 0;
    }

    public static boolean lt(String string2, String string3) {
        return new BigInteger(string2).compareTo(new BigInteger(string3)) < 0;
    }

    public static boolean nlt(String string2, String string3) {
        return new BigInteger(string2).compareTo(new BigInteger(string3)) >= 0;
    }

    public static boolean equals(String string2, String string3) {
        return new BigInteger(string2).compareTo(new BigInteger(string3)) == 0;
    }

    public static String powerMod(String object, int n2, String object2) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4 = bigInteger3;
        bigInteger3 = new BigInteger((String)object);
        object = bigInteger2;
        bigInteger2 = new BigInteger((String)object2);
        object2 = bigInteger;
        bigInteger = new BigInteger("1");
        while (n2 > 0) {
            if (n2 % 2 != 0) {
                object2 = ((BigInteger)object2).multiply(bigInteger4).mod((BigInteger)object);
                --n2;
                continue;
            }
            BigInteger bigInteger5 = bigInteger4;
            bigInteger4 = bigInteger5.multiply(bigInteger5).mod((BigInteger)object);
            n2 /= 2;
        }
        return ((BigInteger)object2).mod((BigInteger)object).toString();
    }
}

