/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.support.v4.view;

import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import com.google.android.support.v4.view.AccessibilityDelegateCompatIcs;
import com.google.android.support.v4.view.AccessibilityDelegateCompatJellyBean;
import com.google.android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.support.v4.view.accessibility.AccessibilityNodeProviderCompat;

public class AccessibilityDelegateCompat {
    private static final AccessibilityDelegateImpl IMPL;
    private static final Object DEFAULT_DELEGATE;
    final Object mBridge = IMPL.newAccessiblityDelegateBridge(this);

    static {
        int n2 = Build.VERSION.SDK_INT;
        IMPL = n2 >= 16 ? new AccessibilityDelegateJellyBeanImpl() : (n2 >= 14 ? new AccessibilityDelegateIcsImpl() : new AccessibilityDelegateStubImpl());
        DEFAULT_DELEGATE = IMPL.newAccessiblityDelegateDefaultImpl();
    }

    Object getBridge() {
        return this.mBridge;
    }

    public void sendAccessibilityEvent(View view, int n2) {
        IMPL.sendAccessibilityEvent(DEFAULT_DELEGATE, view, n2);
    }

    public void sendAccessibilityEventUnchecked(View view, AccessibilityEvent accessibilityEvent) {
        IMPL.sendAccessibilityEventUnchecked(DEFAULT_DELEGATE, view, accessibilityEvent);
    }

    public boolean dispatchPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        return IMPL.dispatchPopulateAccessibilityEvent(DEFAULT_DELEGATE, view, accessibilityEvent);
    }

    public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        IMPL.onPopulateAccessibilityEvent(DEFAULT_DELEGATE, view, accessibilityEvent);
    }

    public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
        IMPL.onInitializeAccessibilityEvent(DEFAULT_DELEGATE, view, accessibilityEvent);
    }

    public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
        IMPL.onInitializeAccessibilityNodeInfo(DEFAULT_DELEGATE, view, accessibilityNodeInfoCompat);
    }

    public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
        return IMPL.onRequestSendAccessibilityEvent(DEFAULT_DELEGATE, viewGroup, view, accessibilityEvent);
    }

    public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(View view) {
        return IMPL.getAccessibilityNodeProvider(DEFAULT_DELEGATE, view);
    }

    public boolean performAccessibilityAction(View view, int n2, Bundle bundle) {
        return IMPL.performAccessibilityAction(DEFAULT_DELEGATE, view, n2, bundle);
    }

    static class AccessibilityDelegateIcsImpl
    extends AccessibilityDelegateStubImpl {
        AccessibilityDelegateIcsImpl() {
        }

        @Override
        public Object newAccessiblityDelegateDefaultImpl() {
            return AccessibilityDelegateCompatIcs.newAccessibilityDelegateDefaultImpl();
        }

        @Override
        public Object newAccessiblityDelegateBridge(final AccessibilityDelegateCompat accessibilityDelegateCompat) {
            return AccessibilityDelegateCompatIcs.newAccessibilityDelegateBridge(new AccessibilityDelegateCompatIcs.AccessibilityDelegateBridge(){

                @Override
                public boolean dispatchPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
                    return accessibilityDelegateCompat.dispatchPopulateAccessibilityEvent(view, accessibilityEvent);
                }

                @Override
                public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
                    accessibilityDelegateCompat.onInitializeAccessibilityEvent(view, accessibilityEvent);
                }

                @Override
                public void onInitializeAccessibilityNodeInfo(View view, Object object) {
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat;
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                    accessibilityNodeInfoCompat = new AccessibilityNodeInfoCompat(object);
                    accessibilityNodeInfoCompat2.accessibilityDelegateCompat.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat2);
                }

                @Override
                public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
                    accessibilityDelegateCompat.onPopulateAccessibilityEvent(view, accessibilityEvent);
                }

                @Override
                public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
                    return accessibilityDelegateCompat.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
                }

                @Override
                public void sendAccessibilityEvent(View view, int n2) {
                    accessibilityDelegateCompat.sendAccessibilityEvent(view, n2);
                }

                @Override
                public void sendAccessibilityEventUnchecked(View view, AccessibilityEvent accessibilityEvent) {
                    accessibilityDelegateCompat.sendAccessibilityEventUnchecked(view, accessibilityEvent);
                }
            });
        }

        @Override
        public boolean dispatchPopulateAccessibilityEvent(Object object, View view, AccessibilityEvent accessibilityEvent) {
            return AccessibilityDelegateCompatIcs.dispatchPopulateAccessibilityEvent(object, view, accessibilityEvent);
        }

        @Override
        public void onInitializeAccessibilityEvent(Object object, View view, AccessibilityEvent accessibilityEvent) {
            AccessibilityDelegateCompatIcs.onInitializeAccessibilityEvent(object, view, accessibilityEvent);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(Object object, View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            AccessibilityDelegateCompatIcs.onInitializeAccessibilityNodeInfo(object, view, accessibilityNodeInfoCompat.getInfo());
        }

        @Override
        public void onPopulateAccessibilityEvent(Object object, View view, AccessibilityEvent accessibilityEvent) {
            AccessibilityDelegateCompatIcs.onPopulateAccessibilityEvent(object, view, accessibilityEvent);
        }

        @Override
        public boolean onRequestSendAccessibilityEvent(Object object, ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            return AccessibilityDelegateCompatIcs.onRequestSendAccessibilityEvent(object, viewGroup, view, accessibilityEvent);
        }

        @Override
        public void sendAccessibilityEvent(Object object, View view, int n2) {
            AccessibilityDelegateCompatIcs.sendAccessibilityEvent(object, view, n2);
        }

        @Override
        public void sendAccessibilityEventUnchecked(Object object, View view, AccessibilityEvent accessibilityEvent) {
            AccessibilityDelegateCompatIcs.sendAccessibilityEventUnchecked(object, view, accessibilityEvent);
        }
    }

    static interface AccessibilityDelegateImpl {
        public Object newAccessiblityDelegateDefaultImpl();

        public Object newAccessiblityDelegateBridge(AccessibilityDelegateCompat var1);

        public boolean dispatchPopulateAccessibilityEvent(Object var1, View var2, AccessibilityEvent var3);

        public void onInitializeAccessibilityEvent(Object var1, View var2, AccessibilityEvent var3);

        public void onInitializeAccessibilityNodeInfo(Object var1, View var2, AccessibilityNodeInfoCompat var3);

        public void onPopulateAccessibilityEvent(Object var1, View var2, AccessibilityEvent var3);

        public boolean onRequestSendAccessibilityEvent(Object var1, ViewGroup var2, View var3, AccessibilityEvent var4);

        public void sendAccessibilityEvent(Object var1, View var2, int var3);

        public void sendAccessibilityEventUnchecked(Object var1, View var2, AccessibilityEvent var3);

        public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(Object var1, View var2);

        public boolean performAccessibilityAction(Object var1, View var2, int var3, Bundle var4);
    }

    static class AccessibilityDelegateJellyBeanImpl
    extends AccessibilityDelegateIcsImpl {
        AccessibilityDelegateJellyBeanImpl() {
        }

        @Override
        public Object newAccessiblityDelegateBridge(final AccessibilityDelegateCompat accessibilityDelegateCompat) {
            return AccessibilityDelegateCompatJellyBean.newAccessibilityDelegateBridge(new AccessibilityDelegateCompatJellyBean.AccessibilityDelegateBridgeJellyBean(){

                @Override
                public boolean dispatchPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
                    return accessibilityDelegateCompat.dispatchPopulateAccessibilityEvent(view, accessibilityEvent);
                }

                @Override
                public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
                    accessibilityDelegateCompat.onInitializeAccessibilityEvent(view, accessibilityEvent);
                }

                @Override
                public void onInitializeAccessibilityNodeInfo(View view, Object object) {
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat;
                    AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
                    accessibilityNodeInfoCompat = new AccessibilityNodeInfoCompat(object);
                    accessibilityNodeInfoCompat2.accessibilityDelegateCompat.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat2);
                }

                @Override
                public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
                    accessibilityDelegateCompat.onPopulateAccessibilityEvent(view, accessibilityEvent);
                }

                @Override
                public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
                    return accessibilityDelegateCompat.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
                }

                @Override
                public void sendAccessibilityEvent(View view, int n2) {
                    accessibilityDelegateCompat.sendAccessibilityEvent(view, n2);
                }

                @Override
                public void sendAccessibilityEventUnchecked(View view, AccessibilityEvent accessibilityEvent) {
                    accessibilityDelegateCompat.sendAccessibilityEventUnchecked(view, accessibilityEvent);
                }

                @Override
                public Object getAccessibilityNodeProvider(View view) {
                    AccessibilityNodeProviderCompat accessibilityNodeProviderCompat = accessibilityNodeProviderCompat.accessibilityDelegateCompat.getAccessibilityNodeProvider(view);
                    return accessibilityNodeProviderCompat != null ? accessibilityNodeProviderCompat.getProvider() : null;
                }

                @Override
                public boolean performAccessibilityAction(View view, int n2, Bundle bundle) {
                    return accessibilityDelegateCompat.performAccessibilityAction(view, n2, bundle);
                }
            });
        }

        @Override
        public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(Object object, View view) {
            Object object2 = AccessibilityDelegateCompatJellyBean.getAccessibilityNodeProvider(object, view);
            if (object2 != null) {
                return new AccessibilityNodeProviderCompat(object2);
            }
            return null;
        }

        @Override
        public boolean performAccessibilityAction(Object object, View view, int n2, Bundle bundle) {
            return AccessibilityDelegateCompatJellyBean.performAccessibilityAction(object, view, n2, bundle);
        }
    }

    static class AccessibilityDelegateStubImpl
    implements AccessibilityDelegateImpl {
        AccessibilityDelegateStubImpl() {
        }

        @Override
        public Object newAccessiblityDelegateDefaultImpl() {
            return null;
        }

        @Override
        public Object newAccessiblityDelegateBridge(AccessibilityDelegateCompat accessibilityDelegateCompat) {
            return null;
        }

        @Override
        public boolean dispatchPopulateAccessibilityEvent(Object object, View view, AccessibilityEvent accessibilityEvent) {
            return false;
        }

        @Override
        public void onInitializeAccessibilityEvent(Object object, View view, AccessibilityEvent accessibilityEvent) {
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(Object object, View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
        }

        @Override
        public void onPopulateAccessibilityEvent(Object object, View view, AccessibilityEvent accessibilityEvent) {
        }

        @Override
        public boolean onRequestSendAccessibilityEvent(Object object, ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            return true;
        }

        @Override
        public void sendAccessibilityEvent(Object object, View view, int n2) {
        }

        @Override
        public void sendAccessibilityEventUnchecked(Object object, View view, AccessibilityEvent accessibilityEvent) {
        }

        @Override
        public AccessibilityNodeProviderCompat getAccessibilityNodeProvider(Object object, View view) {
            return null;
        }

        @Override
        public boolean performAccessibilityAction(Object object, View view, int n2, Bundle bundle) {
            return false;
        }
    }
}

