/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.support.v4.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.google.android.support.v4.view.PagerTitleStrip;
import com.google.android.support.v4.view.ViewPager;

public class PagerTabStrip
extends PagerTitleStrip {
    private static final String TAG = "PagerTabStrip";
    private static final int INDICATOR_HEIGHT = 3;
    private static final int MIN_PADDING_BOTTOM = 6;
    private static final int TAB_PADDING = 16;
    private static final int TAB_SPACING = 32;
    private static final int MIN_TEXT_SPACING = 64;
    private static final int FULL_UNDERLINE_HEIGHT = 1;
    private static final int MIN_STRIP_HEIGHT = 32;
    private int mIndicatorColor;
    private int mIndicatorHeight;
    private int mMinPaddingBottom;
    private int mMinTextSpacing;
    private int mMinStripHeight;
    private int mTabPadding;
    private final Paint mTabPaint;
    private final Rect mTempRect;
    private int mTabAlpha;
    private boolean mDrawFullUnderline;
    private boolean mDrawFullUnderlineSet;
    private int mFullUnderlineHeight;
    private boolean mIgnoreTap;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private int mTouchSlop;

    public PagerTabStrip(Context context) {
        this(context, null);
    }

    public PagerTabStrip(Context context, AttributeSet attributeSet) {
        int n2;
        PagerTabStrip pagerTabStrip = this;
        PagerTabStrip pagerTabStrip2 = this;
        super(context, attributeSet);
        pagerTabStrip2.mTabPaint = new Paint();
        pagerTabStrip2.mTempRect = new Rect();
        pagerTabStrip2.mTabAlpha = 255;
        pagerTabStrip2.mDrawFullUnderline = false;
        pagerTabStrip2.mDrawFullUnderlineSet = false;
        pagerTabStrip2.mIndicatorColor = n2 = pagerTabStrip2.mTextColor;
        pagerTabStrip2.mTabPaint.setColor(n2);
        float f3 = context.getResources().getDisplayMetrics().density;
        this.mIndicatorHeight = (int)(f3 * 3.0f + 0.5f);
        this.mMinPaddingBottom = (int)(f3 * 6.0f + 0.5f);
        this.mMinTextSpacing = (int)(f3 * 64.0f);
        this.mTabPadding = (int)(f3 * 16.0f + 0.5f);
        this.mFullUnderlineHeight = (int)(f3 * 1.0f + 0.5f);
        this.mMinStripHeight = (int)(f3 * 32.0f + 0.5f);
        pagerTabStrip.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        int n3 = pagerTabStrip.getPaddingLeft();
        int n4 = pagerTabStrip.getPaddingTop();
        int n5 = pagerTabStrip.getPaddingRight();
        int n6 = pagerTabStrip.getPaddingBottom();
        pagerTabStrip.setPadding(n3, n4, n5, n6);
        pagerTabStrip.setTextSpacing(pagerTabStrip.getTextSpacing());
        pagerTabStrip.setWillNotDraw(false);
        pagerTabStrip.mPrevText.setFocusable(true);
        pagerTabStrip.mPrevText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ViewPager viewPager = PagerTabStrip.this.mPager;
                viewPager.setCurrentItem(viewPager.getCurrentItem() - 1);
            }
        });
        pagerTabStrip.mNextText.setFocusable(true);
        pagerTabStrip.mNextText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ViewPager viewPager = PagerTabStrip.this.mPager;
                viewPager.setCurrentItem(viewPager.getCurrentItem() + 1);
            }
        });
        if (pagerTabStrip.getBackground() == null) {
            this.mDrawFullUnderline = true;
        }
    }

    public void setTabIndicatorColor(int n2) {
        PagerTabStrip pagerTabStrip = this;
        pagerTabStrip.mIndicatorColor = n2;
        pagerTabStrip.mTabPaint.setColor(n2);
        pagerTabStrip.invalidate();
    }

    public void setTabIndicatorColorResource(int n2) {
        PagerTabStrip pagerTabStrip = this;
        pagerTabStrip.setTabIndicatorColor(pagerTabStrip.getContext().getResources().getColor(n2));
    }

    public int getTabIndicatorColor() {
        return this.mIndicatorColor;
    }

    public void setPadding(int n2, int n3, int n4, int n5) {
        int n6 = this.mMinPaddingBottom;
        if (n5 >= n6) {
            n6 = n5;
        }
        super.setPadding(n2, n3, n4, n6);
    }

    @Override
    public void setTextSpacing(int n2) {
        int n3 = this.mMinTextSpacing;
        if (n2 >= n3) {
            n3 = n2;
        }
        super.setTextSpacing(n3);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        PagerTabStrip pagerTabStrip = this;
        super.setBackgroundDrawable(drawable2);
        if (!pagerTabStrip.mDrawFullUnderlineSet) {
            boolean bl = drawable2 == null;
            this.mDrawFullUnderline = bl;
        }
    }

    public void setBackgroundColor(int n2) {
        PagerTabStrip pagerTabStrip = this;
        super.setBackgroundColor(n2);
        if (!pagerTabStrip.mDrawFullUnderlineSet) {
            n2 = (n2 & 0xFF000000) == 0 ? 1 : 0;
            this.mDrawFullUnderline = n2;
        }
    }

    public void setBackgroundResource(int n2) {
        PagerTabStrip pagerTabStrip = this;
        super.setBackgroundResource(n2);
        if (!pagerTabStrip.mDrawFullUnderlineSet) {
            n2 = n2 == 0 ? 1 : 0;
            this.mDrawFullUnderline = n2;
        }
    }

    public void setDrawFullUnderline(boolean bl) {
        this.mDrawFullUnderline = bl;
        this.mDrawFullUnderlineSet = true;
        this.invalidate();
    }

    public boolean getDrawFullUnderline() {
        return this.mDrawFullUnderline;
    }

    @Override
    int getMinHeight() {
        return Math.max(super.getMinHeight(), this.mMinStripHeight);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction();
        if (n2 != 0 && this.mIgnoreTap) {
            return false;
        }
        MotionEvent motionEvent2 = motionEvent;
        float f3 = motionEvent2.getX();
        float f4 = motionEvent2.getY();
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2 && (Math.abs(f3 - this.mInitialMotionX) > (float)this.mTouchSlop || Math.abs(f4 - this.mInitialMotionY) > (float)this.mTouchSlop)) {
                    this.mIgnoreTap = true;
                }
            } else if (f3 < (float)(this.mCurrText.getLeft() - this.mTabPadding)) {
                ViewPager viewPager = this.mPager;
                viewPager.setCurrentItem(viewPager.getCurrentItem() - 1);
            } else if (f3 > (float)(this.mCurrText.getRight() + this.mTabPadding)) {
                ViewPager viewPager = this.mPager;
                viewPager.setCurrentItem(viewPager.getCurrentItem() + 1);
            }
        } else {
            PagerTabStrip pagerTabStrip = this;
            pagerTabStrip.mInitialMotionX = f3;
            pagerTabStrip.mInitialMotionY = f4;
            pagerTabStrip.mIgnoreTap = false;
        }
        return true;
    }

    protected void onDraw(Canvas canvas) {
        PagerTabStrip pagerTabStrip = this;
        super.onDraw(canvas);
        int n2 = pagerTabStrip.getHeight();
        PagerTabStrip pagerTabStrip2 = this;
        int n3 = pagerTabStrip2.mCurrText.getLeft() - this.mTabPadding;
        int n4 = pagerTabStrip2.mCurrText.getRight() + this.mTabPadding;
        this.mTabPaint.setColor(this.mTabAlpha << 24 | this.mIndicatorColor & 0xFFFFFF);
        float f3 = n3;
        float f4 = n2 - this.mIndicatorHeight;
        float f5 = n4;
        float f6 = n2;
        Paint paint = pagerTabStrip.mTabPaint;
        canvas.drawRect(f3, f4, f5, f6, paint);
        if (this.mDrawFullUnderline) {
            PagerTabStrip pagerTabStrip3 = this;
            PagerTabStrip pagerTabStrip4 = this;
            pagerTabStrip4.mTabPaint.setColor(this.mIndicatorColor & 0xFFFFFF | 0xFF000000);
            float f7 = pagerTabStrip4.getPaddingLeft();
            float f8 = n2 - pagerTabStrip4.mFullUnderlineHeight;
            float f9 = pagerTabStrip3.getWidth() - this.getPaddingRight();
            Paint paint2 = pagerTabStrip3.mTabPaint;
            canvas.drawRect(f7, f8, f9, f6, paint2);
        }
    }

    @Override
    void updateTextPositions(int n2, float f3, boolean bl) {
        PagerTabStrip pagerTabStrip = this;
        Rect n5 = pagerTabStrip.mTempRect;
        int n3 = n2;
        n2 = this.getHeight();
        PagerTabStrip pagerTabStrip2 = this;
        int n4 = pagerTabStrip2.mCurrText.getLeft() - this.mTabPadding;
        int n6 = pagerTabStrip2.mCurrText.getRight() + this.mTabPadding;
        int n7 = n2 - pagerTabStrip2.mIndicatorHeight;
        n5.set(n4, n7, n6, n2);
        super.updateTextPositions(n3, f3, bl);
        this.mTabAlpha = (int)(Math.abs(f3 - 0.5f) * 2.0f * 255.0f);
        n5.union(this.mCurrText.getLeft() - this.mTabPadding, n7, this.mCurrText.getRight() + this.mTabPadding, n2);
        pagerTabStrip.invalidate(n5);
    }
}

