/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.support.v4.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.google.android.support.v4.view.PagerAdapter;
import com.google.android.support.v4.view.PagerTitleStripIcs;
import com.google.android.support.v4.view.ViewPager;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;

public class PagerTitleStrip
extends ViewGroup
implements ViewPager.Decor {
    private static final String TAG = "PagerTitleStrip";
    private static final int[] ATTRS = new int[]{16842804, 16842901, 16842904, 16842927};
    private static final int[] TEXT_ATTRS = new int[]{16843660};
    private static final float SIDE_ALPHA = 0.6f;
    private static final int TEXT_SPACING = 16;
    private static final PagerTitleStripImpl IMPL = Build.VERSION.SDK_INT >= 14 ? new PagerTitleStripImplIcs() : new PagerTitleStripImplBase();
    ViewPager mPager;
    TextView mPrevText;
    TextView mCurrText;
    TextView mNextText;
    private int mLastKnownCurrentPage;
    private float mLastKnownPositionOffset;
    private int mScaledTextSpacing;
    private int mGravity;
    private boolean mUpdatingText;
    private boolean mUpdatingPositions;
    private final PageListener mPageListener;
    private WeakReference<PagerAdapter> mWatchingAdapter;
    private int mNonPrimaryAlpha;
    int mTextColor;

    private static void setSingleLineAllCaps(TextView textView) {
        IMPL.setSingleLineAllCaps(textView);
    }

    public PagerTitleStrip(Context context) {
        this(context, null);
    }

    public PagerTitleStrip(Context context, AttributeSet attributeSet) {
        int n2;
        TextView textView;
        TextView textView2;
        TextView textView3;
        PageListener pageListener;
        PagerTitleStrip pagerTitleStrip = this;
        super(context, attributeSet);
        pagerTitleStrip.mLastKnownCurrentPage = -1;
        pagerTitleStrip.mLastKnownPositionOffset = -1.0f;
        PageListener pageListener2 = pageListener;
        pageListener = new PageListener();
        pagerTitleStrip.mPageListener = pageListener2;
        pageListener2 = textView3;
        textView3 = new TextView(context);
        pagerTitleStrip.mPrevText = pageListener2;
        pagerTitleStrip.addView((View)pageListener2);
        pageListener2 = textView2;
        textView2 = new TextView(context);
        pagerTitleStrip.mCurrText = pageListener2;
        pagerTitleStrip.addView((View)pageListener2);
        pageListener2 = textView;
        textView = new TextView(context);
        pagerTitleStrip.mNextText = pageListener2;
        pagerTitleStrip.addView((View)pageListener2);
        attributeSet = context.obtainStyledAttributes(attributeSet, ATTRS);
        int n3 = attributeSet.getResourceId(0, 0);
        if (n3 != 0) {
            PagerTitleStrip pagerTitleStrip2 = this;
            pagerTitleStrip2.mPrevText.setTextAppearance(context, n3);
            pagerTitleStrip2.mCurrText.setTextAppearance(context, n3);
            pagerTitleStrip2.mNextText.setTextAppearance(context, n3);
        }
        if ((n2 = attributeSet.getDimensionPixelSize(1, 0)) != 0) {
            this.setTextSize(0, n2);
        }
        if (attributeSet.hasValue(2)) {
            PagerTitleStrip pagerTitleStrip3 = this;
            n2 = attributeSet.getColor(2, 0);
            pagerTitleStrip3.mPrevText.setTextColor(n2);
            pagerTitleStrip3.mCurrText.setTextColor(n2);
            pagerTitleStrip3.mNextText.setTextColor(n2);
        }
        PagerTitleStrip pagerTitleStrip4 = this;
        this.mGravity = attributeSet.getInteger(3, 80);
        attributeSet.recycle();
        pagerTitleStrip4.mTextColor = pagerTitleStrip4.mCurrText.getTextColors().getDefaultColor();
        pagerTitleStrip4.setNonPrimaryAlpha(0.6f);
        pagerTitleStrip4.mPrevText.setEllipsize(TextUtils.TruncateAt.END);
        pagerTitleStrip4.mCurrText.setEllipsize(TextUtils.TruncateAt.END);
        pagerTitleStrip4.mNextText.setEllipsize(TextUtils.TruncateAt.END);
        boolean bl = false;
        if (n3 != 0) {
            TypedArray typedArray = context.obtainStyledAttributes(n3, TEXT_ATTRS);
            bl = typedArray.getBoolean(0, false);
            typedArray.recycle();
        }
        if (bl) {
            PagerTitleStrip pagerTitleStrip5 = this;
            PagerTitleStrip.setSingleLineAllCaps(pagerTitleStrip5.mPrevText);
            PagerTitleStrip.setSingleLineAllCaps(pagerTitleStrip5.mCurrText);
            PagerTitleStrip.setSingleLineAllCaps(pagerTitleStrip5.mNextText);
        } else {
            PagerTitleStrip pagerTitleStrip6 = this;
            pagerTitleStrip6.mPrevText.setSingleLine();
            pagerTitleStrip6.mCurrText.setSingleLine();
            pagerTitleStrip6.mNextText.setSingleLine();
        }
        this.mScaledTextSpacing = (int)(context.getResources().getDisplayMetrics().density * 16.0f);
    }

    public void setTextSpacing(int n2) {
        this.mScaledTextSpacing = n2;
        this.requestLayout();
    }

    public int getTextSpacing() {
        return this.mScaledTextSpacing;
    }

    public void setNonPrimaryAlpha(float f3) {
        PagerTitleStrip pagerTitleStrip = this;
        this.mNonPrimaryAlpha = (int)(f3 * 255.0f) & 0xFF;
        int n2 = this.mNonPrimaryAlpha << 24 | this.mTextColor & 0xFFFFFF;
        pagerTitleStrip.mPrevText.setTextColor(n2);
        pagerTitleStrip.mNextText.setTextColor(n2);
    }

    public void setTextColor(int n2) {
        PagerTitleStrip pagerTitleStrip = this;
        pagerTitleStrip.mTextColor = n2;
        pagerTitleStrip.mCurrText.setTextColor(n2);
        int n3 = pagerTitleStrip.mNonPrimaryAlpha << 24 | this.mTextColor & 0xFFFFFF;
        pagerTitleStrip.mPrevText.setTextColor(n3);
        pagerTitleStrip.mNextText.setTextColor(n3);
    }

    public void setTextSize(int n2, float f3) {
        PagerTitleStrip pagerTitleStrip = this;
        pagerTitleStrip.mPrevText.setTextSize(n2, f3);
        pagerTitleStrip.mCurrText.setTextSize(n2, f3);
        pagerTitleStrip.mNextText.setTextSize(n2, f3);
    }

    public void setGravity(int n2) {
        this.mGravity = n2;
        this.requestLayout();
    }

    protected void onAttachedToWindow() {
        PagerTitleStrip pagerTitleStrip = this;
        super.onAttachedToWindow();
        Object object = pagerTitleStrip.getParent();
        if (object instanceof ViewPager) {
            ViewPager viewPager = (ViewPager)((Object)object);
            Object object2 = object = viewPager;
            object = ((ViewPager)((Object)object)).getAdapter();
            ((ViewPager)((Object)object2)).setInternalPageChangeListener(this.mPageListener);
            viewPager.setOnAdapterChangeListener(this.mPageListener);
            this.mPager = viewPager;
            Object object3 = this.mWatchingAdapter;
            object3 = object3 != null ? (PagerAdapter)((Reference)object3).get() : null;
            this.updateAdapter((PagerAdapter)object3, (PagerAdapter)object);
            return;
        }
        throw new IllegalStateException("PagerTitleStrip must be a direct child of a ViewPager.");
    }

    protected void onDetachedFromWindow() {
        PagerTitleStrip pagerTitleStrip = this;
        super.onDetachedFromWindow();
        ViewPager viewPager = pagerTitleStrip.mPager;
        if (viewPager != null) {
            PagerTitleStrip pagerTitleStrip2 = this;
            pagerTitleStrip2.updateAdapter(viewPager.getAdapter(), null);
            pagerTitleStrip2.mPager.setInternalPageChangeListener(null);
            pagerTitleStrip2.mPager.setOnAdapterChangeListener(null);
            pagerTitleStrip2.mPager = null;
        }
    }

    void updateText(int n2, PagerAdapter pagerAdapter) {
        int n3 = pagerAdapter != null ? pagerAdapter.getCount() : 0;
        this.mUpdatingText = true;
        CharSequence charSequence = null;
        if (n2 >= 1 && pagerAdapter != null) {
            charSequence = pagerAdapter.getPageTitle(n2 - 1);
        }
        PagerTitleStrip pagerTitleStrip = this;
        pagerTitleStrip.mPrevText.setText(charSequence);
        charSequence = pagerTitleStrip.mCurrText;
        CharSequence charSequence2 = pagerAdapter != null && n2 < n3 ? pagerAdapter.getPageTitle(n2) : null;
        charSequence.setText(charSequence2);
        charSequence = null;
        int n4 = n2 + 1;
        if (n4 < n3 && pagerAdapter != null) {
            charSequence = pagerAdapter.getPageTitle(n4);
        }
        PagerTitleStrip pagerTitleStrip2 = this;
        pagerTitleStrip2.mNextText.setText(charSequence);
        int n5 = pagerTitleStrip2.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
        n5 = View.MeasureSpec.makeMeasureSpec((int)((int)((float)n5 * 0.8f)), (int)Integer.MIN_VALUE);
        n3 = View.MeasureSpec.makeMeasureSpec((int)(pagerTitleStrip2.getHeight() - this.getPaddingTop() - this.getPaddingBottom()), (int)Integer.MIN_VALUE);
        pagerTitleStrip2.mPrevText.measure(n5, n3);
        pagerTitleStrip2.mCurrText.measure(n5, n3);
        pagerTitleStrip2.mNextText.measure(n5, n3);
        this.mLastKnownCurrentPage = n2;
        if (!this.mUpdatingPositions) {
            PagerTitleStrip pagerTitleStrip3 = this;
            pagerTitleStrip3.updateTextPositions(n2, pagerTitleStrip3.mLastKnownPositionOffset, false);
        }
        this.mUpdatingText = false;
    }

    public void requestLayout() {
        if (!this.mUpdatingText) {
            super.requestLayout();
        }
    }

    void updateAdapter(PagerAdapter object, PagerAdapter pagerAdapter) {
        if (object != null) {
            ((PagerAdapter)object).unregisterDataSetObserver(this.mPageListener);
            this.mWatchingAdapter = null;
        }
        if (pagerAdapter != null) {
            pagerAdapter.registerDataSetObserver(this.mPageListener);
            this.mWatchingAdapter = new WeakReference<PagerAdapter>(pagerAdapter);
        }
        if ((object = this.mPager) != null) {
            PagerTitleStrip pagerTitleStrip = this;
            PagerTitleStrip pagerTitleStrip2 = this;
            pagerTitleStrip2.mLastKnownCurrentPage = -1;
            pagerTitleStrip2.mLastKnownPositionOffset = -1.0f;
            pagerTitleStrip.updateText(((ViewPager)((Object)object)).getCurrentItem(), pagerAdapter);
            pagerTitleStrip.requestLayout();
        }
    }

    void updateTextPositions(int n2, float f3, boolean bl) {
        float f4;
        if (n2 != this.mLastKnownCurrentPage) {
            this.updateText(n2, this.mPager.getAdapter());
        } else if (!bl && f3 == this.mLastKnownPositionOffset) {
            return;
        }
        PagerTitleStrip pagerTitleStrip = this;
        pagerTitleStrip.mUpdatingPositions = true;
        n2 = pagerTitleStrip.mPrevText.getMeasuredWidth();
        int n3 = pagerTitleStrip.mCurrText.getMeasuredWidth();
        int n4 = this.mNextText.getMeasuredWidth();
        int n5 = n3 / 2;
        int n6 = pagerTitleStrip.getWidth();
        PagerTitleStrip pagerTitleStrip2 = this;
        int n7 = pagerTitleStrip2.getHeight();
        int n8 = pagerTitleStrip2.getPaddingLeft();
        int n9 = pagerTitleStrip2.getPaddingRight();
        PagerTitleStrip pagerTitleStrip3 = this;
        int n10 = pagerTitleStrip3.getPaddingTop();
        int n11 = pagerTitleStrip3.getPaddingBottom();
        int n12 = n8 + n5;
        int n13 = n9 + n5;
        n12 = n6 - n12 - n13;
        float f5 = f3 + 0.5f;
        if (f4 > 1.0f) {
            f5 -= 1.0f;
        }
        PagerTitleStrip pagerTitleStrip4 = this;
        n5 = n6 - n13 - (int)((float)n12 * f5) - n5;
        int n14 = n5 + n3;
        n12 = pagerTitleStrip4.mPrevText.getBaseline();
        n13 = this.mCurrText.getBaseline();
        int n15 = this.mNextText.getBaseline();
        int n16 = Math.max(Math.max(n12, n13), n15);
        n12 = n16 - n12;
        n13 = n16 - n13;
        n15 = n16 - n15;
        n16 = n13 + this.mCurrText.getMeasuredHeight();
        int n17 = n15 + this.mNextText.getMeasuredHeight();
        n16 = Math.max(Math.max(n12 + this.mPrevText.getMeasuredHeight(), n16), n17);
        n17 = pagerTitleStrip4.mGravity & 0x70;
        if (n17 != 16) {
            if (n17 != 80) {
                int n18 = n10;
                n7 = n18 + n12;
                n10 = n18 + n13;
                n11 = n18 + n15;
            } else {
                int n19 = n7 - n11 - n16;
                int n20 = n7 = n19;
                n7 += n12;
                n10 = n20 + n13;
                n11 = n19 + n15;
            }
        } else {
            int n21 = (n7 - n10 - n11 - n16) / 2;
            int n22 = n7 = n21;
            n7 += n12;
            n10 = n22 + n13;
            n11 = n21 + n15;
        }
        PagerTitleStrip pagerTitleStrip5 = this;
        PagerTitleStrip pagerTitleStrip6 = this;
        TextView textView = pagerTitleStrip6.mCurrText;
        int n21 = n10 + textView.getMeasuredHeight();
        textView.layout(n5, n10, n14, n21);
        n21 = Math.min(n8, n5 - pagerTitleStrip6.mScaledTextSpacing - n2);
        TextView textView2 = this.mPrevText;
        int n23 = n21;
        n2 = n21 + n2;
        n21 = n7 + textView2.getMeasuredHeight();
        textView2.layout(n23, n7, n2, n21);
        int n232 = Math.max(n6 - n9 - n4, n14 + this.mScaledTextSpacing);
        TextView textView3 = this.mNextText;
        int n24 = n11 + textView3.getMeasuredHeight();
        textView3.layout(n232, n11, n232 += n4, n24);
        pagerTitleStrip5.mLastKnownPositionOffset = f3;
        pagerTitleStrip5.mUpdatingPositions = false;
    }

    protected void onMeasure(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = n3;
        int n6 = n2;
        n2 = View.MeasureSpec.getMode((int)n3);
        n3 = View.MeasureSpec.getSize((int)n6);
        int n7 = View.MeasureSpec.getSize((int)n5);
        if (n4 == 0x40000000) {
            int n8 = n2;
            PagerTitleStrip pagerTitleStrip = this;
            PagerTitleStrip pagerTitleStrip2 = this;
            n2 = pagerTitleStrip2.getMinHeight();
            int n9 = pagerTitleStrip2.getPaddingTop() + this.getPaddingBottom();
            int n10 = View.MeasureSpec.makeMeasureSpec((int)((int)((float)n3 * 0.8f)), (int)Integer.MIN_VALUE);
            int n11 = View.MeasureSpec.makeMeasureSpec((int)(n7 - n9), (int)Integer.MIN_VALUE);
            pagerTitleStrip.mPrevText.measure(n10, n11);
            pagerTitleStrip.mCurrText.measure(n10, n11);
            pagerTitleStrip.mNextText.measure(n10, n11);
            if (n8 == 0x40000000) {
                this.setMeasuredDimension(n3, n7);
            } else {
                this.setMeasuredDimension(n3, Math.max(n2, this.mCurrText.getMeasuredHeight() + n9));
            }
            return;
        }
        throw new IllegalStateException("Must measure with an exact width");
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        if (this.mPager != null) {
            float f3;
            float f4 = this.mLastKnownPositionOffset;
            if (!(f3 >= 0.0f)) {
                f4 = 0.0f;
            }
            PagerTitleStrip pagerTitleStrip = this;
            pagerTitleStrip.updateTextPositions(pagerTitleStrip.mLastKnownCurrentPage, f4, true);
        }
    }

    int getMinHeight() {
        int n2 = 0;
        Drawable drawable2 = this.getBackground();
        if (drawable2 != null) {
            n2 = drawable2.getIntrinsicHeight();
        }
        return n2;
    }

    private class PageListener
    extends DataSetObserver
    implements ViewPager.OnPageChangeListener,
    ViewPager.OnAdapterChangeListener {
        private int mScrollState;

        private PageListener() {
        }

        @Override
        public void onPageScrolled(int n2, float f3, int n3) {
            if (f3 > 0.5f) {
                ++n2;
            }
            PagerTitleStrip.this.updateTextPositions(n2, f3, false);
        }

        @Override
        public void onPageSelected(int n2) {
            if (this.mScrollState == 0) {
                PageListener pageListener = this;
                PagerTitleStrip pagerTitleStrip = pageListener.PagerTitleStrip.this;
                pagerTitleStrip.updateText(pagerTitleStrip.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
                float f3 = pageListener.PagerTitleStrip.this.mLastKnownPositionOffset >= 0.0f ? PagerTitleStrip.this.mLastKnownPositionOffset : 0.0f;
                PagerTitleStrip pagerTitleStrip2 = PagerTitleStrip.this;
                pagerTitleStrip2.updateTextPositions(pagerTitleStrip2.mPager.getCurrentItem(), f3, true);
            }
        }

        @Override
        public void onPageScrollStateChanged(int n2) {
            this.mScrollState = n2;
        }

        @Override
        public void onAdapterChanged(PagerAdapter pagerAdapter, PagerAdapter pagerAdapter2) {
            PagerTitleStrip.this.updateAdapter(pagerAdapter, pagerAdapter2);
        }

        public void onChanged() {
            PageListener pageListener = this;
            PagerTitleStrip pagerTitleStrip = pageListener.PagerTitleStrip.this;
            pagerTitleStrip.updateText(pagerTitleStrip.mPager.getCurrentItem(), PagerTitleStrip.this.mPager.getAdapter());
            float f3 = pageListener.PagerTitleStrip.this.mLastKnownPositionOffset >= 0.0f ? PagerTitleStrip.this.mLastKnownPositionOffset : 0.0f;
            PagerTitleStrip pagerTitleStrip2 = PagerTitleStrip.this;
            pagerTitleStrip2.updateTextPositions(pagerTitleStrip2.mPager.getCurrentItem(), f3, true);
        }
    }

    static interface PagerTitleStripImpl {
        public void setSingleLineAllCaps(TextView var1);
    }

    static class PagerTitleStripImplBase
    implements PagerTitleStripImpl {
        PagerTitleStripImplBase() {
        }

        @Override
        public void setSingleLineAllCaps(TextView textView) {
            textView.setSingleLine();
        }
    }

    static class PagerTitleStripImplIcs
    implements PagerTitleStripImpl {
        PagerTitleStripImplIcs() {
        }

        @Override
        public void setSingleLineAllCaps(TextView textView) {
            PagerTitleStripIcs.setSingleLineAllCaps(textView);
        }
    }
}

