/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.support.v4.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.google.android.support.v4.os.ParcelableCompat;
import com.google.android.support.v4.os.ParcelableCompatCreatorCallbacks;
import com.google.android.support.v4.view.AccessibilityDelegateCompat;
import com.google.android.support.v4.view.KeyEventCompat;
import com.google.android.support.v4.view.MotionEventCompat;
import com.google.android.support.v4.view.PagerAdapter;
import com.google.android.support.v4.view.VelocityTrackerCompat;
import com.google.android.support.v4.view.ViewCompat;
import com.google.android.support.v4.view.ViewConfigurationCompat;
import com.google.android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.support.v4.view.accessibility.AccessibilityRecordCompat;
import com.google.android.support.v4.widget.EdgeEffectCompat;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ViewPager
extends ViewGroup {
    private static final String TAG = "ViewPager";
    private static final boolean DEBUG = false;
    private static final boolean USE_CACHE = false;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final int[] LAYOUT_ATTRS = new int[]{16842931};
    private static final Comparator<ItemInfo> COMPARATOR = new Comparator<ItemInfo>(){

        @Override
        public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
            return itemInfo.position - itemInfo2.position;
        }
    };
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float f3) {
            float f4 = f3 - 1.0f;
            return f4 * f4 * f4 * f4 * f4 + 1.0f;
        }
    };
    private static final int INVALID_POINTER = -1;
    private static final int CLOSE_ENOUGH = 2;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private static final ViewPositionComparator sPositionComparator = new ViewPositionComparator();
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private int mExpectedAdapterCount;
    private final ArrayList<ItemInfo> mItems;
    private final ItemInfo mTempItem;
    private final Rect mTempRect;
    private PagerAdapter mAdapter;
    private int mCurItem;
    private int mRestoredCurItem;
    private Parcelable mRestoredAdapterState;
    private ClassLoader mRestoredClassLoader;
    private Scroller mScroller;
    private PagerObserver mObserver;
    private int mPageMargin;
    private Drawable mMarginDrawable;
    private int mTopPageBounds;
    private int mBottomPageBounds;
    private float mFirstOffset;
    private float mLastOffset;
    private int mChildWidthMeasureSpec;
    private int mChildHeightMeasureSpec;
    private boolean mInLayout;
    private boolean mScrollingCacheEnabled;
    private boolean mPopulatePending;
    private int mOffscreenPageLimit;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private boolean mIgnoreGutter;
    private int mDefaultGutterSize;
    private int mGutterSize;
    private int mTouchSlop;
    private float mLastMotionX;
    private float mLastMotionY;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private int mActivePointerId;
    private VelocityTracker mVelocityTracker;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mFlingDistance;
    private int mCloseEnough;
    private boolean mFakeDragging;
    private long mFakeDragBeginTime;
    private EdgeEffectCompat mLeftEdge;
    private EdgeEffectCompat mRightEdge;
    private boolean mFirstLayout;
    private boolean mNeedCalculatePageOffsets;
    private boolean mCalledSuper;
    private int mDecorChildCount;
    private OnPageChangeListener mOnPageChangeListener;
    private OnPageChangeListener mInternalPageChangeListener;
    private OnAdapterChangeListener mAdapterChangeListener;
    private PageTransformer mPageTransformer;
    private Method mSetChildrenDrawingOrderEnabled;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private final Runnable mEndScrollRunnable;
    private int mScrollState;

    public ViewPager(Context object) {
        Runnable runnable;
        Rect rect;
        ItemInfo itemInfo;
        ArrayList arrayList;
        ViewPager viewPager = this;
        super(object);
        object = arrayList;
        arrayList = new ArrayList();
        viewPager.mItems = object;
        object = itemInfo;
        itemInfo = new ItemInfo();
        viewPager.mTempItem = object;
        object = rect;
        rect = new Rect();
        viewPager.mTempRect = object;
        viewPager.mRestoredCurItem = -1;
        viewPager.mRestoredAdapterState = null;
        viewPager.mRestoredClassLoader = null;
        viewPager.mFirstOffset = -3.4028235E38f;
        viewPager.mLastOffset = Float.MAX_VALUE;
        viewPager.mOffscreenPageLimit = 1;
        viewPager.mActivePointerId = -1;
        viewPager.mFirstLayout = true;
        viewPager.mNeedCalculatePageOffsets = false;
        object = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                3 v02 = this;
                v02.ViewPager.this.setScrollState(0);
                v02.ViewPager.this.populate();
            }
        };
        viewPager.mEndScrollRunnable = object;
        viewPager.mScrollState = 0;
        viewPager.initViewPager();
    }

    public ViewPager(Context object, AttributeSet attributeSet) {
        Runnable runnable;
        Rect rect;
        ItemInfo itemInfo;
        ArrayList arrayList;
        ViewPager viewPager = this;
        super(object, attributeSet);
        object = arrayList;
        arrayList = new ArrayList();
        viewPager.mItems = object;
        object = itemInfo;
        itemInfo = new ItemInfo();
        viewPager.mTempItem = object;
        object = rect;
        rect = new Rect();
        viewPager.mTempRect = object;
        viewPager.mRestoredCurItem = -1;
        viewPager.mRestoredAdapterState = null;
        viewPager.mRestoredClassLoader = null;
        viewPager.mFirstOffset = -3.4028235E38f;
        viewPager.mLastOffset = Float.MAX_VALUE;
        viewPager.mOffscreenPageLimit = 1;
        viewPager.mActivePointerId = -1;
        viewPager.mFirstLayout = true;
        viewPager.mNeedCalculatePageOffsets = false;
        object = runnable;
        runnable = new /* invalid duplicate definition of identical inner class */;
        viewPager.mEndScrollRunnable = object;
        viewPager.mScrollState = 0;
        viewPager.initViewPager();
    }

    private void setScrollState(int n2) {
        if (((ViewPager)((Object)this)).mScrollState == n2) {
            return;
        }
        ((ViewPager)((Object)this)).mScrollState = n2;
        if (((ViewPager)((Object)this)).mPageTransformer != null) {
            boolean bl = n2 != 0;
            ((ViewPager)((Object)this)).enableLayers(bl);
        }
        if ((this = ((ViewPager)((Object)this)).mOnPageChangeListener) != null) {
            this.onPageScrollStateChanged(n2);
        }
    }

    private void removeNonDecorViews() {
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            if (!((LayoutParams)this.getChildAt((int)n2).getLayoutParams()).isDecor) {
                this.removeViewAt(n2);
                --n2;
            }
            ++n2;
        }
        return;
    }

    private int getClientWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    private void scrollToItem(int n2, boolean bl, int n3, boolean bl2) {
        ItemInfo itemInfo = ((ViewPager)((Object)this)).infoForPosition(n2);
        int n4 = 0;
        if (itemInfo != null) {
            n4 = (int)((float)((ViewPager)((Object)this)).getClientWidth() * Math.max(((ViewPager)((Object)this)).mFirstOffset, Math.min(itemInfo.offset, ((ViewPager)((Object)this)).mLastOffset)));
        }
        if (bl) {
            OnPageChangeListener onPageChangeListener;
            ((ViewPager)((Object)this)).smoothScrollTo(n4, 0, n3);
            if (bl2 && (onPageChangeListener = ((ViewPager)((Object)this)).mOnPageChangeListener) != null) {
                onPageChangeListener.onPageSelected(n2);
            }
            if (bl2 && (this = ((ViewPager)((Object)this)).mInternalPageChangeListener) != null) {
                this.onPageSelected(n2);
            }
        } else {
            OnPageChangeListener onPageChangeListener;
            OnPageChangeListener onPageChangeListener2;
            if (bl2 && (onPageChangeListener2 = ((ViewPager)((Object)this)).mOnPageChangeListener) != null) {
                onPageChangeListener2.onPageSelected(n2);
            }
            if (bl2 && (onPageChangeListener = ((ViewPager)((Object)this)).mInternalPageChangeListener) != null) {
                onPageChangeListener.onPageSelected(n2);
            }
            ViewPager viewPager = this;
            viewPager.completeScroll(false);
            viewPager.scrollTo(n4, 0);
            viewPager.pageScrolled(n4);
        }
    }

    private void sortChildDrawingOrder() {
        if (this.mDrawingOrder != 0) {
            ArrayList arrayList = this.mDrawingOrderedChildren;
            if (arrayList == null) {
                ArrayList arrayList2;
                arrayList = arrayList2;
                arrayList2 = new ArrayList();
                this.mDrawingOrderedChildren = arrayList;
            } else {
                arrayList.clear();
            }
            int n2 = this.getChildCount();
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    Collections.sort(this.mDrawingOrderedChildren, sPositionComparator);
                    break;
                }
                ViewPager viewPager = this;
                View view = viewPager.getChildAt(n3);
                viewPager.mDrawingOrderedChildren.add(view);
                ++n3;
            }
        }
    }

    private void calculatePageOffsets(ItemInfo itemInfo, int n2, ItemInfo itemInfo2) {
        int n3;
        ViewPager viewPager = this;
        int n4 = viewPager.mAdapter.getCount();
        int n5 = viewPager.getClientWidth();
        float f3 = n5 > 0 ? (float)this.mPageMargin / (float)n5 : 0.0f;
        if (itemInfo2 != null) {
            ItemInfo itemInfo3;
            int n6 = itemInfo2.position;
            n3 = itemInfo.position;
            if (n6 < n3) {
                n3 = 0;
                float f4 = itemInfo2.offset + itemInfo2.widthFactor + f3;
                ++n6;
                block0: while (n6 <= itemInfo.position && n3 < this.mItems.size()) {
                    itemInfo3 = this.mItems.get(n3);
                    while (n6 > itemInfo3.position && n3 < this.mItems.size() - 1) {
                        itemInfo3 = this.mItems.get(++n3);
                    }
                    while (true) {
                        if (n6 >= itemInfo3.position) {
                            itemInfo3.offset = f4;
                            f4 += itemInfo3.widthFactor + f3;
                            ++n6;
                            continue block0;
                        }
                        f4 += this.mAdapter.getPageWidth(n6) + f3;
                        ++n6;
                    }
                }
            } else if (n6 > n3) {
                int n7 = this.mItems.size() - 1;
                float f5 = itemInfo2.offset;
                block3: for (n3 = n6 - 1; n3 >= itemInfo.position && n7 >= 0; --n3) {
                    itemInfo3 = this.mItems.get(n7);
                    while (n3 < itemInfo3.position && n7 > 0) {
                        itemInfo3 = this.mItems.get(--n7);
                    }
                    while (true) {
                        if (n3 <= itemInfo3.position) {
                            itemInfo3.offset = f5 -= itemInfo3.widthFactor + f3;
                            continue block3;
                        }
                        f5 -= this.mAdapter.getPageWidth(n3) + f3;
                        --n3;
                    }
                }
            }
        }
        ItemInfo itemInfo4 = itemInfo;
        int n8 = this.mItems.size();
        float f6 = itemInfo4.offset;
        int n9 = itemInfo4.position;
        n3 = n9 - 1;
        float f7 = n9 == 0 ? f6 : -3.4028235E38f;
        this.mFirstOffset = f7;
        f7 = itemInfo.position == --n4 ? itemInfo.offset + itemInfo.widthFactor - 1.0f : Float.MAX_VALUE;
        this.mLastOffset = f7;
        int n10 = n2 - 1;
        block6: while (true) {
            if (n10 < 0) {
                ItemInfo itemInfo5 = itemInfo;
                float f8 = itemInfo5.offset + itemInfo.widthFactor + f3;
                int n11 = itemInfo5.position + 1;
                int n12 = ++n2;
                block7: while (true) {
                    if (n12 >= n8) {
                        this.mNeedCalculatePageOffsets = false;
                        return;
                    }
                    ItemInfo itemInfo6 = this.mItems.get(n12);
                    while (true) {
                        if (n11 >= (n2 = itemInfo6.position)) {
                            if (n2 == n4) {
                                this.mLastOffset = f8 + itemInfo6.widthFactor - 1.0f;
                            }
                            itemInfo6.offset = f8;
                            f8 += itemInfo6.widthFactor + f3;
                            n2 = n12 + 1;
                            ++n11;
                            n12 = n2;
                            continue block7;
                        }
                        f8 += this.mAdapter.getPageWidth(n11++) + f3;
                    }
                    break;
                }
            }
            ItemInfo itemInfo7 = this.mItems.get(n10);
            while (true) {
                int n13;
                if (n3 <= (n13 = itemInfo7.position)) {
                    itemInfo7.offset = f6 -= itemInfo7.widthFactor + f3;
                    if (n13 == 0) {
                        this.mFirstOffset = f6;
                    }
                    --n10;
                    --n3;
                    continue block6;
                }
                int n14 = n3;
                n3 = n14 + -1;
                f6 -= this.mAdapter.getPageWidth(n14) + f3;
            }
            break;
        }
    }

    private void recomputeScrollPosition(int n2, int n3, int n4, int n5) {
        if (n3 > 0 && !this.mItems.isEmpty()) {
            ViewPager viewPager = this;
            int n6 = n3;
            n3 = n2 - this.getPaddingLeft() - this.getPaddingRight() + n4;
            n4 = n6 - this.getPaddingLeft() - this.getPaddingRight() + n5;
            n3 = (int)((float)viewPager.getScrollX() / (float)n4 * (float)n3);
            viewPager.scrollTo(n3, viewPager.getScrollY());
            if (!viewPager.mScroller.isFinished()) {
                ViewPager viewPager2 = this;
                int n7 = viewPager2.mScroller.getDuration() - this.mScroller.timePassed();
                ItemInfo itemInfo = viewPager2.infoForPosition(viewPager2.mCurItem);
                viewPager2.mScroller.startScroll(n3, 0, (int)(itemInfo.offset * (float)n2), 0, n7);
            }
        } else {
            ViewPager viewPager = this;
            ItemInfo itemInfo = viewPager.infoForPosition(viewPager.mCurItem);
            n2 = (int)((itemInfo != null ? Math.min(itemInfo.offset, this.mLastOffset) : 0.0f) * (float)(n2 - this.getPaddingLeft() - this.getPaddingRight()));
            if (n2 != this.getScrollX()) {
                ViewPager viewPager3 = this;
                viewPager3.completeScroll(false);
                viewPager3.scrollTo(n2, viewPager3.getScrollY());
            }
        }
    }

    private boolean pageScrolled(int n2) {
        if (this.mItems.size() == 0) {
            ViewPager viewPager = this;
            viewPager.mCalledSuper = false;
            viewPager.onPageScrolled(0, 0.0f, 0);
            if (viewPager.mCalledSuper) {
                return false;
            }
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        ViewPager viewPager = this;
        ItemInfo itemInfo = this.infoForCurrentScrollPosition();
        int n3 = this.getClientWidth();
        int n4 = this.mPageMargin;
        int n5 = n3 + n4;
        float f3 = n3;
        float f4 = (float)n4 / f3;
        int n6 = itemInfo.position;
        f3 = ((float)n2 / f3 - itemInfo.offset) / (itemInfo.widthFactor + f4);
        int n7 = (int)(f3 * (float)n5);
        viewPager.mCalledSuper = false;
        viewPager.onPageScrolled(n6, f3, n7);
        if (viewPager.mCalledSuper) {
            return true;
        }
        throw new IllegalStateException("onPageScrolled did not call superclass implementation");
    }

    private void completeScroll(boolean bl) {
        int n2;
        boolean bl2 = this.mScrollState == 2;
        if (bl2) {
            ViewPager viewPager = this;
            viewPager.setScrollingCacheEnabled(false);
            viewPager.mScroller.abortAnimation();
            ViewPager viewPager2 = this;
            n2 = viewPager2.getScrollY();
            int n3 = viewPager2.mScroller.getCurrX();
            int n4 = this.mScroller.getCurrY();
            if (viewPager.getScrollX() != n3 || n2 != n4) {
                this.scrollTo(n3, n4);
            }
        }
        this.mPopulatePending = false;
        n2 = 0;
        while (true) {
            if (n2 >= this.mItems.size()) {
                if (bl2) {
                    if (bl) {
                        ViewPager viewPager = this;
                        ViewCompat.postOnAnimation((View)viewPager, viewPager.mEndScrollRunnable);
                    } else {
                        this.mEndScrollRunnable.run();
                    }
                }
                return;
            }
            ItemInfo itemInfo = this.mItems.get(n2);
            if (itemInfo.scrolling) {
                bl2 = true;
                itemInfo.scrolling = false;
            }
            ++n2;
        }
    }

    private boolean isGutterDrag(float f3, float f4) {
        return f3 < (float)this.mGutterSize && f4 > 0.0f || f3 > (float)(this.getWidth() - this.mGutterSize) && f4 < 0.0f;
        {
        }
    }

    private void enableLayers(boolean bl) {
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = bl ? 2 : 0;
            ViewCompat.setLayerType(this.getChildAt(n3), n4, null);
            ++n3;
        }
        return;
    }

    private void requestParentDisallowInterceptTouchEvent(boolean bl) {
        if ((this = this.getParent()) != null) {
            this.requestDisallowInterceptTouchEvent(bl);
        }
    }

    private boolean performDrag(float f3) {
        ViewPager viewPager = this;
        float f4 = f3;
        boolean bl = false;
        f3 = this.mLastMotionX - f3;
        viewPager.mLastMotionX = f4;
        f3 = (float)viewPager.getScrollX() + f3;
        float f5 = viewPager.getClientWidth();
        float f6 = f5 * this.mFirstOffset;
        float f7 = f5 * this.mLastOffset;
        boolean bl2 = true;
        boolean bl3 = true;
        ItemInfo itemInfo = viewPager.mItems.get(0);
        ArrayList<ItemInfo> arrayList = viewPager.mItems;
        ItemInfo itemInfo2 = arrayList.get(arrayList.size() - 1);
        if (itemInfo.position != 0) {
            bl2 = false;
            f6 = itemInfo.offset * f5;
        }
        if (itemInfo2.position != this.mAdapter.getCount() - 1) {
            bl3 = false;
            f7 = itemInfo2.offset * f5;
        }
        if (f3 < f6) {
            if (bl2) {
                f3 = f6 - f3;
                bl = this.mLeftEdge.onPull(Math.abs(f3) / f5);
            }
            f7 = f6;
        } else if (f3 > f7) {
            if (bl3) {
                bl = this.mRightEdge.onPull(Math.abs(f3 -= f7) / f5);
            }
        } else {
            f7 = f3;
        }
        ViewPager viewPager2 = this;
        float f8 = f7;
        int n2 = (int)f8;
        viewPager2.mLastMotionX += f8 - (float)n2;
        viewPager2.scrollTo(n2, viewPager2.getScrollY());
        viewPager2.pageScrolled(n2);
        return bl;
    }

    private ItemInfo infoForCurrentScrollPosition() {
        ItemInfo itemInfo;
        int n2 = this.getClientWidth();
        float f3 = n2 > 0 ? (float)this.getScrollX() / (float)n2 : 0.0f;
        float f4 = n2 > 0 ? (float)this.mPageMargin / (float)n2 : 0.0f;
        int n3 = -1;
        float f5 = 0.0f;
        float f6 = 0.0f;
        boolean bl = true;
        ItemInfo itemInfo2 = null;
        int n4 = 0;
        while (true) {
            if (n4 >= this.mItems.size()) {
                return itemInfo2;
            }
            itemInfo = this.mItems.get(n4);
            if (!bl && itemInfo.position != ++n3) {
                itemInfo = this.mTempItem;
                itemInfo.offset = f5 + f6 + f4;
                itemInfo.position = n3;
                this.mTempItem.widthFactor = this.mAdapter.getPageWidth(n3);
                --n4;
            }
            f5 = itemInfo.offset;
            float f7 = f5 + itemInfo.widthFactor + f4;
            if (!bl && !(f3 >= f5)) {
                return itemInfo2;
            }
            if (f3 < f7 || n4 == this.mItems.size() - 1) break;
            ItemInfo itemInfo3 = itemInfo;
            bl = false;
            n3 = itemInfo3.position;
            f6 = itemInfo3.widthFactor;
            ++n4;
            itemInfo2 = itemInfo;
        }
        return itemInfo;
    }

    private int determineTargetPage(int n2, float f3, int n3, int n4) {
        if (Math.abs(n4) > object.mFlingDistance && Math.abs(n3) > object.mMinimumVelocity) {
            if (n3 <= 0) {
                ++n2;
            }
        } else {
            float f4 = n2 >= object.mCurItem ? 0.4f : 0.6f;
            n2 = (int)((float)n2 + f3 + f4);
        }
        if (object.mItems.size() > 0) {
            ViewPager viewPager = object;
            Object object = viewPager.mItems.get(0);
            ArrayList<ItemInfo> arrayList = viewPager.mItems;
            object = arrayList.get(arrayList.size() - 1);
            n2 = Math.max(((ItemInfo)object).position, Math.min(n2, ((ItemInfo)object).position));
        }
        return n2;
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = motionEvent;
        int n2 = MotionEventCompat.getActionIndex(motionEvent2);
        if (MotionEventCompat.getPointerId(motionEvent2, n2) == viewPager.mActivePointerId) {
            n2 = n2 == 0 ? 1 : 0;
            viewPager.mLastMotionX = MotionEventCompat.getX(motionEvent, n2);
            viewPager.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n2);
            ViewPager viewPager = viewPager.mVelocityTracker;
            if (viewPager != null) {
                viewPager.clear();
            }
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        VelocityTracker velocityTracker = this.mVelocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void setScrollingCacheEnabled(boolean bl) {
        if (this.mScrollingCacheEnabled != bl) {
            this.mScrollingCacheEnabled = bl;
        }
    }

    private Rect getChildRectInPagerCoordinates(Rect rect, View view) {
        if (rect == null) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect();
        }
        if (view == null) {
            Rect rect3 = rect;
            rect3.set(0, 0, 0, 0);
            return rect3;
        }
        rect.left = view.getLeft();
        rect.right = view.getRight();
        rect.top = view.getTop();
        rect.bottom = view.getBottom();
        for (view = view.getParent(); view instanceof ViewGroup && view != this; view = view.getParent()) {
            view = (ViewGroup)view;
            Rect rect4 = rect;
            rect4.left += view.getLeft();
            rect4.right += view.getRight();
            rect4.top += view.getTop();
            rect4.bottom += view.getBottom();
        }
        return rect;
    }

    void initViewPager() {
        ViewPager viewPager = this;
        viewPager.setWillNotDraw(false);
        viewPager.setDescendantFocusability(262144);
        viewPager.setFocusable(true);
        Context context = viewPager.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        float f3 = context.getResources().getDisplayMetrics().density;
        ViewPager viewPager2 = this;
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop(viewConfiguration);
        this.mMinimumVelocity = (int)(f3 * 400.0f);
        viewPager2.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        viewPager2.mLeftEdge = new EdgeEffectCompat(context);
        viewPager2.mRightEdge = new EdgeEffectCompat(context);
        this.mFlingDistance = (int)(f3 * 25.0f);
        this.mCloseEnough = (int)(f3 * 2.0f);
        viewPager.mDefaultGutterSize = (int)(f3 * 16.0f);
        ViewCompat.setAccessibilityDelegate((View)viewPager, new MyAccessibilityDelegate());
        if (ViewCompat.getImportantForAccessibility((View)viewPager) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
    }

    protected void onDetachedFromWindow() {
        ViewPager viewPager = this;
        viewPager.removeCallbacks(viewPager.mEndScrollRunnable);
        super.onDetachedFromWindow();
    }

    public void setAdapter(PagerAdapter pagerAdapter) {
        PagerAdapter pagerAdapter2 = ((ViewPager)((Object)this)).mAdapter;
        if (pagerAdapter2 != null) {
            pagerAdapter2.unregisterDataSetObserver(((ViewPager)((Object)this)).mObserver);
            ((ViewPager)((Object)this)).mAdapter.startUpdate((ViewGroup)this);
            int n2 = 0;
            while (true) {
                ItemInfo itemInfo;
                if (n2 >= ((ViewPager)((Object)this)).mItems.size()) {
                    Object object = this;
                    ((ViewPager)((Object)object)).mAdapter.finishUpdate((ViewGroup)this);
                    ((ViewPager)((Object)object)).mItems.clear();
                    super.removeNonDecorViews();
                    ((ViewPager)((Object)object)).mCurItem = 0;
                    object.scrollTo(0, 0);
                    break;
                }
                Object object = this;
                ItemInfo itemInfo2 = itemInfo = ((ViewPager)((Object)object)).mItems.get(n2);
                int n3 = itemInfo2.position;
                ((ViewPager)((Object)object)).mAdapter.destroyItem((ViewGroup)this, n3, itemInfo2.object);
                ++n2;
            }
        }
        pagerAdapter2 = ((ViewPager)((Object)this)).mAdapter;
        ((ViewPager)((Object)this)).mAdapter = pagerAdapter;
        ((ViewPager)((Object)this)).mExpectedAdapterCount = 0;
        if (pagerAdapter != null) {
            if (((ViewPager)((Object)this)).mObserver == null) {
                PagerObserver pagerObserver;
                PagerObserver pagerObserver2 = pagerObserver;
                pagerObserver = (ViewPager)((Object)this).new PagerObserver();
                ((ViewPager)((Object)this)).mObserver = pagerObserver2;
            }
            ViewPager viewPager = this;
            viewPager.mAdapter.registerDataSetObserver(((ViewPager)((Object)this)).mObserver);
            viewPager.mPopulatePending = false;
            boolean bl = viewPager.mFirstLayout;
            viewPager.mFirstLayout = true;
            viewPager.mExpectedAdapterCount = viewPager.mAdapter.getCount();
            if (viewPager.mRestoredCurItem >= 0) {
                Object object = this;
                Object object2 = this;
                Parcelable parcelable = ((ViewPager)((Object)object2)).mRestoredAdapterState;
                ((ViewPager)((Object)object)).mAdapter.restoreState(parcelable, ((ViewPager)((Object)object2)).mRestoredClassLoader);
                ((ViewPager)((Object)object)).setCurrentItemInternal(((ViewPager)((Object)object)).mRestoredCurItem, false, true);
                ((ViewPager)((Object)object)).mRestoredCurItem = -1;
                ((ViewPager)((Object)object)).mRestoredAdapterState = null;
                ((ViewPager)((Object)object)).mRestoredClassLoader = null;
            } else if (!bl) {
                ((ViewPager)((Object)this)).populate();
            } else {
                this.requestLayout();
            }
        }
        if ((this = ((ViewPager)((Object)this)).mAdapterChangeListener) != null && pagerAdapter2 != pagerAdapter) {
            this.onAdapterChanged(pagerAdapter2, pagerAdapter);
        }
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    void setOnAdapterChangeListener(OnAdapterChangeListener onAdapterChangeListener) {
        this.mAdapterChangeListener = onAdapterChangeListener;
    }

    public void setCurrentItem(int n2) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, this.mFirstLayout ^ true, false);
    }

    public void setCurrentItem(int n2, boolean bl) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n2, bl, false);
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    void setCurrentItemInternal(int n2, boolean bl, boolean bl2) {
        this.setCurrentItemInternal(n2, bl, bl2, 0);
    }

    /*
     * Unable to fully structure code
     */
    void setCurrentItemInternal(int var1_1, boolean var2_2, boolean var3_5, int var4_6) {
        block12: {
            var5_7 = this.mAdapter;
            if (var5_7 == null || var5_7.getCount() <= 0) break block12;
            if (var3_5 == 0 && this.mCurItem == var1_1 && this.mItems.size() != 0) {
                this.setScrollingCacheEnabled(false);
                return;
            }
            if (var1_1 < 0) {
                var1_1 = 0;
            } else if (var1_1 >= this.mAdapter.getCount()) {
                var1_1 = this.mAdapter.getCount() - 1;
            }
            v0 = this;
            var3_5 = v0.mOffscreenPageLimit;
            var5_8 = v0.mCurItem;
            if (var1_1 <= var5_8 + var3_5 && var1_1 >= var5_8 - var3_5) ** GOTO lbl18
            var3_5 = 0;
            while (true) {
                block13: {
                    if (var3_5 < this.mItems.size()) break block13;
lbl18:
                    // 2 sources

                    var3_5 = this.mCurItem != var1_1 ? 1 : 0;
                    if (this.mFirstLayout) {
                        this.mCurItem = var1_1;
                        if (var3_5 != 0 && (var2_3 = this.mOnPageChangeListener) != null) {
                            var2_3.onPageSelected(var1_1);
                        }
                        if (var3_5 != 0 && (var2_4 = this.mInternalPageChangeListener) != null) {
                            var2_4.onPageSelected(var1_1);
                        }
                        this.requestLayout();
                    } else {
                        v1 = this;
                        v1.populate(var1_1);
                        v1.scrollToItem(var1_1, var2_2, var4_6, (boolean)var3_5);
                    }
                    return;
                }
                this.mItems.get((int)var3_5).scrolling = true;
                ++var3_5;
            }
        }
        this.setScrollingCacheEnabled(false);
    }

    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    /*
     * WARNING - void declaration
     */
    public void setPageTransformer(boolean bl, PageTransformer pageTransformer) {
        if (Build.VERSION.SDK_INT >= 11) {
            void var2_5;
            boolean bl2 = var2_5 != null;
            boolean bl3 = this.mPageTransformer != null;
            bl3 = bl2 ^ bl3;
            this.mPageTransformer = var2_5;
            this.setChildrenDrawingOrderEnabledCompat(bl2);
            if (bl2) {
                void var1_4;
                if (bl) {
                    int n2 = 2;
                } else {
                    boolean bl4 = true;
                }
                this.mDrawingOrder = var1_4;
            } else {
                this.mDrawingOrder = 0;
            }
            if (bl3) {
                this.populate();
            }
        }
    }

    void setChildrenDrawingOrderEnabledCompat(boolean bl) {
        if (Build.VERSION.SDK_INT >= 7) {
            if (this.mSetChildrenDrawingOrderEnabled == null) {
                ViewPager viewPager = this;
                Class<ViewGroup> clazz = ViewGroup.class;
                Class[] classArray = new Class[1];
                try {
                    classArray[0] = Boolean.TYPE;
                    viewPager.mSetChildrenDrawingOrderEnabled = clazz.getDeclaredMethod("setChildrenDrawingOrderEnabled", classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Log.e((String)TAG, (String)"Can't find setChildrenDrawingOrderEnabled", (Throwable)noSuchMethodException);
                }
            }
            Method method = this.mSetChildrenDrawingOrderEnabled;
            ViewPager viewPager = this;
            Object[] objectArray = new Object[1];
            int n2 = 0;
            try {
                objectArray[n2] = bl;
                method.invoke((Object)viewPager, objectArray);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Error changing children drawing order", (Throwable)exception);
            }
        }
    }

    protected int getChildDrawingOrder(int n2, int n3) {
        if (this.mDrawingOrder == 2) {
            n3 = n2 - 1 - n3;
        }
        return ((LayoutParams)this.mDrawingOrderedChildren.get((int)n3).getLayoutParams()).childIndex;
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.mInternalPageChangeListener = onPageChangeListener;
        return this.mInternalPageChangeListener;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public void setOffscreenPageLimit(int n2) {
        if (n2 < 1) {
            Log.w((String)TAG, (String)("Requested offscreen page limit " + n2 + " too small; defaulting to " + 1));
            n2 = 1;
        }
        if (n2 != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = n2;
            this.populate();
        }
    }

    public void setPageMargin(int n2) {
        ViewPager viewPager = this;
        int n3 = viewPager.mPageMargin;
        viewPager.mPageMargin = n2;
        int n4 = viewPager.getWidth();
        viewPager.recomputeScrollPosition(n4, n4, n2, n3);
        viewPager.requestLayout();
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    public void setPageMarginDrawable(Drawable drawable2) {
        this.mMarginDrawable = drawable2;
        if (drawable2 != null) {
            this.refreshDrawableState();
        }
        boolean bl = drawable2 == null;
        ViewPager viewPager = this;
        viewPager.setWillNotDraw(bl);
        viewPager.invalidate();
    }

    public void setPageMarginDrawable(int n2) {
        ViewPager viewPager = this;
        viewPager.setPageMarginDrawable(viewPager.getContext().getResources().getDrawable(n2));
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        return super.verifyDrawable(drawable2) || drawable2 == this.mMarginDrawable;
    }

    protected void drawableStateChanged() {
        ViewPager viewPager = this;
        super.drawableStateChanged();
        Drawable drawable2 = viewPager.mMarginDrawable;
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    float distanceInfluenceForSnapDuration(float f3) {
        return (float)Math.sin((float)((double)(f3 - 0.5f) * 0.4712389167638204));
    }

    void smoothScrollTo(int n2, int n3) {
        this.smoothScrollTo(n2, n3, 0);
    }

    void smoothScrollTo(int n2, int n3, int n4) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int n5 = n2;
        ViewPager viewPager = this;
        n2 = viewPager.getScrollX();
        int n6 = viewPager.getScrollY();
        int n7 = n5 - n2;
        if (n7 == 0 && (n3 -= n6) == 0) {
            ViewPager viewPager2 = this;
            viewPager2.completeScroll(false);
            viewPager2.populate();
            viewPager2.setScrollState(0);
            return;
        }
        int n8 = n4;
        ViewPager viewPager3 = this;
        viewPager3.setScrollingCacheEnabled(true);
        viewPager3.setScrollState(2);
        n4 = viewPager3.getClientWidth();
        float f3 = n4;
        float f4 = Math.min(1.0f, (float)Math.abs(n7) * 1.0f / f3);
        float f5 = n4 / 2;
        f4 = f5 + f5 * this.distanceInfluenceForSnapDuration(f4);
        int n9 = Math.abs(n8);
        int n10 = Math.min(n9 > 0 ? Math.round(Math.abs(f4 / (float)n9) * 1000.0f) * 4 : (int)(((float)Math.abs(n7) / ((f3 *= this.mAdapter.getPageWidth(this.mCurItem)) + (float)this.mPageMargin) + 1.0f) * 100.0f), 600);
        ViewPager viewPager4 = this;
        viewPager4.mScroller.startScroll(n2, n6, n7, n3, n10);
        ViewCompat.postInvalidateOnAnimation((View)viewPager4);
    }

    ItemInfo addNewItem(int n2, int n3) {
        ItemInfo itemInfo;
        ItemInfo itemInfo2 = itemInfo;
        itemInfo2();
        itemInfo2.position = n2;
        itemInfo2.object = this.mAdapter.instantiateItem(this, n2);
        itemInfo.widthFactor = this.mAdapter.getPageWidth(n2);
        if (n3 >= 0 && n3 < this.mItems.size()) {
            this.mItems.add(n3, itemInfo2);
        } else {
            this.mItems.add(itemInfo2);
        }
        return itemInfo2;
    }

    void dataSetChanged() {
        int n2;
        ViewPager viewPager = this;
        viewPager.mExpectedAdapterCount = n2 = viewPager.mAdapter.getCount();
        int n3 = viewPager.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < n2 ? 1 : 0;
        int n4 = this.mCurItem;
        boolean bl = false;
        int n5 = 0;
        while (true) {
            if (n5 >= this.mItems.size()) {
                if (bl) {
                    this.mAdapter.finishUpdate(this);
                }
                Collections.sort(this.mItems, COMPARATOR);
                if (n3 != 0) {
                    n2 = this.getChildCount();
                    n3 = 0;
                    while (true) {
                        if (n3 >= n2) {
                            ViewPager viewPager2 = this;
                            viewPager2.setCurrentItemInternal(n4, false, true);
                            viewPager2.requestLayout();
                            break;
                        }
                        LayoutParams layoutParams = (LayoutParams)this.getChildAt(n3).getLayoutParams();
                        if (!layoutParams.isDecor) {
                            layoutParams.widthFactor = 0.0f;
                        }
                        ++n3;
                    }
                }
                return;
            }
            ViewPager viewPager3 = this;
            ItemInfo itemInfo = viewPager3.mItems.get(n5);
            int n6 = viewPager3.mAdapter.getItemPosition(itemInfo.object);
            if (n6 != -1) {
                if (n6 == -2) {
                    this.mItems.remove(n5);
                    --n5;
                    if (!bl) {
                        this.mAdapter.startUpdate(this);
                        bl = true;
                    }
                    ViewPager viewPager4 = this;
                    ItemInfo itemInfo2 = itemInfo;
                    n3 = itemInfo2.position;
                    viewPager4.mAdapter.destroyItem(this, n3, itemInfo2.object);
                    n3 = 1;
                    n6 = viewPager4.mCurItem;
                    if (n6 == itemInfo.position) {
                        n4 = Math.max(0, Math.min(n6, n2 - 1));
                        n3 = 1;
                    }
                } else {
                    int n7 = itemInfo.position;
                    if (n7 != n6) {
                        if (n7 == this.mCurItem) {
                            n4 = n6;
                        }
                        itemInfo.position = n6;
                        n3 = 1;
                    }
                }
            }
            ++n5;
        }
    }

    void populate() {
        ViewPager viewPager = this;
        viewPager.populate(viewPager.mCurItem);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void populate(int var1_1) {
        block35: {
            var2_6 = null;
            var3_8 = 2;
            var4_11 = this.mCurItem;
            if (var4_11 != var1_1) {
                var2_7 = var4_11 < var1_1 ? 66 : 17;
                v0 = this;
                var1_2 = v0.infoForPosition(v0.mCurItem);
                this.mCurItem = var1_1;
            } else {
                var1_2 = var2_6;
                var2_7 = var3_8;
            }
            if (this.mAdapter == null) {
                this.sortChildDrawingOrder();
                return;
            }
            if (this.mPopulatePending) {
                this.sortChildDrawingOrder();
                return;
            }
            if (this.getWindowToken() == null) {
                return;
            }
            v1 = this;
            v1.mAdapter.startUpdate(this);
            var3_8 = v1.mOffscreenPageLimit;
            var4_11 = Math.max(0, v1.mCurItem - var3_8);
            var5_14 = v1.mAdapter.getCount();
            var3_8 = Math.min(var5_14 - 1, this.mCurItem + var3_8);
            if (var5_14 != this.mExpectedAdapterCount) break block35;
            var6_15 = null;
            var7_18 = 0;
            while (true) {
                block37: {
                    block39: {
                        block38: {
                            block36: {
                                if (var7_18 >= this.mItems.size()) break block36;
                                var8_19 = this.mItems.get(var7_18);
                                var9_21 = var8_19.position;
                                var10_23 = this.mCurItem;
                                if (var9_21 < var10_23) break block37;
                                if (var9_21 == var10_23) break block38;
                            }
                            var8_19 = var6_15;
                        }
                        if (var8_19 == null && var5_14 > 0) {
                            v2 = this;
                            var8_19 = v2.addNewItem(v2.mCurItem, var7_18);
                        }
                        if (var8_19 == null) break block39;
                        var6_16 = 0.0f;
                        var9_21 = var7_18 - 1;
                        var10_24 = var9_21 >= 0 ? this.mItems.get(var9_21) : null;
                        var11_26 = this.getClientWidth();
                        var12_27 = var11_26 <= 0 ? 0.0f : 2.0f - var8_19.widthFactor + (float)this.getPaddingLeft() / (float)var11_26;
                        var13_28 = this.mCurItem - 1;
                        while (true) {
                            block43: {
                                block44: {
                                    block41: {
                                        block42: {
                                            block40: {
                                                if (var13_28 < 0) break block40;
                                                if (!(var6_16 >= var12_27) || var13_28 >= var4_11) break block41;
                                                if (var10_24 != null) break block42;
                                            }
                                            var4_12 = var8_19.widthFactor;
                                            var6_17 = var7_18 + 1;
                                            if (v3 < 2.0f) {
                                                var9_22 = var6_17 < this.mItems.size() ? this.mItems.get(var6_17) : null;
                                                var10_25 = var11_26 <= 0 ? 0.0f : (float)this.getPaddingRight() / (float)var11_26 + 2.0f;
                                                for (var11_26 = this.mCurItem + 1; var11_26 < var5_14; ++var11_26) {
                                                    if (var4_12 >= var10_25 && var11_26 > var3_8) {
                                                        if (var9_22 == null) break;
                                                        if (var11_26 != var9_22.position || var9_22.scrolling) continue;
                                                        v4 = this;
                                                        v4.mItems.remove(var6_17);
                                                        v4.mAdapter.destroyItem(this, var11_26, var9_22.object);
                                                        if (var6_17 < v4.mItems.size()) {
                                                            var9_22 = this.mItems.get(var6_17);
                                                            continue;
                                                        }
                                                    } else if (var9_22 != null && var11_26 == var9_22.position) {
                                                        var4_12 += var9_22.widthFactor;
                                                        if (++var6_17 < this.mItems.size()) {
                                                            var9_22 = this.mItems.get(var6_17);
                                                            continue;
                                                        }
                                                    } else {
                                                        var9_22 = this.addNewItem(var11_26, var6_17);
                                                        var4_12 += var9_22.widthFactor;
                                                        if (++var6_17 < this.mItems.size()) {
                                                            var9_22 = this.mItems.get(var6_17);
                                                            continue;
                                                        }
                                                    }
                                                    var9_22 = null;
                                                }
                                            }
                                            this.calculatePageOffsets(var8_19, var7_18, (ItemInfo)var1_2);
                                            break;
                                        }
                                        if (var13_28 != var10_24.position || var10_24.scrolling) break block43;
                                        v5 = this;
                                        v5.mItems.remove(var9_21);
                                        v5.mAdapter.destroyItem(this, var13_28, var10_24.object);
                                        --var7_18;
                                        if ((var9_21 += -1) < 0) ** GOTO lbl-1000
                                        var10_24 = this.mItems.get(var9_21);
                                        break block43;
                                    }
                                    if (var10_24 == null || var13_28 != var10_24.position) break block44;
                                    var6_16 += var10_24.widthFactor;
                                    if ((var9_21 += -1) < 0) ** GOTO lbl-1000
                                    var10_24 = this.mItems.get(var9_21);
                                    break block43;
                                }
                                var6_16 += this.addNewItem((int)var13_28, (int)(var9_21 + 1)).widthFactor;
                                ++var7_18;
                                if (var9_21 >= 0) {
                                    var10_24 = this.mItems.get(var9_21);
                                } else lbl-1000:
                                // 3 sources

                                {
                                    var10_24 = null;
                                }
                            }
                            --var13_28;
                        }
                    }
                    v6 = this;
                    var1_2 = v6.mAdapter;
                    var3_8 = v6.mCurItem;
                    var4_13 /* !! */  = var8_19 != null ? var8_19.object : null;
                    v7 = this;
                    var1_2.setPrimaryItem(this, var3_8, var4_13 /* !! */ );
                    v7.mAdapter.finishUpdate(this);
                    var8_20 = v7.getChildCount();
                    var1_3 = 0;
                    while (true) {
                        if (var1_3 >= var8_20) {
                            v8 = this;
                            v8.sortChildDrawingOrder();
                            if (v8.hasFocus() && ((var1_4 /* !! */  = (var1_4 /* !! */  = this.findFocus()) != null ? this.infoForAnyChild(var1_4 /* !! */ ) : null) == null || var1_4 /* !! */ .position != this.mCurItem)) {
                                for (var1_5 = 0; var1_5 < this.getChildCount(); ++var1_5) {
                                    v9 = this;
                                    var3_9 = v9.getChildAt(var1_5);
                                    var4_13 /* !! */  = v9.infoForChild(var3_9);
                                    if (var4_13 /* !! */  != null && var4_13 /* !! */ .position == this.mCurItem && var3_9.requestFocus(var2_7)) break;
                                }
                            }
                            return;
                        }
                        var3_10 /* !! */  = this.getChildAt(var1_3);
                        var4_13 /* !! */  = (LayoutParams)var3_10 /* !! */ .getLayoutParams();
                        var4_13 /* !! */ .childIndex = var1_3;
                        if (!var4_13 /* !! */ .isDecor && var4_13 /* !! */ .widthFactor == 0.0f && (var3_10 /* !! */  = this.infoForChild(var3_10 /* !! */ )) != null) {
                            var4_13 /* !! */ .widthFactor = var3_10 /* !! */ .widthFactor;
                            var4_13 /* !! */ .position = var3_10 /* !! */ .position;
                        }
                        ++var1_3;
                    }
                }
                ++var7_18;
            }
        }
        try {
            var1_2 = this.getResources().getResourceName(this.getId());
        }
        catch (Resources.NotFoundException v10) {
            var1_2 = Integer.toHexString(this.getId());
        }
        throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + var5_14 + " Pager id: " + (String)var1_2 + " Pager class: " + this.getClass() + " Problematic adapter: " + this.mAdapter.getClass());
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState;
        ViewPager viewPager = pagerAdapter;
        Parcelable parcelable = super.onSaveInstanceState();
        SavedState savedState2 = savedState;
        savedState2(parcelable);
        savedState.position = ((ViewPager)((Object)pagerAdapter)).mCurItem;
        PagerAdapter pagerAdapter = viewPager.mAdapter;
        if (pagerAdapter != null) {
            savedState2.adapterState = pagerAdapter.saveState();
        }
        return savedState2;
    }

    public void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState(object);
            return;
        }
        ViewPager viewPager = viewPager3;
        object = (SavedState)((Object)object);
        super.onRestoreInstanceState(object.getSuperState());
        PagerAdapter pagerAdapter = viewPager.mAdapter;
        if (pagerAdapter != null) {
            ViewPager viewPager2 = viewPager3;
            Object object2 = object;
            ViewPager viewPager3 = object2.adapterState;
            pagerAdapter.restoreState((Parcelable)viewPager3, object2.loader);
            viewPager2.setCurrentItemInternal(object.position, false, true);
        } else {
            viewPager3.mRestoredCurItem = object.position;
            viewPager3.mRestoredAdapterState = object.adapterState;
            viewPager3.mRestoredClassLoader = object.loader;
        }
    }

    public void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        boolean bl;
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams = this.generateLayoutParams(layoutParams);
        }
        LayoutParams layoutParams2 = (LayoutParams)layoutParams;
        layoutParams2.isDecor = bl = layoutParams2.isDecor | view instanceof Decor;
        if (this.mInLayout) {
            if (layoutParams2 != null && bl) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            layoutParams2.needsMeasure = true;
            this.addViewInLayout(view, n2, layoutParams);
        } else {
            super.addView(view, n2, layoutParams);
        }
    }

    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    ItemInfo infoForChild(View view) {
        int n2 = 0;
        while (n2 < this.mItems.size()) {
            ViewPager viewPager = this;
            ItemInfo itemInfo = viewPager.mItems.get(n2);
            if (viewPager.mAdapter.isViewFromObject(view, itemInfo.object)) {
                return itemInfo;
            }
            ++n2;
        }
        return null;
    }

    ItemInfo infoForAnyChild(View view) {
        while (true) {
            ViewParent viewParent;
            if ((viewParent = view.getParent()) == this) {
                return this.infoForChild(view);
            }
            if (viewParent == null || !(viewParent instanceof View)) break;
            view = (View)viewParent;
        }
        return null;
    }

    ItemInfo infoForPosition(int n2) {
        int n3 = 0;
        while (n3 < this.mItems.size()) {
            ItemInfo itemInfo = this.mItems.get(n3);
            if (itemInfo.position == n2) {
                return itemInfo;
            }
            ++n3;
        }
        return null;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    protected void onMeasure(int n2, int n3) {
        ViewPager viewPager = this;
        viewPager.setMeasuredDimension(ViewGroup.getDefaultSize((int)0, (int)n2), ViewGroup.getDefaultSize((int)0, (int)n3));
        n2 = viewPager.getMeasuredWidth();
        this.mGutterSize = Math.min(n2 / 10, this.mDefaultGutterSize);
        n2 = n2 - this.getPaddingLeft() - this.getPaddingRight();
        n3 = viewPager.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int n4 = viewPager.getChildCount();
        int n5 = 0;
        while (true) {
            block17: {
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                View view;
                block21: {
                    block20: {
                        LayoutParams layoutParams;
                        block19: {
                            block18: {
                                if (n5 >= n4) {
                                    ViewPager viewPager2 = this;
                                    this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n2, (int)0x40000000);
                                    viewPager2.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000);
                                    viewPager2.mInLayout = true;
                                    viewPager2.populate();
                                    viewPager2.mInLayout = false;
                                    int n12 = viewPager2.getChildCount();
                                    n3 = 0;
                                    while (true) {
                                        LayoutParams layoutParams2;
                                        if (n3 >= n12) {
                                            return;
                                        }
                                        View view2 = this.getChildAt(n3);
                                        if (!(view2.getVisibility() == 8 || (layoutParams2 = (LayoutParams)view2.getLayoutParams()) != null && layoutParams2.isDecor)) {
                                            int n13 = View.MeasureSpec.makeMeasureSpec((int)((int)((float)n2 * layoutParams2.widthFactor)), (int)0x40000000);
                                            view2.measure(n13, this.mChildHeightMeasureSpec);
                                        }
                                        ++n3;
                                    }
                                }
                                view = this.getChildAt(n5);
                                if (view.getVisibility() == 8 || (layoutParams = (LayoutParams)view.getLayoutParams()) == null || !layoutParams.isDecor) break block17;
                                int n14 = layoutParams.gravity;
                                n11 = n14 & 7;
                                n10 = n14 & 0x70;
                                n9 = Integer.MIN_VALUE;
                                n8 = Integer.MIN_VALUE;
                                n10 = n10 != 48 && n10 != 80 ? 0 : 1;
                                n11 = n11 != 3 && n11 != 5 ? 0 : 1;
                                if (n10 != 0) {
                                    n9 = 0x40000000;
                                } else if (n11 != 0) {
                                    n8 = 0x40000000;
                                }
                                n7 = layoutParams.width;
                                if (n7 == -2) break block18;
                                n9 = 0x40000000;
                                if (n7 != -1) break block19;
                            }
                            n7 = n2;
                        }
                        n6 = layoutParams.height;
                        if (n6 == -2) break block20;
                        n8 = 0x40000000;
                        if (n6 != -1) break block21;
                    }
                    n6 = n3;
                }
                int n15 = n6;
                n6 = View.MeasureSpec.makeMeasureSpec((int)n7, (int)n9);
                view.measure(n6, View.MeasureSpec.makeMeasureSpec((int)n15, (int)n8));
                if (n10 != 0) {
                    n3 -= view.getMeasuredHeight();
                } else if (n11 != 0) {
                    n2 -= view.getMeasuredWidth();
                }
            }
            ++n5;
        }
    }

    protected void onSizeChanged(int n2, int n3, int n4, int n5) {
        super.onSizeChanged(n2, n3, n4, n5);
        if (n2 != n4) {
            int n6;
            ViewPager viewPager = this;
            int n7 = n6 = viewPager.mPageMargin;
            viewPager.recomputeScrollPosition(n2, n4, n7, n7);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean n2, int n3, int n4, int n5, int n6) {
        ViewPager viewPager = this;
        n2 = this.getChildCount();
        n3 = n5 - n3;
        n4 = n6 - n4;
        n5 = viewPager.getPaddingLeft();
        n6 = viewPager.getPaddingTop();
        int n7 = viewPager.getPaddingRight();
        int n8 = viewPager.getPaddingBottom();
        int n9 = viewPager.getScrollX();
        int n10 = 0;
        int n11 = 0;
        while (true) {
            int n12;
            block20: {
                block17: {
                    int n13;
                    View view;
                    block16: {
                        block19: {
                            block15: {
                                block18: {
                                    if (n11 >= n2) break;
                                    view = this.getChildAt(n11);
                                    if (view.getVisibility() == 8) break block17;
                                    LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                                    if (!layoutParams.isDecor) break block17;
                                    n13 = layoutParams.gravity;
                                    n12 = n13 & 7;
                                    n13 &= 0x70;
                                    if (n12 == 1) break block18;
                                    if (n12 != 3) {
                                        if (n12 != 5) {
                                            int n14 = n5;
                                            int n15 = n7;
                                            n7 = n5;
                                            n5 = n15;
                                            n12 = n14;
                                            break block15;
                                        } else {
                                            int n16 = n7;
                                            n7 = n3 - n7 - view.getMeasuredWidth();
                                            n12 = n16 + view.getMeasuredWidth();
                                            int n17 = n5;
                                            n5 = n12;
                                            n12 = n17;
                                        }
                                        break block15;
                                    } else {
                                        n12 = n5 + view.getMeasuredWidth();
                                        int n18 = n7;
                                        n7 = n5;
                                        n5 = n18;
                                    }
                                    break block15;
                                }
                                n12 = Math.max((n3 - view.getMeasuredWidth()) / 2, n5);
                                int n19 = n5;
                                int n20 = n7;
                                n7 = n12;
                                n5 = n20;
                                n12 = n19;
                            }
                            if (n13 == 16) break block19;
                            if (n13 != 48) {
                                if (n13 != 80) {
                                    n13 = n6;
                                    break block16;
                                } else {
                                    int n21 = n8;
                                    n8 = n4 - n8 - view.getMeasuredHeight();
                                    n13 = n21 + view.getMeasuredHeight();
                                    int n22 = n8;
                                    n8 = n13;
                                    n13 = n22;
                                }
                                break block16;
                            } else {
                                n13 = n6 + view.getMeasuredHeight();
                                int n23 = n6;
                                n6 = n13;
                                n13 = n23;
                            }
                            break block16;
                        }
                        n13 = Math.max((n4 - view.getMeasuredHeight()) / 2, n6);
                    }
                    int n24 = (n7 += n9) + view.getMeasuredWidth();
                    int n25 = n13 + view.getMeasuredHeight();
                    view.layout(n7, n13, n24, n25);
                    ++n10;
                    break block20;
                }
                int n26 = n5;
                n5 = n7;
                n12 = n26;
            }
            ++n11;
            n7 = n5;
            n5 = n12;
        }
        int n27 = n3 - n5 - n7;
        n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.mTopPageBounds = n6;
                this.mBottomPageBounds = n4 - n8;
                this.mDecorChildCount = n10;
                if (this.mFirstLayout) {
                    ViewPager viewPager2 = this;
                    viewPager2.scrollToItem(viewPager2.mCurItem, false, 0, false);
                }
                this.mFirstLayout = false;
                return;
            }
            View view = this.getChildAt(n3);
            if (view.getVisibility() != 8) {
                ItemInfo itemInfo;
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.isDecor && (itemInfo = this.infoForChild(view)) != null) {
                    float f3 = n27;
                    int n28 = n5 + (int)(f3 * itemInfo.offset);
                    if (layoutParams.needsMeasure) {
                        layoutParams.needsMeasure = false;
                        int n29 = View.MeasureSpec.makeMeasureSpec((int)((int)(f3 * layoutParams.widthFactor)), (int)0x40000000);
                        view.measure(n29, View.MeasureSpec.makeMeasureSpec((int)(n4 - n6 - n8), (int)0x40000000));
                    }
                    int n30 = n28 + view.getMeasuredWidth();
                    int n31 = n6 + view.getMeasuredHeight();
                    view.layout(n28, n6, n30, n31);
                }
            }
            ++n3;
        }
    }

    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            ViewPager viewPager = this;
            int n2 = viewPager.getScrollY();
            int n3 = viewPager.mScroller.getCurrX();
            int n4 = this.mScroller.getCurrY();
            if (this.getScrollX() != n3 || n2 != n4) {
                this.scrollTo(n3, n4);
                if (!this.pageScrolled(n3)) {
                    ViewPager viewPager2 = this;
                    viewPager2.mScroller.abortAnimation();
                    viewPager2.scrollTo(0, n4);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll(true);
    }

    protected void onPageScrolled(int n2, float f3, int n3) {
        OnPageChangeListener onPageChangeListener;
        if (this.mDecorChildCount > 0) {
            ViewPager viewPager = this;
            int n4 = viewPager.getScrollX();
            int n5 = viewPager.getPaddingLeft();
            int n6 = viewPager.getPaddingRight();
            int n7 = viewPager.getWidth();
            int n8 = viewPager.getChildCount();
            for (int i3 = 0; i3 < n8; ++i3) {
                View view = this.getChildAt(i3);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.isDecor) continue;
                int n9 = layoutParams.gravity & 7;
                if (n9 != 1) {
                    if (n9 != 3) {
                        if (n9 != 5) {
                            n9 = n5;
                        } else {
                            int n10 = n6;
                            n6 = n7 - n6 - view.getMeasuredWidth();
                            n9 = n10 + view.getMeasuredWidth();
                            int n11 = n6;
                            n6 = n9;
                            n9 = n11;
                        }
                    } else {
                        n9 = n5 + view.getWidth();
                        int n12 = n5;
                        n5 = n9;
                        n9 = n12;
                    }
                } else {
                    n9 = Math.max((n7 - view.getMeasuredWidth()) / 2, n5);
                }
                n9 = n9 + n4 - view.getLeft();
                if (n9 == 0) continue;
                view.offsetLeftAndRight(n9);
            }
        }
        if ((onPageChangeListener = this.mOnPageChangeListener) != null) {
            onPageChangeListener.onPageScrolled(n2, f3, n3);
        }
        if ((onPageChangeListener = this.mInternalPageChangeListener) != null) {
            onPageChangeListener.onPageScrolled(n2, f3, n3);
        }
        if (this.mPageTransformer != null) {
            ViewPager viewPager = this;
            n2 = viewPager.getScrollX();
            int n13 = viewPager.getChildCount();
            for (n3 = 0; n3 < n13; ++n3) {
                onPageChangeListener = this.getChildAt(n3);
                if (((LayoutParams)onPageChangeListener.getLayoutParams()).isDecor) continue;
                float f4 = (float)(onPageChangeListener.getLeft() - n2) / (float)this.getClientWidth();
                this.mPageTransformer.transformPage((View)onPageChangeListener, f4);
            }
        }
        this.mCalledSuper = true;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction() & 0xFF;
        if (n2 != 3 && n2 != 1) {
            if (n2 != 0) {
                if (this.mIsBeingDragged) {
                    return true;
                }
                if (this.mIsUnableToDrag) {
                    return false;
                }
            }
            if (n2 != 0) {
                if (n2 != 2) {
                    if (n2 == 6) {
                        this.onSecondaryPointerUp(motionEvent);
                    }
                } else {
                    n2 = this.mActivePointerId;
                    if (n2 != -1) {
                        MotionEvent motionEvent2 = motionEvent;
                        n2 = MotionEventCompat.findPointerIndex(motionEvent2, n2);
                        float f3 = MotionEventCompat.getX(motionEvent2, n2);
                        float f4 = f3 - this.mLastMotionX;
                        float f5 = Math.abs(f4);
                        float f6 = MotionEventCompat.getY(motionEvent, n2);
                        float f7 = Math.abs(f6 - this.mInitialMotionY);
                        float f8 = f4 - 0.0f;
                        float f9 = f8 == 0.0f ? 0 : (f8 > 0.0f ? 1 : -1);
                        if (f9 != false) {
                            ViewPager viewPager = this;
                            if (!viewPager.isGutterDrag(viewPager.mLastMotionX, f4)) {
                                ViewPager viewPager2 = this;
                                int n3 = (int)f4;
                                int n4 = (int)f3;
                                int n5 = (int)f6;
                                if (viewPager2.canScroll((View)viewPager2, false, n3, n4, n5)) {
                                    ViewPager viewPager3 = this;
                                    viewPager3.mLastMotionX = f3;
                                    viewPager3.mLastMotionY = f6;
                                    viewPager3.mIsUnableToDrag = true;
                                    return false;
                                }
                            }
                        }
                        if (f5 > (float)this.mTouchSlop && f5 * 0.5f > f7) {
                            ViewPager viewPager = this;
                            viewPager.mIsBeingDragged = true;
                            viewPager.requestParentDisallowInterceptTouchEvent(true);
                            viewPager.setScrollState(1);
                            f5 = f9 > 0 ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                            this.mLastMotionX = f5;
                            this.mLastMotionY = f6;
                            this.setScrollingCacheEnabled(true);
                        } else if (f7 > (float)this.mTouchSlop) {
                            this.mIsUnableToDrag = true;
                        }
                        if (this.mIsBeingDragged && this.performDrag(f3)) {
                            ViewCompat.postInvalidateOnAnimation((View)this);
                        }
                    }
                }
            } else {
                float f10;
                ViewPager viewPager = this;
                ViewPager viewPager4 = this;
                ViewPager viewPager5 = this;
                viewPager5.mInitialMotionX = f10 = motionEvent.getX();
                viewPager5.mLastMotionX = f10;
                viewPager4.mInitialMotionY = f10 = motionEvent.getY();
                viewPager4.mLastMotionY = f10;
                viewPager.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, 0);
                viewPager.mIsUnableToDrag = false;
                viewPager.mScroller.computeScrollOffset();
                if (viewPager.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    ViewPager viewPager6 = this;
                    viewPager6.mScroller.abortAnimation();
                    viewPager6.mPopulatePending = false;
                    viewPager6.populate();
                    viewPager6.mIsBeingDragged = true;
                    viewPager6.requestParentDisallowInterceptTouchEvent(true);
                    viewPager6.setScrollState(1);
                } else {
                    this.completeScroll(false);
                    this.mIsBeingDragged = false;
                }
            }
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            ViewPager viewPager = this;
            viewPager.mVelocityTracker.addMovement(motionEvent);
            return viewPager.mIsBeingDragged;
        }
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        this.mActivePointerId = -1;
        motionEvent = this.mVelocityTracker;
        if (motionEvent != null) {
            motionEvent.recycle();
            this.mVelocityTracker = null;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mFakeDragging) {
            return true;
        }
        if (motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) {
            return false;
        }
        PagerAdapter pagerAdapter = this.mAdapter;
        if (pagerAdapter != null && pagerAdapter.getCount() != 0) {
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(motionEvent);
            int n2 = 0;
            switch (motionEvent.getAction() & 0xFF) {
                default: {
                    break;
                }
                case 6: {
                    MotionEvent motionEvent2 = motionEvent;
                    ViewPager viewPager = this;
                    viewPager.onSecondaryPointerUp(motionEvent);
                    this.mLastMotionX = MotionEventCompat.getX(motionEvent2, MotionEventCompat.findPointerIndex(motionEvent2, viewPager.mActivePointerId));
                    break;
                }
                case 5: {
                    MotionEvent motionEvent3 = motionEvent;
                    int n3 = MotionEventCompat.getActionIndex(motionEvent3);
                    this.mLastMotionX = MotionEventCompat.getX(motionEvent3, n3);
                    this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n3);
                    break;
                }
                case 3: {
                    if (!this.mIsBeingDragged) break;
                    ViewPager viewPager = this;
                    viewPager.scrollToItem(viewPager.mCurItem, true, 0, false);
                    viewPager.mActivePointerId = -1;
                    viewPager.endDrag();
                    n2 = viewPager.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                    break;
                }
                case 2: {
                    if (!this.mIsBeingDragged) {
                        float f3;
                        MotionEvent motionEvent4 = motionEvent;
                        int n4 = MotionEventCompat.findPointerIndex(motionEvent4, this.mActivePointerId);
                        float f4 = MotionEventCompat.getX(motionEvent4, n4);
                        float f5 = Math.abs(f4 - this.mLastMotionX);
                        float f6 = MotionEventCompat.getY(motionEvent, n4);
                        float f7 = Math.abs(f6 - this.mLastMotionY);
                        if (f3 > (float)this.mTouchSlop && f5 > f7) {
                            float f8;
                            float f9 = f4;
                            ViewPager viewPager = this;
                            viewPager.mIsBeingDragged = true;
                            viewPager.requestParentDisallowInterceptTouchEvent(true);
                            f4 = viewPager.mInitialMotionX;
                            f4 = f9 - f8 > 0.0f ? (f4 += (float)this.mTouchSlop) : (f4 -= (float)this.mTouchSlop);
                            ViewPager viewPager2 = this;
                            viewPager2.mLastMotionX = f4;
                            viewPager2.mLastMotionY = f6;
                            viewPager2.setScrollState(1);
                            viewPager2.setScrollingCacheEnabled(true);
                            ViewParent viewParent = viewPager2.getParent();
                            if (viewParent != null) {
                                viewParent.requestDisallowInterceptTouchEvent(true);
                            }
                        }
                    }
                    if (!this.mIsBeingDragged) break;
                    MotionEvent motionEvent5 = motionEvent;
                    n2 |= this.performDrag(MotionEventCompat.getX(motionEvent5, MotionEventCompat.findPointerIndex(motionEvent5, this.mActivePointerId)));
                    break;
                }
                case 1: {
                    if (!this.mIsBeingDragged) break;
                    ViewPager viewPager = this;
                    MotionEvent motionEvent6 = motionEvent;
                    ViewPager viewPager3 = this;
                    VelocityTracker velocityTracker = viewPager3.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    int n5 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
                    viewPager3.mPopulatePending = true;
                    n2 = viewPager3.getClientWidth();
                    int n6 = viewPager3.getScrollX();
                    ItemInfo itemInfo = viewPager3.infoForCurrentScrollPosition();
                    int n7 = n6;
                    n6 = itemInfo.position;
                    float f10 = ((float)n7 / (float)n2 - itemInfo.offset) / itemInfo.widthFactor;
                    int n8 = (int)(MotionEventCompat.getX(motionEvent6, MotionEventCompat.findPointerIndex(motionEvent6, viewPager3.mActivePointerId)) - this.mInitialMotionX);
                    viewPager.setCurrentItemInternal(viewPager.determineTargetPage(n6, f10, n5, n8), true, true, n5);
                    viewPager.mActivePointerId = -1;
                    viewPager.endDrag();
                    n2 = viewPager.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                    break;
                }
                case 0: {
                    float f11;
                    ViewPager viewPager = this;
                    ViewPager viewPager4 = this;
                    ViewPager viewPager5 = this;
                    viewPager5.mScroller.abortAnimation();
                    viewPager5.mPopulatePending = false;
                    viewPager5.populate();
                    viewPager4.mInitialMotionX = f11 = motionEvent.getX();
                    viewPager4.mLastMotionX = f11;
                    viewPager.mInitialMotionY = f11 = motionEvent.getY();
                    viewPager.mLastMotionY = f11;
                    this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, 0);
                }
            }
            if (n2 != 0) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
            return true;
        }
        return false;
    }

    public void draw(Canvas canvas) {
        PagerAdapter pagerAdapter;
        ViewPager viewPager = this;
        super.draw(canvas);
        int n2 = 0;
        int n3 = ViewCompat.getOverScrollMode((View)viewPager);
        if (n3 != 0 && (n3 != 1 || (pagerAdapter = this.mAdapter) == null || pagerAdapter.getCount() <= 1)) {
            ViewPager viewPager2 = this;
            viewPager2.mLeftEdge.finish();
            viewPager2.mRightEdge.finish();
            n3 = n2;
        } else {
            int n4;
            if (!this.mLeftEdge.isFinished()) {
                int n5 = n2;
                ViewPager viewPager3 = this;
                Canvas canvas2 = canvas;
                ViewPager viewPager4 = this;
                n2 = canvas.save();
                n3 = viewPager4.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                n4 = viewPager4.getWidth();
                canvas2.rotate(270.0f);
                canvas2.translate((float)(-n3 + this.getPaddingTop()), this.mFirstOffset * (float)n4);
                viewPager3.mLeftEdge.setSize(n3, n4);
                n3 = n5 | viewPager3.mLeftEdge.draw(canvas);
                canvas.restoreToCount(n2);
            } else {
                n3 = n2;
            }
            if (!this.mRightEdge.isFinished()) {
                int n6 = n3;
                ViewPager viewPager5 = this;
                ViewPager viewPager6 = this;
                n2 = canvas.save();
                n3 = viewPager6.getWidth();
                n4 = viewPager6.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), -(this.mLastOffset + 1.0f) * (float)n3);
                viewPager5.mRightEdge.setSize(n4, n3);
                n3 = n6 | viewPager5.mRightEdge.draw(canvas);
                canvas.restoreToCount(n2);
            }
        }
        if (n3 != 0) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void onDraw(Canvas canvas) {
        ViewPager viewPager = this;
        super.onDraw(canvas);
        if (viewPager.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            ViewPager viewPager2 = this;
            int n2 = viewPager2.getScrollX();
            int n3 = viewPager2.getWidth();
            float f3 = n3;
            float f4 = (float)viewPager2.mPageMargin / f3;
            int n4 = 0;
            ItemInfo itemInfo = viewPager2.mItems.get(0);
            float f5 = itemInfo.offset;
            int n5 = this.mItems.size();
            int n6 = viewPager2.mItems.get((int)(n5 - 1)).position;
            for (int i3 = itemInfo.position; i3 < n6; ++i3) {
                float f6;
                float f7;
                while (i3 > itemInfo.position && n4 < n5) {
                    itemInfo = this.mItems.get(++n4);
                }
                if (i3 == itemInfo.position) {
                    float f8 = itemInfo.offset + itemInfo.widthFactor;
                    f5 = f8 * f3;
                    f7 = f8 + f4;
                } else {
                    float f9 = f5;
                    f7 = this.mAdapter.getPageWidth(i3);
                    f5 = (f5 + f7) * f3;
                    f7 = f9 + (f7 + f4);
                }
                float f10 = f5 + (float)this.mPageMargin;
                if (f6 > (float)n2) {
                    ViewPager viewPager3 = this;
                    int n7 = (int)f5;
                    int n8 = this.mTopPageBounds;
                    int n9 = (int)(f10 + 0.5f);
                    int n10 = this.mBottomPageBounds;
                    viewPager3.mMarginDrawable.setBounds(n7, n8, n9, n10);
                    viewPager3.mMarginDrawable.draw(canvas);
                }
                if (f5 > (float)(n2 + n3)) break;
                f5 = f7;
            }
        }
    }

    public boolean beginFakeDrag() {
        if (this.mIsBeingDragged) {
            return false;
        }
        ViewPager viewPager = this;
        viewPager.mFakeDragging = true;
        viewPager.setScrollState(1);
        viewPager.mLastMotionX = 0.0f;
        viewPager.mInitialMotionX = 0.0f;
        VelocityTracker velocityTracker = viewPager.mVelocityTracker;
        if (velocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            velocityTracker.clear();
        }
        long l2 = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)l2, (long)l2, (int)0, (float)0.0f, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
        this.mFakeDragBeginTime = l2;
        return true;
    }

    public void endFakeDrag() {
        if (this.mFakeDragging) {
            ViewPager viewPager = this;
            VelocityTracker velocityTracker = viewPager.mVelocityTracker;
            velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
            int n2 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
            viewPager.mPopulatePending = true;
            int n3 = viewPager.getClientWidth();
            int n4 = viewPager.getScrollX();
            ItemInfo itemInfo = viewPager.infoForCurrentScrollPosition();
            float f3 = ((float)n4 / (float)n3 - itemInfo.offset) / itemInfo.widthFactor;
            int n5 = (int)(this.mLastMotionX - this.mInitialMotionX);
            viewPager.setCurrentItemInternal(viewPager.determineTargetPage(itemInfo.position, f3, n2, n5), true, true, n2);
            viewPager.endDrag();
            viewPager.mFakeDragging = false;
            return;
        }
        throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
    }

    public void fakeDragBy(float f3) {
        if (this.mFakeDragging) {
            ViewPager viewPager = this;
            viewPager.mLastMotionX += f3;
            f3 = (float)viewPager.getScrollX() - f3;
            float f4 = viewPager.getClientWidth();
            float f5 = f4 * this.mFirstOffset;
            float f6 = f4 * this.mLastOffset;
            ItemInfo itemInfo = viewPager.mItems.get(0);
            ArrayList<ItemInfo> arrayList = viewPager.mItems;
            ItemInfo itemInfo2 = arrayList.get(arrayList.size() - 1);
            if (itemInfo.position != 0) {
                f5 = itemInfo.offset * f4;
            }
            if (itemInfo2.position != this.mAdapter.getCount() - 1) {
                f6 = itemInfo2.offset * f4;
            }
            if (f3 < f5) {
                f6 = f5;
            } else if (!(f3 > f6)) {
                f6 = f3;
            }
            ViewPager viewPager2 = this;
            float f7 = f6;
            int n2 = (int)f7;
            viewPager2.mLastMotionX += f7 - (float)n2;
            viewPager2.scrollTo(n2, viewPager2.getScrollY());
            viewPager2.pageScrolled(n2);
            long l2 = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)viewPager2.mFakeDragBeginTime, (long)l2, (int)2, (float)this.mLastMotionX, (float)0.0f, (int)0);
            this.mVelocityTracker.addMovement(motionEvent);
            motionEvent.recycle();
            return;
        }
        throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    public boolean canScrollHorizontally(int n2) {
        if (this.mAdapter == null) {
            return false;
        }
        ViewPager viewPager = this;
        int n3 = viewPager.getClientWidth();
        int n4 = viewPager.getScrollX();
        if (n2 < 0) {
            return n4 > (int)((float)n3 * this.mFirstOffset);
        }
        if (n2 > 0) {
            return n4 < (int)((float)n3 * this.mLastOffset);
        }
        return false;
    }

    protected boolean canScroll(View view, boolean bl, int n2, int n3, int n4) {
        if (view instanceof ViewGroup) {
            View view2 = view;
            ViewGroup viewGroup = (ViewGroup)view2;
            int n5 = view2.getScrollX();
            int n6 = view2.getScrollY();
            for (int i3 = viewGroup.getChildCount() - 1; i3 >= 0; --i3) {
                int n7;
                int n8;
                int n9 = n3 + n5;
                View view3 = viewGroup.getChildAt(i3);
                if (n9 < view3.getLeft() || n9 >= view3.getRight() || (n8 = n4 + n6) < view3.getTop() || n8 >= view3.getBottom() || !this.canScroll(view3, true, n2, n7 = n9 - view3.getLeft(), n9 = n8 - view3.getTop())) continue;
                return true;
            }
        }
        return bl && ViewCompat.canScrollHorizontally(view, -n2);
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
    }

    public boolean executeKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getAction() == 0) {
            int n2 = keyEvent.getKeyCode();
            if (n2 != 21) {
                if (n2 != 22) {
                    if (n2 == 61 && Build.VERSION.SDK_INT >= 11) {
                        if (KeyEventCompat.hasNoModifiers(keyEvent)) {
                            bl = this.arrowScroll(2);
                        } else if (KeyEventCompat.hasModifiers(keyEvent, 1)) {
                            bl = this.arrowScroll(1);
                        }
                    }
                } else {
                    bl = this.arrowScroll(66);
                }
            } else {
                bl = this.arrowScroll(17);
            }
        }
        return bl;
    }

    public boolean arrowScroll(int n2) {
        ViewParent viewParent;
        View view;
        block17: {
            block16: {
                view = this.findFocus();
                if (view != this) break block16;
                view = null;
                break block17;
            }
            if (view == null) break block17;
            boolean bl = false;
            viewParent = view.getParent();
            block0: while (true) {
                block19: {
                    StringBuilder stringBuilder;
                    block18: {
                        if (!(viewParent instanceof ViewGroup)) break block18;
                        if (viewParent != this) break block19;
                        bl = true;
                    }
                    if (bl) break;
                    StringBuilder stringBuilder2 = stringBuilder;
                    stringBuilder2();
                    stringBuilder.append(view.getClass().getSimpleName());
                    view = view.getParent();
                    while (true) {
                        if (!(view instanceof ViewGroup)) {
                            Log.e((String)TAG, (String)("arrowScroll tried to find focus based on non-child current focused view " + stringBuilder2.toString()));
                            view = null;
                            break block0;
                        }
                        stringBuilder2.append(" => ").append(view.getClass().getSimpleName());
                        view = view.getParent();
                    }
                }
                viewParent = viewParent.getParent();
            }
        }
        int n3 = 0;
        viewParent = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view, n2);
        if (viewParent != null && viewParent != view) {
            if (n2 == 17) {
                ViewPager viewPager = this;
                n3 = viewPager.getChildRectInPagerCoordinates((Rect)viewPager.mTempRect, (View)viewParent).left;
                int n4 = viewPager.getChildRectInPagerCoordinates((Rect)viewPager.mTempRect, (View)view).left;
                n3 = view != null && n3 >= n4 ? (int)(this.pageLeft() ? 1 : 0) : (int)(viewParent.requestFocus() ? 1 : 0);
            } else if (n2 == 66) {
                ViewPager viewPager = this;
                n3 = viewPager.getChildRectInPagerCoordinates((Rect)viewPager.mTempRect, (View)viewParent).left;
                int n5 = viewPager.getChildRectInPagerCoordinates((Rect)viewPager.mTempRect, (View)view).left;
                n3 = view != null && n3 <= n5 ? (int)(this.pageRight() ? 1 : 0) : (int)(viewParent.requestFocus() ? 1 : 0);
            }
        } else if (n2 != 17 && n2 != 1) {
            if (n2 == 66 || n2 == 2) {
                n3 = this.pageRight();
            }
        } else {
            n3 = this.pageLeft();
        }
        if (n3 != 0) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)n2));
        }
        return n3 != 0;
    }

    boolean pageLeft() {
        int n2 = this.mCurItem;
        if (n2 > 0) {
            this.setCurrentItem(n2 - 1, true);
            return true;
        }
        return false;
    }

    boolean pageRight() {
        PagerAdapter pagerAdapter = this.mAdapter;
        if (pagerAdapter != null && this.mCurItem < pagerAdapter.getCount() - 1) {
            ViewPager viewPager = this;
            viewPager.setCurrentItem(viewPager.mCurItem + 1, true);
            return true;
        }
        return false;
    }

    public void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        int n4 = arrayList.size();
        int n5 = this.getDescendantFocusability();
        if (n5 != 393216) {
            for (int i3 = 0; i3 < this.getChildCount(); ++i3) {
                ItemInfo itemInfo;
                View view = this.getChildAt(i3);
                if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
                view.addFocusables(arrayList, n2, n3);
            }
        }
        if (n5 != 262144 || n4 == arrayList.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((n3 & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (arrayList != null) {
                arrayList.add((View)this);
            }
        }
    }

    public void addTouchables(ArrayList<View> arrayList) {
        int n2 = 0;
        while (n2 < this.getChildCount()) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n2);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem) {
                view.addTouchables(arrayList);
            }
            ++n2;
        }
        return;
    }

    protected boolean onRequestFocusInDescendants(int n2, Rect rect) {
        int n3;
        int n4;
        int n5 = this.getChildCount();
        if ((n2 & 2) != 0) {
            n4 = 0;
            n3 = 1;
        } else {
            n4 = n5 - 1;
            n3 = -1;
            n5 = -1;
        }
        while (n4 != n5) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n4);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.requestFocus(n2, rect)) {
                return true;
            }
            n4 += n3;
        }
        return false;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 4096) {
            return super.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    static interface Decor {
    }

    static class ItemInfo {
        Object object;
        int position;
        boolean scrolling;
        float widthFactor;
        float offset;

        ItemInfo() {
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public boolean isDecor;
        public int gravity;
        float widthFactor = 0.0f;
        boolean needsMeasure;
        int position;
        int childIndex;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.gravity = typedArray.getInteger(0, 48);
            typedArray.recycle();
        }
    }

    class MyAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        MyAccessibilityDelegate() {
        }

        private boolean canScroll() {
            return ViewPager.this.mAdapter != null && ViewPager.this.mAdapter.getCount() > 1;
        }

        @Override
        public void onInitializeAccessibilityEvent(View object, AccessibilityEvent accessibilityEvent) {
            AccessibilityEvent accessibilityEvent2 = accessibilityEvent;
            super.onInitializeAccessibilityEvent((View)object, accessibilityEvent);
            accessibilityEvent2.setClassName((CharSequence)ViewPager.class.getName());
            object = AccessibilityRecordCompat.obtain();
            ((AccessibilityRecordCompat)object).setScrollable(this.canScroll());
            if (accessibilityEvent2.getEventType() == 4096 && ViewPager.this.mAdapter != null) {
                ((AccessibilityRecordCompat)object).setItemCount(ViewPager.this.mAdapter.getCount());
                ((AccessibilityRecordCompat)object).setFromIndex(ViewPager.this.mCurItem);
                ((AccessibilityRecordCompat)object).setToIndex(ViewPager.this.mCurItem);
            }
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            accessibilityNodeInfoCompat.setClassName(ViewPager.class.getName());
            accessibilityNodeInfoCompat.setScrollable(this.canScroll());
            if (ViewPager.this.canScrollHorizontally(1)) {
                accessibilityNodeInfoCompat.addAction(4096);
            }
            if (ViewPager.this.canScrollHorizontally(-1)) {
                accessibilityNodeInfoCompat.addAction(8192);
            }
        }

        @Override
        public boolean performAccessibilityAction(View view, int n2, Bundle bundle) {
            if (super.performAccessibilityAction(view, n2, bundle)) {
                return true;
            }
            if (n2 != 4096) {
                if (n2 != 8192) {
                    return false;
                }
                if (ViewPager.this.canScrollHorizontally(-1)) {
                    ViewPager viewPager = ViewPager.this;
                    viewPager.setCurrentItem(viewPager.mCurItem - 1);
                    return true;
                }
                return false;
            }
            if (ViewPager.this.canScrollHorizontally(1)) {
                ViewPager viewPager = ViewPager.this;
                viewPager.setCurrentItem(viewPager.mCurItem + 1);
                return true;
            }
            return false;
        }
    }

    static interface OnAdapterChangeListener {
        public void onAdapterChanged(PagerAdapter var1, PagerAdapter var2);
    }

    public static interface OnPageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }

    public static interface PageTransformer {
        public void transformPage(View var1, float var2);
    }

    private class PagerObserver
    extends DataSetObserver {
        private PagerObserver() {
        }

        public void onChanged() {
            ViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            ViewPager.this.dataSetChanged();
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator(new ParcelableCompatCreatorCallbacks<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n2) {
                return new SavedState[n2];
            }
        });
        int position;
        Parcelable adapterState;
        ClassLoader loader;

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel);
            if (classLoader == null) {
                classLoader = SavedState.class.getClassLoader();
            }
            this.position = parcel.readInt();
            this.adapterState = parcel.readParcelable(classLoader);
            this.loader = classLoader;
        }

        public void writeToParcel(Parcel parcel, int n2) {
            SavedState savedState = this;
            super.writeToParcel(parcel, n2);
            parcel.writeInt(savedState.position);
            parcel.writeParcelable(this.adapterState, n2);
        }

        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + "}";
        }
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrolled(int n2, float f3, int n3) {
        }

        @Override
        public void onPageSelected(int n2) {
        }

        @Override
        public void onPageScrollStateChanged(int n2) {
        }
    }

    static class ViewPositionComparator
    implements Comparator<View> {
        ViewPositionComparator() {
        }

        @Override
        public int compare(View object, View view) {
            Object object2 = (LayoutParams)object.getLayoutParams();
            object = (LayoutParams)view.getLayoutParams();
            boolean bl = ((LayoutParams)((Object)object2)).isDecor;
            if (bl != object.isDecor) {
                return bl ? 1 : -1;
            }
            return ((LayoutParams)((Object)object2)).position - object.position;
        }
    }
}

