/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.support.v4.view.accessibility;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import com.google.android.support.v4.view.accessibility.AccessibilityNodeInfoCompatIcs;
import com.google.android.support.v4.view.accessibility.AccessibilityNodeInfoCompatJellyBean;
import com.google.android.support.v4.view.accessibility.AccessibilityNodeInfoCompatJellybeanMr2;
import com.google.android.support.v4.view.accessibility.AccessibilityNodeInfoCompatKitKat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessibilityNodeInfoCompat {
    private static final AccessibilityNodeInfoImpl IMPL;
    public static final int ACTION_FOCUS = 1;
    public static final int ACTION_CLEAR_FOCUS = 2;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_CLEAR_SELECTION = 8;
    public static final int ACTION_CLICK = 16;
    public static final int ACTION_LONG_CLICK = 32;
    public static final int ACTION_ACCESSIBILITY_FOCUS = 64;
    public static final int ACTION_CLEAR_ACCESSIBILITY_FOCUS = 128;
    public static final int ACTION_NEXT_AT_MOVEMENT_GRANULARITY = 256;
    public static final int ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = 512;
    public static final int ACTION_NEXT_HTML_ELEMENT = 1024;
    public static final int ACTION_PREVIOUS_HTML_ELEMENT = 2048;
    public static final int ACTION_SCROLL_FORWARD = 4096;
    public static final int ACTION_SCROLL_BACKWARD = 8192;
    public static final int ACTION_COPY = 16384;
    public static final int ACTION_PASTE = 32768;
    public static final int ACTION_CUT = 65536;
    public static final int ACTION_SET_SELECTION = 131072;
    public static final String ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT = "ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT";
    public static final String ACTION_ARGUMENT_HTML_ELEMENT_STRING = "ACTION_ARGUMENT_HTML_ELEMENT_STRING";
    public static final String ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN = "ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN";
    public static final String ACTION_ARGUMENT_SELECTION_START_INT = "ACTION_ARGUMENT_SELECTION_START_INT";
    public static final String ACTION_ARGUMENT_SELECTION_END_INT = "ACTION_ARGUMENT_SELECTION_END_INT";
    public static final int FOCUS_INPUT = 1;
    public static final int FOCUS_ACCESSIBILITY = 2;
    public static final int MOVEMENT_GRANULARITY_CHARACTER = 1;
    public static final int MOVEMENT_GRANULARITY_WORD = 2;
    public static final int MOVEMENT_GRANULARITY_LINE = 4;
    public static final int MOVEMENT_GRANULARITY_PARAGRAPH = 8;
    public static final int MOVEMENT_GRANULARITY_PAGE = 16;
    private final Object mInfo;

    static {
        int n2 = Build.VERSION.SDK_INT;
        IMPL = n2 >= 19 ? new AccessibilityNodeInfoKitKatImpl() : (n2 >= 18 ? new AccessibilityNodeInfoJellybeanMr2Impl() : (n2 >= 16 ? new AccessibilityNodeInfoJellybeanImpl() : (n2 >= 14 ? new AccessibilityNodeInfoIcsImpl() : new AccessibilityNodeInfoStubImpl())));
    }

    static AccessibilityNodeInfoCompat wrapNonNullInstance(Object object) {
        if (object != null) {
            return new AccessibilityNodeInfoCompat(object);
        }
        return null;
    }

    public AccessibilityNodeInfoCompat(Object object) {
        this.mInfo = object;
    }

    public static AccessibilityNodeInfoCompat obtain(View view) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(view));
    }

    public static AccessibilityNodeInfoCompat obtain(View view, int n2) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(view, n2));
    }

    public static AccessibilityNodeInfoCompat obtain() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain());
    }

    public static AccessibilityNodeInfoCompat obtain(AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(accessibilityNodeInfoCompat.mInfo));
    }

    private static String getActionSymbolicName(int n2) {
        switch (n2) {
            default: {
                return "ACTION_UNKNOWN";
            }
            case 131072: {
                return "ACTION_SET_SELECTION";
            }
            case 65536: {
                return "ACTION_CUT";
            }
            case 32768: {
                return "ACTION_PASTE";
            }
            case 16384: {
                return "ACTION_COPY";
            }
            case 8192: {
                return "ACTION_SCROLL_BACKWARD";
            }
            case 4096: {
                return "ACTION_SCROLL_FORWARD";
            }
            case 2048: {
                return "ACTION_PREVIOUS_HTML_ELEMENT";
            }
            case 1024: {
                return "ACTION_NEXT_HTML_ELEMENT";
            }
            case 512: {
                return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
            }
            case 256: {
                return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
            }
            case 128: {
                return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
            }
            case 64: {
                return "ACTION_ACCESSIBILITY_FOCUS";
            }
            case 32: {
                return "ACTION_LONG_CLICK";
            }
            case 16: {
                return "ACTION_CLICK";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 1: 
        }
        return "ACTION_FOCUS";
    }

    public Object getInfo() {
        return this.mInfo;
    }

    public void setSource(View view) {
        IMPL.setSource(this.mInfo, view);
    }

    public void setSource(View view, int n2) {
        IMPL.setSource(this.mInfo, view, n2);
    }

    public AccessibilityNodeInfoCompat findFocus(int n2) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.findFocus(this.mInfo, n2));
    }

    public AccessibilityNodeInfoCompat focusSearch(int n2) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.focusSearch(this.mInfo, n2));
    }

    public int getWindowId() {
        return IMPL.getWindowId(this.mInfo);
    }

    public int getChildCount() {
        return IMPL.getChildCount(this.mInfo);
    }

    public AccessibilityNodeInfoCompat getChild(int n2) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getChild(this.mInfo, n2));
    }

    public void addChild(View view) {
        IMPL.addChild(this.mInfo, view);
    }

    public void addChild(View view, int n2) {
        IMPL.addChild(this.mInfo, view, n2);
    }

    public int getActions() {
        return IMPL.getActions(this.mInfo);
    }

    public void addAction(int n2) {
        IMPL.addAction(this.mInfo, n2);
    }

    public boolean performAction(int n2) {
        return IMPL.performAction(this.mInfo, n2);
    }

    public boolean performAction(int n2, Bundle bundle) {
        return IMPL.performAction(this.mInfo, n2, bundle);
    }

    public void setMovementGranularities(int n2) {
        IMPL.setMovementGranularities(this.mInfo, n2);
    }

    public int getMovementGranularities() {
        return IMPL.getMovementGranularities(this.mInfo);
    }

    public List<AccessibilityNodeInfoCompat> findAccessibilityNodeInfosByText(String string2) {
        ArrayList<AccessibilityNodeInfoCompat> arrayList;
        ArrayList<AccessibilityNodeInfoCompat> arrayList2 = arrayList;
        arrayList = new ArrayList<AccessibilityNodeInfoCompat>();
        List<Object> list = IMPL.findAccessibilityNodeInfosByText(((AccessibilityNodeInfoCompat)((Object)list)).mInfo, string2);
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            AccessibilityNodeInfoCompat accessibilityNodeInfoCompat;
            Object e3 = list.get(n3);
            AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = accessibilityNodeInfoCompat;
            accessibilityNodeInfoCompat = new AccessibilityNodeInfoCompat(e3);
            arrayList2.add(accessibilityNodeInfoCompat2);
            ++n3;
        }
        return arrayList2;
    }

    public AccessibilityNodeInfoCompat getParent() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getParent(this.mInfo));
    }

    public void setParent(View view) {
        IMPL.setParent(this.mInfo, view);
    }

    public void setParent(View view, int n2) {
        IMPL.setParent(this.mInfo, view, n2);
    }

    public void getBoundsInParent(Rect rect) {
        IMPL.getBoundsInParent(this.mInfo, rect);
    }

    public void setBoundsInParent(Rect rect) {
        IMPL.setBoundsInParent(this.mInfo, rect);
    }

    public void getBoundsInScreen(Rect rect) {
        IMPL.getBoundsInScreen(this.mInfo, rect);
    }

    public void setBoundsInScreen(Rect rect) {
        IMPL.setBoundsInScreen(this.mInfo, rect);
    }

    public boolean isCheckable() {
        return IMPL.isCheckable(this.mInfo);
    }

    public void setCheckable(boolean bl) {
        IMPL.setCheckable(this.mInfo, bl);
    }

    public boolean isChecked() {
        return IMPL.isChecked(this.mInfo);
    }

    public void setChecked(boolean bl) {
        IMPL.setChecked(this.mInfo, bl);
    }

    public boolean isFocusable() {
        return IMPL.isFocusable(this.mInfo);
    }

    public void setFocusable(boolean bl) {
        IMPL.setFocusable(this.mInfo, bl);
    }

    public boolean isFocused() {
        return IMPL.isFocused(this.mInfo);
    }

    public void setFocused(boolean bl) {
        IMPL.setFocused(this.mInfo, bl);
    }

    public boolean isVisibleToUser() {
        return IMPL.isVisibleToUser(this.mInfo);
    }

    public void setVisibleToUser(boolean bl) {
        IMPL.setVisibleToUser(this.mInfo, bl);
    }

    public boolean isAccessibilityFocused() {
        return IMPL.isAccessibilityFocused(this.mInfo);
    }

    public void setAccessibilityFocused(boolean bl) {
        IMPL.setAccessibilityFocused(this.mInfo, bl);
    }

    public boolean isSelected() {
        return IMPL.isSelected(this.mInfo);
    }

    public void setSelected(boolean bl) {
        IMPL.setSelected(this.mInfo, bl);
    }

    public boolean isClickable() {
        return IMPL.isClickable(this.mInfo);
    }

    public void setClickable(boolean bl) {
        IMPL.setClickable(this.mInfo, bl);
    }

    public boolean isLongClickable() {
        return IMPL.isLongClickable(this.mInfo);
    }

    public void setLongClickable(boolean bl) {
        IMPL.setLongClickable(this.mInfo, bl);
    }

    public boolean isEnabled() {
        return IMPL.isEnabled(this.mInfo);
    }

    public void setEnabled(boolean bl) {
        IMPL.setEnabled(this.mInfo, bl);
    }

    public boolean isPassword() {
        return IMPL.isPassword(this.mInfo);
    }

    public void setPassword(boolean bl) {
        IMPL.setPassword(this.mInfo, bl);
    }

    public boolean isScrollable() {
        return IMPL.isScrollable(this.mInfo);
    }

    public void setScrollable(boolean bl) {
        IMPL.setScrollable(this.mInfo, bl);
    }

    public CharSequence getPackageName() {
        return IMPL.getPackageName(this.mInfo);
    }

    public void setPackageName(CharSequence charSequence) {
        IMPL.setPackageName(this.mInfo, charSequence);
    }

    public CharSequence getClassName() {
        return IMPL.getClassName(this.mInfo);
    }

    public void setClassName(CharSequence charSequence) {
        IMPL.setClassName(this.mInfo, charSequence);
    }

    public CharSequence getText() {
        return IMPL.getText(this.mInfo);
    }

    public void setText(CharSequence charSequence) {
        IMPL.setText(this.mInfo, charSequence);
    }

    public CharSequence getContentDescription() {
        return IMPL.getContentDescription(this.mInfo);
    }

    public void setContentDescription(CharSequence charSequence) {
        IMPL.setContentDescription(this.mInfo, charSequence);
    }

    public void recycle() {
        IMPL.recycle(this.mInfo);
    }

    public void setViewIdResourceName(String string2) {
        IMPL.setViewIdResourceName(this.mInfo, string2);
    }

    public String getViewIdResourceName() {
        return IMPL.getViewIdResourceName(this.mInfo);
    }

    public int getLiveRegion() {
        return IMPL.getLiveRegion(this.mInfo);
    }

    public void setLiveRegion(int n2) {
        IMPL.setLiveRegion(this.mInfo, n2);
    }

    public int hashCode() {
        Object object = ((AccessibilityNodeInfoCompat)object).mInfo;
        return object == null ? 0 : object.hashCode();
    }

    public boolean equals(Object object) {
        if (accessibilityNodeInfoCompat2 == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (AccessibilityNodeInfoCompat.class != object.getClass()) {
            return false;
        }
        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat = accessibilityNodeInfoCompat2;
        AccessibilityNodeInfoCompat accessibilityNodeInfoCompat2 = (AccessibilityNodeInfoCompat)object;
        object = accessibilityNodeInfoCompat.mInfo;
        return !(object == null ? accessibilityNodeInfoCompat2.mInfo != null : !object.equals(accessibilityNodeInfoCompat2.mInfo));
    }

    public String toString() {
        Rect rect;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder2.append(super.toString());
        Rect rect2 = rect;
        this.getBoundsInParent(new Rect());
        stringBuilder2.append("; boundsInParent: " + rect2);
        this.getBoundsInScreen(rect2);
        stringBuilder.append("; boundsInScreen: " + rect2);
        stringBuilder.append("; packageName: ").append(this.getPackageName());
        stringBuilder.append("; className: ").append(this.getClassName());
        stringBuilder.append("; text: ").append(this.getText());
        stringBuilder.append("; contentDescription: ").append(this.getContentDescription());
        stringBuilder.append("; viewId: ").append(this.getViewIdResourceName());
        stringBuilder.append("; checkable: ").append(this.isCheckable());
        stringBuilder.append("; checked: ").append(this.isChecked());
        stringBuilder.append("; focusable: ").append(this.isFocusable());
        stringBuilder.append("; focused: ").append(this.isFocused());
        stringBuilder.append("; selected: ").append(this.isSelected());
        stringBuilder.append("; clickable: ").append(this.isClickable());
        stringBuilder.append("; longClickable: ").append(this.isLongClickable());
        stringBuilder.append("; enabled: ").append(this.isEnabled());
        stringBuilder.append("; password: ").append(this.isPassword());
        stringBuilder.append("; scrollable: " + this.isScrollable());
        stringBuilder.append("; [");
        int n2 = this.getActions();
        while (true) {
            if (n2 == 0) {
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.append("]");
                return stringBuilder3.toString();
            }
            int n3 = n2;
            n2 = 1 << Integer.numberOfTrailingZeros(n3);
            int n4 = n3 & ~n2;
            stringBuilder2.append(AccessibilityNodeInfoCompat.getActionSymbolicName(n2));
            if (n4 != 0) {
                stringBuilder2.append(", ");
            }
            n2 = n4;
        }
    }

    static class AccessibilityNodeInfoIcsImpl
    extends AccessibilityNodeInfoStubImpl {
        AccessibilityNodeInfoIcsImpl() {
        }

        @Override
        public Object obtain() {
            return AccessibilityNodeInfoCompatIcs.obtain();
        }

        @Override
        public Object obtain(View view) {
            return AccessibilityNodeInfoCompatIcs.obtain(view);
        }

        @Override
        public Object obtain(Object object) {
            return AccessibilityNodeInfoCompatIcs.obtain(object);
        }

        @Override
        public void addAction(Object object, int n2) {
            AccessibilityNodeInfoCompatIcs.addAction(object, n2);
        }

        @Override
        public void addChild(Object object, View view) {
            AccessibilityNodeInfoCompatIcs.addChild(object, view);
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByText(Object object, String string2) {
            return AccessibilityNodeInfoCompatIcs.findAccessibilityNodeInfosByText(object, string2);
        }

        @Override
        public int getActions(Object object) {
            return AccessibilityNodeInfoCompatIcs.getActions(object);
        }

        @Override
        public void getBoundsInParent(Object object, Rect rect) {
            AccessibilityNodeInfoCompatIcs.getBoundsInParent(object, rect);
        }

        @Override
        public void getBoundsInScreen(Object object, Rect rect) {
            AccessibilityNodeInfoCompatIcs.getBoundsInScreen(object, rect);
        }

        @Override
        public Object getChild(Object object, int n2) {
            return AccessibilityNodeInfoCompatIcs.getChild(object, n2);
        }

        @Override
        public int getChildCount(Object object) {
            return AccessibilityNodeInfoCompatIcs.getChildCount(object);
        }

        @Override
        public CharSequence getClassName(Object object) {
            return AccessibilityNodeInfoCompatIcs.getClassName(object);
        }

        @Override
        public CharSequence getContentDescription(Object object) {
            return AccessibilityNodeInfoCompatIcs.getContentDescription(object);
        }

        @Override
        public CharSequence getPackageName(Object object) {
            return AccessibilityNodeInfoCompatIcs.getPackageName(object);
        }

        @Override
        public Object getParent(Object object) {
            return AccessibilityNodeInfoCompatIcs.getParent(object);
        }

        @Override
        public CharSequence getText(Object object) {
            return AccessibilityNodeInfoCompatIcs.getText(object);
        }

        @Override
        public int getWindowId(Object object) {
            return AccessibilityNodeInfoCompatIcs.getWindowId(object);
        }

        @Override
        public boolean isCheckable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isCheckable(object);
        }

        @Override
        public boolean isChecked(Object object) {
            return AccessibilityNodeInfoCompatIcs.isChecked(object);
        }

        @Override
        public boolean isClickable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isClickable(object);
        }

        @Override
        public boolean isEnabled(Object object) {
            return AccessibilityNodeInfoCompatIcs.isEnabled(object);
        }

        @Override
        public boolean isFocusable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isFocusable(object);
        }

        @Override
        public boolean isFocused(Object object) {
            return AccessibilityNodeInfoCompatIcs.isFocused(object);
        }

        @Override
        public boolean isLongClickable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isLongClickable(object);
        }

        @Override
        public boolean isPassword(Object object) {
            return AccessibilityNodeInfoCompatIcs.isPassword(object);
        }

        @Override
        public boolean isScrollable(Object object) {
            return AccessibilityNodeInfoCompatIcs.isScrollable(object);
        }

        @Override
        public boolean isSelected(Object object) {
            return AccessibilityNodeInfoCompatIcs.isSelected(object);
        }

        @Override
        public boolean performAction(Object object, int n2) {
            return AccessibilityNodeInfoCompatIcs.performAction(object, n2);
        }

        @Override
        public void setBoundsInParent(Object object, Rect rect) {
            AccessibilityNodeInfoCompatIcs.setBoundsInParent(object, rect);
        }

        @Override
        public void setBoundsInScreen(Object object, Rect rect) {
            AccessibilityNodeInfoCompatIcs.setBoundsInScreen(object, rect);
        }

        @Override
        public void setCheckable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setCheckable(object, bl);
        }

        @Override
        public void setChecked(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setChecked(object, bl);
        }

        @Override
        public void setClassName(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatIcs.setClassName(object, charSequence);
        }

        @Override
        public void setClickable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setClickable(object, bl);
        }

        @Override
        public void setContentDescription(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatIcs.setContentDescription(object, charSequence);
        }

        @Override
        public void setEnabled(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setEnabled(object, bl);
        }

        @Override
        public void setFocusable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setFocusable(object, bl);
        }

        @Override
        public void setFocused(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setFocused(object, bl);
        }

        @Override
        public void setLongClickable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setLongClickable(object, bl);
        }

        @Override
        public void setPackageName(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatIcs.setPackageName(object, charSequence);
        }

        @Override
        public void setParent(Object object, View view) {
            AccessibilityNodeInfoCompatIcs.setParent(object, view);
        }

        @Override
        public void setPassword(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setPassword(object, bl);
        }

        @Override
        public void setScrollable(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setScrollable(object, bl);
        }

        @Override
        public void setSelected(Object object, boolean bl) {
            AccessibilityNodeInfoCompatIcs.setSelected(object, bl);
        }

        @Override
        public void setSource(Object object, View view) {
            AccessibilityNodeInfoCompatIcs.setSource(object, view);
        }

        @Override
        public void setText(Object object, CharSequence charSequence) {
            AccessibilityNodeInfoCompatIcs.setText(object, charSequence);
        }

        @Override
        public void recycle(Object object) {
            AccessibilityNodeInfoCompatIcs.recycle(object);
        }
    }

    static interface AccessibilityNodeInfoImpl {
        public Object obtain();

        public Object obtain(View var1);

        public Object obtain(Object var1);

        public Object obtain(View var1, int var2);

        public void setSource(Object var1, View var2);

        public void setSource(Object var1, View var2, int var3);

        public Object findFocus(Object var1, int var2);

        public Object focusSearch(Object var1, int var2);

        public int getWindowId(Object var1);

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public void addChild(Object var1, View var2);

        public void addChild(Object var1, View var2, int var3);

        public int getActions(Object var1);

        public void addAction(Object var1, int var2);

        public boolean performAction(Object var1, int var2);

        public boolean performAction(Object var1, int var2, Bundle var3);

        public void setMovementGranularities(Object var1, int var2);

        public int getMovementGranularities(Object var1);

        public List<Object> findAccessibilityNodeInfosByText(Object var1, String var2);

        public Object getParent(Object var1);

        public void setParent(Object var1, View var2, int var3);

        public void setParent(Object var1, View var2);

        public void getBoundsInParent(Object var1, Rect var2);

        public void setBoundsInParent(Object var1, Rect var2);

        public void getBoundsInScreen(Object var1, Rect var2);

        public void setBoundsInScreen(Object var1, Rect var2);

        public boolean isCheckable(Object var1);

        public void setCheckable(Object var1, boolean var2);

        public boolean isChecked(Object var1);

        public void setChecked(Object var1, boolean var2);

        public boolean isFocusable(Object var1);

        public void setFocusable(Object var1, boolean var2);

        public boolean isFocused(Object var1);

        public void setFocused(Object var1, boolean var2);

        public boolean isVisibleToUser(Object var1);

        public void setVisibleToUser(Object var1, boolean var2);

        public boolean isAccessibilityFocused(Object var1);

        public void setAccessibilityFocused(Object var1, boolean var2);

        public boolean isSelected(Object var1);

        public void setSelected(Object var1, boolean var2);

        public boolean isClickable(Object var1);

        public void setClickable(Object var1, boolean var2);

        public boolean isLongClickable(Object var1);

        public void setLongClickable(Object var1, boolean var2);

        public boolean isEnabled(Object var1);

        public void setEnabled(Object var1, boolean var2);

        public boolean isPassword(Object var1);

        public void setPassword(Object var1, boolean var2);

        public boolean isScrollable(Object var1);

        public void setScrollable(Object var1, boolean var2);

        public CharSequence getPackageName(Object var1);

        public void setPackageName(Object var1, CharSequence var2);

        public CharSequence getClassName(Object var1);

        public void setClassName(Object var1, CharSequence var2);

        public CharSequence getText(Object var1);

        public void setText(Object var1, CharSequence var2);

        public CharSequence getContentDescription(Object var1);

        public void setContentDescription(Object var1, CharSequence var2);

        public void recycle(Object var1);

        public String getViewIdResourceName(Object var1);

        public void setViewIdResourceName(Object var1, String var2);

        public int getLiveRegion(Object var1);

        public void setLiveRegion(Object var1, int var2);
    }

    static class AccessibilityNodeInfoJellybeanImpl
    extends AccessibilityNodeInfoIcsImpl {
        AccessibilityNodeInfoJellybeanImpl() {
        }

        @Override
        public Object obtain(View view, int n2) {
            return AccessibilityNodeInfoCompatJellyBean.obtain(view, n2);
        }

        @Override
        public Object findFocus(Object object, int n2) {
            return AccessibilityNodeInfoCompatJellyBean.findFocus(object, n2);
        }

        @Override
        public Object focusSearch(Object object, int n2) {
            return AccessibilityNodeInfoCompatJellyBean.focusSearch(object, n2);
        }

        @Override
        public void addChild(Object object, View view, int n2) {
            AccessibilityNodeInfoCompatJellyBean.addChild(object, view, n2);
        }

        @Override
        public void setSource(Object object, View view, int n2) {
            AccessibilityNodeInfoCompatJellyBean.setSource(object, view, n2);
        }

        @Override
        public boolean isVisibleToUser(Object object) {
            return AccessibilityNodeInfoCompatJellyBean.isVisibleToUser(object);
        }

        @Override
        public void setVisibleToUser(Object object, boolean bl) {
            AccessibilityNodeInfoCompatJellyBean.setVisibleToUser(object, bl);
        }

        @Override
        public boolean isAccessibilityFocused(Object object) {
            return AccessibilityNodeInfoCompatJellyBean.isAccessibilityFocused(object);
        }

        @Override
        public void setAccessibilityFocused(Object object, boolean bl) {
            AccessibilityNodeInfoCompatJellyBean.setAccesibilityFocused(object, bl);
        }

        @Override
        public boolean performAction(Object object, int n2, Bundle bundle) {
            return AccessibilityNodeInfoCompatJellyBean.performAction(object, n2, bundle);
        }

        @Override
        public void setMovementGranularities(Object object, int n2) {
            AccessibilityNodeInfoCompatJellyBean.setMovementGranularities(object, n2);
        }

        @Override
        public int getMovementGranularities(Object object) {
            return AccessibilityNodeInfoCompatJellyBean.getMovementGranularities(object);
        }

        @Override
        public void setParent(Object object, View view, int n2) {
            AccessibilityNodeInfoCompatJellyBean.setParent(object, view, n2);
        }
    }

    static class AccessibilityNodeInfoJellybeanMr2Impl
    extends AccessibilityNodeInfoJellybeanImpl {
        AccessibilityNodeInfoJellybeanMr2Impl() {
        }

        @Override
        public String getViewIdResourceName(Object object) {
            return AccessibilityNodeInfoCompatJellybeanMr2.getViewIdResourceName(object);
        }

        @Override
        public void setViewIdResourceName(Object object, String string2) {
            AccessibilityNodeInfoCompatJellybeanMr2.setViewIdResourceName(object, string2);
        }
    }

    static class AccessibilityNodeInfoKitKatImpl
    extends AccessibilityNodeInfoJellybeanMr2Impl {
        AccessibilityNodeInfoKitKatImpl() {
        }

        @Override
        public int getLiveRegion(Object object) {
            return AccessibilityNodeInfoCompatKitKat.getLiveRegion(object);
        }

        @Override
        public void setLiveRegion(Object object, int n2) {
            AccessibilityNodeInfoCompatKitKat.setLiveRegion(object, n2);
        }
    }

    static class AccessibilityNodeInfoStubImpl
    implements AccessibilityNodeInfoImpl {
        AccessibilityNodeInfoStubImpl() {
        }

        @Override
        public Object obtain() {
            return null;
        }

        @Override
        public Object obtain(View view) {
            return null;
        }

        @Override
        public Object obtain(View view, int n2) {
            return null;
        }

        @Override
        public Object obtain(Object object) {
            return null;
        }

        @Override
        public void addAction(Object object, int n2) {
        }

        @Override
        public void addChild(Object object, View view) {
        }

        @Override
        public void addChild(Object object, View view, int n2) {
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByText(Object object, String string2) {
            return Collections.emptyList();
        }

        @Override
        public int getActions(Object object) {
            return 0;
        }

        @Override
        public void getBoundsInParent(Object object, Rect rect) {
        }

        @Override
        public void getBoundsInScreen(Object object, Rect rect) {
        }

        @Override
        public Object getChild(Object object, int n2) {
            return null;
        }

        @Override
        public int getChildCount(Object object) {
            return 0;
        }

        @Override
        public CharSequence getClassName(Object object) {
            return null;
        }

        @Override
        public CharSequence getContentDescription(Object object) {
            return null;
        }

        @Override
        public CharSequence getPackageName(Object object) {
            return null;
        }

        @Override
        public Object getParent(Object object) {
            return null;
        }

        @Override
        public CharSequence getText(Object object) {
            return null;
        }

        @Override
        public int getWindowId(Object object) {
            return 0;
        }

        @Override
        public boolean isCheckable(Object object) {
            return false;
        }

        @Override
        public boolean isChecked(Object object) {
            return false;
        }

        @Override
        public boolean isClickable(Object object) {
            return false;
        }

        @Override
        public boolean isEnabled(Object object) {
            return false;
        }

        @Override
        public boolean isFocusable(Object object) {
            return false;
        }

        @Override
        public boolean isFocused(Object object) {
            return false;
        }

        @Override
        public boolean isVisibleToUser(Object object) {
            return false;
        }

        @Override
        public boolean isAccessibilityFocused(Object object) {
            return false;
        }

        @Override
        public boolean isLongClickable(Object object) {
            return false;
        }

        @Override
        public boolean isPassword(Object object) {
            return false;
        }

        @Override
        public boolean isScrollable(Object object) {
            return false;
        }

        @Override
        public boolean isSelected(Object object) {
            return false;
        }

        @Override
        public boolean performAction(Object object, int n2) {
            return false;
        }

        @Override
        public boolean performAction(Object object, int n2, Bundle bundle) {
            return false;
        }

        @Override
        public void setMovementGranularities(Object object, int n2) {
        }

        @Override
        public int getMovementGranularities(Object object) {
            return 0;
        }

        @Override
        public void setBoundsInParent(Object object, Rect rect) {
        }

        @Override
        public void setBoundsInScreen(Object object, Rect rect) {
        }

        @Override
        public void setCheckable(Object object, boolean bl) {
        }

        @Override
        public void setChecked(Object object, boolean bl) {
        }

        @Override
        public void setClassName(Object object, CharSequence charSequence) {
        }

        @Override
        public void setClickable(Object object, boolean bl) {
        }

        @Override
        public void setContentDescription(Object object, CharSequence charSequence) {
        }

        @Override
        public void setEnabled(Object object, boolean bl) {
        }

        @Override
        public void setFocusable(Object object, boolean bl) {
        }

        @Override
        public void setFocused(Object object, boolean bl) {
        }

        @Override
        public void setVisibleToUser(Object object, boolean bl) {
        }

        @Override
        public void setAccessibilityFocused(Object object, boolean bl) {
        }

        @Override
        public void setLongClickable(Object object, boolean bl) {
        }

        @Override
        public void setPackageName(Object object, CharSequence charSequence) {
        }

        @Override
        public void setParent(Object object, View view) {
        }

        @Override
        public void setPassword(Object object, boolean bl) {
        }

        @Override
        public void setScrollable(Object object, boolean bl) {
        }

        @Override
        public void setSelected(Object object, boolean bl) {
        }

        @Override
        public void setSource(Object object, View view) {
        }

        @Override
        public void setSource(Object object, View view, int n2) {
        }

        @Override
        public Object findFocus(Object object, int n2) {
            return null;
        }

        @Override
        public Object focusSearch(Object object, int n2) {
            return null;
        }

        @Override
        public void setText(Object object, CharSequence charSequence) {
        }

        @Override
        public void recycle(Object object) {
        }

        @Override
        public void setParent(Object object, View view, int n2) {
        }

        @Override
        public String getViewIdResourceName(Object object) {
            return null;
        }

        @Override
        public void setViewIdResourceName(Object object, String string2) {
        }

        @Override
        public int getLiveRegion(Object object) {
            return 0;
        }

        @Override
        public void setLiveRegion(Object object, int n2) {
        }
    }
}

