/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.datahub;

import com.baidu.datahub.BDLog;
import com.baidu.datahub.ShareLocationInfo;
import com.baidu.datahub.protocol.OrderInfoProtocol;
import com.baidu.datahub.protocol.ShareLocationInfoProtocol;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class BDCache {
    private static final int protocol_type_one = 1;
    private static final int protocol_type_two = 2;
    private static final String TAG = "BDCache";
    private static int MAX_SIZE = 60;
    private CopyOnWriteArrayList<ShareLocationInfo> list;
    private OrderInfoProtocol mParentOrderInfo;

    public BDCache(OrderInfoProtocol orderInfoProtocol) {
        CopyOnWriteArrayList copyOnWriteArrayList;
        CopyOnWriteArrayList copyOnWriteArrayList2 = copyOnWriteArrayList;
        copyOnWriteArrayList = new CopyOnWriteArrayList();
        v1.list = copyOnWriteArrayList2;
        v1.mParentOrderInfo = orderInfoProtocol;
    }

    private String getOrderStatsStr(List<? extends OrderInfoProtocol> object) {
        Object object2 = ((BDCache)object2).mParentOrderInfo;
        if (object2 != null && 1 == ((OrderInfoProtocol)object2).orderType) {
            return "10";
        }
        if (object != null && object.size() > 0) {
            StringBuilder stringBuilder;
            object2 = object.iterator();
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            while (object2.hasNext()) {
                OrderInfoProtocol orderInfoProtocol = object2.next();
                if (orderInfoProtocol == null) {
                    BDLog.e(TAG, "[getOrderStatsStr]: null == orderInfo");
                    continue;
                }
                ((StringBuilder)object).append(orderInfoProtocol.orderState);
                break;
            }
            return ((StringBuilder)object).toString();
        }
        BDLog.e(TAG, "[getOrderStatsStr]: orderInfos is empty");
        return String.valueOf(0);
    }

    private String calCoordinateDiff(double d6, double d7) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringBuilder.append((int)(d6 * 100000.0 - d7 * 100000.0));
        return stringBuilder.toString();
    }

    private String calSpeedDirectDiff(float f6, float f7, int n5) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        float f8 = n5;
        stringBuilder.append((int)(f6 * f8 - f7 * f8));
        return stringBuilder.toString();
    }

    public int getSize() {
        return this.list.size();
    }

    public ShareLocationInfoProtocol getLastLocation(int n5) {
        if (n5 > MAX_SIZE && n5 <= 0) {
            return null;
        }
        return this.list.get(n5 - 1).getInfo();
    }

    public synchronized void addLocationInfoToCache(ShareLocationInfo shareLocationInfo) {
        while (this.list.size() >= MAX_SIZE) {
            this.list.remove(0);
        }
        this.list.add(shareLocationInfo);
    }

    public synchronized void remove(int n5) {
        if (n5 <= MAX_SIZE && n5 > 0) {
            for (int i5 = 0; i5 < n5; ++i5) {
                this.list.remove(0);
            }
            return;
        }
    }

    public String formatPointsData(int n5) {
        if (n5 <= MAX_SIZE && n5 > 0) {
            StringBuffer stringBuffer;
            StringBuffer stringBuffer2;
            StringBuffer stringBuffer3;
            StringBuffer stringBuffer4;
            StringBuffer stringBuffer5;
            StringBuffer stringBuffer6;
            StringBuffer stringBuffer7;
            StringBuffer stringBuffer8;
            Iterator<ShareLocationInfo> iterator = ((BDCache)((Object)stringBuffer16)).list.iterator();
            if (!iterator.hasNext()) {
                BDLog.e(TAG, "[formatPointsData]: !value.hasNext()");
                return null;
            }
            ShareLocationInfo shareLocationInfo = iterator.next();
            ShareLocationInfoProtocol shareLocationInfoProtocol = shareLocationInfo.getInfo();
            String string2 = String.valueOf(1);
            String string3 = String.valueOf(n5--);
            StringBuffer stringBuffer9 = stringBuffer8;
            stringBuffer8 = new StringBuffer();
            StringBuffer stringBuffer10 = stringBuffer7;
            stringBuffer7 = new StringBuffer();
            StringBuffer stringBuffer11 = stringBuffer6;
            stringBuffer6 = new StringBuffer();
            StringBuffer stringBuffer12 = stringBuffer5;
            stringBuffer5 = new StringBuffer();
            StringBuffer stringBuffer13 = stringBuffer4;
            stringBuffer4 = new StringBuffer();
            StringBuffer stringBuffer14 = stringBuffer3;
            stringBuffer3 = new StringBuffer();
            StringBuffer stringBuffer15 = stringBuffer2;
            stringBuffer15();
            stringBuffer9.append(shareLocationInfo.getTimestamp());
            stringBuffer10.append(((BDCache)((Object)stringBuffer16)).getOrderStatsStr(shareLocationInfoProtocol.orderInfos));
            stringBuffer11.append((int)(shareLocationInfoProtocol.postLongitude * 100000.0) + "," + (int)(shareLocationInfoProtocol.postLatitude * 100000.0));
            stringBuffer12.append((int)shareLocationInfoProtocol.postDirection);
            stringBuffer13.append((int)(shareLocationInfoProtocol.gpsLongitude * 100000.0) + "," + (int)(shareLocationInfoProtocol.gpsLatitude * 100000.0));
            stringBuffer14.append((int)shareLocationInfoProtocol.gpsDirection);
            stringBuffer2.append((int)(shareLocationInfoProtocol.gpsSpeed * 10.0f));
            while (iterator.hasNext() && n5 != 0) {
                ShareLocationInfo shareLocationInfo2 = iterator.next();
                ShareLocationInfoProtocol shareLocationInfoProtocol2 = shareLocationInfo2.getInfo();
                stringBuffer9.append("," + (shareLocationInfo2.getTimestamp() - shareLocationInfo.getTimestamp()));
                if (stringBuffer10.length() > 0) {
                    stringBuffer10.append(',');
                }
                stringBuffer10.append(super.getOrderStatsStr(shareLocationInfoProtocol2.orderInfos));
                double d6 = shareLocationInfoProtocol2.postLongitude;
                double d7 = shareLocationInfoProtocol.postLongitude;
                StringBuilder stringBuilder = new StringBuilder().append(";").append(super.calCoordinateDiff(d6, d7)).append(",");
                d6 = shareLocationInfoProtocol2.postLatitude;
                d7 = shareLocationInfoProtocol.postLatitude;
                stringBuffer11.append(stringBuilder.append(super.calCoordinateDiff(d6, d7)).toString());
                float f6 = shareLocationInfoProtocol2.postDirection;
                stringBuffer12.append("," + super.calSpeedDirectDiff(f6, shareLocationInfoProtocol.postDirection, 1));
                d6 = shareLocationInfoProtocol2.gpsLongitude;
                d7 = shareLocationInfoProtocol.gpsLongitude;
                StringBuilder stringBuilder2 = new StringBuilder().append(";").append(super.calCoordinateDiff(d6, d7)).append(",");
                d6 = shareLocationInfoProtocol2.gpsLatitude;
                d7 = shareLocationInfoProtocol.gpsLatitude;
                stringBuffer13.append(stringBuilder2.append(super.calCoordinateDiff(d6, d7)).toString());
                f6 = shareLocationInfoProtocol2.gpsDirection;
                stringBuffer14.append("," + super.calSpeedDirectDiff(f6, shareLocationInfoProtocol.gpsDirection, 1));
                f6 = shareLocationInfoProtocol2.gpsSpeed;
                stringBuffer15.append("," + super.calSpeedDirectDiff(f6, shareLocationInfoProtocol.gpsSpeed, 10));
                shareLocationInfoProtocol = shareLocationInfo2.getInfo();
                --n5;
                shareLocationInfo = shareLocationInfo2;
            }
            StringBuffer stringBuffer16 = stringBuffer;
            stringBuffer16();
            stringBuffer.append(string2).append("|").append(string3).append("|").append(stringBuffer9.toString()).append("|").append(stringBuffer10.toString()).append("|").append(stringBuffer11.toString()).append("|").append(stringBuffer12.toString()).append("|").append(stringBuffer13.toString()).append("|").append(stringBuffer14.toString()).append("|").append(stringBuffer15.toString());
            BDLog.d(TAG, "points:" + stringBuffer16.toString());
            return stringBuffer.toString();
        }
        BDLog.e(TAG, "[formatPointsData]: number > MAX_SIZE || number <= 0, number" + n5);
        return null;
    }
}

