/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.datahub;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.baidu.datahub.BDCache;
import com.baidu.datahub.BDLog;
import com.baidu.datahub.BaseRequest;
import com.baidu.datahub.ContextHelper;
import com.baidu.datahub.DatabaseHelper;
import com.baidu.datahub.HttpClient;
import com.baidu.datahub.LogFile;
import com.baidu.datahub.MD5Util;
import com.baidu.datahub.NavigationType;
import com.baidu.datahub.ShareLocationInfo;
import com.baidu.datahub.protocol.IRequestListenerProtocol;
import com.baidu.datahub.protocol.OrderInfoProtocol;
import com.baidu.datahub.protocol.RoutePlanNodeProtocol;
import com.baidu.datahub.protocol.ShareETAInfoProtocol;
import com.baidu.datahub.protocol.ShareLocationInfoProtocol;
import com.baidu.datahub.protocol.ShareRouteInfoProtocol;
import com.baidu.datahub.protocol.SyncShareImpl;
import com.baidu.datahub.protocol.TokenInfoProtocol;
import com.baidu.datahub.protocol.WayPointInfoProtocol;
import com.baidu.mapapi.CoordType;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareLocationManager {
    private static final String TAG = "ShareLocationManager";
    private static final int MAX_RETRY_TIMES_SERVER_ERROR = 1;
    private static final int MAX_RETRY_TIMES_NET_ERROR = 2;
    private static final int MAX_RETRY_TIMES_PART_REG_FAILED = 1;
    private static final long MAX_ORDER = 50L;
    private static final int DB_VERSION = 6;
    private static final String DEFAULT_PARENT_ORDER_ID = "-+~$#empty_parent_id#$~+-";
    private static final int CAR_POOL_PARENT_ORDER_STATUS = 10;
    private static final String ETA_PROTOCOL_V_SECOND = "v2";
    private static final String ETA_PROTOCOL_V_THIRD = "v3";
    private BDCache mCache;
    private ShareLocationHandler mShareLocationHandler;
    private int mInterval;
    private boolean mFirstInitTimer;
    private String mAuthToken;
    private String mCuid;
    private DataStatus mUploadStatus;
    private BaseRequest mBaseRequest;
    private SQLiteDatabase mDatabase;
    private int mCountRegisterNetError;
    private int mCountRegisterPartFailed;
    private int mCountRegisterServerError;
    private int mCountUpdateNetError;
    private int mCountUpdateServerError;
    private int mCountUpdateRouteInfoError;
    private int mCountUpdateDriverStatusError;
    private long mLastLocationChangeTime;
    private long mLastUpdateLocResponseTime;
    private int mLastUpdateLocationStatus;
    private boolean mIsStopSynServer;
    private boolean mIsOrderRegisted;
    private String mHashCode;
    private String mRouteID;
    private OrderInfoProtocol mParentOrderInfo;
    private int mOrderType;
    private final Set<String> mUnRegisterOrderSet;
    private Timer mUpdateInfoTimer;
    private TimerTask mUpdateInfoTask;
    private SyncShareImpl mShareManagerImpl;
    private NavigationType mNavigationType;

    public ShareLocationManager(String string2, String string3, int n5, SyncShareImpl syncShareImpl, NavigationType navigationType) {
        this.mShareLocationHandler = new ShareLocationHandler();
        this.mInterval = 2;
        this.mFirstInitTimer = false;
        this.mUploadStatus = DataStatus.ready;
        this.mBaseRequest = new BaseRequest();
        this.mCountRegisterNetError = 0;
        this.mCountRegisterPartFailed = 0;
        this.mCountRegisterServerError = 0;
        this.mCountUpdateNetError = 0;
        this.mCountUpdateServerError = 0;
        this.mCountUpdateRouteInfoError = 0;
        this.mCountUpdateDriverStatusError = 0;
        this.mLastLocationChangeTime = 0L;
        this.mLastUpdateLocResponseTime = 0L;
        this.mLastUpdateLocationStatus = -1000;
        this.mIsStopSynServer = false;
        this.mIsOrderRegisted = false;
        this.mHashCode = "";
        this.mRouteID = null;
        this.mParentOrderInfo = new OrderInfoProtocol();
        this.mUnRegisterOrderSet = Collections.synchronizedSet(new HashSet());
        this.mUpdateInfoTimer = new Timer();
        this.mUpdateInfoTask = new TimerTask(){

            @Override
            public void run() {
                if (DataStatus.process != ShareLocationManager.this.mUploadStatus) {
                    1 v02 = this;
                    v02.ShareLocationManager.this.loadOrderInfo();
                    v02.ShareLocationManager.this.loadUpdateOrderInfo();
                    ShareLocationManager shareLocationManager = v02.ShareLocationManager.this;
                    shareLocationManager.loadRouteInfo(shareLocationManager.getParentOrderId());
                    ShareLocationManager shareLocationManager2 = v02.ShareLocationManager.this;
                    shareLocationManager2.updateLocationInfo(shareLocationManager2.mRouteID);
                    v02.ShareLocationManager.this.updateWayPointInfo();
                }
            }
        };
        this.mNavigationType = NavigationType.DRIVER;
        this.initManager(string2, string3, n5, syncShareImpl, navigationType);
    }

    public ShareLocationManager(String string2, String string3, int n5, SyncShareImpl syncShareImpl) {
        ShareLocationManager shareLocationManager = object;
        object.mShareLocationHandler = (ShareLocationManager)object.new ShareLocationHandler();
        object.mInterval = 2;
        object.mFirstInitTimer = false;
        object.mUploadStatus = DataStatus.ready;
        object.mBaseRequest = new BaseRequest();
        object.mCountRegisterNetError = 0;
        object.mCountRegisterPartFailed = 0;
        object.mCountRegisterServerError = 0;
        object.mCountUpdateNetError = 0;
        object.mCountUpdateServerError = 0;
        object.mCountUpdateRouteInfoError = 0;
        object.mCountUpdateDriverStatusError = 0;
        object.mLastLocationChangeTime = 0L;
        object.mLastUpdateLocResponseTime = 0L;
        object.mLastUpdateLocationStatus = -1000;
        object.mIsStopSynServer = false;
        object.mIsOrderRegisted = false;
        object.mHashCode = "";
        object.mRouteID = null;
        object.mParentOrderInfo = new OrderInfoProtocol();
        object.mUnRegisterOrderSet = Collections.synchronizedSet(new HashSet());
        object.mUpdateInfoTimer = new Timer();
        object.mUpdateInfoTask = new /* invalid duplicate definition of identical inner class */;
        Object object = NavigationType.DRIVER;
        v1.mNavigationType = object;
        shareLocationManager.initManager(string2, string3, n5, syncShareImpl, (NavigationType)((Object)object));
    }

    private void initManager(String string2, String string3, int n5, SyncShareImpl syncShareImpl, NavigationType navigationType) {
        if (syncShareImpl == null) {
            BDLog.e(TAG, "ShareManagerInterface cannot be empty");
            return;
        }
        ShareLocationManager shareLocationManager = this;
        this.mAuthToken = string2;
        this.mCuid = string3;
        this.mShareManagerImpl = syncShareImpl;
        this.mNavigationType = navigationType;
        shareLocationManager.mOrderType = n5;
        shareLocationManager.mCache = new BDCache(this.mParentOrderInfo);
        shareLocationManager.registerShareLocationHandler(shareLocationManager.mShareLocationHandler);
        string2 = shareLocationManager.mShareManagerImpl.getAppContext();
        ContextHelper.setContext((Context)string2);
        try {
            shareLocationManager.mDatabase = new DatabaseHelper((Context)string2, "drivier.db", null, 6).getWritableDatabase();
        }
        catch (Exception exception) {
            BDLog.dforce(TAG, "Get mDatabase failed, caught SQLiteException", exception);
        }
        LogFile.init((Context)string2);
        this.mHashCode = String.valueOf(this.hashCode());
        int n6 = this.mHashCode.length();
        if (n6 > 4) {
            this.mHashCode = this.mHashCode.substring(n6 - 4);
        }
        this.removeLastParentOrderReleatedInfoFromDB();
    }

    /*
     * Exception decompiling
     */
    private synchronized boolean loadUpdateOrderInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 24[TRYBLOCK] [46 : 464->490)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized boolean updateOrder(OrderInfoProtocol orderInfoProtocol) {
        String string2;
        HashMap<String, Object> hashMap;
        block15: {
            HashMap<String, Object> hashMap2;
            if (orderInfoProtocol == null) {
                BDLog.e(TAG, "BNOrderInfo is null");
                return false;
            }
            ShareLocationManager shareLocationManager = this;
            hashMap = hashMap2;
            ShareLocationManager shareLocationManager2 = this;
            HashMap<String, Object> hashMap3 = hashMap;
            hashMap();
            string2 = "order_id";
            try {
                hashMap.put(string2, this.whetherToEncodeParameter(MD5Util.getMD5String(orderInfoProtocol.getOrderId(), orderInfoProtocol.companyServerId), true));
            }
            catch (Exception exception) {
                BDLog.dforce(TAG, "updateOrder exception happened", exception);
                return false;
            }
            string2 = "company";
            hashMap.put(string2, this.whetherToEncodeParameter(orderInfoProtocol.companyServerId, true));
            string2 = "order_attr";
            hashMap3.put(string2, this.whetherToEncodeParameter(orderInfoProtocol.driverId, true));
            hashMap3.put("status", orderInfoProtocol.orderState);
            hashMap3.put("modify_time", System.currentTimeMillis() / 1000L);
            hashMap3.put("order_type", orderInfoProtocol.orderType);
            string2 = "trip_mode";
            hashMap.put(string2, this.getTripMode());
            string2 = "token";
            hashMap2.put(string2, shareLocationManager2.whetherToEncodeParameter(shareLocationManager2.mAuthToken, true));
            string2 = shareLocationManager.getRequestData(hashMap2, 1);
            if (shareLocationManager.mShareManagerImpl == null) break block15;
            hashMap.put("sign", this.mShareManagerImpl.getSignMD5String(string2));
        }
        ShareLocationManager shareLocationManager = this;
        ShareLocationManager shareLocationManager3 = shareLocationManager;
        BDLog.e("ShareLocationManagerparamSign", string2);
        string2 = shareLocationManager.getRequestData(hashMap, 0);
        BDLog.d(TAG, "updateOrder data:" + string2);
        Object[] objectArray = shareLocationManager3.mDatabase;
        if (shareLocationManager3.mDatabase != null && objectArray.isOpen()) {
            ShareLocationManager shareLocationManager4 = this;
            Object[] objectArray2 = new String[2];
            objectArray = objectArray2;
            objectArray2[0] = orderInfoProtocol.getOrderId();
            objectArray2[1] = "update_order";
            shareLocationManager4.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", (String[])objectArray);
            String[] stringArray = new String[15];
            Object[] objectArray3 = objectArray = stringArray;
            objectArray[0] = orderInfoProtocol.getOrderId();
            objectArray[1] = orderInfoProtocol.companyServerId;
            objectArray[2] = orderInfoProtocol.driverId;
            objectArray[3] = String.valueOf(orderInfoProtocol.orderState);
            objectArray3[4] = (String)hashMap.get("cur_pos");
            objectArray3[5] = "";
            objectArray3[6] = "";
            objectArray3[7] = "";
            objectArray3[8] = "";
            objectArray3[9] = "";
            objectArray3[10] = "";
            objectArray3[11] = "";
            objectArray[12] = "update_order";
            objectArray[13] = String.valueOf(orderInfoProtocol.orderType);
            stringArray[14] = this.getParentOrderId();
            shareLocationManager4.mDatabase.execSQL("insert into orderInfo (orderId,companyServerId,driverId,orderState,cur_point,start_point,start_poiid,start_name,end_point,end_poiid,end_name,cuid,remark,order_type,parent_order_id) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", objectArray);
        }
        return this.sendUpdateOrder(orderInfoProtocol.getOrderId(), string2);
    }

    private synchronized boolean sendUpdateOrder(final String string2, final String string3) {
        if (!this.mIsStopSynServer && this.mIsOrderRegisted) {
            HttpClient.ProtoResultCallBack protoResultCallBack;
            if (string3 == null) {
                return false;
            }
            HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
            protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                @Override
                public void onSuccess(String string22) {
                    2 v02 = string32;
                    BDLog.e(ShareLocationManager.TAG, "update order success");
                    v02.ShareLocationManager.this.removeNotUpdateOrder(string32.string2);
                    ShareLocationManager.access$902(v02.ShareLocationManager.this, 0);
                    if (v02.ShareLocationManager.this.mShareManagerImpl != null) {
                        2 v12 = string32;
                        String string32 = String.valueOf(v12.ShareLocationManager.this.parseResponseStatus(string22));
                        string22 = v12.ShareLocationManager.this.mHashCode;
                        string32.ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.6", "ds", string32, string22);
                    }
                }

                @Override
                public void onFailed(HttpClient.HttpStateError object, String string22) {
                    BDLog.e(ShareLocationManager.TAG, "update order failed,errCode:" + (Object)object + "result:" + string22);
                    if (HttpClient.HttpStateError.SERVER_INNER == object) {
                        if (string32.ShareLocationManager.this.mCountUpdateServerError < 1) {
                            2 v02 = string32;
                            v02.ShareLocationManager.this.mCountUpdateServerError++;
                            2 v12 = string32;
                            string22 = v12.string2;
                            v02.ShareLocationManager.this.sendUpdateOrder(string22, v12.string3);
                        }
                    } else if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.USER_DELETED_BY_ADMIN != object && HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT != object) {
                        if (HttpClient.HttpStateError.NETWORK_ERROR == object) {
                            if (string32.ShareLocationManager.this.mCountUpdateNetError < 2) {
                                Object object2 = string32;
                                object2.ShareLocationManager.this.mCountUpdateNetError++;
                                Object object3 = string32;
                                string22 = object3.string2;
                                object2.ShareLocationManager.this.sendUpdateOrder(string22, object3.string3);
                            } else {
                                ShareLocationManager.access$902(string32.ShareLocationManager.this, 0);
                            }
                        } else {
                            ShareLocationManager.access$902(string32.ShareLocationManager.this, 0);
                        }
                    } else {
                        ShareLocationManager.access$1502(string32.ShareLocationManager.this, true);
                    }
                    if (string32.ShareLocationManager.this.mShareManagerImpl != null) {
                        2 v42 = string32;
                        String string32 = String.valueOf(object.getValue());
                        object = v42.ShareLocationManager.this.mHashCode;
                        string32.ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.6", "ds", string32, (String)object);
                    }
                }
            };
            this.mBaseRequest.sendRequest(2, "POST", string3, protoResultCallBack2);
            return true;
        }
        BDLog.e(TAG, "[sendUpdateOrder]: User is deleted by admin or order register failedor order error");
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean updateLocationInfo(String var1_1) {
        block37: {
            block34: {
                block36: {
                    block35: {
                        block33: {
                            block32: {
                                if (this.isParentOrderInfoEmpty()) {
                                    BDLog.e("ShareLocationManager", "[updateLocationInfo]:mParentOrderInfo is empty");
                                    return false;
                                }
                                this.mUploadStatus = DataStatus.process;
                                var2_3 = this.mCache.getSize();
                                if (var2_3 == 0) {
                                    this.mUploadStatus = DataStatus.ready;
                                    return false;
                                }
                                var3_4 = this.getETAInfos();
                                var4_5 = "";
                                if (var3_4 != null && var3_4.size() > 0) {
                                    var4_5 = var3_4.get((int)0).routeID;
                                }
                                var3_4 = v0;
                                v1 = this;
                                v2 = this;
                                v3 = this;
                                v4 = this;
                                var3_4();
                                var5_6 = "order_id";
                                var3_4.put(var5_6, v4.whetherToEncodeParameter(v4.getParentOrderId(), true));
                                var5_6 = "company";
                                var3_4.put(var5_6, v3.whetherToEncodeParameter(v3.mParentOrderInfo.companyServerId, true));
                                var5_6 = "order_attr";
                                var3_4.put(var5_6, v2.whetherToEncodeParameter(v2.mParentOrderInfo.driverId, true));
                                var5_6 = "points";
                                v0.put(var5_6, v1.whetherToEncodeParameter(v1.mCache.formatPointsData(var2_3), true));
                                v0.put("modify_time", System.currentTimeMillis() / 1000L);
                                if (this.mParentOrderInfo.orderType != 0) ** GOTO lbl63
                                if (TextUtils.isEmpty((CharSequence)var1_1)) break block32;
                                v5 = var1_1;
                                var1_1 = "route_id";
                                v6 = var3_4.put(var1_1, this.whetherToEncodeParameter(v5, true));
lbl46:
                                // 2 sources

                                while (true) {
                                    break block33;
                                    break;
                                }
                            }
                            if (TextUtils.isEmpty((CharSequence)var4_5)) break block33;
                            var1_1 = "route_id";
                            v6 = var3_4.put(var1_1, this.whetherToEncodeParameter(var4_5, true));
                            ** continue;
                        }
                        v7 = var3_4;
                        v7.put("status", this.mParentOrderInfo.orderState);
                        this.generateRunAndRemainInfo(v7);
                        break block34;
lbl63:
                        // 1 sources

                        if (this.mParentOrderInfo.orderType != 1) break block34;
                        if (TextUtils.isEmpty((CharSequence)var1_1)) break block35;
                        var5_6 = "route_id";
                        v8 = var3_4.put(var5_6, this.whetherToEncodeParameter(var1_1, true));
lbl69:
                        // 2 sources

                        while (true) {
                            ** GOTO lbl82
                            break;
                        }
                    }
                    try {
                        if (TextUtils.isEmpty((CharSequence)var4_5)) ** GOTO lbl82
                        var5_6 = "route_id";
                    }
                    catch (Exception var1_2) {
                        this.mUploadStatus = DataStatus.ready;
                        BDLog.dforce("ShareLocationManager", "updateLocationInfo exception happened.", var1_2);
                        return false;
                    }
                    v8 = var3_4.put(var5_6, this.whetherToEncodeParameter(var4_5, true));
                    ** continue;
lbl82:
                    // 2 sources

                    v9 = var1_1;
                    var3_4.put("status", "10");
                    if (!TextUtils.isEmpty((CharSequence)v9)) break block36;
                    if (TextUtils.isEmpty((CharSequence)var4_5)) break block34;
                }
                this.generateRunAndRemainInfo(var3_4);
            }
            v10 = this;
            v11 = var3_4;
            v12 = this;
            var3_4.put("order_type", this.mParentOrderInfo.orderType);
            var1_1 = "trip_mode";
            var3_4.put(var1_1, this.getTripMode());
            var1_1 = "token";
            v11.put(var1_1, v12.whetherToEncodeParameter(v12.mAuthToken, true));
            var1_1 = v10.getRequestData(v11, 1);
            if (v10.mShareManagerImpl == null) break block37;
            var3_4.put("sign", this.mShareManagerImpl.getSignMD5String(var1_1));
        }
        v13 = this;
        v14 = v13;
        BDLog.e("ShareLocationManagerparamSign", var1_1);
        v15 = v13.getRequestData(var3_4, 0);
        BDLog.d("ShareLocationManager", "*******update location data:" + v15);
        return v14.sendLocationInfo(v15, var2_3);
    }

    private void generateRunAndRemainInfo(Map<String, Object> map) {
        List<ShareETAInfoProtocol> list = ((ShareLocationManager)((Object)stringBuilder4)).getETAInfos();
        if (list != null && list.size() > 0) {
            StringBuilder stringBuilder;
            if (((ShareLocationManager)((Object)stringBuilder4)).isParentOrderInfoEmpty()) {
                BDLog.e(TAG, "parent order info is empty");
                return;
            }
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            int n5 = ((ShareLocationManager)((Object)stringBuilder4)).mParentOrderInfo.orderType;
            if (n5 == 1) {
                stringBuilder2.append(ETA_PROTOCOL_V_SECOND).append("|");
            } else if (n5 == 0) {
                stringBuilder2.append(ETA_PROTOCOL_V_THIRD).append("|");
            }
            long l5 = 0L;
            long l6 = 0L;
            list = list.iterator();
            boolean bl = true;
            while (list.hasNext()) {
                ShareETAInfoProtocol shareETAInfoProtocol = (ShareETAInfoProtocol)list.next();
                if (shareETAInfoProtocol != null && !TextUtils.isEmpty((CharSequence)shareETAInfoProtocol.orderId) && !TextUtils.isEmpty((CharSequence)shareETAInfoProtocol.etaType)) {
                    stringBuilder2.append(shareETAInfoProtocol.leftDist).append(';').append(shareETAInfoProtocol.leftTime).append('#').append(MD5Util.getMD5String(shareETAInfoProtocol.orderId, ((ShareLocationManager)((Object)stringBuilder4)).mParentOrderInfo.companyServerId)).append('#').append(shareETAInfoProtocol.etaType);
                    if (list.hasNext()) {
                        stringBuilder2.append('|');
                    }
                    l5 += shareETAInfoProtocol.pastDist;
                    l6 += shareETAInfoProtocol.pastTime;
                    continue;
                }
                if (shareETAInfoProtocol != null) {
                    BDLog.e(TAG, "etainfo is error" + shareETAInfoProtocol.toString());
                }
                bl = false;
                break;
            }
            if (bl) {
                StringBuilder stringBuilder3;
                Map<String, Object> map2 = map;
                map2.put("remain", stringBuilder2.toString());
                StringBuilder stringBuilder4 = stringBuilder3;
                stringBuilder4();
                map2.put("run", stringBuilder3.append(l5).append(";").append(l6).toString());
            }
            return;
        }
        BDLog.e(TAG, "etaInfos is null");
    }

    private synchronized boolean sendLocationInfo(String string2, final int n5) {
        if (!this.mIsStopSynServer && this.mIsOrderRegisted) {
            if (string2 != null && !string2.isEmpty()) {
                HttpClient.ProtoResultCallBack protoResultCallBack;
                HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
                protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                    @Override
                    public void onSuccess(String string2) {
                        3 v02 = this;
                        BDLog.e(ShareLocationManager.TAG, "[sendLocationInfo] success, result:" + string2);
                        v02.ShareLocationManager.this.mCache.remove(n5);
                        ShareLocationManager.access$002(v02.ShareLocationManager.this, DataStatus.success);
                        ShareLocationManager shareLocationManager = v02.ShareLocationManager.this;
                        shareLocationManager.addLocationUpdateResponseLog(shareLocationManager.parseResponseStatus(string2));
                        v02.ShareLocationManager.this.handleEndPositionInfo(string2);
                        v02.ShareLocationManager.this.parseResponsePassengerPoint(string2);
                    }

                    @Override
                    public void onFailed(HttpClient.HttpStateError httpStateError, String string2) {
                        BDLog.e(ShareLocationManager.TAG, "[sendLocationInfo],errCode:" + (Object)((Object)httpStateError) + "result:" + string2);
                        ShareLocationManager.access$002(ShareLocationManager.this, DataStatus.error);
                        if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN == httpStateError || HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN == httpStateError || HttpClient.HttpStateError.USER_DELETED_BY_ADMIN == httpStateError || HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT == httpStateError) {
                            ShareLocationManager.access$1502(ShareLocationManager.this, true);
                        }
                        ShareLocationManager.this.addLocationUpdateResponseLog(httpStateError.getValue());
                    }
                };
                this.mBaseRequest.sendRequest(4, "POST", string2, protoResultCallBack2);
                return true;
            }
            this.mUploadStatus = DataStatus.ready;
            return false;
        }
        BDLog.e(TAG, "[sendLocationInfo]: User is deleted by admin or order register failedor order error");
        this.mUploadStatus = DataStatus.ready;
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean updateRoute(ShareRouteInfoProtocol var1_2) {
        block54: {
            block53: {
                block56: {
                    block52: {
                        block51: {
                            block50: {
                                block55: {
                                    block49: {
                                        block48: {
                                            if (var1_2 == null) {
                                                BDLog.e("ShareLocationManager", "[updateRoute]:BNShareRouteInfo is null");
                                                return false;
                                            }
                                            if (!this.isParentOrderInfoEmpty()) ** GOTO lbl21
                                            BDLog.e("ShareLocationManager", "[updateRoute]:mParentOrderInfo is null");
                                            var2_3 = var1_2.orderInfos;
                                            if (var2_3 == null || var2_3.size() <= 0) ** GOTO lbl19
                                            if ((var2_3 = var2_3.get(0)) == null) {
                                                BDLog.e("ShareLocationManager", "[updateRoute]:orderInfo is null");
                                                return false;
                                            }
                                            if (var2_3.getOrderId() != null && (var3_5 = var2_3.companyServerId) != null && (var4_6 = var2_3.driverId) != null && var1_2.sessionId != null) {
                                                var5_7 = 1 == var2_3.orderType ? 10 : var2_3.orderState;
                                                var6_9 = 1 == var2_3.orderType ? "-+~$#empty_parent_id#$~+-_" + this.mHashCode : MD5Util.getMD5String(var2_3.getOrderId(), var3_5);
                                                var2_4 = var2_3.orderType;
                                                BDLog.e("ShareLocationManager", "[updateRoute]:mParentOrderInfo update route set data" + var6_9);
                                            } else {
                                                BDLog.e("ShareLocationManager", "[updateRoute]:must parameter is null");
                                                return false;
lbl19:
                                                // 1 sources

                                                BDLog.e("ShareLocationManager", "[updateRoute]:orderInfos is empty");
                                                return false;
lbl21:
                                                // 1 sources

                                                v0 = this;
                                                v1 = v0.mParentOrderInfo;
                                                var3_5 = v1.companyServerId;
                                                var4_6 = v1.driverId;
                                                var5_7 = v1.orderState;
                                                var2_4 = v1.orderType;
                                                var6_9 = v0.getParentOrderId();
                                                BDLog.e("ShareLocationManager", "[updateRoute]:mParentOrderInfo update route get cache" + var6_9);
                                            }
                                            this.mRouteID = var1_2.curRouteMD5;
                                            v2 = var7_10 = v3;
                                            v4 = this;
                                            v5 = var4_6;
                                            var7_10();
                                            var4_6 = "";
                                            var5_8 = "";
                                            var8_11 = "";
                                            var9_12 = "order_id";
                                            var7_10.put(var9_12, this.whetherToEncodeParameter(var6_9, true));
                                            var9_12 = "company";
                                            var7_10.put(var9_12, this.whetherToEncodeParameter(var3_5, true));
                                            var9_12 = "order_attr";
                                            var7_10.put(var9_12, this.whetherToEncodeParameter(v5, true));
                                            var9_12 = "session_id";
                                            var7_10.put(var9_12, this.whetherToEncodeParameter(var1_2.sessionId, true));
                                            var9_12 = "route_id";
                                            v2.put(var9_12, v4.whetherToEncodeParameter(v4.mRouteID, true));
                                            v2.put("modify_time", System.currentTimeMillis() / 1000L);
                                            var9_12 = "status";
                                            v3.put(var9_12, var5_7);
                                            v3.put("order_type", this.mParentOrderInfo.orderType);
                                            if (1 != var2_4) break block55;
                                            v6 = this;
                                            v7 = var1_2;
                                            var1_2 = v8;
                                            v8 = new StringBuilder();
                                            if (v6.generateCarpoolOrderSubSeq(v7.wayPointInfos, var3_5, (StringBuilder)var1_2)) break block48;
                                            BDLog.e("ShareLocationManager", "generateWayPointsOrderSubSeq failed");
                                            return false;
                                        }
                                        var4_6 = this.whetherToEncodeParameter(var1_2.toString(), true);
                                        if (!TextUtils.isEmpty((CharSequence)var4_6)) break block49;
                                        BDLog.e("ShareLocationManager", "subOrdersSeq is empty");
                                        return false;
                                    }
                                    var7_10.put("sub_orders_seq", var4_6);
                                    break block56;
                                }
                                if (var2_4 != 0) break block56;
                                BDLog.e("ShareLocationManager", " [updateRoute] wayPointInfos \uff1a " + var1_2.wayPointInfos);
                                var3_5 = this.generateWayPointsOrderSubSeq(var1_2.wayPointInfos, var6_9, false);
                                if (TextUtils.isEmpty((CharSequence)var3_5)) break block50;
                                v9 = var7_10;
                                var3_5 = this.whetherToEncodeParameter(var3_5, true);
                                BDLog.e("ShareLocationManager", " [updateRoute] subOrdersSeq \uff1a " + var3_5);
                                v10 = v9.put("waypoints", var3_5);
lbl104:
                                // 2 sources

                                while (true) {
                                    ** GOTO lbl110
                                    break;
                                }
                            }
                            v10 = var7_10.put("waypoints", "");
                            ** continue;
lbl110:
                            // 1 sources

                            var5_8 = this.generatePathPlanWayPointsOrderSubSeq(var1_2.wayPointInfos, var6_9, false);
                            if (TextUtils.isEmpty((CharSequence)var5_8)) break block51;
                            v11 = var7_10;
                            var5_8 = this.whetherToEncodeParameter(var5_8, true);
                            BDLog.e("ShareLocationManager", " [updateRoute] subNewRowOrdersSeq \uff1a " + var5_8);
                            v12 = v11.put("pathplan_points", var5_8);
lbl119:
                            // 2 sources

                            while (true) {
                                ** GOTO lbl125
                                break;
                            }
                        }
                        v12 = var7_10.put("pathplan_points", "");
                        ** continue;
lbl125:
                        // 1 sources

                        if (var1_2.endNodeInfo == null) break block52;
                        v13 = var1_2;
                        var8_11 = "end_name";
                        var7_10.put((String)var8_11, this.whetherToEncodeParameter(var1_2.endNodeInfo.getName(), true));
                        var8_11 = "end_point";
                        var7_10.put((String)var8_11, this.whetherToEncodeParameter(var1_2.endNodeInfo.getLongitude() + "," + var1_2.endNodeInfo.getLatitude(), true));
                        var1_2 = "end_poiid";
                        v14 = var7_10.put((String)var1_2, this.whetherToEncodeParameter(v13.endNodeInfo.getId(), true));
lbl138:
                        // 2 sources

                        while (true) {
                            break block53;
                            break;
                        }
                    }
                    try {
                        v15 = var7_10;
                        v16 = v15;
                        v17 = v15;
                        v15.put("end_name", "");
                    }
                    catch (Exception var0_1) {
                        BDLog.dforce("ShareLocationManager", "updateRoute exception happened.", var0_1);
                        return false;
                    }
                    v17.put("end_point", "");
                    v14 = v16.put("end_poiid", "");
                    ** continue;
                }
                v18 = var5_8;
                var5_8 = var8_11;
                var3_5 = v18;
            }
            v19 = this;
            v20 = var7_10;
            v21 = this;
            var1_2 = "trip_mode";
            var7_10.put((String)var1_2, this.getTripMode());
            var1_2 = "token";
            v20.put((String)var1_2, v21.whetherToEncodeParameter(v21.mAuthToken, true));
            var1_2 = v19.getRequestData(v20, 1);
            if (v19.mShareManagerImpl == null) break block54;
            var7_10.put("sign", this.mShareManagerImpl.getSignMD5String((String)var1_2));
        }
        v22 = this;
        v23 = v22;
        BDLog.e("ShareLocationManager paramSign", (String)var1_2);
        var1_2 = v22.getRequestData(var7_10, 0);
        BDLog.d("ShareLocationManager", "*********update route data:" + (String)var1_2);
        var8_11 = v23.getOutOfRangeOrdersFromDataBase("routeInfo");
        if (var8_11 != null && !var8_11.isEmpty()) {
            this.deleteFromDB("routeInfo", (ArrayList<String>)var8_11);
        }
        if ((var8_11 = this.mDatabase) != null && var8_11.isOpen()) {
            v24 = this;
            v25 = new String[1];
            var8_11 = v25;
            v25[0] = var6_9;
            v24.mDatabase.delete("routeInfo", "orderId = ?", (String[])var8_11);
            v26 = new String[14];
            var8_11 = v26;
            var8_11[0] = var6_9;
            var8_11[1] = (String)var7_10.get("company");
            var8_11[2] = (String)var7_10.get("order_attr");
            var8_11[3] = String.valueOf(var7_10.get("status"));
            var8_11[4] = (String)var7_10.get("session_id");
            var8_11[5] = (String)var7_10.get("route_id");
            var8_11[6] = String.valueOf(var7_10.get("modify_time"));
            var8_11[7] = var4_6;
            var8_11[8] = String.valueOf(var2_4);
            var8_11[9] = String.valueOf(var7_10.get("end_name"));
            var8_11[10] = String.valueOf(var7_10.get("end_point"));
            v26[11] = String.valueOf(var7_10.get("end_poiid"));
            v26[12] = var3_5;
            v26[13] = var5_8;
            v24.mDatabase.execSQL("insert into routeInfo(orderId,companyServerId,driverId,orderState,sessionId,curRouteMD5,modify_time,sub_orders_seq,order_type,end_name,end_point,end_poiid,waypoints,pathplan_points) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", var8_11);
        }
        if ("-+~$#empty_parent_id#$~+-".equals(var6_9)) {
            BDLog.e("ShareLocationManager", "[updateRoute]: parentOrderId is empty");
            return false;
        }
        return this.sendRouteInfo(var6_9, (String)var1_2, var7_10);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean generateCarpoolOrderSubSeq(List<? extends WayPointInfoProtocol> iterator, String string2, StringBuilder stringBuilder) {
        if (iterator != null && iterator.size() > 0) {
            if (stringBuilder == null) {
                BDLog.e(TAG, "[generateCarpoolOrderSubSeq]:subOrdersSeq is null");
                return false;
            }
        } else {
            BDLog.e(TAG, "[generateCarpoolOrderSubSeq]:orderInfoList is empty");
            return false;
        }
        iterator = iterator.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            RoutePlanNodeProtocol routePlanNodeProtocol;
            String string3;
            Object object = (WayPointInfoProtocol)iterator.next();
            if (object == null) return false;
            WayPointInfoProtocol wayPointInfoProtocol = object;
            object = wayPointInfoProtocol.getOrderId();
            if (!this.appendOneSubSeq(stringBuilder, (String)object, string3 = wayPointInfoProtocol.getType(), routePlanNodeProtocol = wayPointInfoProtocol.getNode(), string2)) {
                return false;
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append('|');
        }
        return bl;
    }

    private String generateWayPointsOrderSubSeq(List<? extends WayPointInfoProtocol> object, String string2, boolean bl) {
        if (object != null && object.size() > 0) {
            Object object2;
            Object object3;
            StringBuilder stringBuilder;
            if (string2 == null) {
                string2 = "";
            }
            List<? extends WayPointInfoProtocol> list = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator<? extends WayPointInfoProtocol> iterator = list.iterator();
            while (iterator.hasNext() && (object3 = iterator.next()) != null && (object2 = ((WayPointInfoProtocol)object3).getNode()) != null) {
                if (bl) {
                    WayPointInfoProtocol wayPointInfoProtocol = object3;
                    object3 = ((StringBuilder)object).append(((RoutePlanNodeProtocol)object2).getLongitude()).append(',').append(((RoutePlanNodeProtocol)object2).getLatitude()).append(';').append(this.whetherToEncodeParameter(((RoutePlanNodeProtocol)object2).getName(), true)).append(';').append(((RoutePlanNodeProtocol)object2).getId()).append(';');
                    object2 = wayPointInfoProtocol.isArrive() ? "1" : "0";
                    ((StringBuilder)object3).append((String)object2).append(';').append(string2);
                } else if (((WayPointInfoProtocol)object3).getType().equals("wp")) {
                    ((StringBuilder)object).append(((RoutePlanNodeProtocol)object2).getLongitude()).append(',').append(((RoutePlanNodeProtocol)object2).getLatitude()).append(';').append(this.whetherToEncodeParameter(((RoutePlanNodeProtocol)object2).getName(), true)).append(';').append(((RoutePlanNodeProtocol)object2).getId()).append(';').append("0").append(';').append(string2);
                }
                if (!iterator.hasNext()) continue;
                ((StringBuilder)object).append('|');
            }
            if (!(((StringBuilder)object).length() <= 0 || "null".equals(((StringBuilder)object).toString()) || "".equals(((StringBuilder)object).toString()) || "|".equals(((StringBuilder)object).toString()))) {
                return ((StringBuilder)object).toString();
            }
            return "";
        }
        BDLog.e(TAG, "[generateWayPointsOrderSubSeq]:orderInfoList is empty");
        return "";
    }

    private String generatePathPlanWayPointsOrderSubSeq(List<? extends WayPointInfoProtocol> object, String string2, boolean bl) {
        if (object != null && object.size() > 0) {
            Object object2;
            Object object3;
            StringBuilder stringBuilder;
            if (string2 == null) {
                string2 = "";
            }
            List<? extends WayPointInfoProtocol> list = object;
            object = stringBuilder;
            stringBuilder = new StringBuilder();
            Iterator<? extends WayPointInfoProtocol> iterator = list.iterator();
            while (iterator.hasNext() && (object3 = iterator.next()) != null && (object2 = ((WayPointInfoProtocol)object3).getNode()) != null) {
                if (bl) {
                    WayPointInfoProtocol wayPointInfoProtocol = object3;
                    object3 = ((StringBuilder)object).append(((RoutePlanNodeProtocol)object2).getLongitude()).append(',').append(((RoutePlanNodeProtocol)object2).getLatitude()).append(';').append(this.whetherToEncodeParameter(((RoutePlanNodeProtocol)object2).getName(), true)).append(';').append(((RoutePlanNodeProtocol)object2).getId()).append(';');
                    object2 = wayPointInfoProtocol.isArrive() ? "1" : "0";
                    ((StringBuilder)object3).append((String)object2).append(';').append(string2);
                } else {
                    ((StringBuilder)object).append(((RoutePlanNodeProtocol)object2).getLongitude()).append(',').append(((RoutePlanNodeProtocol)object2).getLatitude()).append(';').append(this.whetherToEncodeParameter(((RoutePlanNodeProtocol)object2).getName(), true)).append(';').append(((RoutePlanNodeProtocol)object2).getId()).append(';').append(((WayPointInfoProtocol)object3).getType()).append(';').append(string2);
                }
                if (!iterator.hasNext()) continue;
                ((StringBuilder)object).append('|');
            }
            if (!(((StringBuilder)object).length() <= 0 || "null".equals(((StringBuilder)object).toString()) || "".equals(((StringBuilder)object).toString()) || "|".equals(((StringBuilder)object).toString()))) {
                return ((StringBuilder)object).toString();
            }
            return "";
        }
        BDLog.e(TAG, "[generateWayPointsOrderSubSeq]:orderInfoList is empty");
        return "";
    }

    private boolean appendOneSubSeq(StringBuilder stringBuilder, String string2, String string3, RoutePlanNodeProtocol routePlanNodeProtocol, String string4) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[appendOneSubSeq]:orderId is empty");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string3)) {
            BDLog.e(TAG, "[appendOneSubSeq]:type is empty");
            return false;
        }
        if (routePlanNodeProtocol == null) {
            BDLog.e(TAG, "[appendOneSubSeq]:routePlanNode is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string4)) {
            BDLog.e(TAG, "[appendOneSubSeq]:companyServerId is null");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = MD5Util.getMD5String(string2, string4)))) {
            BDLog.e(TAG, "[appendOneSubSeq]:encryptOrderId is empty");
            return false;
        }
        stringBuilder.append(string2).append('_').append(string3).append(';').append(routePlanNodeProtocol.getLongitude()).append(',').append(routePlanNodeProtocol.getLatitude()).append(';').append(this.whetherToEncodeParameter(routePlanNodeProtocol.getName(), true)).append(';').append(routePlanNodeProtocol.getId());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getRequestData(Map<String, Object> object, int n5) {
        StringBuffer stringBuffer;
        Object object2 = object;
        object = stringBuffer;
        stringBuffer = new StringBuffer();
        for (Map.Entry entry : object2.entrySet()) {
            StringBuffer stringBuffer2;
            if (entry.getValue() != null && n5 == 0) {
                stringBuffer2 = ((StringBuffer)object).append((String)entry.getKey()).append("=").append(this.whetherToEncodeParameter(String.valueOf(entry.getValue()), true)).append("&");
                continue;
            }
            stringBuffer2 = ((StringBuffer)object).append((String)entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        Object object3 = object;
        Object object4 = object3;
        int n6 = ((StringBuffer)object3).length();
        try {
            ((StringBuffer)object4).deleteCharAt(n6 - 1);
        }
        catch (Exception exception) {
            BDLog.dforce(TAG, "getRequestData exception happened.", exception);
        }
        return ((StringBuffer)object).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> getURLEncodeRequestData(Map<String, Object> hashMap) {
        Iterator iterator;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap;
        hashMap = hashMap2;
        hashMap2 = new HashMap<String, Object>();
        try {
            iterator = hashMap3.entrySet().iterator();
        }
        catch (Exception exception) {
            BDLog.dforce(TAG, "getURLEncodeRequestData exception happened.", exception);
        }
        while (true) {
            if (!iterator.hasNext()) return hashMap;
            Map.Entry entry = iterator.next();
            if (entry.getKey() == null) continue;
            if (entry.getValue() == null) continue;
            HashMap<String, Object> hashMap4 = hashMap;
            ShareLocationManager shareLocationManager = this;
            Map.Entry entry2 = entry;
            Map.Entry entry3 = entry2;
            Object k5 = entry2.getKey();
            hashMap4.put((String)k5, shareLocationManager.whetherToEncodeParameter(String.valueOf(entry3.getValue()), true));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean updateWayPointInfo() {
        block39: {
            block38: {
                var1_6 /* !! */  = this.getParentOrderId();
                if (TextUtils.isEmpty((CharSequence)var1_6 /* !! */ )) {
                    BDLog.e("ShareLocationManager", "[updateWayPointInfo]: orderId is empty");
                    return false;
                }
                var2_8 = "orderId = ?";
                v0 = new String[1];
                var3_11 = v0;
                v0[0] = var1_6 /* !! */ ;
                var4_12 /* !! */  = this.mDatabase;
                if (var4_12 /* !! */  == null || !var4_12 /* !! */ .isOpen()) break block39;
                var4_12 /* !! */  = "";
                var5_13 = 0;
                var6_14 = "";
                var7_15 = null;
                try {
                    var7_15 = this.mDatabase.query("driverStatus", null, (String)var2_8, (String[])var3_11, null, null, null);
                    if (var7_15 == null) {
                    }
                    ** GOTO lbl-1000
                }
                catch (Exception var2_10) {
                    // empty catch block
                    ** GOTO lbl-1000
                }
                try {
                    BDLog.e("ShareLocationManager", "[loadWayPoint]: cursor is null 0");
                    var0_1 = false;
                    if (var7_15 == null) return var0_1;
                }
                catch (Exception var1_7) {
                    var2_8 = var1_7;
                    ** GOTO lbl-1000
                }
                catch (Throwable var0_5) {
                    break block38;
                }
                var7_15.close();
                return var0_1;
lbl-1000:
                // 1 sources

                {
                    if (this.mDatabase.isOpen()) ** GOTO lbl-1000
                }
                {
                    v1 = var7_15;
                    v1.close();
                    BDLog.e("ShareLocationManager", "[loadWayPoint]: database is close");
                    var0_2 = false;
                    if (v1 == null) return var0_2;
                }
                var7_15.close();
                return var0_2;
lbl-1000:
                // 1 sources

                {
                    var3_11 = "-+~$#empty_parent_id#$~+-_" + this.mHashCode;
                    if (var7_15.moveToFirst()) ** GOTO lbl-1000
                }
                {
                    v2 = this;
                    var7_15.close();
                    v3 = new String[1];
                }
                var8_16 = v3;
                {
                    v3[0] = var3_11;
                    var7_15 = v2.mDatabase.query("driverStatus", null, (String)var2_8, var8_16, null, null, null);
                    if (var7_15 != null) ** GOTO lbl-1000
                }
                {
                    BDLog.e("ShareLocationManager", "[loadWayPoint]: cursor is null");
                    var0_3 = false;
                    if (var7_15 == null) return var0_3;
                }
                var7_15.close();
                return var0_3;
lbl-1000:
                // 1 sources

                {
                    if (this.mDatabase.isOpen() && var7_15.moveToFirst()) ** GOTO lbl-1000
                    v4 = var7_15;
                    v4.close();
                    BDLog.e("ShareLocationManager", "[loadWayPoint]: Datsbase is close or cursor is empty");
                    var0_4 = false;
                    if (v4 == null) return var0_4;
                }
                var7_15.close();
                return var0_4;
lbl-1000:
                // 2 sources

                {
                    v5 = var3_11;
                    v6 = var7_15;
                }
                var8_16 = v7;
                {
                    v7 = new HashMap();
                }
                {
                    var4_12 /* !! */  = v6.getString(0);
                    if (!v5.equals(var4_12 /* !! */ )) ** GOTO lbl-1000
                }
                try {
                    v8 = this;
                }
                catch (Exception var2_9) {
                    var4_12 /* !! */  = var1_6 /* !! */ ;
                    ** GOTO lbl-1000
                }
                var4_12 /* !! */  = v9;
                {
                    new ContentValues().put("orderId", (String)var1_6 /* !! */ );
                    v8.mDatabase.update("driverStatus", (ContentValues)var4_12 /* !! */ , (String)var2_8, new String[]{var3_11});
                }
                var4_12 /* !! */  = var1_6 /* !! */ ;
lbl-1000:
                // 2 sources

                {
                    v10 = var7_15;
                    v11 = var8_16;
                    v12 = var7_15;
                    v13 = var8_16;
                    v14 = var7_15;
                    v15 = var8_16;
                    v16 = var7_15;
                    var8_16.put("order_id", var4_12 /* !! */ );
                }
                var1_6 /* !! */  = "company";
                {
                    v15.put(var1_6 /* !! */ , v16.getString(1));
                }
                var1_6 /* !! */  = "order_attr";
                {
                    v13.put(var1_6 /* !! */ , v14.getString(2));
                }
                var1_6 /* !! */  = "status";
                {
                    v11.put(var1_6 /* !! */ , v12.getInt(3));
                }
                {
                    var1_6 /* !! */  = v10.getString(4);
                }
                {
                    var8_16.put("waypoints", var1_6 /* !! */ );
                }
                {
                    var1_6 /* !! */  = var1_6 /* !! */ .split("\\|");
                }
                {
                    if (var1_6 /* !! */ .length > 0) {
                        var5_13 = var1_6 /* !! */ .length;
                    }
                    v17 = this;
                    v18 = this;
                    var1_6 /* !! */  = "trip_mode";
                }
                {
                    var8_16.put(var1_6 /* !! */ , this.getTripMode());
                }
                var1_6 /* !! */  = "token";
                {
                    var8_16.put(var1_6 /* !! */ , v18.whetherToEncodeParameter(v18.mAuthToken, true));
                }
                {
                    var1_6 /* !! */  = v17.getRequestData((Map<String, Object>)var8_16, 1);
                    if (v17.mShareManagerImpl == null) ** GOTO lbl-1000
                    var8_16.put("sign", this.mShareManagerImpl.getSignMD5String((String)var1_6 /* !! */ ));
                }
lbl-1000:
                // 2 sources

                {
                    BDLog.e("ShareLocationManager paramDriver", (String)var1_6 /* !! */ );
                    var6_14 = this.getRequestData((Map<String, Object>)var8_16, 0);
                    BDLog.d("ShareLocationManager", " load waypoint driver data:" + var6_14);
                    if (var7_15 == null) return this.requestUpdateDriverStatus((String)var4_12 /* !! */ , var6_14, var5_13);
                }
lbl122:
                // 2 sources

                while (true) {
                    var7_15.close();
                    return this.requestUpdateDriverStatus((String)var4_12 /* !! */ , var6_14, var5_13);
                }
lbl-1000:
                // 3 sources

                {
                    BDLog.dforce("ShareLocationManager", "updateWayPointInfo exception: " + var2_8.toString());
                    if (var7_15 == null) return this.requestUpdateDriverStatus((String)var4_12 /* !! */ , var6_14, var5_13);
                    ** continue;
                }
            }
            if (var7_15 == null) throw var0_5;
            var7_15.close();
            throw var0_5;
        }
        BDLog.dforce("ShareLocationManager", "Load way point info error beacause database can't error");
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean loadRouteInfo(String string2) {
        Throwable throwable222222;
        Cursor cursor;
        block47: {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                BDLog.e(TAG, "[loadRouteInfo]: orderId is empty");
                return false;
            }
            String string3 = "orderId = ?";
            String[] stringArray = new String[1];
            Object object = stringArray;
            stringArray[0] = string2;
            Object object2 = this.mDatabase;
            if (object2 != null && object2.isOpen()) {
                Object object3;
                block46: {
                    block45: {
                        block44: {
                            block43: {
                                block42: {
                                    ContentValues contentValues;
                                    block38: {
                                        boolean bl;
                                        block41: {
                                            block39: {
                                                boolean bl2;
                                                block40: {
                                                    block36: {
                                                        boolean bl3;
                                                        block37: {
                                                            block34: {
                                                                boolean bl4;
                                                                block35: {
                                                                    HashMap hashMap;
                                                                    object2 = hashMap;
                                                                    hashMap = new HashMap();
                                                                    cursor = null;
                                                                    cursor = this.mDatabase.query("routeInfo", null, string3, (String[])object, null, null, null);
                                                                    if (cursor != null) break block34;
                                                                    BDLog.e(TAG, "[loadRouteInfo]: cursor is null 0");
                                                                    bl4 = false;
                                                                    if (cursor == null) break block35;
                                                                    cursor.close();
                                                                }
                                                                return bl4;
                                                            }
                                                            if (this.mDatabase.isOpen()) break block36;
                                                            Cursor cursor2 = cursor;
                                                            cursor2.close();
                                                            BDLog.e(TAG, "[loadRouteInfo]: database is close");
                                                            bl3 = false;
                                                            if (cursor2 == null) break block37;
                                                            cursor.close();
                                                        }
                                                        return bl3;
                                                    }
                                                    object = "-+~$#empty_parent_id#$~+-_" + this.mHashCode;
                                                    if (cursor.moveToFirst()) break block38;
                                                    ShareLocationManager shareLocationManager = this;
                                                    cursor.close();
                                                    String[] stringArray2 = new String[1];
                                                    object3 = stringArray2;
                                                    stringArray2[0] = object;
                                                    cursor = shareLocationManager.mDatabase.query("routeInfo", null, string3, (String[])object3, null, null, null);
                                                    if (cursor != null) break block39;
                                                    BDLog.e(TAG, "[loadRouteInfo]: cursor is null");
                                                    bl2 = false;
                                                    if (cursor == null) break block40;
                                                    cursor.close();
                                                }
                                                return bl2;
                                            }
                                            if (this.mDatabase.isOpen() && cursor.moveToFirst()) break block38;
                                            Cursor cursor3 = cursor;
                                            cursor3.close();
                                            BDLog.e(TAG, "[loadRouteInfo]: Datsbase is close or cursor is empty");
                                            bl = false;
                                            if (cursor3 == null) break block41;
                                            cursor.close();
                                        }
                                        return bl;
                                    }
                                    Object object4 = object;
                                    object3 = cursor.getString(0);
                                    if (!((String)object4).equals(object3)) break block42;
                                    ShareLocationManager shareLocationManager = this;
                                    object3 = contentValues;
                                    new ContentValues().put("orderId", string2);
                                    shareLocationManager.mDatabase.update("routeInfo", object3, string3, new String[]{object});
                                    object3 = string2;
                                }
                                Cursor cursor4 = cursor;
                                Object object5 = object2;
                                Cursor cursor5 = cursor;
                                Object object6 = object2;
                                Cursor cursor6 = cursor;
                                Object object7 = object2;
                                Cursor cursor7 = cursor;
                                Object object8 = object2;
                                Cursor cursor8 = cursor;
                                Object object9 = object2;
                                Cursor cursor9 = cursor;
                                Object object10 = object2;
                                Cursor cursor10 = cursor;
                                Object object11 = object2;
                                Cursor cursor11 = cursor;
                                object2.put("order_id", object3);
                                string2 = "company";
                                object11.put(string2, cursor11.getString(1));
                                string2 = "order_attr";
                                object10.put(string2, cursor10.getString(2));
                                string2 = "status";
                                object9.put(string2, cursor9.getInt(3));
                                string2 = "session_id";
                                object8.put(string2, cursor8.getString(4));
                                string2 = "route_id";
                                object7.put(string2, cursor7.getString(5));
                                string2 = "modify_time";
                                object6.put(string2, cursor6.getInt(6));
                                string2 = cursor5.getString(7);
                                object5.put("order_type", string2);
                                string3 = cursor4.getString(8);
                                if (!"1".equals(string2)) break block43;
                                object2.put("sub_orders_seq", string3);
                            }
                            Cursor cursor12 = cursor;
                            string3 = cursor12.getString(10);
                            object = cursor12.getString(11);
                            String string4 = cursor12.getString(12);
                            String string5 = cursor12.getString(13);
                            String string6 = cursor12.getString(14);
                            if (!"0".equals(string2)) break block44;
                            Object object12 = object2;
                            Object object13 = object12;
                            Object object14 = object12;
                            Object object15 = object12;
                            Object object16 = object12;
                            object12.put("end_name", string3);
                            object14.put("end_point", object);
                            object15.put("end_poiid", string4);
                            object16.put("waypoints", string5);
                            object13.put("pathplan_points", string6);
                        }
                        ShareLocationManager shareLocationManager = this;
                        Object object17 = object2;
                        ShareLocationManager shareLocationManager2 = this;
                        string2 = "trip_mode";
                        object2.put(string2, this.getTripMode());
                        string2 = "token";
                        object17.put(string2, shareLocationManager2.whetherToEncodeParameter(shareLocationManager2.mAuthToken, true));
                        string2 = shareLocationManager.getRequestData((Map<String, Object>)object17, 1);
                        if (shareLocationManager.mShareManagerImpl == null) break block45;
                        object2.put("sign", this.mShareManagerImpl.getSignMD5String(string2));
                    }
                    BDLog.e("ShareLocationManagerparamSign", string2);
                    string2 = this.getRequestData((Map<String, Object>)object2, 0);
                    BDLog.d(TAG, "*******load route data:" + string2);
                    if (cursor == null) break block46;
                    cursor.close();
                }
                return this.sendRouteInfo((String)object3, string2, (Map<String, Object>)object2);
            }
            BDLog.dforce(TAG, "Load route info error beacause database can't error");
            return false;
            {
                boolean bl;
                block48: {
                    catch (Throwable throwable222222) {
                        break block47;
                    }
                    catch (Exception exception) {}
                    {
                        BDLog.dforce(TAG, "loadRouteInfo exception happened.", exception);
                        bl = false;
                        if (cursor == null) break block48;
                    }
                    cursor.close();
                }
                return bl;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        throw throwable222222;
    }

    /*
     * Exception decompiling
     */
    private synchronized boolean loadOrderInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 47[TRYBLOCK] [90 : 789->799)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized OrderInfoProtocol loadParentOrderInfo() {
        Throwable throwable222222;
        Cursor cursor;
        block14: {
            ShareLocationManager shareLocationManager;
            Object object = shareLocationManager.mDatabase;
            if (object != null && object.isOpen()) {
                block13: {
                    block11: {
                        block12: {
                            block9: {
                                block10: {
                                    OrderInfoProtocol orderInfoProtocol;
                                    object = orderInfoProtocol;
                                    orderInfoProtocol = new OrderInfoProtocol();
                                    cursor = null;
                                    cursor = shareLocationManager.mDatabase.query("parentOrderInfo", null, null, null, null, null, null);
                                    if (cursor != null) break block9;
                                    BDLog.e(TAG, "[loadParentOrderInfo]: cursor is null");
                                    shareLocationManager = null;
                                    if (cursor == null) break block10;
                                    cursor.close();
                                }
                                return shareLocationManager;
                            }
                            if (!shareLocationManager.mDatabase.isOpen() || !cursor.moveToFirst()) break block11;
                            ((OrderInfoProtocol)object).setOrderId(cursor.getString(0));
                            ((OrderInfoProtocol)object).companyServerId = cursor.getString(1);
                            ((OrderInfoProtocol)object).driverId = cursor.getString(2);
                            ((OrderInfoProtocol)object).orderState = cursor.getInt(3);
                            ((OrderInfoProtocol)object).orderType = cursor.getInt(4);
                            if (cursor == null) break block12;
                            cursor.close();
                        }
                        return object;
                    }
                    Cursor cursor2 = cursor;
                    cursor2.close();
                    BDLog.e(TAG, "[loadParentOrderInfo]:Database is close or cursor is empty when load order info");
                    shareLocationManager = null;
                    if (cursor2 == null) break block13;
                    cursor.close();
                }
                return shareLocationManager;
            }
            BDLog.dforce(TAG, "[loadParentOrderInfo]:Load order info error because database error");
            return null;
            {
                block15: {
                    catch (Throwable throwable222222) {
                        break block14;
                    }
                    catch (Exception exception) {}
                    {
                        BDLog.e(TAG, "[loadParentOrderInfo]:Database exception happened");
                        shareLocationManager = null;
                        if (cursor == null) break block15;
                    }
                    cursor.close();
                }
                return shareLocationManager;
            }
        }
        if (cursor != null) {
            cursor.close();
        }
        throw throwable222222;
    }

    private String makeSqlPlacekHolder(int n5) {
        StringBuffer stringBuffer;
        if (n5 <= 0) {
            return "";
        }
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append("?");
        for (int i5 = 1; i5 < n5; ++i5) {
            stringBuffer2.append(",?");
        }
        return stringBuffer2.toString();
    }

    private String[] getSelectArgs(String object, Set<String> stringArray) {
        int n5 = stringArray.size() + 1;
        String[] stringArray2 = new String[n5];
        stringArray = stringArray2;
        stringArray2[0] = object;
        object = stringArray.iterator();
        int n6 = 1;
        while (object.hasNext() && n6 < n5) {
            String string2;
            stringArray[n6++] = string2 = (String)object.next();
        }
        return stringArray;
    }

    private synchronized boolean sendRouteInfo(final String string2, final String string3, final Map<String, Object> map) {
        if (!this.mIsStopSynServer && this.mIsOrderRegisted) {
            if (map != null && string3 != null && !string3.isEmpty()) {
                HttpClient.ProtoResultCallBack protoResultCallBack;
                HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
                protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                    @Override
                    public void onSuccess(String string22) {
                        4 v02 = string32;
                        BDLog.d(ShareLocationManager.TAG, "update route success");
                        ShareLocationManager.access$2002(v02.ShareLocationManager.this, 0);
                        String[] stringArray = new String[1];
                        String[] stringArray2 = stringArray;
                        stringArray[0] = string32.string2;
                        v02.ShareLocationManager.this.mDatabase.delete("routeInfo", "orderId = ?", stringArray2);
                        if (v02.ShareLocationManager.this.mShareManagerImpl != null) {
                            4 v22 = string32;
                            String string32 = String.valueOf(v22.ShareLocationManager.this.parseResponseStatus(string22));
                            string22 = v22.ShareLocationManager.this.mHashCode;
                            string32.ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.6", "dp", string32, string22);
                        }
                    }

                    @Override
                    public void onFailed(HttpClient.HttpStateError object, String string22) {
                        BDLog.e(ShareLocationManager.TAG, "update route failed,errCode:" + (Object)object + "result:" + string22);
                        if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.USER_DELETED_BY_ADMIN != object && HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT != object) {
                            if (HttpClient.HttpStateError.NETWORK_ERROR == object) {
                                if (string6.ShareLocationManager.this.mCountUpdateRouteInfoError < 2) {
                                    String string32 = string6;
                                    string32.ShareLocationManager.this.mCountUpdateRouteInfoError++;
                                    String string4 = string6;
                                    string22 = string4.string2;
                                    String string5 = string4.string3;
                                    Map map2 = string4.map;
                                    string32.ShareLocationManager.this.sendRouteInfo(string22, string5, map2);
                                } else {
                                    ShareLocationManager.access$2002(string6.ShareLocationManager.this, 0);
                                }
                            } else {
                                ShareLocationManager.access$2002(string6.ShareLocationManager.this, 0);
                            }
                        } else {
                            ShareLocationManager.access$1502(string6.ShareLocationManager.this, true);
                        }
                        if (string6.ShareLocationManager.this.mShareManagerImpl != null) {
                            4 v22 = string6;
                            String string6 = String.valueOf(object.getValue());
                            object = v22.ShareLocationManager.this.mHashCode;
                            string6.ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.6", "dp", string6, (String)object);
                        }
                    }
                };
                this.mBaseRequest.sendRequest(3, "POST", string3, protoResultCallBack2);
                return true;
            }
            return false;
        }
        BDLog.e(TAG, "[sendRouteInfo]: User is deleted by admin or order register failed");
        return false;
    }

    private synchronized boolean sendRegisterOrder(final String string2, final List<OrderInfoProtocol> list) {
        HttpClient.ProtoResultCallBack protoResultCallBack;
        if (object.mIsStopSynServer) {
            BDLog.e(TAG, "[sendRegisterOrder]: User is deleted by admin");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
        protoResultCallBack = new HttpClient.ProtoResultCallBack(){

            @Override
            public void onSuccess(String string22) {
                5 v02 = string3;
                BDLog.d(ShareLocationManager.TAG, "register order success");
                ShareLocationManager.access$2302(v02.ShareLocationManager.this, 0);
                ShareLocationManager.access$2402(v02.ShareLocationManager.this, 0);
                ShareLocationManager.access$2502(v02.ShareLocationManager.this, 0);
                v02.ShareLocationManager.this.handleRegisterOrderResult(string22, string3.list);
                if (v02.ShareLocationManager.this.mShareManagerImpl != null) {
                    5 v12 = string3;
                    String string3 = String.valueOf(v12.ShareLocationManager.this.parseResponseStatus(string22));
                    string22 = v12.ShareLocationManager.this.mHashCode;
                    string3.ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.6", "dr", string3, string22);
                }
            }

            @Override
            public void onFailed(HttpClient.HttpStateError object, String string22) {
                BDLog.e(ShareLocationManager.TAG, "register order failed,errCode:" + (Object)object + "result:" + string22);
                if (HttpClient.HttpStateError.SERVER_INNER == object) {
                    if (string3.ShareLocationManager.this.mCountRegisterServerError < 1) {
                        5 v02 = string3;
                        v02.ShareLocationManager.this.mCountRegisterServerError++;
                        5 v12 = string3;
                        string22 = v12.string2;
                        v02.ShareLocationManager.this.sendRegisterOrder(string22, v12.list);
                    }
                } else if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.USER_DELETED_BY_ADMIN != object && HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT != object) {
                    if (HttpClient.HttpStateError.NETWORK_ERROR == object) {
                        if (string3.ShareLocationManager.this.mCountRegisterNetError < 2) {
                            Object object2 = string3;
                            object2.ShareLocationManager.this.mCountRegisterNetError++;
                            Object object3 = string3;
                            string22 = object3.string2;
                            object2.ShareLocationManager.this.sendRegisterOrder(string22, object3.list);
                        } else {
                            BDLog.e(ShareLocationManager.TAG, "network error times:" + string3.ShareLocationManager.this.mCountRegisterNetError);
                        }
                    } else if (HttpClient.HttpStateError.PART_ORDERS_REG_FAILED == object) {
                        string3.ShareLocationManager.this.handleRegisterOrderResult(string22, string3.list);
                    } else if (HttpClient.HttpStateError.PARAM_ERROR == object && !string3.ShareLocationManager.this.isParentOrderInfoEmpty()) {
                        string3.ShareLocationManager.this.removeAllUnregisterOrder(string3.list);
                    } else if (HttpClient.HttpStateError.ORDER_ATTR_DISMATCH == object || HttpClient.HttpStateError.PARENT_ORDER_NOT_EXIST == object || HttpClient.HttpStateError.PARENT_ORDER_FINISH == object) {
                        string3.ShareLocationManager.this.removeAllUnregisterOrder(string3.list);
                    }
                } else {
                    ShareLocationManager.access$1502(string3.ShareLocationManager.this, true);
                }
                if (string3.ShareLocationManager.this.mShareManagerImpl != null) {
                    5 v42 = string3;
                    String string3 = String.valueOf(object.getValue());
                    object = v42.ShareLocationManager.this.mHashCode;
                    string3.ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.6", "dr", string3, (String)object);
                }
            }
        };
        Object object = HttpClient.ContentType.FORM_DATA;
        object.mBaseRequest.sendRequest(1, "POST", string2, protoResultCallBack2, (HttpClient.ContentType)((Object)object));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeAllUnregisterOrder(List<OrderInfoProtocol> object) {
        if (object == null) return;
        if (object.size() <= 0) {
            return;
        }
        SQLiteDatabase object22 = this.mDatabase;
        if (object22 == null) return;
        if (!object22.isOpen()) {
            return;
        }
        Set<String> set = object;
        object = this.mUnRegisterOrderSet;
        synchronized (object) {
            this.mUnRegisterOrderSet.clear();
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : object
            object = set.iterator();
        }
        while (object.hasNext()) {
            OrderInfoProtocol orderInfoProtocol = (OrderInfoProtocol)object.next();
            if (orderInfoProtocol == null) continue;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = orderInfoProtocol.getOrderId();
            stringArray[1] = "register_order";
            this.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", stringArray2);
        }
    }

    private void setCommonInfo(JSONObject jSONObject, OrderInfoProtocol orderInfoProtocol) {
        int n5;
        if (orderInfoProtocol == null) {
            BDLog.e(TAG, "[getParentOrderInfo]:orderIdList is null, getParentOrderInfo failed");
            return;
        }
        OrderInfoProtocol orderInfoProtocol2 = orderInfoProtocol;
        Object object = orderInfoProtocol2.preOrderId;
        if (orderInfoProtocol2.orderType == 0 && !TextUtils.isEmpty((CharSequence)object) && (object = this.mParentOrderInfo) != null && !((OrderInfoProtocol)object).getOrderId().equals(orderInfoProtocol.getOrderId())) {
            BDLog.e(TAG, "[getParentOrderInfo]:previousOrderId is normal");
            return;
        }
        if (this.mParentOrderInfo == null) {
            OrderInfoProtocol orderInfoProtocol3;
            object = orderInfoProtocol3;
            orderInfoProtocol3 = new OrderInfoProtocol();
            this.mParentOrderInfo = object;
        }
        object = this.mParentOrderInfo;
        ((OrderInfoProtocol)object).orderType = n5 = orderInfoProtocol.orderType;
        ((OrderInfoProtocol)object).driverId = orderInfoProtocol.driverId;
        this.mParentOrderInfo.companyServerId = orderInfoProtocol.companyServerId;
        if (1 == n5) {
            ((OrderInfoProtocol)object).orderState = 10;
            ((OrderInfoProtocol)object).setOrderId(jSONObject.optString("parent_order_id"));
        } else if (n5 == 0) {
            ((OrderInfoProtocol)object).setOrderId(orderInfoProtocol.getOrderId());
        }
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.insertParentOrderInfoToDataBase(shareLocationManager.mParentOrderInfo);
    }

    private boolean insertParentOrderInfoToDataBase(OrderInfoProtocol orderInfoProtocol) {
        if (!(orderInfoProtocol == null || TextUtils.isEmpty((CharSequence)orderInfoProtocol.companyServerId) || TextUtils.isEmpty((CharSequence)orderInfoProtocol.driverId) || TextUtils.isEmpty((CharSequence)orderInfoProtocol.getOrderId()) || DEFAULT_PARENT_ORDER_ID.equals(orderInfoProtocol.getOrderId()))) {
            Object[] objectArray = ((ShareLocationManager)((Object)string2)).mDatabase;
            if (((ShareLocationManager)((Object)string2)).mDatabase != null && objectArray.isOpen()) {
                ShareLocationManager shareLocationManager;
                try {
                    ShareLocationManager shareLocationManager2 = string2;
                    shareLocationManager = shareLocationManager2;
                    shareLocationManager2.mDatabase.delete("parentOrderInfo", "", null);
                }
                catch (Exception exception) {
                    BDLog.e(TAG, "[loadParentOrderInfo]:Database exception happened");
                    return false;
                }
                String string2 = "insert into parentOrderInfo (orderId,companyServerId,driverId,orderState,order_type) values(?,?,?,?,?)";
                Object[] objectArray2 = new String[5];
                objectArray = objectArray2;
                int n5 = 0;
                objectArray[n5] = orderInfoProtocol.getOrderId();
                n5 = 1;
                objectArray[n5] = orderInfoProtocol.companyServerId;
                n5 = 2;
                objectArray2[n5] = orderInfoProtocol.driverId;
                objectArray2[3] = String.valueOf(orderInfoProtocol.orderState);
                objectArray2[4] = String.valueOf(orderInfoProtocol.orderType);
                shareLocationManager.mDatabase.execSQL(string2, objectArray);
                return true;
            }
            return false;
        }
        BDLog.e(TAG, "[insertParentOrderInfoToDataBase]:parent order info is empty");
        return false;
    }

    private void removeParentOrderRelatedInfoFromDB(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.removeOrderInfoFromDB(string2);
        shareLocationManager.removeRouteInfoFromDB(string2);
        shareLocationManager.removeParentOrderInfoFromDB();
    }

    private void removeLastParentOrderReleatedInfoFromDB() {
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.removeRouteInfoWithDefaultParentIDFromDB();
        OrderInfoProtocol orderInfoProtocol = shareLocationManager.loadParentOrderInfo();
        if (orderInfoProtocol == null) {
            BDLog.e(TAG, "preOrderInfo is null");
            return;
        }
        if (orderInfoProtocol.orderType == 0) {
            OrderInfoProtocol orderInfoProtocol2 = orderInfoProtocol;
            orderInfoProtocol2.setOrderId(MD5Util.getMD5String(orderInfoProtocol2.getOrderId(), orderInfoProtocol.companyServerId));
        }
        this.removeParentOrderRelatedInfoFromDB(orderInfoProtocol.getOrderId());
    }

    private void removeParentOrderInfoFromDB() {
        SQLiteDatabase sQLiteDatabase = this.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            try {
                this.mDatabase.delete("parentOrderInfo", "", null);
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[removeParentOrderInfoFromDataBase]:Database exception happened");
                return;
            }
        }
    }

    private void removeOrderInfoFromDB(String string2) {
        String string3 = "parent_order_id = ?";
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = string2;
        string2 = this.mDatabase;
        if (string2 != null && string2.isOpen()) {
            try {
                this.mDatabase.delete("orderInfo", string3, stringArray2);
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[removeParentOrderInfoFromDataBase]:Database exception happened");
                return;
            }
        }
    }

    private void removeRouteInfoFromDB(String string2) {
        SQLiteDatabase sQLiteDatabase = this.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            SQLiteDatabase sQLiteDatabase2;
            try {
                sQLiteDatabase2 = this.mDatabase;
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[removeParentOrderInfoFromDataBase]:Database exception happened");
                return;
            }
            sQLiteDatabase2.delete("routeInfo", "orderId = ?", new String[]{string2});
        }
    }

    private void removeRouteInfoWithDefaultParentIDFromDB() {
        SQLiteDatabase sQLiteDatabase = this.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            SQLiteDatabase sQLiteDatabase2;
            try {
                sQLiteDatabase2 = this.mDatabase;
            }
            catch (Exception exception) {
                BDLog.e(TAG, "[removeParentOrderInfoFromDataBase]:Database exception happened");
                return;
            }
            sQLiteDatabase2.delete("routeInfo", "orderId like ?", new String[]{"-+~$#empty_parent_id#$~+-_%"});
        }
    }

    private void handleRegisterOrderResult(String string2, List<OrderInfoProtocol> list) {
        JSONObject jSONObject;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[handleRegOrderResult]:result is empty");
            return;
        }
        JSONObject jSONObject2 = jSONObject;
        try {
            int n5 = new JSONObject(string2).optInt("status");
            if (HttpClient.HttpStateError.NO_ERROR.getValue() != n5 && HttpClient.HttpStateError.ORDER_EXIST.getValue() != n5) {
                this.handleNotAllRegisterSuccessResult(jSONObject2, list);
            } else {
                this.handleRegisterSuccessResult(jSONObject2, list);
                this.mIsOrderRegisted = true;
            }
            return;
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
    }

    private void handleRegisterSuccessResult(JSONObject object, List<OrderInfoProtocol> object2) {
        if (object2 != null && object2.size() > 0) {
            ShareLocationManager shareLocationManager = this;
            shareLocationManager.setCommonInfo((JSONObject)object, object2.get(0));
            object = shareLocationManager.mDatabase;
            if (object != null && object.isOpen()) {
                object = object2.iterator();
                while (object.hasNext()) {
                    object2 = (OrderInfoProtocol)object.next();
                    if (object2 == null) continue;
                    this.removeUnregisterOrder(((OrderInfoProtocol)object2).getOrderId());
                }
                return;
            }
            BDLog.e(TAG, "datebase is not open");
            return;
        }
        BDLog.e(TAG, "[handleSuccessResult]:orderIdList is empty");
    }

    private void handleNotAllRegisterSuccessResult(JSONObject jSONObject, List<OrderInfoProtocol> list) {
        if (jSONObject == null) {
            return;
        }
        JSONArray jSONArray = jSONObject.optJSONArray("order_detail");
        if (jSONArray == null) {
            return;
        }
        JSONObject jSONObject2 = null;
        boolean bl = false;
        for (int i5 = 0; i5 < jSONArray.length(); ++i5) {
            try {
                jSONObject2 = (JSONObject)jSONArray.get(i5);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            if (jSONObject2 == null) continue;
            int n5 = jSONObject2.optInt("status");
            String string2 = jSONObject2.optString("order");
            if (n5 != 0) {
                if (n5 != 1000) {
                    if (n5 != 1100) {
                        continue;
                    }
                } else {
                    OrderInfoProtocol orderInfoProtocol = this.findRegisterOrderInfo(list, string2);
                    if (orderInfoProtocol == null) continue;
                    this.removeUnregisterOrder(orderInfoProtocol.getOrderId());
                    continue;
                }
            }
            this.mIsOrderRegisted = true;
            OrderInfoProtocol orderInfoProtocol = this.findRegisterOrderInfo(list, string2);
            if (orderInfoProtocol == null) continue;
            this.removeUnregisterOrder(orderInfoProtocol.getOrderId());
            if (bl) continue;
            this.setCommonInfo(jSONObject, orderInfoProtocol);
            bl = true;
        }
        int n6 = this.mCountRegisterPartFailed;
        if (n6 < 1) {
            this.mCountRegisterPartFailed = n6 + 1;
            this.loadOrderInfo();
        }
    }

    private void removeUnregisterOrder(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        String[] stringArray = this.mDatabase;
        if (this.mDatabase != null && stringArray.isOpen()) {
            String[] stringArray2 = new String[2];
            stringArray = stringArray2;
            stringArray2[0] = string2;
            stringArray2[1] = "register_order";
            this.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", stringArray);
        }
        this.removeOrderFromUnRegisterList(string2);
    }

    private void removeNotUpdateOrder(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        SQLiteDatabase sQLiteDatabase = stringArray2.mDatabase;
        if (sQLiteDatabase != null && sQLiteDatabase.isOpen()) {
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            stringArray[0] = string2;
            stringArray[1] = "update_order";
            stringArray2.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", stringArray2);
        }
    }

    private OrderInfoProtocol findRegisterOrderInfo(List<OrderInfoProtocol> object, String string2) {
        if (object != null && object.size() > 0) {
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            Iterator<OrderInfoProtocol> iterator = object.iterator();
            object = null;
            while (iterator.hasNext()) {
                object = (OrderInfoProtocol)iterator.next();
                if (object == null) continue;
                if (string2.equals(MD5Util.getMD5String(((OrderInfoProtocol)object).getOrderId(), ((OrderInfoProtocol)object).companyServerId))) break;
                object = null;
            }
            return object;
        }
        return null;
    }

    private synchronized boolean driverOrderChange(String string2, String string3, int n5) {
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2;
            if (((ShareLocationManager)((Object)string5)).isParentOrderInfoEmpty()) {
                BDLog.e(TAG, "mParentOrderInfo is null");
                return false;
            }
            HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
            hashMap2();
            String string4 = ((ShareLocationManager)((Object)string5)).getParentOrderId();
            hashMap2.put("order_id", string4);
            hashMap2.put("company", ((ShareLocationManager)((Object)string5)).mParentOrderInfo.companyServerId);
            hashMap2.put("order_attr", ((ShareLocationManager)((Object)string5)).mParentOrderInfo.driverId);
            hashMap3.put("status", ((ShareLocationManager)((Object)string5)).mParentOrderInfo.orderState);
            hashMap3.put("waypoints", string2);
            hashMap3.put("pathplan_points", string3);
            hashMap.put("trip_mode", ((ShareLocationManager)((Object)string5)).getTripMode());
            Object[] objectArray = ((ShareLocationManager)((Object)string5)).mDatabase;
            if (((ShareLocationManager)((Object)string5)).mDatabase != null && objectArray.isOpen()) {
                ShareLocationManager shareLocationManager = string5;
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = string4;
                shareLocationManager.mDatabase.delete("driverStatus", "orderId = ?", (String[])objectArray);
                String[] stringArray = new String[6];
                objectArray = stringArray;
                objectArray[0] = string4;
                objectArray[1] = (String)hashMap2.get("company");
                objectArray[2] = (String)hashMap2.get("order_attr");
                stringArray[3] = String.valueOf(hashMap2.get("status"));
                stringArray[4] = string2;
                stringArray[5] = string3;
                shareLocationManager.mDatabase.execSQL("insert into driverStatus (orderId,companyServerId,driverId,orderState,waypoints,pathplan_points)values(?,?,?,?,?,?)", objectArray);
            }
            ShareLocationManager shareLocationManager = string5;
            String string5 = ((ShareLocationManager)((Object)string5)).getRequestData(hashMap2, 0);
            BDLog.e("ShareLocationManager driver data request", string5);
            return shareLocationManager.requestUpdateDriverStatus(string4, string5, n5);
        }
        BDLog.e(TAG, "waypointsSeq is null");
        return false;
    }

    private synchronized boolean registerOrder(List<OrderInfoProtocol> list) {
        if (list != null && list.size() > 0) {
            JSONObject jSONObject;
            JSONArray jSONArray;
            JSONArray jSONArray2 = jSONArray;
            jSONArray = new JSONArray();
            String string2 = this.getCoordTypeStr();
            int n5 = 0;
            while (true) {
                block15: {
                    if (n5 >= list.size()) break;
                    Object object = list.get(n5);
                    if (object == null) break block15;
                    Object object2 = this.generateOneRegParam((OrderInfoProtocol)object, string2);
                    if (object2 == null) break block15;
                    ShareLocationManager shareLocationManager = this;
                    this.addOrderToUnRegisterList(((OrderInfoProtocol)object).getOrderId());
                    jSONArray2.put(n5, (Object)new JSONObject(object2));
                    if (shareLocationManager.mShareManagerImpl == null) break block15;
                    SyncShareImpl syncShareImpl = this.mShareManagerImpl;
                    OrderInfoProtocol orderInfoProtocol = object;
                    object = "w.1.7.1";
                    object2 = orderInfoProtocol.getOrderId();
                    String string3 = orderInfoProtocol.driverId;
                    String string4 = this.mHashCode;
                    syncShareImpl.addUserOP((String)object, (String)object2, string3, string4);
                }
                ++n5;
            }
            ShareLocationManager shareLocationManager = this;
            try {
                BDLog.d(TAG, "jsonArray : " + jSONArray2.toString());
                JSONObject jSONObject2 = new JSONObject();
                jSONObject = jSONObject2;
                jSONObject2.put("order_detail", (Object)jSONArray2);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                return false;
            }
            return shareLocationManager.sendRegisterOrder(shareLocationManager.generateRegisterOrderSubUrl(jSONObject), list);
        }
        BDLog.e(TAG, "BNOrderInfo is null");
        return false;
    }

    private String generateRegisterOrderSubUrl(JSONObject object) {
        ShareLocationManager shareLocationManager = this;
        object = object.toString();
        String string2 = shareLocationManager.whetherToEncodeParameter(shareLocationManager.mAuthToken, true);
        object = shareLocationManager.whetherToEncodeParameter((String)object, true);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)object)) {
            String string3 = "orders=" + (String)object + "&token=" + string2;
            String string4 = "";
            SyncShareImpl syncShareImpl = this.mShareManagerImpl;
            if (syncShareImpl != null) {
                string4 = syncShareImpl.getSignMD5String(string3);
            }
            if (TextUtils.isEmpty((CharSequence)string4)) {
                BDLog.e(TAG, "[generateRegisterOrderSubUrl]: sign is null");
                return "";
            }
            String string5 = "orders=" + this.whetherToEncodeParameter((String)object, true) + "&token=" + this.whetherToEncodeParameter(string2, true) + "&sign=" + this.whetherToEncodeParameter(string4, true);
            BDLog.d(TAG, string5);
            return string5;
        }
        return "";
    }

    private Map<String, Object> generateOneRegParam(OrderInfoProtocol orderInfoProtocol, String sQLiteDatabase) {
        if (orderInfoProtocol == null) {
            return null;
        }
        if (orderInfoProtocol.getOrderId() != null && orderInfoProtocol.companyServerId != null && orderInfoProtocol.driverId != null) {
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2 = hashMap;
            hashMap = new HashMap<String, Object>();
            String string2 = "0,0";
            String string3 = "0,0";
            String string4 = "";
            String string5 = "";
            String string6 = "0,0";
            String string7 = "";
            String string8 = "";
            if (orderInfoProtocol.endNode != null) {
                OrderInfoProtocol orderInfoProtocol2 = orderInfoProtocol;
                string3 = orderInfoProtocol.endNode.getLongitude() + "," + orderInfoProtocol.endNode.getLatitude();
                string4 = orderInfoProtocol2.endNode.getId();
                string5 = objectArray2.whetherToEncodeParameter(orderInfoProtocol2.endNode.getName(), true);
            }
            if (orderInfoProtocol.pickupNode != null) {
                OrderInfoProtocol orderInfoProtocol3 = orderInfoProtocol;
                string6 = orderInfoProtocol.pickupNode.getLongitude() + "," + orderInfoProtocol.pickupNode.getLatitude();
                string8 = orderInfoProtocol3.pickupNode.getId();
                string7 = objectArray2.whetherToEncodeParameter(orderInfoProtocol3.pickupNode.getName(), true);
            }
            if (orderInfoProtocol.curLocationNode != null) {
                string2 = orderInfoProtocol.curLocationNode.getLongitude() + "," + orderInfoProtocol.curLocationNode.getLatitude();
            }
            HashMap<String, Object> hashMap3 = hashMap2;
            HashMap<String, Object> hashMap4 = hashMap2;
            hashMap2.put("order_id", MD5Util.getMD5String(orderInfoProtocol.getOrderId(), orderInfoProtocol.companyServerId));
            hashMap2.put("company", orderInfoProtocol.companyServerId);
            hashMap2.put("origin_oid", orderInfoProtocol.getOrderId());
            hashMap2.put("order_attr", orderInfoProtocol.driverId);
            hashMap4.put("status", orderInfoProtocol.orderState);
            hashMap4.put("cur_point", string2);
            hashMap4.put("start_point", string6);
            hashMap4.put("start_poiid", string8);
            hashMap4.put("end_point", string3);
            hashMap4.put("end_poiid", string4);
            hashMap4.put("start_name", string7);
            hashMap4.put("end_name", string5);
            hashMap2.put("cuid", objectArray2.mCuid);
            hashMap3.put("order_type", orderInfoProtocol.orderType);
            hashMap3.put("coord_type", sQLiteDatabase);
            hashMap2.put("trip_mode", objectArray2.getTripMode());
            sQLiteDatabase = objectArray2.mParentOrderInfo;
            if (sQLiteDatabase != null && !TextUtils.isEmpty((CharSequence)sQLiteDatabase.getOrderId()) && objectArray2.mParentOrderInfo.orderType == 1) {
                hashMap2.put("parent_order_id", objectArray2.getParentOrderId());
            }
            if (orderInfoProtocol.orderType == 0 && (sQLiteDatabase = orderInfoProtocol.preOrderId) != null) {
                hashMap2.put("previous_order_id", MD5Util.getMD5String((String)sQLiteDatabase, orderInfoProtocol.companyServerId));
            } else {
                hashMap2.put("previous_order_id", "");
            }
            sQLiteDatabase = objectArray2.getOutOfRangeOrdersFromDataBase("orderInfo");
            if (sQLiteDatabase != null && !sQLiteDatabase.isEmpty()) {
                objectArray2.deleteFromDB("orderInfo", (ArrayList<String>)sQLiteDatabase);
            }
            if ((sQLiteDatabase = objectArray2.mDatabase) != null && sQLiteDatabase.isOpen()) {
                Object[] objectArray = new String[2];
                Object[] objectArray2 = objectArray;
                objectArray[0] = orderInfoProtocol.getOrderId();
                objectArray[1] = "register_order";
                objectArray2.mDatabase.delete("orderInfo", "orderId = ? and remark = ?", (String[])objectArray2);
                String[] stringArray = new String[17];
                objectArray2 = stringArray;
                objectArray2[0] = orderInfoProtocol.getOrderId();
                objectArray2[1] = (String)hashMap2.get("company");
                objectArray2[2] = (String)hashMap2.get("order_attr");
                objectArray2[3] = String.valueOf(hashMap2.get("status"));
                objectArray2[4] = (String)hashMap2.get("cur_point");
                objectArray2[5] = (String)hashMap2.get("start_point");
                objectArray2[6] = (String)hashMap2.get("start_poiid");
                objectArray2[7] = (String)hashMap2.get("start_name");
                objectArray2[8] = (String)hashMap2.get("end_point");
                objectArray2[9] = (String)hashMap2.get("end_poiid");
                objectArray2[10] = (String)hashMap2.get("end_name");
                objectArray2[11] = (String)hashMap2.get("cuid");
                objectArray2[12] = "register_order";
                objectArray2[13] = String.valueOf(hashMap2.get("order_type"));
                objectArray2[14] = (String)hashMap2.get("parent_order_id");
                objectArray2[15] = (String)hashMap2.get("coord_type");
                stringArray[16] = (String)hashMap2.get("previous_order_id");
                objectArray2.mDatabase.execSQL("insert into orderInfo (orderId,companyServerId,driverId,orderState,cur_point,start_point,start_poiid,start_name,end_point,end_poiid,end_name,cuid,remark,order_type,parent_order_id,coord_type,previous_order_id)values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", objectArray2);
            }
            return hashMap2;
        }
        return null;
    }

    private String getCoordTypeStr() {
        Object object = ((ShareLocationManager)object).mShareManagerImpl;
        if (object == null) {
            return "";
        }
        if ((object = ((SyncShareImpl)object).getCoordType()) == null) {
            return "";
        }
        String string2 = "gcj02";
        int n5 = 11.$SwitchMap$com$baidu$mapapi$CoordType[object.ordinal()];
        if (n5 != 1) {
            if (n5 == 2) {
                string2 = "bd09ll";
            }
        } else {
            string2 = "gcj02";
        }
        return string2;
    }

    private int parseResponseStatus(String string2) {
        int n5;
        block5: {
            block4: {
                JSONObject jSONObject;
                ShareLocationManager shareLocationManager = jSONObject;
                try {
                    if (!new JSONObject(string2).has("status")) break block4;
                }
                catch (JSONException jSONException) {
                    BDLog.dforce(TAG, "ParseResponseStatus json happened exception", jSONException);
                    return -1;
                }
                n5 = shareLocationManager.getInt("status");
                break block5;
            }
            n5 = -1;
        }
        return n5;
    }

    private synchronized void handleEndPositionInfo(String string2) {
        OrderInfoProtocol orderInfoProtocol = this.mParentOrderInfo;
        if (orderInfoProtocol != null && orderInfoProtocol.orderType == 0 && !TextUtils.isEmpty((CharSequence)orderInfoProtocol.getOrderId())) {
            block6: {
                JSONObject jSONObject;
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return;
                }
                orderInfoProtocol = jSONObject;
                try {
                    if (new JSONObject(string2).has("data")) break block6;
                    return;
                }
                catch (JSONException jSONException) {
                    BDLog.dforce(TAG, "Parse endPosition info happened exception", jSONException);
                    return;
                }
            }
            string2 = orderInfoProtocol.optJSONObject("data");
            if (string2 != null && string2.length() != 0) {
                ShareLocationManager shareLocationManager = this;
                shareLocationManager.parseResponseExtDestination((JSONObject)string2);
                shareLocationManager.parseResponseExtOrigin((JSONObject)string2);
                shareLocationManager.parseResponseExtWayPoints((JSONObject)string2);
                shareLocationManager.parseResponseExtNextDestination((JSONObject)string2);
                shareLocationManager.parseResponseExtNextOrigin((JSONObject)string2);
                shareLocationManager.parseResponseExtNextWayPoints((JSONObject)string2);
                shareLocationManager.parseResponseExtNextPassRoute((JSONObject)string2);
                return;
            }
            return;
        }
    }

    private void parseResponseExtNextPassRoute(JSONObject jSONObject) {
        if (jSONObject.length() != 0 && jSONObject.has("ext_pass_setroute")) {
            BDLog.d(TAG, "parseResponseExtNextPassRoute" + jSONObject.toString());
            jSONObject = jSONObject.optJSONObject("ext_pass_setroute");
            if (jSONObject != null && jSONObject.length() != 0) {
                SyncShareImpl syncShareImpl = ((ShareLocationManager)((Object)syncShareImpl)).mShareManagerImpl;
                if (syncShareImpl == null) {
                    BDLog.d(TAG, "parseResponseExtNextPassRoutemShareManagerImpl is empty");
                    return;
                }
                syncShareImpl.updateOrderPassRoute(jSONObject.toString());
                return;
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void parseResponseExtNextWayPoints(JSONObject var1_2) {
        block43: {
            block36: {
                block37: {
                    block38: {
                        block39: {
                            if (var1_2.length() == 0) break block36;
                            if (!var1_2.has("ext_next_order_way_points")) break block36;
                            var1_2 = var1_2.optJSONObject("ext_next_order_way_points");
                            if (var1_2 == null) break block37;
                            if (var1_2.length() == 0) break block37;
                            var2_3 = var1_2.optJSONArray("pts");
                            if (var2_3 == null) break block38;
                            if (var2_3.length() == 0) break block38;
                            var1_2 = var1_2.optString("modify_time_ms");
                            var3_4 = 0L;
                            if (TextUtils.isEmpty((CharSequence)var1_2)) break block39;
                            var3_4 = Long.valueOf((String)var1_2);
                        }
                        var1_2 = v0;
                        v0 = new ArrayList<E>();
                        var5_5 = "";
                        var6_6 = 0;
                        while (true) {
                            block41: {
                                block40: {
                                    block42: {
                                        if (var6_6 >= var2_3.length()) break;
                                        var7_7 /* !! */  = var2_3.getJSONObject(var6_6);
                                        if (var7_7 /* !! */  == null) break block40;
                                        if (var7_7 /* !! */ .length() == 0) break block40;
                                        v1 = var7_7 /* !! */ ;
                                        v2 = v1;
                                        var5_5 = v1.optString("pt_type");
                                        var8_8 = v2.optString("order_id");
                                        if (!"way".equals(var5_5)) break block41;
                                        v3 = var7_7 /* !! */ ;
                                        v4 = v3;
                                        var5_5 = v3.optString("name");
                                        var9_9 = v4.optString("point");
                                        if (TextUtils.isEmpty((CharSequence)var9_9)) break block41;
                                        var9_9 = var9_9.split(",");
                                        if (var9_9 == null) break block41;
                                        if (var9_9.length != 2) break block41;
                                        v5 = var7_7 /* !! */ ;
                                        v6 = v5;
                                        v7 = v5;
                                        v8 = var9_9;
                                        var9_10 = Double.valueOf(var9_9[0]);
                                        var11_11 = Double.valueOf(v8[1]);
                                        var7_7 /* !! */  = v6.optString("poiid");
                                        ** try [egrp 25[TRYBLOCK] [25 : 256->259)] { 
lbl68:
                                        // 1 sources

                                        if (!"bd09ll".equals(v7.optString("coord_type"))) break block42;
                                        v9 = CoordType.BD09LL;
lbl73:
                                        // 2 sources

                                        while (true) {
                                            var13_12 = v9;
                                            ** GOTO lbl80
                                            break;
                                        }
                                    }
                                    v9 = CoordType.GCJ02;
                                    ** continue;
lbl80:
                                    // 1 sources

                                    v10 = var1_2;
                                    var5_5 = new RoutePlanNodeProtocol.Builder().id((String)var7_7 /* !! */ ).latitude(var11_11).longitude(var9_10).name((String)var5_5).build();
                                    v10.add(new WayPointInfoProtocol(var8_8, "wp", (RoutePlanNodeProtocol)var5_5, var13_12));
                                    break block41;
                                }
                                var8_8 = var5_5;
                            }
                            ++var6_6;
                            var5_5 = var8_8;
                        }
                        if (this.mShareManagerImpl != null) ** GOTO lbl98
                        try {
                            BDLog.d("ShareLocationManager", "parseResponseExtNextWayPointsmShareManagerImpl is empty");
                            return;
lbl98:
                            // 1 sources

                            this.mShareManagerImpl.updateWayPoints((List<WayPointInfoProtocol>)var1_2, var3_4, (String)var5_5);
                        }
lbl107:
                        // 32 sources

                        catch (JSONException var0_1) {
                            var0_1.printStackTrace();
                            BDLog.d("ShareLocationManager", "parseResponseExtNextWayPoints" + var0_1.getMessage());
                        }
                        break block43;
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseResponseExtNextOrigin(JSONObject object) {
        ShareLocationManager shareLocationManager;
        long l5;
        String string2;
        String string3;
        String string4;
        String string5;
        double d6;
        double d7;
        String[] stringArray;
        String string6;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        try {
            if (object.length() == 0) return;
            if (!object.has("ext_next_order_origin")) {
                return;
            }
            jSONObject2 = object.optJSONObject("ext_next_order_origin");
            if (jSONObject2 == null) return;
        }
        catch (Exception exception) {
            BDLog.d(TAG, "parseResponseExtNextOrigin" + exception.getMessage());
            return;
        }
        {
            if (jSONObject2.length() == 0) {
                return;
            }
            jSONObject = jSONObject2;
            string6 = jSONObject.optString("name");
        }
        {
            stringArray = jSONObject.optString("point");
            if (TextUtils.isEmpty((CharSequence)stringArray)) {
                return;
            }
            if ((stringArray = stringArray.split(",")) == null) return;
        }
        {
            if (stringArray.length != 2) {
                return;
            }
            JSONObject jSONObject3 = jSONObject2;
            d7 = Double.valueOf(stringArray[0]);
            d6 = Double.valueOf(stringArray[1]);
            string5 = jSONObject3.optString("poiid");
            string4 = jSONObject3.optString("order_id");
            string3 = jSONObject3.optString("coord_type");
            string2 = jSONObject3.optString("modify_time_ms");
            l5 = 0L;
        }
        {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                l5 = Long.valueOf(string2);
            }
            shareLocationManager = this;
        }
        {
            RoutePlanNodeProtocol routePlanNodeProtocol = new RoutePlanNodeProtocol.Builder().id(string5).latitude(d6).longitude(d7).name(string6).build();
            if (shareLocationManager.mShareManagerImpl == null) {
                BDLog.d(TAG, "parseResponseExtNextOriginmShareManagerImpl is empty");
                return;
            }
            this.mShareManagerImpl.updateOrderStartPosition(string4, routePlanNodeProtocol, l5, string3);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseResponseExtNextDestination(JSONObject object) {
        ShareLocationManager shareLocationManager;
        long l5;
        String string2;
        String string3;
        String string4;
        String string5;
        double d6;
        double d7;
        String[] stringArray;
        String string6;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        try {
            if (object.length() == 0) return;
            if (!object.has("ext_next_order_destinnation")) {
                return;
            }
            jSONObject2 = object.optJSONObject("ext_next_order_destinnation");
            if (jSONObject2 == null) return;
        }
        catch (Exception exception) {
            BDLog.d(TAG, "parseResponseExtNextDestination" + exception.getMessage());
            return;
        }
        {
            if (jSONObject2.length() == 0) {
                return;
            }
            jSONObject = jSONObject2;
            string6 = jSONObject.optString("name");
        }
        {
            stringArray = jSONObject.optString("point");
            if (TextUtils.isEmpty((CharSequence)stringArray)) {
                return;
            }
            if ((stringArray = stringArray.split(",")) == null) return;
        }
        {
            if (stringArray.length != 2) {
                return;
            }
            JSONObject jSONObject3 = jSONObject2;
            d7 = Double.valueOf(stringArray[0]);
            d6 = Double.valueOf(stringArray[1]);
            string5 = jSONObject3.optString("poiid");
            string4 = jSONObject3.optString("order_id");
            string3 = jSONObject3.optString("coord_type");
            string2 = jSONObject3.optString("modify_time_ms");
            l5 = 0L;
        }
        {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                l5 = Long.valueOf(string2);
            }
            shareLocationManager = this;
        }
        {
            RoutePlanNodeProtocol routePlanNodeProtocol = new RoutePlanNodeProtocol.Builder().id(string5).latitude(d6).longitude(d7).name(string6).build();
            if (shareLocationManager.mShareManagerImpl == null) {
                BDLog.d(TAG, "parseResponseExtNextDestinationmShareManagerImpl is empty");
                return;
            }
            this.mShareManagerImpl.updateOrderEndPosition(string4, routePlanNodeProtocol, l5, string3);
        }
    }

    private void parseResponsePassengerPoint(String string2) {
        Object object = ((ShareLocationManager)object4).mParentOrderInfo;
        if (object != null && ((OrderInfoProtocol)object).orderType == 0 && !TextUtils.isEmpty((CharSequence)((OrderInfoProtocol)object).getOrderId())) {
            block10: {
                JSONObject jSONObject;
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return;
                }
                object = jSONObject;
                try {
                    if (new JSONObject(string2).has("data")) break block10;
                    return;
                }
                catch (JSONException jSONException) {
                    BDLog.dforce(TAG, "Parse endPosition info happened exception", jSONException);
                    return;
                }
            }
            string2 = object.optJSONObject("data");
            if (string2 != null && string2.length() != 0 && string2.has("pass_position")) {
                if ((string2 = string2.optJSONObject("pass_position")) != null && string2.length() != 0) {
                    RoutePlanNodeProtocol.Builder builder;
                    String string3 = string2;
                    object = string3.optString("coord_type");
                    Object object2 = string3.optString("point");
                    double d6 = 0.0;
                    double d7 = 0.0;
                    long l5 = 0L;
                    if (!TextUtils.isEmpty((CharSequence)object2) && (object2 = ((String)object2).split("\\|")) != null && ((String[])object2).length >= 2) {
                        l5 = Long.valueOf(object2[0]);
                        if ((object2 = String.valueOf(object2[1]).split(",")) != null && ((String[])object2).length == 2) {
                            Object object3 = object2;
                            d7 = Double.valueOf((String)object3[0]);
                            d6 = Double.valueOf((String)object3[1]);
                        }
                    }
                    boolean bl = string2.optInt("a") == 1;
                    ShareLocationManager shareLocationManager = object4;
                    Object object4 = builder;
                    ((RoutePlanNodeProtocol.Builder)object4)();
                    object4 = builder.latitude(d6).longitude(d7).build();
                    object2 = shareLocationManager.mShareManagerImpl;
                    if (object2 == null) {
                        BDLog.d(TAG, "parseResponsePassengerPointmShareManagerImpl is empty");
                        return;
                    }
                    ((SyncShareImpl)object2).setUserLocation((RoutePlanNodeProtocol)object4, (String)object, l5, bl);
                    return;
                }
                return;
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void parseResponseExtWayPoints(JSONObject var1_2) {
        block43: {
            block36: {
                block37: {
                    block38: {
                        block39: {
                            if (var1_2.length() == 0) break block36;
                            if (!var1_2.has("ext_way_points")) break block36;
                            var1_2 = var1_2.optJSONObject("ext_way_points");
                            if (var1_2 == null) break block37;
                            if (var1_2.length() == 0) break block37;
                            var2_3 = var1_2.optJSONArray("pts");
                            if (var2_3 == null) break block38;
                            if (var2_3.length() == 0) break block38;
                            var1_2 = var1_2.optString("modify_time_ms");
                            var3_4 = 0L;
                            if (TextUtils.isEmpty((CharSequence)var1_2)) break block39;
                            var3_4 = Long.valueOf((String)var1_2);
                        }
                        var1_2 = v0;
                        v0 = new ArrayList<E>();
                        var5_5 = "";
                        var6_6 = 0;
                        while (true) {
                            block41: {
                                block40: {
                                    block42: {
                                        if (var6_6 >= var2_3.length()) break;
                                        var7_7 /* !! */  = var2_3.getJSONObject(var6_6);
                                        if (var7_7 /* !! */  == null) break block40;
                                        if (var7_7 /* !! */ .length() == 0) break block40;
                                        v1 = var7_7 /* !! */ ;
                                        v2 = v1;
                                        var5_5 = v1.optString("pt_type");
                                        var8_8 = v2.optString("order_id");
                                        if (!"way".equals(var5_5)) break block41;
                                        v3 = var7_7 /* !! */ ;
                                        v4 = v3;
                                        var5_5 = v3.optString("name");
                                        var9_9 = v4.optString("point");
                                        if (TextUtils.isEmpty((CharSequence)var9_9)) break block41;
                                        var9_9 = var9_9.split(",");
                                        if (var9_9 == null) break block41;
                                        if (var9_9.length != 2) break block41;
                                        v5 = var7_7 /* !! */ ;
                                        v6 = v5;
                                        v7 = v5;
                                        v8 = var9_9;
                                        var9_10 = Double.valueOf(var9_9[0]);
                                        var11_11 = Double.valueOf(v8[1]);
                                        var7_7 /* !! */  = v6.optString("poiid");
                                        ** try [egrp 25[TRYBLOCK] [25 : 256->259)] { 
lbl68:
                                        // 1 sources

                                        if (!"bd09ll".equals(v7.optString("coord_type"))) break block42;
                                        v9 = CoordType.BD09LL;
lbl73:
                                        // 2 sources

                                        while (true) {
                                            var13_12 = v9;
                                            ** GOTO lbl80
                                            break;
                                        }
                                    }
                                    v9 = CoordType.GCJ02;
                                    ** continue;
lbl80:
                                    // 1 sources

                                    v10 = var1_2;
                                    var5_5 = new RoutePlanNodeProtocol.Builder().id((String)var7_7 /* !! */ ).latitude(var11_11).longitude(var9_10).name((String)var5_5).build();
                                    v10.add(new WayPointInfoProtocol(var8_8, "wp", (RoutePlanNodeProtocol)var5_5, var13_12));
                                    break block41;
                                }
                                var8_8 = var5_5;
                            }
                            ++var6_6;
                            var5_5 = var8_8;
                        }
                        if (this.mShareManagerImpl != null) ** GOTO lbl98
                        try {
                            BDLog.d("ShareLocationManager", "parseResponseExtWayPointsmShareManagerImpl is empty");
                            return;
lbl98:
                            // 1 sources

                            this.mShareManagerImpl.updateWayPoints((List<WayPointInfoProtocol>)var1_2, var3_4, (String)var5_5);
                        }
lbl107:
                        // 32 sources

                        catch (JSONException var0_1) {
                            var0_1.printStackTrace();
                            BDLog.d("ShareLocationManager", "parseResponseExtWayPoints" + var0_1.getMessage());
                        }
                        break block43;
                    }
                    return;
                }
                return;
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseResponseExtOrigin(JSONObject object) {
        ShareLocationManager shareLocationManager;
        long l5;
        String string2;
        String string3;
        String string4;
        String string5;
        double d6;
        double d7;
        String[] stringArray;
        String string6;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        try {
            if (object.length() == 0) return;
            if (!object.has("ext_origin")) {
                return;
            }
            jSONObject2 = object.optJSONObject("ext_origin");
            if (jSONObject2 == null) return;
        }
        catch (Exception exception) {
            BDLog.d(TAG, "parseResponseExtOrigin" + exception.getMessage());
            return;
        }
        {
            if (jSONObject2.length() == 0) {
                return;
            }
            jSONObject = jSONObject2;
            string6 = jSONObject.optString("name");
        }
        {
            stringArray = jSONObject.optString("point");
            if (TextUtils.isEmpty((CharSequence)stringArray)) {
                return;
            }
            if ((stringArray = stringArray.split(",")) == null) return;
        }
        {
            if (stringArray.length != 2) {
                return;
            }
            JSONObject jSONObject3 = jSONObject2;
            d7 = Double.valueOf(stringArray[0]);
            d6 = Double.valueOf(stringArray[1]);
            string5 = jSONObject3.optString("poiid");
            string4 = jSONObject3.optString("order_id");
            string3 = jSONObject3.optString("coord_type");
            string2 = jSONObject3.optString("modify_time_ms");
            l5 = 0L;
        }
        {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                l5 = Long.valueOf(string2);
            }
            shareLocationManager = this;
        }
        {
            RoutePlanNodeProtocol routePlanNodeProtocol = new RoutePlanNodeProtocol.Builder().id(string5).latitude(d6).longitude(d7).name(string6).build();
            if (shareLocationManager.mShareManagerImpl == null) {
                BDLog.d(TAG, "parseResponseExtOriginmShareManagerImpl is empty");
                return;
            }
            this.mShareManagerImpl.updateOrderStartPosition(string4, routePlanNodeProtocol, l5, string3);
        }
    }

    private void parseResponseExtDestination(JSONObject object) {
        if (object.length() != 0 && object.has("ext_destination")) {
            if ((object = object.optJSONObject("ext_destination")) != null && object.length() != 0) {
                JSONObject jSONObject = object;
                String string2 = jSONObject.optString("name");
                String[] stringArray = jSONObject.optString("point");
                if (TextUtils.isEmpty((CharSequence)stringArray)) {
                    return;
                }
                if ((stringArray = stringArray.split(",")) != null && stringArray.length == 2) {
                    JSONObject jSONObject2 = object;
                    double d6 = Double.valueOf(stringArray[0]);
                    double d7 = Double.valueOf(stringArray[1]);
                    object = jSONObject2.optString("poiid");
                    String string3 = jSONObject2.optString("order_id");
                    String string4 = jSONObject2.optString("coord_type");
                    String string5 = jSONObject2.optString("modify_time_ms");
                    long l5 = 0L;
                    if (!TextUtils.isEmpty((CharSequence)string5)) {
                        l5 = Long.valueOf(string5);
                    }
                    ShareLocationManager shareLocationManager = routePlanNodeProtocol;
                    RoutePlanNodeProtocol routePlanNodeProtocol = new RoutePlanNodeProtocol.Builder().id((String)object).latitude(d7).longitude(d6).name(string2).build();
                    object = shareLocationManager.mShareManagerImpl;
                    if (object == null) {
                        BDLog.d(TAG, "parseResponseExtDestinationmShareManagerImpl is empty");
                        return;
                    }
                    ((SyncShareImpl)object).updateOrderEndPosition(string3, routePlanNodeProtocol, l5, string4);
                    return;
                }
                return;
            }
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private synchronized ArrayList<String> getOutOfRangeOrdersFromDataBase(String var1_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 15[TRYBLOCK] [30 : 306->332)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void deleteFromDB(String string2, ArrayList<String> object) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            String[] stringArray = this.mDatabase;
            if (this.mDatabase == null || !stringArray.isOpen()) continue;
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string3;
            this.mDatabase.delete(string2, "orderId = ?", stringArray);
        }
    }

    private void addUserOp(List<? extends OrderInfoProtocol> object, Map<String, String> map) {
        if (object != null && object.size() > 0 && map != null && map.size() > 0) {
            object = object.iterator();
            while (object.hasNext()) {
                OrderInfoProtocol orderInfoProtocol = (OrderInfoProtocol)object.next();
                if (orderInfoProtocol == null) continue;
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    if (entry == null) continue;
                    Map.Entry<String, String> entry2 = entry;
                    entry = entry2.getKey();
                    String string2 = entry2.getValue();
                    Object object2 = this.mShareManagerImpl;
                    if (object2 == null) continue;
                    SyncShareImpl syncShareImpl = object2;
                    object2 = orderInfoProtocol.getOrderId();
                    String string3 = this.mHashCode;
                    syncShareImpl.addUserOP((String)((Object)entry), (String)object2, string2, string3);
                }
            }
            return;
        }
    }

    private void addLocationUpdateResponseLog(int n5) {
        if (n5 != this.mLastUpdateLocationStatus) {
            Object object = this.mShareManagerImpl;
            if (object != null) {
                SyncShareImpl syncShareImpl = object;
                object = String.valueOf(n5);
                String string2 = this.mHashCode;
                syncShareImpl.addUserOP("w.1.7.6", "dl", (String)object, string2);
            }
            ShareLocationManager shareLocationManager = this;
            shareLocationManager.mLastUpdateLocationStatus = n5;
            shareLocationManager.mLastUpdateLocResponseTime = System.currentTimeMillis();
            return;
        }
        if (System.currentTimeMillis() - this.mLastUpdateLocResponseTime >= 60000L) {
            Object object = this.mShareManagerImpl;
            if (object != null) {
                SyncShareImpl syncShareImpl = object;
                String string3 = String.valueOf(n5);
                object = this.mHashCode;
                syncShareImpl.addUserOP("w.1.7.6", "dl", string3, (String)object);
            }
            this.mLastUpdateLocResponseTime = System.currentTimeMillis();
        }
    }

    private synchronized boolean requestUpdateDriverStatus(final String string2, final String string3, final int n5) {
        if (!this.mIsStopSynServer && this.mIsOrderRegisted) {
            if (string3 != null && !string3.isEmpty()) {
                HttpClient.ProtoResultCallBack protoResultCallBack;
                HttpClient.ProtoResultCallBack protoResultCallBack2 = protoResultCallBack;
                protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                    @Override
                    public void onSuccess(String object) {
                        8 v02 = string22;
                        BDLog.d(ShareLocationManager.TAG, "update driver status success");
                        ShareLocationManager.access$3102(v02.ShareLocationManager.this, 0);
                        String[] stringArray = new String[1];
                        object = stringArray;
                        stringArray[0] = string22.string2;
                        v02.ShareLocationManager.this.mDatabase.delete("driverStatus", "orderId = ?", object);
                        if (v02.ShareLocationManager.this.mShareManagerImpl != null) {
                            8 v22 = string22;
                            String string22 = v22.string2;
                            object = String.valueOf(v22.n5);
                            String string32 = v22.ShareLocationManager.this.mHashCode;
                            string22.ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.7", string22, (String)object, string32);
                        }
                    }

                    @Override
                    public void onFailed(HttpClient.HttpStateError object, String string22) {
                        BDLog.e(ShareLocationManager.TAG, "update driver status failed,errCode:" + (Object)object + "result:" + string22);
                        if (HttpClient.HttpStateError.APP_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.APP_SERVER_DISABLED_BY_ADMIN != object && HttpClient.HttpStateError.USER_DELETED_BY_ADMIN != object && HttpClient.HttpStateError.DAY_QUOTA_OVER_LIMIT != object) {
                            if (HttpClient.HttpStateError.NETWORK_ERROR == object) {
                                if (string5.ShareLocationManager.this.mCountUpdateDriverStatusError < 2) {
                                    String string32 = string5;
                                    string32.ShareLocationManager.this.mCountUpdateDriverStatusError++;
                                    String string4 = string5;
                                    object = string4.string2;
                                    string22 = string4.string3;
                                    int n52 = string4.n5;
                                    string32.ShareLocationManager.this.requestUpdateDriverStatus((String)object, string22, n52);
                                } else {
                                    ShareLocationManager.access$3102(string5.ShareLocationManager.this, 0);
                                }
                            } else {
                                ShareLocationManager.access$3102(string5.ShareLocationManager.this, 0);
                            }
                        } else {
                            ShareLocationManager.access$1502(string5.ShareLocationManager.this, true);
                        }
                        if (string5.ShareLocationManager.this.mShareManagerImpl != null) {
                            8 v22 = string5;
                            String string5 = v22.string2;
                            object = String.valueOf(v22.n5);
                            string22 = v22.ShareLocationManager.this.mHashCode;
                            string5.ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.7", string5, (String)object, string22);
                        }
                    }
                };
                this.mBaseRequest.sendRequest(7, "POST", string3, protoResultCallBack2);
                return true;
            }
            return false;
        }
        BDLog.e(TAG, "[requestUpdateDriverStatus]: User is deleted by admin or order register failed");
        return false;
    }

    private void notifyBNListener(HttpClient.HttpStateError httpStateError, String string2, IRequestListenerProtocol iRequestListenerProtocol) {
        if (httpStateError != HttpClient.HttpStateError.NETWORK_ERROR && httpStateError != HttpClient.HttpStateError.INNER_ERROR && httpStateError != HttpClient.HttpStateError.URL_ERROR) {
            iRequestListenerProtocol.onRequestResult(200, "\u8bf7\u6c42\u6210\u529f", string2);
        } else {
            String string3 = httpStateError.getValue() >= 500 ? "\u670d\u52a1\u5f02\u5e38" : (httpStateError.getValue() >= 400 ? "\u8bf7\u6c42\u5f02\u5e38" : (httpStateError.getValue() == -2 ? "\u7f51\u7edc\u5f02\u5e38" : "\u672a\u77e5\u5f02\u5e38"));
            iRequestListenerProtocol.onRequestResult(httpStateError.getValue(), string3, string2);
        }
    }

    private void registerShareLocationHandler(Handler handler) {
        SyncShareImpl syncShareImpl = this.mShareManagerImpl;
        if (syncShareImpl == null) {
            BDLog.e(TAG, "registerShareLocationHandler ShareManagerInterface cannot be empty");
            return;
        }
        int n5 = this.mOrderType;
        if (n5 == 0) {
            syncShareImpl.registerNormalShareLocationHandler(handler);
        } else if (1 == n5) {
            syncShareImpl.registerCarPoolShareLocationHandler(handler);
        }
    }

    private void addOrderToUnRegisterList(final String string2) {
        Runnable runnable;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[addOrderToUnRegisterList]: orderId is empty");
            return;
        }
        Object object = this.mShareLocationHandler;
        if (object == null) {
            BDLog.e(TAG, "[addOrderToUnRegisterList]: mHandler is null");
            return;
        }
        ShareLocationHandler shareLocationHandler = object;
        object = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = ShareLocationManager.this.mUnRegisterOrderSet;
                synchronized (set) {
                    ShareLocationManager.this.mUnRegisterOrderSet.add(string2);
                    return;
                }
            }
        };
        shareLocationHandler.post((Runnable)object);
    }

    private void removeOrderFromUnRegisterList(final String string2) {
        Runnable runnable;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            BDLog.e(TAG, "[addOrderToUnRegisterList]: orderId is empty");
            return;
        }
        Object object = this.mShareLocationHandler;
        if (object == null) {
            BDLog.e(TAG, "[removeOrderFromUnRegisterList]: mHandler is null");
            return;
        }
        ShareLocationHandler shareLocationHandler = object;
        object = runnable;
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = ShareLocationManager.this.mUnRegisterOrderSet;
                synchronized (set) {
                    ShareLocationManager.this.mUnRegisterOrderSet.remove(string2);
                    return;
                }
            }
        };
        shareLocationHandler.post((Runnable)object);
    }

    private boolean isParentOrderInfoEmpty() {
        OrderInfoProtocol orderInfoProtocol;
        block8: {
            block7: {
                if (((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo == null) {
                    OrderInfoProtocol orderInfoProtocol2;
                    orderInfoProtocol = orderInfoProtocol2;
                    orderInfoProtocol2 = new OrderInfoProtocol();
                    ((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo = orderInfoProtocol;
                }
                if (TextUtils.isEmpty((CharSequence)((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo.companyServerId) || TextUtils.isEmpty((CharSequence)((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo.driverId) || TextUtils.isEmpty((CharSequence)((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo.getOrderId())) break block7;
                orderInfoProtocol = ((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo;
                if (orderInfoProtocol.orderState != 0 && !DEFAULT_PARENT_ORDER_ID.equals(orderInfoProtocol.getOrderId())) break block8;
            }
            if ((orderInfoProtocol = ((ShareLocationManager)((Object)orderInfoProtocol3)).loadParentOrderInfo()) == null) {
                return true;
            }
            ((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo = orderInfoProtocol;
        }
        if (!((orderInfoProtocol = ((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo) == null || TextUtils.isEmpty((CharSequence)orderInfoProtocol.companyServerId) || TextUtils.isEmpty((CharSequence)((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo.driverId) || TextUtils.isEmpty((CharSequence)((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo.getOrderId()))) {
            OrderInfoProtocol orderInfoProtocol3 = ((ShareLocationManager)((Object)orderInfoProtocol3)).mParentOrderInfo;
            if (orderInfoProtocol3.orderState != 0 && !DEFAULT_PARENT_ORDER_ID.equals(orderInfoProtocol3.getOrderId())) {
                return false;
            }
        }
        return true;
    }

    private String getParentOrderId() {
        OrderInfoProtocol orderInfoProtocol = this.mParentOrderInfo;
        if (orderInfoProtocol != null && !TextUtils.isEmpty((CharSequence)orderInfoProtocol.getOrderId())) {
            orderInfoProtocol = this.mParentOrderInfo;
            if (orderInfoProtocol.orderType == 0) {
                return MD5Util.getMD5String(orderInfoProtocol.getOrderId(), this.mParentOrderInfo.companyServerId);
            }
            return orderInfoProtocol.getOrderId();
        }
        return "";
    }

    static /* synthetic */ int access$902(ShareLocationManager shareLocationManager, int n5) {
        shareLocationManager.mCountUpdateNetError = n5;
        return n5;
    }

    static /* synthetic */ boolean access$1502(ShareLocationManager shareLocationManager, boolean bl) {
        shareLocationManager.mIsStopSynServer = bl;
        return bl;
    }

    static /* synthetic */ DataStatus access$002(ShareLocationManager shareLocationManager, DataStatus dataStatus) {
        shareLocationManager.mUploadStatus = dataStatus;
        return dataStatus;
    }

    static /* synthetic */ int access$2002(ShareLocationManager shareLocationManager, int n5) {
        shareLocationManager.mCountUpdateRouteInfoError = n5;
        return n5;
    }

    static /* synthetic */ int access$2302(ShareLocationManager shareLocationManager, int n5) {
        shareLocationManager.mCountRegisterNetError = n5;
        return n5;
    }

    static /* synthetic */ int access$2402(ShareLocationManager shareLocationManager, int n5) {
        shareLocationManager.mCountRegisterPartFailed = n5;
        return n5;
    }

    static /* synthetic */ int access$2502(ShareLocationManager shareLocationManager, int n5) {
        shareLocationManager.mCountRegisterServerError = n5;
        return n5;
    }

    static /* synthetic */ int access$3102(ShareLocationManager shareLocationManager, int n5) {
        shareLocationManager.mCountUpdateDriverStatusError = n5;
        return n5;
    }

    static /* synthetic */ int access$3802(ShareLocationManager shareLocationManager, int n5) {
        shareLocationManager.mInterval = n5;
        return n5;
    }

    static /* synthetic */ TimerTask access$3902(ShareLocationManager shareLocationManager, TimerTask timerTask) {
        shareLocationManager.mUpdateInfoTask = timerTask;
        return timerTask;
    }

    static /* synthetic */ boolean access$4102(ShareLocationManager shareLocationManager, boolean bl) {
        shareLocationManager.mFirstInitTimer = bl;
        return bl;
    }

    static /* synthetic */ long access$4302(ShareLocationManager shareLocationManager, long l5) {
        shareLocationManager.mLastLocationChangeTime = l5;
        return l5;
    }

    static /* synthetic */ String access$4602(ShareLocationManager shareLocationManager, String string2) {
        shareLocationManager.mAuthToken = string2;
        return string2;
    }

    public void retryRegisterShareLocationHandler() {
        if (this.mShareLocationHandler == null) {
            ShareLocationHandler shareLocationHandler;
            ShareLocationHandler shareLocationHandler2 = shareLocationHandler;
            shareLocationHandler = new ShareLocationHandler();
            this.mShareLocationHandler = shareLocationHandler2;
        }
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.registerShareLocationHandler(shareLocationManager.mShareLocationHandler);
    }

    public void setLogEnable(boolean bl) {
        BDLog.setLogEnable(bl);
    }

    public synchronized void onFinish(List<? extends OrderInfoProtocol> object) {
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.loadOrderInfo();
        shareLocationManager.loadRouteInfo(shareLocationManager.getParentOrderId());
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                OrderInfoProtocol orderInfoProtocol = (OrderInfoProtocol)object.next();
                if (orderInfoProtocol == null) continue;
                this.updateOrder(orderInfoProtocol);
            }
        }
        ShareLocationManager shareLocationManager2 = this;
        shareLocationManager2.updateLocationInfo(shareLocationManager2.mRouteID);
        shareLocationManager2.updateWayPointInfo();
        shareLocationManager2.removeRouteInfoWithDefaultParentIDFromDB();
        if (shareLocationManager2.isParentOrderInfoEmpty()) {
            return;
        }
        ShareLocationManager shareLocationManager3 = this;
        shareLocationManager3.removeParentOrderRelatedInfoFromDB(shareLocationManager3.getParentOrderId());
    }

    public synchronized void onDestory() {
        ShareLocationManager shareLocationManager = this;
        shareLocationManager.unregisterShareLocationHandler(shareLocationManager.mShareLocationHandler);
        Object object = shareLocationManager.mUpdateInfoTask;
        if (object != null) {
            ((TimerTask)object).cancel();
            this.mUpdateInfoTask = null;
        }
        if ((object = this.mUpdateInfoTimer) != null) {
            ((Timer)object).cancel();
            this.mUpdateInfoTimer = null;
        }
        if ((object = this.mDatabase) != null) {
            if (object.isOpen()) {
                this.mDatabase.close();
            }
            this.mDatabase = null;
        }
        ContextHelper.setContext(null);
    }

    public boolean isHttpsEnable() {
        return HttpClient.isHttpsEnable;
    }

    public void setHttpsEnable(boolean bl) {
        HttpClient.isHttpsEnable = bl;
    }

    public boolean uploadRouteInfo(ShareRouteInfoProtocol object, final IRequestListenerProtocol iRequestListenerProtocol) {
        if (object != null && iRequestListenerProtocol != null) {
            List<? extends OrderInfoProtocol> list = ((ShareRouteInfoProtocol)object).orderInfos;
            if (list != null && list.size() >= 1) {
                HttpClient.ProtoResultCallBack protoResultCallBack;
                HashMap<String, Object> hashMap;
                block10: {
                    HashMap<String, Object> hashMap2;
                    if ((list = list.get(0)) == null) {
                        BDLog.dforce(TAG, "bnOrderInfo is null");
                        return false;
                    }
                    ShareLocationManager shareLocationManager = this;
                    HashMap<String, Object> hashMap3 = hashMap = hashMap2;
                    hashMap();
                    hashMap.put("order_id", MD5Util.getMD5String(((OrderInfoProtocol)((Object)list)).getOrderId(), ((OrderInfoProtocol)((Object)list)).companyServerId));
                    hashMap.put("company", ((OrderInfoProtocol)((Object)list)).companyServerId);
                    hashMap.put("order_attr", ((OrderInfoProtocol)((Object)list)).driverId);
                    hashMap.put("status", ((OrderInfoProtocol)((Object)list)).orderState);
                    hashMap.put("session_id", ((ShareRouteInfoProtocol)object).sessionId);
                    hashMap.put("mrsl", ((ShareRouteInfoProtocol)object).mrsl);
                    hashMap.put("route_id", ((ShareRouteInfoProtocol)object).curRouteMD5);
                    hashMap.put("start_point", ((ShareRouteInfoProtocol)object).startNode);
                    hashMap.put("end_point", ((ShareRouteInfoProtocol)object).endNode);
                    hashMap3.put("preference", ((ShareRouteInfoProtocol)object).preference);
                    hashMap3.put("coord_type", "gcj02");
                    hashMap.put("trip_mode", this.getTripMode());
                    object = "token";
                    try {
                        hashMap2.put((String)object, this.mAuthToken);
                    }
                    catch (Exception exception) {
                        BDLog.dforce(TAG, "uploadRouteInfo exception happened.", exception);
                        return false;
                    }
                    object = shareLocationManager.getRequestData(hashMap2, 0);
                    if (shareLocationManager.mShareManagerImpl == null) break block10;
                    hashMap.put("sign", this.mShareManagerImpl.getSignMD5String((String)object));
                }
                ShareLocationManager shareLocationManager = this;
                BDLog.e("ShareLocationManagerparamSign", (String)object);
                object = shareLocationManager.getRequestData(shareLocationManager.getURLEncodeRequestData(hashMap), 0);
                BDLog.e("ShareLocationManageruploadRoute data = ", (String)object);
                if (((String)object).isEmpty()) {
                    BDLog.dforce(TAG, "uploadRoute data isEmpty");
                    return false;
                }
                list = protoResultCallBack;
                protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                    @Override
                    public void onSuccess(String string2) {
                        iRequestListenerProtocol.onRequestResult(200, "\u8bf7\u6c42\u6210\u529f", string2);
                    }

                    @Override
                    public void onFailed(HttpClient.HttpStateError httpStateError, String string2) {
                        ShareLocationManager.this.notifyBNListener(httpStateError, string2, iRequestListenerProtocol);
                    }
                };
                this.mBaseRequest.sendRequest(5, "POST", (String)object, (HttpClient.ProtoResultCallBack)((Object)list));
                return true;
            }
            BDLog.dforce(TAG, "orderInfos is null");
            return false;
        }
        BDLog.dforce(TAG, "BNShareRouteInfo or listener is null");
        return false;
    }

    public void requestRouteInfo(OrderInfoProtocol object, final IRequestListenerProtocol iRequestListenerProtocol) {
        if (object != null && iRequestListenerProtocol != null) {
            HttpClient.ProtoResultCallBack protoResultCallBack;
            Object object2;
            block8: {
                HashMap<String, Object> hashMap;
                ShareLocationManager shareLocationManager = this;
                object2 = hashMap;
                ((HashMap)object2)();
                object2.put("order_id", MD5Util.getMD5String(((OrderInfoProtocol)object).getOrderId(), ((OrderInfoProtocol)object).companyServerId));
                object2.put("company", ((OrderInfoProtocol)object).companyServerId);
                object2.put("order_attr", ((OrderInfoProtocol)object).driverId);
                object2.put("status", ((OrderInfoProtocol)object).orderState);
                object2.put("trip_mode", this.getTripMode());
                object = "token";
                hashMap.put((String)object, this.mAuthToken);
                object = shareLocationManager.getRequestData(hashMap, 0);
                if (shareLocationManager.mShareManagerImpl == null) break block8;
                object2.put((String)"sign", (Object)this.mShareManagerImpl.getSignMD5String((String)object));
            }
            try {
                BDLog.e("ShareLocationManagerparamSign", (String)object);
            }
            catch (Exception exception) {
                BDLog.dforce(TAG, "requestRouteInfo exception happened.", exception);
            }
            object = this.getRequestData((Map<String, Object>)object2, 0);
            BDLog.e("ShareLocationManagerrequestRoute data = ", (String)object);
            if (TextUtils.isEmpty((CharSequence)object)) {
                BDLog.dforce(TAG, "requestRoute data isEmpty");
                return;
            }
            object2 = protoResultCallBack;
            protoResultCallBack = new HttpClient.ProtoResultCallBack(){

                @Override
                public void onSuccess(String string2) {
                    iRequestListenerProtocol.onRequestResult(200, "\u8bf7\u6c42\u6210\u529f", string2);
                }

                @Override
                public void onFailed(HttpClient.HttpStateError httpStateError, String string2) {
                    ShareLocationManager.this.notifyBNListener(httpStateError, string2, iRequestListenerProtocol);
                }
            };
            this.mBaseRequest.sendRequest(6, "GET", (String)object, (HttpClient.ProtoResultCallBack)object2);
            return;
        }
        BDLog.dforce(TAG, "BNOrderInfo or listener is null");
    }

    public List<ShareETAInfoProtocol> getETAInfos() {
        if (this.mShareManagerImpl == null) {
            BDLog.e(TAG, "getETAInfos ShareManagerInterface cannot be empty");
            return null;
        }
        List<ShareETAInfoProtocol> list = null;
        int n5 = this.mOrderType;
        if (1 == n5) {
            BDLog.e(TAG, "getETAInfos CAR_POOL_ORDER");
            list = this.mShareManagerImpl.getCarPoolETAInfos();
        } else if (n5 == 0) {
            BDLog.e(TAG, "getETAInfos NORMAL_ORDER");
            list = this.mShareManagerImpl.getNormalETAInfos();
        }
        return list;
    }

    public void unregisterShareLocationHandler(Handler handler) {
        SyncShareImpl syncShareImpl = this.mShareManagerImpl;
        if (syncShareImpl == null) {
            BDLog.e(TAG, "unregisterShareLocationHandler ShareManagerInterface cannot be empty");
            return;
        }
        int n5 = this.mOrderType;
        if (n5 == 0) {
            syncShareImpl.unregisterNormalShareLocationHandler(handler);
        } else if (1 == n5) {
            syncShareImpl.unregisterCarPoolShareLocationHandler(handler);
        }
    }

    public String getTripMode() {
        Object object = object.mNavigationType;
        if (object == NavigationType.DRIVER) {
            return "driving";
        }
        if (object == NavigationType.WALK) {
            return "walking";
        }
        return "riding";
    }

    public String whetherToEncodeParameter(String string2, boolean bl) {
        block4: {
            try {
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    return "";
                }
                if (!bl) break block4;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                BDLog.e(TAG, "encode encodeStr failed:" + unsupportedEncodingException.toString());
                return "";
            }
            return URLEncoder.encode(string2, "utf-8");
        }
        return string2;
    }

    public class ShareLocationHandler
    extends Handler {
        private boolean handleRegisterOrder(Message object) {
            if (object != null && (object = object.obj) != null) {
                if ((object = (List)object) == null) {
                    BDLog.e(ShareLocationManager.TAG, "[handleRegisterOrder]: orderInfoList is null");
                    return false;
                }
                return ShareLocationManager.this.registerOrder((List)object);
            }
            BDLog.e(ShareLocationManager.TAG, "[handleRegisterOrder]: msg is null");
            return false;
        }

        private boolean handleUpdateOrder(Message object) {
            if (object != null && (object = ((Message)object).obj) != null) {
                if ((object = (List)object) != null && object.size() > 0) {
                    ShareLocationHandler shareLocationHandler = this;
                    ShareLocationHandler shareLocationHandler2 = this;
                    shareLocationHandler2.updateParentOrderState((OrderInfoProtocol)object.get(0));
                    shareLocationHandler2.ShareLocationManager.this.loadOrderInfo();
                    ShareLocationManager shareLocationManager = shareLocationHandler2.ShareLocationManager.this;
                    shareLocationManager.loadRouteInfo(shareLocationManager.getParentOrderId());
                    shareLocationHandler.handleOrderUpdateImp((List<OrderInfoProtocol>)object);
                    ShareLocationManager shareLocationManager2 = shareLocationHandler.ShareLocationManager.this;
                    shareLocationManager2.updateLocationInfo(shareLocationManager2.mRouteID);
                    shareLocationHandler.ShareLocationManager.this.updateWayPointInfo();
                    return true;
                }
                BDLog.e(ShareLocationManager.TAG, "[handleUpdateOrder]: orderInfos is null");
                return false;
            }
            BDLog.e(ShareLocationManager.TAG, "[handleUpdateOrder]: msg is null");
            return false;
        }

        private void updateParentOrderState(OrderInfoProtocol orderInfoProtocol) {
            if (ShareLocationManager.this.mParentOrderInfo != null && ((ShareLocationManager)ShareLocationManager.this).mParentOrderInfo.orderType == 0 && orderInfoProtocol != null) {
                BDLog.e(ShareLocationManager.TAG, " [updateParentOrderState]: mParentOrderInfo is null");
                if (!(TextUtils.isEmpty((CharSequence)orderInfoProtocol.preOrderId) || TextUtils.isEmpty((CharSequence)ShareLocationManager.this.mParentOrderInfo.getOrderId()) || ShareLocationManager.this.mParentOrderInfo.getOrderId().equals(orderInfoProtocol.getOrderId()))) {
                    return;
                }
                BDLog.e(ShareLocationManager.TAG, " [updateParentOrderState]: orderState is set");
                ((ShareLocationManager)ShareLocationManager.this).mParentOrderInfo.orderState = orderInfoProtocol.orderState;
                ShareLocationManager shareLocationManager = ShareLocationManager.this;
                shareLocationManager.insertParentOrderInfoToDataBase(shareLocationManager.mParentOrderInfo);
            }
        }

        private void handleOrderUpdateImp(List<OrderInfoProtocol> object) {
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (OrderInfoProtocol)object.next();
                if (object2 == null) continue;
                ShareLocationHandler shareLocationHandler = this;
                shareLocationHandler.ShareLocationManager.this.updateOrder((OrderInfoProtocol)object2);
                if (shareLocationHandler.ShareLocationManager.this.mShareManagerImpl == null) continue;
                OrderInfoProtocol orderInfoProtocol = object2;
                object2 = orderInfoProtocol.getOrderId();
                String string2 = orderInfoProtocol.driverId;
                String string3 = ShareLocationManager.this.mHashCode;
                ShareLocationManager.this.mShareManagerImpl.addUserOP("w.1.7.2", (String)object2, string2, string3);
            }
        }

        private boolean handleUpdatePosUploadInterval(Message message) {
            Date date;
            if (message == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleUpdatePosUploadInterval]: msg is null");
                return false;
            }
            int n5 = message.arg1;
            if (n5 <= 0) {
                BDLog.e(ShareLocationManager.TAG, "[handleUpdatePosUploadInterval]: msg.arg1 <= 0");
                return false;
            }
            ShareLocationHandler shareLocationHandler = object;
            ShareLocationManager.access$3802(shareLocationHandler.ShareLocationManager.this, n5);
            shareLocationHandler.ShareLocationManager.this.mUpdateInfoTask.cancel();
            if (shareLocationHandler.ShareLocationManager.this.mIsStopSynServer) {
                object.ShareLocationManager.this.mUpdateInfoTimer.cancel();
                BDLog.d(ShareLocationManager.TAG, "[handleUpdatePosUploadInterval]: cancel mUpdateInfoTimer");
                return false;
            }
            ShareLocationHandler shareLocationHandler2 = object;
            ShareLocationManager.access$3902(shareLocationHandler2.ShareLocationManager.this, new TimerTask(){

                @Override
                public void run() {
                    if (DataStatus.process != ShareLocationManager.this.mUploadStatus) {
                        1 v02 = this;
                        v02.ShareLocationManager.this.loadOrderInfo();
                        v02.ShareLocationManager.this.loadUpdateOrderInfo();
                        ShareLocationManager shareLocationManager = v02.ShareLocationManager.this;
                        shareLocationManager.loadRouteInfo(shareLocationManager.getParentOrderId());
                        ShareLocationManager shareLocationManager2 = v02.ShareLocationManager.this;
                        shareLocationManager2.updateLocationInfo(shareLocationManager2.mRouteID);
                        v02.ShareLocationManager.this.updateWayPointInfo();
                    }
                }
            });
            ShareLocationHandler shareLocationHandler3 = object;
            Object object = date;
            date = new Date();
            long l5 = shareLocationHandler3.ShareLocationManager.this.mInterval * 1000;
            shareLocationHandler2.ShareLocationManager.this.mUpdateInfoTimer.schedule(object.ShareLocationManager.this.mUpdateInfoTask, (Date)object, l5);
            ShareLocationManager.access$4102(shareLocationHandler2.ShareLocationManager.this, true);
            return true;
        }

        private boolean handleLocationChange(Message object) {
            if (object != null && object.obj != null) {
                ShareLocationInfo shareLocationInfo;
                Object object2;
                if (ShareLocationManager.this.mIsStopSynServer) {
                    ShareLocationHandler shareLocationHandler = this;
                    shareLocationHandler.ShareLocationManager.this.mUpdateInfoTask.cancel();
                    shareLocationHandler.ShareLocationManager.this.mUpdateInfoTimer.cancel();
                    return false;
                }
                if (!ShareLocationManager.this.mFirstInitTimer) {
                    Date date;
                    ShareLocationHandler shareLocationHandler = this;
                    object2 = date;
                    date = new Date();
                    long l5 = ShareLocationManager.this.mInterval * 1000;
                    shareLocationHandler.ShareLocationManager.this.mUpdateInfoTimer.schedule(ShareLocationManager.this.mUpdateInfoTask, (Date)object2, l5);
                    ShareLocationManager.access$4102(shareLocationHandler.ShareLocationManager.this, true);
                }
                if (ShareLocationManager.this.isParentOrderInfoEmpty()) {
                    BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: mParentOrderInfo is null");
                    return false;
                }
                object = (ShareLocationInfoProtocol)object.obj;
                if (object == null) {
                    BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: locationInfo is null");
                    return false;
                }
                if (((ShareLocationManager)ShareLocationManager.this).mParentOrderInfo.orderType == 0) {
                    BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: BNOrderInfo.OrderType.NORMAL_ORDER == mParentOrderInfo.orderType");
                    object2 = object.orderInfos;
                    if (object2 != null && object2.size() > 0) {
                        object2 = object.orderInfos.get(0);
                        if (object2 == null) {
                            BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]:orderInfo is null");
                            return false;
                        }
                        if (((OrderInfoProtocol)object2).orderState != ((ShareLocationManager)ShareLocationManager.this).mParentOrderInfo.orderState) {
                            BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]:orderState not match parent order");
                            return false;
                        }
                    } else {
                        BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]:locationInfo.orderInfos is empty");
                        return false;
                    }
                }
                object2 = shareLocationInfo;
                shareLocationInfo = new ShareLocationInfo();
                if (!(Math.abs(object.gpsLatitude) > 90.0 || Math.abs(object.gpsLongitude) > 180.0 || Math.abs(object.postLatitude) > 90.0 || Math.abs(object.postLongitude) > 180.0)) {
                    HashMap<String, Object> hashMap;
                    HashMap<String, Object> hashMap2;
                    ((ShareLocationInfo)object2).setTimestamp(System.currentTimeMillis() / 1000L);
                    ((ShareLocationInfo)object2).setInfo((ShareLocationInfoProtocol)object);
                    ShareLocationManager.this.mCache.addLocationInfoToCache((ShareLocationInfo)object2);
                    object2 = (int)(object.postLongitude * 100000.0) + "," + (int)(object.postLatitude * 100000.0);
                    HashMap<String, Object> hashMap3 = hashMap2;
                    hashMap3();
                    ShareLocationManager.this.generateRunAndRemainInfo(hashMap3);
                    String string2 = "";
                    if (hashMap2.containsKey("remain")) {
                        string2 = (String)hashMap3.get("remain");
                    }
                    hashMap3 = hashMap;
                    new HashMap<String, Object>().put("w.1.7.5", object2);
                    hashMap3.put("w.1.7.3", string2);
                    if (ShareLocationManager.this.mLastLocationChangeTime != 0L) {
                        if (System.currentTimeMillis() - ShareLocationManager.this.mLastLocationChangeTime >= 60000L) {
                            ShareLocationHandler shareLocationHandler = this;
                            ShareLocationManager.access$4302(shareLocationHandler.ShareLocationManager.this, System.currentTimeMillis());
                            shareLocationHandler.ShareLocationManager.this.addUserOp(object.orderInfos, hashMap3);
                        }
                    } else {
                        ShareLocationHandler shareLocationHandler = this;
                        ShareLocationManager.access$4302(shareLocationHandler.ShareLocationManager.this, System.currentTimeMillis());
                        shareLocationHandler.ShareLocationManager.this.addUserOp(object.orderInfos, hashMap3);
                    }
                    return true;
                }
                BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: gps info invalid, gpsLatitude:" + object.gpsLatitude + "gpsLongitude:" + object.gpsLongitude + "postLatitude:" + object.postLatitude + "postLongitude:" + object.postLongitude);
                return false;
            }
            BDLog.e(ShareLocationManager.TAG, "[handleLocationChange]: msg is null");
            return false;
        }

        private boolean handleRougeChanged(Message object) {
            HashMap hashMap;
            if (object == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleRougeChanged]: msg is null");
                return false;
            }
            object = (ShareRouteInfoProtocol)object.obj;
            if (object == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleRougeChanged]: routeInfo is null");
                return false;
            }
            ShareLocationHandler shareLocationHandler = object2;
            shareLocationHandler.ShareLocationManager.this.loadOrderInfo();
            shareLocationHandler.ShareLocationManager.this.updateRoute((ShareRouteInfoProtocol)object);
            shareLocationHandler.ShareLocationManager.this.updateLocationInfo(object.curRouteMD5);
            shareLocationHandler.ShareLocationManager.this.updateWayPointInfo();
            Object object2 = hashMap;
            ((HashMap)object2)();
            hashMap.put("w.1.7.4", object.curRouteMD5);
            shareLocationHandler.ShareLocationManager.this.addUserOp(object.orderInfos, (Map)object2);
            return true;
        }

        private boolean handleTokenChanged(Message object) {
            object = object.obj;
            if (object == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleTokenChanged]: msg is null");
                return false;
            }
            boolean bl = false;
            TokenInfoProtocol tokenInfoProtocol = (TokenInfoProtocol)object;
            if (!TextUtils.isEmpty((CharSequence)tokenInfoProtocol.token)) {
                ShareLocationManager.access$4602(ShareLocationManager.this, tokenInfoProtocol.token);
                BDLog.d(ShareLocationManager.TAG, "orderId:" + tokenInfoProtocol.orderInfo.getOrderId() + "   orderState:" + tokenInfoProtocol.orderInfo.orderState);
                bl = true;
            }
            return bl;
        }

        private boolean handlerWayPointStatusChanged(Message object) {
            object = ((Message)object).obj;
            if (object == null) {
                BDLog.e(ShareLocationManager.TAG, "[handleTokenChanged]: msg is null");
                return false;
            }
            if ((object = (List)object) != null && object.size() > 0) {
                String string2;
                String string3 = "";
                if (!ShareLocationManager.this.isParentOrderInfoEmpty()) {
                    string3 = ShareLocationManager.this.getParentOrderId();
                }
                if (TextUtils.isEmpty((CharSequence)(string2 = ShareLocationManager.this.generateWayPointsOrderSubSeq((List)object, string3, true)))) {
                    BDLog.e(ShareLocationManager.TAG, "generateWayPointsOrderSubSeq empty");
                    return false;
                }
                if (TextUtils.isEmpty((CharSequence)(string2 = ShareLocationManager.this.whetherToEncodeParameter(string2, true)))) {
                    BDLog.e(ShareLocationManager.TAG, "subRowOrdersSeq is empty");
                    return false;
                }
                if (TextUtils.isEmpty((CharSequence)(string3 = ShareLocationManager.this.generatePathPlanWayPointsOrderSubSeq((List)object, string3, true)))) {
                    BDLog.e(ShareLocationManager.TAG, "generateNewWayPointsOrderSubSeq empty");
                    return false;
                }
                string3 = ShareLocationManager.this.whetherToEncodeParameter(string3, true);
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    BDLog.e(ShareLocationManager.TAG, "subNewWayPointOrdersSeq is empty");
                    return false;
                }
                return ShareLocationManager.this.driverOrderChange(string2, string3, object.size());
            }
            BDLog.e(ShareLocationManager.TAG, "[handlerDriverChanged]: wayPointInfos is null");
            return false;
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            int n5 = message.what;
            if (n5 != 1) {
                if (n5 != 2) {
                    if (n5 != 3) {
                        if (n5 != 30) {
                            switch (n5) {
                                default: {
                                    break;
                                }
                                case 12: {
                                    BDLog.d(ShareLocationManager.TAG, "MSG_SL_TOKEN_CHANGED");
                                    this.handleTokenChanged(message);
                                    break;
                                }
                                case 11: {
                                    BDLog.d(ShareLocationManager.TAG, "MSG_SL_ORDER_UPDATE");
                                    this.handleUpdateOrder(message);
                                    break;
                                }
                                case 10: {
                                    BDLog.d(ShareLocationManager.TAG, "MSG_SL_ORDER_REGISTER");
                                    this.handleRegisterOrder(message);
                                    break;
                                }
                            }
                        } else {
                            BDLog.d(ShareLocationManager.TAG, "MSG_SL_DRIVER_CHANGED");
                            this.handlerWayPointStatusChanged(message);
                        }
                    } else {
                        BDLog.d(ShareLocationManager.TAG, "MSG_SL_SET_DRIVER_POSITION_UPLOAD_INTERVAL");
                        this.handleUpdatePosUploadInterval(message);
                    }
                } else {
                    BDLog.d(ShareLocationManager.TAG, "MSG_SL_ROUTE_CHANGED");
                    this.handleRougeChanged(message);
                }
            } else {
                BDLog.d(ShareLocationManager.TAG, "MSG_SL_LOCATION_CHANGED");
                this.handleLocationChange(message);
            }
        }
    }

    private static final class DataStatus
    extends Enum<DataStatus> {
        public static final /* enum */ DataStatus ready;
        public static final /* enum */ DataStatus success;
        public static final /* enum */ DataStatus error;
        public static final /* enum */ DataStatus process;
        private static final /* synthetic */ DataStatus[] $VALUES;

        public static DataStatus[] values() {
            return (DataStatus[])$VALUES.clone();
        }

        public static DataStatus valueOf(String string2) {
            return Enum.valueOf(DataStatus.class, string2);
        }

        static {
            DataStatus dataStatus;
            ready = new DataStatus();
            success = new DataStatus();
            error = new DataStatus();
            DataStatus dataStatus2 = dataStatus;
            process = new DataStatus();
            $VALUES = new DataStatus[]{ready, success, error, dataStatus2};
        }
    }
}

