/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapframework.nirvana.concurrent;

import android.support.annotation.NonNull;
import com.baidu.mapframework.nirvana.ExceptionCallback;
import com.baidu.mapframework.nirvana.NirvanaExecutors;
import com.baidu.mapframework.nirvana.NirvanaFramework;
import com.baidu.mapframework.nirvana.Utils;
import com.baidu.mapframework.nirvana.concurrent.ConcurrentCallable;
import com.baidu.mapframework.nirvana.concurrent.ConcurrentQueueRunner;
import com.baidu.mapframework.nirvana.concurrent.ConcurrentTask;
import com.baidu.mapframework.nirvana.concurrent.QueueToken;
import com.baidu.mapframework.nirvana.concurrent.ScheduleTask;
import com.baidu.mapframework.nirvana.module.Module;
import com.baidu.mapframework.nirvana.monitor.RecordType;
import com.baidu.mapframework.nirvana.schedule.ScheduleConfig;
import com.baidu.mapframework.nirvana.schedule.UITaskType;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConcurrentManager {
    private static final ExecutorService a = NirvanaExecutors.defaultThreadPool();
    private static final ExecutorService b = NirvanaExecutors.newCachedThreadPool("ConcurrentManager.UI.worker");
    private static final ScheduledThreadPoolExecutor c = NirvanaExecutors.newScheduledThreadPool("ConcurrentManager.SCHEDULE.worker", 1);

    public static QueueToken obtainTaskQueue(Module module) {
        return new QueueToken(new ConcurrentQueueRunner(a));
    }

    public static QueueToken obtainSingleTaskQueue(Module module) {
        return new QueueToken(new ConcurrentQueueRunner(NirvanaExecutors.newFixedThreadPool(module.name(), 1)));
    }

    public static void executeTask(@NonNull Module object, @NonNull ConcurrentTask concurrentTask, @NonNull ScheduleConfig scheduleConfig) {
        if (!Utils.executeParamCheck(object, concurrentTask, scheduleConfig)) {
            return;
        }
        ConcurrentTask concurrentTask2 = concurrentTask;
        NirvanaFramework.getMonitor().markSubmit(RecordType.CONCURRENT, concurrentTask, (Module)((Object)object), scheduleConfig);
        object = ConcurrentManager.a(concurrentTask2, concurrentTask2.getExceptionCallback(), scheduleConfig);
        if (concurrentTask2.a() == null) {
            if (ConcurrentManager.a(scheduleConfig)) {
                b.execute((Runnable)object);
            } else {
                a.execute((Runnable)object);
            }
        } else {
            concurrentTask.a().a().a((Runnable)object);
        }
    }

    public static <T> FutureTask submitTask(@NonNull Module object, @NonNull ConcurrentCallable<T> concurrentCallable, @NonNull ScheduleConfig scheduleConfig) {
        FutureTask<T> futureTask;
        if (!Utils.executeParamCheck(object, concurrentCallable, scheduleConfig)) {
            Callable callable;
            object = callable;
            callable = new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return null;
                }
            };
            return new FutureTask(object);
        }
        FutureTask<T> futureTask2 = futureTask;
        futureTask2(concurrentCallable);
        NirvanaFramework.getMonitor().markSubmit(RecordType.CONCURRENT, futureTask2, (Module)((Object)object), scheduleConfig);
        object = ConcurrentManager.a(futureTask, concurrentCallable.getExceptionCallback(), scheduleConfig);
        if (concurrentCallable.a() == null) {
            if (ConcurrentManager.a(scheduleConfig)) {
                b.execute((Runnable)object);
            } else {
                a.execute((Runnable)object);
            }
        } else {
            concurrentCallable.a().a().a((Runnable)object);
        }
        return futureTask2;
    }

    public static void scheduleTask(@NonNull Module module, @NonNull ScheduleTask scheduleTask, @NonNull ScheduleConfig object) {
        if (!Utils.executeParamCheck(module, scheduleTask, object)) {
            return;
        }
        ScheduleTask scheduleTask2 = scheduleTask;
        NirvanaFramework.getMonitor().markSubmit(RecordType.CONCURRENT, scheduleTask, module, (ScheduleConfig)object);
        long l5 = scheduleTask.getDelay();
        object = TimeUnit.MILLISECONDS;
        c.schedule(ConcurrentManager.a(scheduleTask2, scheduleTask2.getExceptionCallback(), object), l5, (TimeUnit)((Object)object));
    }

    private static Runnable a(final @NonNull Runnable runnable, final ExceptionCallback exceptionCallback, final ScheduleConfig scheduleConfig) {
        return new Runnable(){

            @Override
            public void run() {
                block4: {
                    NirvanaFramework.getMonitor().markRunning(runnable);
                    if (!scheduleConfig.isLifecycleActive()) break block4;
                    try {
                        runnable.run();
                    }
                    catch (Exception exception) {
                        ExceptionCallback exceptionCallback2 = exceptionCallback;
                        if (exceptionCallback2 != null) {
                            exceptionCallback2.onException(exception);
                            break block4;
                        }
                        NirvanaFramework.onUncaughtException("ConcurrentManager", exception);
                    }
                }
                NirvanaFramework.getMonitor().markFinish(runnable);
            }
        };
    }

    private static boolean a(ScheduleConfig scheduleConfig) {
        try {
            return scheduleConfig.getType() instanceof UITaskType;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

