/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.adapter.struct;

import androidx.annotation.NonNull;

public class BNLocationData {
    public final double latitude;
    public final double longitude;
    public final float speed;
    public final float direction;
    public final float accuracy;
    public final float bias;
    public final int satellitesNum;
    public final int altitude;
    public long time;
    public int locType;

    private BNLocationData(double d6, double d7, float f6, float f7, float f8, float f9, int n5, int n6, long l5, int n7) {
        this.latitude = d6;
        this.longitude = d7;
        this.speed = f6;
        this.direction = f7;
        this.accuracy = f8;
        this.bias = f9;
        this.satellitesNum = n5;
        this.altitude = n6;
        this.time = l5;
        this.locType = n7;
    }

    @NonNull
    public String toString() {
        return "BNLocationData{latitude=" + this.latitude + ", longitude=" + this.longitude + ", speed=" + this.speed + ", direction=" + this.direction + ", accuracy=" + this.accuracy + ", bias=" + this.bias + ", satellitesNum=" + this.satellitesNum + ", altitude=" + this.altitude + ", time=" + this.time + ", locType=" + this.locType + '}';
    }

    public static class Builder {
        private double latitude;
        private double longitude;
        private float speed;
        private float direction;
        private float accuracy;
        private float bias = -1.0f;
        private int satellitesNum;
        private int altitude;
        private long time;
        private int locType;

        public Builder latitude(double d6) {
            this.latitude = d6;
            return this;
        }

        public Builder longitude(double d6) {
            this.longitude = d6;
            return this;
        }

        public Builder speed(float f6) {
            this.speed = f6;
            return this;
        }

        public Builder direction(float f6) {
            this.direction = f6;
            return this;
        }

        public Builder accuracy(float f6) {
            this.accuracy = f6;
            return this;
        }

        public Builder bias(float f6) {
            this.bias = f6;
            return this;
        }

        public Builder satellitesNum(int n5) {
            this.satellitesNum = n5;
            return this;
        }

        public Builder altitude(int n5) {
            this.altitude = n5;
            return this;
        }

        public Builder time(long l5) {
            this.time = l5;
            return this;
        }

        public Builder locType(int n5) {
            this.locType = n5;
            return this;
        }

        public BNLocationData build() {
            Builder builder = this;
            double d6 = builder.latitude;
            double d7 = builder.longitude;
            float f6 = builder.speed;
            float f7 = builder.direction;
            float f8 = builder.accuracy;
            float f9 = builder.bias;
            int n5 = builder.satellitesNum;
            int n6 = builder.altitude;
            long l5 = builder.time;
            int n7 = builder.locType;
            return new BNLocationData(d6, d7, f6, f7, f8, f9, n5, n6, l5, n7);
        }
    }
}

