/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.comapi.mapcontrol;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import androidx.annotation.Nullable;
import com.baidu.navisdk.comapi.base.a;
import com.baidu.navisdk.comapi.mapcontrol.BNDynamicOverlay;
import com.baidu.navisdk.comapi.mapcontrol.BNMapOperationStatistic;
import com.baidu.navisdk.comapi.mapcontrol.MapParams;
import com.baidu.navisdk.jni.nativeif.JNIGuidanceControl;
import com.baidu.navisdk.ui.util.d;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.ScreenUtil;
import com.baidu.navisdk.util.common.i;
import com.baidu.navisdk.util.common.r;
import com.baidu.navisdk.util.common.v;
import com.baidu.nplatform.comapi.MapItem;
import com.baidu.nplatform.comapi.basestruct.GeoPoint;
import com.baidu.nplatform.comapi.basestruct.b;
import com.baidu.nplatform.comapi.basestruct.c;
import com.baidu.nplatform.comapi.map.l;
import com.baidu.nplatform.comapi.map.m;
import com.baidu.nplatform.comapi.map.p;
import com.baidu.nplatform.comapi.map.w;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BNMapController
extends a {
    private static final String TAG = "BNMapController";
    private static volatile BNMapController me = new BNMapController();
    private static BNDynamicOverlay sDynamicMap;
    private l mMapController;
    private m mSDKMapController;
    private int mLayerMode;
    private final com.baidu.navisdk.util.worker.loop.b mHandler;
    private final BNMapOperationStatistic mapOperation;

    public BNMapController() {
        BNMapController bNMapController = this;
        bNMapController.mHandler = new com.baidu.navisdk.util.worker.loop.b("MC"){

            @Override
            public void onMessage(Message message) {
                switch (message.what) {
                    default: {
                        break;
                    }
                    case 4201: {
                        object.BNMapController.this.notifyObservers(1, 260, message);
                        break;
                    }
                    case 4200: {
                        Object object = message.arg2;
                        object.BNMapController.this.notifyObservers(1, 259, object);
                        break;
                    }
                    case 4196: {
                        object.BNMapController.this.notifyObservers(1, 275, message);
                        break;
                    }
                    case 4097: 
                    case 4611: {
                        object.BNMapController.this.notifyObservers(1, 274, null);
                    }
                }
            }

            @Override
            public void careAbout() {
                1 v02 = this;
                v02.observe(4200);
                v02.observe(4097);
                v02.observe(4196);
                v02.observe(4138);
                v02.observe(4201);
                v02.observe(4611);
            }
        };
        bNMapController.mapOperation = new BNMapOperationStatistic();
        com.baidu.navisdk.vi.b.a(bNMapController.mHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BNMapController getInstance() {
        if (me != null) return me;
        Class<BNMapController> clazz = BNMapController.class;
        synchronized (BNMapController.class) {
            if (me != null) return me;
            me = new BNMapController();
            // ** MonitorExit[var0] (shouldn't be in output)
            return me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void destory() {
        if (me == null) return;
        Class<BNMapController> clazz = BNMapController.class;
        synchronized (BNMapController.class) {
            if (me == null) return;
            me.dispose();
            me = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private void dispose() {
        Object object = this.mMapController;
        if (object != null) {
            ((l)object).I();
            this.mMapController = null;
        }
        if ((object = this.mSDKMapController) != null) {
            ((m)object).c();
            this.mSDKMapController = null;
        }
    }

    private void checkMapSize() {
        if (this.mMapController == null) {
            return;
        }
        int n5 = com.baidu.baidunavis.maplayer.a.h().e();
        int n6 = com.baidu.baidunavis.maplayer.a.h().d();
        if (this.mMapController.u() != n5 || this.mMapController.t() != n6) {
            if (i.t.d()) {
                i.t.e(TAG, "check map size, not match, resize it");
            }
            this.resizeScreen(n5, n6);
        }
    }

    public static BNDynamicOverlay getDynamicOverlay() {
        if (sDynamicMap == null) {
            sDynamicMap = new BNDynamicOverlay();
        }
        return sDynamicMap;
    }

    private static byte[] bitmap2Bytes(Bitmap object) {
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream2();
            object.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream2);
            object = byteArrayOutputStream.toByteArray();
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
            return object;
        }
        return null;
    }

    public void enterNavi() {
        this.setMap2DLook(false);
    }

    public void initMapController(Context object, Bundle object2) {
        if (this.mMapController == null) {
            l l5;
            Bundle bundle;
            Bundle bundle2 = bundle;
            bundle2();
            bundle2.putInt("right", object2.getInt("screen_width"));
            bundle.putInt("bottom", object2.getInt("screen_height"));
            Object object3 = object2 = l5;
            object3((Context)object);
            this.mMapController = object3;
            l5.c(bundle2);
            this.mMapController.a(new NavMapViewListener());
            BNMapController.getDynamicOverlay().setMapController(this.mMapController);
        }
        if (this.mSDKMapController == null) {
            m m5;
            object = m5;
            object();
            this.mSDKMapController = object;
            m5.b();
        }
    }

    public void onMapAnimationFinish() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.z();
        }
    }

    public l getMapController() {
        return this.mMapController;
    }

    public m getSDKMapController() {
        return this.mSDKMapController;
    }

    public void notifyMapObservers(int n5, int n6, Object object) {
        this.notifyObservers(n5, n6, object);
        if (com.baidu.nplatform.comapi.map.gesture.opt.d.l && n6 == 520) {
            this.mapOperation.addMapOP(n5, 521);
        } else {
            this.mapOperation.addMapOP(n5, n6);
        }
    }

    public void setMapStatus(b b6, l.b b7) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setMapStatus -> " + b6.toString());
        }
        if ((this = ((BNMapController)this).mMapController) != null) {
            ((l)this).a(b6, b7);
        }
    }

    public void setMapStatus(b b6, l.b b7, int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.a(b6, b7, n5);
        }
    }

    public void setMapStatus(b b6, l.b b7, int n5, boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.a(b6, b7, n5, bl);
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "\u4fef\u4ef0\u89d2:" + b6.c);
            }
        }
    }

    public b getMapStatus() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.getMapStatus();
        }
        return null;
    }

    public b getMapStatus(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.h(bl);
        }
        return null;
    }

    public boolean SetMinimapWinSize(int n5, int n6) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.a(n5, n6);
        }
        return false;
    }

    public boolean set3DCarToMap(List<Bitmap> list) {
        ArrayList<Bundle> arrayList;
        if (list == null) {
            return false;
        }
        int n5 = list.size();
        int n6 = n5 / 4;
        ArrayList<Bundle> arrayList2 = arrayList;
        arrayList = new ArrayList<Bundle>();
        for (int i5 = 0; i5 < n5; ++i5) {
            Bitmap bitmap = list.get((i5 + n6) % n5);
            int n7 = bitmap.getWidth();
            int n8 = bitmap.getHeight();
            int n9 = bitmap.getByteCount() * 8 / (n7 * n8);
            byte[] byArray = d.a(bitmap);
            Bundle bundle = new Bundle();
            bundle.putInt("imageWidth", n7);
            bundle.putInt("imageHeight", n8);
            bundle.putInt("imageLen", bitmap.getByteCount());
            bundle.putInt("bits", n9);
            bundle.putByteArray("imageBytes", byArray);
            arrayList2.add(bundle);
        }
        return this.mMapController.a((List<Bundle>)arrayList2);
    }

    public boolean setDIYImageToMap(List<Bitmap> list, int[] nArray) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.a(list, nArray);
        }
        return false;
    }

    public void ResetGLHandleWhenCreateOrDestroyContext(boolean bl) {
        if (this.mMapController != null) {
            LogUtil.e("BaiduGLSurfaceView", " BNMapController --> ResetGLHandleWhenCreateOrDestroyContext");
            this.mMapController.d(bl);
        } else {
            LogUtil.e("MinimapTexture", "BNMapController ReleaseMinimap mMapController == null");
        }
    }

    public int glDrawMinimap() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return -1;
        }
        return l5.x();
    }

    public int getZoomLevel() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.v();
        }
        return 18;
    }

    public float getFloatZoomLevel() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.l();
        }
        return 18.0f;
    }

    public void zoomToFullView(Rect rect, boolean bl, int n5, int n6, boolean bl2) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.a(rect, bl, n5, n6, bl2);
        }
    }

    public double getZoomUnitsInMeter() {
        double d6 = 1.0;
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            d6 = l5.w();
        }
        return d6 / ((double)ScreenUtil.getInstance().getDPI() / 310.0);
    }

    @Deprecated
    public void setLevel(float f6) {
        b b6 = this.getMapStatus();
        if (b6 != null) {
            b6.a = f6;
            this.setMapStatus(b6, l.b.f);
        }
    }

    public boolean zoomIn() {
        l l5 = this.mMapController;
        if (l5 != null) {
            com.baidu.navisdk.comapi.statistics.b.f().a(Math.min(l5.v() + 1, 21));
            return this.mMapController.J();
        }
        return false;
    }

    public boolean zoomOut() {
        l l5 = this.mMapController;
        if (l5 != null) {
            com.baidu.navisdk.comapi.statistics.b.f().a(Math.max(l5.v() - 1, 4));
            return this.mMapController.K();
        }
        return false;
    }

    public boolean updateLayer(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.m(n5);
            return true;
        }
        return false;
    }

    public boolean clearLayer(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.a(n5);
            return true;
        }
        return false;
    }

    public void resizeScreen(int n5, int n6) {
        l l5 = this.mMapController;
        if (l5 != null) {
            l5.c(n5, n6);
        }
        this.notifyMapObservers(1, 256, null);
    }

    public int getScreenWidth() {
        BNMapController bNMapController = this;
        bNMapController.checkMapSize();
        int n5 = 0;
        l l5 = bNMapController.mMapController;
        if (l5 != null) {
            n5 = l5.u();
        }
        if (n5 <= 0) {
            if (i.t.d()) {
                i.t.e(TAG, "getScreenWidth,width invalid, will use ScreenUtil instead");
            }
            n5 = ScreenUtil.getInstance().getWidthPixels();
        }
        if (i.t.d()) {
            i.t.e(TAG, "getScreenWidth,width:" + n5);
        }
        return n5;
    }

    public int getScreenHeight() {
        BNMapController bNMapController = this;
        bNMapController.checkMapSize();
        int n5 = 0;
        l l5 = bNMapController.mMapController;
        if (l5 != null) {
            n5 = l5.t();
        }
        if (n5 <= 0) {
            if (i.t.d()) {
                i.t.e(TAG, "getScreenHeight,height invalid, will use ScreenUtil instead");
            }
            n5 = ScreenUtil.getInstance().getHeightPixels();
        }
        if (i.t.d()) {
            i.t.e(TAG, "getScreenHeight,height:" + n5);
        }
        return n5;
    }

    public void onResume() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.B();
        }
    }

    public void onPause() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.A();
        }
    }

    public void showTrafficMap(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.a(bl, true);
        }
    }

    public void showTrafficMap(boolean bl, boolean bl2) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.a(bl, bl2);
        }
    }

    public GeoPoint getGeoPosByScreenPos(int n5, int n6) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.b(n5, n6);
        }
        return null;
    }

    public c getScreenPosByGeoPos(GeoPoint geoPoint) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.a(geoPoint);
        }
        return null;
    }

    public boolean saveScreenToBuffer() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.C();
    }

    public boolean getScreenShot(int n5, int n6, int n7, Bitmap bitmap) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.a(n5, n6, n7, bitmap);
    }

    public int getLayerMode() {
        return this.mLayerMode;
    }

    public void setLayerMode(int n5) {
        l l5 = this.mMapController;
        if (l5 == null) {
            return;
        }
        this.mLayerMode = n5;
        switch (n5) {
            default: {
                break;
            }
            case 12: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, true);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, true);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, true);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 11: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, true);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, true);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 10: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, true);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 9: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, true);
                bNMapController.mMapController.m(8);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.m(35);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, false);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.m(13);
                bNMapController.mMapController.c(16, false);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 8: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.m(8);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.m(35);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, false);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, false);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.c(19, true);
                bNMapController.mMapController.m(19);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 7: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.m(8);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.m(35);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, false);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, true);
                bNMapController.mMapController.m(20);
                break;
            }
            case 6: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, true);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, false);
                bNMapController.mMapController.c(13, true);
                bNMapController.mMapController.m(13);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, true);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 5: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, true);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, false);
                bNMapController.mMapController.c(13, true);
                bNMapController.mMapController.m(13);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, true);
                bNMapController.mMapController.c(17, true);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 4: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, true);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, true);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 3: {
                BNMapController bNMapController = this;
                l5.c(9, true);
                bNMapController.mMapController.m(9);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, true);
                bNMapController.mMapController.m(10);
                bNMapController.mMapController.c(8, true);
                bNMapController.mMapController.c(15, true);
                bNMapController.mMapController.m(8);
                bNMapController.mMapController.c(35, true);
                bNMapController.mMapController.m(35);
                bNMapController.mMapController.c(14, false);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                bNMapController.mMapController.c(24, true);
                bNMapController.mMapController.c(25, true);
                bNMapController.mMapController.c(26, true);
                bNMapController.mMapController.c(27, true);
                break;
            }
            case 2: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, true);
                bNMapController.mMapController.m(3);
                bNMapController.mMapController.c(4, true);
                bNMapController.mMapController.m(4);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(14, true);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 1: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, true);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
                break;
            }
            case 0: {
                BNMapController bNMapController = this;
                l5.c(9, false);
                bNMapController.mMapController.c(3, false);
                bNMapController.mMapController.c(4, false);
                bNMapController.mMapController.c(10, false);
                bNMapController.mMapController.c(8, false);
                bNMapController.mMapController.c(35, false);
                bNMapController.mMapController.c(15, false);
                bNMapController.mMapController.c(14, true);
                bNMapController.mMapController.c(13, false);
                bNMapController.mMapController.c(16, true);
                bNMapController.mMapController.c(11, false);
                bNMapController.mMapController.c(17, false);
                bNMapController.mMapController.m(17);
                bNMapController.mMapController.c(19, false);
                bNMapController.mMapController.c(31, false);
                bNMapController.mMapController.c(32, false);
                bNMapController.mMapController.c(33, false);
                bNMapController.mMapController.c(20, false);
            }
        }
        BNMapController bNMapController = this;
        bNMapController.mMapController.c(27, true);
        bNMapController.mMapController.c(34, true);
    }

    public boolean focusItem(int n5, int n6, boolean bl) {
        boolean bl2 = false;
        l l5 = this.mMapController;
        if (l5 != null) {
            bl2 = l5.b(n5, n6, bl);
        }
        return bl2;
    }

    public boolean setAnimationGlobalSwitch(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.l(bl);
        }
        return false;
    }

    public boolean setNightMode(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.t(bl);
        }
        return false;
    }

    public boolean setSlightScreenStatus(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.k(n5);
        }
        return false;
    }

    public boolean checkRoadConditionSupport(int n5) {
        return true;
    }

    public void enableTouchEventLookover(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.g(bl);
        }
    }

    public boolean showLayer(int n5, boolean bl) {
        if (this.mMapController != null) {
            LogUtil.e("RGUgcRoadModel", "ugcpopup  showLayer  show: " + bl + "   layerType " + n5);
            return this.mMapController.c(n5, bl);
        }
        return false;
    }

    public void showCarResultLayer(boolean bl) {
        if (this.mMapController == null) {
            i.t.a("showCarResultLayer is null");
            return;
        }
        i.t.a("showCarResultLayer " + bl);
        this.mMapController.c(10, bl);
        if (!bl) {
            this.mMapController.a(10);
        }
        BNMapController bNMapController = this;
        bNMapController.mMapController.m(10);
        bNMapController.mMapController.c(8, bl);
        if (!bl) {
            this.mMapController.a(8);
        }
        BNMapController bNMapController2 = this;
        bNMapController2.mMapController.m(8);
        bNMapController2.mMapController.c(27, bl);
        if (!bl) {
            this.mMapController.a(27);
        }
        BNMapController bNMapController3 = this;
        bNMapController3.mMapController.m(27);
        bNMapController3.mMapController.c(35, bl);
        if (!bl) {
            this.mMapController.a(35);
        }
        this.mMapController.m(35);
    }

    public boolean zoomToBound(Bundle bundle) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.h(bundle);
        }
        return false;
    }

    public void injectRenderMsg() {
        Object object = object.mHandler;
        if (object != null) {
            object.sendEmptyMessage(4196);
        }
    }

    public float GetZoomToBound(Bundle bundle, float f6, float f7) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.a(bundle, f6, f7);
        }
        return 0.0f;
    }

    public Rect getShowScreenRect() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return new Rect();
        }
        return l5.p();
    }

    public void updateMapViewByBound(Rect rect, Rect rect2, boolean bl, l.b b6, int n5) {
        this.updateMapViewByBound(rect, rect2, bl, b6, n5, 0);
    }

    public void updateMapViewByBound(Rect rect, Rect rect2, boolean bl, l.b b6, int n5, int n6) {
        this.updateMapViewByBound(rect, rect2, bl, b6, n5, n6, false);
    }

    public void updateMapViewByBound(Rect rect, Rect rect2, boolean bl, l.b b6, int n5, int n6, boolean bl2) {
        float f6;
        float f7;
        Bundle bundle;
        Rect rect3 = rect;
        Bundle bundle2 = bundle;
        Rect rect4 = rect2;
        bundle2();
        long l5 = rect.left;
        bundle2.putLong("left", l5);
        l5 = rect.right;
        bundle2.putLong("right", l5);
        l5 = rect.top;
        bundle2.putLong("top", l5);
        l5 = rect.bottom;
        bundle2.putLong("bottom", l5);
        float f8 = rect4.right - rect2.left;
        float f9 = rect4.top - rect2.bottom;
        float f10 = this.GetZoomToBound(bundle, f8, f9) - 0.35f;
        float f11 = (rect3.right + rect.left) / 2;
        float f12 = (rect3.top + rect.bottom) / 2;
        int n7 = n6;
        n6 = ScreenUtil.getInstance().getWidthPixels();
        int n8 = ScreenUtil.getInstance().getHeightPixels() - n7;
        if (bl) {
            Rect rect5 = rect2;
            float f13 = (rect5.top + rect2.bottom - n8) / 2;
            f7 = (rect5.right + rect2.left - n6) / 2;
            f6 = f13;
        } else {
            Rect rect6 = rect2;
            f6 = (rect6.top + rect2.bottom - n6) / 2;
            f7 = (rect6.right + rect2.left - n8) / 2;
        }
        b b7 = this.getMapStatus();
        if (b7 == null) {
            LogUtil.e(TAG, "updateMapView fail st is null");
            return;
        }
        b b8 = b7;
        b7.j = (long)f6;
        b7.i = (long)f7;
        b7.d = (int)f11;
        b7.e = (int)f12;
        b8.a = f10;
        b8.b = 0.0f;
        b8.c = 0;
        if (i.t.d()) {
            LogUtil.e(TAG, "updateMapView() --> bundle = " + bundle2 + ", width = " + f8 + ", height = " + f9 + ", st = " + b7);
            LogUtil.e(TAG, "updateMapView() --> st._WinRound: left = " + b7.g.a + ", top = " + b7.g.c + ", right = " + b7.g.b + ", bottom = " + b7.g.d);
        }
        BNMapController bNMapController = this;
        int n9 = (int)f7;
        bNMapController.setCarLogoOffsetXY(n9, (int)f6, true);
        bNMapController.setMapStatus(b7, b6, n5, bl2);
    }

    public void zoomToSlightNaviFullView(Bundle bundle, boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.a(bundle, bl);
        }
    }

    public boolean setScreenShotParam(int n5, int n6, int n7, long l5, long l6, int n8) {
        l l7 = ((BNMapController)((Object)l7)).mMapController;
        if (l7 == null) {
            return false;
        }
        return l7.a(n5, n6, n7, l5, l6, n8);
    }

    public boolean getScreenShotImage(Bundle bundle) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.b(bundle);
    }

    public boolean handleDoubleTouch(Object object) {
        if (this.mMapController != null) {
            com.baidu.navisdk.comapi.statistics.b.f().d("ds");
            if (object != null) {
                this.mMapController.b((MotionEvent)object);
            }
            BNMapController.getInstance().notifyMapObservers(2, 513, null);
        }
        return true;
    }

    public boolean handleSingleTouch(Object object) {
        if (this.mMapController != null) {
            com.baidu.navisdk.comapi.statistics.b.f().d("dd");
            if (object != null) {
                this.mMapController.a((MotionEvent)object);
            }
            BNMapController.getInstance().notifyMapObservers(2, 514, object);
        }
        return true;
    }

    public boolean onMapItemClick(String string2, int n5, int n6) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.a(string2, n5, n6);
        }
        return false;
    }

    public void setDynamicEffects(boolean bl) {
        if (this.mMapController == null) {
            i.t.e(TAG, "setDynamicEffects controller = null");
            return;
        }
        if (i.t.d()) {
            i.t.e(TAG, "setDynamicEffects, show = " + bl);
        }
        this.mMapController.n(bl);
    }

    public void notifyOrientation(boolean bl) {
        if (this.mMapController == null) {
            i.t.e(TAG, "notifyOrientation controller = null");
            return;
        }
        if (i.t.d()) {
            i.t.e(TAG, "notifyOrientation, isPortrait = " + bl);
        }
        this.mMapController.a(bl);
    }

    public void setMapShowScreenRect(int n5, int n6, int n7, int n8) {
        block3: {
            if (bNMapController2.mMapController != null) {
                Rect rect;
                BNMapController bNMapController = bNMapController2;
                BNMapController bNMapController2 = rect;
                rect = new Rect(n5, n6, n7, n8);
                try {
                    bNMapController.mMapController.b((Rect)bNMapController2);
                }
                catch (Exception exception) {
                    if (!LogUtil.LOGGABLE) break block3;
                    LogUtil.e(TAG, "setMapShowScreenRect error:" + exception);
                }
            }
        }
    }

    public void setHighLightAvoidTrafficRoute(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.e(2, n5);
        BNMapController.getInstance().updateLayer(10);
        int n6 = JNIGuidanceControl.getInstance().getSelectRouteIdx();
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setHighLightAvoidTrafficRoute routeIdx: " + n5 + ",mainRouteIdx: " + n6);
        }
        String string2 = n5 + "";
        com.baidu.navisdk.util.statistic.userop.b.r().a("3.s.a", n6 + "", string2, "2");
    }

    public void setHighLightRoute(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.e(1, n5);
        BNMapController.getInstance().updateLayer(10);
        int n6 = JNIGuidanceControl.getInstance().getSelectRouteIdx();
        String string2 = n5 + "";
        com.baidu.navisdk.util.statistic.userop.b.r().a("3.s.a", n6 + "", string2, "1");
    }

    public void setHighLightRoute(int n5, int n6) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.e(n5, n6);
    }

    public void recoveryHighLightRoute() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.e(0, 0);
        BNMapController.getInstance().updateLayer(10);
        if (LogUtil.LOGGABLE) {
            int n5 = JNIGuidanceControl.getInstance().getSelectRouteIdx();
            LogUtil.e(TAG, "recoveryHighLightRoute mainRouteIdx:" + n5);
        }
    }

    public boolean setNaviMapMode(int n5) {
        if (this.mMapController != null && com.baidu.navisdk.module.init.a.a()) {
            return this.mMapController.h(n5);
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setNaviMapMode,mMapController is null");
        }
        return false;
    }

    public boolean setPreRoutePlanStatus(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.w(bl);
    }

    public void createMiniMapControl() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.d();
    }

    public void destroyMiniMapControl() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.e();
    }

    public boolean setRedLineRender(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.y(bl);
    }

    public boolean preNextRouteDetail(boolean bl) {
        LogUtil.e(TAG, "preNextRouteDetail: mMapController --> " + ((BNMapController)((Object)l5)).mMapController + ", bPre=" + bl);
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.i(bl);
    }

    public boolean setRouteDetailIndex(int n5) {
        LogUtil.e(TAG, "setRouteDetailIndex: mMapController --> " + ((BNMapController)((Object)l5)).mMapController + ", index=" + n5);
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.i(n5);
    }

    public boolean resetRouteDetailIndex() {
        LogUtil.e(TAG, "resetRouteDetailIndex: mMapController --> " + ((BNMapController)this).mMapController);
        if (i.g.d()) {
            i.g.e(TAG, "resetRouteDetailIndex()");
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return false;
        }
        return ((l)this).j(true);
    }

    public boolean resetRouteDetailIndex(boolean bl) {
        LogUtil.e(TAG, "resetRouteDetailIndex: mMapController --> " + ((BNMapController)((Object)l5)).mMapController + ", bAnimation=" + bl);
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.j(bl);
    }

    public boolean allViewSerialAnimation() {
        LogUtil.e(TAG, "allViewSerialAnimation: mMapController --> " + ((BNMapController)((Object)l5)).mMapController);
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.b();
    }

    public boolean setScreenShow(int n5, int n6, int n7, int n8, int n9, int n10) {
        Bundle bundle;
        LogUtil.e(TAG, "setScreenShow: mMapController --> " + bNMapController2.mMapController);
        if (bNMapController2.mMapController == null) {
            return false;
        }
        BNMapController bNMapController = bNMapController2;
        BNMapController bNMapController2 = bundle;
        new Bundle().putInt("unScreenWidth", n5);
        bNMapController2.putInt("unScreenHeight", n6);
        bNMapController2.putInt("nTopHeight", n7);
        bNMapController2.putInt("nBottomHeight", n8);
        bNMapController2.putInt("nLeftWidth", n9);
        bNMapController2.putInt("nRightWidth", n10);
        return bNMapController.mMapController.g((Bundle)bNMapController2);
    }

    public boolean dynamicWindowInit(int n5, Bundle bundle) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.a(n5, bundle);
    }

    public void dynamicWindowDraw(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.b(n5);
    }

    public void dynamicWindowShutDown(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.c(n5);
    }

    public void awakeDrawWaitEvent() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.c();
    }

    public void dynamicWindowChange(int n5, int n6, int n7) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.b(n5, n6, n7);
    }

    public void setDynamicWindowShowSize(int n5, int n6, int n7, int n8, int n9) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.a(n5, n6, n7, n8, n9);
    }

    public boolean setSimpleModeGuide(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.B(bl);
    }

    public boolean setPreFinishStatus(boolean bl) {
        if (this.mMapController == null) {
            return false;
        }
        LogUtil.e(TAG, "setPreFinishStatus :" + bl);
        return this.mMapController.v(bl);
    }

    public boolean setRouteSearchStatus(boolean bl) {
        if (this.mMapController == null) {
            return false;
        }
        LogUtil.e(TAG, "setRouteSearchStatus(), isHasNearbySearchResult : " + bl);
        return this.mMapController.z(bl);
    }

    public boolean setUIViewBound(ArrayList<Bundle> arrayList) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return false;
        }
        return l5.a(arrayList);
    }

    public boolean setUIViewBound(ArrayList<Bundle> arrayList, int n5) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "setUIViewBound --> dealy = " + n5);
            LogUtil.printList(TAG, "setUIViewBound", "viewArray", arrayList);
            LogUtil.printCallStack();
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return false;
        }
        return ((l)this).a(arrayList, n5);
    }

    public void setMap2DLook(boolean bl) {
        if (this.mMapController == null) {
            LogUtil.e(TAG, "mMapController is null");
            return;
        }
        LogUtil.e(TAG, "setMapFuncInfo:" + bl);
        this.mMapController.b(bl);
    }

    public void setMapPoiScene(boolean bl) {
        if (this.mMapController == null) {
            LogUtil.e(TAG, "mMapController is null");
            return;
        }
        LogUtil.e(TAG, "setMapFuncInfo:" + bl);
        this.mMapController.s(bl);
    }

    public void setCompassVisible(boolean bl) {
        if (this.mMapController == null) {
            LogUtil.e(TAG, "mMapController is null");
            return;
        }
        LogUtil.e(TAG, "setCompassVisible: " + bl);
        this.mMapController.c(bl);
    }

    public boolean setCarLogoVisible(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "setCarLogoVisible,mMapController is null");
            }
            return false;
        }
        return l5.e(bl);
    }

    public void setStrategyVisible(boolean bl) {
        if (this.mMapController == null) {
            LogUtil.e(TAG, "mMapController is null");
            return;
        }
        LogUtil.e(TAG, "SetStrategyVisible: " + bl);
        this.mMapController.f(bl);
    }

    public void setMapFuncInfo(int n5, Bundle bundle) {
        if (this.mMapController == null) {
            LogUtil.e(TAG, "mMapController is null");
            return;
        }
        LogUtil.e(TAG, "setMapFuncInfo --> mapElementType = " + n5 + ", mapElementAttr = " + bundle);
        this.mMapController.b(n5, bundle);
    }

    public void setMapFuncInfoMapClass(int n5, Bundle bundle) {
        if (this.mMapController == null) {
            LogUtil.e(TAG, "setMapFuncInfoMapClass,mMapController is null");
            return;
        }
        LogUtil.e(TAG, "setMapFuncInfoMapClass --> mapClassType = " + n5 + ", bundle = " + bundle);
        this.mMapController.c(n5, bundle);
    }

    public void setMapFuncInfoMapStrategy(int n5, Bundle bundle) {
        if (this.mMapController == null) {
            LogUtil.e(TAG, "setMapFuncInfoMapStrategy,mMapController is null");
            return;
        }
        LogUtil.e(TAG, "setMapFuncInfoMapStrategy --> mapStrategyType = " + n5 + ", bundle = " + bundle);
        this.mMapController.d(n5, bundle);
    }

    public boolean setMapFuncInfoFastRoute(boolean bl, int n5, int n6, int n7) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "setMapFuncInfoMapClass,mMapController is null");
            }
            return false;
        }
        return l5.a(bl, n5, n6, n7);
    }

    public void setMapElementShow(int n5, boolean bl) {
        Bundle bundle;
        if (bNMapController2.mMapController == null) {
            LogUtil.e(TAG, "setMapElementShow mMapController is null");
            return;
        }
        BNMapController bNMapController = bNMapController2;
        BNMapController bNMapController2 = bundle;
        new Bundle().putBoolean("bShow", bl);
        LogUtil.e(TAG, "setMapElementShow --> mapElementType = " + n5 + ", bShow = " + bl);
        bNMapController.setMapFuncInfo(n5, (Bundle)bNMapController2);
    }

    public GeoPoint scrPtToGeoPoint(int n5, int n6) {
        if (this.mMapController == null) {
            LogUtil.e(TAG, "scrPtToGeoPoint mMapController is null");
            return new GeoPoint();
        }
        LogUtil.e(TAG, "scrPtToGeoPoint --> inX = " + n5 + ", inY = " + n6);
        return this.mMapController.d(n5, n6);
    }

    public float getMapLevel() {
        return this.getMapStatus().a;
    }

    public b.a getGeoRound() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return null;
        }
        return l5.getMapStatus().h;
    }

    public void setNaviCarPos() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.F();
    }

    public void updateReservationMap(ArrayList<GeoPoint> bundle, Rect rect, boolean bl) {
        float f6;
        float f7;
        Bundle bundle2;
        LogUtil.e(TAG, "updateReservationMap searchPois size :" + bundle.size());
        int f10 = Integer.MAX_VALUE;
        int f11 = 0;
        int object = Integer.MAX_VALUE;
        int l5 = 0;
        int f62 = bundle.size();
        for (int i5 = 0; i5 < f62; ++i5) {
            GeoPoint geoPoint = (GeoPoint)bundle.get(i5);
            if (geoPoint == null) continue;
            if (f10 > geoPoint.getLongitudeE6()) {
                f10 = geoPoint.getLongitudeE6();
            }
            if (f11 < geoPoint.getLongitudeE6()) {
                f11 = geoPoint.getLongitudeE6();
            }
            if (l5 < geoPoint.getLatitudeE6()) {
                l5 = geoPoint.getLatitudeE6();
            }
            if (object <= geoPoint.getLatitudeE6()) continue;
            object = geoPoint.getLatitudeE6();
        }
        bundle = r.c(f11, object);
        Bundle bundle3 = r.c(f10, l5);
        Bundle bundle4 = bundle;
        int n10 = bundle4.getInt("MCx");
        int f9 = bundle4.getInt("MCy");
        f10 = bundle3.getInt("MCx");
        f11 = bundle3.getInt("MCy");
        Object object2 = bundle2;
        object2();
        long f72 = f10;
        object2.putLong("left", f72);
        f72 = n10;
        object2.putLong("right", f72);
        f72 = f11;
        object2.putLong("top", f72);
        f72 = f9;
        bundle2.putLong("bottom", f72);
        if (!bl) {
            f7 = ScreenUtil.getInstance().getHeightPixels() - rect.left - rect.right;
            f6 = ScreenUtil.getInstance().getWidthPixels() - rect.top - rect.bottom;
        } else {
            f7 = ScreenUtil.getInstance().getWidthPixels() - rect.left - rect.right;
            f6 = ScreenUtil.getInstance().getHeightPixels() - rect.top - rect.bottom;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "updateReservationMap() s.w=" + ScreenUtil.getInstance().getWidthPixels() + ", s.h=" + ScreenUtil.getInstance().getHeightPixels() + ", r.left=" + rect.left + ", r.right=" + rect.right + ", r.top=" + rect.top + ", r.bottom=" + rect.bottom + ", width=" + f7 + ", height=" + f6);
        }
        if (f7 <= 0.0f || f6 <= 0.0f) {
            LogUtil.e(TAG, "updateReservationMap() w or h <= 0");
            f7 = 0.0f;
            f6 = 0.0f;
        }
        Rect rect2 = rect;
        float f8 = this.GetZoomToBound((Bundle)object2, f7, f6) - 0.35f;
        LogUtil.e(TAG, "updateReservationMap() level=" + f8);
        float f12 = (n10 + f10) / 2;
        float f13 = (f11 + f9) / 2;
        float f14 = (rect2.bottom - rect.top) / 2;
        float f122 = (rect2.left - rect.right) / 2;
        object2 = this.getMapStatus();
        if (object2 == null) {
            LogUtil.e(TAG, "updateMapView fail st is null");
            return;
        }
        Object object3 = object2;
        object2.j = (long)f14;
        object2.i = (long)f122;
        object2.d = (int)f12;
        object2.e = (int)f13;
        object3.a = f8;
        object3.b = 1.0f;
        object3.c = 0;
        int n11 = (int)f122;
        this.setCarLogoOffsetXY(n11, (int)f14, false);
        this.setMapStatus((b)object2, l.b.b, -1);
    }

    public boolean setCameraStatus(int n5, boolean bl) {
        if (this.mMapController == null) {
            return false;
        }
        LogUtil.e(TAG, "setCameraStatus --> type =" + n5 + ", isShow =" + bl);
        return this.mMapController.a(n5, bl);
    }

    public boolean getCameraStatus(int n5) {
        if (this.mMapController == null) {
            return false;
        }
        LogUtil.e(TAG, "setCameraStatus --> type =" + n5);
        return this.mMapController.d(n5);
    }

    public void setMapFuncTruckUgcInfo(int[] nArray, boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.b(nArray, bl);
    }

    public void setMapFuncTruckLimitInfo(int[] nArray, boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.a(nArray, bl);
    }

    public void initMiniRenderEngine(int n5, int n6, int n7) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.c(n5, n6, n7);
    }

    public void enterCarPlayMode(long l5) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "enterCarPlayMode --> baseMapAddr = " + l5 + ", mMapController = " + ((BNMapController)this).mMapController);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return;
        }
        ((l)this).b(l5);
    }

    public void exitCarPlayMode() {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "exitCarPlayMode --> mMapController = " + ((BNMapController)this).mMapController);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return;
        }
        ((l)this).f();
    }

    public boolean checkMapViewCameraAvailable(long l5) {
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "checkMapViewCameraAvailable --> baseMapAddr = " + l5 + ", mMapController = " + ((BNMapController)this).mMapController);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return false;
        }
        return ((l)this).a(l5);
    }

    public void setDpiScale(float f6) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return;
        }
        l5.setDpiScale(f6);
    }

    public void setDpiScale(float f6, long l5) {
        l l6 = ((BNMapController)((Object)l6)).mMapController;
        if (l6 == null) {
            return;
        }
        l6.a(f6, l5);
    }

    public float getDpiScale() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return 0.0f;
        }
        return l5.a();
    }

    public float getDpiScale(long l5) {
        l l6 = ((BNMapController)((Object)l6)).mMapController;
        if (l6 == null) {
            return 0.0f;
        }
        return l6.c(l5);
    }

    public boolean setMapFuncInfoPartRouteZoom(boolean bl, int n5, int n6, int n7) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.b(bl, n5, n6, n7);
        }
        return false;
    }

    public boolean setMapForceSwitchStrategy(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.r(bl);
        }
        return false;
    }

    public boolean setQuitMossPartZoom(boolean bl) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            return l5.x(bl);
        }
        return false;
    }

    public boolean setCarImageToMap(Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        int n5 = bitmap2.getWidth();
        int n6 = bitmap2.getHeight();
        int n7 = bitmap2.getByteCount() * 8 / (n5 * n6);
        byte[] byArray = BNMapController.bitmap2Bytes(bitmap2);
        if (byArray != null && n5 > 0 && n6 > 0 && n7 > 0) {
            if (i.r.e()) {
                i.r.g("guide_info", "setCarImageToMap() showCurCarSpeedView()");
            }
            boolean bl = false;
            l l5 = this.mMapController;
            if (l5 != null) {
                bl = l5.a(n5, n6, n7, byArray);
            }
            return bl;
        }
        i.r.a("guide_info", "width=" + n5 + ", height=" + n6 + ", bits=" + n7);
        if (i.r.b()) {
            i.r.b("guide_info", "imageBytes = " + byArray);
        }
        return false;
    }

    public boolean setCarLogoTriangle() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.E();
            return true;
        }
        return false;
    }

    public boolean setCarLogoSpeed() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 != null) {
            l5.D();
            return true;
        }
        return false;
    }

    public boolean set3DCarLogoToMap(String string2, String string3) {
        if (LogUtil.LOGGABLE) {
            i.r.e(TAG, "set3DCarLogoToMap(), filePath = " + string2 + " configFileName = " + string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (!v.c(string2 + string3)) {
                if (LogUtil.LOGGABLE) {
                    i.r.e(TAG, "set3DCarLogoToMap config file not exist");
                }
                return false;
            }
            l l5 = ((BNMapController)((Object)l5)).mMapController;
            boolean bl = l5 != null && l5.a(string2, string3);
            if (LogUtil.LOGGABLE) {
                i.r.e(TAG, "set3DCarLogoToMap result:" + bl);
            }
            return bl;
        }
        return false;
    }

    public boolean setDIYDataToMap(int n5, String string2, String string3) {
        if (LogUtil.LOGGABLE) {
            i.r.e(TAG, "setDIYDataToMap(), filePath = " + string2 + " configFileName = " + string3 + ", type:" + n5);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        if (string3 != null && !v.c(string2 + string3)) {
            if (LogUtil.LOGGABLE) {
                i.r.e(TAG, "setDIYDataToMap config file not exist");
            }
            return false;
        }
        boolean bl = this.mMapController.a(n5, string2, string3);
        if (LogUtil.LOGGABLE) {
            i.r.e(TAG, "setDIYDataToMap result:" + bl);
        }
        return true;
    }

    public void setLabelBreathing(int n5, boolean bl) {
        if (i.c.d()) {
            i.c.e(TAG, "routeId = " + n5 + " isBreathing = " + bl);
        }
        if (n5 < 0) {
            return;
        }
        this.mMapController.b(n5, bl);
    }

    public boolean setHDDataToMap(Bundle bundle) {
        if (i.t.d()) {
            i.t.e(TAG, "setHDDataToMap(): " + bundle);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            if (i.c.c()) {
                i.c.c(TAG, "setHDDataToMap mMapController == null");
            }
            return false;
        }
        return ((l)this).e(bundle);
    }

    public boolean setBarrageInfo(String object, String[] stringArray, String[] stringArray2) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return false;
        }
        if (stringArray != null && stringArray2 != null) {
            Bundle bundle;
            BNMapController bNMapController = bNMapController2;
            BNMapController bNMapController2 = bundle;
            long l5 = JNIGuidanceControl.getInstance().uidCodecDecode((String)object);
            new Bundle().putString("eventId", (String)object);
            bNMapController2.putLong("eventLongId", l5);
            bNMapController2.putStringArray("iconList", stringArray);
            bNMapController2.putStringArray("textList", stringArray2);
            object = bNMapController.mMapController;
            if (object != null) {
                return ((l)object).d((Bundle)bNMapController2);
            }
            return false;
        }
        return false;
    }

    public void setSlightModeZoomToFullView() {
        LogUtil.e(TAG, "setSlightModeZoomToFullView: mMapController --> " + ((BNMapController)this).mMapController);
        if (i.g.d()) {
            i.g.e(TAG, "setSlightModeZoomToFullView()");
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return;
        }
        ((l)this).G();
    }

    public void setEndNodeIconVisible(boolean bl) {
        LogUtil.e(TAG, "setEndNodeIconVisible: mMapController --> " + ((BNMapController)this).mMapController);
        if (i.g.d()) {
            i.g.e(TAG, "setEndNodeIconVisible()");
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return;
        }
        ((l)this).o(bl);
    }

    public void setEndNodeNameVisible(boolean bl) {
        LogUtil.e(TAG, "setEndNodeNameVisible: mMapController --> " + ((BNMapController)this).mMapController);
        if (i.g.d()) {
            i.g.e(TAG, "setEndNodeNameVisible()");
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return;
        }
        ((l)this).p(bl);
    }

    public void setACEParkViewMode(int n5) {
        LogUtil.e(TAG, "setACEParkViewVisible: mMapController --> " + ((BNMapController)this).mMapController + ", viewMode = " + n5);
        if (i.g.d()) {
            i.g.e(TAG, "setACEParkViewMode() --> viewMode = " + n5);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return;
        }
        ((l)this).e(n5);
    }

    public void setRealGraphInfo(long l5, String string2, String string3) {
        if (i.g.d()) {
            i.g.e(TAG, "setRealGraphInfo(), decodeEventId = " + l5 + " imageUrl = " + string2 + " text = " + string3);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            return;
        }
        ((l)this).a(l5, string2, string3);
    }

    public void setOpenOneMapMode(boolean bl) {
        if (this.mMapController == null) {
            i.t.c(TAG, "setOpenOneMapMode --> mBaseMap is null");
            return;
        }
        if (i.t.d()) {
            i.t.e(TAG, "setOpenOneMapMode to " + bl);
        }
        this.mMapController.u(bl);
    }

    public void setShowOneMap(boolean bl) {
        if (this.mMapController == null) {
            i.t.c(TAG, "setShowOneMap --> mBaseMap is null");
            return;
        }
        if (i.t.d()) {
            i.t.e(TAG, "setShowOneMap to " + bl);
        }
        this.mMapController.A(bl);
    }

    public boolean setCarLogoOffset(int n5, int n6, Rect rect) {
        if (i.t.d()) {
            i.t.e(TAG, "setCarLogoOffset: " + n5 + "\uff0c" + n6 + "," + rect);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            i.t.c(TAG, "setCarLogoOffset --> mMapController is null");
            return false;
        }
        float f6 = n5;
        return ((l)this).a(new PointF(f6, (float)n6), rect);
    }

    public boolean setCarLogoOffsetRegion(Rect rect) {
        if (i.t.d()) {
            i.t.e("setCarLogoOffsetRegion\uff1a" + rect);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            i.t.c(TAG, "setCarLogoOffsetRegion --> mMapController is null");
            return false;
        }
        return ((l)this).a(rect);
    }

    @Nullable
    public Rect getCarLogoOffsetRegion() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return null;
        }
        return l5.h();
    }

    public boolean setCarLogoOffsetXY(int n5, int n6, boolean bl) {
        if (i.t.d()) {
            i.t.e(TAG, "setCarLogoOffsetXY: " + n5 + "," + n6 + "," + bl);
        }
        if ((this = ((BNMapController)this).mMapController) == null) {
            i.t.c(TAG, "setCarLogoOffsetXY --> mMapController is null");
            return false;
        }
        return ((l)this).a(n5, n6, bl);
    }

    @Nullable
    public PointF getCarLogoOffsetXY() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            i.t.c(TAG, "getCarLogoOffsetXY --> mMapController is null");
            return null;
        }
        return l5.i();
    }

    public boolean setICarScreenMode(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            i.t.c(TAG, "setICarScreenMode --> mMapController is null");
            return false;
        }
        return l5.f(n5);
    }

    public boolean setTLCruiseMode(int n5) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            i.t.c(TAG, "setICarScreenMode --> mMapController is null");
            return false;
        }
        return l5.l(n5);
    }

    public void getCameraAndLightData(Bundle bundle) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            i.t.c(TAG, "getCameraAndLightData --> mMapController is null");
            return;
        }
        l5.a(bundle);
    }

    public void setPageStateToMap(MapParams.PageState.Scene scene, MapParams.PageState.Distance distance, MapParams.PageState.PageTag pageTag, MapParams.PageState.RouteSubPageTag routeSubPageTag, boolean bl) {
        Bundle bundle;
        if (i.t.d()) {
            i.t.e(TAG, "setPageStateToMap --> scene = " + (Object)((Object)scene) + ", distance = " + (Object)((Object)distance) + ", pageTag = " + (Object)((Object)pageTag) + ", routeSubPageTag = " + (Object)((Object)routeSubPageTag) + ", isNovice = " + bl);
        }
        if (bNMapController2.mMapController == null) {
            i.t.c(TAG, "setPageStateToMap --> mMapController is null");
            return;
        }
        BNMapController bNMapController = bNMapController2;
        BNMapController bNMapController2 = bundle;
        bNMapController2();
        bNMapController2.putInt("scene", scene.type);
        bNMapController2.putInt("distance", distance.type);
        bNMapController2.putInt("page_tag", pageTag.type);
        bundle.putInt("route_sub_page_tag", routeSubPageTag.type);
        bundle.putBoolean("is_novice", bl);
        bNMapController.mMapController.f((Bundle)bNMapController2);
    }

    public float getCruiseDefaultLevel() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return -1.0f;
        }
        return l5.j();
    }

    public float getCruiseDefaultOverLooking() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return -1.0f;
        }
        return l5.k();
    }

    public float getFloatOverLooking() {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            return -1.0f;
        }
        return l5.s();
    }

    public void setMonitorMode(l.d d6) {
        l l5 = ((BNMapController)((Object)l5)).mMapController;
        if (l5 == null) {
            i.t.c(TAG, "setMapIndicatorMonitorMode --> mMapController is null");
            return;
        }
        l5.a(d6);
    }

    public class NavMapViewListener
    implements w {
        private long mLastTime = 0L;

        @Override
        public void onMapAnimationFinish() {
            long l5;
            if (i.t.d()) {
                i.t.e("onMapAnimationFinish");
            }
            if ((l5 = SystemClock.elapsedRealtime()) - this.mLastTime < 100L) {
                return;
            }
            this.mLastTime = l5;
            BNMapController.getInstance().notifyMapObservers(1, 257, null);
            if (BNMapController.this.mMapController != null) {
                BNMapController.this.mMapController.m(10);
            }
        }

        @Override
        public void onMapNetworkingChanged(boolean bl) {
            LogUtil.e("Map", "onMapNetworkingChanged");
            if (bl) {
                BNMapController.getInstance().notifyMapObservers(1, 258, null);
            }
        }

        public void onMapObviousMove() {
            LogUtil.e("Map", "onMapObviousMove");
            BNMapController.getInstance().notifyMapObservers(2, 519, null);
        }

        @Override
        public void onClickedBaseLayer() {
            LogUtil.e("Map", "onClickedBaseLayer");
            BNMapController.getInstance().notifyMapObservers(1, 261, null);
        }

        @Override
        public void onClickedCompassLayer() {
            LogUtil.e("Map", "onClickedCompassLayer");
            BNMapController.getInstance().notifyMapObservers(1, 262, null);
        }

        @Override
        public void onClickedPopupLayer() {
            LogUtil.e("Map", "onClickedPopupLayer");
            BNMapController.getInstance().notifyMapObservers(1, 263, null);
        }

        @Override
        public void onClickedBasePOILayer(MapItem mapItem) {
            LogUtil.e("Map", "onClickedBasePOILayer");
            BNMapController.getInstance().notifyMapObservers(1, 264, mapItem);
        }

        @Override
        public void onClickedFavPoiLayer(MapItem mapItem) {
            LogUtil.e("Map", "onClickedFavPoiLayer");
            BNMapController.getInstance().notifyMapObservers(1, 276, mapItem);
        }

        @Override
        public void onClickedPOIBkgLayer(MapItem mapItem) {
            LogUtil.e("Map", "onClickedPOIBkgLayer");
            BNMapController.getInstance().notifyMapObservers(1, 265, mapItem);
        }

        public void onClickedStreetPopup(String string2) {
        }

        @Override
        public void onClickedBackground(int n5, int n6) {
            BNMapController.getInstance().notifyMapObservers(1, 272, null);
        }

        public void onClickedStreetIndoorPoi(p p5) {
        }

        @Override
        public void onDoubleFingerZoom() {
            LogUtil.e("Map", "onDoubleFingerZoom");
            BNMapController.getInstance().notifyMapObservers(2, 520, null);
        }

        public void onDoubleFingerRotate() {
            BNMapController.getInstance().notifyMapObservers(2, 521, null);
        }

        @Override
        public void onClickedPOILayer(MapItem mapItem) {
            LogUtil.e("Map", "onClickedPOILayer");
            BNMapController.getInstance().notifyMapObservers(1, 277, mapItem);
        }

        @Override
        public void onClickedRouteSpecLayer(MapItem mapItem) {
            BNMapController.getInstance().notifyMapObservers(1, 278, mapItem);
        }

        public void onClickedCustomLayer(MapItem mapItem, int n5, int n6) {
            Bundle bundle;
            NavMapViewListener navMapViewListener = bundle;
            new Bundle().putSerializable("item", (Serializable)mapItem);
            navMapViewListener.putInt("clickedX", n5);
            navMapViewListener.putInt("clickedY", n6);
            BNMapController.getInstance().notifyMapObservers(1, 512, navMapViewListener);
        }

        @Override
        public void onClickedStartLayer(MapItem mapItem, int n5, int n6) {
            Bundle bundle;
            NavMapViewListener navMapViewListener = bundle;
            new Bundle().putSerializable("item", (Serializable)mapItem);
            navMapViewListener.putInt("clickedX", n5);
            navMapViewListener.putInt("clickedY", n6);
            BNMapController.getInstance().notifyMapObservers(1, 516, navMapViewListener);
        }

        @Override
        public void onClickedThroughNodeLayer(MapItem mapItem, int n5, int n6) {
            Bundle bundle;
            NavMapViewListener navMapViewListener = bundle;
            new Bundle().putSerializable("item", (Serializable)mapItem);
            navMapViewListener.putInt("clickedX", n5);
            navMapViewListener.putInt("clickedY", n6);
            BNMapController.getInstance().notifyMapObservers(1, 517, navMapViewListener);
        }

        @Override
        public void onClickedEndLayer(MapItem mapItem, int n5, int n6) {
            Bundle bundle;
            NavMapViewListener navMapViewListener = bundle;
            new Bundle().putSerializable("item", (Serializable)mapItem);
            navMapViewListener.putInt("clickedX", n5);
            navMapViewListener.putInt("clickedY", n6);
            BNMapController.getInstance().notifyMapObservers(1, 513, navMapViewListener);
        }

        @Override
        public void onClickedRoute(MapItem mapItem) {
            BNMapController.getInstance().notifyMapObservers(1, 514, mapItem);
        }

        @Override
        public void onClickedUgcItem(MapItem mapItem) {
            BNMapController.getInstance().notifyMapObservers(1, 515, mapItem);
        }

        @Override
        public void onClickedRouteUgcItem(MapItem mapItem) {
            BNMapController.getInstance().notifyMapObservers(1, 515, mapItem);
        }

        @Override
        public void onClickedRouteAroundElement(MapItem mapItem) {
            BNMapController.getInstance().notifyMapObservers(1, 518, mapItem);
        }

        @Override
        public void onClickedRcPredictionElement(MapItem mapItem) {
            BNMapController.getInstance().notifyMapObservers(1, 520, mapItem);
        }

        @Override
        public void onClickedTrafficLightItem(MapItem mapItem) {
            BNMapController.getInstance().notifyMapObservers(1, 519, mapItem);
        }

        @Override
        public void onClickedCarLogo(MapItem mapItem) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onClickedCarLogo: " + mapItem);
            }
            BNMapController.getInstance().notifyMapObservers(1, 521, mapItem);
        }

        @Override
        public void onClickedRoutePanItem(MapItem mapItem) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onClickedRoutePanItem: " + mapItem);
            }
            BNMapController.getInstance().notifyMapObservers(1, 528, mapItem);
        }

        @Override
        public void onClickDestNodeBubble(MapItem mapItem) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onClickDestNodeBubble: " + mapItem);
            }
            BNMapController.getInstance().notifyMapObservers(1, 529, mapItem);
        }

        @Override
        public void onClickIndoorParkspace(MapItem mapItem) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onClickIndoorParkspace: " + mapItem);
            }
            BNMapController.getInstance().notifyMapObservers(1, 530, mapItem);
        }

        @Override
        public void onClickedMgData(MapItem mapItem) {
            if (LogUtil.LOGGABLE) {
                LogUtil.e(TAG, "onClickedMgData: " + mapItem);
            }
            BNMapController.getInstance().notifyMapObservers(1, 531, mapItem);
            if (sDynamicMap != null) {
                sDynamicMap.onClicked(mapItem);
            }
        }
    }

    public class BNMapConfigParams {
        public static final String KEY_SCREEN_WIDTH = "screen_width";
        public static final String KEY_SCREEN_HEIGHT = "screen_height";
    }
}

