/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.imageloader;

import android.content.Context;
import android.view.View;
import androidx.annotation.Nullable;
import com.baidu.navisdk.imageloader.config.ContextChecker;
import com.baidu.navisdk.imageloader.config.ImageConfig;
import com.baidu.navisdk.imageloader.config.ImagePriority;
import com.baidu.navisdk.imageloader.interfaces.ILoader;
import com.baidu.navisdk.imageloader.transform.BorderRoundTransformation;
import com.baidu.navisdk.imageloader.transform.CropCircleTransformation;
import com.baidu.navisdk.imageloader.transform.CropCircleWithBorderTransformation;
import com.baidu.navisdk.imageloader.transform.RoundedCornersTransformation;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.load.resource.bitmap.BitmapTransitionOptions;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.CenterInside;
import com.bumptech.glide.load.resource.bitmap.FitCenter;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import java.util.ArrayList;

public class GlideLoader
extends ILoader {
    private ImageConfig mImageConfig;

    private Priority getPriority(ImageConfig imageConfig) {
        if (imageConfig.getPriority() == ImagePriority.HIGH) {
            return Priority.HIGH;
        }
        if (imageConfig.getPriority() == ImagePriority.IMMEDIATE) {
            return Priority.IMMEDIATE;
        }
        if (imageConfig.getPriority() == ImagePriority.LOW) {
            return Priority.LOW;
        }
        return Priority.NORMAL;
    }

    private DiskCacheStrategy getDiskCacheStrategy(ImageConfig imageConfig) {
        if (!imageConfig.getDiskCacheStrategy().cacheSource() && !imageConfig.getDiskCacheStrategy().cacheResult()) {
            return DiskCacheStrategy.NONE;
        }
        if (!imageConfig.getDiskCacheStrategy().cacheSource() && imageConfig.getDiskCacheStrategy().cacheResult()) {
            return DiskCacheStrategy.DATA;
        }
        if (imageConfig.getDiskCacheStrategy().cacheSource() && !imageConfig.getDiskCacheStrategy().cacheResult()) {
            return DiskCacheStrategy.RESOURCE;
        }
        return DiskCacheStrategy.AUTOMATIC;
    }

    @Nullable
    private RequestBuilder getRequestBuilder(ImageConfig imageConfig) {
        ImageConfig imageConfig2 = imageConfig;
        GlideLoader glideLoader = Glide.with((Context)imageConfig2.getContext());
        return imageConfig2.isToBytes() ? glideLoader.as(byte[].class).load(imageConfig.getSource()) : (imageConfig.isGif() ? glideLoader.asGif().load(imageConfig.getSource()) : (imageConfig.isAsBitmap() ? glideLoader.asBitmap().load(imageConfig.getSource()) : (imageConfig.asFile() ? glideLoader.asFile().load(imageConfig.getSource()) : glideLoader.load(imageConfig.getSource()))));
    }

    private BitmapTransformation[] getBitmapTransFormations(ImageConfig object) {
        block14: {
            int n5;
            int n6;
            block12: {
                block13: {
                    ArrayList arrayList;
                    ArrayList arrayList2 = arrayList;
                    arrayList = new ArrayList();
                    n6 = ((ImageConfig)object).getScaleMode();
                    if (n6 != 1) {
                        if (n6 != 4) {
                            if (n6 == 5) {
                                FitCenter fitCenter;
                                FitCenter fitCenter2 = fitCenter;
                                fitCenter = new FitCenter();
                                arrayList2.add(fitCenter2);
                            }
                        } else {
                            CenterInside centerInside;
                            CenterInside centerInside2 = centerInside;
                            centerInside = new CenterInside();
                            arrayList2.add(centerInside2);
                        }
                    } else {
                        CenterCrop centerCrop;
                        CenterCrop centerCrop2 = centerCrop;
                        centerCrop = new CenterCrop();
                        arrayList2.add(centerCrop2);
                    }
                    n6 = ((ImageConfig)object).getShapeMode();
                    if (n6 == 1) break block12;
                    if (n6 == 2) break block13;
                    if (n6 == 3) break block12;
                    break block14;
                }
                if (((ImageConfig)object).getBorderWidth() > 0 && ((ImageConfig)object).getBorderColor() != 0) {
                    Object object2 = object;
                    Context context = ((ImageConfig)object2).getContext();
                    int n7 = ((ImageConfig)object2).getBorderWidth();
                    arrayList2.add(new CropCircleWithBorderTransformation(context, n7, ((ImageConfig)object).getContext().getResources().getColor(((ImageConfig)object).getBorderColor())));
                } else {
                    CropCircleTransformation cropCircleTransformation;
                    object = cropCircleTransformation;
                    cropCircleTransformation = new CropCircleTransformation();
                    arrayList2.add(object);
                }
                break block14;
            }
            RoundedCornersTransformation.CornerType cornerType = RoundedCornersTransformation.CornerType.ALL;
            if (n6 == 3) {
                cornerType = RoundedCornersTransformation.CornerType.TOP;
            }
            if (((ImageConfig)object).getBorderWidth() > 0 && ((ImageConfig)object).getBorderColor() != 0) {
                Object object3 = object;
                cornerType = ((ImageConfig)object3).getContext();
                int n8 = ((ImageConfig)object3).getRectRoundRadius();
                n5 = ((ImageConfig)object3).getBorderWidth();
                int n9 = ((ImageConfig)object).getContext().getResources().getColor(((ImageConfig)object).getBorderColor());
                arrayList2.add(new BorderRoundTransformation((Context)cornerType, n8, 0, n5, n9, 725248));
            } else {
                RoundedCornersTransformation roundedCornersTransformation;
                RoundedCornersTransformation roundedCornersTransformation2 = roundedCornersTransformation;
                Object object4 = object;
                object = ((ImageConfig)object4).getContext();
                n5 = ((ImageConfig)object4).getRectRoundRadius();
                int n10 = ((ImageConfig)object4).getBorderWidth();
                roundedCornersTransformation = new RoundedCornersTransformation((Context)object, n5, n10, cornerType);
                arrayList2.add(roundedCornersTransformation2);
            }
        }
        if (!arrayList2.isEmpty()) {
            BitmapTransformation[] bitmapTransformationArray = new BitmapTransformation[arrayList2.size()];
            for (int i5 = 0; i5 < arrayList2.size(); ++i5) {
                bitmapTransformationArray[i5] = (BitmapTransformation)arrayList2.get(i5);
            }
            return bitmapTransformationArray;
        }
        return null;
    }

    @Override
    public void requestData(final ImageConfig imageConfig) {
        RequestOptions requestOptions;
        if (imageConfig == null) {
            return;
        }
        this.mImageConfig = imageConfig;
        RequestBuilder requestBuilder = this.getRequestBuilder(imageConfig);
        if (requestBuilder == null) {
            return;
        }
        RequestOptions requestOptions2 = requestOptions;
        requestOptions = new RequestOptions();
        if (imageConfig.isdontTransform()) {
            requestOptions2.dontTransform();
        } else {
            BitmapTransformation[] bitmapTransformationArray = this.getBitmapTransFormations(imageConfig);
            if (bitmapTransformationArray != null && bitmapTransformationArray.length > 0) {
                requestOptions2.transform((Transformation[])bitmapTransformationArray);
            }
        }
        if (imageConfig.isDontAnimate()) {
            requestOptions2.dontAnimate();
        }
        if (imageConfig.getPlaceHolderDrawable() != null) {
            requestOptions2.placeholder(imageConfig.getPlaceHolderDrawable());
        } else if (imageConfig.getPlaceHolderResId() != 0) {
            requestOptions2.placeholder(imageConfig.getPlaceHolderResId());
        }
        if (imageConfig.getSource() instanceof Integer) {
            requestOptions2.placeholder(((Integer)imageConfig.getSource()).intValue());
        }
        if (imageConfig.getErrorResId() > 0) {
            requestOptions2.error(imageConfig.getErrorResId());
        } else if (imageConfig.getErrorDrawable() != null) {
            requestOptions2.error(imageConfig.getErrorDrawable());
        }
        if (imageConfig.getWidth() > 0 && imageConfig.getHeight() > 0) {
            ImageConfig imageConfig2 = imageConfig;
            int n5 = imageConfig2.getWidth();
            requestOptions2.override(n5, imageConfig2.getHeight());
        } else if (imageConfig.getWidth() == Integer.MIN_VALUE && imageConfig.getHeight() == Integer.MIN_VALUE) {
            requestOptions2.override(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        requestOptions2.skipMemoryCache(imageConfig.isMemoryCache() ^ true);
        requestOptions2.priority(this.getPriority(imageConfig));
        if (imageConfig.getDiskCacheStrategy() == null) {
            requestOptions2.diskCacheStrategy(DiskCacheStrategy.ALL);
        } else {
            requestOptions2.diskCacheStrategy(this.getDiskCacheStrategy(imageConfig));
        }
        requestBuilder.apply((BaseRequestOptions)requestOptions2);
        if (imageConfig.isCrossFade()) {
            if (imageConfig.isAsBitmap()) {
                requestBuilder.transition((TransitionOptions)new BitmapTransitionOptions().crossFade());
            } else {
                requestBuilder.transition((TransitionOptions)new DrawableTransitionOptions().crossFade());
            }
        }
        requestBuilder.listener(new RequestListener(){

            public boolean onLoadFailed(@Nullable GlideException glideException, Object object, Target target, boolean bl) {
                if (imageConfig.getImageLoaderRequestListener() != null) {
                    imageConfig.getImageLoaderRequestListener().onFail((Throwable)glideException, imageConfig.getSource());
                }
                return false;
            }

            public boolean onResourceReady(Object object, Object object2, Target target, DataSource dataSource, boolean bl) {
                if (imageConfig.getImageLoaderRequestListener() != null) {
                    imageConfig.getImageLoaderRequestListener().onSuccess(object, imageConfig.getSource());
                }
                return false;
            }
        });
        if (imageConfig.getTargetView() != null) {
            requestBuilder.into(imageConfig.getTargetView());
        } else if (imageConfig.getImageLoaderCustomTarget() != null) {
            requestBuilder.into((Target)imageConfig.getImageLoaderCustomTarget());
        } else if (imageConfig.getImageLoaderViewTarget() != null) {
            requestBuilder.into((Target)imageConfig.getImageLoaderViewTarget());
        } else if (imageConfig.getImageLoaderBitmapTarget() != null) {
            requestBuilder.into((Target)imageConfig.getImageLoaderBitmapTarget());
        } else if (imageConfig.getImageLoaderDrawableTarget() != null) {
            requestBuilder.into((Target)imageConfig.getImageLoaderDrawableTarget());
        } else if (imageConfig.getImageLoaderGifTarget() != null) {
            requestBuilder.into((Target)imageConfig.getImageLoaderGifTarget());
        } else if (imageConfig.isPreload()) {
            requestBuilder.preload();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object getObject(ImageConfig var1_2) {
        block16: {
            block15: {
                block14: {
                    var2_3 = this.getRequestBuilder(var1_2);
                    if (var2_3 == null) {
                        return null;
                    }
                    v0 = var1_2;
                    this = this.getBitmapTransFormations(var1_2);
                    var3_4 = v1;
                    v1 = new RequestOptions();
                    if (!v0.isdontTransform()) break block14;
                    v2 = var3_4.dontTransform();
lbl13:
                    // 2 sources

                    while (true) {
                        ** GOTO lbl25
                        break;
                    }
                }
                if (this == null) ** GOTO lbl25
                try {
                    if (this.length <= 0) ** GOTO lbl25
                }
                catch (Exception v3) {
                    v3.printStackTrace();
                    return null;
                }
                v2 = var3_4.transform((Transformation[])this);
                ** continue;
lbl25:
                // 3 sources

                if (var1_2.getWidth() <= 0) break block15;
                if (var1_2.getHeight() > 0) break block16;
            }
            if (var1_2.getWidth() != -2147483648) ** GOTO lbl41
            if (var1_2.getHeight() != -2147483648) ** GOTO lbl41
        }
        v4 = var2_3.apply((BaseRequestOptions)var3_4);
        v5 = var1_2;
        v6 = v5;
        var0_1 = v5.getWidth();
        return v4.submit(var0_1, v6.getHeight()).get();
lbl41:
        // 2 sources

        return var2_3.apply((BaseRequestOptions)var3_4).submit().get();
    }

    @Override
    public void pause() {
        ImageConfig imageConfig = this.mImageConfig;
        if (imageConfig != null && ContextChecker.check(imageConfig.getContext())) {
            Glide.with((Context)this.mImageConfig.getContext()).pauseRequestsRecursive();
        }
    }

    @Override
    public void resume() {
        ImageConfig imageConfig = this.mImageConfig;
        if (imageConfig != null && ContextChecker.check(imageConfig.getContext())) {
            Glide.with((Context)this.mImageConfig.getContext()).resumeRequestsRecursive();
        }
    }

    @Override
    public void clearDiskCache() {
        ImageConfig imageConfig = this.mImageConfig;
        if (imageConfig != null && ContextChecker.check(imageConfig.getContext())) {
            Glide.get((Context)this.mImageConfig.getContext()).clearDiskCache();
        }
    }

    @Override
    public void clearMemoryCache() {
        ImageConfig imageConfig = this.mImageConfig;
        if (imageConfig != null && ContextChecker.check(imageConfig.getContext())) {
            Glide.get((Context)this.mImageConfig.getContext()).clearMemory();
        }
    }

    @Override
    public void clearMemoryCache(View view) {
        ImageConfig imageConfig = this.mImageConfig;
        if (imageConfig != null && ContextChecker.check(imageConfig.getContext())) {
            Glide.with((Context)this.mImageConfig.getContext()).clear(view);
        }
    }

    @Override
    public void trimMemory(int n5) {
        ImageConfig imageConfig = this.mImageConfig;
        if (imageConfig != null && ContextChecker.check(imageConfig.getContext())) {
            Glide.with((Context)this.mImageConfig.getContext()).onTrimMemory(n5);
        }
    }

    @Override
    public void onLowMemory() {
        ImageConfig imageConfig = this.mImageConfig;
        if (imageConfig != null && ContextChecker.check(imageConfig.getContext())) {
            Glide.with((Context)this.mImageConfig.getContext()).onLowMemory();
        }
    }
}

