/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.imageloader.config;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.baidu.navisdk.imageloader.ImageLoader;
import com.baidu.navisdk.imageloader.config.ContextChecker;
import com.baidu.navisdk.imageloader.config.ImageDiskCacheStrategy;
import com.baidu.navisdk.imageloader.config.ImagePriority;
import com.baidu.navisdk.imageloader.interfaces.ImageLoaderRequestListener;
import com.baidu.navisdk.imageloader.target.ImageLoaderBitmapTarget;
import com.baidu.navisdk.imageloader.target.ImageLoaderCustomTarget;
import com.baidu.navisdk.imageloader.target.ImageLoaderCustomViewTarget;
import com.baidu.navisdk.imageloader.target.ImageLoaderDrawableTarget;
import com.baidu.navisdk.imageloader.target.ImageLoaderGifTarget;

public class ImageConfig {
    private Context context;
    private Object source;
    private int width;
    private int height;
    private int placeHolderResId;
    private Drawable placeHolderDrawable;
    private int placeHolderScaleType;
    private int scaleMode;
    private int borderWidth;
    private int borderColor;
    private int errorResId;
    private Drawable errorDrawable;
    private int errorScaleType;
    private int shapeMode;
    private int rectRoundRadius;
    private ImagePriority priority;
    private ImageDiskCacheStrategy diskCacheStrategy;
    private boolean isMemoryCache;
    private boolean isPreload;
    private boolean asBitmap;
    private ImageLoaderRequestListener imageLoaderRequestListener;
    private boolean isDontAnimate;
    private boolean isCrossFade;
    private boolean isdontTransform;
    private boolean isToBytes;
    private boolean isGif;
    private boolean isFile;
    private ImageView targetView;
    private ImageLoaderCustomTarget imageLoaderCustomTarget;
    private ImageLoaderCustomViewTarget imageLoaderCustomViewTarget;
    private ImageLoaderBitmapTarget imageLoaderBitmapTarget;
    private ImageLoaderDrawableTarget imageLoaderDrawableTarget;
    private ImageLoaderGifTarget imageLoaderGifTarget;

    private void show() {
        if (ContextChecker.check(this.context)) {
            ImageLoader.getLoader().requestData(this);
        }
    }

    private Object get() {
        if (ContextChecker.check(this.context)) {
            return ImageLoader.getLoader().getObject(this);
        }
        return null;
    }

    public ImageConfig(ConfigBuilder configBuilder) {
        this.context = configBuilder.context;
        this.source = configBuilder.source;
        this.isDontAnimate = configBuilder.isDontAnimate;
        this.isCrossFade = configBuilder.isDontAnimate;
        this.isdontTransform = configBuilder.isdontTransform;
        this.isToBytes = configBuilder.isToBytes;
        this.priority = configBuilder.priority;
        this.isCrossFade = configBuilder.isCrossFade;
        this.isPreload = configBuilder.isPreload;
        this.isMemoryCache = configBuilder.isMemoryCache;
        this.diskCacheStrategy = configBuilder.diskCacheStrategy;
        this.targetView = configBuilder.targetView;
        this.imageLoaderCustomTarget = configBuilder.imageLoaderCustomTarget;
        this.imageLoaderCustomViewTarget = configBuilder.imageLoaderCustomViewTarget;
        this.imageLoaderGifTarget = configBuilder.imageLoaderGifTarget;
        this.imageLoaderDrawableTarget = configBuilder.imageLoaderDrawableTarget;
        this.imageLoaderBitmapTarget = configBuilder.imageLoaderBitmapTarget;
        this.width = configBuilder.width;
        this.height = configBuilder.height;
        this.shapeMode = configBuilder.shapeMode;
        if (this.shapeMode == 1) {
            this.rectRoundRadius = configBuilder.rectRoundRadius;
        }
        this.scaleMode = configBuilder.scaleMode;
        this.placeHolderResId = configBuilder.placeHolderResId;
        this.placeHolderDrawable = configBuilder.placeHolderDrawable;
        this.borderWidth = configBuilder.borderWidth;
        if (this.borderWidth > 0) {
            this.borderColor = configBuilder.borderColor;
        }
        this.asBitmap = configBuilder.asBitmap;
        this.isGif = configBuilder.isGif;
        this.isFile = configBuilder.isFile;
        this.errorResId = configBuilder.errorResId;
        this.errorDrawable = configBuilder.errorDrawable;
        this.errorScaleType = configBuilder.errorScaleType;
        this.placeHolderScaleType = configBuilder.placeHolderScaleType;
        this.imageLoaderRequestListener = configBuilder.imageLoaderRequestListener;
    }

    public Context getContext() {
        return this.context;
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Object getSource() {
        return this.source;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPlaceHolderResId() {
        return this.placeHolderResId;
    }

    public Drawable getPlaceHolderDrawable() {
        return this.placeHolderDrawable;
    }

    public int getRectRoundRadius() {
        return this.rectRoundRadius;
    }

    public void setScaleMode(int n5) {
        this.scaleMode = n5;
    }

    public int getScaleMode() {
        return this.scaleMode;
    }

    public int getShapeMode() {
        return this.shapeMode;
    }

    public ImageView getTargetView() {
        return this.targetView;
    }

    public ImageLoaderCustomTarget getImageLoaderCustomTarget() {
        return this.imageLoaderCustomTarget;
    }

    public ImageLoaderCustomViewTarget getImageLoaderViewTarget() {
        return this.imageLoaderCustomViewTarget;
    }

    public ImageLoaderBitmapTarget getImageLoaderBitmapTarget() {
        return this.imageLoaderBitmapTarget;
    }

    public ImageLoaderDrawableTarget getImageLoaderDrawableTarget() {
        return this.imageLoaderDrawableTarget;
    }

    public ImageLoaderGifTarget getImageLoaderGifTarget() {
        return this.imageLoaderGifTarget;
    }

    public int getWidth() {
        return this.width;
    }

    public int getPlaceHolderScaleType() {
        return this.placeHolderScaleType;
    }

    public int getErrorScaleType() {
        return this.errorScaleType;
    }

    public int getErrorResId() {
        return this.errorResId;
    }

    public boolean isMemoryCache() {
        return this.isMemoryCache;
    }

    public boolean isPreload() {
        return this.isPreload;
    }

    public Drawable getErrorDrawable() {
        return this.errorDrawable;
    }

    public boolean isDontAnimate() {
        return this.isDontAnimate;
    }

    public boolean isdontTransform() {
        return this.isdontTransform;
    }

    public boolean isToBytes() {
        return this.isToBytes;
    }

    public boolean isCrossFade() {
        return this.isCrossFade;
    }

    public void setDontAnimate(boolean bl) {
        this.isDontAnimate = bl;
    }

    public ImageDiskCacheStrategy getDiskCacheStrategy() {
        return this.diskCacheStrategy;
    }

    public void setAsBitmap(boolean bl) {
        this.asBitmap = bl;
    }

    public boolean isAsBitmap() {
        return this.asBitmap;
    }

    public ImageLoaderRequestListener getImageLoaderRequestListener() {
        return this.imageLoaderRequestListener;
    }

    public ImagePriority getPriority() {
        return this.priority;
    }

    public boolean isGif() {
        return this.isGif;
    }

    public boolean asFile() {
        return this.isFile;
    }

    public static class ConfigBuilder {
        private Context context;
        private Object source;
        private boolean isMemoryCache = true;
        private boolean isPreload = false;
        private ImageDiskCacheStrategy diskCacheStrategy;
        private boolean isGif = false;
        private boolean isFile = false;
        private boolean isDontAnimate = false;
        private boolean isCrossFade = false;
        private boolean isdontTransform = false;
        private boolean isToBytes;
        private ImagePriority priority;
        private ImageView targetView;
        private ImageLoaderCustomTarget imageLoaderCustomTarget;
        private ImageLoaderCustomViewTarget imageLoaderCustomViewTarget;
        private ImageLoaderBitmapTarget imageLoaderBitmapTarget;
        private ImageLoaderDrawableTarget imageLoaderDrawableTarget;
        private ImageLoaderGifTarget imageLoaderGifTarget;
        private boolean asBitmap;
        private ImageLoaderRequestListener imageLoaderRequestListener;
        private int width;
        private int height;
        private int placeHolderResId;
        private Drawable placeHolderDrawable;
        private int placeHolderScaleType;
        private int errorScaleType;
        private int errorResId;
        private Drawable errorDrawable;
        private int shapeMode;
        private int rectRoundRadius;
        private int scaleMode = 0;
        private int borderWidth;
        private int borderColor;

        public ConfigBuilder(Context context) {
            this.context = context;
        }

        public ConfigBuilder setImageLoaderRequestListener(ImageLoaderRequestListener imageLoaderRequestListener) {
            this.imageLoaderRequestListener = imageLoaderRequestListener;
            return this;
        }

        public ConfigBuilder setMemoryCache(boolean bl) {
            this.isMemoryCache = bl;
            return this;
        }

        public void preload() {
            this.isPreload = true;
            new ImageConfig(this).show();
        }

        public ConfigBuilder diskCacheStrategy(ImageDiskCacheStrategy imageDiskCacheStrategy) {
            this.diskCacheStrategy = imageDiskCacheStrategy;
            return this;
        }

        public ConfigBuilder load(Object object) {
            this.source = object;
            return this;
        }

        public ConfigBuilder error(int n5) {
            this.errorResId = n5;
            return this;
        }

        public ConfigBuilder error(int n5, int n6) {
            this.errorResId = n5;
            this.errorScaleType = n6;
            return this;
        }

        public ConfigBuilder error(Drawable drawable2) {
            this.errorDrawable = drawable2;
            return this;
        }

        public void into(ImageView imageView) {
            this.targetView = imageView;
            new ImageConfig(this).show();
        }

        public void into(ImageLoaderCustomTarget imageLoaderCustomTarget) {
            this.imageLoaderCustomTarget = imageLoaderCustomTarget;
            new ImageConfig(this).show();
        }

        public void into(ImageLoaderCustomViewTarget imageLoaderCustomViewTarget) {
            this.imageLoaderCustomViewTarget = imageLoaderCustomViewTarget;
            new ImageConfig(this).show();
        }

        public void into(ImageLoaderBitmapTarget imageLoaderBitmapTarget) {
            this.imageLoaderBitmapTarget = imageLoaderBitmapTarget;
            new ImageConfig(this).show();
        }

        public void into(ImageLoaderGifTarget imageLoaderGifTarget) {
            this.imageLoaderGifTarget = imageLoaderGifTarget;
            new ImageConfig(this).show();
        }

        public void into(ImageLoaderDrawableTarget imageLoaderDrawableTarget) {
            this.imageLoaderDrawableTarget = imageLoaderDrawableTarget;
            new ImageConfig(this).show();
        }

        public ConfigBuilder asBitmap() {
            this.asBitmap = true;
            return this;
        }

        public ConfigBuilder asGif() {
            this.isGif = true;
            return this;
        }

        public ConfigBuilder asFile() {
            this.isFile = true;
            return this;
        }

        public ConfigBuilder dontAnimate() {
            this.isDontAnimate = true;
            return this;
        }

        public ConfigBuilder crossFade() {
            this.isCrossFade = true;
            return this;
        }

        public ConfigBuilder dontTransform() {
            this.isdontTransform = true;
            return this;
        }

        public ConfigBuilder priority(ImagePriority imagePriority) {
            this.priority = imagePriority;
            return this;
        }

        public ConfigBuilder widthHeight(int n5, int n6) {
            this.width = n5;
            this.height = n6;
            return this;
        }

        public ConfigBuilder override(int n5, int n6) {
            this.width = n5;
            this.height = n6;
            return this;
        }

        public Object get() {
            return new ImageConfig(this).get();
        }

        public ConfigBuilder placeHolder(int n5) {
            this.placeHolderResId = n5;
            return this;
        }

        public ConfigBuilder placeHolder(Drawable drawable2) {
            this.placeHolderDrawable = drawable2;
            return this;
        }

        public ConfigBuilder placeHolder(int n5, int n6) {
            this.placeHolderResId = n5;
            this.placeHolderScaleType = n6;
            return this;
        }

        public ConfigBuilder asCircle() {
            this.shapeMode = 2;
            return this;
        }

        public ConfigBuilder rectRoundCorner(int n5) {
            this.rectRoundRadius = n5;
            this.shapeMode = 1;
            return this;
        }

        public ConfigBuilder rectRoundCorner(int n5, int n6, int n7, int n8) {
            this.shapeMode = 1;
            return this;
        }

        public ConfigBuilder scale(int n5) {
            this.scaleMode = n5;
            return this;
        }

        public ConfigBuilder centerCrop() {
            this.scaleMode = 1;
            return this;
        }

        public ConfigBuilder fitCenter() {
            this.scaleMode = 5;
            return this;
        }

        public ConfigBuilder centerInside() {
            this.scaleMode = 4;
            return this;
        }

        public ConfigBuilder toBytes() {
            this.isToBytes = true;
            return this;
        }

        public ConfigBuilder border(int n5, int n6) {
            this.borderWidth = n5;
            this.borderColor = n6;
            return this;
        }
    }
}

