/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.imageloader.transform;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import java.security.MessageDigest;

public class BorderRoundTransformation
extends BitmapTransformation {
    private int mRadius;
    private int mMargin;
    private int mBorderWidth;
    private int mBorderColor;
    private int mCornerPos;

    public BorderRoundTransformation(Context context, int n5, int n6, int n7, int n8, int n9) {
        this.mRadius = n5;
        this.mMargin = n6;
        this.mBorderColor = n8;
        this.mBorderWidth = n7;
        this.mCornerPos = n9;
    }

    private void drawRoundRect(Canvas canvas, Paint paint, float f6, float f7, Paint paint2) {
        Path path;
        BorderRoundTransformation borderRoundTransformation = this;
        float f8 = f7;
        int n5 = this.mMargin;
        f7 = f6 - (float)n5;
        float f9 = f8 - (float)n5;
        float f10 = borderRoundTransformation.mBorderWidth / 2;
        Path path2 = path;
        path = new Path();
        float[] fArray = new float[8];
        int n6 = borderRoundTransformation.mCornerPos;
        for (int i5 = 3; i5 >= 0; --i5) {
            int n7 = i5 * 2;
            int n8 = n7 + 1;
            int n9 = n6 & 1;
            float f11 = n9 > 0 ? (float)this.mRadius : 0.0f;
            fArray[n8] = f11;
            float f12 = n9 > 0 ? (float)this.mRadius : 0.0f;
            fArray[n7] = f12;
            n6 >>= 1;
        }
        Path path3 = path2;
        float f13 = f9;
        int n10 = this.mMargin;
        float f14 = (float)n10 + f10;
        float f15 = (float)n10 + f10;
        f9 = f7 - f10;
        f7 = f13 - f10;
        path3.addRoundRect(new RectF(f14, f15, f9, f7), fArray, Path.Direction.CW);
        canvas.drawPath(path3, paint);
        canvas.drawPath(path2, paint2);
    }

    protected Bitmap transform(BitmapPool bitmapPool, Bitmap bitmap, int n5, int n6) {
        Paint paint;
        Paint paint2;
        Canvas canvas;
        Bitmap bitmap2 = bitmap;
        int n7 = bitmap2.getWidth();
        n5 = bitmap2.getHeight();
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        if ((config = bitmapPool.get(n7, n5, config)) == null) {
            config = Bitmap.createBitmap((int)n7, (int)n5, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas2 = canvas;
        canvas = new Canvas((Bitmap)config);
        Paint paint3 = paint2;
        new Paint().setAntiAlias(true);
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        paint3.setShader((Shader)new BitmapShader(bitmap, tileMode, tileMode));
        Bitmap bitmap3 = bitmap = paint;
        bitmap(1);
        bitmap3.setColor(this.mBorderColor);
        bitmap3.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)this.mBorderWidth);
        float f6 = n7;
        float f7 = n5;
        this.drawRoundRect(canvas2, paint3, f6, f7, (Paint)bitmap);
        return config;
    }

    public String getId() {
        return "RoundedTransformation(radius=" + this.mRadius + ", margin=" + this.mMargin + ", mBorderWidth" + this.mBorderWidth + ", mBorderColor" + this.mBorderColor + "mCornerPos" + this.mCornerPos + ")";
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(this.getId().getBytes());
    }
}

