/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.imageloader.transform;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import java.security.MessageDigest;

public class CropCircleWithBorderTransformation
extends BitmapTransformation {
    private static final int VERSION = 1;
    private static final String ID = "CropCircleWithBorderTransformation1";
    private Paint mBorderPaint;
    private float mBorderWidth;
    private int borderColor;

    public CropCircleWithBorderTransformation(Context context, int n5, int n6) {
        CropCircleWithBorderTransformation cropCircleWithBorderTransformation = this;
        cropCircleWithBorderTransformation.mBorderWidth = Resources.getSystem().getDisplayMetrics().density * (float)n5;
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setDither(true);
        cropCircleWithBorderTransformation.mBorderPaint.setAntiAlias(true);
        cropCircleWithBorderTransformation.mBorderPaint.setColor(n6);
        cropCircleWithBorderTransformation.mBorderPaint.setStyle(Paint.Style.STROKE);
        cropCircleWithBorderTransformation.mBorderPaint.setStrokeWidth(this.mBorderWidth);
        this.borderColor = n6;
    }

    private Bitmap circleCrop(BitmapPool bitmapPool, Bitmap bitmap) {
        Paint paint;
        Canvas canvas;
        int n5;
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = bitmap;
        int n6 = n5 = (int)((float)Math.min(bitmap2.getWidth(), bitmap.getHeight()) - this.mBorderWidth / 2.0f);
        bitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)((bitmap2.getWidth() - n5) / 2), (int)((bitmap.getHeight() - n5) / 2), (int)n6, (int)n6);
        int n7 = n5;
        Bitmap bitmap3 = bitmapPool.get(n7, n7, Bitmap.Config.ARGB_8888);
        if (bitmap3 == null) {
            bitmap3 = Bitmap.createBitmap((int)n5, (int)n5, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas2 = canvas;
        canvas2(bitmap3);
        Paint paint2 = paint;
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        new Paint().setShader((Shader)new BitmapShader(bitmap, tileMode, tileMode));
        paint2.setAntiAlias(true);
        float f6 = (float)n5 / 2.0f;
        canvas.drawCircle(f6, f6, f6, paint2);
        paint2 = this.mBorderPaint;
        if (paint2 != null) {
            float f7 = f6;
            canvas2.drawCircle(f7, f6, f7 - this.mBorderWidth / 2.0f, paint2);
        }
        return bitmap3;
    }

    protected Bitmap transform(BitmapPool bitmapPool, Bitmap bitmap, int n5, int n6) {
        return this.circleCrop(bitmapPool, bitmap);
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(ID.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof CropCircleWithBorderTransformation)) return false;
        CropCircleWithBorderTransformation cropCircleWithBorderTransformation = (CropCircleWithBorderTransformation)((Object)object);
        if (cropCircleWithBorderTransformation.mBorderWidth != this.mBorderWidth) return false;
        if (cropCircleWithBorderTransformation.borderColor != this.borderColor) return false;
        return true;
    }

    public int hashCode() {
        return (int)((float)230345622 + this.mBorderWidth * 100.0f + (float)this.borderColor + 10.0f);
    }
}

