/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.imageloader.transform;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import java.security.MessageDigest;

public class RoundedCornersTransformation
extends BitmapTransformation {
    private int mRadius;
    private int mDiameter;
    private int mMargin;
    private CornerType mCornerType;

    public RoundedCornersTransformation(Context context, int n5) {
        this(context, n5, 0);
    }

    public RoundedCornersTransformation(Context context, int n5, int n6) {
        RoundedCornersTransformation roundedCornersTransformation = object;
        Object object = CornerType.ALL;
        roundedCornersTransformation(context, n5, n6, (CornerType)((Object)object));
    }

    public RoundedCornersTransformation(Context context, int n5, int n6, CornerType cornerType) {
        this.mRadius = n5;
        this.mDiameter = n5 * 2;
        this.mMargin = n6;
        this.mCornerType = cornerType;
    }

    private void drawRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        float f8 = f7;
        int n5 = this.mMargin;
        f7 = f6 - (float)n5;
        float f9 = f8 - (float)n5;
        switch (1.$SwitchMap$com$baidu$navisdk$imageloader$transform$RoundedCornersTransformation$CornerType[this.mCornerType.ordinal()]) {
            default: {
                RectF rectF;
                Canvas canvas2 = canvas;
                canvas = rectF;
                int n6 = this.mMargin;
                float f10 = n6;
                rectF = new RectF(f10, (float)n6, f7, f9);
                int n7 = this.mRadius;
                f10 = n7;
                f9 = n7;
                canvas2.drawRoundRect((RectF)canvas, f10, f9, paint);
                break;
            }
            case 14: {
                this.drawDiagonalFromTopRightRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 13: {
                this.drawDiagonalFromTopLeftRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 12: {
                this.drawOtherBottomRightRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 11: {
                this.drawOtherBottomLeftRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 10: {
                this.drawOtherTopRightRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 9: {
                this.drawOtherTopLeftRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 8: {
                this.drawRightRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 7: {
                this.drawLeftRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 6: {
                this.drawBottomRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 5: {
                this.drawTopRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 4: {
                this.drawBottomRightRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 3: {
                this.drawBottomLeftRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 2: {
                this.drawTopRightRoundRect(canvas, paint, f7, f9);
                break;
            }
            case 1: {
                this.drawTopLeftRoundRect(canvas, paint, f7, f9);
            }
        }
    }

    private void drawTopLeftRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        Canvas canvas2 = canvas;
        canvas = rectF;
        int n5 = this.mMargin;
        float f8 = n5;
        float f9 = n5;
        int n6 = this.mDiameter;
        float f10 = n5 + n6;
        float f11 = n5 + n6;
        rectF = new RectF(f8, f9, f10, f11);
        int n7 = this.mRadius;
        float f12 = n7;
        canvas2.drawRoundRect((RectF)canvas, f12, (float)n7, paint);
        int n8 = this.mMargin;
        f12 = n8;
        int n9 = this.mRadius;
        f9 = n8 + n9;
        float f13 = n8 + n9;
        canvas2.drawRect(new RectF(f12, f9, f13, f7), paint);
        int n10 = this.mMargin;
        float f14 = n10 + this.mRadius;
        canvas2.drawRect(new RectF(f14, (float)n10, f6, f7), paint);
    }

    private void drawTopRightRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        Canvas canvas2 = canvas;
        canvas = rectF;
        int n5 = this.mDiameter;
        float f8 = f6 - (float)n5;
        int n6 = this.mMargin;
        float f9 = f8;
        float f10 = n6;
        f8 = n6 + n5;
        rectF = new RectF(f9, f10, f6, f8);
        int n7 = this.mRadius;
        float f11 = n7;
        canvas2.drawRoundRect((RectF)canvas, f11, (float)n7, paint);
        RoundedCornersTransformation roundedCornersTransformation = this;
        int n8 = roundedCornersTransformation.mMargin;
        f11 = n8;
        f10 = n8;
        f8 = f6 - (float)roundedCornersTransformation.mRadius;
        canvas2.drawRect(new RectF(f11, f10, f8, f7), paint);
        int n9 = this.mRadius;
        canvas2.drawRect(new RectF(f6 - (float)n9, (float)(this.mMargin + n9), f6, f7), paint);
    }

    private void drawBottomLeftRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        Canvas canvas2 = canvas;
        canvas = rectF;
        int n5 = this.mMargin;
        float f8 = n5;
        int n6 = this.mDiameter;
        float f9 = f7 - (float)n6;
        float f10 = n5 + n6;
        rectF = new RectF(f8, f9, f10, f7);
        int n7 = this.mRadius;
        float f11 = n7;
        canvas2.drawRoundRect((RectF)canvas, f11, (float)n7, paint);
        RoundedCornersTransformation roundedCornersTransformation = this;
        int n8 = roundedCornersTransformation.mMargin;
        f11 = n8;
        f8 = n8;
        f10 = n8 + this.mDiameter;
        f9 = f7 - (float)roundedCornersTransformation.mRadius;
        canvas2.drawRect(new RectF(f11, f8, f10, f9), paint);
        int n9 = this.mMargin;
        float f12 = n9 + this.mRadius;
        canvas2.drawRect(new RectF(f12, (float)n9, f6, f7), paint);
    }

    private void drawBottomRightRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        Canvas canvas2 = canvas;
        canvas = rectF;
        int n5 = this.mDiameter;
        float f8 = f6 - (float)n5;
        rectF = new RectF(f8, f7 - (float)n5, f6, f7);
        int n6 = this.mRadius;
        float f9 = n6;
        canvas2.drawRoundRect((RectF)canvas, f9, (float)n6, paint);
        RoundedCornersTransformation roundedCornersTransformation = this;
        int n7 = roundedCornersTransformation.mMargin;
        f9 = n7;
        float f10 = n7;
        f8 = f6 - (float)roundedCornersTransformation.mRadius;
        canvas2.drawRect(new RectF(f9, f10, f8, f7), paint);
        float f11 = f7;
        int n8 = this.mRadius;
        f7 = f6 - (float)n8;
        float f12 = this.mMargin;
        float f13 = f11 - (float)n8;
        canvas2.drawRect(new RectF(f7, f12, f6, f13), paint);
    }

    private void drawTopRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        Canvas canvas2 = canvas;
        canvas = rectF;
        int n5 = this.mMargin;
        float f8 = n5;
        float f9 = n5;
        float f10 = n5 + this.mDiameter;
        rectF = new RectF(f8, f9, f6, f10);
        int n6 = this.mRadius;
        float f11 = n6;
        canvas2.drawRoundRect((RectF)canvas, f11, (float)n6, paint);
        int n7 = this.mMargin;
        float f12 = n7;
        canvas2.drawRect(new RectF(f12, (float)(n7 + this.mRadius), f6, f7), paint);
    }

    private void drawBottomRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        Canvas canvas2 = canvas;
        canvas = rectF;
        RoundedCornersTransformation roundedCornersTransformation = this;
        float f8 = roundedCornersTransformation.mMargin;
        rectF = new RectF(f8, f7 - (float)roundedCornersTransformation.mDiameter, f6, f7);
        int n5 = this.mRadius;
        float f9 = n5;
        canvas2.drawRoundRect((RectF)canvas, f9, (float)n5, paint);
        RoundedCornersTransformation roundedCornersTransformation2 = this;
        int n6 = roundedCornersTransformation2.mMargin;
        float f10 = n6;
        f9 = n6;
        canvas2.drawRect(new RectF(f10, f9, f6, f7 -= (float)roundedCornersTransformation2.mRadius), paint);
    }

    private void drawLeftRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        Canvas canvas2 = canvas;
        canvas = rectF;
        int n5 = this.mMargin;
        float f8 = n5;
        float f9 = n5;
        float f10 = n5 + this.mDiameter;
        rectF = new RectF(f8, f9, f10, f7);
        int n6 = this.mRadius;
        float f11 = n6;
        canvas2.drawRoundRect((RectF)canvas, f11, (float)n6, paint);
        int n7 = this.mMargin;
        float f12 = n7 + this.mRadius;
        canvas2.drawRect(new RectF(f12, (float)n7, f6, f7), paint);
    }

    private void drawRightRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        Canvas canvas2 = canvas;
        canvas = rectF;
        rectF = new RectF(f6 - (float)this.mDiameter, (float)this.mMargin, f6, f7);
        int n5 = this.mRadius;
        float f8 = n5;
        canvas2.drawRoundRect((RectF)canvas, f8, (float)n5, paint);
        RoundedCornersTransformation roundedCornersTransformation = this;
        int n6 = roundedCornersTransformation.mMargin;
        float f9 = n6;
        f8 = n6;
        float f10 = f6 - (float)roundedCornersTransformation.mRadius;
        canvas2.drawRect(new RectF(f9, f8, f10, f7), paint);
    }

    private void drawOtherTopLeftRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        RectF rectF2;
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        canvas = rectF2;
        RoundedCornersTransformation roundedCornersTransformation = this;
        float f8 = roundedCornersTransformation.mMargin;
        rectF2 = new RectF(f8, f7 - (float)roundedCornersTransformation.mDiameter, f6, f7);
        int n5 = this.mRadius;
        float f9 = n5;
        canvas3.drawRoundRect((RectF)canvas, f9, (float)n5, paint);
        RectF rectF3 = rectF;
        rectF = new RectF(f6 - (float)this.mDiameter, (float)this.mMargin, f6, f7);
        int n6 = this.mRadius;
        float f10 = n6;
        canvas2.drawRoundRect(rectF3, f10, (float)n6, paint);
        RoundedCornersTransformation roundedCornersTransformation2 = this;
        int n7 = roundedCornersTransformation2.mMargin;
        float f11 = n7;
        f10 = n7;
        int n8 = roundedCornersTransformation2.mRadius;
        float f12 = f7 - (float)n8;
        canvas2.drawRect(new RectF(f11, f10, f6 -= (float)n8, f12), paint);
    }

    private void drawOtherTopRightRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        RectF rectF2;
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        canvas = rectF2;
        int n5 = this.mMargin;
        float f8 = n5;
        float f9 = n5;
        float f10 = n5 + this.mDiameter;
        rectF2 = new RectF(f8, f9, f10, f7);
        int n6 = this.mRadius;
        float f11 = n6;
        canvas3.drawRoundRect((RectF)canvas, f11, (float)n6, paint);
        RectF rectF3 = rectF;
        RoundedCornersTransformation roundedCornersTransformation = this;
        f8 = roundedCornersTransformation.mMargin;
        rectF = new RectF(f8, f7 - (float)roundedCornersTransformation.mDiameter, f6, f7);
        int n7 = this.mRadius;
        float f12 = n7;
        canvas2.drawRoundRect(rectF3, f12, (float)n7, paint);
        float f13 = f7;
        int n8 = this.mMargin;
        int n9 = this.mRadius;
        f12 = n8 + n9;
        f7 = n8;
        float f14 = f13 - (float)n9;
        canvas2.drawRect(new RectF(f12, f7, f6, f14), paint);
    }

    private void drawOtherBottomLeftRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        RectF rectF2;
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        canvas = rectF2;
        int n5 = this.mMargin;
        float f8 = n5;
        float f9 = n5;
        float f10 = n5 + this.mDiameter;
        rectF2 = new RectF(f8, f9, f6, f10);
        int n6 = this.mRadius;
        float f11 = n6;
        canvas3.drawRoundRect((RectF)canvas, f11, (float)n6, paint);
        RectF rectF3 = rectF;
        rectF = new RectF(f6 - (float)this.mDiameter, (float)this.mMargin, f6, f7);
        int n7 = this.mRadius;
        float f12 = n7;
        canvas2.drawRoundRect(rectF3, f12, (float)n7, paint);
        int n8 = this.mMargin;
        float f13 = n8;
        int n9 = this.mRadius;
        float f14 = n8 + n9;
        float f15 = f6 - (float)n9;
        canvas2.drawRect(new RectF(f13, f14, f15, f7), paint);
    }

    private void drawOtherBottomRightRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        RectF rectF2;
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        canvas = rectF2;
        int n5 = this.mMargin;
        float f8 = n5;
        float f9 = n5;
        float f10 = n5 + this.mDiameter;
        rectF2 = new RectF(f8, f9, f6, f10);
        int n6 = this.mRadius;
        float f11 = n6;
        canvas3.drawRoundRect((RectF)canvas, f11, (float)n6, paint);
        RectF rectF3 = rectF;
        int n7 = this.mMargin;
        f8 = n7;
        f9 = n7;
        f10 = n7 + this.mDiameter;
        rectF = new RectF(f8, f9, f10, f7);
        int n8 = this.mRadius;
        float f12 = n8;
        canvas2.drawRoundRect(rectF3, f12, (float)n8, paint);
        int n9 = this.mMargin;
        int n10 = this.mRadius;
        f12 = n9 + n10;
        canvas2.drawRect(new RectF(f12, (float)(n9 + n10), f6, f7), paint);
    }

    private void drawDiagonalFromTopLeftRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        RectF rectF2;
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        canvas = rectF2;
        int n5 = this.mMargin;
        float f8 = n5;
        float f9 = n5;
        int n6 = this.mDiameter;
        float f10 = n5 + n6;
        float f11 = n5 + n6;
        rectF2 = new RectF(f8, f9, f10, f11);
        int n7 = this.mRadius;
        float f12 = n7;
        canvas3.drawRoundRect((RectF)canvas, f12, (float)n7, paint);
        RectF rectF3 = rectF;
        int n8 = this.mDiameter;
        f9 = f6 - (float)n8;
        rectF = new RectF(f9, f7 - (float)n8, f6, f7);
        int n9 = this.mRadius;
        float f13 = n9;
        canvas2.drawRoundRect(rectF3, f13, (float)n9, paint);
        RoundedCornersTransformation roundedCornersTransformation = this;
        int n10 = roundedCornersTransformation.mMargin;
        f13 = n10;
        float f14 = n10 + this.mRadius;
        f9 = f6 - (float)roundedCornersTransformation.mDiameter;
        canvas2.drawRect(new RectF(f13, f14, f9, f7), paint);
        RoundedCornersTransformation roundedCornersTransformation2 = this;
        int n11 = roundedCornersTransformation2.mMargin;
        float f15 = n11 + this.mDiameter;
        f13 = n11;
        canvas2.drawRect(new RectF(f15, f13, f6, f7 -= (float)roundedCornersTransformation2.mRadius), paint);
    }

    private void drawDiagonalFromTopRightRoundRect(Canvas canvas, Paint paint, float f6, float f7) {
        RectF rectF;
        RectF rectF2;
        Canvas canvas2 = canvas;
        Canvas canvas3 = canvas;
        canvas = rectF2;
        int n5 = this.mDiameter;
        float f8 = f6 - (float)n5;
        int n6 = this.mMargin;
        float f9 = f8;
        float f10 = n6;
        f8 = n6 + n5;
        rectF2 = new RectF(f9, f10, f6, f8);
        int n7 = this.mRadius;
        float f11 = n7;
        canvas3.drawRoundRect((RectF)canvas, f11, (float)n7, paint);
        RectF rectF3 = rectF;
        int n8 = this.mMargin;
        float f12 = n8;
        int n9 = this.mDiameter;
        float f13 = f7 - (float)n9;
        float f14 = n8 + n9;
        rectF = new RectF(f12, f13, f14, f7);
        int n10 = this.mRadius;
        float f15 = n10;
        canvas2.drawRoundRect(rectF3, f15, (float)n10, paint);
        RoundedCornersTransformation roundedCornersTransformation = this;
        int n11 = roundedCornersTransformation.mMargin;
        f15 = n11;
        f12 = n11;
        int n12 = roundedCornersTransformation.mRadius;
        f13 = f6 - (float)n12;
        float f16 = f7 - (float)n12;
        canvas2.drawRect(new RectF(f15, f12, f13, f16), paint);
        int n13 = this.mMargin;
        int n14 = this.mRadius;
        f15 = n13 + n14;
        canvas2.drawRect(new RectF(f15, (float)(n13 + n14), f6, f7), paint);
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(this.getId().getBytes());
    }

    protected Bitmap transform(BitmapPool bitmapPool, Bitmap bitmap, int n5, int n6) {
        BitmapShader bitmapShader;
        Paint paint;
        Canvas canvas;
        Bitmap bitmap2 = bitmap;
        int n7 = bitmap2.getWidth();
        n5 = bitmap2.getHeight();
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        if ((config = bitmapPool.get(n7, n5, config)) == null) {
            config = Bitmap.createBitmap((int)n7, (int)n5, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        RoundedCornersTransformation roundedCornersTransformation = roundedCornersTransformation2;
        RoundedCornersTransformation roundedCornersTransformation2 = canvas;
        canvas = new Canvas((Bitmap)config);
        Paint paint2 = paint;
        new Paint().setAntiAlias(true);
        BitmapShader bitmapShader2 = bitmapShader;
        Shader.TileMode tileMode = Shader.TileMode.CLAMP;
        bitmapShader = new BitmapShader(bitmap, tileMode, tileMode);
        paint2.setShader((Shader)bitmapShader2);
        float f6 = n7;
        float f7 = n5;
        roundedCornersTransformation.drawRoundRect((Canvas)roundedCornersTransformation2, paint2, f6, f7);
        return config;
    }

    public String getId() {
        return "RoundedTransformation(radius=" + this.mRadius + ", margin=" + this.mMargin + ", diameter=" + this.mDiameter + ", cornerType=" + this.mCornerType.name() + ")";
    }

    public static final class CornerType
    extends Enum<CornerType> {
        public static final /* enum */ CornerType ALL;
        public static final /* enum */ CornerType TOP_LEFT;
        public static final /* enum */ CornerType TOP_RIGHT;
        public static final /* enum */ CornerType BOTTOM_LEFT;
        public static final /* enum */ CornerType BOTTOM_RIGHT;
        public static final /* enum */ CornerType TOP;
        public static final /* enum */ CornerType BOTTOM;
        public static final /* enum */ CornerType LEFT;
        public static final /* enum */ CornerType RIGHT;
        public static final /* enum */ CornerType OTHER_TOP_LEFT;
        public static final /* enum */ CornerType OTHER_TOP_RIGHT;
        public static final /* enum */ CornerType OTHER_BOTTOM_LEFT;
        public static final /* enum */ CornerType OTHER_BOTTOM_RIGHT;
        public static final /* enum */ CornerType DIAGONAL_FROM_TOP_LEFT;
        public static final /* enum */ CornerType DIAGONAL_FROM_TOP_RIGHT;
        private static final /* synthetic */ CornerType[] $VALUES;

        public static CornerType[] values() {
            return (CornerType[])$VALUES.clone();
        }

        public static CornerType valueOf(String string2) {
            return Enum.valueOf(CornerType.class, string2);
        }

        static {
            CornerType cornerType;
            ALL = new CornerType();
            TOP_LEFT = new CornerType();
            TOP_RIGHT = new CornerType();
            BOTTOM_LEFT = new CornerType();
            BOTTOM_RIGHT = new CornerType();
            TOP = new CornerType();
            BOTTOM = new CornerType();
            LEFT = new CornerType();
            RIGHT = new CornerType();
            OTHER_TOP_LEFT = new CornerType();
            OTHER_TOP_RIGHT = new CornerType();
            OTHER_BOTTOM_LEFT = new CornerType();
            OTHER_BOTTOM_RIGHT = new CornerType();
            DIAGONAL_FROM_TOP_LEFT = new CornerType();
            CornerType cornerType2 = cornerType;
            DIAGONAL_FROM_TOP_RIGHT = new CornerType();
            $VALUES = new CornerType[]{ALL, TOP_LEFT, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_RIGHT, TOP, BOTTOM, LEFT, RIGHT, OTHER_TOP_LEFT, OTHER_TOP_RIGHT, OTHER_BOTTOM_LEFT, OTHER_BOTTOM_RIGHT, DIAGONAL_FROM_TOP_LEFT, cornerType2};
        }
    }
}

