/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.routeguide.fsm;

import com.baidu.navisdk.util.common.i;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RGFSMTable {
    private static HashMap<String, HashMap<String, String>> dictFSM;
    private static List<String> glassStates;
    private static HashMap<String, String> dictStateSimpleGuide;
    private static HashMap<String, String> dictStateNorth2D;
    private static HashMap<String, String> dictStateCar3D;
    private static HashMap<String, String> dictStateFullview;
    private static HashMap<String, String> dictStateEnlargeRoadmap;
    private static HashMap<String, String> dictStateColladamap;
    private static HashMap<String, String> dictStateBrowseMap;
    private static HashMap<String, String> dictStateHUD;
    private static HashMap<String, String> dictStateHUDMirror;
    private static HashMap<String, String> dictStateHighway;
    private static HashMap<String, String> dictStateNaviReady;
    private static HashMap<String, String> dictStateVoice;
    private static HashMap<String, String> dictStateArriveDest;
    private static HashMap<String, String> dictStateNearbySearch;
    private static HashMap<String, String> dictStateIndoorPark;
    private static HashMap<String, String> dictStateIndoorParkBrowse;
    private static HashMap<String, String> dictStateIndoorParkChoose;
    private static HashMap<String, String> dictStatePip;
    private static HashMap<String, String> dictStateDynamicLayer;
    private static final byte[] lock;

    public static void initTransition() {
        RGFSMTable.initTransSimpleGuide();
        RGFSMTable.initTransNorth2D();
        RGFSMTable.initTransCar3D();
        RGFSMTable.initTransFullview();
        RGFSMTable.initTransEnlargeRoadmap();
        RGFSMTable.initTransColladamap();
        RGFSMTable.initTransBrowseMap();
        RGFSMTable.initTransHUD();
        RGFSMTable.initTransHUDMirror();
        RGFSMTable.initNaviReady();
        RGFSMTable.initVoiceState();
        RGFSMTable.initArriveDest();
        RGFSMTable.initTransNearbySearch();
        RGFSMTable.initIndoorParkStates();
        RGFSMTable.initIndoorParkBrowseStates();
        RGFSMTable.initIndoorParkChooseStates();
        RGFSMTable.initPipStates();
        RGFSMTable.initDynamicLayerStates();
        RGFSMTable.initDictFSM();
        RGFSMTable.initGlassStates();
    }

    private static void initPipStates() {
        dictStatePip = new HashMap<String, String>();
        dictStatePip.put("\u9000\u51fa\u753b\u4e2d\u753b\u72b6\u6001", "BACK");
        dictStatePip.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
    }

    private static void initIndoorParkBrowseStates() {
        dictStateIndoorParkBrowse = new HashMap<String, String>();
        dictStateIndoorParkBrowse.put("[\u653e\u5927\u7f29\u5c0f]\u6309\u94ae\u70b9\u51fb", "IndoorParkBrowse");
        dictStateIndoorParkBrowse.put("\u62d6\u52a8\u5730\u56fe", "IndoorParkBrowse");
        dictStateIndoorParkBrowse.put("\u89e6\u78b0\u5730\u56fe", "IndoorParkBrowse");
        dictStateIndoorParkBrowse.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "IndoorPark");
        dictStateIndoorParkBrowse.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "IndoorParkBrowse");
        dictStateIndoorParkBrowse.put("\u7ee7\u7eed\u5bfc\u822a", "IndoorPark");
        dictStateIndoorParkBrowse.put("\u9000\u51fa\u6e38\u89c8\u6001", "IndoorPark");
        dictStateIndoorParkBrowse.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateIndoorParkBrowse.put("\u9000\u51fa\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "SimpleGuide");
        dictStateIndoorParkBrowse.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u9009\u62e9\u6001", "IndoorParkChoose");
    }

    private static void initIndoorParkStates() {
        dictStateIndoorPark = new HashMap<String, String>();
        dictStateIndoorPark.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateIndoorPark.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "IndoorPark");
        dictStateIndoorPark.put("\u9000\u51fa\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "SimpleGuide");
        dictStateIndoorPark.put("\u62d6\u52a8\u5730\u56fe", "IndoorParkBrowse");
        dictStateIndoorPark.put("\u89e6\u78b0\u5730\u56fe", "IndoorParkBrowse");
        dictStateIndoorPark.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateIndoorPark.put("[3D\u8f66\u5934\u5411\u4e0a]\u6309\u94ae\u70b9\u51fb", "North2D");
        dictStateIndoorPark.put("[2D\u6b63\u5317]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateIndoorPark.put("[\u56de\u8f66\u4f4d]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateIndoorPark.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u9009\u62e9\u6001", "IndoorParkChoose");
    }

    private static void initIndoorParkChooseStates() {
        dictStateIndoorParkChoose = new HashMap<String, String>();
        dictStateIndoorParkChoose.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateIndoorParkChoose.put("\u9000\u51fa\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "SimpleGuide");
    }

    private static void initTransSimpleGuide() {
        dictStateSimpleGuide = new HashMap<String, String>();
        dictStateSimpleGuide.put("[\u56de\u8f66\u4f4d]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateSimpleGuide.put("[3D\u8f66\u5934\u5411\u4e0a]\u6309\u94ae\u70b9\u51fb", "North2D");
        dictStateSimpleGuide.put("[2D\u6b63\u5317]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateSimpleGuide.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateSimpleGuide.put("\u6307\u5357\u9488\u70b9\u51fb", "Car3D");
        dictStateSimpleGuide.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateSimpleGuide.put("\u89e6\u78b0\u5730\u56fe", "BrowseMap");
        dictStateSimpleGuide.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateSimpleGuide.put("\u4eceHUD\u53bbHUD\u955c\u50cf\u9875", "HUDMirror");
        dictStateSimpleGuide.put("\u4eceHUD\u955c\u50cf\u9875\u56de\u5230HUD", "HUD");
        dictStateSimpleGuide.put("\u6536\u5230\u653e\u5927\u56fe\u663e\u793a\u6d88\u606f", "EnlargeRoadmap");
        dictStateSimpleGuide.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateSimpleGuide.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateSimpleGuide.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "SimpleGuide");
        dictStateSimpleGuide.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateSimpleGuide.put("\u8fdb\u5165\u5bfc\u822a\u51c6\u5907\u72b6\u6001", "NaviReady");
        dictStateSimpleGuide.put("\u8fdb\u5165\u8bed\u97f3\u6001", "Voice");
        dictStateSimpleGuide.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateSimpleGuide.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateSimpleGuide.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateSimpleGuide.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
        dictStateSimpleGuide.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
    }

    private static void initTransNorth2D() {
        dictStateNorth2D = new HashMap();
        dictStateNorth2D.clear();
        dictStateNorth2D.put("[2D\u6b63\u5317]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateNorth2D.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateNorth2D.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateNorth2D.put("\u6307\u5357\u9488\u70b9\u51fb", "Car3D");
        dictStateNorth2D.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateNorth2D.put("\u89e6\u78b0\u5730\u56fe", "North2D");
        dictStateNorth2D.put("\u6536\u5230\u653e\u5927\u56fe\u663e\u793a\u6d88\u606f", "EnlargeRoadmap");
        dictStateNorth2D.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateNorth2D.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateNorth2D.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "North2D");
        dictStateNorth2D.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateNorth2D.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateNorth2D.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateNorth2D.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initTransCar3D() {
        dictStateCar3D = new HashMap();
        dictStateCar3D.clear();
        dictStateCar3D.put("[3D\u8f66\u5934\u5411\u4e0a]\u6309\u94ae\u70b9\u51fb", "North2D");
        dictStateCar3D.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateCar3D.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateCar3D.put("\u6307\u5357\u9488\u70b9\u51fb", "North2D");
        dictStateCar3D.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateCar3D.put("\u89e6\u78b0\u5730\u56fe", "Car3D");
        dictStateCar3D.put("\u6536\u5230\u653e\u5927\u56fe\u663e\u793a\u6d88\u606f", "EnlargeRoadmap");
        dictStateCar3D.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateCar3D.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateCar3D.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "Car3D");
        dictStateCar3D.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateCar3D.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateCar3D.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateCar3D.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initTransFullview() {
        dictStateFullview = new HashMap();
        dictStateFullview.clear();
        dictStateFullview.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateFullview.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateFullview.put("[\u653e\u5927\u7f29\u5c0f]\u6309\u94ae\u70b9\u51fb", "BrowseMap");
        dictStateFullview.put("[\u8fd4\u56de]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateFullview.put("\u6307\u5357\u9488\u70b9\u51fb", "BACK");
        dictStateFullview.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateFullview.put("\u89e6\u78b0\u5730\u56fe", "Fullview");
        dictStateFullview.put("\u6536\u5230\u653e\u5927\u56fe\u663e\u793a\u6d88\u606f", "EnlargeRoadmap");
        dictStateFullview.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateFullview.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateFullview.put("\u6536\u5230\u81ea\u52a8\u56de\u8f66\u4f4d\u6d88\u606f", "Fullview");
        dictStateFullview.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "Fullview");
        dictStateFullview.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateFullview.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateFullview.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateFullview.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initTransEnlargeRoadmap() {
        dictStateEnlargeRoadmap = new HashMap();
        dictStateEnlargeRoadmap.clear();
        dictStateEnlargeRoadmap.put("[\u56de\u8f66\u4f4d]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateEnlargeRoadmap.put("[3D\u8f66\u5934\u5411\u4e0a]\u6309\u94ae\u70b9\u51fb", "North2D");
        dictStateEnlargeRoadmap.put("[2D\u6b63\u5317]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateEnlargeRoadmap.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateEnlargeRoadmap.put("[\u8fd4\u56de]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateEnlargeRoadmap.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateEnlargeRoadmap.put("\u89e6\u78b0\u5730\u56fe", "BrowseMap");
        dictStateEnlargeRoadmap.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateEnlargeRoadmap.put("\u6536\u5230\u653e\u5927\u56fe\u9690\u85cf\u6d88\u606f", "BACK");
        dictStateEnlargeRoadmap.put("\u6536\u5230\u504f\u822a\u5f00\u59cb\u7684\u6d88\u606f", "SimpleGuide");
        dictStateEnlargeRoadmap.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateEnlargeRoadmap.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "EnlargeRoadmap");
        dictStateEnlargeRoadmap.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateEnlargeRoadmap.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateEnlargeRoadmap.put("\u8fdb\u5165\u5bfc\u822a\u51c6\u5907\u72b6\u6001", "NaviReady");
        dictStateEnlargeRoadmap.put("\u8fdb\u5165\u8bed\u97f3\u6001", "Voice");
        dictStateEnlargeRoadmap.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateEnlargeRoadmap.put("\u6536\u5230\u653e\u5927\u56fe\u663e\u793a\u6d88\u606f", "EnlargeRoadmap");
        dictStateEnlargeRoadmap.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateEnlargeRoadmap.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateEnlargeRoadmap.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateEnlargeRoadmap.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initTransColladamap() {
        dictStateColladamap = new HashMap();
        dictStateColladamap.clear();
        dictStateColladamap.put("[\u56de\u8f66\u4f4d]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateColladamap.put("[3D\u8f66\u5934\u5411\u4e0a]\u6309\u94ae\u70b9\u51fb", "North2D");
        dictStateColladamap.put("[2D\u6b63\u5317]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateColladamap.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateColladamap.put("[\u8fd4\u56de]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateColladamap.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateColladamap.put("\u89e6\u78b0\u5730\u56fe", "BrowseMap");
        dictStateColladamap.put("\u6536\u5230\u504f\u822a\u5f00\u59cb\u7684\u6d88\u606f", "SimpleGuide");
        dictStateColladamap.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateColladamap.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateColladamap.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "Colladamap");
        dictStateColladamap.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateColladamap.put("\u6536\u5230collada\u9690\u85cf\u6d88\u606f", "BACK");
        dictStateColladamap.put("\u8fdb\u5165\u5bfc\u822a\u51c6\u5907\u72b6\u6001", "NaviReady");
        dictStateColladamap.put("\u8fdb\u5165\u8bed\u97f3\u6001", "Voice");
        dictStateColladamap.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateColladamap.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateColladamap.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateColladamap.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initTransBrowseMap() {
        dictStateBrowseMap = new HashMap();
        dictStateBrowseMap.clear();
        dictStateBrowseMap.put("[\u56de\u8f66\u4f4d]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateBrowseMap.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateBrowseMap.put("[\u653e\u5927\u7f29\u5c0f]\u6309\u94ae\u70b9\u51fb", "BrowseMap");
        dictStateBrowseMap.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateBrowseMap.put("\u4eceHUD\u53bbHUD\u955c\u50cf\u9875", "HUDMirror");
        dictStateBrowseMap.put("\u6307\u5357\u9488\u70b9\u51fb", "BACK");
        dictStateBrowseMap.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateBrowseMap.put("\u89e6\u78b0\u5730\u56fe", "BrowseMap");
        dictStateBrowseMap.put("\u6536\u5230\u653e\u5927\u56fe\u663e\u793a\u6d88\u606f", "EnlargeRoadmap");
        dictStateBrowseMap.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateBrowseMap.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateBrowseMap.put("\u6536\u5230\u81ea\u52a8\u56de\u8f66\u4f4d\u6d88\u606f", "BACK");
        dictStateBrowseMap.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "BrowseMap");
        dictStateBrowseMap.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateBrowseMap.put("\u9000\u51fa\u6e38\u89c8\u6001", "BACK");
        dictStateBrowseMap.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateBrowseMap.put("\u8fdb\u5165\u8bed\u97f3\u6001", "Voice");
        dictStateBrowseMap.put("\u9000\u51fa\u8bed\u97f3\u6001", "BrowseMap");
        dictStateBrowseMap.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateBrowseMap.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateBrowseMap.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateBrowseMap.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initNaviReady() {
        dictStateNaviReady = new HashMap();
        dictStateNaviReady.clear();
        dictStateNaviReady.put("\u6307\u5357\u9488\u70b9\u51fb", "BACK");
        dictStateNaviReady.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateNaviReady.put("\u6536\u5230\u504f\u822a\u5f00\u59cb\u7684\u6d88\u606f", "SimpleGuide");
        dictStateNaviReady.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateNaviReady.put("\u9000\u51fa\u5bfc\u822a\u51c6\u5907\u72b6\u6001", "SimpleGuide");
        dictStateNaviReady.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "NaviReady");
        dictStateNaviReady.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateNaviReady.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateNaviReady.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateNaviReady.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateNaviReady.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initVoiceState() {
        dictStateVoice = new HashMap();
        dictStateVoice.clear();
        dictStateVoice.put("\u9000\u51fa\u8bed\u97f3\u6001", "BACK");
        dictStateVoice.put("\u6536\u5230\u504f\u822a\u5f00\u59cb\u7684\u6d88\u606f", "SimpleGuide");
        dictStateVoice.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateVoice.put("\u9000\u51fa\u6e38\u89c8\u6001", "BACK");
        dictStateVoice.put("[\u56de\u8f66\u4f4d]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateVoice.put("[3D\u8f66\u5934\u5411\u4e0a]\u6309\u94ae\u70b9\u51fb", "North2D");
        dictStateVoice.put("[2D\u6b63\u5317]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateVoice.put("\u89e6\u78b0\u5730\u56fe", "BrowseMap");
        dictStateVoice.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "Voice");
        dictStateVoice.put("\u8fdb\u5165\u5bfc\u822a\u51c6\u5907\u72b6\u6001", "NaviReady");
        dictStateVoice.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateVoice.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateVoice.put("\u4ece\u8bed\u97f3\u8fdb\u5165HUD\u955c\u50cf\u9875", "HUDMirror");
        dictStateVoice.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateVoice.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initArriveDest() {
        dictStateArriveDest = new HashMap();
        dictStateArriveDest.clear();
        dictStateArriveDest.put("\u9000\u51fa\u76ee\u7684\u5730\u6001\u6d88\u606f", "SimpleGuide");
        dictStateArriveDest.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "ArriveDest");
        dictStateArriveDest.put("\u62d6\u52a8\u5730\u56fe", "ArriveDest");
        dictStateArriveDest.put("\u89e6\u78b0\u5730\u56fe", "ArriveDest");
        dictStateArriveDest.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateArriveDest.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateArriveDest.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initTransHUD() {
        dictStateHUD = new HashMap();
        dictStateHUD.clear();
        dictStateHUD.put("\u4eceHUD\u53bbHUD\u955c\u50cf\u9875", "HUDMirror");
        dictStateHUD.put("[\u8fd4\u56de]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateHUD.put("\u6536\u5230\u504f\u822a\u5f00\u59cb\u7684\u6d88\u606f", "SimpleGuide");
        dictStateHUD.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateHUD.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateHUD.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateHUD.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateHUD.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
    }

    private static void initTransHUDMirror() {
        dictStateHUDMirror = new HashMap();
        dictStateHUDMirror.clear();
        dictStateHUDMirror.put("[\u8fd4\u56de]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateHUDMirror.put("\u4eceHUD\u955c\u50cf\u9875\u56de\u5230HUD", "HUD");
        dictStateHUDMirror.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateHUDMirror.put("\u6536\u5230\u504f\u822a\u5f00\u59cb\u7684\u6d88\u606f", "SimpleGuide");
        dictStateHUDMirror.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateHUDMirror.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateHUDMirror.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateHUDMirror.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateHUDMirror.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
    }

    private static void initTransHighway() {
        dictStateHighway = new HashMap();
        dictStateHighway.clear();
        dictStateHighway.put("[\u56de\u8f66\u4f4d]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateHighway.put("[3D\u8f66\u5934\u5411\u4e0a]\u6309\u94ae\u70b9\u51fb", "North2D");
        dictStateHighway.put("[2D\u6b63\u5317]\u6309\u94ae\u70b9\u51fb", "Car3D");
        dictStateHighway.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateHighway.put("\u62d6\u52a8\u5730\u56fe", "BrowseMap");
        dictStateHighway.put("\u89e6\u78b0\u5730\u56fe", "BrowseMap");
        dictStateHighway.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateHighway.put("\u4eceHUD\u53bbHUD\u955c\u50cf\u9875", "HUDMirror");
        dictStateHighway.put("\u4eceHUD\u955c\u50cf\u9875\u56de\u5230HUD", "HUD");
        dictStateHighway.put("\u6536\u5230\u504f\u822a\u5f00\u59cb\u7684\u6d88\u606f", "SimpleGuide");
        dictStateHighway.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateHighway.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "Highway");
        dictStateHighway.put("\u6536\u5230\u653e\u5927\u56fe\u663e\u793a\u6d88\u606f", "EnlargeRoadmap");
        dictStateHighway.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateHighway.put("\u7ee7\u7eed\u5bfc\u822a", "Highway");
        dictStateHighway.put("\u8fdb\u5165\u5bfc\u822a\u51c6\u5907\u72b6\u6001", "NaviReady");
        dictStateHighway.put("\u8fdb\u5165\u8bed\u97f3\u6001", "Voice");
        dictStateHighway.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateHighway.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateHighway.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateHighway.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initTransNearbySearch() {
        dictStateNearbySearch = new HashMap();
        dictStateNearbySearch.clear();
        dictStateNearbySearch.put("[\u8fd4\u56de]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateNearbySearch.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateNearbySearch.put("[\u653e\u5927\u7f29\u5c0f]\u6309\u94ae\u70b9\u51fb", "NearbySearch");
        dictStateNearbySearch.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateNearbySearch.put("\u4eceHUD\u53bbHUD\u955c\u50cf\u9875", "HUDMirror");
        dictStateNearbySearch.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateNearbySearch.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateNearbySearch.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "NearbySearch");
        dictStateNearbySearch.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateNearbySearch.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateNearbySearch.put("\u8fdb\u5165\u8bed\u97f3\u6001", "Voice");
        dictStateNearbySearch.put("\u9000\u51fa\u8bed\u97f3\u6001", "BACK");
        dictStateNearbySearch.put("\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001", "NearbySearch");
        dictStateNearbySearch.put("\u9000\u51fa\u6cbf\u9014\u641c\u7d22\u6001", "BACK");
        dictStateNearbySearch.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateNearbySearch.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
        dictStateNearbySearch.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
    }

    private static void initDynamicLayerStates() {
        dictStateDynamicLayer = new HashMap<String, String>();
        dictStateDynamicLayer.put("[\u8fd4\u56de]\u6309\u94ae\u70b9\u51fb", "BACK");
        dictStateDynamicLayer.put("[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb", "Fullview");
        dictStateDynamicLayer.put("[\u653e\u5927\u7f29\u5c0f]\u6309\u94ae\u70b9\u51fb", "DynamicLayer");
        dictStateDynamicLayer.put("[HUD]\u6309\u94ae\u70b9\u51fb", "HUD");
        dictStateDynamicLayer.put("\u4eceHUD\u53bbHUD\u955c\u50cf\u9875", "HUDMirror");
        dictStateDynamicLayer.put("\u6536\u5230collada\u663e\u793a\u6d88\u606f", "Colladamap");
        dictStateDynamicLayer.put("\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f", "SimpleGuide");
        dictStateDynamicLayer.put("\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f", "DynamicLayer");
        dictStateDynamicLayer.put("\u7ee7\u7eed\u5bfc\u822a", "SimpleGuide");
        dictStateDynamicLayer.put("\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f", "ArriveDest");
        dictStateDynamicLayer.put("\u8fdb\u5165\u8bed\u97f3\u6001", "Voice");
        dictStateDynamicLayer.put("\u9000\u51fa\u8bed\u97f3\u6001", "BACK");
        dictStateDynamicLayer.put("\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "DynamicLayer");
        dictStateDynamicLayer.put("\u9000\u51fa\u52a8\u6001\u56fe\u5c42\u72b6\u6001", "BACK");
        dictStateDynamicLayer.put("\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001", "IndoorPark");
        dictStateDynamicLayer.put("\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001", "PIP");
    }

    private static void initDictFSM() {
        dictFSM = new HashMap();
        dictFSM.clear();
        dictFSM.put("SimpleGuide", dictStateSimpleGuide);
        dictFSM.put("North2D", dictStateNorth2D);
        dictFSM.put("Car3D", dictStateCar3D);
        dictFSM.put("Fullview", dictStateFullview);
        dictFSM.put("EnlargeRoadmap", dictStateEnlargeRoadmap);
        dictFSM.put("Colladamap", dictStateColladamap);
        dictFSM.put("BrowseMap", dictStateBrowseMap);
        dictFSM.put("HUD", dictStateHUD);
        dictFSM.put("HUDMirror", dictStateHUDMirror);
        dictFSM.put("NaviReady", dictStateNaviReady);
        dictFSM.put("Voice", dictStateVoice);
        dictFSM.put("ArriveDest", dictStateArriveDest);
        dictFSM.put("NearbySearch", dictStateNearbySearch);
        dictFSM.put("IndoorPark", dictStateIndoorPark);
        dictFSM.put("IndoorParkBrowse", dictStateIndoorParkBrowse);
        dictFSM.put("IndoorParkChoose", dictStateIndoorParkChoose);
        dictFSM.put("PIP", dictStatePip);
        dictFSM.put("DynamicLayer", dictStateDynamicLayer);
    }

    private static void initGlassStates() {
        glassStates = new ArrayList<String>();
        glassStates.add("North2D");
        glassStates.add("Car3D");
        glassStates.add("Fullview");
    }

    public static boolean isGlassState(String string2) {
        if (string2 != null && string2.length() != 0) {
            return glassStates.contains(string2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String queryDestState(String string2, String string3) {
        byte[] byArray = lock;
        synchronized (lock) {
            Object object = dictFSM.get(string2);
            if (object == null) {
                if (i.c.d()) {
                    i.c.e("RouteGuide", "\u4e0d\u5b58\u5728\u8be5\u72b6\u6001\u5bf9\u5e94\u7684\u72b6\u6001\u673a\uff0c\u8bf7\u5b8c\u5584\u903b\u8f91!");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            if ((object = ((HashMap)object).get(string3)) == null) {
                if (i.c.d()) {
                    i.c.e("RouteGuide", "\u5904\u4e8e\u72b6\u6001 (" + string2 + ")\u65f6\uff0c \u4e0d\u5b58\u5728\u6267\u884cevent = " + string3 + " \u7684\u8df3\u8f6c\uff0c\u8bf7\u8003\u8651\u662f\u5426\u5b8c\u5584\u903b\u8f91!");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return object;
        }
    }

    public static boolean isNeedRefreshMapState(String string2) {
        if (string2 != null && string2.length() != 0) {
            return "SimpleGuide".equals(string2);
        }
        return false;
    }

    public static void destory() {
        HashMap<String, Object> hashMap = dictFSM;
        if (hashMap != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateNorth2D) != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateCar3D) != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateFullview) != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateEnlargeRoadmap) != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateColladamap) != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateBrowseMap) != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateHUD) != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateHUDMirror) != null) {
            hashMap.clear();
        }
        if ((hashMap = dictStateHighway) != null) {
            hashMap.clear();
        }
    }

    static {
        lock = new byte[0];
    }

    public static class FsmParamsKey {
        public static final String ORIENTATION_CHANGE = "orientation_change";
        public static final String RUN_EVENT = "run_event";
        public static final String IS_AR_NAVI = "is_ar_navi";
        public static final String IS_NEED_EXECUTE_GLASS_FMS = "is_need_execute_glass_fms";
        public static final String IS_FROM_SUB_BASE_MAP = "is_from_sub_base_map";
    }

    public static class FsmEvent {
        public static final String BTN_CLICK_NORTH_2D = "[2D\u6b63\u5317]\u6309\u94ae\u70b9\u51fb";
        public static final String BTN_CLICK_CAR_3D = "[3D\u8f66\u5934\u5411\u4e0a]\u6309\u94ae\u70b9\u51fb";
        public static final String BTN_CLICK_LOC_CAR = "[\u56de\u8f66\u4f4d]\u6309\u94ae\u70b9\u51fb";
        public static final String BTN_CLICK_FULL_VIEW = "[\u4e00\u952e\u5168\u89c8]\u6309\u94ae\u70b9\u51fb";
        public static final String BTN_CLICK_HUD_ENTER = "[HUD]\u6309\u94ae\u70b9\u51fb";
        public static final String BTN_CLICK_AR = "[AR]\u6309\u94ae\u70b9\u51fb";
        public static final String BTN_CLICK_ZOOM = "[\u653e\u5927\u7f29\u5c0f]\u6309\u94ae\u70b9\u51fb";
        public static final String BTN_CLICK_BACK = "[\u8fd4\u56de]\u6309\u94ae\u70b9\u51fb";
        public static final String MAP_COMPASS_CLICK = "\u6307\u5357\u9488\u70b9\u51fb";
        public static final String MAP_MOVE = "\u62d6\u52a8\u5730\u56fe";
        public static final String TOUCH_MAP = "\u89e6\u78b0\u5730\u56fe";
        public static final String TOUCH_ENLARGE_ROAD_MAP = "\u89e6\u78b0\u653e\u5927\u56fe";
        public static final String MSG_ENLARGE_ROADMAP_SHOW = "\u6536\u5230\u653e\u5927\u56fe\u663e\u793a\u6d88\u606f";
        public static final String MSG_ENLARGE_ROADMAP_HIDE = "\u6536\u5230\u653e\u5927\u56fe\u9690\u85cf\u6d88\u606f";
        public static final String MSG_YAWING_START = "\u6536\u5230\u504f\u822a\u5f00\u59cb\u7684\u6d88\u606f";
        public static final String MSG_YAWING_REROUTED = "\u6536\u5230\u504f\u822a\u7b97\u8def\u6210\u529f\u6d88\u606f";
        public static final String MSG_AUTO_LOC_CAR_WHEN_TIMEOUT = "\u6536\u5230\u81ea\u52a8\u56de\u8f66\u4f4d\u6d88\u606f";
        public static final String MSG_PORT_LAND_SCREEN_CHANGED = "\u6536\u5230\u6a2a\u7ad6\u5c4f\u53d8\u5316\u6d88\u606f";
        public static final String MSG_HUD_GOTO_MIRROR = "\u4eceHUD\u53bbHUD\u955c\u50cf\u9875";
        public static final String MSG_MIRROR_GOTO_HUD = "\u4eceHUD\u955c\u50cf\u9875\u56de\u5230HUD";
        public static final String CONTINUE_NAVI = "\u7ee7\u7eed\u5bfc\u822a";
        public static final String MSG_COLLADA_SHOW = "\u6536\u5230collada\u663e\u793a\u6d88\u606f";
        public static final String MSG_COLLADA_HIDE = "\u6536\u5230collada\u9690\u85cf\u6d88\u606f";
        public static final String ENTRY_NAVI_READY = "\u8fdb\u5165\u5bfc\u822a\u51c6\u5907\u72b6\u6001";
        public static final String EXIT_NAVI_READY = "\u9000\u51fa\u5bfc\u822a\u51c6\u5907\u72b6\u6001";
        public static final String VOICE_STATE_ENTRY = "\u8fdb\u5165\u8bed\u97f3\u6001";
        public static final String VOICE_STATE_EXIT = "\u9000\u51fa\u8bed\u97f3\u6001";
        public static final String BROWSER_STATE_EXIT = "\u9000\u51fa\u6e38\u89c8\u6001";
        public static final String MSG_ENTER_ARRIVE_DEST = "\u5bfc\u822a\u7ed3\u675f\u8fdb\u5165\u76ee\u7684\u5730\u6001\u6d88\u606f";
        public static final String MSG_EXIT_ARRIVE_DEST = "\u9000\u51fa\u76ee\u7684\u5730\u6001\u6d88\u606f";
        public static final String ENTRY_NEARBY_SEARCH = "\u8fdb\u5165\u6cbf\u9014\u641c\u7d22\u6001";
        public static final String EXIT_NEARBY_SEARCH = "\u9000\u51fa\u6cbf\u9014\u641c\u7d22\u6001";
        public static final String VOICE_HUDMIRROR = "\u4ece\u8bed\u97f3\u8fdb\u5165HUD\u955c\u50cf\u9875";
        public static final String ENTRY_INDOOR_PARK = "\u8fdb\u5165\u505c\u8f66\u4f4d\u5bfc\u822a\u6001";
        public static final String EXIT_INDOOR_PARK = "\u9000\u51fa\u505c\u8f66\u4f4d\u5bfc\u822a\u6001";
        public static final String ENTRY_INDOOR_PARK_CHOOSE = "\u8fdb\u5165\u505c\u8f66\u4f4d\u9009\u62e9\u6001";
        public static final String ENTRY_PIP = "\u8fdb\u5165\u753b\u4e2d\u753b\u72b6\u6001";
        public static final String EXIT_PIP = "\u9000\u51fa\u753b\u4e2d\u753b\u72b6\u6001";
        public static final String ENTRY_DYNAMIC_LAYER = "\u8fdb\u5165\u52a8\u6001\u56fe\u5c42\u72b6\u6001";
        public static final String EXIT_DYNAMIC_LAYER = "\u9000\u51fa\u52a8\u6001\u56fe\u5c42\u72b6\u6001";
    }

    public static class FsmState {
        public static final String BACK = "BACK";
        public static final String SimpleGuide = "SimpleGuide";
        public static final String NaviReady = "NaviReady";
        public static final String Voice = "Voice";
        public static final String North2D = "North2D";
        public static final String Car3D = "Car3D";
        public static final String Fullview = "Fullview";
        public static final String EnlargeRoadmap = "EnlargeRoadmap";
        public static final String BrowseMap = "BrowseMap";
        public static final String HUD = "HUD";
        public static final String HUDMirror = "HUDMirror";
        public static final String Highway = "Highway";
        public static final String Colladamap = "Colladamap";
        public static final String ArriveDest = "ArriveDest";
        public static final String NearbySearch = "NearbySearch";
        public static final String IndoorPark = "IndoorPark";
        public static final String IndoorParkChoose = "IndoorParkChoose";
        public static final String IndoorParkBrowse = "IndoorParkBrowse";
        public static final String Pip = "PIP";
        public static final String DynamicLayer = "DynamicLayer";
    }
}

