/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.routeguide.model;

import com.baidu.navisdk.embed.R;
import com.baidu.navisdk.ui.routeguide.model.RGLineItem;
import com.baidu.navisdk.ui.routeguide.model.r;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.i;
import java.util.ArrayList;
import java.util.HashMap;

public class RGLaneInfoModel {
    public static final String TAG = "com.baidu.navisdk.ui.routeguide.model.RGLaneInfoModel";
    public static RGLaneInfoModel mInstance = new RGLaneInfoModel();
    public static final int MAX_LINE_NUMBER = 16;
    public static final int CURRENT_MAX_LINE = 14;
    public static final int LANE_SOURCE = 2;
    public static final int DEFAULT_ERROR_ID = 99;
    public static final int ENLARGE_TYPE = 100;
    public static final int NORMAL_LANE = 101;
    public RGLineItem[] mLaneLineList = new RGLineItem[16];
    public int mLineNumber = 0;
    public int mStartDist = 0;
    public int mRemainDist = 0;
    public int mID = 0;
    public double mX = 0.0;
    public double mY = 0.0;
    public int mDriveHabbit = 0;
    public boolean isLaneShow = false;
    private final HashMap<String, Integer> mImageMap = new HashMap();
    private final HashMap<String, String> mImageNameMap = new HashMap();
    public boolean isShow = false;
    public ArrayList<Integer> mImageIdList = new ArrayList();
    public int needDisplay;
    public int mAceUpdate;
    private final r mRGLaneInfoRightHandHelper = new r();

    private void initImageNameMap() {
        RGLaneInfoModel rGLaneInfoModel = this;
        rGLaneInfoModel.mImageNameMap.put("011000000", "nsdk_ic_lane_turn_left_90");
        rGLaneInfoModel.mImageNameMap.put("010000000", "nsdk_ic_lane_turn_left_90_gray");
        rGLaneInfoModel.mImageNameMap.put("000110000", "nsdk_ic_lane_turn_right_90");
        rGLaneInfoModel.mImageNameMap.put("000100000", "nsdk_ic_lane_turn_right_90_gray");
        rGLaneInfoModel.mImageNameMap.put("000001100", "nsdk_ic_lane_straight");
        rGLaneInfoModel.mImageNameMap.put("000001000", "nsdk_ic_lane_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("000000011", "nsdk_ic_lane_turn_around_left");
        rGLaneInfoModel.mImageNameMap.put("000000010", "nsdk_ic_lane_turn_around_left_gray");
        rGLaneInfoModel.mImageNameMap.put("010001000", "nsdk_ic_lane_2cross_left_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("011001000", "nsdk_ic_lane_2cross_turn_left");
        rGLaneInfoModel.mImageNameMap.put("010001100", "nsdk_ic_lane_2cross_left_straight");
        rGLaneInfoModel.mImageNameMap.put("000101000", "nsdk_ic_lane_2cross_right_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("000111000", "nsdk_ic_lane_2cross_turn_right");
        rGLaneInfoModel.mImageNameMap.put("000101100", "nsdk_ic_lane_2cross_right_straight");
        rGLaneInfoModel.mImageNameMap.put("010101000", "nsdk_ic_lane_3cross_gray");
        rGLaneInfoModel.mImageNameMap.put("011101000", "nsdk_ic_lane_3cross_turn_left");
        rGLaneInfoModel.mImageNameMap.put("010111000", "nsdk_ic_lane_3cross_turn_right");
        rGLaneInfoModel.mImageNameMap.put("010101100", "nsdk_ic_lane_3cross_straight");
        rGLaneInfoModel.mImageNameMap.put("010000010", "nsdk_ic_lane_around_and_left_gray");
        rGLaneInfoModel.mImageNameMap.put("011000010", "nsdk_ic_lane_left_and_around");
        rGLaneInfoModel.mImageNameMap.put("010000011", "nsdk_ic_lane_around_and_left");
        rGLaneInfoModel.mImageNameMap.put("010100000", "nsdk_ic_lane_left_and_right_gray");
        rGLaneInfoModel.mImageNameMap.put("011100000", "nsdk_ic_lane_left_and_right");
        rGLaneInfoModel.mImageNameMap.put("010110000", "nsdk_ic_lane_right_and_left");
        rGLaneInfoModel.mImageNameMap.put("000100010", "nsdk_ic_lane_around_and_right_gray");
        rGLaneInfoModel.mImageNameMap.put("000110010", "nsdk_ic_lane_right_and_around");
        rGLaneInfoModel.mImageNameMap.put("000100011", "nsdk_ic_lane_around_and_right");
        rGLaneInfoModel.mImageNameMap.put("000001010", "nsdk_ic_lane_around_and_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("000001110", "nsdk_ic_lane_straight_and_around");
        rGLaneInfoModel.mImageNameMap.put("000001011", "nsdk_ic_lane_around_and_straight");
        rGLaneInfoModel.mImageNameMap.put("010100010", "nsdk_ic_lane_around_left_right_gray");
        rGLaneInfoModel.mImageNameMap.put("011100010", "nsdk_ic_lane_left_around_right");
        rGLaneInfoModel.mImageNameMap.put("010110010", "nsdk_ic_lane_right_around_left");
        rGLaneInfoModel.mImageNameMap.put("010100011", "nsdk_ic_lane_around_left_right");
        rGLaneInfoModel.mImageNameMap.put("010001010", "nsdk_ic_lane_around_left_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("011001010", "nsdk_ic_lane_left_around_straight");
        rGLaneInfoModel.mImageNameMap.put("010001110", "nsdk_ic_lane_straight_left_around");
        rGLaneInfoModel.mImageNameMap.put("010001011", "nsdk_ic_lane_around_left_straight");
        rGLaneInfoModel.mImageNameMap.put("000101010", "nsdk_ic_lane_around_right_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("000111010", "nsdk_ic_lane_right_around_straight");
        rGLaneInfoModel.mImageNameMap.put("000101110", "nsdk_ic_lane_straight_right_around");
        rGLaneInfoModel.mImageNameMap.put("000101011", "nsdk_ic_lane_around_right_straight");
        rGLaneInfoModel.mImageNameMap.put("010101010", "nsdk_ic_lane_around_left_right_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("011101010", "nsdk_ic_lane_left_around_right_straight");
        rGLaneInfoModel.mImageNameMap.put("010111010", "nsdk_ic_lane_right_around_left_straight");
        rGLaneInfoModel.mImageNameMap.put("010101110", "nsdk_ic_lane_straight_around_left_right");
        rGLaneInfoModel.mImageNameMap.put("010101011", "nsdk_ic_lane_around_left_right_straight");
        rGLaneInfoModel.mImageNameMap.put("111000000", "nsdk_ic_lane_bus_left");
        rGLaneInfoModel.mImageNameMap.put("100110000", "nsdk_ic_lane_bus_right");
        rGLaneInfoModel.mImageNameMap.put("100001100", "nsdk_ic_lane_bus_front");
        rGLaneInfoModel.mImageNameMap.put("100000011", "nsdk_ic_lane_bus_back");
        rGLaneInfoModel.mImageNameMap.put("210001000", "nsdk_ic_lane_bus_left_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("200101000", "nsdk_ic_lane_bus_right_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("210101000", "nsdk_ic_lane_bus_3cross_gray");
        rGLaneInfoModel.mImageNameMap.put("210000010", "nsdk_ic_lane_bus_around_and_left_gray");
        rGLaneInfoModel.mImageNameMap.put("200100010", "nsdk_ic_lane_bus_around_and_right_gray");
        rGLaneInfoModel.mImageNameMap.put("200001010", "nsdk_ic_lane_bus_around_and_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("210100010", "nsdk_ic_lane_bus_around_left_right_gray");
        rGLaneInfoModel.mImageNameMap.put("210001010", "nsdk_ic_lane_bus_around_left_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("200101010", "nsdk_ic_lane_bus_around_right_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("210100000", "nsdk_ic_lane_bus_left_and_right_gray");
        rGLaneInfoModel.mImageNameMap.put("200001000", "nsdk_ic_lane_bus_straight_gray");
        rGLaneInfoModel.mImageNameMap.put("200000010", "nsdk_ic_lane_bus_turn_around_left_gray");
        rGLaneInfoModel.mImageNameMap.put("210000000", "nsdk_ic_lane_bus_turn_left_90_gray");
        rGLaneInfoModel.mImageNameMap.put("200100000", "nsdk_ic_lane_bus_turn_right_90_gray");
    }

    private int parseSpecialLaneLine(RGLineItem rGLineItem) {
        if (rGLineItem == null) {
            LogUtil.e(TAG, "parseSpecialLaneLine->item = null,return -1!");
            return -1;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "parseSpecialLaneLine->RGLineItem:" + rGLineItem.toString());
        }
        if (rGLineItem.isORNLane) {
            return R.drawable.nsdk_ic_lane_winter_olympic_text;
        }
        if (rGLineItem.isBusLaneTextBright) {
            return R.drawable.nsdk_ic_lane_bus_text;
        }
        if (rGLineItem.isVariableBright) {
            if (this.mAceUpdate == 0) {
                return R.drawable.nsdk_ic_lane_variable_bright;
            }
            if (rGLineItem.isLeftBright) {
                return R.drawable.nsdk_ic_lane_changable_left_bright;
            }
            if (rGLineItem.isRightBright) {
                return R.drawable.nsdk_ic_lane_changable_right_bright;
            }
            if (rGLineItem.isFrontBright) {
                return R.drawable.nsdk_ic_lane_changable_front_bright;
            }
            if (rGLineItem.isBackBright) {
                return R.drawable.nsdk_ic_lane_changable_back_bright;
            }
            return R.drawable.nsdk_ic_lane_variable_bright;
        }
        if (rGLineItem.isVariable) {
            if (this.mAceUpdate == 0) {
                return R.drawable.nsdk_ic_lane_variable;
            }
            if (rGLineItem.isLeft && rGLineItem.isRight || rGLineItem.isLeft && rGLineItem.isFront || rGLineItem.isLeft && rGLineItem.isBack || rGLineItem.isRight && rGLineItem.isBack || rGLineItem.isRight && rGLineItem.isFront || rGLineItem.isFront && rGLineItem.isBack) {
                return R.drawable.nsdk_ic_lane_variable;
            }
            if (rGLineItem.isLeft) {
                return R.drawable.nsdk_ic_lane_changable_left;
            }
            if (rGLineItem.isRight) {
                return R.drawable.nsdk_ic_lane_changable_right;
            }
            if (rGLineItem.isFront) {
                return R.drawable.nsdk_ic_lane_changable_front;
            }
            if (rGLineItem.isBack) {
                return R.drawable.nsdk_ic_lane_changable_back;
            }
            return R.drawable.nsdk_ic_lane_variable;
        }
        if (rGLineItem.isHov) {
            return R.drawable.nsdk_ic_lane_hov;
        }
        if (rGLineItem.isHovBright) {
            return R.drawable.nsdk_ic_lane_hov_bright;
        }
        if (rGLineItem.isTidalTextBright) {
            return R.drawable.nsdk_ic_lane_tidal_text_bright;
        }
        if (rGLineItem.isTidalText) {
            return R.drawable.nsdk_ic_lane_tidal_text;
        }
        if (rGLineItem.isTidalAvailableBright) {
            return R.drawable.nsdk_ic_lane_tidal_available_bright;
        }
        if (rGLineItem.isTidalAvailable) {
            return R.drawable.nsdk_ic_lane_tidal_available;
        }
        if (rGLineItem.isTidalFrontBright) {
            if (rGLineItem.isLeft) {
                return R.drawable.nsdk_ic_lane_tidal_left_bright;
            }
            if (rGLineItem.isRight) {
                return R.drawable.nsdk_ic_lane_tidal_right_bright;
            }
            if (rGLineItem.isFront) {
                return R.drawable.nsdk_ic_lane_tidal_front_bright;
            }
            if (rGLineItem.isBack) {
                return R.drawable.nsdk_ic_lane_tidal_back_bright;
            }
        } else if (rGLineItem.isTidalFront) {
            if (rGLineItem.isLeft) {
                return R.drawable.nsdk_ic_lane_tidal_left;
            }
            if (rGLineItem.isRight) {
                return R.drawable.nsdk_ic_lane_tidal_right;
            }
            if (rGLineItem.isFront) {
                return R.drawable.nsdk_ic_lane_tidal_front;
            }
            if (rGLineItem.isBack) {
                return R.drawable.nsdk_ic_lane_tidal_back;
            }
        }
        return -1;
    }

    private String parseSpecialLaneLineToString(RGLineItem rGLineItem) {
        if (rGLineItem == null) {
            LogUtil.e(TAG, "parseSpecialLaneLine->item = null,return -1!");
            return null;
        }
        if (LogUtil.LOGGABLE) {
            LogUtil.e(TAG, "parseSpecialLaneLine->RGLineItem:" + rGLineItem.toString());
        }
        if (rGLineItem.isORNLane) {
            return "nsdk_ic_lane_winter_olympic_text";
        }
        if (rGLineItem.isBusLaneTextBright) {
            return "nsdk_ic_lane_bus_text";
        }
        if (rGLineItem.isVariableBright) {
            return "nsdk_ic_lane_variable_bright";
        }
        if (rGLineItem.isVariable) {
            return "nsdk_ic_lane_variable";
        }
        if (rGLineItem.isHov) {
            return "nsdk_ic_lane_hov";
        }
        if (rGLineItem.isHovBright) {
            return "nsdk_ic_lane_hov_bright";
        }
        if (rGLineItem.isTidalTextBright) {
            return "nsdk_ic_lane_tidal_text_bright";
        }
        if (rGLineItem.isTidalText) {
            return "nsdk_ic_lane_tidal_text";
        }
        if (rGLineItem.isTidalAvailableBright) {
            return "nsdk_ic_lane_tidal_available_bright";
        }
        if (rGLineItem.isTidalAvailable) {
            return "nsdk_ic_lane_tidal_available";
        }
        if (rGLineItem.isTidalFrontBright) {
            if (rGLineItem.isLeft) {
                return "nsdk_ic_lane_tidal_left_bright";
            }
            if (rGLineItem.isRight) {
                return "nsdk_ic_lane_tidal_right_bright";
            }
            if (rGLineItem.isFront) {
                return "nsdk_ic_lane_tidal_front_bright";
            }
            if (rGLineItem.isBack) {
                return "nsdk_ic_lane_tidal_back_bright";
            }
        } else if (rGLineItem.isTidalFront) {
            if (rGLineItem.isLeft) {
                return "nsdk_ic_lane_tidal_left";
            }
            if (rGLineItem.isRight) {
                return "nsdk_ic_lane_tidal_right";
            }
            if (rGLineItem.isFront) {
                return "nsdk_ic_lane_tidal_front";
            }
            if (rGLineItem.isBack) {
                return "nsdk_ic_lane_tidal_back";
            }
        }
        return null;
    }

    private int getImageID(String string2) {
        HashMap<String, Integer> hashMap;
        int n5 = 99;
        if (this.mDriveHabbit == 1) {
            string2 = this.mRGLaneInfoRightHandHelper.a(string2);
        }
        if ((hashMap = this.mImageMap) != null && hashMap.containsKey(string2)) {
            n5 = this.mImageMap.get(string2);
        }
        LogUtil.e(TAG, "getImageID id is " + n5);
        return n5;
    }

    private String getImageName(String string2) {
        HashMap<String, String> hashMap;
        String string3 = null;
        if (this.mDriveHabbit == 1) {
            string2 = this.mRGLaneInfoRightHandHelper.a(string2);
        }
        if ((hashMap = this.mImageNameMap) != null && hashMap.containsKey(string2)) {
            string3 = this.mImageNameMap.get(string2);
        }
        LogUtil.e(TAG, "getImageID id is " + string3);
        return string3;
    }

    public static RGLaneInfoModel getModel(boolean bl) {
        if (bl || mInstance == null) {
            mInstance = new RGLaneInfoModel();
        }
        return mInstance;
    }

    public boolean isShowLaneLineView() {
        return this.isShow && this.isLaneShow;
    }

    public void initMap() {
        if (this.mImageMap.size() > 0) {
            return;
        }
        RGLaneInfoModel rGLaneInfoModel = this;
        rGLaneInfoModel.mImageMap.put("011000000", R.drawable.nsdk_ic_lane_turn_left_90);
        rGLaneInfoModel.mImageMap.put("010000000", R.drawable.nsdk_ic_lane_turn_left_90_gray);
        rGLaneInfoModel.mImageMap.put("000110000", R.drawable.nsdk_ic_lane_turn_right_90);
        rGLaneInfoModel.mImageMap.put("000100000", R.drawable.nsdk_ic_lane_turn_right_90_gray);
        rGLaneInfoModel.mImageMap.put("000001100", R.drawable.nsdk_ic_lane_straight);
        rGLaneInfoModel.mImageMap.put("000001000", R.drawable.nsdk_ic_lane_straight_gray);
        rGLaneInfoModel.mImageMap.put("000000011", R.drawable.nsdk_ic_lane_turn_around_left);
        rGLaneInfoModel.mImageMap.put("000000010", R.drawable.nsdk_ic_lane_turn_around_left_gray);
        rGLaneInfoModel.mImageMap.put("010001000", R.drawable.nsdk_ic_lane_2cross_left_straight_gray);
        rGLaneInfoModel.mImageMap.put("011001000", R.drawable.nsdk_ic_lane_2cross_turn_left);
        rGLaneInfoModel.mImageMap.put("010001100", R.drawable.nsdk_ic_lane_2cross_left_straight);
        rGLaneInfoModel.mImageMap.put("011001100", R.drawable.nsdk_ic_lane_2cross_left_straight_bright);
        rGLaneInfoModel.mImageMap.put("000101000", R.drawable.nsdk_ic_lane_2cross_right_straight_gray);
        rGLaneInfoModel.mImageMap.put("000111000", R.drawable.nsdk_ic_lane_2cross_turn_right);
        rGLaneInfoModel.mImageMap.put("000101100", R.drawable.nsdk_ic_lane_2cross_right_straight);
        rGLaneInfoModel.mImageMap.put("000111100", R.drawable.nsdk_ic_lane_2cross_right_straight_bright);
        rGLaneInfoModel.mImageMap.put("010101000", R.drawable.nsdk_ic_lane_3cross_gray);
        rGLaneInfoModel.mImageMap.put("011101000", R.drawable.nsdk_ic_lane_3cross_turn_left);
        rGLaneInfoModel.mImageMap.put("010111000", R.drawable.nsdk_ic_lane_3cross_turn_right);
        rGLaneInfoModel.mImageMap.put("010101100", R.drawable.nsdk_ic_lane_3cross_straight);
        rGLaneInfoModel.mImageMap.put("011111100", R.drawable.nsdk_ic_lane_3cross_bright);
        rGLaneInfoModel.mImageMap.put("010000010", R.drawable.nsdk_ic_lane_around_and_left_gray);
        rGLaneInfoModel.mImageMap.put("011000010", R.drawable.nsdk_ic_lane_left_and_around);
        rGLaneInfoModel.mImageMap.put("010000011", R.drawable.nsdk_ic_lane_around_and_left);
        rGLaneInfoModel.mImageMap.put("011000011", R.drawable.nsdk_ic_lane_around_and_left_bright);
        rGLaneInfoModel.mImageMap.put("010100000", R.drawable.nsdk_ic_lane_left_and_right_gray);
        rGLaneInfoModel.mImageMap.put("011100000", R.drawable.nsdk_ic_lane_left_and_right);
        rGLaneInfoModel.mImageMap.put("010110000", R.drawable.nsdk_ic_lane_right_and_left);
        rGLaneInfoModel.mImageMap.put("011110000", R.drawable.nsdk_ic_lane_left_and_right_bright);
        rGLaneInfoModel.mImageMap.put("000100010", R.drawable.nsdk_ic_lane_around_and_right_gray);
        rGLaneInfoModel.mImageMap.put("000110010", R.drawable.nsdk_ic_lane_right_and_around);
        rGLaneInfoModel.mImageMap.put("000100011", R.drawable.nsdk_ic_lane_around_and_right);
        rGLaneInfoModel.mImageMap.put("000110011", R.drawable.nsdk_ic_lane_around_and_right_bright);
        rGLaneInfoModel.mImageMap.put("000001010", R.drawable.nsdk_ic_lane_around_and_straight_gray);
        rGLaneInfoModel.mImageMap.put("000001110", R.drawable.nsdk_ic_lane_straight_and_around);
        rGLaneInfoModel.mImageMap.put("000001011", R.drawable.nsdk_ic_lane_around_and_straight);
        rGLaneInfoModel.mImageMap.put("000001111", R.drawable.nsdk_ic_lane_around_and_straight_bright);
        rGLaneInfoModel.mImageMap.put("010100010", R.drawable.nsdk_ic_lane_around_left_right_gray);
        rGLaneInfoModel.mImageMap.put("011100010", R.drawable.nsdk_ic_lane_left_around_right);
        rGLaneInfoModel.mImageMap.put("010110010", R.drawable.nsdk_ic_lane_right_around_left);
        rGLaneInfoModel.mImageMap.put("010100011", R.drawable.nsdk_ic_lane_around_left_right);
        rGLaneInfoModel.mImageMap.put("011110011", R.drawable.nsdk_ic_lane_around_left_right_bright);
        rGLaneInfoModel.mImageMap.put("010001010", R.drawable.nsdk_ic_lane_around_left_straight_gray);
        rGLaneInfoModel.mImageMap.put("011001010", R.drawable.nsdk_ic_lane_left_around_straight);
        rGLaneInfoModel.mImageMap.put("010001110", R.drawable.nsdk_ic_lane_straight_left_around);
        rGLaneInfoModel.mImageMap.put("010001011", R.drawable.nsdk_ic_lane_around_left_straight);
        rGLaneInfoModel.mImageMap.put("011001111", R.drawable.nsdk_ic_lane_around_left_straight_bright);
        rGLaneInfoModel.mImageMap.put("000101010", R.drawable.nsdk_ic_lane_around_right_straight_gray);
        rGLaneInfoModel.mImageMap.put("000111010", R.drawable.nsdk_ic_lane_right_around_straight);
        rGLaneInfoModel.mImageMap.put("000101110", R.drawable.nsdk_ic_lane_straight_right_around);
        rGLaneInfoModel.mImageMap.put("000101011", R.drawable.nsdk_ic_lane_around_right_straight);
        rGLaneInfoModel.mImageMap.put("000111111", R.drawable.nsdk_ic_lane_around_right_straight_bright);
        rGLaneInfoModel.mImageMap.put("010101010", R.drawable.nsdk_ic_lane_around_left_right_straight_gray);
        rGLaneInfoModel.mImageMap.put("011101010", R.drawable.nsdk_ic_lane_left_around_right_straight);
        rGLaneInfoModel.mImageMap.put("010111010", R.drawable.nsdk_ic_lane_right_around_left_straight);
        rGLaneInfoModel.mImageMap.put("010101110", R.drawable.nsdk_ic_lane_straight_around_left_right);
        rGLaneInfoModel.mImageMap.put("010101011", R.drawable.nsdk_ic_lane_around_left_right_straight);
        rGLaneInfoModel.mImageMap.put("011111111", R.drawable.nsdk_ic_lane_around_left_right_straight_bright);
        rGLaneInfoModel.mImageMap.put("200001000", R.drawable.nsdk_ic_lane_bus_straight_gray);
        rGLaneInfoModel.mImageMap.put("100001100", R.drawable.nsdk_ic_lane_bus_front);
        rGLaneInfoModel.mImageMap.put("200000010", R.drawable.nsdk_ic_lane_bus_turn_around_left_gray);
        rGLaneInfoModel.mImageMap.put("100000011", R.drawable.nsdk_ic_lane_bus_back);
        rGLaneInfoModel.mImageMap.put("210000000", R.drawable.nsdk_ic_lane_bus_turn_left_90_gray);
        rGLaneInfoModel.mImageMap.put("111000000", R.drawable.nsdk_ic_lane_bus_left);
        rGLaneInfoModel.mImageMap.put("200100000", R.drawable.nsdk_ic_lane_bus_turn_right_90_gray);
        rGLaneInfoModel.mImageMap.put("100110000", R.drawable.nsdk_ic_lane_bus_right);
        rGLaneInfoModel.mImageMap.put("210001000", R.drawable.nsdk_ic_lane_bus_left_straight_gray);
        rGLaneInfoModel.mImageMap.put("111001100", R.drawable.nsdk_ic_lane_bus_2cross_left_straight_bright);
        rGLaneInfoModel.mImageMap.put("200101000", R.drawable.nsdk_ic_lane_bus_right_straight_gray);
        rGLaneInfoModel.mImageMap.put("100111100", R.drawable.nsdk_ic_lane_bus_2cross_right_straight_bright);
        rGLaneInfoModel.mImageMap.put("210101000", R.drawable.nsdk_ic_lane_bus_3cross_gray);
        rGLaneInfoModel.mImageMap.put("111111100", R.drawable.nsdk_ic_lane_bus_3cross_bright);
        rGLaneInfoModel.mImageMap.put("210000010", R.drawable.nsdk_ic_lane_bus_around_and_left_gray);
        rGLaneInfoModel.mImageMap.put("111000011", R.drawable.nsdk_ic_lane_bus_around_and_left_bright);
        rGLaneInfoModel.mImageMap.put("200100010", R.drawable.nsdk_ic_lane_bus_around_and_right_gray);
        rGLaneInfoModel.mImageMap.put("100110011", R.drawable.nsdk_ic_lane_bus_around_and_right_bright);
        rGLaneInfoModel.mImageMap.put("200001010", R.drawable.nsdk_ic_lane_bus_around_and_straight_gray);
        rGLaneInfoModel.mImageMap.put("100001111", R.drawable.nsdk_ic_lane_bus_around_and_straight_bright);
        rGLaneInfoModel.mImageMap.put("210100010", R.drawable.nsdk_ic_lane_bus_around_left_right_gray);
        rGLaneInfoModel.mImageMap.put("111110011", R.drawable.nsdk_ic_lane_bus_around_left_right_bright);
        rGLaneInfoModel.mImageMap.put("210001010", R.drawable.nsdk_ic_lane_bus_around_left_straight_gray);
        rGLaneInfoModel.mImageMap.put("111001111", R.drawable.nsdk_ic_lane_bus_around_left_straight_bright);
        rGLaneInfoModel.mImageMap.put("200101010", R.drawable.nsdk_ic_lane_bus_around_right_straight_gray);
        rGLaneInfoModel.mImageMap.put("100111111", R.drawable.nsdk_ic_lane_bus_around_right_straight_bright);
        rGLaneInfoModel.mImageMap.put("210100000", R.drawable.nsdk_ic_lane_bus_left_and_right_gray);
        rGLaneInfoModel.mImageMap.put("200001000", R.drawable.nsdk_ic_lane_bus_straight_gray);
        rGLaneInfoModel.mImageMap.put("200000010", R.drawable.nsdk_ic_lane_bus_turn_around_left_gray);
        rGLaneInfoModel.mImageMap.put("210000000", R.drawable.nsdk_ic_lane_bus_turn_left_90_gray);
        rGLaneInfoModel.mImageMap.put("200100000", R.drawable.nsdk_ic_lane_bus_turn_right_90_gray);
        rGLaneInfoModel.mImageMap.put("111110000", R.drawable.nsdk_ic_lane_bus_left_and_right_bright);
        rGLaneInfoModel.initImageNameMap();
    }

    public String parseItem(RGLineItem rGLineItem) {
        StringBuffer stringBuffer;
        if (rGLineItem == null) {
            return "0";
        }
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        int n5 = rGLineItem.isBusLaneBright && rGLineItem.isBusLine ? 1 : (rGLineItem.isBusLine && !rGLineItem.isBusLaneBright ? 2 : 0);
        StringBuffer stringBuffer3 = stringBuffer2;
        stringBuffer2.append(n5);
        stringBuffer2.append(rGLineItem.isLeft ? 1 : 0);
        stringBuffer2.append(rGLineItem.isLeftBright ? 1 : 0);
        stringBuffer2.append(rGLineItem.isRight ? 1 : 0);
        stringBuffer2.append(rGLineItem.isRightBright ? 1 : 0);
        stringBuffer2.append(rGLineItem.isFront ? 1 : 0);
        stringBuffer2.append(rGLineItem.isFrontBright ? 1 : 0);
        stringBuffer2.append(rGLineItem.isBack ? 1 : 0);
        stringBuffer3.append(rGLineItem.isBackBright ? 1 : 0);
        LogUtil.e(TAG, "parseItemToLong long is " + stringBuffer2.toString());
        return stringBuffer3.toString();
    }

    public String getImageNameFromItem(RGLineItem rGLineItem) {
        String string2 = this.parseSpecialLaneLineToString(rGLineItem);
        if (string2 != null) {
            return string2;
        }
        RGLaneInfoModel rGLaneInfoModel = this;
        return rGLaneInfoModel.getImageName(rGLaneInfoModel.parseItem(rGLineItem));
    }

    public int getImageIDFromItem(RGLineItem rGLineItem) {
        int n5 = this.parseSpecialLaneLine(rGLineItem);
        if (n5 > -1) {
            return n5;
        }
        RGLaneInfoModel rGLaneInfoModel = this;
        return rGLaneInfoModel.getImageID(rGLaneInfoModel.parseItem(rGLineItem));
    }

    public void cloneData(RGLineItem[] rGLineItemArray) {
        if (rGLineItemArray != null && rGLineItemArray.length > 0) {
            for (int i5 = 0; i5 < rGLineItemArray.length; ++i5) {
                this.mLaneLineList[i5] = rGLineItemArray[i5];
                LogUtil.e(TAG, "cloneData is " + this.mLaneLineList[i5].toString());
            }
            LogUtil.e(TAG, "cloneData size = " + this.mLaneLineList.length);
            return;
        }
    }

    public int getDriveHabbit() {
        RGLaneInfoModel rGLaneInfoModel = mInstance;
        if (rGLaneInfoModel != null) {
            return rGLaneInfoModel.mDriveHabbit;
        }
        return 0;
    }

    public String toString() {
        Object[] objectArray = new Object[5];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.mLineNumber;
        objectArray2[1] = this.mStartDist;
        objectArray2[2] = this.mID;
        objectArray2[3] = this.isLaneShow;
        objectArray[4] = this.needDisplay;
        return String.format("[%d,%d,%d,%b,%d]", objectArray2);
    }

    public boolean isNeedDisplay(int n5) {
        if (i.c.d()) {
            i.c.e(TAG, "isNeedDisplay: " + n5);
        }
        return (this.needDisplay & n5) == n5;
    }
}

