/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.baidu.navisdk.util.common.LogUtil;
import com.baidu.navisdk.util.common.ScreenUtil;

public abstract class BNBaseFloatView {
    private static final String TAG = "BNBaseFloatView";
    private View mFloatLayout;
    private WindowManager.LayoutParams wmParams;
    private WindowManager mWindowManager;
    private int mTouchSlop;
    private float mXInFloatView;
    private float mYInFloatView;
    private float mXInScreen;
    private float mYInScreen;
    private boolean isShowing;
    private Context mContext;
    private Activity mActivity;
    private float mDownX;
    private float mDownY;
    private boolean isMoved;

    public BNBaseFloatView(Activity activity) {
        BNBaseFloatView bNBaseFloatView = this;
        this.isShowing = false;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.isMoved = false;
        this.mActivity = activity;
        bNBaseFloatView.mContext = activity.getApplicationContext();
        bNBaseFloatView.initWindowsManger();
        bNBaseFloatView.intParams();
        bNBaseFloatView.mFloatLayout = bNBaseFloatView.initViews();
    }

    private void initWindowsManger() {
        int n5;
        this.wmParams = new WindowManager.LayoutParams();
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        this.wmParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : (Build.MANUFACTURER.equalsIgnoreCase("xiaomi") && Build.VERSION.SDK_INT >= 24 ? 2002 : ((n5 = Build.VERSION.SDK_INT) >= 25 ? 2002 : (n5 >= 19 ? 2005 : 2002)));
        BNBaseFloatView bNBaseFloatView = this;
        WindowManager.LayoutParams layoutParams = bNBaseFloatView.wmParams;
        layoutParams.format = 1;
        layoutParams.flags = 8;
        layoutParams.gravity = 51;
        layoutParams.x = ScreenUtil.getInstance().dip2px(25);
        WindowManager.LayoutParams layoutParams2 = bNBaseFloatView.wmParams;
        layoutParams2.y = 0;
        layoutParams2.width = ScreenUtil.getInstance().dip2px(300);
        bNBaseFloatView.wmParams.height = ScreenUtil.getInstance().dip2px(200);
    }

    private void intParams() {
        this.mTouchSlop = ScreenUtil.getInstance().dip2px(4);
    }

    private boolean handleMotionEvent(MotionEvent motionEvent) {
        int n5 = motionEvent.getAction();
        if (n5 != 0) {
            if (n5 != 1) {
                if (n5 != 2) {
                    return false;
                }
                this.mXInScreen = motionEvent.getRawX();
                this.mYInScreen = motionEvent.getRawY() - (float)ScreenUtil.getInstance().getStatusBarHeight(this.mActivity);
                if (Math.abs(this.mDownX - motionEvent.getRawX()) > (float)this.mTouchSlop || Math.abs(this.mDownY - motionEvent.getRawY()) > (float)this.mTouchSlop) {
                    this.isMoved = true;
                }
                this.updateViewPosition();
                return false;
            }
            BNBaseFloatView bNBaseFloatView = this;
            bNBaseFloatView.updateViewPosition();
            return bNBaseFloatView.isMoved;
        }
        BNBaseFloatView bNBaseFloatView = this;
        this.mXInFloatView = motionEvent.getX();
        this.mYInFloatView = motionEvent.getY();
        this.mDownX = motionEvent.getRawX();
        bNBaseFloatView.mDownY = motionEvent.getRawY();
        bNBaseFloatView.isMoved = false;
        return false;
    }

    private void updateViewPosition() {
        BNBaseFloatView bNBaseFloatView = this;
        WindowManager.LayoutParams layoutParams = bNBaseFloatView.wmParams;
        layoutParams.x = (int)(this.mXInScreen - this.mXInFloatView);
        bNBaseFloatView.wmParams.y = (int)(this.mYInScreen - this.mYInFloatView);
        try {
            bNBaseFloatView.mWindowManager.updateViewLayout(this.mFloatLayout, (ViewGroup.LayoutParams)layoutParams);
        }
        catch (Exception exception) {}
    }

    public abstract View initViews();

    public Context getContext() {
        return this.mContext;
    }

    public View getFloatView() {
        return this.mFloatLayout;
    }

    public boolean show() {
        View view;
        BNBaseFloatView bNBaseFloatView;
        WindowManager windowManager;
        LogUtil.e(TAG, "show :" + this.isShow());
        if (this.isShow()) {
            return true;
        }
        try {
            BNBaseFloatView bNBaseFloatView2 = this;
            BNBaseFloatView bNBaseFloatView3 = bNBaseFloatView2;
            bNBaseFloatView2.mFloatLayout.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    return BNBaseFloatView.this.handleMotionEvent(motionEvent);
                }
            });
            windowManager = bNBaseFloatView2.mWindowManager;
            BNBaseFloatView bNBaseFloatView4 = this;
            bNBaseFloatView = bNBaseFloatView4;
            view = bNBaseFloatView4.mFloatLayout;
        }
        catch (Exception exception) {
            LogUtil.e(TAG, "float excetion e:" + exception.getMessage());
            this.isShowing = false;
            return false;
        }
        windowManager.addView(view, (ViewGroup.LayoutParams)bNBaseFloatView.wmParams);
        bNBaseFloatView3.isShowing = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void hide() {
        LogUtil.e(TAG, "hide");
        try {
            if (this.mFloatLayout != null && this.mFloatLayout.getParent() != null) {
                this.mWindowManager.removeView(this.mFloatLayout);
            }
            this.isShowing = false;
            return;
        }
        catch (Exception exception) {
            LogUtil.e(TAG, "hide float excetion e:" + exception.getMessage());
        }
    }

    public boolean isShow() {
        return this.isShowing;
    }

    public void dispose() {
        this.isShowing = false;
        View view = this.mFloatLayout;
        if (view != null) {
            this.mWindowManager.removeView(view);
        }
    }
}

