/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;

public class BNBaseShadowDrawable
extends Drawable {
    public static final int SHAPE_ROUND = 1;
    public static final int SHAPE_CIRCLE = 2;
    private Paint mShadowPaint;
    private Paint mBgPaint;
    private int mShadowRadius;
    private int mShape;
    private int mShapeRadius;
    private int mOffsetX;
    private int mOffsetY;
    private int mOffsetLeft;
    private int mOffsetRight;
    private int mOffsetTop;
    private int mOffsetBottom;
    private int[] mBgColor;
    private int mShadowColor;
    private RectF mRect;

    public BNBaseShadowDrawable(int n5, int[] nArray, int n6, int n7, int n8, int n9, int n10) {
        BNBaseShadowDrawable bNBaseShadowDrawable = this;
        this.mShape = n5;
        this.mBgColor = nArray;
        this.mShapeRadius = n6;
        this.mShadowRadius = n8;
        this.mShadowColor = n7;
        this.mOffsetX = n9;
        this.mOffsetY = n10;
        this.mOffsetLeft = n9;
        this.mOffsetRight = n9;
        this.mOffsetTop = n10;
        bNBaseShadowDrawable.mOffsetBottom = n10;
        this.mShadowPaint = new Paint();
        this.mShadowPaint.setColor(0);
        bNBaseShadowDrawable.mShadowPaint.setAntiAlias(true);
        float f6 = n8;
        float f7 = n9;
        float f8 = n10;
        bNBaseShadowDrawable.mShadowPaint.setShadowLayer(f6, f7, f8, n7);
        bNBaseShadowDrawable.mShadowPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
        this.mBgPaint = new Paint();
        this.mBgPaint.setAntiAlias(true);
    }

    public BNBaseShadowDrawable(int n5, int[] nArray, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        BNBaseShadowDrawable bNBaseShadowDrawable = this;
        this.mShape = n5;
        this.mBgColor = nArray;
        this.mShapeRadius = n6;
        this.mShadowRadius = n8;
        this.mShadowColor = n7;
        this.mOffsetLeft = n9;
        this.mOffsetRight = n10;
        this.mOffsetTop = n11;
        bNBaseShadowDrawable.mOffsetBottom = n12;
        this.mShadowPaint = new Paint();
        this.mShadowPaint.setColor(0);
        bNBaseShadowDrawable.mShadowPaint.setAntiAlias(true);
        BNBaseShadowDrawable bNBaseShadowDrawable2 = this;
        float f6 = bNBaseShadowDrawable2.mOffsetLeft;
        bNBaseShadowDrawable.mShadowPaint.setShadowLayer((float)n8, f6, (float)bNBaseShadowDrawable2.mOffsetTop, n7);
        bNBaseShadowDrawable.mShadowPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
        this.mBgPaint = new Paint();
        this.mBgPaint.setAntiAlias(true);
    }

    public static void setShadowDrawable(View view, Drawable drawable2) {
        if (view != null && drawable2 != null) {
            View view2 = view;
            view2.setLayerType(1, null);
            ViewCompat.setBackground((View)view2, (Drawable)drawable2);
            return;
        }
    }

    public static void setShadowDrawable(View object, int n5, int n6, int n7, int n8, int n9) {
        View view = object;
        object = new Builder().setShapeRadius(n5).setShadowColor(n6).setShadowRadius(n7).setOffsetX(n8).setOffsetY(n9).builder();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)object);
    }

    public static void setShadowDrawable(View object, int n5, int n6, int n7, int n8, int n9, int n10) {
        View view = object;
        object = new Builder().setBgColor(n5).setShapeRadius(n6).setShadowColor(n7).setShadowRadius(n8).setOffsetX(n9).setOffsetY(n10).builder();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)object);
    }

    public static void setShadowDrawable(View object, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        View view = object;
        object = new Builder().setShape(n5).setBgColor(n6).setShapeRadius(n7).setShadowColor(n8).setShadowRadius(n9).setOffsetLeft(n10).setOffsetRight(n11).setOffsetTop(n12).setOffsetBottom(n13).builderOffset();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)object);
    }

    public static void setShadowDrawable(View object, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        View view = object;
        object = new Builder().setShape(n5).setBgColor(n6).setShapeRadius(n7).setShadowColor(n8).setShadowRadius(n9).setOffsetX(n10).setOffsetY(n11).builder();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)object);
    }

    public static void setShadowDrawable(View object, int[] nArray, int n5, int n6, int n7, int n8, int n9) {
        View view = object;
        object = new Builder().setBgColor(nArray).setShapeRadius(n5).setShadowColor(n6).setShadowRadius(n7).setOffsetX(n8).setOffsetY(n9).builder();
        view.setLayerType(1, null);
        ViewCompat.setBackground((View)view, (Drawable)object);
    }

    public void draw(@NonNull Canvas canvas) {
        float f6;
        Object object = bNBaseShadowDrawable3.mBgColor;
        if (bNBaseShadowDrawable3.mBgColor != null) {
            if (((int[])object).length == 1) {
                bNBaseShadowDrawable3.mBgPaint.setColor(object[0]);
            } else {
                BNBaseShadowDrawable bNBaseShadowDrawable = bNBaseShadowDrawable3;
                RectF rectF = bNBaseShadowDrawable.mRect;
                float f7 = rectF.left;
                f6 = rectF.height() / 2.0f;
                RectF rectF2 = bNBaseShadowDrawable.mRect;
                float f8 = rectF2.right;
                float f9 = rectF2.height() / 2.0f;
                int[] nArray = bNBaseShadowDrawable.mBgColor;
                object = Shader.TileMode.CLAMP;
                bNBaseShadowDrawable3.mBgPaint.setShader((Shader)new LinearGradient(f7, f6, f8, f9, nArray, null, (Shader.TileMode)object));
            }
        }
        if (bNBaseShadowDrawable3.mShape == 1) {
            BNBaseShadowDrawable bNBaseShadowDrawable = bNBaseShadowDrawable3;
            BNBaseShadowDrawable bNBaseShadowDrawable2 = bNBaseShadowDrawable3;
            BNBaseShadowDrawable bNBaseShadowDrawable3 = bNBaseShadowDrawable2.mRect;
            int n5 = bNBaseShadowDrawable2.mShapeRadius;
            float f10 = n5;
            float f11 = n5;
            Paint paint = bNBaseShadowDrawable2.mShadowPaint;
            canvas.drawRoundRect((RectF)bNBaseShadowDrawable3, f10, f11, paint);
            bNBaseShadowDrawable3 = bNBaseShadowDrawable.mRect;
            int n6 = bNBaseShadowDrawable.mShapeRadius;
            f10 = n6;
            f11 = n6;
            paint = bNBaseShadowDrawable.mBgPaint;
            canvas.drawRoundRect((RectF)bNBaseShadowDrawable3, f10, f11, paint);
        } else {
            BNBaseShadowDrawable bNBaseShadowDrawable = bNBaseShadowDrawable3;
            BNBaseShadowDrawable bNBaseShadowDrawable4 = bNBaseShadowDrawable3;
            float f12 = bNBaseShadowDrawable4.mRect.centerX();
            float f13 = bNBaseShadowDrawable4.mRect.centerY();
            f6 = Math.min(bNBaseShadowDrawable4.mRect.width(), bNBaseShadowDrawable3.mRect.height()) / 2.0f;
            Paint paint = bNBaseShadowDrawable4.mShadowPaint;
            canvas.drawCircle(f12, f13, f6, paint);
            f12 = bNBaseShadowDrawable.mRect.centerX();
            f13 = bNBaseShadowDrawable.mRect.centerY();
            float f14 = Math.min(bNBaseShadowDrawable.mRect.width(), bNBaseShadowDrawable3.mRect.height()) / 2.0f;
            Paint paint2 = bNBaseShadowDrawable.mBgPaint;
            canvas.drawCircle(f12, f13, f14, paint2);
        }
    }

    public void setAlpha(int n5) {
        this.mShadowPaint.setAlpha(n5);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mShadowPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public void setBounds(int n5, int n6, int n7, int n8) {
        super.setBounds(n5, n6, n7, n8);
        int n9 = n5;
        n5 = this.mShadowRadius;
        float f6 = n9 + n5 - this.mOffsetLeft;
        float f7 = n6 + n5 - this.mOffsetTop;
        float f8 = n7 - n5 - this.mOffsetRight;
        float f9 = n8 - n5 - this.mOffsetBottom;
        this.mRect = new RectF(f6, f7, f8, f9);
    }

    public static class Builder {
        private int mShape = 1;
        private int mShapeRadius = 12;
        private int mShadowColor = Color.parseColor((String)"#4d000000");
        private int mShadowRadius = 18;
        private int mOffsetX = 0;
        private int mOffsetY = 0;
        private int mOffsetLeft = 0;
        private int mOffsetRight = 0;
        private int mOffsetTop = 0;
        private int mOffsetBottom = 0;
        private int[] mBgColor;

        public Builder() {
            int[] nArray = new int[1];
            this.mBgColor = nArray;
            nArray[0] = 0;
        }

        public Builder setShape(int n5) {
            this.mShape = n5;
            return this;
        }

        public Builder setShapeRadius(int n5) {
            this.mShapeRadius = n5;
            return this;
        }

        public Builder setShadowColor(int n5) {
            this.mShadowColor = n5;
            return this;
        }

        public Builder setShadowRadius(int n5) {
            this.mShadowRadius = n5;
            return this;
        }

        public Builder setOffsetX(int n5) {
            this.mOffsetX = n5;
            return this;
        }

        public Builder setOffsetY(int n5) {
            this.mOffsetY = n5;
            return this;
        }

        public Builder setOffsetLeft(int n5) {
            this.mOffsetLeft = n5;
            return this;
        }

        public Builder setOffsetRight(int n5) {
            this.mOffsetRight = n5;
            return this;
        }

        public Builder setOffsetTop(int n5) {
            this.mOffsetTop = n5;
            return this;
        }

        public Builder setOffsetBottom(int n5) {
            this.mOffsetBottom = n5;
            return this;
        }

        public Builder setBgColor(int n5) {
            Builder builder = this;
            builder.mBgColor[0] = n5;
            return builder;
        }

        public Builder setBgColor(int[] nArray) {
            this.mBgColor = nArray;
            return this;
        }

        public BNBaseShadowDrawable builder() {
            Builder builder = this;
            int n5 = builder.mShape;
            int[] nArray = builder.mBgColor;
            int n6 = builder.mShapeRadius;
            int n7 = builder.mShadowColor;
            int n8 = builder.mShadowRadius;
            int n9 = builder.mOffsetX;
            int n10 = builder.mOffsetY;
            return new BNBaseShadowDrawable(n5, nArray, n6, n7, n8, n9, n10);
        }

        public BNBaseShadowDrawable builderOffset() {
            Builder builder = this;
            int n5 = builder.mShape;
            int[] nArray = builder.mBgColor;
            int n6 = builder.mShapeRadius;
            int n7 = builder.mShadowColor;
            int n8 = builder.mShadowRadius;
            int n9 = builder.mOffsetLeft;
            int n10 = builder.mOffsetRight;
            int n11 = builder.mOffsetTop;
            int n12 = builder.mOffsetBottom;
            return new BNBaseShadowDrawable(n5, nArray, n6, n7, n8, n9, n10, n11, n12);
        }
    }
}

