/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.FrameLayout;
import com.baidu.mapframework.braavos.BraavosConfiguration;
import com.baidu.mapframework.braavos.BraavosContext;
import com.baidu.mapframework.braavos.BraavosContextImpl;
import com.baidu.mapframework.braavos.BraavosWebView;
import com.baidu.mapframework.braavos.BraavosWebViewCore;
import com.baidu.mapframework.braavos.BraavosWebViewImpl;
import com.baidu.mapframework.braavos.CallbackContext;
import com.baidu.mapframework.braavos.ConfigXmlParser;
import com.baidu.mapframework.braavos.ModuleEntry;
import com.baidu.mapframework.braavos.core.DefaultWebView;
import com.baidu.mapframework.braavos.core.NestedScrollWebView;
import com.baidu.mapframework.braavos.event.IMessageBinder;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BNBraavosView
extends FrameLayout
implements IMessageBinder {
    public static final String TAG = "BNBraavosView";
    private static ExecutorService sExecutorService;
    public String launchUrl;
    protected BraavosWebView appView;
    protected boolean keepRunning;
    protected BraavosConfiguration preferences;
    protected ArrayList<ModuleEntry> pluginEntries;
    protected BraavosContextImpl braavosContext;
    protected boolean isCreated;
    private int scrollOffset;
    private int touchOffset;

    public BNBraavosView(Context context) {
        BNBraavosView bNBraavosView = this;
        super(context);
        bNBraavosView.keepRunning = true;
        bNBraavosView.onCreateView();
    }

    public BNBraavosView(Context context, AttributeSet attributeSet) {
        BNBraavosView bNBraavosView = this;
        super(context, attributeSet);
        bNBraavosView.keepRunning = true;
        bNBraavosView.onCreateView();
    }

    public BNBraavosView(Context context, AttributeSet attributeSet, int n5) {
        BNBraavosView bNBraavosView = this;
        super(context, attributeSet, n5);
        bNBraavosView.keepRunning = true;
        bNBraavosView.onCreateView();
    }

    @TargetApi(value=21)
    public BNBraavosView(Context context, AttributeSet attributeSet, int n5, int n6) {
        BNBraavosView bNBraavosView = this;
        super(context, attributeSet, n5, n6);
        bNBraavosView.keepRunning = true;
        bNBraavosView.onCreateView();
    }

    static {
        ThreadFactory threadFactory;
        SynchronousQueue<Runnable> synchronousQueue;
        TimeUnit timeUnit = TimeUnit.SECONDS;
        SynchronousQueue<Runnable> synchronousQueue2 = synchronousQueue;
        synchronousQueue = new SynchronousQueue<Runnable>();
        ThreadFactory threadFactory2 = threadFactory;
        threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, BNBraavosView.TAG);
            }
        };
        sExecutorService = new ThreadPoolExecutor(0, 128, 5L, timeUnit, synchronousQueue2, threadFactory2);
    }

    public void setScrollValue(int n5, int n6, int n7) {
        this.scrollOffset = n6 - n5 + n7;
        this.touchOffset = n5;
    }

    public void onCreateView() {
        if (!this.isCreated || this.appView == null) {
            BNBraavosView bNBraavosView = this;
            bNBraavosView.isCreated = true;
            bNBraavosView.loadConfig((Activity)bNBraavosView.getContext());
            bNBraavosView.braavosContext = bNBraavosView.makeBraavosContext();
            bNBraavosView.init();
        }
        BNBraavosView bNBraavosView = this;
        bNBraavosView.addView(bNBraavosView.appView.getView());
    }

    protected void init() {
        BNBraavosView bNBraavosView = this;
        bNBraavosView.appView = bNBraavosView.makeWebView();
        bNBraavosView.createViews();
        if (!bNBraavosView.appView.isInitialized()) {
            BNBraavosView bNBraavosView2 = this;
            BraavosContextImpl braavosContextImpl = bNBraavosView2.braavosContext;
            ArrayList<ModuleEntry> arrayList = bNBraavosView2.pluginEntries;
            BraavosConfiguration braavosConfiguration = bNBraavosView2.preferences;
            this.appView.init((BraavosContext)braavosContextImpl, arrayList, braavosConfiguration);
        }
        BNBraavosView bNBraavosView3 = this;
        bNBraavosView3.appView.setBinder((IMessageBinder)this);
        bNBraavosView3.braavosContext.onBraavosInit(this.appView.getModuleManager());
        if (bNBraavosView3.appView.getView() instanceof DefaultWebView && ((DefaultWebView)this.appView.getView()).getSettings() != null) {
            ((DefaultWebView)this.appView.getView()).getSettings().setTextZoom(100);
        }
    }

    protected void loadConfig(Activity activity) {
        ConfigXmlParser configXmlParser;
        BNBraavosView bNBraavosView = bNBraavosView2;
        BNBraavosView bNBraavosView2 = configXmlParser;
        bNBraavosView2();
        configXmlParser.parse((Context)activity);
        bNBraavosView.preferences = configXmlParser.getPreferences();
        bNBraavosView.launchUrl = bNBraavosView2.getLaunchUrl();
        bNBraavosView.pluginEntries = bNBraavosView2.getPluginEntries();
    }

    protected View createViews() {
        BNBraavosView bNBraavosView = this;
        bNBraavosView.appView.getView().setId(100);
        bNBraavosView.appView.getView().requestFocusFromTouch();
        bNBraavosView.appView.getView().setOverScrollMode(2);
        return bNBraavosView.appView.getView();
    }

    public DefaultWebView getWebView() {
        BNBraavosView bNBraavosView = bNBraavosView.appView;
        if (bNBraavosView != null) {
            return (DefaultWebView)bNBraavosView.getView();
        }
        return null;
    }

    protected BraavosWebView makeWebView() {
        return new BraavosWebViewImpl(this.makeWebViewCore());
    }

    protected BraavosWebViewCore makeWebViewCore() {
        return BraavosWebViewImpl.createWebViewCore((DefaultWebView)new NestedScrollWebView(this.getContext()), (BraavosConfiguration)this.preferences);
    }

    protected BraavosContextImpl makeBraavosContext() {
        BNBraavosView bNBraavosView = this;
        return new BraavosContextImpl((Activity)bNBraavosView.getContext(), sExecutorService){

            public Object onMessage(String string2, Object object) {
                return BNBraavosView.this.onMessage(string2, object);
            }
        };
    }

    public void loadUrl(String string2) {
        if (bNBraavosView2.appView == null && !bNBraavosView2.isCreated) {
            bNBraavosView2.init();
        }
        BNBraavosView bNBraavosView = bNBraavosView2;
        bNBraavosView.keepRunning = bNBraavosView.preferences.getBoolean("KeepRunning", true);
        BNBraavosView bNBraavosView2 = bNBraavosView.appView;
        if (bNBraavosView2 != null) {
            bNBraavosView2.loadUrlIntoView(string2, true);
        }
    }

    public void onPause() {
        BraavosWebView braavosWebView;
        Log.d((String)TAG, (String)"Paused the activity.");
        if (this.getWebView() != null) {
            this.getWebView().setOnPause();
        }
        if ((braavosWebView = this.appView) != null) {
            braavosWebView.handlePause(this.keepRunning);
        }
    }

    public void onResume() {
        Log.d((String)TAG, (String)"Resumed the activity.");
        if (this.appView == null) {
            return;
        }
        if (this.getWebView() != null) {
            this.getWebView().setOnResume();
        }
        this.appView.handleResume(this.keepRunning);
    }

    public void onStop() {
        Log.d((String)TAG, (String)"Stopped the activity.");
        BNBraavosView bNBraavosView = bNBraavosView.appView;
        if (bNBraavosView == null) {
            return;
        }
        bNBraavosView.handleStop();
    }

    public void onStart() {
        Log.d((String)TAG, (String)"Started the activity.");
        BNBraavosView bNBraavosView = bNBraavosView.appView;
        if (bNBraavosView == null) {
            return;
        }
        bNBraavosView.handleStart();
    }

    public void updateOffset() {
        if (this.getWebView() != null) {
            BNBraavosView bNBraavosView = this;
            int n5 = bNBraavosView.scrollOffset;
            this.getWebView().setScrollOffset(n5, bNBraavosView.touchOffset);
        }
    }

    public void onReceivedError(int n5, String string2, String string3) {
    }

    public void notifyJSRuntime(String string2, JSONObject jSONObject) {
        block7: {
            JSONObject jSONObject2;
            try {
                if (this.getWebView() == null) break block7;
            }
            catch (Exception exception) {}
            JSONObject jSONObject3 = jSONObject;
            JSONObject jSONObject4 = jSONObject2;
            new JSONObject().put("event", (Object)string2);
            if (jSONObject3 != null) {
                jSONObject4.put("params", (Object)jSONObject);
            }
            this.getWebView().evaluateJavascript("(function(){BMAP_CWN(" + jSONObject4.toString() + ");})();", null);
        }
    }

    public Object onMessage(String string2, Object object) {
        if ("onReceivedError".equals(string2)) {
            JSONObject jSONObject = (JSONObject)object;
            JSONObject jSONObject2 = jSONObject;
            JSONObject jSONObject3 = jSONObject;
            int n5 = jSONObject.getInt("errorCode");
            string2 = jSONObject3.getString("description");
            object = jSONObject2.getString("url");
            try {
                this.onReceivedError(n5, string2, (String)object);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return null;
    }

    public void onConfigurationChanged(Configuration configuration) {
        BNBraavosView bNBraavosView = bNBraavosView2;
        super.onConfigurationChanged(configuration);
        BNBraavosView bNBraavosView2 = bNBraavosView.appView;
        if (bNBraavosView2 == null) {
            return;
        }
        if ((bNBraavosView2 = bNBraavosView2.getModuleManager()) != null) {
            bNBraavosView2.onConfigurationChanged(configuration);
        }
    }

    public void onRequestPermissionsResult(int n5, String[] stringArray, int[] nArray) {
        try {
            this.braavosContext.onRequestPermissionResult(n5, stringArray, nArray);
        }
        catch (JSONException jSONException) {
            Log.d((String)TAG, (String)"JSONException: Parameters fed into the method are not valid");
            jSONException.printStackTrace();
        }
    }

    public void onActivityResult(int n5, int n6, Intent intent) {
        try {
            this.braavosContext.onActivityResult(n5, n6, intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean onBackPressed() {
        BraavosWebView braavosWebView = this.appView;
        if (braavosWebView != null && braavosWebView.canGoBack()) {
            return this.appView.backHistory();
        }
        return false;
    }

    public void scrollTo(int n5, int n6) {
        BraavosWebView braavosWebView = this.appView;
        if (braavosWebView != null && braavosWebView.getView() != null) {
            this.appView.getView().scrollTo(n5, n6);
        }
    }

    public void resetScrollPos() {
        if (this.getWebView() != null && this.getWebView().getScrollY() != 0) {
            BNBraavosView bNBraavosView = this;
            bNBraavosView.getWebView().stopNestedScroll();
            bNBraavosView.getWebView().flingScroll(0, 0);
            bNBraavosView.getWebView().scrollTo(0, 0);
        }
    }

    public void dispatchMessage(String string2, JSONArray jSONArray, CallbackContext callbackContext) {
    }

    public void destroy() {
        BraavosWebView braavosWebView = this.appView;
        if (braavosWebView != null) {
            BNBraavosView bNBraavosView = this;
            braavosWebView.handleDestroy();
            bNBraavosView.isCreated = false;
            bNBraavosView.appView = null;
        }
    }
}

