/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class BNEllipsizingTextView
extends TextView {
    private static final CharSequence ELLIPSIS = "\u2026";
    private static final Pattern DEFAULT_END_PUNCTUATION = Pattern.compile("[\\.!?,;:\u2026]*$", 32);
    private final List<EllipsizeListener> mEllipsizeListeners;
    private EllipsizeStrategy mEllipsizeStrategy;
    private boolean isEllipsized;
    private boolean isStale;
    private boolean programmaticChange;
    private CharSequence mFullText;
    private int mMaxLines;
    private float mLineSpacingMult;
    private float mLineAddVertPad;
    private Pattern mEndPunctPattern;

    public BNEllipsizingTextView(Context context) {
        this(context, null);
    }

    public BNEllipsizingTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    public BNEllipsizingTextView(Context object, AttributeSet attributeSet, int n5) {
        Context context = object;
        super(object, attributeSet, n5);
        this.mEllipsizeListeners = new ArrayList<EllipsizeListener>();
        this.mLineSpacingMult = 1.0f;
        this.mLineAddVertPad = 0.0f;
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = 16843091;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, (int[])object, n5, 0);
        this.setMaxLines(typedArray.getInt(0, Integer.MAX_VALUE));
        typedArray.recycle();
        this.setEndPunctuationPattern(DEFAULT_END_PUNCTUATION);
    }

    private void resetText() {
        CharSequence charSequence = ((BNEllipsizingTextView)((Object)iterator)).mFullText;
        boolean bl = false;
        if (((BNEllipsizingTextView)((Object)iterator)).getMaxLines() != -1) {
            if (((BNEllipsizingTextView)((Object)iterator)).mEllipsizeStrategy == null) {
                ((BNEllipsizingTextView)((Object)iterator)).setEllipsize(null);
            }
            BNEllipsizingTextView bNEllipsizingTextView = iterator;
            charSequence = bNEllipsizingTextView.mEllipsizeStrategy.processText(((BNEllipsizingTextView)((Object)iterator)).mFullText);
            bl = bNEllipsizingTextView.mEllipsizeStrategy.isInLayout(((BNEllipsizingTextView)((Object)iterator)).mFullText) ^ true;
        }
        if (!charSequence.equals(iterator.getText())) {
            ((BNEllipsizingTextView)((Object)iterator)).programmaticChange = true;
            try {
                iterator.setText(charSequence);
                ((BNEllipsizingTextView)((Object)iterator)).programmaticChange = false;
            }
            catch (Throwable throwable) {
                ((BNEllipsizingTextView)((Object)iterator)).programmaticChange = false;
                throw throwable;
            }
        }
        ((BNEllipsizingTextView)((Object)iterator)).isStale = false;
        if (bl != ((BNEllipsizingTextView)((Object)iterator)).isEllipsized) {
            ((BNEllipsizingTextView)((Object)iterator)).isEllipsized = bl;
            Iterator<EllipsizeListener> iterator = ((BNEllipsizingTextView)((Object)iterator)).mEllipsizeListeners.iterator();
            while (iterator.hasNext()) {
                ((EllipsizeListener)iterator.next()).ellipsizeStateChanged(bl);
            }
        }
    }

    public void setEndPunctuationPattern(Pattern pattern) {
        this.mEndPunctPattern = pattern;
    }

    public void addEllipsizeListener(EllipsizeListener ellipsizeListener) {
        this.mEllipsizeListeners.add(ellipsizeListener);
    }

    public void removeEllipsizeListener(EllipsizeListener ellipsizeListener) {
        this.mEllipsizeListeners.remove(ellipsizeListener);
    }

    public boolean isEllipsized() {
        return this.isEllipsized;
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public void setMaxLines(int n5) {
        super.setMaxLines(n5);
        this.mMaxLines = n5;
        this.isStale = true;
    }

    public boolean ellipsizingLastFullyVisibleLine() {
        return this.mMaxLines == Integer.MAX_VALUE;
    }

    public void setLineSpacing(float f6, float f7) {
        this.mLineAddVertPad = f6;
        this.mLineSpacingMult = f7;
        super.setLineSpacing(f6, f7);
    }

    public void setText(CharSequence charSequence, TextView.BufferType bufferType) {
        if (!this.programmaticChange) {
            BNEllipsizingTextView bNEllipsizingTextView = this;
            bNEllipsizingTextView.mFullText = charSequence;
            bNEllipsizingTextView.isStale = true;
        }
        super.setText(charSequence, bufferType);
    }

    protected void onSizeChanged(int n5, int n6, int n7, int n8) {
        BNEllipsizingTextView bNEllipsizingTextView = this;
        super.onSizeChanged(n5, n6, n7, n8);
        if (bNEllipsizingTextView.ellipsizingLastFullyVisibleLine()) {
            this.isStale = true;
        }
    }

    public void setPadding(int n5, int n6, int n7, int n8) {
        BNEllipsizingTextView bNEllipsizingTextView = this;
        super.setPadding(n5, n6, n7, n8);
        if (bNEllipsizingTextView.ellipsizingLastFullyVisibleLine()) {
            this.isStale = true;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.isStale) {
            this.resetText();
        }
        super.onDraw(canvas);
    }

    public void setEllipsize(TextUtils.TruncateAt object) {
        if (object == null) {
            EllipsizeNoneStrategy ellipsizeNoneStrategy;
            object = ellipsizeNoneStrategy;
            ellipsizeNoneStrategy = new EllipsizeNoneStrategy();
            this.mEllipsizeStrategy = object;
            return;
        }
        switch (1.$SwitchMap$android$text$TextUtils$TruncateAt[object.ordinal()]) {
            default: {
                EllipsizeNoneStrategy ellipsizeNoneStrategy;
                object = ellipsizeNoneStrategy;
                ellipsizeNoneStrategy = new EllipsizeNoneStrategy();
                this.mEllipsizeStrategy = object;
                break;
            }
            case 4: {
                EllipsizeNoneStrategy ellipsizeNoneStrategy;
                super.setEllipsize(object);
                this.isStale = false;
                object = ellipsizeNoneStrategy;
                ellipsizeNoneStrategy = new EllipsizeNoneStrategy();
                this.mEllipsizeStrategy = object;
                break;
            }
            case 3: {
                EllipsizeMiddleStrategy ellipsizeMiddleStrategy;
                object = ellipsizeMiddleStrategy;
                ellipsizeMiddleStrategy = new EllipsizeMiddleStrategy();
                this.mEllipsizeStrategy = object;
                break;
            }
            case 2: {
                EllipsizeStartStrategy ellipsizeStartStrategy;
                object = ellipsizeStartStrategy;
                ellipsizeStartStrategy = new EllipsizeStartStrategy();
                this.mEllipsizeStrategy = object;
                break;
            }
            case 1: {
                EllipsizeEndStrategy ellipsizeEndStrategy;
                object = ellipsizeEndStrategy;
                ellipsizeEndStrategy = new EllipsizeEndStrategy();
                this.mEllipsizeStrategy = object;
            }
        }
    }

    private class EllipsizeMiddleStrategy
    extends EllipsizeStrategy {
        private EllipsizeMiddleStrategy() {
        }

        @Override
        protected CharSequence createEllipsizedText(CharSequence charSequence) {
            SpannableStringBuilder spannableStringBuilder;
            SpannableStringBuilder spannableStringBuilder2;
            int n5 = ellipsizeMiddleStrategy.createWorkingLayout(charSequence).getLineEnd(ellipsizeMiddleStrategy.BNEllipsizingTextView.this.mMaxLines - 1);
            int n6 = charSequence.length();
            int n7 = n6 - n5;
            if (n7 < ELLIPSIS.length()) {
                n7 = ELLIPSIS.length();
            }
            n5 = n7 + n5 % 2;
            int n8 = n6 / 2;
            String string2 = TextUtils.substring((CharSequence)charSequence, (int)0, (int)(n8 - (n5 /= 2)));
            String string3 = TextUtils.substring((CharSequence)charSequence, (int)(n8 + n5 + 2), (int)n6).trim();
            while (!ellipsizeMiddleStrategy.isInLayout(string2 + ELLIPSIS + string3)) {
                int n9 = string2.lastIndexOf(32);
                int n10 = string3.indexOf(32);
                if (n9 == -1 || n10 == -1) break;
                string2 = string2.substring(0, n9);
                string3 = string3.substring(n10).trim();
            }
            EllipsizeMiddleStrategy ellipsizeMiddleStrategy = spannableStringBuilder2;
            spannableStringBuilder2 = new SpannableStringBuilder((CharSequence)string2);
            SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder;
            spannableStringBuilder = new SpannableStringBuilder((CharSequence)string3);
            if (charSequence instanceof Spanned) {
                charSequence = (Spanned)charSequence;
                TextUtils.copySpansFrom((Spanned)charSequence, (int)0, (int)string2.length(), null, (Spannable)ellipsizeMiddleStrategy, (int)0);
                TextUtils.copySpansFrom((Spanned)charSequence, (int)(n6 - string3.length()), (int)n6, null, (Spannable)spannableStringBuilder3, (int)0);
            }
            return TextUtils.concat((CharSequence[])new CharSequence[]{ellipsizeMiddleStrategy, ELLIPSIS, spannableStringBuilder3});
        }
    }

    private class EllipsizeStartStrategy
    extends EllipsizeStrategy {
        private EllipsizeStartStrategy() {
        }

        @Override
        protected CharSequence createEllipsizedText(CharSequence charSequence) {
            String string2 = new StringBuffer(charSequence).reverse().toString();
            Object object = TextUtils.substring((CharSequence)string2, (int)0, (int)(((EllipsizeStrategy)object).createWorkingLayout(string2).getLineEnd(((EllipsizeStartStrategy)object).BNEllipsizingTextView.this.mMaxLines - 1) - 1)).trim();
            object = ELLIPSIS + new StringBuffer((String)object).reverse().toString();
            return new SpannableStringBuilder((CharSequence)object);
        }
    }

    private class EllipsizeEndStrategy
    extends EllipsizeStrategy {
        private EllipsizeEndStrategy() {
        }

        @Override
        protected CharSequence createEllipsizedText(CharSequence charSequence) {
            SpannableStringBuilder spannableStringBuilder;
            int n5;
            int n6 = ((EllipsizeStrategy)((Object)string4)).createWorkingLayout(charSequence).getLineEnd(((EllipsizeEndStrategy)((Object)string4)).BNEllipsizingTextView.this.mMaxLines - 1);
            int n7 = charSequence.length();
            n6 = n7 - n6;
            if (n6 < ELLIPSIS.length()) {
                n6 = ELLIPSIS.length();
            }
            String string2 = TextUtils.substring((CharSequence)charSequence, (int)0, (int)(n7 - n6)).trim();
            String string3 = ((EllipsizeEndStrategy)((Object)string4)).stripEndPunctuation(string2);
            while (!((EllipsizeStrategy)((Object)string4)).isInLayout(string3 + ELLIPSIS) && (n5 = string2.lastIndexOf(32)) != -1) {
                string2 = string2.substring(0, n5).trim();
                string3 = ((EllipsizeEndStrategy)((Object)string4)).stripEndPunctuation(string2);
            }
            String string4 = string3 + ELLIPSIS;
            string2 = spannableStringBuilder;
            spannableStringBuilder = new SpannableStringBuilder((CharSequence)string4);
            if (charSequence instanceof Spanned) {
                TextUtils.copySpansFrom((Spanned)((Spanned)charSequence), (int)0, (int)string4.length(), null, (Spannable)string2, (int)0);
            }
            return string2;
        }

        public String stripEndPunctuation(CharSequence charSequence) {
            return BNEllipsizingTextView.this.mEndPunctPattern.matcher(charSequence).replaceFirst("");
        }
    }

    private class EllipsizeNoneStrategy
    extends EllipsizeStrategy {
        private EllipsizeNoneStrategy() {
        }

        @Override
        protected CharSequence createEllipsizedText(CharSequence charSequence) {
            return charSequence;
        }
    }

    private abstract class EllipsizeStrategy {
        private EllipsizeStrategy() {
        }

        public CharSequence processText(CharSequence charSequence) {
            if (!this.isInLayout(charSequence)) {
                charSequence = this.createEllipsizedText(charSequence);
            }
            return charSequence;
        }

        public boolean isInLayout(CharSequence charSequence) {
            return this.createWorkingLayout(charSequence).getLineCount() <= this.getLinesCount();
        }

        protected Layout createWorkingLayout(CharSequence charSequence) {
            CharSequence charSequence2 = charSequence;
            EllipsizeStrategy ellipsizeStrategy = this;
            charSequence = ellipsizeStrategy.BNEllipsizingTextView.this.getPaint();
            int n5 = ellipsizeStrategy.BNEllipsizingTextView.this.getMeasuredWidth() - BNEllipsizingTextView.this.getPaddingLeft() - BNEllipsizingTextView.this.getPaddingRight();
            Layout.Alignment alignment = Layout.Alignment.ALIGN_NORMAL;
            float f6 = ellipsizeStrategy.BNEllipsizingTextView.this.mLineSpacingMult;
            float f7 = ellipsizeStrategy.BNEllipsizingTextView.this.mLineAddVertPad;
            return new StaticLayout(charSequence2, (TextPaint)charSequence, n5, alignment, f6, f7, false);
        }

        protected int getLinesCount() {
            if (BNEllipsizingTextView.this.ellipsizingLastFullyVisibleLine()) {
                int n5 = this.getFullyVisibleLinesCount();
                if (n5 == -1) {
                    n5 = 1;
                }
                return n5;
            }
            return BNEllipsizingTextView.this.mMaxLines;
        }

        protected int getFullyVisibleLinesCount() {
            EllipsizeStrategy ellipsizeStrategy = this;
            Layout layout2 = ellipsizeStrategy.createWorkingLayout("");
            return (ellipsizeStrategy.BNEllipsizingTextView.this.getHeight() - BNEllipsizingTextView.this.getCompoundPaddingTop() - BNEllipsizingTextView.this.getCompoundPaddingBottom()) / layout2.getLineBottom(0);
        }

        protected abstract CharSequence createEllipsizedText(CharSequence var1);
    }

    public static interface EllipsizeListener {
        public void ellipsizeStateChanged(boolean var1);
    }
}

