/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.navisdk.ui.widget;

import android.content.Context;
import android.database.Observable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.baidu.navisdk.util.common.i;
import java.util.ArrayList;

public class BNFixedItemLayout<VH extends ViewHolder>
extends FrameLayout {
    private static final String TAG = "BNFixedItemLayout";
    private LayoutManager mLayoutManager;
    private Adapter<VH> mAdapter;
    private OnItemClickListener mOnItemClickListener;
    private ArrayList<VH> mItemViewList;
    private boolean isNeedUpdate = false;
    private final AdapterDataObserver observer;
    private int mItemWidth;
    private int mItemHeight;
    private int mRemainderPadding;

    public BNFixedItemLayout(@NonNull Context context) {
        this(context, null);
    }

    public BNFixedItemLayout(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public BNFixedItemLayout(@NonNull Context object, @Nullable AttributeSet attributeSet, int n5) {
        super(object, attributeSet, n5);
        AdapterDataObserver adapterDataObserver;
        object = adapterDataObserver;
        adapterDataObserver = new AdapterDataObserver(){

            @Override
            public void updateAllView() {
                BNFixedItemLayout.this.updateAllView();
            }

            @Override
            public void updateView(int n5) {
                BNFixedItemLayout.this.updateView(n5);
            }

            @Override
            public void updateLayout() {
                BNFixedItemLayout.this.onOrientationChange();
            }
        };
        this.observer = object;
        this.mRemainderPadding = 0;
    }

    @RequiresApi(api=21)
    public BNFixedItemLayout(@NonNull Context object, @Nullable AttributeSet attributeSet, int n5, int n6) {
        super(object, attributeSet, n5, n6);
        AdapterDataObserver adapterDataObserver;
        object = adapterDataObserver;
        adapterDataObserver = new /* invalid duplicate definition of identical inner class */;
        this.observer = object;
        this.mRemainderPadding = 0;
    }

    private void updateWidthHeight() {
        BNFixedItemLayout bNFixedItemLayout = this;
        int n5 = bNFixedItemLayout.mLayoutManager.getColTotal();
        if (bNFixedItemLayout.mItemWidth == -1) {
            int n6;
            int n7 = this.getWidth() - this.getPaddingEnd() - this.getPaddingStart() - (n5 - 1) * this.mLayoutManager.getColMargin();
            this.mItemWidth = n6 = n7 / n5;
            this.mRemainderPadding = n7 - n6 * n5;
            if (this.mRemainderPadding > 0 && i.b.d()) {
                i.b.e(TAG, "mRemainderPadding:" + this.mRemainderPadding);
            }
        }
        if (this.mItemHeight == -1) {
            this.mItemHeight = this.mItemWidth;
        }
        if (i.c.d()) {
            i.c.e(TAG, "setLayoutManager: " + this.mItemWidth + ", " + this.mItemHeight);
        }
        if (this.isNeedUpdate) {
            this.updateAllView();
        }
    }

    private void updateAllView() {
        if (this.mItemHeight > 0 && this.mItemWidth > 0) {
            this.isNeedUpdate = false;
            Adapter<VH> adapter2 = this.mAdapter;
            if (adapter2 != null && adapter2.getItemCount() > 0) {
                int n5;
                if (this.mItemViewList == null) {
                    this.mItemViewList = new ArrayList(this.mAdapter.getItemCount());
                }
                int n6 = this.mAdapter.getItemCount();
                for (n5 = 0; n5 < n6; ++n5) {
                    ViewHolder viewHolder;
                    if (n5 < this.mItemViewList.size()) {
                        viewHolder = (ViewHolder)this.mItemViewList.get(n5);
                    } else {
                        BNFixedItemLayout bNFixedItemLayout = this;
                        viewHolder = bNFixedItemLayout.mAdapter.onCreateViewHolder((ViewGroup)this);
                        bNFixedItemLayout.addView(viewHolder.itemView);
                        bNFixedItemLayout.mItemViewList.add(viewHolder);
                    }
                    int n7 = n5 / this.mLayoutManager.getColTotal();
                    int n8 = n5 % this.mLayoutManager.getColTotal();
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)viewHolder.itemView.getLayoutParams();
                    layoutParams.width = this.mItemWidth;
                    layoutParams.height = this.mItemHeight;
                    ((FrameLayout.LayoutParams)viewHolder.itemView.getLayoutParams()).topMargin = (this.mLayoutManager.getRowMargin() + this.mItemHeight) * n7;
                    if (n8 == this.mLayoutManager.getColTotal() - 1) {
                        layoutParams.setMarginStart((this.mLayoutManager.getColMargin() + this.mItemWidth) * n8 + this.mRemainderPadding);
                    } else {
                        layoutParams.setMarginStart((this.mLayoutManager.getColMargin() + this.mItemWidth) * n8);
                    }
                    ViewHolder viewHolder2 = viewHolder;
                    viewHolder.itemView.requestLayout();
                    this.mAdapter.onBindViewHolder(viewHolder, n5);
                    viewHolder2.itemView.setTag((Object)n5);
                    viewHolder2.itemView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (BNFixedItemLayout.this.mOnItemClickListener != null) {
                                BNFixedItemLayout.this.mOnItemClickListener.onClickItem((Integer)view.getTag(), view);
                            }
                        }
                    });
                }
                while (n5 < this.mItemViewList.size()) {
                    ViewHolder viewHolder = (ViewHolder)this.mItemViewList.remove(n5);
                    if (viewHolder != null && (viewHolder = viewHolder.itemView) != null) {
                        this.removeView((View)viewHolder);
                    }
                    ++n5;
                }
                return;
            }
            if (i.b.d()) {
                i.b.e(TAG, "updateAllView mAdapter == null || 0");
            }
            return;
        }
        this.isNeedUpdate = true;
    }

    private void onOrientationChange() {
        LayoutManager layoutManager;
        if (i.c.d()) {
            i.c.e(TAG, "onOrientationChange: ");
        }
        if ((layoutManager = this.mLayoutManager) == null) {
            if (i.c.c()) {
                i.c.c(TAG, "onOrientationChange mLayoutManager == null ");
            }
            return;
        }
        BNFixedItemLayout bNFixedItemLayout = this;
        bNFixedItemLayout.mItemHeight = layoutManager.getItemHeight();
        bNFixedItemLayout.mItemWidth = bNFixedItemLayout.mLayoutManager.getItemWidth();
        int n5 = bNFixedItemLayout.getWidth();
        if (bNFixedItemLayout.mItemWidth <= 0 && n5 <= 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (i.c.d()) {
                        i.c.e(BNFixedItemLayout.TAG, "onOrientationChange onGlobalLayout: ");
                    }
                    4 v02 = this;
                    v02.BNFixedItemLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    v02.BNFixedItemLayout.this.updateWidthHeight();
                    v02.BNFixedItemLayout.this.updateLayout();
                }
            });
        } else {
            BNFixedItemLayout bNFixedItemLayout2 = this;
            bNFixedItemLayout2.updateWidthHeight();
            bNFixedItemLayout2.updateLayout();
        }
    }

    private void updateLayout() {
        for (int i5 = 0; i5 < this.mItemViewList.size(); ++i5) {
            BNFixedItemLayout bNFixedItemLayout = this;
            ViewHolder viewHolder = (ViewHolder)bNFixedItemLayout.mItemViewList.get(i5);
            int n5 = i5 / bNFixedItemLayout.mLayoutManager.getColTotal();
            int n6 = i5 % this.mLayoutManager.getColTotal();
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)viewHolder.itemView.getLayoutParams();
            layoutParams.width = this.mItemWidth;
            layoutParams.height = this.mItemHeight;
            ((FrameLayout.LayoutParams)viewHolder.itemView.getLayoutParams()).topMargin = (this.mLayoutManager.getRowMargin() + this.mItemHeight) * n5;
            if (n6 == this.mLayoutManager.getColTotal() - 1) {
                layoutParams.setMarginStart((this.mLayoutManager.getColMargin() + this.mItemWidth) * n6 + this.mRemainderPadding);
            } else {
                layoutParams.setMarginStart((this.mLayoutManager.getColMargin() + this.mItemWidth) * n6);
            }
            viewHolder.itemView.requestLayout();
        }
    }

    public void setAdapter(Adapter<VH> adapter2) {
        this.mAdapter = adapter2;
        adapter2.registerAdapterDataObserver(this.observer);
    }

    public void setLayoutManager(LayoutManager layoutManager) {
        BNFixedItemLayout bNFixedItemLayout = this;
        this.mLayoutManager = layoutManager;
        bNFixedItemLayout.mItemHeight = layoutManager.getItemHeight();
        bNFixedItemLayout.mItemWidth = bNFixedItemLayout.mLayoutManager.getItemWidth();
        int n5 = bNFixedItemLayout.getWidth();
        if (bNFixedItemLayout.mItemWidth <= 0 && n5 <= 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (i.c.d()) {
                        i.c.e(BNFixedItemLayout.TAG, "setLayoutManager onGlobalLayout: ");
                    }
                    2 v02 = this;
                    v02.BNFixedItemLayout.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    v02.BNFixedItemLayout.this.updateWidthHeight();
                }
            });
        } else {
            this.updateWidthHeight();
        }
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    @Nullable
    public VH getViewHolder(int n5) {
        ArrayList<VH> arrayList;
        if (i.b.d()) {
            i.b.e(TAG, "getViewHolder: " + n5);
        }
        if ((arrayList = this.mItemViewList) != null && arrayList.size() != 0 && n5 < this.mItemViewList.size()) {
            return (VH)((ViewHolder)this.mItemViewList.get(n5));
        }
        return null;
    }

    public void updateView(int n5) {
        Adapter<VH> adapter2;
        if (i.b.d()) {
            i.b.e(TAG, "updateView: " + n5);
        }
        if ((adapter2 = object.mItemViewList) != null && ((ArrayList)((Object)adapter2)).size() != 0 && n5 < object.mItemViewList.size()) {
            BNFixedItemLayout bNFixedItemLayout = object;
            Object object = (ViewHolder)bNFixedItemLayout.mItemViewList.get(n5);
            adapter2 = bNFixedItemLayout.mAdapter;
            if (adapter2 != null) {
                adapter2.onBindViewHolder(object, n5);
            }
            return;
        }
        if (i.b.d()) {
            i.b.e(TAG, "updateView mItemViewList == null ");
        }
    }

    public static interface OnItemClickListener {
        public void onClickItem(int var1, View var2);
    }

    public static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        public void updateAllView() {
            for (int i5 = this.mObservers.size() - 1; i5 >= 0; --i5) {
                ((AdapterDataObserver)this.mObservers.get(i5)).updateAllView();
            }
        }

        public void updateView(int n5) {
            for (int i5 = this.mObservers.size() - 1; i5 >= 0; --i5) {
                ((AdapterDataObserver)this.mObservers.get(i5)).updateView(n5);
            }
        }

        public void updateLayout() {
            for (int i5 = this.mObservers.size() - 1; i5 >= 0; --i5) {
                ((AdapterDataObserver)this.mObservers.get(i5)).updateLayout();
            }
        }
    }

    public static interface AdapterDataObserver {
        public void updateAllView();

        public void updateView(int var1);

        public void updateLayout();
    }

    public static abstract class ViewHolder {
        public final View itemView;

        public ViewHolder(View view) {
            this.itemView = view;
        }
    }

    public static abstract class LayoutManager {
        public abstract int getColTotal();

        public abstract int getColMargin();

        public abstract int getRowMargin();

        public abstract int getItemWidth();

        public abstract int getItemHeight();
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        private AdapterDataObservable observable;

        public Adapter() {
            AdapterDataObservable adapterDataObservable;
            Object object = adapterDataObservable;
            adapterDataObservable = new AdapterDataObservable();
            v1.observable = object;
        }

        @NonNull
        public abstract VH onCreateViewHolder(@NonNull ViewGroup var1);

        public abstract void onBindViewHolder(@NonNull VH var1, int var2);

        public abstract int getItemCount();

        public void updateAllView() {
            this.observable.updateAllView();
        }

        public void updateView(int n5) {
            this.observable.updateView(n5);
        }

        public void updateLayout() {
            this.observable.updateLayout();
        }

        void registerAdapterDataObserver(@NonNull AdapterDataObserver adapterDataObserver) {
            this.observable.registerObserver(adapterDataObserver);
        }
    }
}

